/*
   File:     FillPath.c
   Purpose:  Trace back through the best cost pointers in the graph to
             construct the optimal path.
   Author:   James Painter, David Meyers
   Date:     Last Modified: 8 November 1989
*/

#include <TypeDefinitions.h>
#include "TorGraph.h"

void FillPath( G, StartRow, StartCol, P)
 GraphType *G;
 PathType *P;
 int StartRow, StartCol;
 {
  int ThisR, ThisC, R, C, R1, C1, p;

  P->Rows = G->Rows;
  P->Columns = G->Columns;
  P->StartR = StartRow;
  P->StartC = StartCol;
  if (P->StartC > P->Columns)
   {
    P->StartC -= P->Columns;
    P->StartR += P->Rows;
    P->StartR %= (2*P->Rows);
   }
  ThisR = (P->StartR + P->Rows) % (2*G->Rows);
  ThisC = (P->StartC + P->Columns) % (2*G->Columns);
  R = G->Rows; C = G->Columns;
  for (p = R+C; p > 0; p--)
   {
    if (G->PSN[R][C].WhichWay == UP)
     {
      if (ThisR == 0) ThisR = (2*G->Rows);
      ThisR--; R--;
      P->LeavesRowInCol[ThisR] = ThisC;
      R1 = (ThisR + P->Rows) % (2*G->Rows);
      C1 = (ThisC + P->Columns) % (2*G->Columns);
      P->LeavesRowInCol[R1] = C1;
     }
    else
     {
      if (ThisC == 0) ThisC = (2*G->Columns);
      ThisC--; C--;
      P->LeavesColInRow[ThisC] = ThisR;  
      R1 = (ThisR + P->Rows) % (2*G->Rows);
      C1 = (ThisC + P->Columns) % (2*G->Columns);
      P->LeavesColInRow[C1] = R1;
     }
   }
 }
