/*
  File: TestEOps.c
  Author: David Meyers
  Last Modified: 21 August 1990
  Purpose: Test functions and useful utilities for the Euler Operators module
 */

#include<stdio.h>
#include<XOut.h>
#include<WingEdge.h>
#include<EulerOps.h>
#include<WingEdgeUtil.h>
#define FALSE (0)
#define TRUE (1)

extern void sleep();
extern void exit();

static void usage(RoutineName)
 char *RoutineName;
{
 (void)fprintf(stderr,
         "Usage is: \n\t%s [options] SiteFileName\n \
       Available options are:\n \
             [-X] enable X11 display \n \
             [-D] prints x, y values to stderr \n \
             [-S SleepTime] set sleeptime \n \
             [-h] print this message\n", RoutineName);
}

/**************************************************************************/

static void ParseArgs(argc, argv, ArgsParsed, SiteFileName, RoutineName,
		      X11Out, DumpValues, SleepTime)
 int argc, ArgsParsed;
 char *argv[];
 char **SiteFileName;
 char *RoutineName;
 int *X11Out, *DumpValues, *SleepTime;
 {
  char *Flag;

  for(; ArgsParsed < argc; )
   {
    Flag = argv[ArgsParsed++];
    if ('-' == Flag[0])
     {
      switch (Flag[1])
       {
        case 'X':
         *X11Out = TRUE;
        break;

        case 'D':
         *DumpValues = TRUE;
        break;

        case 'S':
         *SleepTime = atoi(argv[ArgsParsed++]);
        break;

        case 'h':  { usage(RoutineName); exit(-1); }
        break;

        default:  { usage(RoutineName); exit(-1); }
        break;
       }
     }
    else if(ArgsParsed = argc)
     *SiteFileName = Flag;
    else { usage(RoutineName); exit(-1); }
   }
 }

/**************************************************************************/

main(argc, argv)
 int argc;
 char *argv[];
{
 char *RoutineName;
 int X11Out = FALSE;
 int DumpValues = FALSE;
 int SleepTime = 1;
 char *SiteFileName;
 FILE *SiteFile;
 int ArgsParsed = 0;
 double Xmin, Xmax, Ymin, Ymax, Xrange, Yrange;
 WEFaceNode *ThePolygon;
 WingEdgeNode *CurrentEdge;

 
 RoutineName = argv[ArgsParsed++];
 ParseArgs(argc, argv, ArgsParsed, &SiteFileName, RoutineName, &X11Out,
	   &DumpValues, &SleepTime);
 SiteFile = fopen(SiteFileName, "r");
 if(NULL == SiteFile)
  {
   (void)fprintf(stderr,"Unable to open site file\n");
   exit(1);
  }
 ThePolygon = ReadPolygon(SiteFile);
 CurrentEdge = ThePolygon->Edges;
 Xmin = CurrentEdge->Org->x; Xmax = CurrentEdge->Org->x;
 Ymin= CurrentEdge->Org->y; Ymax = CurrentEdge->Org->y;

 do
  {
   if (CurrentEdge->Dest->x < Xmin)
    Xmin = CurrentEdge->Dest->x;
   if (CurrentEdge->Dest->x > Xmax)
    Xmax = CurrentEdge->Dest->x;
   if (CurrentEdge->Dest->y < Ymin)
    Ymin = CurrentEdge->Dest->y;
   if (CurrentEdge->Dest->y > Ymax)
    Ymax = CurrentEdge->Dest->y;
   if(DumpValues)
    (void)fprintf(stderr, "x=%lf, y=%lf\n", 
		  CurrentEdge->Dest->x, CurrentEdge->Dest->y);
   CurrentEdge = CurrentEdge->DCW;
  } while(CurrentEdge != ThePolygon->Edges);

 if(X11Out)
  {
   Xrange = Xmax - Xmin; Yrange = Ymax - Ymin;
   Xmin = Xmin - 0.05 * Xrange;
   Xmax = Xmax + 0.05 * Xrange;
   Ymin = Ymin - 0.05 * Yrange;
   Ymax = Ymax + 0.05 * Yrange;
   if(DumpValues) (void)fprintf(stderr,
                                "Xmin=%lf, Xmax=%lf, Ymin=%lf, Ymax=%lf\n",
                                Xmin, Xmax, Ymin, Ymax);
   SetupX11(Xmin, Ymin, Xmax, Ymax);
  }

 if(X11Out)
  {
   DrawShell(ThePolygon);
   (void)fprintf(stderr, "Hit return in this window to continue: \n");
   (void)fscanf(stdin,"%*c");
  }
 return(0);
}
