/*
	cachecon.c
	04 feb 90
	Paul V. O'Neill -- Coastal Imaging Lab, Oregon State University

	For Wren V 94181-702
	Prints current or saved cache control parameters.
	Optionally sets or clears cache control bit AND SAVES IT.

from:
 * Generic SCSI driver example.
 *
 * History
 * -------
 * 10-Apr-89	Doug Mitchell
 *	Write after read to avoid trashing system disk.
 * 20-Mar-89	Doug Mitchell at NeXT
 *	Created.
 *
 *	Procedure:
 *		open sg0;
 *		set (target,lun) to (1,0);
 *		execute Request Sense command;
 *		Read 4 blocks;
 *		Write 4 blocks;
 */
 
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <nextdev/scsireg.h>


#define SENSE_SIZE	0x40			/* sense buffer size */

char sbuf[SENSE_SIZE]; 				/* sense buffer */

int fd;						/* file descriptor */
int target=0;  /* BE CAREFUL -- THIS IS YOUR SYSTEM THAT YOUR'RE MUCKING WITH */
int lun=0;

char *dev_name="/dev/sg0";

main(argc,argv)
int	argc;
char	*argv[];
{

	struct scsi_adr sa;
	int rtn;
	int i;
	int	pcf;				/* parameter control flag */

	pcf = 0;			/* default will be current params */

	/* open /dev/sg0 */
	
	if ((fd = open (dev_name, O_RDWR)) < 0) {
		fprintf(stderr,"\nCould not open %s - fd = %XH\n",dev_name,fd);
		fprintf(stderr,"errno = %d\n",errno);
		perror("open");
		exit(1);
	}
	
	/* set (target,lun) */
	
	sa.sa_target = target;
	sa.sa_lun = lun;
	if (ioctl(fd,SGIOCSTL,&sa) < 0) {
		fprintf(stderr,"Error setting target %d lun %d\n",target,lun);
		fprintf(stderr,"errno = %d\n",errno);
		perror("ioctl(SGIOCSTL)");
		exit(1);
	}

	if(gs_request_sense())			/* clear unit attention */
		exit(1);

	for(i=0;i<SENSE_SIZE;i++)		/* clear parameter list */
		sbuf[i] = 0;

	if( argc != 2 )
		usage();
	switch(*argv[1]) {		/* may or may not do a mode_select */
		case 'c':
			pcf = 0;
			break;
		case 's':
			pcf = 1;
			break;
		case '0':
                        if(gs_mode_select(0))
                                exit(1);
                        fprintf(stderr,"mode select successful.\n");
			break;
		case '1':
			if(gs_mode_select(1))
				exit(1);
			fprintf(stderr,"mode select successful.\n");
			break;
		default:
			usage();
			break;
	}

	for(i=0;i<SENSE_SIZE;i++)		/* clear parameter list */
		sbuf[i] = 0;
	if(gs_mode_sense(pcf))			/* alwasy do a mode_sense */
		exit(1);
	fprintf(stderr,"Sense_Mode ok, cache control params to stdout.\n");
	fprintf(stderr,"Number 14 is the one your are interested in.\n");
	fprintf(stderr,"01 -> cache off		11 -> cache on\n");
	for (i=0; i<30; i++)
		printf("%2d = %02.2x\n", i, (u_char)sbuf[i]);
	
	/* close /dev/sg0 */
	
	if ((rtn = close(fd)) < 0) {
		fprintf(stderr,"\nCould not close %s - fd = %XH\n",dev_name,fd);
		fprintf(stderr,"\nerrno = %d\n",errno);
		perror("close");
		exit(1);
	}
	else
		exit(0);

} /* main() */

usage() {
    fprintf(stderr, "usage: cachecon [ c|s|0|1 ]\n");
    exit(-1);
}


/*	
 *	standard I/O routines
 */
 
gs_request_sense() {

	struct scsi_req sr;	
	struct cdb_6 *cdbp = &sr.sr_cdb.cdb_c6;
	
	cdb_clr(cdbp);
	cdbp->c6_opcode = C6OP_REQSENSE;
	cdbp->c6_lun    = lun;
	cdbp->c6_len	= SENSE_SIZE;
	sr.sr_dma_dir	= SR_DMA_RD;
	sr.sr_addr	= sbuf;
	sr.sr_dma_max	= SENSE_SIZE;
	sr.sr_ioto	= 10;
	return(do_ioc(&sr));


} /* gs_request_sense() */

gs_mode_sense(pcf)
int	pcf;				/* page control field flag */

{
    struct scsi_req sr;	
    struct cdb_6 *cdbp = &sr.sr_cdb.cdb_c6;

	cdb_clr(cdbp);
	cdbp->c6_opcode = C6OP_MODESENSE;
	cdbp->c6_lun    = lun;
	cdbp->c6_lba	= 0x3800;	/* current Cache Control Params */
	if( pcf )
		cdbp->c6_lba = 0xf800;	/* saved Cache Control Params */
	cdbp->c6_len	= SENSE_SIZE;
	sr.sr_dma_dir	= SR_DMA_RD;
	sr.sr_addr	= sbuf;
	sr.sr_dma_max	= SENSE_SIZE;
	sr.sr_ioto	= 10;
	return(do_ioc(&sr));
} /* gs_mode_sense() */

gs_mode_select(cc)
int	cc;				/* cache control flag */

{
    struct scsi_req sr;	
    struct cdb_6 *cdbp = &sr.sr_cdb.cdb_c6;

	cdb_clr(cdbp);			/* clr the Control Data Block */
	cdbp->c6_opcode = C6OP_MODESELECT;
	cdbp->c6_lun    = lun;
	cdbp->c6_lba	= 0x10000;	/* sets Save Mode Parameters bit */
	cdbp->c6_len	= 20;		/* 4 byte header, 2byte page header, 
						14 byte page params */
	sr.sr_dma_dir	= SR_DMA_WR;
	sr.sr_dma_max	= SENSE_SIZE;
	sr.sr_addr	= sbuf;
	sr.sr_ioto	= 10;
	
	sbuf[4] = 0x38;			/* Cache Control Parameters */
	sbuf[5] = 14;			/* page length */
	sbuf[6] = 0x01;
	if ( cc )
		sbuf[6] = 0x11;		/* this is the BIGGY */
	sbuf[7] = 0xff;
	
	return(do_ioc(&sr));
} /* gs_mode_select() */

cdb_clr(cdbp)
union cdb *cdbp;
{
	int i;
	char *p;
	
	p = (char *)cdbp;
	for(i=0; i<sizeof(union cdb); i++)
		*p++ = 0;
}

do_ioc(sr)
struct scsi_req *sr;
{
	
	if (ioctl(fd,SGIOCREQ,sr) < 0) {
		fprintf(stderr,"..Error executing ioctl\n");
		fprintf(stderr,"errno = %d\n",errno);
		perror("ioctl(SGIOCREQ)");
		return(1);
	}
	if(sr->sr_io_status) {
		fprintf(stderr,"sr_io_status = 0x%X\n",sr->sr_io_status);
		if(sr->sr_io_status == SR_IOST_CHKSV) {
			fprintf(stderr,"   sense key = %02XH   sense code = %02XH\n",
				sr->sr_esense.er_sensekey,
				sr->sr_esense.er_addsensecode);
		}
		fprintf(stderr,"SCSI status = %02XH\n",sr->sr_scsi_status);
		return(1);
	}
	return(0);
} /* do_ioc() */
