#include <midi.h>
#include <mpuvar.h>

#define d define
#d u_char	unsigned char
#d u_short	unsigned short

dx7Button(midi, chan, button, down)
	int midi;	/* file descriptor of midi device */
	char chan;	/* midi channel (0 -> ch 1) */
	char button;	/* which button # to push */
	char down;	/* 1=>down  0 => up */
/*
 * Send a button push to the dx7.
 * Just like pushing the 'button' up or down.
 * Buttons are:
 * .Cs
 * 0-31   voice buttons
 * 32-39  group of 8 buttons (store, etc), L->R, top->bottom
 * 40     no
 * 41     yes
 * .Ce
 * c.f. macros like 'DX7store' et al.
 * `Note:` this is undocumented in dx7 literature;
 * the information came from Brian Schmidt at Northwestern
 * (ucbvax!ihnp4!numusic!brian).
 */
{
	static u_char s[] =
		{MPU_SEND_SYSTEM_MESSAGE,
		 SX_CMD,
		 ID_DX7,
		 0, 0x8, 0, 0,
		 SX_EOB};
	u_char *p = s+3;
	p[0] = DX7_SXSS_PC << 4 | (chan & M_CHAN_MASK);
	p[2] = button;
	p[3] = down? 1 : 0;
	MpuSetTrack(midi,MPU_TR_COM);
	write(midi,s,sizeof s);
	MpuSetTrack(midi,0);
}

dx7Push(midi,chan,button)
/*
 * Push dx7 'button' `down`, then `up`.
 */
{
	dx7Button(midi,chan,button,1);
	dx7Button(midi,chan,button,0);
}

dx7ShiftPush(midi,chan,but1,but2)
/*
** Like holding dx7 'but1', pressing 'but2', and releasing 'but1'; viz.,
** .Cs
** dx7Button(midi,chan,but1,1);
** dx7Push(midi,chan,but2);
** dx7Button(midi,chan,but1,0);
** .Ce
*/
{
        dx7Button(midi,chan,but1,1);
        dx7Push(midi,chan,but2);
        dx7Button(midi,chan,but1,0);
}
