/*
**	RPTS -- Repeat and Skip preprocessor
**	psl 7/88
*/
#include	<midi.h>
#include	<stdio.h>

main(argc, argv)
char	*argv[];
{
	char *infile = (char *) 0, *cp;
	int frpt, lrpt, i, cflg;
	FILE *ifp;

	frpt = lrpt = 1;		/* default repeat */
	cflg = 0;			/* ignore comments (default) */
	infile = (char *) 0;
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'c':		/* don't strip comments */
		    cflg++;
		    break;
		case 'r':		/* specify which repeat(s) */
		    frpt = lrpt = atoi(&argv[i][2]);
		    for (cp = &argv[i][2]; *cp && *cp != '-'; cp++);
		    if (*cp++ == '-')
			lrpt = atoi(cp);
		    break;
		default:
		    goto syntax;
		}
	    } else if (infile == (char *) 0)
		infile = argv[i];
	    else
		goto syntax;
	}
	if (infile) {
	    if (!(ifp = fopen(infile, "r"))) {
		perror(infile);
		goto syntax;
	    }
	} else if (frpt != lrpt) {
syntax:
	    fprintf(stderr, "Usage: %s [-r#] [file or stdin]\n", argv[0]);
	    fprintf(stderr, "   or: %s -r#-# file\n", argv[0]);
	    exit(2);
	} else
	    ifp = stdin;
	for (i = frpt; i <= lrpt; i++) {
	    if (i > frpt)
		fseek(ifp, 0L, 0);
	    proc(ifp, i, cflg);
	}
	exit(0);
}

proc(ifp, rpt, cflg)
FILE	*ifp;
{
	char buf[512], a[16][128];
	int skip, wrongr, i, nf;

	skip = wrongr = 0;
	while (fgets(buf, sizeof buf, ifp) != NULL) {
	    nf = sscanf(buf, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	     a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7],
	     a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15]);
	    if (nf <= 0 || strcmp(a[0], "#") == 0) {
		if (cflg)
		    fputs(buf, stdout);
		continue;
	    }
	    if (a[0][0] == '#') {
		if (skip && strcmp(a[0], "#ENDSKIP") != 0)
		    continue;
		if (strcmp(a[0], "#ALLRPTS") == 0) {
		    wrongr = 0;
		    continue;
		}
		if (strcmp(a[0], "#NOTRPT") == 0) {
		    wrongr = 0;
		    for (i = 1; i < nf; i++)
			if (atoi(a[i]) == rpt)
			    wrongr = 1;
		    continue;
		}
		if (strcmp(a[0], "#ONLYRPT") == 0) {
		    wrongr = 1;
		    for (i = 1; i < nf; i++)
			if (atoi(a[i]) == rpt)
			    wrongr = 0;
		    continue;
		}
		if (wrongr)
		    continue;
		if (strcmp(a[0], "#ENDSKIP") == 0) {
		    skip = 0;
		    continue;
		}
		if (strcmp(a[0], "#RPT") == 0) {
		    rpt = atoi(a[1]);
		    continue;
		}
		if (strcmp(a[0], "#SKIP") == 0) {
		    skip = 1;
		    continue;
		}
	    }
	    if (skip || wrongr)
		continue;
	    fputs(buf, stdout);
	}
}
