# awk script to do arbitrary transposition of riffs.c
BEGIN	{
	n["Cb"] = -1; n["C"] =  0; n["C#"] =  1
	n["Db"] =  1; n["D"] =  2; n["D#"] =  3
	n["Eb"] =  3; n["E"] =  4; n["E#"] =  5
	n["Fb"] =  4; n["F"] =  5; n["F#"] =  6
	n["Gb"] =  6; n["G"] =  7; n["G#"] =  8
	n["Ab"] =  8; n["A"] =  9; n["A#"] = 10
	n["Bb"] = 10; n["B"] = 11; n["B#"] = 12
	c[0] = "C"
	c[1] = "Db"
	c[2] = "D"
	c[3] = "Eb"
	c[4] = "E"
	c[5] = "F"
	c[6] = "Gb"
	c[7] = "G"
	c[8] = "Ab"
	c[9] = "A"
	c[10] = "Bb"
	c[11] = "B"
	state = 0
}
/^TRANSPOSE/	{
	transpose = $2
	next
}
/^char	riffs.*=/	{
	print
	state = 1
	next
}
state != 1	{
	print
	next
}
/^};/	{
	print
	state = 2
	next
}
	{
	for (i = 1; i <= NF; i++) {
	    l = length($i)
	    if (l >= 3 && substr($i, l, 1) == ",") {
		pc = substr($i, 1, l - 2)
		o = substr($i, l - 1, 1)
		pcn = n[pc] + transpose
		while (pcn < 0) {
		    o = o - 1
		    pcn = pcn + 12
		}
		while (pcn >= 12) {
		    o = o + 1
		    pcn = pcn - 12
		}
		$i = c[pcn] o ","
	    }
	    while (length($i) < 4)
		$i = $i " "
	}
	$1 = "	" $1
	print
}
