/*
**	PHARM -- Generate "parallel" harmonization
**	psl 8/88
*/
#include	<stdio.h>
#include	<midi.h>

int	Scale[12]	= {		/* scale to use */
	0, 2, 4, 5, 7, 9, 11,
};
int	Nscale	= 7;			/* length of scale */
int	Part[7]		= {		/* part spacing */
	2,				/* default is 1 part, up 2 */
};
int	Npart	= 0;			/* number of parts */

main(argc, argv)
char	*argv[];
{
	register int i, orig;
	char *cp;
	long now;
	MCMD *mp;

	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'p':			/* set part intervals */
		    Npart = 0;
		    for (cp = &argv[i][2]; *cp; ) {
			Part[Npart++] = atoi(cp);
			while (*cp > ' ' && *cp != ',')
			    cp++;
			if (*cp++ != ',')
			    break;
		    }
		    break;
		case 's':			/* set scale */
		    Nscale = 0;
		    for (cp = &argv[i][2]; *cp; ) {
			Scale[Nscale++] = atoi(cp);
			while (*cp > ' ' && *cp != ',')
			    cp++;
			if (*cp++ != ',')
			    break;
		    }
		    break;
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s [-p#,...] [-s#,#,#,...]\n", argv[0]);
		exit(2);
	    }
	}
	if (Npart == 0)
	    Part[Npart++] = 2;			/* default part spacing */
	now = 0;
	putmcmd(0, 0);
	while (mp = getmcmd(stdin, now)) {
	    now = mp->when;
	    putmcmd(stdout, mp);
	    if ((mp->cmd[0] & M_CMD_MASK)  == CH_KEY_ON
	     || (mp->cmd[0] & M_CMD_MASK)  == CH_KEY_OFF) {
		orig = key2scale(mp->cmd[1]);
		if (orig < 0)
		    continue;
		for (i = 0; i < Npart; i++) {
		    mp->cmd[1] = scale2key(orig + Part[i]);
		    putmcmd(stdout, mp);
		}
	    }
	}
	exit(0);
}

key2scale(key)
{
	register int o, n, i;

	o = (key + 12) / 12;
	n = (key + 12) % 12;
	for (i = 0; i < Nscale; i++)
	    if (n == Scale[i])
		return(Nscale * o + i);
	return(-1);
}

scale2key(scale)
{
	register int o, n;

	o = scale / Nscale;
	n = scale % Nscale;
	return(12 * o + Scale[n]);
}
