/*
**	NUMEV -- Count number of key-on/off events in a MIDI stream
**	psl 3/87
*/
#include	<stdio.h>
#include	<midi.h>

int	Qflg	= 0;			/* quiet */
int	Vflg	= 0;			/* verbose */

main(argc, argv)
char	*argv[];
{
	register int i, exstat;
	FILE *bfp;

	exstat = 0;
	bfp = NULL;
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'q':			/* quiet */
		    Qflg++;
		    break;
		case 'v':			/* verbose */
		    Vflg++;
		    break;
		default:
syntax:
		    fprintf(stderr,
		     "Usage: %s [-quiet] [-verbose] [files or stdin]\n",
		     argv[0]);
		    exit(2);
		}
	    } else {
		if ((bfp = fopen(argv[i], "r")) == NULL) {
		    perror(argv[i]);
		    bfp = (FILE *) 1;
		    continue;
		}
		exstat += getdata(argv[i], bfp);
		fclose(bfp);
	    }
	}
	if (bfp == NULL)
	    exstat += getdata(0, stdin);
	exit(exstat);
}

getdata(name, ifp)
FILE	*ifp;
{
	register int type, on, off;
	MCMD *mp;

	on = off = 0;
	while (mp = getmcmd(ifp, 0L)) {
	    type = mp->cmd[0] & M_CMD_MASK;
	    if (type != CH_KEY_ON && type != CH_KEY_OFF)
		continue;
	    if (mp->cmd[2] == 0)
		type = CH_KEY_OFF;
	    if (type == CH_KEY_ON)
		on++;
	    if (type == CH_KEY_OFF)
		off++;
	}
	if (name && !Qflg)
	    printf("%s:\t", name);
	if (Vflg)
	    printf("%d on, %d off\n", on, off);
	else
	    printf("%d\n", on + off);
	return(on - off);
}
