/*	NETSCORE -- Bellscore network music client, psl 2/89 */
#include <stdio.h>
#include <signal.h>
#include <midi.h>
#include <sys/ioctl.h>
#include <mpuvar.h>
#define	DBG	if(Debug)fprintf
#define	MAGIC	0x44

char	*Mididev	= MPU_DEV_0;
int	Copacetic	= 1;	/* everything's (still) okay */
int	Debug		= 1;
int	Eknpid;			/* in case we need to kill it */
int	Mfh;
int	Toekn[2];		/* pipe with "MORE\n" going to ekn */
int	Fromekn[2];		/* pipe with MPU data coming back to us */

main(argc, argv)
char	*argv[];
{
	char buf[1024], *style, sync, *host;
	int n, i;
	struct	hdrstr	{
		u_char	magic;	/* should be MAGIC */
		u_char	tempo;
	} hdr;
	void interrupt(), timeout();

	signal(SIGINT, interrupt);
	style = "-sswing";
	host = "puddle";
	n = 0;
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'd':
		    Debug++;
		    break;
		case 'h':
		    host = &argv[i][2];
		    break;
		case 'o':
		    Mididev = &argv[i][2];
		    break;
		case 'S':
		    sync = argv[i][2];
		    break;
		case 's':
		    style = argv[i];
		    break;
		case 't':
		    n = atoi(&argv[i][2]);
		    break;
		default:
		    use(2);
		}
	    } else
		use(2);
	}

	MpuSet(MPU_MIDI_THRU_OFF);
	pipe(Toekn);
	pipe(Fromekn);
	Eknpid = forkexec(Toekn, Fromekn, "rsh", host, "ekn", style, 0);
	if (read(Fromekn[0], &hdr, sizeof hdr) != sizeof hdr) {
	    perror("ekn header read");
	    exit(1);
	}
	if (hdr.magic != MAGIC) {
	    fprintf(stderr, "Garbled header from ekn 0x%x\n", hdr.magic);
	    exit(1);
	}
	MpuSet(MPU_TEMPO);
	MpuSet(n? n : hdr.tempo);
	if (!(Mfh = playinit(Fromekn[0], sync, MPU_START_PLAY)))
	    perror(Mididev);
	signal(SIGALRM, timeout);
	do {
	    for (; trackresid(0) > 256; sleep(1));	/* wait */
	    write(Toekn[1], "MORE\n", 5);
	    alarm(5);
	    n = read(Fromekn[0], buf, sizeof buf);
	    alarm(0);
	    write(Mfh, buf, n);
DBG(stderr, "Wrote %d bytes to %s\n", n, Mididev);
	} while (Copacetic);
fprintf(stderr, "Restarting...\n");
	execvp(argv[0], argv);
}

void
timeout()
{
	kill(Eknpid, 2);
	fprintf(stderr, "Lost connection? resid count = %d\n", trackresid(0));
	ioctl(Mfh, MPU_IOC_PURGE, 0);
	close(Mfh);
	close(Toekn[1]);
	close(Fromekn[0]);
	sleep(2);
	kill(Eknpid, 9);
	Copacetic = 0;
}

playinit(fd, sync, mode)
{
	char buf[512];
	int f, n;

	if ((f = open(Mididev,2)) == -1) {
	    perror(Mididev);
	    return(0);
	}
	n = read(fd, buf, sizeof buf);
	if (MpuSetTrack(f, 0) == -1 || write(f, buf, n) != n) {
	    perror(Mididev);
	    return(0);
	}
	if (sync == 'f')			/* initialization sequence */
	    sync = MPU_FSK_CLOCK;
	else if (sync == 'm')
	    sync = MPU_MIDI_CLOCK;
	else
	    sync = MPU_INT_CLOCK;
	MpuSend(f,
	 MPU_ACTIVE_TRACKS, 1,
	 MPU_CLEAR_PLAY_COUNTERS,
	 MPU_BENDER_ON,
	 sync,
	 mode==0? MPU_START_PLAY : mode,
	0);
	if (MpuSetTrack(f, 0) == -1) {
	    perror(Mididev);
	    return(0);
	}
	return(f);
}

use(i)
{
	fprintf(stderr, "Usage: %s [files or stdin]\n", av0);
	fprintf(stderr, "flags:\n\t%s\t%s\t%s\t%s\t%s",
	    "-oDEV	  send output to \"DEV\" in place of /dev/mpu0\n",
	    "-sSTYLE	  request specific musical style\n",
	    "-Sx	  set sync src,  i => int, f => fsk, m => MIDI in\n",
	    "-t#	  set tempo to # (beats/minute, default=100)\n");
	exit(i);
}

void
interrupt()
{
	ioctl(Mfh, MPU_IOC_PURGE, 0);
	close(Mfh);
	exit(1);
}

trackresid(t)
{
	int counts[MPU_TTR_MAX];

	ioctl(Mfh, MPU_IOC_RESID, counts);
	return(counts[t]);
}

/*VARARGS3*/
forkexec(pipeto, pipefrom, p, a1, a2, a3, a4)
int	pipeto[2], pipefrom[2];
char	*p, *a1, *a2, *a3, *a4;
{
	register int pid;

if (Debug) {
 fprintf(stderr, "forkexec(%x, %x, %s", pipeto, pipefrom, p);
 if (a1) { fprintf(stderr, ", %s", a1);
	  if (a2) { fprintf(stderr, ", %s", a2);
	   if (a3) { fprintf(stderr, ", %s", a3);
	    if (a4) { fprintf(stderr, ", %s", a4);
	}}}}
 fprintf(stderr, ")\n");
}
	switch (pid = fork()) {
	case -1:
	    perror("fork()");
	    break;
	case 0:
	    if (pipeto) {
		dup2(pipeto[0], 0);
		close(pipeto[1]);
	    }
	    if (pipefrom) {
		dup2(pipefrom[1], 1);
		close(pipefrom[0]);
	    }
	    execlp(p, p, a1, a2, a3, a4, 0);
	    perror(p);
	    exit(1);
	}
	if (pipeto)
	    close(pipeto[0]);
	if (pipefrom)
	    close(pipefrom[1]);
	return(pid);
}
