/*                                                             WAVE.H   */

struct wav_head {
  long	magic;			/* 'RIFF' */
  long	len0;			/* Chunk size = len + 8 + 16 + 12 */
  long	magic1;			/* 'WAVE' */
  long	magic2;			/* 'fmt ' */
  long	len;			/* length of samples */
  short	format;			/* 1 is PCM, rest not known */
  short	nchns;			/* Number of chanels */
  long	rate;			/* sampling frequency */
  long	aver;			/* Average bytes/sec !! */
  short	nBlockAlign;		/* (rate*nch +7)/8 */
  short	size;			/* size of each sample (8,16,32) */
  long	magic3;			/* 'data' */
  long	datasize;		/* data chunk size */
};

static char     RIFF_ID[4] = {'R','I','F','F'};
static char     WAVE_ID[4] = {'W','A','V','E'};
static char     FMT_ID[4]  = {'f','m','t',' '};
static char     DATA_ID[4] = {'d','a','t','a'};

#define WAVHDRSIZ (sizeof(struct wav_head))

