#include "cs.h"			/*				UGENS2.C	*/
#include "ugens2.h"
#include <math.h>

static float	fzero = 0., fone = 1.;

void phsset(p)
 register PHSOR *p;
{
register float	phs;
register long  longphs;
	if ((phs = *p->iphs) >= fzero) {
		if ((longphs = phs))
			warning("init phase truncation");
		p->curphs = phs - longphs;
	}
}

void kphsor(p)
 register PHSOR *p;
{
register float	phs;
	*p->sr = phs = p->curphs;
	if ((phs += *p->xcps * onedkr) >= fone)
		phs -= fone;
	else if (phs < fzero)
		phs += fone;
	p->curphs = phs;
}

void phsor(p)
 register PHSOR *p;
{
register int	nsmps = ksmps;
register float	*rs, phase, incr;

	rs = p->sr;
	phase = p->curphs;
	if (p->XINCODE) {
		register float *cps = p->xcps;
		do {
			incr = *cps++ / esr;
			*rs++ = phase;
			phase += incr;
			if (phase >= fone)
				phase -= fone;
			else if (phase < fzero)
				phase += fone;
		} while (--nsmps);
	}
	else {
		incr = *p->xcps / esr;
		do {
			*rs++ = phase;
			phase += incr;
			if (phase >= fone)
				phase -= fone;
			else if (phase < fzero)
				phase += fone;
		} while (--nsmps);
	}
	p->curphs = phase;
}

static int tblchk(p)
 register TABLE *p;
{
register FUNC	*ftp;
register long	xbmul;
register float	xoff;

	if ((ftp = ftfind(p->ifn)) == NULL)
		return(0);
	if (*p->ixmode)
		xbmul = ftp->flen;
	else	xbmul = 1L;
	if ((xoff = xbmul * *p->ixoff) < 0. || xoff > ftp->flen) {
		initerror("invalid ixoff");
		return(0);
	}
	p->ftp = ftp;
	p->xbmul = xbmul;
	p->offset = xoff;
	p->wrap = *p->iwrap;
	return(1);
}

void tblset(p)
 register TABLE *p;
{
	tblchk(p);
}

void itable(p)
 register TABLE *p;
{
  void ktable();
	if (tblchk(p))
		ktable(p);
}
 
void itabli(p)
 register TABLE *p;
{
  void ktabli();
	if (tblchk(p))
		ktabli(p);
}
 
void ktable(p)
 register TABLE  *p;
{
register FUNC 	*ftp;
register long	indx, length;
register float 	ndx;

	ftp = p->ftp;
	ndx = *p->indx;
	length = ftp->flen;
	ndx *= p->xbmul;		/* flen if normalized, 1 if not */
	indx = (long) (ndx + p->offset);	/* offset  non-normalized */
	if (!p->wrap) {
		if (indx > length)
			indx = length;
		else if (indx < 0L)
			indx = 0L;
	}
	indx &= ftp->lenmask;
	*p->rslt = *(ftp->ftable + indx);
}

void table(p)
 register TABLE  *p;
{
register FUNC 	*ftp;
register float 	*rslt, *pindx, *tab;
register long	indx, mask, length;
register int	nsmps = ksmps;
	float	ndx, xbmul, ixoff;

	ftp = p->ftp;
	rslt = p->rslt;
	length = ftp->flen;
	pindx = p->indx;
	xbmul = p->xbmul;
	ixoff = p->offset;
	mask = ftp->lenmask;
	tab = ftp->ftable;
	do {
		ndx = *pindx++;
		ndx *= xbmul;		/* flen if normalized, 1 if not */
		indx = (long) (ndx + ixoff);	/* offset  non-normalized */
		if (!p->wrap) {
			if (indx > length)  indx = length;
			else if (indx < 0L)  indx = 0L;
		}
		indx &= mask;
		*rslt++ = *(tab + indx);
	} 
	while(--nsmps);
}

void ktabli(p)
 register TABLE  *p;
{
register FUNC 	*ftp;
register long	indx, length;
register float 	v1, v2, fract, ndx;

	ftp = p->ftp;
	ndx = *p->indx;
	length = ftp->flen;
	ndx *= p->xbmul;			/* flen if normalized, 1 not */
	if (ndx < 0L) {
		indx = (long) (ndx + p->offset - fone); 
		fract = fone +  ndx - (long)ndx ;
	}
	else {
		indx = (long) (ndx + p->offset);    /* offset non-normalized */
		fract = ndx - (long)ndx;
	}
	if (!p->wrap) {
		if (indx > length)  indx = length;
		else if (indx < 0L)  indx = 0L;
	}
	indx &= ftp->lenmask;
	v1 = *(ftp->ftable + indx);
	v2 = *(ftp->ftable + indx +1); 
	*p->rslt = v1 + (v2 - v1) * fract;
}

void tabli(p)
 register TABLE  *p;
{
register FUNC 	*ftp;
register long	indx, mask, length;
register int	nsmps = ksmps;
register float 	*rslt, *pindx, *tab;
register float 	fract, v1, v2, ndx, xbmul, ixoff;

	ftp = p->ftp;
	rslt = p->rslt;
	length = ftp->flen;
	pindx = p->indx;
	xbmul = p->xbmul;
	ixoff = p->offset;
	mask = ftp->lenmask;
	tab = ftp->ftable;
	do {
		ndx = *pindx++;
		ndx *= xbmul;	/* flen if normalized, 1 if not */
		if (ndx < 0) {
			indx = (long) (ndx + ixoff - fone);
			fract = fone + ndx - (long) ndx;
		}
		else {
			indx = (long) (ndx + ixoff); 
			fract = ndx - (long) ndx;
		}
		if (!p->wrap) {
			if (indx > length)  indx = length;
			else if (indx < 0L)  indx = 0L;
		}
		indx &= mask;
		v1 = *(tab + indx);
		v2 = *(tab + indx +1);
		*rslt++ = v1 + (v2 - v1)*fract;
	} 
	while(--nsmps);
}

void ko1set(p)
 register OSCIL1 *p;
{
register FUNC	*ftp;

	if ((ftp = ftfind(p->ifn)) == NULL)
		return;
	if (*p->idur <= fzero)
		warning("duration < zero");
	p->ftp = ftp;
	p->phs = 0;
	p->dcnt = *p->idel * ekr;
	p->kinc = (long) (kicvt / *p->idur);
}

void kosc1(p) 
 register OSCIL1 *p;
{
register FUNC *ftp;
register long  phs, dcnt;

	ftp = p->ftp;
	phs = p->phs;
	*p->rslt = *(ftp->ftable + (phs >> ftp->lobits)) * *p->kamp;
	if ((dcnt = p->dcnt) > 0L)
		dcnt--;
	else if (dcnt == 0L) {
		phs += p->kinc;
		if (phs >= MAXLEN) {
			phs = MAXLEN;
			dcnt--;
		}
		p->phs = phs;
	}
	p->dcnt = dcnt;
}

void kosc1i(p)
 register OSCIL1  *p;
{
register FUNC	*ftp;
register float	fract, v1, *ftab;
register long	phs, dcnt;

	ftp = p->ftp;
	phs = p->phs;
	fract = PFRAC(phs); 	
	ftab = ftp->ftable + (phs >> ftp->lobits);
	v1 = *ftab++;
	*p->rslt = (v1 + (*ftab - v1) * fract) * *p->kamp;
	if ((dcnt = p->dcnt) > 0L) {
		dcnt--;
		p->dcnt = dcnt;
	}
	else if (dcnt == 0L) {
		phs += p->kinc;
		if (phs >= MAXLEN) {
			phs = MAXLEN;
			dcnt--;
			p->dcnt = dcnt;
		}
		p->phs = phs;
	}
}

void oscset(p)
 register OSC *p;
{
register FUNC	*ftp;

	if ((ftp = ftfind(p->ifn)) != NULL) {
		p->ftp = ftp;
		if (*p->iphs >= 0)
			p->lphs = ((long)(*p->iphs * fmaxlen)) & PMASK;
	}
}

void koscil(p)
 register OSC *p;
{
register FUNC	*ftp;
register long	phs, inc;

	ftp = p->ftp;
	phs = p->lphs;
	inc = *p->xcps * kicvt;
	*p->sr = *(ftp->ftable + (phs >> ftp->lobits)) * *p->xamp;
	phs += inc;
	phs &= PMASK;
	p->lphs = phs;
}

void osckk(p)
 register OSC *p;
{
register FUNC	*ftp;
register float	amp, *ar, *ftbl;
register long	phs, inc, lobits;
register int	nsmps = ksmps;

	ftp = p->ftp;
	ftbl = ftp->ftable;
	phs = p->lphs;
	inc = *p->xcps * sicvt;
	lobits = ftp->lobits;
	amp = *p->xamp;
	ar = p->sr;
	do {
		*ar++ = *(ftbl + (phs >> lobits)) * amp;
		phs += inc;
		phs &= PMASK;
	}
	while (--nsmps);
	p->lphs = phs;
}

void oscka(p)
 register OSC *p;
{
register FUNC	*ftp;
register float	*ar, amp, *cpsp, *ftbl;
register long	phs, lobits;
register int	nsmps = ksmps;

	ftp = p->ftp;
	ftbl = ftp->ftable;
	lobits = ftp->lobits;
	amp = *p->xamp;
	cpsp = p->xcps;
	phs = p->lphs;
	ar = p->sr;
	do {
		register long inc;
		inc = *cpsp++ * sicvt;
		*ar++ = *(ftbl + (phs >> lobits)) * amp;
		phs += inc;
		phs &= PMASK;
	}
	while (--nsmps);
	p->lphs = phs;
}

void oscak(p)
 register OSC *p;
{
register FUNC	*ftp;
register float	*ar, *ampp, *ftbl;
register long	phs, inc, lobits;
register int	nsmps = ksmps;

	ftp = p->ftp;
	ftbl = ftp->ftable;
	lobits = ftp->lobits;
	phs = p->lphs;
	inc = *p->xcps * sicvt;
	ampp = p->xamp;
	ar = p->sr;
	do {
		*ar++ = *(ftbl + (phs >>lobits)) * *ampp++;
		phs += inc;
		phs &= PMASK;
	}
	while (--nsmps);
	p->lphs = phs;
}

void oscaa(p)
 register OSC *p;
{
register FUNC	*ftp;
register float	*ar, *ampp, *cpsp, *ftbl;
register long	phs, lobits;
register int	nsmps = ksmps;

	ftp = p->ftp;
	ftbl = ftp->ftable;
	lobits = ftp->lobits;
	phs = p->lphs;
	ampp = p->xamp;
	cpsp = p->xcps;
	ar = p->sr;
	do {
		register long inc;
		inc = *cpsp++ * sicvt;
		*ar++ = *(ftbl + (phs >>lobits)) * *ampp++;
		phs += inc;
		phs &= PMASK;
	}
	while (--nsmps);
	p->lphs = phs;
}

void koscli(p)
 register OSC  *p;
{
register FUNC	*ftp;
register long	phs, inc;
register float  *ftab, fract, v1;

	phs = p->lphs;
	ftp = p->ftp;
	fract = PFRAC(phs);
	ftab = ftp->ftable + (phs >> ftp->lobits);
	v1 = *ftab++;
	*p->sr = (v1 + (*ftab - v1) * fract) * *p->xamp;
	inc = *p->xcps * kicvt;
	phs += inc;
	phs &= PMASK;
	p->lphs = phs;
}

void osckki(p)
  register OSC  *p;
{
register FUNC	*ftp;
register float	fract, v1, amp, *ar, *ftab;
register long	phs, inc, lobits;
register int	nsmps = ksmps;

	ftp = p->ftp;
	lobits = ftp->lobits;
	phs = p->lphs;
	inc = *p->xcps * sicvt;
	amp = *p->xamp;
	ar = p->sr;
	do {
		fract = PFRAC(phs);
		ftab = ftp->ftable + (phs >> lobits);
		v1 = *ftab++;
		*ar++ = (v1 + (*ftab - v1) * fract) * amp;
		phs += inc;
		phs &= PMASK;
	}
	while (--nsmps);
	p->lphs = phs;
}

void osckai(p)
 register OSC  *p;
{
register FUNC	*ftp;
register float	*ar, amp, *cpsp, fract, v1, *ftab;
register long	phs, lobits;
register int	nsmps = ksmps;

	ftp = p->ftp;
	lobits = ftp->lobits;
	amp = *p->xamp;
	cpsp = p->xcps;
	phs = p->lphs;
	ar = p->sr;
	do {
		register long inc;
		inc = *cpsp++ * sicvt;
		fract = PFRAC(phs);
		ftab = ftp->ftable + (phs >> lobits);
		v1 = *ftab++;
		*ar++ = (v1 + (*ftab - v1) * fract) * amp;
		phs += inc;
		phs &= PMASK;
	}
	while (--nsmps);
	p->lphs = phs;
}

void oscaki(p)
 register OSC  *p;
{
register FUNC	*ftp;
register float	v1, fract, *ar, *ampp, *ftab;
register long	phs, inc, lobits;
register int	nsmps = ksmps;

	ftp = p->ftp;
	ftab = ftp->ftable;
	lobits = ftp->lobits;
	phs = p->lphs;
	inc = *p->xcps * sicvt;
	ampp = p->xamp;
	ar = p->sr;
	do {
		fract = PFRAC(phs);
		ftab = ftp->ftable + (phs >> lobits);
		v1 = *ftab++;
		*ar++ = (v1 + (*ftab - v1) * fract) * *ampp++;
		phs += inc;
		phs &= PMASK;
	}
	while (--nsmps);
	p->lphs = phs;
}

void oscaai(p)
 register OSC  *p;
{
register FUNC	*ftp;
register float	v1, fract, *ar, *ampp, *cpsp, *ftab;
register long	phs, lobits;
register int	nsmps = ksmps;

	ftp = p->ftp;
	ftab = ftp->ftable;
	lobits = ftp->lobits;
	phs = p->lphs;
	ampp = p->xamp;
	cpsp = p->xcps;
	ar = p->sr;
	do {
		register long inc;
		inc = *cpsp++ * sicvt;
		fract = PFRAC(phs);
		ftab = ftp->ftable + (phs >> lobits);
		v1 = *ftab++;
		*ar++ = (v1 + (*ftab - v1) * fract) * *ampp++;
		phs += inc;
		phs &= PMASK;
	}
	while (--nsmps);
	p->lphs = phs;
}

