.TH Command BUILD
.SY "build [ship|plane|nuke|bridge] <SECTS> [ship-type|plane-type|nuke-type|direction] <TECH> [Number to build]"
The build command is used to specify the types of ships
to be built in your harbors, the planes and missiles at your airfields,
the nuclear devices at your nuclear production facilities,
and the directions in which bridge spans are to be built
from bridge head sectors.
.s3
The ability to produce ships, planes, nukes, or bridges, is based on
several factors:
labor force, light production units, heavy production units,
oil units, radioactive material units, available cash,
and technology level.
The quantities or levels required vary with the object being built.
.s1
HARBOR SECTORS
.s3
The ship choices range from patrol boats through battleships and yachts.
For a brief table indicating the production costs of the
different ship types respond with \*Q?\*U.
For a table describing the costs and capabilities of the
different ship types see \*Qinfo ship-types\*U.
.s3
The labor force required to build a particular ship type
is equal to the ship's tonnage,
which is the lcm cost plus twice the hcm cost.
Labor force is defined
as the number of civilians multiplied by the work percentage,
plus the number of uncompensated workers,
plus two-fifths the number of military.
.s1
You must give enough of the ship name to make it unique,
otherwise the program won't know which to build, and will
regale you with the full list.
.s1
\*QNote:\*U if you wish to give the ship-type argument on the
command line, it may be necessary to quote the ship-type. For
example: build s 0,0 "lander 2" 80 would build a lander 2. Without
the quotes, it mnight build a lander 1 instead, since the ship-type
is two words.
.s1
The "Number to build" option may only be given if the command is being
specified totally on the command line. If oyu give multiple sectors and
a number to build, it will attempt to build that number at EACH sector
specified.
.s1
Note that ships first appear at 20% efficiency and a 19% efficient ship
will not float (i.e., it sinks).
As the ships' crew and harbor personnel work on them,
their efficiency grows to 100%.
The workforce needed to increase a ship's efficiency by
one percent per time unit is equal to its tonnage.
.s1
Harbor workforce is divided up among those ships needing work
in proportion to their tonnages relative to the total,
up to a workforce limit of two times the tonnage for any ship.
For fastest efficiency growth, put full crews on your newly built
ships and leave them in harbor until they reach 100%.
.s1
Ships at sea have only their crews to make repairs.
Crew members each supply the same amount of work,
whether civilian, military, or uncompensated worker.
A small crew on a large ship
may not be able to make any repairs at all.
(Moral: keep your ships fully crewed in anticipation of future damage.)
.s1
Entropy acts on ships at the rate of one efficiency point every
four time units.
Ships at sea without enough crew to fight entropy effects
will gradually rust, take on water, and sink.
.s1
AIRPORT SECTORS
.s3
The choices range from low tech \*Qfighter 1\*U planes
up to and including super-long range \*Qjet hvy bomber\*Us
and \*Qicbm\*Us.
For a brief table indicating the production costs of the
different plane types respond with \*Q?\*U.
For a table describing the costs and capabilities of the
different plane types see \*Qinfo plane-types\*U,
and \*Qinfo show\*U.
.s3
Note that planes first appear at 10% efficiency.
As time passes, and as long as there are \*Qavailable work units\*U in the
airport at which the planes reside (to work on the planes), they grow to
100% efficiency.
.s1
NUCLEAR PLANT SECTORS
.s3
If you type
.EX build 6,2
and 6,2 is a nuclear plant that has enough hcm
(heavy construction materials),
lcm (light construction materials), oil, and radioactive material,
the workforce in the sector is large enough (as defined above),
you have enough money, and your technology level is high enough,
then the program will construct a new nuclear device of the type
requested, and add it to the current stockpile in that sector.
.s3
Note: If the DRNUKE option is enabled, you will need a certain amount
of research to make nukes. At the present time, it is 1/4 the amount of 
tech needed to make the nuke. So, for example, to build a nuke that is tech 400
you would need 100 research.
.s1
BRIDGES
.s3
If you type
.EX build 2,2
and 2,2 is a sector that has enough hcm (heavy construction materials),
the workforce in the sector is large enough (as defined above),
you have enough money, and your technology level is high enough,
then the program will respond:
.NF
Bridge head at 2,2; build span in what direction? j
.FI
.s3
With the EASY_BRIDGES option enabled,
the sector the bridge span is to be built in must be adjacent to
at least 1 non-sea, non-bridge span sector, but does NOT have
to be built from a bridge head. If so, you get:
.NF

Bridge span built over 4,2
.FI
To find out the required amounts of materials, workforce, and money
try to build in an underdeveloped bridge head sector
and the program will tell you the current amounts
(may be changed by the local deity).
.s1
If the optional \*Q(direction)\*U argument is used in the command line
the program will try to build
a span in the specified direction from all bridge heads
in the given area that have the necessary heavy production units.
.s3
See also : launch, fly, nuke, bridges
