/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#ifndef _TESTS_SUPPORT_H
#define _TESTS_SUPPORT_H

#include <check.h>
#include <libsyncml/syncml.h>
#include <libsyncml/syncml_internals.h>

void configure_environment();
void cleanup_environment();
char *setup_testbed(char *fkt_name);
void destroy_testbed(char *path);
void create_case(Suite *s, const char *name, TFun function);
SmlParser *start_parser(const char *data, SmlError **error);
int sml_sleep(int64_t nanoseconds);

#ifdef THREAD_SAFE_CHECK

	#define sml_fail_unless(expr, ...);\
		{\
			int _result = expr;\
			fail_unless(_result, ## __VA_ARGS__);\
			if (!_result) smlAssertMsg(0, g_strdup_printf(__VA_ARGS__));\
		}

#else

	/* If check is earlier than 0.9.7 then it is not thread safe. */

	extern GStaticMutex __libsyncml_check_mutex;

	#define sml_fail_unless(expr, ...);\
		{\
			int _result = expr;\
			g_static_mutex_lock(&__libsyncml_check_mutex);\
			fail_unless(_result, ## __VA_ARGS__);\
			g_static_mutex_unlock(&__libsyncml_check_mutex);\
		}
			/* disabled to avoid unwanted aborts
			 * if (!_result) smlAssertMsg(0, g_strdup_printf(__VA_ARGS__));\
			 */

	
#endif /* THREAD_SAFE_CHECK */

/* setup test cases */

#define SML_TESTCASE_START(x)	\
	const char *_unittest = (#x);	\
	struct sml_testcase_s sml_testcase[] = {

#define SML_TESTCASE_ADD(x) { (#x), x },

#define SML_TESTCASE_END			\
	{ NULL, NULL }				\
	};					\
						\
int main(int argc, char **argv)			\
{						\
        return sml_testsuite(argc, argv, _unittest, sml_testcase);	\
}

struct sml_testcase_s {
	const char *name;
	void *func;
};


int sml_testsuite(
		int argc,
		char **argv,
		const char *unittest,
		struct sml_testcase_s *tc);

#endif // _TESTS_SUPPORT_H
