/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.XPathException;

public final class ContextItemExpression
extends ComputedExpression {
    public Expression analyze(StaticContext staticContext) throws XPathException {
        return this;
    }

    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    public int computeCardinality() {
        return 512;
    }

    public boolean equals(Object object) {
        return object instanceof ContextItemExpression;
    }

    public int hashCode() {
        return "ContextItemExpression".hashCode();
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is not set");
        }
        return SingletonIterator.makeIterator(item);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is not set");
        }
        return item;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + ".");
    }
}

