.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.ie \n(.g .ds `` \(lq
.el       .ds `` ``
.ie \n(.g .ds '' \(rq
.el       .ds '' ''
.hw XtCreate-Popup-Shell XtVaCreate-Popup-Shell wid-get
.na
.TH XtCreatePopupShell __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtCreatePopupShell, XtVaCreatePopupShell \- create a popup shell
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
Widget XtCreatePopupShell(const char *\fIname\fP, WidgetClass \fIwidget_class\fP,
Widget \fIparent\fP, ArgList \fIargs\fP, Cardinal \fInum_args\fP);
.HP
Widget XtVaCreatePopupShell(const char *\fIname\fP, WidgetClass \fIwidget_class\fP,
Widget \fIparent\fP, ...\^);
.SH ARGUMENTS
.IP \fIargs\fP 1i
Specifies the argument list to override the resource defaults.
.IP \fIname\fP 1i
Specifies the text name for the created shell widget.
.IP \fInum_args\fP 1i
Specifies the number of arguments in the argument list.
.IP \fIparent\fP 1i
Specifies the parent widget.
.IP \fIwidget_class\fP 1i
Specifies the widget class pointer for the created shell widget.
.IP \fI...\fP 1i
Specifies the variable argument list to override the resource defaults.
.SH DESCRIPTION
The
.B XtCreatePopupShell
function ensures that the specified class is a subclass of
.B Shell
and, rather than using insert_child to attach the widget to the parent's
children list, attaches the shell to the parent's pop-ups list directly.
.LP
A spring-loaded pop-up invoked from a translation table already must exist
at the time that the translation is invoked,
so the translation manager can find the shell by name.
Pop-ups invoked in other ways can be created \*(``on-the-fly\*('' when
the pop-up actually is needed.
This delayed creation of the shell is particularly useful when you pop up
an unspecified number of pop-ups.
You can look to see if an appropriate unused shell (that is, not
currently popped up) exists and create a new shell if needed.
.SH "SEE ALSO"
XtCreateWidget(__libmansuffix__),
XtPopdown(__libmansuffix__),
XtPopup(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
