/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License, in which case the provisions of the GPL are
 * required INSTEAD OF the above restrictions.  (This clause is
 * necessary due to a potential bad interaction between the GPL and
 * the restrictions contained in a BSD-style copyright.)
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Check crypt handling
 * First use exact password, 8 characters (13 characters crypt)
 * Second use longer password, 9 characters
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <security/pam_appl.h>

static int in_test;

/* A conversation function which uses an internally-stored value for
   the responses. */
static int
fake_conv (int num_msg, const struct pam_message **msgm UNUSED,
	   struct pam_response **response, void *appdata_ptr UNUSED)
{
  struct pam_response *reply;
  int count;

  /* Sanity test. */
  if (num_msg <= 0)
    return PAM_CONV_ERR;

  /* Allocate memory for the responses. */
  reply = calloc (num_msg, sizeof (struct pam_response));
  if (reply == NULL)
    return PAM_CONV_ERR;

  /* Each prompt elicits the same response. */
  for (count = 0; count < num_msg; ++count)
    {
      reply[count].resp_retcode = 0;
      /* first call get a password, second one a too long one */
      if (in_test == 1)
	reply[count].resp = strdup ("pamunix0");
      else if (in_test == 2)
	reply[count].resp = strdup ("pamunix01");
      else
	reply[count].resp = strdup ("pamunix1");
    }

  /* Set the pointers in the response structure and return. */
  *response = reply;
  return PAM_SUCCESS;
}

static struct pam_conv conv = {
    fake_conv,
    NULL
};


/* Check that errors of optional modules are ignored and that
   required modules after a sufficient one are not executed.  */

int
main(int argc, char *argv[])
{
  pam_handle_t *pamh=NULL;
  const char *user="tstpamunix";
  int retval;
  int debug = 0;

  if (argc > 1 && strcmp (argv[1], "-d") == 0)
    debug = 1;

  retval = pam_start("tst-pam_unix2", user, &conv, &pamh);
  if (retval != PAM_SUCCESS)
    {
      if (debug)
	fprintf (stderr, "unix2: pam_start returned %d\n", retval);
      return 1;
    }

  /* Try one, first input is correct, second is NULL */
  in_test = 1;
  retval = pam_authenticate (pamh, 0);
  if (retval != PAM_SUCCESS)
    {
      if (debug)
	fprintf (stderr, "unix2-1: pam_authenticate returned %d\n", retval);
      return 1;
    }

  /* Try two, second input is too long  */
  in_test = 2;
  retval = pam_authenticate (pamh, 0);
  if (retval != PAM_SUCCESS)
    {
      if (debug)
        fprintf (stderr, "unix2-2: pam_authenticate returned %d\n", retval);
      return 1;
    }

  /* Third try, third input is wrong  */
  in_test = 3;
  retval = pam_authenticate (pamh, 0);
  if (retval != PAM_AUTH_ERR)
    {
      if (debug)
        fprintf (stderr, "unix2-3: pam_authenticate returned %d\n", retval);
      return 1;
    }


  retval = pam_end (pamh,retval);
  if (retval != PAM_SUCCESS)
    {
      if (debug)
	fprintf (stderr, "unix2: pam_end returned %d\n", retval);
      return 1;
    }
  return 0;
}
