// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See generate_spec_error_message.py for modifications
// Based on Vulkan specification version: 1.4.341

/***************************************************************************
 *
 * Copyright (c) 2016-2026 Google Inc.
 * Copyright (c) 2016-2026 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/
#pragma once

#include "containers/custom_containers.h"

#include <array>

// clang-format off

// Mapping from VUID string to the corresponding spec text
struct vuid_info {
    const std::string_view spec_text;
    const std::string_view url_id;
};

const vvl::unordered_map<std::string_view, vuid_info> &GetVuidMap() {
    static const std::array<std::pair<std::string_view, vuid_info>, 23482> vuid_array = {{
        { {"VUID-BaryCoordKHR-BaryCoordKHR-04154", 36}, { {"The BaryCoordKHR decoration must be used only within the Fragment Execution Model", 81}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordKHR-BaryCoordKHR-04155", 36}, { {"The variable decorated with BaryCoordKHR must be declared using the Input Storage Class", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordKHR-BaryCoordKHR-04156", 36}, { {"The variable decorated with BaryCoordKHR must be declared as a three-component vector of 32-bit floating-point values", 117}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04157", 50}, { {"The BaryCoordNoPerspAMD decoration must be used only within the Fragment Execution Model", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04158", 50}, { {"The variable decorated with BaryCoordNoPerspAMD must be declared using the Input Storage Class", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04159", 50}, { {"The variable decorated with BaryCoordNoPerspAMD must be declared as a two-component vector of 32-bit floating-point values", 122}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04163", 66}, { {"The BaryCoordNoPerspCentroidAMD decoration must be used only within the Fragment Execution Model", 96}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04164", 66}, { {"The variable decorated with BaryCoordNoPerspCentroidAMD must be declared using the Input Storage Class", 102}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04165", 66}, { {"The variable decorated with BaryCoordNoPerspCentroidAMD must be declared as a three-component vector of 32-bit floating-point values", 132}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04160", 50}, { {"The BaryCoordNoPerspKHR decoration must be used only within the Fragment Execution Model", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04161", 50}, { {"The variable decorated with BaryCoordNoPerspKHR must be declared using the Input Storage Class", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04162", 50}, { {"The variable decorated with BaryCoordNoPerspKHR must be declared as a three-component vector of 32-bit floating-point values", 124}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04166", 62}, { {"The BaryCoordNoPerspSampleAMD decoration must be used only within the Fragment Execution Model", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04167", 62}, { {"The variable decorated with BaryCoordNoPerspSampleAMD must be declared using the Input Storage Class", 100}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04168", 62}, { {"The variable decorated with BaryCoordNoPerspSampleAMD must be declared as a two-component vector of 32-bit floating-point values", 128}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04169", 54}, { {"The BaryCoordPullModelAMD decoration must be used only within the Fragment Execution Model", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04170", 54}, { {"The variable decorated with BaryCoordPullModelAMD must be declared using the Input Storage Class", 96}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04171", 54}, { {"The variable decorated with BaryCoordPullModelAMD must be declared as a three-component vector of 32-bit floating-point values", 126}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04172", 48}, { {"The BaryCoordSmoothAMD decoration must be used only within the Fragment Execution Model", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04173", 48}, { {"The variable decorated with BaryCoordSmoothAMD must be declared using the Input Storage Class", 93}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04174", 48}, { {"The variable decorated with BaryCoordSmoothAMD must be declared as a two-component vector of 32-bit floating-point values", 121}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04175", 64}, { {"The BaryCoordSmoothCentroidAMD decoration must be used only within the Fragment Execution Model", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04176", 64}, { {"The variable decorated with BaryCoordSmoothCentroidAMD must be declared using the Input Storage Class", 101}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04177", 64}, { {"The variable decorated with BaryCoordSmoothCentroidAMD must be declared as a two-component vector of 32-bit floating-point values", 129}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04178", 60}, { {"The BaryCoordSmoothSampleAMD decoration must be used only within the Fragment Execution Model", 93}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04179", 60}, { {"The variable decorated with BaryCoordSmoothSampleAMD must be declared using the Input Storage Class", 99}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04180", 60}, { {"The variable decorated with BaryCoordSmoothSampleAMD must be declared as a two-component vector of 32-bit floating-point values", 127}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaseInstance-BaseInstance-04181", 36}, { {"The BaseInstance decoration must be used only within the Vertex Execution Model", 79}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaseInstance-BaseInstance-04182", 36}, { {"The variable decorated with BaseInstance must be declared using the Input Storage Class", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaseInstance-BaseInstance-04183", 36}, { {"The variable decorated with BaseInstance must be declared as a scalar 32-bit integer value", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaseVertex-BaseVertex-04184", 32}, { {"The BaseVertex decoration must be used only within the Vertex Execution Model", 77}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaseVertex-BaseVertex-04185", 32}, { {"The variable decorated with BaseVertex must be declared using the Input Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-BaseVertex-BaseVertex-04186", 32}, { {"The variable decorated with BaseVertex must be declared as a scalar 32-bit integer value", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistance-ClipDistance-04187", 36}, { {"The ClipDistance decoration must be used only within the MeshEXT, MeshNV, Vertex, Fragment, TessellationControl, TessellationEvaluation, or Geometry Execution Model", 164}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistance-ClipDistance-04188", 36}, { {"The variable decorated with ClipDistance within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", 142}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistance-ClipDistance-04189", 36}, { {"The variable decorated with ClipDistance within the Fragment Execution Model must be declared using the Input Storage Class", 123}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistance-ClipDistance-04190", 36}, { {"The variable decorated with ClipDistance within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared in a Storage Class other than Input or Output", 191}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistance-ClipDistance-04191", 36}, { {"The variable decorated with ClipDistance must be declared as an array of 32-bit floating-point values", 101}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04192", 54}, { {"The ClipDistancePerViewNV decoration must be used only within the MeshNV Execution Model", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04193", 54}, { {"The variable decorated with ClipDistancePerViewNV must be declared using the Output Storage Class", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04194", 54}, { {"The variable decorated with ClipDistancePerViewNV must also be decorated with the PerViewNV decoration", 102}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04195", 54}, { {"The variable decorated with ClipDistancePerViewNV must be declared as a two-dimensional array of 32-bit floating-point values", 125}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClusterIDHUAWEI-ClusterIDHUAWEI-07797", 42}, { {"The ClusterIDHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", 96}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClusterIDHUAWEI-ClusterIDHUAWEI-07798", 42}, { {"The variable decorated with ClusterIDHUAWEI must be declared as a scalar 32-bit integer value", 93}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClusterIDNV-ClusterIDNV-10531", 34}, { {"The ClusterIDNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", 99}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClusterIDNV-ClusterIDNV-10532", 34}, { {"The variable decorated with ClusterIDNV must be declared using the Input Storage Class", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClusterIDNV-ClusterIDNV-10533", 34}, { {"The variable decorated with ClusterIDNV must be declared as a scalar 32-bit integer value", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClusterShadingRateHUAWEI-ClusterShadingRateHUAWEI-09448", 60}, { {"The ClusterShadingRateHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", 105}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ClusterShadingRateHUAWEI-ClusterShadingRateHUAWEI-09449", 60}, { {"The variable decorated with ClusterShadingRateHUAWEI must be declared as a scalar 32-bit integer value", 102}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09172", 58}, { {"The variable decorated with CoalescedInputCountAMDX must be declared using the Input Storage Class", 98}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09173", 58}, { {"If a variable is decorated with CoalescedInputCountAMDX, the CoalescingAMDX execution mode must be declared", 107}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09174", 58}, { {"The variable decorated with CoalescedInputCountAMDX must be declared as a scalar 32-bit integer value", 101}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoreCountARM-CoreCountARM-07595", 36}, { {"The variable decorated with CoreCountARM must be declared using the Input Storage Class", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoreCountARM-CoreCountARM-07596", 36}, { {"The variable decorated with CoreCountARM must be declared as a scalar 32-bit integer value", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoreIDARM-CoreIDARM-07599", 30}, { {"The variable decorated with CoreIDARM must be declared using the Input Storage Class", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoreIDARM-CoreIDARM-07600", 30}, { {"The variable decorated with CoreIDARM must be declared as a scalar 32-bit integer value", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoreMaxIDARM-CoreMaxIDARM-07597", 36}, { {"The variable decorated with CoreMaxIDARM must be declared using the Input Storage Class", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CoreMaxIDARM-CoreMaxIDARM-07598", 36}, { {"The variable decorated with CoreMaxIDARM must be declared as a scalar 32-bit integer value", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistance-CullDistance-04196", 36}, { {"The CullDistance decoration must be used only within the MeshEXT, MeshNV, Vertex, Fragment, TessellationControl, TessellationEvaluation, or Geometry Execution Model", 164}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistance-CullDistance-04197", 36}, { {"The variable decorated with CullDistance within the MeshEXT, MeshNV or Vertex Execution Model must be declared using the Output Storage Class", 141}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistance-CullDistance-04198", 36}, { {"The variable decorated with CullDistance within the Fragment Execution Model must be declared using the Input Storage Class", 123}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistance-CullDistance-04199", 36}, { {"The variable decorated with CullDistance within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", 194}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistance-CullDistance-04200", 36}, { {"The variable decorated with CullDistance must be declared as an array of 32-bit floating-point values", 101}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04201", 54}, { {"The CullDistancePerViewNV decoration must be used only within the MeshNV Execution Model", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04202", 54}, { {"The variable decorated with CullDistancePerViewNV must be declared using the Output Storage Class", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04203", 54}, { {"The variable decorated with CullDistancePerViewNV must also be decorated with the PerViewNV decoration", 102}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04204", 54}, { {"The variable decorated with CullDistancePerViewNV must be declared as a two-dimensional array of 32-bit floating-point values", 125}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullMaskKHR-CullMaskKHR-06735", 34}, { {"The CullMaskKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", 125}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullMaskKHR-CullMaskKHR-06736", 34}, { {"The variable decorated with CullMaskKHR must be declared using the Input Storage Class", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullMaskKHR-CullMaskKHR-06737", 34}, { {"The variable decorated with CullMaskKHR must be declared as a scalar 32-bit integer value", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07034", 44}, { {"The CullPrimitiveEXT decoration must be used only within the MeshEXT Execution Model", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07035", 44}, { {"The variable decorated with CullPrimitiveEXT must be declared using the Output Storage Class", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07036", 44}, { {"CullPrimitiveEXT must decorate a scalar boolean member of a structure decorated as Block, or decorate a variable of type OpTypeArray of boolean values", 150}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07038", 44}, { {"The variable decorated with CullPrimitiveEXT within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", 138}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-10589", 44}, { {"If CullPrimitiveEXT is declared as an array of boolean values, the size of the array must match the value specified by OutputPrimitivesEXT", 138}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-10590", 44}, { {"If CullPrimitiveEXT decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", 188}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-10591", 44}, { {"There must be only one declaration of the CullPrimitiveEXT associated with a entry point's interface", 100}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04942", 44}, { {"The CurrentRayTimeNV decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", 130}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04943", 44}, { {"The variable decorated with CurrentRayTimeNV must be declared using the Input Storage Class", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04944", 44}, { {"The variable decorated with CurrentRayTimeNV must be declared as a scalar 32-bit floating-point value", 101}, { "chapters/interfaces.html", 24} } },
        { {"VUID-DeviceIndex-DeviceIndex-04205", 34}, { {"The variable decorated with DeviceIndex must be declared using the Input Storage Class", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-DeviceIndex-DeviceIndex-04206", 34}, { {"The variable decorated with DeviceIndex must be declared as a scalar 32-bit integer value", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-DrawIndex-DrawIndex-04207", 30}, { {"The DrawIndex decoration must be used only within the Vertex, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", 113}, { "chapters/interfaces.html", 24} } },
        { {"VUID-DrawIndex-DrawIndex-04208", 30}, { {"The variable decorated with DrawIndex must be declared using the Input Storage Class", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-DrawIndex-DrawIndex-04209", 30}, { {"The variable decorated with DrawIndex must be declared as a scalar 32-bit integer value", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FirstIndexHUAWEI-FirstIndexHUAWEI-07799", 44}, { {"The FirstIndexHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FirstIndexHUAWEI-FirstIndexHUAWEI-07800", 44}, { {"The variable decorated with FirstIndexHUAWEI must be declared as a scalar 32-bit integer value", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FirstInstanceHUAWEI-FirstInstanceHUAWEI-07801", 50}, { {"The FirstInstanceHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", 100}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FirstInstanceHUAWEI-FirstInstanceHUAWEI-07802", 50}, { {"The variable decorated with FirstInstanceHUAWEI must be declared as a scalar 32-bit integer value", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FirstVertexHUAWEI-FirstVertexHUAWEI-07803", 46}, { {"The FirstVertexHUAWEI decoration must be used only within the FirstVertexHUAWEI Execution Model", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FirstVertexHUAWEI-FirstVertexHUAWEI-07804", 46}, { {"The variable decorated with FirstVertexHUAWEI must be declared as a scalar 32-bit integer value", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragCoord-FragCoord-04210", 30}, { {"The FragCoord decoration must be used only within the Fragment Execution Model", 78}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragCoord-FragCoord-04211", 30}, { {"The variable decorated with FragCoord must be declared using the Input Storage Class", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragCoord-FragCoord-04212", 30}, { {"The variable decorated with FragCoord must be declared as a four-component vector of 32-bit floating-point values", 113}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragDepth-FragDepth-04213", 30}, { {"The FragDepth decoration must be used only within the Fragment Execution Model", 78}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragDepth-FragDepth-04214", 30}, { {"The variable decorated with FragDepth must be declared using the Output Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragDepth-FragDepth-04215", 30}, { {"The variable decorated with FragDepth must be declared as a scalar 32-bit floating-point value", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragDepth-FragDepth-04216", 30}, { {"If the shader dynamically writes to the variable decorated with FragDepth, the DepthReplacing Execution Mode must be declared", 125}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04217", 56}, { {"The FragInvocationCountEXT decoration must be used only within the Fragment Execution Model", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04218", 56}, { {"The variable decorated with FragInvocationCountEXT must be declared using the Input Storage Class", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04219", 56}, { {"The variable decorated with FragInvocationCountEXT must be declared as a scalar 32-bit integer value", 100}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragSizeEXT-FragSizeEXT-04220", 34}, { {"The FragSizeEXT decoration must be used only within the Fragment Execution Model", 80}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragSizeEXT-FragSizeEXT-04221", 34}, { {"The variable decorated with FragSizeEXT must be declared using the Input Storage Class", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragSizeEXT-FragSizeEXT-04222", 34}, { {"The variable decorated with FragSizeEXT must be declared as a two-component vector of 32-bit integer values", 107}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragStencilRefEXT-FragStencilRefEXT-04223", 46}, { {"The FragStencilRefEXT decoration must be used only within the Fragment Execution Model", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragStencilRefEXT-FragStencilRefEXT-04224", 46}, { {"The variable decorated with FragStencilRefEXT must be declared using the Output Storage Class", 93}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragStencilRefEXT-FragStencilRefEXT-04225", 46}, { {"The variable decorated with FragStencilRefEXT must be declared as a scalar integer value", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragmentSizeNV-FragmentSizeNV-04226", 40}, { {"The FragmentSizeNV decoration must be used only within the Fragment Execution Model", 83}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragmentSizeNV-FragmentSizeNV-04227", 40}, { {"The variable decorated with FragmentSizeNV must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FragmentSizeNV-FragmentSizeNV-04228", 40}, { {"The variable decorated with FragmentSizeNV must be declared as a two-component vector of 32-bit integer values", 110}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FrontFacing-FrontFacing-04229", 34}, { {"The FrontFacing decoration must be used only within the Fragment Execution Model", 80}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FrontFacing-FrontFacing-04230", 34}, { {"The variable decorated with FrontFacing must be declared using the Input Storage Class", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FrontFacing-FrontFacing-04231", 34}, { {"The variable decorated with FrontFacing must be declared as a boolean value", 75}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FullyCoveredEXT-FullyCoveredEXT-04232", 42}, { {"The FullyCoveredEXT decoration must be used only within the Fragment Execution Model", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FullyCoveredEXT-FullyCoveredEXT-04233", 42}, { {"The variable decorated with FullyCoveredEXT must be declared using the Input Storage Class", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FullyCoveredEXT-FullyCoveredEXT-04234", 42}, { {"The variable decorated with FullyCoveredEXT must be declared as a boolean value", 79}, { "chapters/interfaces.html", 24} } },
        { {"VUID-FullyCoveredEXT-conservativeRasterizationPostDepthCoverage-04235", 69}, { {"If VkPhysicalDeviceConservativeRasterizationPropertiesEXT::conservativeRasterizationPostDepthCoverage is not supported the PostDepthCoverage Execution Mode must not be declared, when a variable with the FullyCoveredEXT decoration is declared", 241}, { "chapters/interfaces.html", 24} } },
        { {"VUID-GlobalInvocationId-GlobalInvocationId-04236", 48}, { {"The GlobalInvocationId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", 125}, { "chapters/interfaces.html", 24} } },
        { {"VUID-GlobalInvocationId-GlobalInvocationId-04237", 48}, { {"The variable decorated with GlobalInvocationId must be declared using the Input Storage Class", 93}, { "chapters/interfaces.html", 24} } },
        { {"VUID-GlobalInvocationId-GlobalInvocationId-04238", 48}, { {"The variable decorated with GlobalInvocationId must be declared as a three-component vector of 32-bit integer values", 116}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HelperInvocation-HelperInvocation-04239", 44}, { {"The HelperInvocation decoration must be used only within the Fragment Execution Model", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HelperInvocation-HelperInvocation-04240", 44}, { {"The variable decorated with HelperInvocation must be declared using the Input Storage Class", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HelperInvocation-HelperInvocation-04241", 44}, { {"The variable decorated with HelperInvocation must be declared as a boolean value", 80}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitIsLSSNV-HitIsLSSNV-10516", 32}, { {"The HitIsLSSNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", 98}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitIsLSSNV-HitIsLSSNV-10517", 32}, { {"The variable decorated with HitIsLSSNV must be declared using the Input Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitIsLSSNV-HitIsLSSNV-10518", 32}, { {"The variable decorated with HitIsLSSNV must be declared as a boolean value", 74}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitIsSphereNV-HitIsSphereNV-10513", 38}, { {"The HitIsSphereNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", 101}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitIsSphereNV-HitIsSphereNV-10514", 38}, { {"The variable decorated with HitIsSphereNV must be declared using the Input Storage Class", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitIsSphereNV-HitIsSphereNV-10515", 38}, { {"The variable decorated with HitIsSphereNV must be declared as a boolean value", 77}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitKindKHR-HitKindKHR-04242", 32}, { {"The HitKindKHR decoration must be used only within the AnyHitKHR or ClosestHitKHR Execution Model", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitKindKHR-HitKindKHR-04243", 32}, { {"The variable decorated with HitKindKHR must be declared using the Input Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitKindKHR-HitKindKHR-04244", 32}, { {"The variable decorated with HitKindKHR must be declared as a scalar 32-bit integer value", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitLSSPositionsNV-HitLSSPositionsNV-10525", 46}, { {"The HitLSSPositionsNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", 105}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitLSSPositionsNV-HitLSSPositionsNV-10526", 46}, { {"The variable decorated with HitLSSPositionsNV must be declared using the Input Storage Class", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitLSSPositionsNV-HitLSSPositionsNV-10527", 46}, { {"The variable decorated with HitLSSPositionsNV must be declared as an array of size two, containing three-component vector of 32-bit floating-point values", 153}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitLSSRadiiNV-HitLSSRadiiNV-10528", 38}, { {"The HitLSSRadiiNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", 101}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitLSSRadiiNV-HitLSSRadiiNV-10529", 38}, { {"The variable decorated with HitLSSRadiiNV must be declared using the Input Storage Class", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitLSSRadiiNV-HitLSSRadiiNV-10530", 38}, { {"The variable decorated with HitLSSRadiiNV must be declared as an array of size two, containing 32-bit floating-point values", 123}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitSpherePositionNV-HitSpherePositionNV-10519", 50}, { {"The HitSpherePositionNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", 107}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitSpherePositionNV-HitSpherePositionNV-10520", 50}, { {"The variable decorated with HitSpherePositionNV must be declared using the Input Storage Class", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitSpherePositionNV-HitSpherePositionNV-10521", 50}, { {"The variable decorated with HitSpherePositionNV must be declared as a three-component vector of 32-bit floating-point values", 124}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitSphereRadiusNV-HitSphereRadiusNV-10522", 46}, { {"The HitSphereRadiusNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", 105}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitSphereRadiusNV-HitSphereRadiusNV-10523", 46}, { {"The variable decorated with HitSphereRadiusNV must be declared using the Input Storage Class", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitSphereRadiusNV-HitSphereRadiusNV-10524", 46}, { {"The variable decorated with HitSphereRadiusNV must be declared as a scalar 32-bit floating-point value", 102}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitTNV-HitTNV-04245", 24}, { {"The HitTNV decoration must be used only within the AnyHitNV or ClosestHitNV Execution Model", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitTNV-HitTNV-04246", 24}, { {"The variable decorated with HitTNV must be declared using the Input Storage Class", 81}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitTNV-HitTNV-04247", 24}, { {"The variable decorated with HitTNV must be declared as a scalar 32-bit floating-point value", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08747", 70}, { {"The HitTriangleVertexPositionsKHR decoration must be used only within the AnyHitKHR or ClosestHitKHR Execution Model", 116}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08748", 70}, { {"The variable decorated with HitTriangleVertexPositionsKHR must be declared using the Input Storage Class", 104}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08749", 70}, { {"The variable decorated with HitTriangleVertexPositionsKHR must be declared as an array of three vectors of three 32-bit float values", 132}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08750", 70}, { {"The variable decorated with HitTriangleVertexPositionsKHR must be used only if the value of HitKindKHR is HitKindFrontFacingTriangleKHR or HitKindBackFacingTriangleKHR", 167}, { "chapters/interfaces.html", 24} } },
        { {"VUID-HitTriangleVertexPositionsKHR-None-08751", 45}, { {"The acceleration structure corresponding to the current intersection must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_BIT_KHR", 152}, { "chapters/interfaces.html", 24} } },
        { {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04248", 50}, { {"The IncomingRayFlagsKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", 133}, { "chapters/interfaces.html", 24} } },
        { {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04249", 50}, { {"The variable decorated with IncomingRayFlagsKHR must be declared using the Input Storage Class", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04250", 50}, { {"The variable decorated with IncomingRayFlagsKHR must be declared as a scalar 32-bit integer value", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-IndexCountHUAWEI-IndexCountHUAWEI-07805", 44}, { {"The IndexCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-IndexCountHUAWEI-IndexCountHUAWEI-07806", 44}, { {"The variable decorated with IndexCountHUAWEI must be declared as a scalar 32-bit integer value", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceCountHUAWEI-InstanceCountHUAWEI-07807", 50}, { {"The InstanceCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", 100}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceCountHUAWEI-InstanceCountHUAWEI-07808", 50}, { {"The variable decorated with InstanceCountHUAWEI must be declared as a scalar 32-bit integer value", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04251", 56}, { {"The InstanceCustomIndexKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", 127}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04252", 56}, { {"The variable decorated with InstanceCustomIndexKHR must be declared using the Input Storage Class", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04253", 56}, { {"The variable decorated with InstanceCustomIndexKHR must be declared as a scalar 32-bit integer value", 100}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceId-InstanceId-04254", 32}, { {"The InstanceId decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", 115}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceId-InstanceId-04255", 32}, { {"The variable decorated with InstanceId must be declared using the Input Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceId-InstanceId-04256", 32}, { {"The variable decorated with InstanceId must be declared as a scalar 32-bit integer value", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceIndex-InstanceIndex-04263", 38}, { {"The InstanceIndex decoration must be used only within the Vertex Execution Model", 80}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceIndex-InstanceIndex-04264", 38}, { {"The variable decorated with InstanceIndex must be declared using the Input Storage Class", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InstanceIndex-InstanceIndex-04265", 38}, { {"The variable decorated with InstanceIndex must be declared as a scalar 32-bit integer value", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InvocationId-InvocationId-04257", 36}, { {"The InvocationId decoration must be used only within the TessellationControl or Geometry Execution Model", 104}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InvocationId-InvocationId-04258", 36}, { {"The variable decorated with InvocationId must be declared using the Input Storage Class", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InvocationId-InvocationId-04259", 36}, { {"The variable decorated with InvocationId must be declared as a scalar 32-bit integer value", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04260", 54}, { {"The InvocationsPerPixelNV decoration must be used only within the Fragment Execution Model", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04261", 54}, { {"The variable decorated with InvocationsPerPixelNV must be declared using the Input Storage Class", 96}, { "chapters/interfaces.html", 24} } },
        { {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04262", 54}, { {"The variable decorated with InvocationsPerPixelNV must be declared as a scalar 32-bit integer value", 99}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LaunchIdKHR-LaunchIdKHR-04266", 34}, { {"The LaunchIdKHR decoration must be used only within the RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", 156}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LaunchIdKHR-LaunchIdKHR-04267", 34}, { {"The variable decorated with LaunchIdKHR must be declared using the Input Storage Class", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LaunchIdKHR-LaunchIdKHR-04268", 34}, { {"The variable decorated with LaunchIdKHR must be declared as a three-component vector of 32-bit integer values", 109}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LaunchSizeKHR-LaunchSizeKHR-04269", 38}, { {"The LaunchSizeKHR decoration must be used only within the RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", 158}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LaunchSizeKHR-LaunchSizeKHR-04270", 38}, { {"The variable decorated with LaunchSizeKHR must be declared using the Input Storage Class", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LaunchSizeKHR-LaunchSizeKHR-04271", 38}, { {"The variable decorated with LaunchSizeKHR must be declared as a three-component vector of 32-bit integer values", 111}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-04272", 22}, { {"The Layer decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, Geometry, or Fragment Execution Model", 136}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-04273", 22}, { {"If the shaderOutputLayer feature is not enabled then the Layer decoration must be used only within the Geometry or Fragment Execution Model", 139}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-04274", 22}, { {"The variable decorated with Layer within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, or Geometry Execution Model must be declared using the Output Storage Class", 169}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-04275", 22}, { {"The variable decorated with Layer within the Fragment Execution Model must be declared using the Input Storage Class", 116}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-04276", 22}, { {"The variable decorated with Layer must be declared as a scalar 32-bit integer value for all supported execution models except MeshEXT", 133}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-07039", 22}, { {"The variable decorated with Layer within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", 127}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-10592", 22}, { {"Layer within the MeshEXT Execution Model must decorate a scalar 32-bit integer member of a structure decorated as Block, or decorate a variable of type OpTypeArray of scalar 32-bit integer values", 195}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-10593", 22}, { {"If Layer is declared as an array of 32-bit integer values, within the MeshEXT Execution Model, size of the array must match the value specified by OutputPrimitivesEXT", 166}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Layer-Layer-10594", 22}, { {"If Layer decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", 177}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LayerPerViewNV-LayerPerViewNV-04277", 40}, { {"The LayerPerViewNV decoration must be used only within the MeshNV Execution Model", 81}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LayerPerViewNV-LayerPerViewNV-04278", 40}, { {"The variable decorated with LayerPerViewNV must be declared using the Output Storage Class", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LayerPerViewNV-LayerPerViewNV-04279", 40}, { {"The variable decorated with LayerPerViewNV must also be decorated with the PerViewNV decoration", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LayerPerViewNV-LayerPerViewNV-04280", 40}, { {"The variable decorated with LayerPerViewNV must be declared as an array of scalar 32-bit integer values", 103}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LocalInvocationId-LocalInvocationId-04281", 46}, { {"The LocalInvocationId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", 124}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LocalInvocationId-LocalInvocationId-04282", 46}, { {"The variable decorated with LocalInvocationId must be declared using the Input Storage Class", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LocalInvocationId-LocalInvocationId-04283", 46}, { {"The variable decorated with LocalInvocationId must be declared as a three-component vector of 32-bit integer values", 115}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LocalInvocationIndex-LocalInvocationIndex-04284", 52}, { {"The LocalInvocationIndex decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", 127}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LocalInvocationIndex-LocalInvocationIndex-04285", 52}, { {"The variable decorated with LocalInvocationIndex must be declared using the Input Storage Class", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-LocalInvocationIndex-LocalInvocationIndex-04286", 52}, { {"The variable decorated with LocalInvocationIndex must be declared as a scalar 32-bit integer value", 98}, { "chapters/interfaces.html", 24} } },
        { {"VUID-MeshViewCountNV-MeshViewCountNV-04287", 42}, { {"The MeshViewCountNV decoration must be used only within the MeshNV or TaskNV Execution Model", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-MeshViewCountNV-MeshViewCountNV-04288", 42}, { {"The variable decorated with MeshViewCountNV must be declared using the Input Storage Class", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-MeshViewCountNV-MeshViewCountNV-04289", 42}, { {"The variable decorated with MeshViewCountNV must be declared as a scalar 32-bit integer value", 93}, { "chapters/interfaces.html", 24} } },
        { {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04290", 46}, { {"The MeshViewIndicesNV decoration must be used only within the MeshNV or TaskNV Execution Model", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04291", 46}, { {"The variable decorated with MeshViewIndicesNV must be declared using the Input Storage Class", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04292", 46}, { {"The variable decorated with MeshViewIndicesNV must be declared as an array of scalar 32-bit integer values", 106}, { "chapters/interfaces.html", 24} } },
        { {"VUID-NumSubgroups-NumSubgroups-04293", 36}, { {"The NumSubgroups decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", 119}, { "chapters/interfaces.html", 24} } },
        { {"VUID-NumSubgroups-NumSubgroups-04294", 36}, { {"The variable decorated with NumSubgroups must be declared using the Input Storage Class", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-NumSubgroups-NumSubgroups-04295", 36}, { {"The variable decorated with NumSubgroups must be declared as a scalar 32-bit integer value", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-NumWorkgroups-NumWorkgroups-04296", 38}, { {"The NumWorkgroups decoration must be used only within the GLCompute, MeshEXT, or TaskEXT Execution Model", 104}, { "chapters/interfaces.html", 24} } },
        { {"VUID-NumWorkgroups-NumWorkgroups-04297", 38}, { {"The variable decorated with NumWorkgroups must be declared using the Input Storage Class", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-NumWorkgroups-NumWorkgroups-04298", 38}, { {"The variable decorated with NumWorkgroups must be declared as a three-component vector of 32-bit integer values", 111}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04299", 54}, { {"The ObjectRayDirectionKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", 126}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04300", 54}, { {"The variable decorated with ObjectRayDirectionKHR must be declared using the Input Storage Class", 96}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04301", 54}, { {"The variable decorated with ObjectRayDirectionKHR must be declared as a three-component vector of 32-bit floating-point values", 126}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04302", 48}, { {"The ObjectRayOriginKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", 123}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04303", 48}, { {"The variable decorated with ObjectRayOriginKHR must be declared using the Input Storage Class", 93}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04304", 48}, { {"The variable decorated with ObjectRayOriginKHR must be declared as a three-component vector of 32-bit floating-point values", 123}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04305", 44}, { {"The ObjectToWorldKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", 121}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04306", 44}, { {"The variable decorated with ObjectToWorldKHR must be declared using the Input Storage Class", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04307", 44}, { {"The variable decorated with ObjectToWorldKHR must be declared as a matrix with four columns of three-component vectors of 32-bit floating-point values", 150}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PFN_vkDebugUtilsMessengerCallbackEXT-None-04769", 52}, { {"The callback must not make calls to any Vulkan commands", 55}, { "chapters/debugging.html", 23} } },
        { {"VUID-PatchVertices-PatchVertices-04308", 38}, { {"The PatchVertices decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", 119}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PatchVertices-PatchVertices-04309", 38}, { {"The variable decorated with PatchVertices must be declared using the Input Storage Class", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PatchVertices-PatchVertices-04310", 38}, { {"The variable decorated with PatchVertices must be declared as a scalar 32-bit integer value", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PointCoord-PointCoord-04311", 32}, { {"The PointCoord decoration must be used only within the Fragment Execution Model", 79}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PointCoord-PointCoord-04312", 32}, { {"The variable decorated with PointCoord must be declared using the Input Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PointCoord-PointCoord-04313", 32}, { {"The variable decorated with PointCoord must be declared as a two-component vector of 32-bit floating-point values", 113}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PointSize-PointSize-04314", 30}, { {"The PointSize decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", 151}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PointSize-PointSize-04315", 30}, { {"The variable decorated with PointSize within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", 139}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PointSize-PointSize-04316", 30}, { {"The variable decorated with PointSize within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", 191}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PointSize-PointSize-04317", 30}, { {"The variable decorated with PointSize must be declared as a scalar 32-bit floating-point value", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Position-Position-04318", 28}, { {"The Position decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", 150}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Position-Position-04319", 28}, { {"The variable decorated with Position within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", 138}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Position-Position-04320", 28}, { {"The variable decorated with Position within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", 190}, { "chapters/interfaces.html", 24} } },
        { {"VUID-Position-Position-04321", 28}, { {"The variable decorated with Position must be declared as a four-component vector of 32-bit floating-point values", 112}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PositionPerViewNV-PositionPerViewNV-04322", 46}, { {"The PositionPerViewNV decoration must be used only within the MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", 150}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PositionPerViewNV-PositionPerViewNV-04323", 46}, { {"The variable decorated with PositionPerViewNV within the Vertex, or MeshNV Execution Model must be declared using the Output Storage Class", 138}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PositionPerViewNV-PositionPerViewNV-04324", 46}, { {"The variable decorated with PositionPerViewNV within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", 199}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PositionPerViewNV-PositionPerViewNV-04325", 46}, { {"The variable decorated with PositionPerViewNV must be declared as an array of four-component vector of 32-bit floating-point values with at least as many elements as the maximum view in the subpass's view mask plus one", 218}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PositionPerViewNV-PositionPerViewNV-04326", 46}, { {"The array variable decorated with PositionPerViewNV must only be indexed by a constant or specialization constant", 113}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveCountNV-PrimitiveCountNV-04327", 44}, { {"The PrimitiveCountNV decoration must be used only within the MeshNV Execution Model", 83}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveCountNV-PrimitiveCountNV-04328", 44}, { {"The variable decorated with PrimitiveCountNV must be declared using the Output Storage Class", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveCountNV-PrimitiveCountNV-04329", 44}, { {"The variable decorated with PrimitiveCountNV must be declared as a scalar 32-bit integer value", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-Fragment-04331", 31}, { {"If pipeline contains both the Fragment and Geometry Execution Model and a variable decorated with PrimitiveId is read from Fragment shader, then the Geometry shader must write to the output variables decorated with PrimitiveId in all execution paths", 249}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-Fragment-04332", 31}, { {"If pipeline contains both the Fragment and MeshEXT or MeshNV Execution Model and a variable decorated with PrimitiveId is read from Fragment shader, then the MeshEXT or MeshNV shader must write to the output variables decorated with PrimitiveId in all execution paths", 267}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-Fragment-04333", 31}, { {"If Fragment Execution Model contains a variable decorated with PrimitiveId, then either the MeshShadingEXT, MeshShadingNV, Geometry or Tessellation capability must also be declared", 180}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-04330", 34}, { {"The PrimitiveId decoration must be used only within the MeshEXT, MeshNV, IntersectionKHR, AnyHitKHR, ClosestHitKHR, TessellationControl, TessellationEvaluation, Geometry, or Fragment Execution Model", 198}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-04334", 34}, { {"The variable decorated with PrimitiveId within the TessellationControl, TessellationEvaluation, Fragment, IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model must be declared using the Input Storage Class", 213}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-04335", 34}, { {"The variable decorated with PrimitiveId within the Geometry Execution Model must be declared using the Input or Output Storage Class", 132}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-04336", 34}, { {"The variable decorated with PrimitiveId within the MeshEXT or MeshNV Execution Model must be declared using the Output Storage Class", 132}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-04337", 34}, { {"The variable decorated with PrimitiveId must be declared as a scalar 32-bit integer value for all supported execution models except MeshEXT", 139}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-07040", 34}, { {"The variable decorated with PrimitiveId within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", 133}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-10595", 34}, { {"PrimitiveId within the MeshEXT Execution Model must decorate a scalar 32-bit integer member of a structure decorated as Block, or decorate a variable of type OpTypeArray of 32-bit integer values", 194}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-10596", 34}, { {"If PrimitiveId is declared as an array of 32-bit integer values, within the MeshEXT Execution Model, size of the array must match the value specified by OutputPrimitivesEXT", 172}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveId-PrimitiveId-10597", 34}, { {"If PrimitiveId decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", 183}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveIndicesNV-OutputLinesNV-04343", 43}, { {"If the Execution Mode is OutputLinesNV, then the array decorated with PrimitiveIndicesNV must be the size of two times the value specified by OutputPrimitivesNV", 160}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveIndicesNV-OutputPoints-04342", 42}, { {"If the Execution Mode is OutputPoints, then the array decorated with PrimitiveIndicesNV must be the size of the value specified by OutputPrimitivesNV", 149}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveIndicesNV-OutputTrianglesNV-04344", 47}, { {"If the Execution Mode is OutputTrianglesNV, then the array decorated with PrimitiveIndicesNV must be the size of three times the value specified by OutputPrimitivesNV", 166}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04338", 48}, { {"The PrimitiveIndicesNV decoration must be used only within the MeshNV Execution Model", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04339", 48}, { {"The variable decorated with PrimitiveIndicesNV must be declared using the Output Storage Class", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04340", 48}, { {"The variable decorated with PrimitiveIndicesNV must be declared as an array of scalar 32-bit integer values", 107}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04341", 48}, { {"All index values of the array decorated with PrimitiveIndicesNV must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", 162}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07047", 58}, { {"The PrimitiveLineIndicesEXT decoration must be used only within the MeshEXT Execution Model", 91}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07048", 58}, { {"The PrimitiveLineIndicesEXT decoration must be used with the OutputLinesEXT Execution Mode", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07049", 58}, { {"The variable decorated with PrimitiveLineIndicesEXT must be declared using the Output Storage Class", 99}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07050", 58}, { {"The variable decorated with PrimitiveLineIndicesEXT must be declared as an array of two component vector 32-bit integer values", 126}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07051", 58}, { {"The index to access the array decorated with PrimitiveLineIndicesEXT must be in the range [0, N-1], where N is the value specified by the \"Primitive Count\" operand of OpSetMeshOutputsEXT", 188}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07052", 58}, { {"The size of the array decorated with PrimitiveLineIndicesEXT must match the value specified by OutputPrimitivesEXT", 114}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-12336", 58}, { {"All index values written to the array decorated with PrimitiveLineIndicesEXT must be in the range [0, N-1], where N is the value specified by the \"Vertex Count\" operand of OpSetMeshOutputsEXT", 193}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07041", 60}, { {"The PrimitivePointIndicesEXT decoration must be used only within the MeshEXT Execution Model", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07042", 60}, { {"The PrimitivePointIndicesEXT decoration must be used with the OutputPoints Execution Mode", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07043", 60}, { {"The variable decorated with PrimitivePointIndicesEXT must be declared using the Output Storage Class", 100}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07044", 60}, { {"The variable decorated with PrimitivePointIndicesEXT must be declared as an array of scalar 32-bit integer values", 113}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07045", 60}, { {"The index to access the array decorated with PrimitivePointIndicesEXT must be in the range [0, N-1], where N is the value specified by the \"Primitive Count\" operand of OpSetMeshOutputsEXT", 189}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07046", 60}, { {"The size of the array decorated with PrimitivePointIndicesEXT must match the value specified by OutputPrimitivesEXT", 115}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-12335", 60}, { {"All index values written to the array decorated with PrimitivePointIndicesEXT must be in the range [0, N-1], where N is the value specified by the \"Vertex Count\" operand of OpSetMeshOutputsEXT", 194}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04484", 58}, { {"The PrimitiveShadingRateKHR decoration must be used only within the MeshEXT, MeshNV, Vertex, or Geometry Execution Model", 120}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04485", 58}, { {"The variable decorated with PrimitiveShadingRateKHR must be declared using the Output Storage Class", 99}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04486", 58}, { {"The variable decorated with PrimitiveShadingRateKHR must be declared as a scalar 32-bit integer value for all supported execution models except MeshEXT", 151}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04487", 58}, { {"The value written to PrimitiveShadingRateKHR must include no more than one of Vertical2Pixels and Vertical4Pixels", 113}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04488", 58}, { {"The value written to PrimitiveShadingRateKHR must include no more than one of Horizontal2Pixels and Horizontal4Pixels", 117}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04489", 58}, { {"The value written to PrimitiveShadingRateKHR must not have any bits set other than those defined by Fragment Shading Rate Flags enumerants in the SPIR-V specification", 166}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-07059", 58}, { {"The variable decorated with PrimitiveShadingRateKHR within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", 145}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-10598", 58}, { {"PrimitiveShadingRateKHR within the MeshEXT Execution Model must decorate a scalar 32-bit integer member of a structure decorated as Block, or decorate a variable of type OpTypeArray of 32-bit integer values", 206}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-10599", 58}, { {"If PrimitiveShadingRateKHR is declared as an array of 32-bit integer values, within the MeshEXT Execution Model, size of the array must match the value specified by OutputPrimitivesEXT", 184}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-10600", 58}, { {"If PrimitiveShadingRateKHR decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", 195}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-12275", 58}, { {"If PrimitiveShadingRateKHR is declared in the MeshEXT Execution Model, the primitiveFragmentShadingRateMeshShader feature must be enabled", 137}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07053", 66}, { {"The PrimitiveTriangleIndicesEXT decoration must be used only within the MeshEXT Execution Model", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07054", 66}, { {"The PrimitiveTriangleIndicesEXT decoration must be used with the OutputTrianglesEXT Execution Mode", 98}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07055", 66}, { {"The variable decorated with PrimitiveTriangleIndicesEXT must be declared using the Output Storage Class", 103}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07056", 66}, { {"The variable decorated with PrimitiveTriangleIndicesEXT must be declared as an array of three component vector 32-bit integer values", 132}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07057", 66}, { {"The index to access the array decorated with PrimitiveTriangleIndicesEXT must be in the range [0, N-1], where N is the value specified by the \"Primitive Count\" operand of OpSetMeshOutputsEXT", 192}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07058", 66}, { {"The size of the array decorated with PrimitiveTriangleIndicesEXT must match the value specified by OutputPrimitivesEXT", 118}, { "chapters/interfaces.html", 24} } },
        { {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-12337", 66}, { {"All index values written to the array decorated with PrimitiveTriangleIndicesEXT must be in the range [0, N-1], where N is the value specified by the \"Vertex Count\" operand of OpSetMeshOutputsEXT", 197}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04345", 50}, { {"The RayGeometryIndexKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", 124}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04346", 50}, { {"The variable decorated with RayGeometryIndexKHR must be declared using the Input Storage Class", 94}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04347", 50}, { {"The variable decorated with RayGeometryIndexKHR must be declared as a scalar 32-bit integer value", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayTmaxKHR-RayTmaxKHR-04348", 32}, { {"The RayTmaxKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", 124}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayTmaxKHR-RayTmaxKHR-04349", 32}, { {"The variable decorated with RayTmaxKHR must be declared using the Input Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayTmaxKHR-RayTmaxKHR-04350", 32}, { {"The variable decorated with RayTmaxKHR must be declared as a scalar 32-bit floating-point value", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayTminKHR-RayTminKHR-04351", 32}, { {"The RayTminKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", 124}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayTminKHR-RayTminKHR-04352", 32}, { {"The variable decorated with RayTminKHR must be declared using the Input Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-RayTminKHR-RayTminKHR-04353", 32}, { {"The variable decorated with RayTminKHR must be declared as a scalar 32-bit floating-point value", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ResourceHeapEXT-ResourceHeapEXT-11241", 42}, { {"The variable decorated with ResourceHeapEXT must be declared using the UniformConstant Storage Class", 100}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-RuntimeSpirv-ConstOffset-10718", 35}, { {"If an OpTypeSampledImage variable backed by an image view and sampler that require sampler Y'CBCR conversion is statically used in a shader with a sampling instruction, it must not use the ConstOffset or Offset operands", 219}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Coordinate-10713", 34}, { {"The Coordinate operand of any OpImageRead, OpImageSparseRead, OpImageWrite, OpUntypedImageTexelPointerEXT or OpImageTexelPointer instruction that consumes an OpTypeImage with an image Storage Class TileAttachmentQCOM must not result in any texels accessed outside the boundaries of the current tile, computed as described in Tile Attachments", 341}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Coordinate-10714", 34}, { {"The Coordinate operand(s) of any of the following instructions that consumes an OpTypeSampledImage with an image of Storage Class TileAttachmentQCOM must not result in any texels accessed outside boundaries of the current tile, computed as described in Tile Attachments: OpImageSample* OpImageSparseSample* OpImageFetch OpImageSparseFetch OpImage*Gather OpImageSparse*Gather OpImageSampleWeightedQCOM OpImageBoxFilterQCOM OpImageBlockMatch*QCOM", 444}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-DescriptorSet-11385", 37}, { {"If an instruction accesses memory through any resource with a DescriptorSet and Binding that are mapped using VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_DATA_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_ADDRESS_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_DATA_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_ADDRESS_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_INDIRECT_ADDRESS_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_RESOURCE_HEAP_DATA_EXT, the resource through which that memory is accessed must be determined by constant integral expressions", 519}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-DescriptorSet-11388", 37}, { {"All possible values of a variable pointer to a resource must not be resources with a DescriptorSet and Binding that are mapped using VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_DATA_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_ADDRESS_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_DATA_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_ADDRESS_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_INDIRECT_ADDRESS_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_RESOURCE_HEAP_DATA_EXT", 438}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-GraphARM-09922", 32}, { {"The GraphARM capability must not be declared in modules used to create a shader stage", 85}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Image-11379", 29}, { {"If the Image operand of OpImageTexelPointer or OpUntypedImageTexelPointerEXT is derived from a variable decorated with ResourceHeapEXT, it must correspond to accessing a descriptor matching one of the descriptor types listed in Heap Resource Type Correspondence for the OpTypeImage pointed to", 292}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Image-11380", 29}, { {"If the Image operand of OpImageTexelPointer or OpUntypedImageTexelPointerEXT is derived from a variable decorated with ResourceHeapEXT, the Image Format and Sampled Type of the OpTypeImage pointed to must correspond to a descriptor with a VkFormat that matches as described by Compatibility Between SPIR-V Image Formats and Vulkan Formats and Image Format and Type Matching", 373}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Image-11382", 29}, { {"If the Image operand of OpImageTexelPointer or OpUntypedImageTexelPointerEXT is derived from a variable decorated with ResourceHeapEXT, the operands of that OpTypeImage must correspond to a descriptor with operands that match as described by Heap Image Operand Correspondence and Heap Image View Type Dimensionality", 315}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-InputAttachmentArrayNonUniformIndexing-10138", 62}, { {"If the InputAttachmentArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through an input attachment, the input attachment through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", 264}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-LocalSizeId-06434", 35}, { {"If Execution Mode LocalSizeId is used, maintenance4 must be enabled", 67}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Location-06272", 32}, { {"The sum of Location and the number of locations the variable it decorates consumes must be less than or equal to the value for the matching Execution Model defined in Shader Input and Output Locations", 200}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Location-06428", 32}, { {"The maximum number of storage buffers, storage images, and output Location decorated color attachments written to in the Fragment Execution Model must be less than or equal to maxFragmentCombinedOutputResources", 210}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MaximallyReconvergesKHR-09565", 47}, { {"The execution mode MaximallyReconvergesKHR must not be applied to an entry point unless the entry point does not execute any invocation repack instructions", 155}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07115", 31}, { {"For mesh shaders using the MeshEXT Execution Model the OutputVertices OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshOutputVertices", 178}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07116", 31}, { {"For mesh shaders using the MeshEXT Execution Model the OutputPrimitivesEXT OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshOutputPrimitives", 185}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07118", 31}, { {"In mesh shaders using the MeshEXT Execution Model OpSetMeshOutputsEXT must be called at most once under dynamically uniform conditions", 134}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07295", 31}, { {"For mesh shaders using the MeshEXT Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[0]", 184}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07296", 31}, { {"For mesh shaders using the MeshEXT Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[1]", 184}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07297", 31}, { {"For mesh shaders using the MeshEXT Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[2]", 184}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07298", 31}, { {"For mesh shaders using the MeshEXT Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupInvocations", 219}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07332", 31}, { {"For mesh shaders using the MeshEXT Execution Model the \"Vertex Count\" operand of OpSetMeshOutputsEXT must be less than or equal to OutputVertices OpExecutionMode", 163}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-07333", 31}, { {"For mesh shaders using the MeshEXT Execution Model the \"Primitive Count\" operand of OpSetMeshOutputsEXT must be less than or equal to OutputPrimitivesEXT OpExecutionMode", 171}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-09218", 31}, { {"In mesh shaders using the MeshEXT or MeshNV Execution Model and the OutputPoints Execution Mode, if the maintenance5 feature is not enabled, and if the number of output points is greater than 0, a PointSize decorated variable must be written to for each output point", 266}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-10883", 31}, { {"If the MeshEXT Execution Model declares a variable with the TaskPayloadWorkgroupEXT Storage Class in the entry point, there must be a matching TaskPayloadWorkgroupEXT Storage Class variable in the TaskEXT Execution Model passed as an argument to OpEmitMeshTasksEXT", 264}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshEXT-12333", 31}, { {"For mesh shaders using the MeshEXT Execution Model the index into the array of any variable decorated with the PerPrimitiveEXT decoration must be less than the \"Primitive Count\" operand of OpSetMeshOutputsEXT", 210}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshNV-07113", 30}, { {"For mesh shaders using the MeshNV Execution Model the OutputVertices OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputVertices", 176}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-MeshNV-07114", 30}, { {"For mesh shaders using the MeshNV Execution Model the OutputPrimitivesNV OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputPrimitives", 182}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-NodePayloadAMDX-09192", 39}, { {"Variables in the NodePayloadAMDX storage class must only be declared in the GLCompute or MeshEXT execution model", 112}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-NonWritable-06340", 35}, { {"If the fragmentStoresAndAtomics feature is not enabled, then all storage image, storage texel buffer, and storage buffer variables in the fragment stage must be decorated with the NonWritable decoration", 202}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-NonWritable-06341", 35}, { {"If the vertexPipelineStoresAndAtomics feature is not enabled, then all storage image, storage texel buffer, and storage buffer variables in the vertex, tessellation, and geometry stages must be decorated with the NonWritable decoration", 235}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06275", 28}, { {"shaderSubgroupExtendedTypes must be enabled for group operations to use 8-bit integer, 16-bit integer, 64-bit integer, 16-bit floating-point, and vectors of these types", 168}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06278", 28}, { {"shaderBufferInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of StorageBuffer or Uniform", 155}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06279", 28}, { {"shaderSharedInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of Workgroup", 140}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06284", 28}, { {"shaderBufferFloat32Atomics, or shaderBufferFloat32AtomicAdd, or shaderBufferFloat64Atomics, or shaderBufferFloat64AtomicAdd, or shaderBufferFloat16Atomics, or shaderBufferFloat16AtomicAdd, or shaderBufferFloat16AtomicMinMax, or shaderBufferFloat32AtomicMinMax, or shaderBufferFloat64AtomicMinMax, or shaderFloat16VectorAtomics must be enabled for floating-point atomic operations to be supported on a Pointer with a Storage Class of StorageBuffer", 446}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06285", 28}, { {"shaderSharedFloat32Atomics, or shaderSharedFloat32AtomicAdd, or shaderSharedFloat64Atomics, or shaderSharedFloat64AtomicAdd, or shaderSharedFloat16Atomics, or shaderSharedFloat16AtomicAdd, or shaderSharedFloat16AtomicMinMax, or shaderSharedFloat32AtomicMinMax, or shaderSharedFloat64AtomicMinMax, or shaderFloat16VectorAtomics, must be enabled for floating-point atomic operations to be supported on a Pointer with a Storage Class of Workgroup", 443}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06286", 28}, { {"shaderImageFloat32Atomics, or shaderImageFloat32AtomicAdd, or shaderImageFloat32AtomicMinMax, must be enabled for 32-bit floating-point atomic operations to be supported on a Pointer with a Storage Class of Image", 212}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06287", 28}, { {"sparseImageFloat32Atomics, or sparseImageFloat32AtomicAdd, or sparseImageFloat32AtomicMinMax, must be enabled for 32-bit floating-point atomics to be supported on sparse images", 176}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06288", 28}, { {"shaderImageInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of Image", 135}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06337", 28}, { {"shaderBufferFloat16Atomics, or shaderBufferFloat16AtomicAdd, or shaderBufferFloat16AtomicMinMax, or shaderSharedFloat16Atomics, or shaderSharedFloat16AtomicAdd, or shaderSharedFloat16AtomicMinMax must be enabled for 16-bit floating-point atomic operations", 255}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06338", 28}, { {"shaderBufferFloat32Atomics, or shaderBufferFloat32AtomicAdd, or shaderSharedFloat32Atomics, or shaderSharedFloat32AtomicAdd, or shaderImageFloat32Atomics, or shaderImageFloat32AtomicAdd or shaderBufferFloat32AtomicMinMax, or shaderSharedFloat32AtomicMinMax, or shaderImageFloat32AtomicMinMax must be enabled for 32-bit floating-point atomic operations", 351}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06339", 28}, { {"shaderBufferFloat64Atomics, or shaderBufferFloat64AtomicAdd, or shaderSharedFloat64Atomics, or shaderSharedFloat64AtomicAdd, or shaderBufferFloat64AtomicMinMax, or shaderSharedFloat64AtomicMinMax, must be enabled for 64-bit floating-point atomic operations", 256}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06342", 28}, { {"If subgroupQuadOperationsInAllStages is VK_FALSE, then quad subgroup operations must not be used except for in fragment and compute stages", 138}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-06343", 28}, { {"Group operations with subgroup scope must not be used if the shader stage is not in subgroupSupportedStages", 107}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-09558", 28}, { {"If the dynamicRenderingLocalRead feature is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Dim\" operand of SubpassData must be decorated with InputAttachmentIndex", 194}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-10148", 28}, { {"If an instruction accesses memory through any resource, the effective subgroup size is 1, the DescriptorHeapEXT capability is not declared, and the resource through which that memory is accessed is not uniform within the invocation group, then the operand corresponding to that resource (e.g. the pointer or sampled image operand) must be decorated with NonUniform", 364}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-10824", 28}, { {"If the maintenance9 feature is not enabled, the Base operand of any OpBitCount, OpBitReverse, OpBitFieldInsert, OpBitFieldSExtract, or OpBitFieldUExtract instruction must be a 32-bit integer scalar or a vector of 32-bit integers", 228}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-10834", 28}, { {"Buffer indexing calculations must not wrap 32 bits if the pipeline or shader was not created with the VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT or VK_SHADER_CREATE_64_BIT_INDEXING_BIT_EXT flags and the entry point does not set the Shader64BitIndexingEXT execution mode", 271}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-10980", 28}, { {"Objects containing 8-bit integer or 8-bit floating-point elements must not have storage class of Input or Output", 112}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-12205", 28}, { {"If an image view or sampler that requires sampler Y'CBCR conversion is accessed in a shader, it must be determined by constant integral expressions", 147}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-None-12295", 28}, { {"If the longVector feature is not enabled, the Component Count of any vector type must be less than or equal to 4 and greater than 1", 131}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Offset-06308", 30}, { {"The Offset plus size of the type of each variable, in the output interface of the entry point being compiled, decorated with XfbBuffer must not be greater than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackBufferDataSize", 242}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Offset-06344", 30}, { {"The first element of the Offset operand of InterpolateAtOffset must be greater than or equal to: fragwidth x minInterpolationOffset where fragwidth is the width of the current fragment in pixels", 194}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Offset-06345", 30}, { {"The first element of the Offset operand of InterpolateAtOffset must be less than or equal to fragwidth x (maxInterpolationOffset + ULP ) - ULP where fragwidth is the width of the current fragment in pixels and ULP = 1 / 2^subPixelInterpolationOffsetBits^", 254}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Offset-06346", 30}, { {"The second element of the Offset operand of InterpolateAtOffset must be greater than or equal to fragheight x minInterpolationOffset where fragheight is the height of the current fragment in pixels", 197}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Offset-06347", 30}, { {"The second element of the Offset operand of InterpolateAtOffset must be less than or equal to fragheight x (maxInterpolationOffset + ULP ) - ULP where fragheight is the height of the current fragment in pixels and ULP = 1 / 2^subPixelInterpolationOffsetBits^", 258}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Offset-10213", 30}, { {"If the maintenance8 feature is not enabled, image operand Offset must only be used with OpImage*Gather instructions", 115}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpArrayLength-11807", 37}, { {"OpArrayLength and OpUntypedArrayLengthKHR result type must be a 32-bit integer type if the pipeline or shader was not compiled with the VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT or VK_SHADER_CREATE_64_BIT_INDEXING_BIT_EXT flags and the entry point does not set the Shader64BitIndexingEXT execution mode", 305}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpConstantSizeOfEXT-11475", 43}, { {"The result type of OpConstantSizeOfEXT must not be a 64-bit integer type if the pipeline or shader was not compiled with the VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT or VK_SHADER_CREATE_64_BIT_INDEXING_BIT_EXT flags and the entry point does not set the Shader64BitIndexingEXT execution mode", 294}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeMatrixLoadKHR-08986", 50}, { {"For OpCooperativeMatrixLoadKHR and OpCooperativeMatrixStoreKHR instructions, the Pointer and Stride operands must be aligned to at least the lesser of 16 bytes or the natural alignment of a row or column (depending on ColumnMajor) of the matrix (where the natural alignment is the number of columns/rows multiplied by the component size)", 337}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeMatrixLoadNV-06324", 49}, { {"For OpCooperativeMatrixLoadNV and OpCooperativeMatrixStoreNV instructions, the Pointer and Stride operands must be aligned to at least the lesser of 16 bytes or the natural alignment of a row or column (depending on ColumnMajor) of the matrix (where the natural alignment is the number of columns/rows multiplied by the component size)", 335}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeMatrixMulAddKHR-10060", 52}, { {"For OpCooperativeMatrixMulAddKHR, the operands must match a supported VkCooperativeMatrixPropertiesKHR", 102}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorLoadNV-10099", 49}, { {"For OpCooperativeVectorLoadNV and OpCooperativeVectorStoreNV instructions, the Pointer and Offset must be aligned to 16 bytes", 125}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorLoadNV-11809", 49}, { {"OpCooperativeVectorLoadNV, OpCooperativeVectorStoreNV, OpCooperativeVectorOuterProductAccumulateNV, and OpCooperativeVectorReduceSumAccumulateNV Offset parameters must be 32-bit integer types if the pipeline or shader was not compiled with the VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT or VK_SHADER_CREATE_64_BIT_INDEXING_BIT_EXT flags and the entry point does not set the Shader64BitIndexingEXT execution mode", 413}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulAddNV-10098", 57}, { {"For OpCooperativeVectorMatrixMulAddNV instructions, the Bias and BiasOffset must be aligned to 16 bytes", 103}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulAddNV-11808", 57}, { {"OpCooperativeVectorMatrixMulAddNV and OpCooperativeVectorMatrixMulNV MatrixOffset and BiasOffset parameters must be 32-bit integer types if the pipeline or shader was not compiled with the VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT or VK_SHADER_CREATE_64_BIT_INDEXING_BIT_EXT flags and the entry point does not set the Shader64BitIndexingEXT execution mode", 358}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulNV-10089", 54}, { {"For OpCooperativeVectorMatrixMulNV and OpCooperativeVectorMatrixMulAddNV, the following must be satisfied by the same entry in the VkCooperativeVectorPropertiesNV array returned by vkGetPhysicalDeviceCooperativeVectorPropertiesNV: The component type of Input must match VkCooperativeVectorPropertiesNV::inputType The InputInterpretation must match VkCooperativeVectorPropertiesNV::inputInterpretation The MatrixInterpretation must match VkCooperativeVectorPropertiesNV::matrixInterpretation For OpCooperativeVectorMatrixMulAddNV, the BiasInterpretation must match VkCooperativeVectorPropertiesNV::biasInterpretation The Result Type must match VkCooperativeVectorPropertiesNV::resultType If Transpose is true, VkCooperativeVectorPropertiesNV::transpose must be VK_TRUE", 767}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulNV-10090", 54}, { {"For OpCooperativeVectorMatrixMulNV and OpCooperativeVectorMatrixMulAddNV, if MatrixInterpretation is either VK_COMPONENT_TYPE_FLOAT_E4M3_NV or VK_COMPONENT_TYPE_FLOAT_E5M2_NV then MemoryLayout must be either VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_INFERENCING_OPTIMAL_NV or VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_TRAINING_OPTIMAL_NV", 325}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulNV-10096", 54}, { {"For OpCooperativeVectorMatrixMulNV and OpCooperativeVectorMatrixMulAddNV instructions using non-optimal layouts, the Stride operand must be aligned to 16 bytes", 159}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulNV-10097", 54}, { {"For OpCooperativeVectorMatrixMulNV and OpCooperativeVectorMatrixMulAddNV instructions, the Matrix and MatrixOffset must be aligned to 64 bytes", 142}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorOuterProductAccumulateNV-10093", 67}, { {"For OpCooperativeVectorOuterProductAccumulateNV: MatrixInterpretation must be VK_COMPONENT_TYPE_FLOAT16_KHR or VK_COMPONENT_TYPE_FLOAT32_KHR If MatrixInterpretation is VK_COMPONENT_TYPE_FLOAT16_KHR, cooperativeVectorTrainingFloat16Accumulation must be supported If MatrixInterpretation is VK_COMPONENT_TYPE_FLOAT32_KHR, cooperativeVectorTrainingFloat32Accumulation must be supported The component types of A and B must be 16-bit floating-point The matrix layout must be training-optimal The pointer's storage class must be StorageBuffer or PhysicalStorageBuffer", 561}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorOuterProductAccumulateNV-10101", 67}, { {"For OpCooperativeVectorOuterProductAccumulateNV instructions, the Pointer and Offset must be aligned to 64 bytes", 112}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorReduceSumAccumulateNV-10092", 64}, { {"For OpCooperativeVectorReduceSumAccumulateNV: The component type of V must be either 16- or 32-bit floating-point If the component type of V is 16-bit floating-point, cooperativeVectorTrainingFloat16Accumulation must be supported If the component type of V is 32-bit floating-point, cooperativeVectorTrainingFloat32Accumulation must be supported The pointer's storage class must be StorageBuffer or PhysicalStorageBuffer", 420}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpCooperativeVectorReduceSumAccumulateNV-10100", 64}, { {"For OpCooperativeVectorReduceSumAccumulateNV instructions, the Pointer and Offset must be aligned to 16 bytes", 109}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpEmitStreamVertex-06310", 42}, { {"The Stream value to OpEmitStreamVertex and OpEndStreamPrimitive must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams", 157}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpEntryPoint-07754", 36}, { {"Any user-defined variables between the OpEntryPoint of two shader stages must have the same type and width for each Component", 125}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpEntryPoint-08727", 36}, { {"Each OpEntryPoint must not have more than one variable decorated with InputAttachmentIndex per image aspect of the attachment image bound to it, either explicitly or implicitly as described by input attachment interface", 219}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpEntryPoint-08743", 36}, { {"Any user-defined variables shared between the OpEntryPoint of two shader stages, and declared with Input as its Storage Class for the subsequent shader stage, must have all Location slots and Component words declared in the preceding shader stage's OpEntryPoint with Output as the Storage Class", 294}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11878", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", 244}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11879", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", 225}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11880", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, the RayTmin operand must be less than or equal to the RayTmax operand", 219}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11881", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", 226}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11882", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions the time operand must be between 0.0 and 1.0", 193}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11883", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", 226}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11884", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", 282}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11885", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", 263}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11886", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, if the Rayflags operand contains SkipTrianglesKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR set", 299}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayEXT-11887", 46}, { {"For OpHitObjectTraceRayEXT, OpHitObjectTraceRayMotionEXT, OpHitObjectTraceMotionReorderExecuteEXT and OpHitObjectTraceReorderExecuteEXT instructions, if the Rayflags operand contains SkipAABBsKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR set", 299}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionEXT-11877", 52}, { {"For OpHitObjectTraceRayMotionEXT and OpHitObjectTraceMotionReorderExecuteEXT instructions, the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", 186}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07704", 51}, { {"For OpHitObjectTraceRayMotionNV instructions, if Acceleration Structure was built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags, the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", 238}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07709", 51}, { {"For OpHitObjectTraceRayMotionNV instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", 206}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07711", 51}, { {"For OpHitObjectTraceRayMotionNV instructions the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", 140}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07705", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", 166}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07706", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", 147}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07707", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the RayTmin operand must be less than or equal to the RayTmax operand", 141}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07708", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", 148}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07710", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions the time operand must be between 0.0 and 1.0", 115}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07712", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", 148}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07713", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", 204}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07714", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", 185}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07715", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, if the Rayflags operand contains SkipTrianglesKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR set", 221}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07716", 45}, { {"For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, if the Rayflags operand contains SkipAABBsKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR set", 221}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImage-06376", 31}, { {"If an OpImage*Gather operation has an image operand of Offset, ConstOffset, or ConstOffsets the offset value must be greater than or equal to minTexelGatherOffset", 162}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImage-06377", 31}, { {"If an OpImage*Gather operation has an image operand of Offset, ConstOffset, or ConstOffsets the offset value must be less than or equal to maxTexelGatherOffset", 159}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImage-10706", 31}, { {"An OpImage with Storage Class TileAttachmentQCOM must not be consumed by OpImageTexelPointer or OpUntypedImageTexelPointerEXT unless the tileShadingAtomicOps feature is enabled", 176}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchSADQCOM-06982", 48}, { {"If an OpImageBlockMatchSADQCOM or OpImageBlockMatchSSDQCOM operation is used, then the target sampled image, reference sampled image, and Block Size parameters must both be dynamically uniform for the quad", 205}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06983", 48}, { {"If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must be of storage class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=0, MS=0, and Sampled=1", 257}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06984", 48}, { {"If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then the target sampled image and reference sampled image parameters must be decorated with BlockMatchTextureQCOM", 191}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06985", 48}, { {"If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created using an identical sampler object", 199}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06986", 48}, { {"If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", 233}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06987", 48}, { {"If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", 233}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06988", 48}, { {"If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then Block Size less than or equal to maxBlockMatchRegion", 135}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09219", 47}, { {"If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then the target sampled image, reference sampled image, and Block Size parameters must both be dynamically uniform for the quad", 212}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09220", 47}, { {"If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must be of storage class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=0, MS=0, and Sampled=1", 264}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09221", 47}, { {"If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then the target sampled image and reference sampled image parameters must be decorated with BlockMatchTextureQCOM", 198}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09222", 47}, { {"If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created using an identical sampler object", 206}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09223", 47}, { {"If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", 240}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09224", 47}, { {"If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created with sampler object with unnormalizedCoordinates equal to VK_TRUE", 238}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBoxFilterQCOM-06989", 44}, { {"If an OpImageBoxFilterQCOM operation is used, then Box Size.y must be equal to or greater than 1.0 and less than or equal to maxBoxFilterBlockSize.height", 153}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageBoxFilterQCOM-06990", 44}, { {"If an OpImageBoxFilterQCOM operation is used, then Sampled Texture Image and Box Size parameters must be dynamically uniform", 124}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageSample-06435", 37}, { {"If an OpImageSample* or OpImageFetch* operation has an image operand of Offset or ConstOffset then the offset value must be greater than or equal to minTexelOffset", 163}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageSample-06436", 37}, { {"If an OpImageSample* or OpImageFetch* operation has an image operand of Offset or ConstOffset then the offset value must be less than or equal to maxTexelOffset", 160}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageSampleWeightedQCOM-06979", 49}, { {"If an OpImageSampleWeightedQCOM operation is used, then the Texture Sampled Image and Weight Image parameters must both be dynamically uniform for the quad", 155}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageSampleWeightedQCOM-06980", 49}, { {"If an OpImageSampleWeightedQCOM operation is used, then the Weight Image parameter must be of Storage Class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=1, MS=0, and Sampled=1", 197}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageSampleWeightedQCOM-06981", 49}, { {"If an OpImageSampleWeightedQCOM operation is used, then the Weight Image parameter must be decorated with WeightTextureQCOM", 123}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpImageWrite-07112", 36}, { {"OpImageWrite to any Image whose Image Format is not Unknown must have the Texel operand contain at least as many components as the corresponding VkFormat as given in the SPIR-V Image Format compatibility table", 209}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryGenerateIntersectionKHR-06353", 57}, { {"For OpRayQueryGenerateIntersectionKHR instructions, Hit T must satisfy the condition RayTmin <= Hit T <= RayTmax, where RayTmin is equal to the value returned by OpRayQueryGetRayTMinKHR with the same ray query object, and RayTmax is equal to the value of OpRayQueryGetIntersectionTKHR for the current committed intersection with the same ray query object", 354}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryGenerateIntersectionKHR-06354", 57}, { {"For OpRayQueryGenerateIntersectionKHR instructions, Acceleration Structure must not be built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", 152}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06348", 47}, { {"For OpRayQueryInitializeKHR instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", 136}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06349", 47}, { {"For OpRayQueryInitializeKHR instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", 117}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06350", 47}, { {"For OpRayQueryInitializeKHR instructions, the RayTmin operand must be less than or equal to the RayTmax operand", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06351", 47}, { {"For OpRayQueryInitializeKHR instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", 118}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06352", 47}, { {"For OpRayQueryInitializeKHR instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure", 142}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06889", 47}, { {"For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", 118}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06890", 47}, { {"For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", 174}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06891", 47}, { {"For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", 155}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpReportIntersectionKHR-06998", 47}, { {"The value of the \"Hit Kind\" operand of OpReportIntersectionKHR must be in the range [0,127]", 93}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06355", 37}, { {"For OpTraceRayKHR instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", 126}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06356", 37}, { {"For OpTraceRayKHR instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", 107}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06357", 37}, { {"For OpTraceRayKHR instructions, the RayTmin operand must be less than or equal to the RayTmax operand", 101}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06358", 37}, { {"For OpTraceRayKHR instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", 108}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06359", 37}, { {"For OpTraceRayKHR instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure", 132}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06360", 37}, { {"For OpTraceRayKHR instructions, if Acceleration Structure was built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags, the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", 224}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06552", 37}, { {"For OpTraceRayKHR instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", 108}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06553", 37}, { {"For OpTraceRayKHR instructions, if the Rayflags operand contains SkipTrianglesKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR set", 181}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06554", 37}, { {"For OpTraceRayKHR instructions, if the Rayflags operand contains SkipAABBsKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR set", 181}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06892", 37}, { {"For OpTraceRayKHR instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", 164}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-06893", 37}, { {"For OpTraceRayKHR instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", 145}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayKHR-11855", 37}, { {"For modules which contain OpTraceRayKHR or OpTraceRayMotionNV instructions that declare a variable in the RayPayloadKHR Storage Class, all shaders which may be invoked as part of that shader call must declare an identical variable in the IncomingRayPayloadKHR Storage Class", 273}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06361", 42}, { {"For OpTraceRayMotionNV instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", 131}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06362", 42}, { {"For OpTraceRayMotionNV instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", 112}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06363", 42}, { {"For OpTraceRayMotionNV instructions, the RayTmin operand must be less than or equal to the RayTmax operand", 106}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06364", 42}, { {"For OpTraceRayMotionNV instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06365", 42}, { {"For OpTraceRayMotionNV instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", 197}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06366", 42}, { {"For OpTraceRayMotionNV instructions the time operand must be between 0.0 and 1.0", 80}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06367", 42}, { {"For OpTraceRayMotionNV instructions the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", 131}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixKHR-10163", 50}, { {"For OpTypeCooperativeMatrixKHR, if the cooperativeMatrixFlexibleDimensions feature is not enabled, the component type, scope, number of rows, and number of columns must match one of the matrices in any of the supported VkCooperativeMatrixPropertiesKHR", 251}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixKHR-10770", 50}, { {"Any pipeline containing a shader with OpTypeCooperativeMatrixKHR or OpCooperativeMatrix*KHR instructions must be created with the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT flag or the shader module must be version 1.6 or greater", 245}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixKHR-10771", 50}, { {"Any shader object containing OpTypeCooperativeMatrixKHR or OpCooperativeMatrix*KHR instructions must be created with the VK_SHADER_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT flag or the shader module must be version 1.6 or greater", 225}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixMulAddNV-10059", 55}, { {"For OpTypeCooperativeMatrixMulAddNV, the operands must match a supported VkCooperativeMatrixPropertiesNV", 104}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixNV-06316", 49}, { {"For OpTypeCooperativeMatrixNV, the component type, scope, number of rows, and number of columns must match one of the matrices in any of the supported VkCooperativeMatrixPropertiesNV", 182}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixNV-06322", 49}, { {"OpTypeCooperativeMatrixNV and OpCooperativeMatrix* instructions must not be used in shader stages not included in VkPhysicalDeviceCooperativeMatrixPropertiesNV::cooperativeMatrixSupportedStages", 193}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeCooperativeVector-10095", 47}, { {"OpTypeCooperativeVector instructions must have Component Type that is any supported type reported by vkGetPhysicalDeviceCooperativeVectorPropertiesNV", 149}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeImage-09644", 35}, { {"Any variable declared as an OpTypeArray where the Element Type is an OpTypeImage with a \"Dim\" operand of SubpassData must be decorated with InputAttachmentIndex", 162}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeImage-10707", 35}, { {"An OpTypeImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to the color attachment of the current subpass instance unless the tileShadingColorAttachments feature is enabled", 206}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeImage-10708", 35}, { {"An OpTypeImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to the depth aspect of the depth/stencil attachment of the current subpass instance unless the tileShadingDepthAttachments", 215}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeImage-10709", 35}, { {"An OpTypeImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to the stencil aspect of the depth/stencil attachment of the current subpass instance unless the tileShadingStencilAttachments feature is enabled", 238}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeImage-10710", 35}, { {"An OpTypeImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to the input attachment of the current subpass instance unless the tileShadingInputAttachments feature is enabled", 206}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeImage-12204", 35}, { {"If a variable with type OpTypeImage is declared in the Shader Resource Interface, it must not be backed by an image view that requires sampler Y'CBCR conversion", 160}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeImage-12207", 35}, { {"If a OpTypeImage variable backed by an image view that requires sampler Y'CBCR conversion is statically used in a shader, it must only be used with OpImageQueryLevels or OpImageQuerySizeLod instructions", 202}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeSampledImage-10711", 42}, { {"An OpTypeSampledImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to an attachment of the current subpass instance unless the tileShadingSampledAttachments feature is enabled", 208}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeSampledImage-12206", 42}, { {"If an OpTypeSampledImage variable backed by an image view and sampler that require sampler Y'CBCR conversion is statically used in a shader, it must only be used with OpImageSample*, OpImageSparseSample*, or OpImage instructions", 228}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeSampledImage-12208", 42}, { {"If an OpTypeSampledImage variable backed by an image view and sampler that require sampler Y'CBCR conversion is statically used in a shader, the image view and sampler must have been created with an identically defined VkSamplerYcbcrConversion set via VkSamplerYcbcrConversionInfo", 280}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeSampler-12203", 37}, { {"If a variable with type OpTypeSampler is declared in the Shader Resource Interface, it must not be backed by a sampler that requires sampler Y'CBCR conversion", 158}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeTensorARM-09902", 39}, { {"OpTypeTensorARM with a Shape must not be used in shader stages", 62}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeTensorARM-09907", 39}, { {"OpTypeTensorARM without a Rank must not be used in shader stages", 64}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpTypeUntypedPointerKHR-11166", 47}, { {"Any memory access made using an OpTypeUntypedPointerKHR must have an alignment that satisfies Offset and Stride Assignment", 122}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-OpVariable-08746", 34}, { {"Any variable, Block-decorated OpTypeStruct, or Block-decorated OpTypeStruct members shared between the OpEntryPoint of two shader stages must have matching decorations as defined in interface matching", 200}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-PhysicalStorageBuffer64-06315", 47}, { {"If the PhysicalStorageBuffer64 addressing model is enabled the pointer value of a memory access instruction must be at least as aligned as specified by the Aligned memory access operand", 185}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-PhysicalStorageBuffer64-11819", 47}, { {"If the PhysicalStorageBuffer64 addressing model is enabled the pointer value of a memory access instruction in the PhysicalStorageBuffer Storage Class must reference a buffer created with the VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT usage flag set", 248}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Result-11340", 30}, { {"If the Result Type operand of OpLoad is OpTypeSampler, and Pointer is derived from a variable decorated with SamplerHeapEXT, it must correspond to loading a descriptor matching one of the descriptor types listed in Heap Resource Type Correspondence for OpTypeSampler", 266}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Result-11341", 30}, { {"If the Result Type operand of OpLoad is OpTypeImage, and Pointer is derived from a variable decorated with ResourceHeapEXT, it must correspond to loading a descriptor matching one of the descriptor types listed in Heap Resource Type Correspondence for OpTypeImage", 263}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Result-11342", 30}, { {"The Buffer operand of OpBufferPointerEXT must correspond to accessing a descriptor matching one of the descriptor types listed in Heap Resource Type Correspondence for OpTypePointer", 181}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Result-11343", 30}, { {"If the Result Type operand of OpLoad is OpTypeImage, and Pointer is derived from a variable decorated with ResourceHeapEXT, the Image Format and Sampled Type of that OpTypeImage must correspond to a descriptor with a VkFormat that matches as described by Compatibility Between SPIR-V Image Formats and Vulkan Formats and Image Format and Type Matching Between SPIR-V Image Formats and Vulkan Formats>>", 401}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Result-11345", 30}, { {"If the Result Type operand of OpLoad is OpTypeImage, and Pointer is derived from a variable decorated with ResourceHeapEXT, the operands of that OpTypeImage must correspond to a descriptor with operands that match as described by Heap Image Operand Correspondence and Heap Image View Type Dimensionality", 303}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Result-11350", 30}, { {"If the Result Type operand of OpLoad is OpTypeAccelerationStructureKHR and Pointer is derived from a variable decorated with ResourceHeapEXT, it must be at an offset from the base that is a multiple of bufferDescriptorAlignment", 227}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-SampleRateShading-06378", 41}, { {"If the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_EXT, then the SPIR-V fragment shader Capability SampleRateShading must not be enabled", 164}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-SampledImageArrayNonUniformIndexing-10135", 59}, { {"If the SampledImageArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a sampled image or sampler, the sampled image or sampler through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", 276}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-ShaderEnqueueAMDX-09191", 41}, { {"The ShaderEnqueueAMDX capability must only be used in shaders with the GLCompute or MeshEXT execution model", 107}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Size-11165", 28}, { {"The Size operand of OpCopyMemorySized must be a multiple of 4 If 16-bit storage is enabled for the storage classes of both the Target and Source operands the Size operand may instead be a multiple of 2 If 8-bit storage is enabled for the storage classes of both the Target and Source operands the Size operand may instead be any value", 334}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-StorageBufferArrayNonUniformIndexing-10136", 60}, { {"If the StorageBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage buffer, the storage buffer through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", 257}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-StorageImageArrayNonUniformIndexing-10137", 59}, { {"If the StorageImageArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage image, the storage image through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", 254}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-StorageTexelBufferArrayNonUniformIndexing-10140", 65}, { {"If the StorageTexelBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage texel buffer, the storage texel buffer through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", 274}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Stream-06312", 30}, { {"The stream number value to Stream must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams", 127}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-SubgroupUniformControlFlowKHR-06379", 53}, { {"The Execution Mode SubgroupUniformControlFlowKHR must not be applied to an entry point unless the shaderSubgroupUniformControlFlow feature is enabled, the corresponding shader stage bit is set in subgroupSupportedStages, and the entry point does not execute any invocation repack instructions", 292}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07117", 31}, { {"In task shaders using the TaskEXT Execution Model OpEmitMeshTasksEXT must be called exactly once under dynamically uniform conditions", 133}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07291", 31}, { {"In task shaders using the TaskEXT Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[0]", 183}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07292", 31}, { {"In task shaders using the TaskEXT Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[1]", 183}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07293", 31}, { {"In task shaders using the TaskEXT Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[2]", 183}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07294", 31}, { {"In task shaders using the TaskEXT Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupInvocations", 218}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07299", 31}, { {"In task shaders using the TaskEXT Execution Model the value of the \"Group Count X\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[0]", 210}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07300", 31}, { {"In task shaders using the TaskEXT Execution Model the value of the \"Group Count Y\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[1]", 210}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07301", 31}, { {"In task shaders using the TaskEXT Execution Model the value of the \"Group Count Z\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[2]", 210}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TaskEXT-07302", 31}, { {"In task shaders using the TaskEXT Execution Model the product of the \"Group Count\" operands of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupTotalCount", 213}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TileShadingQCOM-10698", 39}, { {"TileShadingQCOM capability must not be declared in the compute stage unless the tileShading feature is enabled", 110}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TileShadingQCOM-10699", 39}, { {"The TileShadingQCOM capability must not be declared in the fragment stage unless the tileShadingFragmentStage feature is enabled", 128}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TileShadingQCOM-10700", 39}, { {"A shader that enables SPIR-V capability TileShadingQCOM must not be invoked outside a tile shading render pass", 110}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-TileShadingQCOM-10701", 39}, { {"A compute shader that enables SPIR-V capability TileShadingQCOM must only be invoked inside those portions of a command buffer where per-tile execution model is enabled", 168}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Type-12297", 28}, { {"Any pointer type whose Type parameter is a vector type with more than four components (or an aggregate containing such a type) must have Storage Class of Function, Private, Uniform, Workgroup, StorageBuffer, PhysicalStorageBuffer, PushConstant, or ShaderRecordBufferKHR.", 270}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-UniformBufferArrayNonUniformIndexing-10134", 60}, { {"If the UniformBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a uniform buffer, the uniform buffer through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", 257}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-UniformTexelBufferArrayNonUniformIndexing-10139", 65}, { {"If the UniformTexelBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a uniform texel buffer, the uniform texel buffer through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", 274}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-Workgroup-06530", 33}, { {"The sum of size in bytes for variables and padding in the Workgroup Storage Class in the GLCompute Execution Model must be less than or equal to maxComputeSharedMemorySize", 171}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-XfbBuffer-06309", 33}, { {"For any given XfbBuffer value, define the buffer data size to be smallest number of bytes such that, for all outputs decorated with the same XfbBuffer value, the size of the output interface variable plus the Offset is less than or equal to the buffer data size. For a given Stream, the sum of all the buffer data sizes for all buffers writing to that stream the must not exceed VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreamDataSize", 461}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-XfbStride-06313", 33}, { {"The XFB Stride value to XfbStride must be less than or equal to VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackBufferDataStride", 148}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-apiVersion-07954", 34}, { {"If VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.3, the VK_KHR_format_feature_flags2 extension is not supported, and the shaderStorageImageWriteWithoutFormat feature is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Sampled\" operand of 2 and an \"Image Format\" operand of Unknown must be decorated with NonWritable", 362}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-apiVersion-07955", 34}, { {"If VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.3, the VK_KHR_format_feature_flags2 extension is not supported, and the shaderStorageImageReadWithoutFormat feature is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Sampled\" operand of 2 and an \"Image Format\" operand of Unknown must be decorated with NonReadable", 361}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-bufferDescriptorAlignment-11384", 49}, { {"The Buffer operand of OpBufferPointerEXT must be at an offset from the base of the ResourceHeapEXT that is a multiple of bufferDescriptorAlignment", 146}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-bufferDescriptorAlignment-11478", 49}, { {"If a OpTypeBufferEXT member of a struct is decorated with Offset or OffsetIdEXT, the Byte Offset value must be a multiple of bufferDescriptorAlignment", 150}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-bufferDescriptorAlignment-11479", 49}, { {"If a OpTypeAccelerationStructureKHR member of a struct is decorated with Offset or OffsetIdEXT, the Byte Offset value must be a multiple of bufferDescriptorAlignment", 165}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-cooperativeMatrixFlexibleDimensions-10165", 59}, { {"For OpTypeCooperativeMatrixKHR, if the cooperativeMatrixFlexibleDimensions feature is enabled, the component type, scope, number of rows, and number of columns must match either one of the matrices in one of the supported VkCooperativeMatrixPropertiesKHR or VkCooperativeMatrixFlexibleDimensionsPropertiesNV", 307}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-cooperativeMatrixFlexibleDimensions-10166", 59}, { {"For OpCooperativeMatrixMulAddKHR, if the cooperativeMatrixFlexibleDimensions feature is enabled, the operands must match either one of the supported VkCooperativeMatrixPropertiesKHR or VkCooperativeMatrixFlexibleDimensionsPropertiesNV", 234}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-cooperativeMatrixFlexibleDimensionsMaxDimension-10167", 71}, { {"All OpTypeCooperativeMatrixKHR dimensions must be less than or equal to cooperativeMatrixFlexibleDimensionsMaxDimension", 119}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-cooperativeMatrixSupportedStages-08985", 56}, { {"OpTypeCooperativeMatrixKHR and OpCooperativeMatrix* instructions must not be used in shader stages not included in VkPhysicalDeviceCooperativeMatrixPropertiesKHR::cooperativeMatrixSupportedStages", 195}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-cooperativeMatrixWorkgroupScope-10164", 55}, { {"If the cooperativeMatrixWorkgroupScope feature is not enabled, the scope of all OpTypeCooperativeMatrixKHR must not be VkScopeKHR::VK_SCOPE_WORKGROUP_KHR", 153}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-cooperativeVectorSupportedStages-10091", 56}, { {"OpTypeCooperativeVectorNV and OpCooperativeVector* instructions must not be used in shader stages not included in VkPhysicalDeviceCooperativeVectorPropertiesNV::cooperativeVectorSupportedStages", 193}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-denormBehaviorIndependence-06289", 50}, { {"If denormBehaviorIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY, then the entry point must use the same denormals Execution Mode for both 16-bit and 64-bit floating-point types", 195}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-denormBehaviorIndependence-06290", 50}, { {"If denormBehaviorIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE, then the entry point must use the same denormals Execution Mode for all floating-point types", 169}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-flags-08761", 29}, { {"For OpRayQueryGetIntersectionTriangleVertexPositionsKHR instructions, Acceleration Structure must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_BIT_KHR in flags", 185}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-flags-11875", 29}, { {"For OpHitObjectTraceRayMotionEXT and OpHitObjectTraceMotionReorderExecuteEXT instructions, if Acceleration Structure was built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags, the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", 283}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-flags-11876", 29}, { {"For OpHitObjectTraceRayMotionEXT and OpHitObjectTraceMotionReorderExecuteEXT instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", 251}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-imageDescriptorAlignment-11349", 48}, { {"If the Result Type operand of OpLoad is OpTypeImage, and Pointer is derived from a variable decorated with ResourceHeapEXT, it must be at an offset from the base that is a multiple of imageDescriptorAlignment", 208}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-imageDescriptorAlignment-11383", 48}, { {"If the Image operand of OpImageTexelPointer or OpUntypedImageTexelPointerEXT is derived from a variable decorated with ResourceHeapEXT, it must be at an offset from the base that is a multiple of imageDescriptorAlignment", 220}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-imageDescriptorAlignment-11477", 48}, { {"If a OpTypeImage member of a struct is decorated with Offset or OffsetIdEXT, the Byte Offset value must be a multiple of imageDescriptorAlignment", 145}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-longVector-12296", 34}, { {"If the longVector feature is enabled, the Component Count of any vector type must be less than or equal to maxVectorComponents", 126}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maintenance4-06817", 36}, { {"If the maintenance4 feature is not enabled, any vector type output interface variables must not have a higher Component Count than a matching vector type input interface variable", 178}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maintenance5-09190", 36}, { {"If the maintenance5 feature is enabled and a PointSize decorated variable is written to, all execution paths must write to a PointSize decorated variable", 153}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maintenance5-10934", 36}, { {"If the maintenance5 feature is enabled and a PointSize decorated variable is written to for any output vertex in the Geometry Execution Model, all execution paths for all output vertices must write to a PointSize decorated variable", 231}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxBlockMatchRegion-09225", 43}, { {"If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then Block Size less than or equal to maxBlockMatchRegion", 142}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxComputeSharedMemorySize-10168", 50}, { {"If the module uses OpTypeCooperativeMatrixKHR with Scope equal to Workgroup, the sum of size in bytes for variables and padding in the Workgroup Storage Class in the GLCompute Execution Model must be less than or equal to maxComputeSharedMemorySize minus cooperativeMatrixWorkgroupScopeReservedSharedMemory", 306}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxCooperativeVectorComponents-10094", 54}, { {"OpTypeCooperativeVector instructions must have Component Count less than or equal to maxCooperativeVectorComponents", 115}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxExecutionGraphShaderOutputNodes-09197", 58}, { {"Shaders must not include more than maxExecutionGraphShaderOutputNodes instances of OpInitializeNodePayloadsAMDX", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadCount-09196", 59}, { {"Shaders must not statically initialize more than maxExecutionGraphShaderPayloadCount variables in the NodeOutputPayloadAMDX storage class", 137}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09193", 58}, { {"Variables declared in the NodePayloadAMDX storage class must not be larger than the maxExecutionGraphShaderPayloadSize limit", 124}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09194", 58}, { {"Variables declared in the NodeOutputPayloadAMDX storage class must not be larger than the maxExecutionGraphShaderPayloadSize limit", 130}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09195", 58}, { {"For a given entry point, the sum of the size of any variable in the NodePayloadAMDX storage class, and the combined size of all statically initialized variables in the NodeOutputPayloadAMDX storage class must not be greater than maxExecutionGraphShaderPayloadSize", 263}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxMeshOutputMemorySize-08756", 47}, { {"The sum of size in bytes for variables in the Output Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshOutputMemorySize according to the formula in Mesh Shader Output", 198}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxMeshPayloadAndOutputMemorySize-08757", 57}, { {"The sum of size in bytes for variables and in the TaskPayloadWorkgroupEXT or Output Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshPayloadAndOutputMemorySize according to the formula in Mesh Shader Output", 239}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxMeshPayloadAndSharedMemorySize-08755", 57}, { {"The sum of size in bytes for variables and padding in the TaskPayloadWorkgroupEXT or Workgroup Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshPayloadAndSharedMemorySize", 203}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxMeshSharedMemorySize-08754", 47}, { {"The sum of size in bytes for variables and padding in the Workgroup Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshSharedMemorySize", 166}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxShaderBindingTableRecordIndex-11888", 56}, { {"The SBT Index passed in to OpHitObjectSetShaderBindingTableRecordIndexEXT must be less than or equal to VkPhysicalDeviceRayTracingInvocationReorderPropertiesEXT::maxShaderBindingTableRecordIndex", 194}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxTaskPayloadAndSharedMemorySize-08760", 57}, { {"The sum of size in bytes for variables and padding in the TaskPayloadWorkgroupEXT or Workgroup Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskPayloadAndSharedMemorySize", 203}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxTaskPayloadSize-08758", 42}, { {"The sum of size in bytes for variables and in the TaskPayloadWorkgroupEXT Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskPayloadSize", 167}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxTaskSharedMemorySize-08759", 47}, { {"The sum of size in bytes for variables and padding in the Workgroup Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskSharedMemorySize", 166}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxTensorShaderAccessArrayLength-09903", 56}, { {"The length of an array returned by OpTensorReadARM or passed as the Object operand to OpTensorWriteARM must be less than or equal to maxTensorShaderAccessArrayLength", 165}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-maxTensorShaderAccessSize-09904", 49}, { {"The total size of the data (number of tensor elements x size of an element) read or written by one OpTensorReadARM, or OpTensorWriteARM instruction, respectively, must be less than or equal to maxTensorShaderAccessSize", 218}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-meshAndTaskShaderDerivatives-10153", 52}, { {"If meshAndTaskShaderDerivatives is VK_FALSE, the DerivativeGroupLinearKHR and DerivativeGroupQuadsKHR execution modes must not be used in the MeshEXT, MeshNV, TaskEXT, or TaskNV Execution Model", 193}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-minSampleShading-08731", 40}, { {"If sample shading is enabled and minSampleShading is 1.0, the sample operand of any OpColorAttachmentReadEXT, OpDepthAttachmentReadEXT, or OpStencilAttachmentReadEXT operation must evaluate to the value of the coverage index for any given fragment invocation", 258}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-minSampleShading-08732", 40}, { {"If sample shading is enabled and any of the OpColorAttachmentReadEXT, OpDepthAttachmentReadEXT, or OpStencilAttachmentReadEXT operations are used, then minSampleShading must be 1.0", 180}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-pNext-09226", 29}, { {"If a OpImageBlockMatchWindow*QCOM operation is used, then target sampled image must have been created using asampler object that included VkSamplerBlockMatchWindowCreateInfoQCOM in the pNext chain", 196}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-pNext-09919", 29}, { {"For each data graph pipeline created with a VkDataGraphPipelineShaderModuleCreateInfoARM structure included in the pNext chain of VkDataGraphPipelineCreateInfoARM, the OpGraph that is used by the OpGraphEntryPointARM the pipeline is being created for must have an OpTypeGraphARM that only uses OpTypeTensorARM with Shape present", 328}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-pNext-09920", 29}, { {"For each data graph pipeline created with a VkDataGraphPipelineShaderModuleCreateInfoARM structure included in the pNext chain of VkDataGraphPipelineCreateInfoARM, all the OpGraphConstantARM with OpTypeTensorARM type used by the OpGraph that is used by the OpGraphEntryPointARM the pipeline is being created for must have an OpTypeTensorARM with Shape present", 359}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-pNext-09921", 29}, { {"The pConstants in the data graph pipeline must satisfy all constraints", 70}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-pNext-09923", 29}, { {"The pResourceInfos in the data graph pipeline must satisfy all constraints", 74}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-protectedNoFault-09645", 40}, { {"If protectedNoFault is not supported, the Storage Class of the PhysicalStorageBuffer must not be used if the buffer being accessed is protected", 143}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-roundingModeIndependence-06291", 48}, { {"If roundingModeIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY, then the entry point must use the same rounding Execution Mode for both 16-bit and 64-bit floating-point types", 192}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-roundingModeIndependence-06292", 48}, { {"If roundingModeIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE, then the entry point must use the same rounding Execution Mode for all floating-point types", 166}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-samplerDescriptorAlignment-11348", 50}, { {"If the Result Type operand of OpLoad is OpTypeSampler, and Pointer is derived from a variable decorated with SamplerHeapEXT, it must be at an offset from the base that is a multiple of samplerDescriptorAlignment", 211}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-samplerDescriptorAlignment-11476", 50}, { {"If a OpTypeSampler member of a struct is decorated with Offset or OffsetIdEXT, the Byte Offset value must be a multiple of samplerDescriptorAlignment", 149}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-samples-08725", 31}, { {"If an OpTypeImage has an MS operand 0, its bound image must have been created with VkImageCreateInfo::samples as VK_SAMPLE_COUNT_1_BIT", 134}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-samples-08726", 31}, { {"If an OpTypeImage has an MS operand 1, its bound image must not have been created with VkImageCreateInfo::samples as VK_SAMPLE_COUNT_1_BIT", 138}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat16-06299", 54}, { {"If shaderDenormFlushToZeroFloat16 is VK_FALSE, then DenormFlushToZero for 16-bit floating-point type must not be used", 117}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat32-06300", 54}, { {"If shaderDenormFlushToZeroFloat32 is VK_FALSE, then DenormFlushToZero for 32-bit floating-point type must not be used", 117}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat64-06301", 54}, { {"If shaderDenormFlushToZeroFloat64 is VK_FALSE, then DenormFlushToZero for 64-bit floating-point type must not be used", 117}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderDenormPreserveFloat16-06296", 51}, { {"If shaderDenormPreserveFloat16 is VK_FALSE, then DenormPreserve for 16-bit floating-point type must not be used", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderDenormPreserveFloat32-06297", 51}, { {"If shaderDenormPreserveFloat32 is VK_FALSE, then DenormPreserve for 32-bit floating-point type must not be used", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderDenormPreserveFloat64-06298", 51}, { {"If shaderDenormPreserveFloat64 is VK_FALSE, then DenormPreserve for 64-bit floating-point type must not be used", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderDeviceClock-06268", 41}, { {"If the shaderDeviceClock feature is not enabled, the Device scope must not be used for OpReadClockKHR", 101}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06767", 55}, { {"If the shaderEarlyAndLateFragmentTests feature is not enabled, the EarlyAndLateFragmentTestsEXT Execution Mode must not be used", 127}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06768", 55}, { {"If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefUnchangedFrontEXT Execution Mode must not be used", 126}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06769", 55}, { {"If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefUnchangedBackEXT Execution Mode must not be used", 125}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06770", 55}, { {"If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefGreaterFrontEXT Execution Mode must not be used", 124}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06771", 55}, { {"If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefGreaterBackEXT Execution Mode must not be used", 123}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06772", 55}, { {"If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefLessFrontEXT Execution Mode must not be used", 121}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06773", 55}, { {"If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefLessBackEXT Execution Mode must not be used", 120}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderFloat16VectorAtomics-09581", 50}, { {"shaderFloat16VectorAtomics, must be enabled for 16-bit floating-point, 2- and 4-component vector atomic operations to be supported", 130}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderFmaFloat16-10977", 40}, { {"shaderFmaFloat16 must be enabled for OpFmaKHR to be supported with a result type that includes a 16-bit float", 109}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderFmaFloat32-10978", 40}, { {"shaderFmaFloat32 must be enabled for OpFmaKHR to be supported with a result type that includes a 32-bit float", 109}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderFmaFloat64-10979", 40}, { {"shaderFmaFloat64 must be enabled for OpFmaKHR to be supported with a result type that includes a 64-bit float", 109}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderRelaxedExtendedInstruction-10773", 56}, { {"If the shaderRelaxedExtendedInstruction feature is not enabled, the OpExtInstWithForwardRefsKHR must not be used", 112}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat16-06302", 52}, { {"If shaderRoundingModeRTEFloat16 is VK_FALSE, then RoundingModeRTE for 16-bit floating-point type must not be used", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat32-06303", 52}, { {"If shaderRoundingModeRTEFloat32 is VK_FALSE, then RoundingModeRTE for 32-bit floating-point type must not be used", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat64-06304", 52}, { {"If shaderRoundingModeRTEFloat64 is VK_FALSE, then RoundingModeRTE for 64-bit floating-point type must not be used", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat16-06305", 52}, { {"If shaderRoundingModeRTZFloat16 is VK_FALSE, then RoundingModeRTZ for 16-bit floating-point type must not be used", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat32-06306", 52}, { {"If shaderRoundingModeRTZFloat32 is VK_FALSE, then RoundingModeRTZ for 32-bit floating-point type must not be used", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat64-06307", 52}, { {"If shaderRoundingModeRTZFloat64 is VK_FALSE, then RoundingModeRTZ for 64-bit floating-point type must not be used", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSampleRateInterpolationFunctions-06325", 62}, { {"If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::shaderSampleRateInterpolationFunctions is VK_FALSE, then GLSL.std.450 fragment interpolation functions are not supported by the implementation and OpCapability must not be InterpolationFunction", 298}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-06293", 61}, { {"If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE, then SignedZeroInfNanPreserve for 16-bit floating-point type must not be used", 131}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-09559", 61}, { {"If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE then any FPFastMathDefault execution mode with a type of 16-bit float must include the NSZ, NotInf, and NotNaN flags", 169}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-09560", 61}, { {"If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 16-bit float must include the NSZ, NotInf, and NotNaN flags", 218}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-06294", 61}, { {"If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE, then SignedZeroInfNanPreserve for 32-bit floating-point type must not be used", 131}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-09561", 61}, { {"If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE then any FPFastMathDefault execution mode with a type of 32-bit float must include the NSZ, NotInf, and NotNaN flags", 169}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-09562", 61}, { {"If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 32-bit float must include the NSZ, NotInf, and NotNaN flags", 218}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-06295", 61}, { {"If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE, then SignedZeroInfNanPreserve for 64-bit floating-point type must not be used", 131}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-09563", 61}, { {"If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE then any FPFastMathDefault execution mode with a type of 64-bit float must include the NSZ, NotInf, and NotNaN flags", 169}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-09564", 61}, { {"If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 64-bit float must include the NSZ, NotInf, and NotNaN flags", 218}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSubgroupClock-06267", 43}, { {"If the shaderSubgroupClock feature is not enabled, the Subgroup scope must not be used for OpReadClockKHR", 105}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderSubgroupRotateClustered-09566", 53}, { {"If shaderSubgroupRotateClustered is VK_FALSE, then the ClusterSize operand to OpGroupNonUniformRotateKHR must not be used", 121}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderTensorSupportedStages-09901", 51}, { {"OpTypeTensorARM, OpTensorReadARM, OpTensorWriteARM, or OpTensorQuerySizeARM must not be used in shader stages not in shaderTensorSupportedStages", 144}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderUniformBufferUnsizedArray-11806", 55}, { {"If the shaderUniformBufferUnsizedArray feature is not enabled, OpTypeRuntimeArray must not be used for the last member of a Block-decorated OpTypeStruct in the Uniform storage Storage Class", 189}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-shaderZeroInitializeWorkgroupMemory-06372", 59}, { {"If the shaderZeroInitializeWorkgroupMemory feature is not enabled, any variable with Workgroup as its Storage Class must not have an Initializer operand", 152}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-source-11387", 30}, { {"All possible values of a variable pointer to a resource that are not OpConstantNull must either all be pointers to resources with DescriptorSet and Binding decorations with the same mapping types as specified by VkDescriptorSetAndBindingMappingEXT::source, or all be pointers to resources without DescriptorSet and Binding decorations", 334}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-storageBuffer16BitAccess-11161", 48}, { {"If storageBuffer16BitAccess is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have Storage Class of StorageBuffer, ShaderRecordBufferKHR, or PhysicalStorageBuffer unless: storageBuffer8BitAccess is VK_TRUE, or the elements are accessed in 32-bit multiples if shaderUntypedPointers is VK_TRUE.", 337}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-storageBuffer8BitAccess-06328", 47}, { {"If storageBuffer8BitAccess is VK_FALSE, then objects containing an 8-bit integer element must not have Storage Class of StorageBuffer, ShaderRecordBufferKHR, or PhysicalStorageBuffer unless shaderUntypedPointers is VK_TRUE and they are accessed in: 32-bit multiples, or 16-bit multiples if storageBuffer16BitAccess is VK_TRUE.", 326}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-storageInputOutput16-11162", 44}, { {"If storageInputOutput16 is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have storage class of Input or Output", 156}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-storagePushConstant16-06333", 45}, { {"If storagePushConstant16 is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have Storage Class of PushConstant unless: StoragePushConstant8 is VK_TRUE, or elements are accessed in 32-bit multiples if shaderUntypedPointers is VK_TRUE", 276}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-storagePushConstant8-06330", 44}, { {"If storagePushConstant8 is VK_FALSE, then objects containing an 8-bit integer element must not have Storage Class of PushConstant unless shaderUntypedPointers is VK_TRUE and they are accessed in: 32-bit multiples, or 16-bit multiples if storagePushConstant16 is VK_TRUE.", 270}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupBroadcastDynamicId-06276", 50}, { {"If subgroupBroadcastDynamicId is VK_TRUE, and the shader module version is 1.5 or higher, the \"Index\" for OpGroupNonUniformQuadBroadcast must be dynamically uniform within the derivative group. Otherwise, \"Index\" must be a constant", 235}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupBroadcastDynamicId-06277", 50}, { {"If subgroupBroadcastDynamicId is VK_TRUE, and the shader module version is 1.5 or higher, the \"Id\" for OpGroupNonUniformBroadcast must be dynamically uniform within the subgroup. Otherwise, \"Id\" must be a constant", 217}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupSize-10141", 36}, { {"If the effective subgroup size is 1, the UniformBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a uniform buffer, the uniform buffer through which that memory is accessed must be dynamically uniform within the invocation group", 279}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupSize-10142", 36}, { {"If the effective subgroup size is 1, the SampledImageArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a sampled image or sampler, the sampled image or sampler through which that memory is accessed must be dynamically uniform within the invocation group", 298}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupSize-10143", 36}, { {"If the effective subgroup size is 1, the StorageBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage buffer, the storage buffer through which that memory is accessed must be dynamically uniform within the invocation group", 279}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupSize-10144", 36}, { {"If the effective subgroup size is 1, the StorageImageArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage image, the storage image through which that memory is accessed must be dynamically uniform within the invocation group", 276}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupSize-10145", 36}, { {"If the effective subgroup size is 1, the InputAttachmentArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through an input attachment, the input attachment through which that memory is accessed must be dynamically uniform within the invocation group", 286}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupSize-10146", 36}, { {"If the effective subgroup size is 1, the UniformTexelBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a uniform texel buffer, the uniform texel buffer through which that memory is accessed must be dynamically uniform within the invocation group", 296}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupSize-10147", 36}, { {"If the effective subgroup size is 1, the StorageTexelBufferArrayNonUniformIndexing capability is not is not declared, and an instruction accesses memory through a storage texel buffer, the storage texel buffer through which that memory is accessed must be dynamically uniform within the invocation group", 303}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-subgroupSize-10149", 36}, { {"If an instruction accesses memory through any resource, the effective subgroup size is greater than 1, the DescriptorHeapEXT capability is not declared, and the resource through which that memory is accessed is not uniform within the invocation group, and not uniform within the subgroup, then the operand corresponding to that resource (e.g. the pointer or sampled image operand) must be decorated with NonUniform", 414}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-tensorDescriptorAlignment-11480", 49}, { {"If a OpTypeTensorARM member of a struct is decorated with Offset or OffsetIdEXT, the Byte Offset value must be a multiple of tensorDescriptorAlignment", 150}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-tensorDescriptorAlignment-11481", 49}, { {"If the Result Type operand of OpLoad is OpTypeTensorARM and Pointer is derived from a variable decorated with ResourceHeapEXT, it must be at an offset from the base that is a multiple of tensorDescriptorAlignment", 212}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-tessellationShader-06326", 42}, { {"If the tessellationShader feature is enabled, and the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::tessellationIsolines is VK_FALSE, then OpExecutionMode must not be IsoLines", 227}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-tessellationShader-06327", 42}, { {"If the tessellationShader feature is enabled, and the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::tessellationPointMode is VK_FALSE, then OpExecutionMode must not be PointMode", 229}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-tileShadingImageProcessing-10712", 50}, { {"If an OpTypeSampledImage with Storage Class TileAttachmentQCOM is consumed by any argument of the following operations, tileShadingImageProcessing must be enabled: OpImageSampleWeightedQCOM OpImageBoxFilterQCOM OpImageBlockMatch*QCOM", 233}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-tileSize-10705", 32}, { {"In compute shaders that enables SPIR-V capability TileShadingQCOM, VkTilePropertiesQCOM.tileSize.z % TileShadingRateQCOM::z must equal 0", 136}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-transformFeedbackStreamsLinesTriangles-06311", 62}, { {"If the geometry shader emits to more than one vertex stream and VkPhysicalDeviceTransformFeedbackPropertiesEXT::transformFeedbackStreamsLinesTriangles is VK_FALSE, then Execution Mode must be OutputPoints", 204}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-uniformAndStorageBuffer16BitAccess-06332", 58}, { {"If uniformAndStorageBuffer16BitAccess is VK_FALSE, then objects in the Uniform Storage Class with the Block decoration must not have 16-bit integer or 16-bit floating-point members unless: uniformAndStorageBuffer8BitAccess is VK_TRUE, or members are accessed in 32-bit multiples and shaderUntypedPointers is VK_TRUE", 315}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-uniformAndStorageBuffer8BitAccess-06329", 57}, { {"If uniformAndStorageBuffer8BitAccess is VK_FALSE, then objects in the Uniform Storage Class with the Block decoration must not have an 8-bit integer member unless shaderUntypedPointers is VK_TRUE and they are accessed in: 32-bit multiples, or 16-bit multiples if uniformAndStorageBuffer16BitAccess is VK_TRUE.", 309}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-vulkanMemoryModel-06265", 41}, { {"If the vulkanMemoryModel feature is enabled and the vulkanMemoryModelDeviceScope feature is not enabled, Device memory scope must not be used", 141}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-vulkanMemoryModel-06266", 41}, { {"If the vulkanMemoryModel feature is not enabled, QueueFamily memory scope must not be used", 90}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-workgroupMemoryExplicitLayout16BitAccess-10757", 64}, { {"If workgroupMemoryExplicitLayout16BitAccess is VK_FALSE, then objects in the Workgroup Storage Class with the Block decoration must not have an 16-bit integer or 16-bit floating-point elements unless: workgroupMemoryExplicitLayout8BitAccess is VK_TRUE, or elements are accessed in 32-bit multiples if shaderUntypedPointers is VK_TRUE", 333}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-workgroupMemoryExplicitLayout8BitAccess-10756", 63}, { {"If workgroupMemoryExplicitLayout8BitAccess is VK_FALSE, then objects in the Workgroup Storage Class with the Block decoration must not have an 8-bit integer element unless shaderUntypedPointers is VK_TRUE and they are accessed in: 32-bit multiples, or 16-bit multiples if workgroupMemoryExplicitLayout16BitAccess is VK_TRUE", 323}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-x-06429", 25}, { {"In compute shaders using the GLCompute Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[0]", 174}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-x-06432", 25}, { {"In compute shaders using the GLCompute Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupInvocations", 209}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-x-10702", 25}, { {"In compute shaders that enables SPIR-V capability TileShadingQCOM, the x size in TileShadingRateQCOM must be less than or equal to VkPhysicalDeviceTileShadingPropertiesQCOM.maxTileShadingRate.x", 193}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-y-06430", 25}, { {"In compute shaders using the GLCompute Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[1]", 174}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-y-10703", 25}, { {"In compute shaders that enables SPIR-V capability TileShadingQCOM, the y size in TileShadingRateQCOM must be less than or equal to VkPhysicalDeviceTileShadingPropertiesQCOM.maxTileShadingRate.y", 193}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-z-06431", 25}, { {"In compute shaders using the GLCompute Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[2]", 174}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-RuntimeSpirv-z-10704", 25}, { {"In compute shaders that enables SPIR-V capability TileShadingQCOM, the z size in TileShadingRateQCOM must be less than or equal to VkTilePropertiesQCOM.tileSize.z", 162}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-SMCountNV-SMCountNV-04363", 30}, { {"The variable decorated with SMCountNV must be declared using the Input Storage Class", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SMCountNV-SMCountNV-04364", 30}, { {"The variable decorated with SMCountNV must be declared as a scalar 32-bit integer value", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SMIDNV-SMIDNV-04365", 24}, { {"The variable decorated with SMIDNV must be declared using the Input Storage Class", 81}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SMIDNV-SMIDNV-04366", 24}, { {"The variable decorated with SMIDNV must be declared as a scalar 32-bit integer value", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SampleId-SampleId-04354", 28}, { {"The SampleId decoration must be used only within the Fragment Execution Model", 77}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SampleId-SampleId-04355", 28}, { {"The variable decorated with SampleId must be declared using the Input Storage Class", 83}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SampleId-SampleId-04356", 28}, { {"The variable decorated with SampleId must be declared as a scalar 32-bit integer value", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SampleMask-SampleMask-04357", 32}, { {"The SampleMask decoration must be used only within the Fragment Execution Model", 79}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SampleMask-SampleMask-04358", 32}, { {"The variable decorated with SampleMask must be declared using the Input or Output Storage Class", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SampleMask-SampleMask-04359", 32}, { {"The variable decorated with SampleMask must be declared as an array of 32-bit integer values", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SamplePosition-SamplePosition-04360", 40}, { {"The SamplePosition decoration must be used only within the Fragment Execution Model", 83}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SamplePosition-SamplePosition-04361", 40}, { {"The variable decorated with SamplePosition must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SamplePosition-SamplePosition-04362", 40}, { {"The variable decorated with SamplePosition must be declared as a two-component vector of 32-bit floating-point values", 117}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SamplerHeapEXT-SamplerHeapEXT-11239", 40}, { {"The variable decorated with SamplerHeapEXT must be declared using the UniformConstant Storage Class", 99}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-ShaderIndexAMDX-ShaderIndexAMDX-09175", 42}, { {"The variable decorated with ShaderIndexAMDX must be declared using the Input Storage Class", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ShaderIndexAMDX-ShaderIndexAMDX-09176", 42}, { {"The variable decorated with ShaderIndexAMDX must be declared as a scalar 32-bit integer value", 93}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ShadingRateKHR-ShadingRateKHR-04490", 40}, { {"The ShadingRateKHR decoration must be used only within the Fragment Execution Model", 83}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ShadingRateKHR-ShadingRateKHR-04491", 40}, { {"The variable decorated with ShadingRateKHR must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ShadingRateKHR-ShadingRateKHR-04492", 40}, { {"The variable decorated with ShadingRateKHR must be declared as a scalar 32-bit integer value", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-StandaloneSpirv-Base-07650", 31}, { {"The Base operand of OpPtrAccessChain or OpUntypedPtrAccessChainKHR must have a storage class of Workgroup, StorageBuffer, or PhysicalStorageBuffer", 146}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Base-07651", 31}, { {"If the Base operand of OpPtrAccessChain or OpUntypedPtrAccessChainKHR has a Workgroup Storage Class, then the VariablePointers capability must be declared", 154}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Base-07652", 31}, { {"If the Base operand of OpPtrAccessChain or OpUntypedPtrAccessChainKHR has a StorageBuffer Storage Class, then the VariablePointers or VariablePointersStorageBuffer capability must be declared", 191}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-BuiltIn-04668", 34}, { {"Any BuiltIn decoration not listed in Built-In Variables must not be used", 72}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-CallableDataKHR-04704", 42}, { {"CallableDataKHR Storage Class must only be used in ray generation, closest hit, miss, and callable shaders", 106}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Component-04920", 36}, { {"The Component decoration value must not be greater than 3", 57}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Component-04921", 36}, { {"If the Component decoration is used on a variable that has a vector type with a Component Type with a Width that is less than or equal to 32, the sum of its Component Count and the Component decoration value must be less than or equal to 4", 239}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Component-04922", 36}, { {"If the Component decoration is used on a variable that has a vector type with a Component Type with a Width that is equal to 64, the sum of two times its Component Count and the Component decoration value must be less than or equal to 4", 236}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Component-04923", 36}, { {"The Component decorations value must not be 1 or 3 for scalar or two-component 64-bit data types", 96}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Component-07703", 36}, { {"The Component decorations must not be used for a 64-bit vector type with more than two components", 97}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Component-10583", 36}, { {"The Component decorations must not be used with any type that is not a scalar, vector, array of scalars or vectors, or an array of arrays of scalars or vectors", 159}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-DerivativeGroupLinearKHR-10152", 51}, { {"For compute, mesh, or task shaders using the DerivativeGroupLinearKHR execution mode, the product of the dimensions of the local workgroup size must be a multiple of four", 170}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-DerivativeGroupLinearNV-04778", 50}, { {"For compute shaders using the DerivativeGroupLinearNV execution mode, the product of the dimensions of the local workgroup size must be a multiple of four", 154}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-DerivativeGroupQuadsKHR-10151", 50}, { {"For compute, mesh, or task shaders using the DerivativeGroupQuadsKHR execution mode, the first two dimensions of the local workgroup size must be a multiple of two", 163}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-DerivativeGroupQuadsNV-04684", 49}, { {"For compute shaders using the DerivativeGroupQuadsNV execution mode, the first two dimensions of the local workgroup size must be a multiple of two", 147}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-DescriptorHeapEXT-11482", 44}, { {"If the DescriptorHeapEXT capability is declared, structure types must not contain opaque types other than descriptors", 117}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-DescriptorSet-06491", 40}, { {"If a variable is decorated by DescriptorSet or Binding, the Storage Class must correspond to an entry in Shader Resource and Storage Class Correspondence", 153}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Execution-10584", 36}, { {"If the Execution Model of an entry point is not TessellationControl or Geometry, its interface definition must not include any variables in the Input storage class decorated with Component that are arrays of arrays of scalars or vectors", 236}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Execution-10585", 36}, { {"If the Execution Model of an entry point is not MeshNV, its interface definition must not include any variables in the Output storage class decorated with Component that are arrays of arrays of scalars or vectors", 212}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Execution-10687", 36}, { {"Execution Mode NonCoherentTileAttachmentReadQCOM must not be used in any stage other than fragment", 98}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Execution-10688", 36}, { {"Execution Mode TileShadingRateQCOM must not be used in any stage other than compute", 83}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-ExecutionModel-07320", 41}, { {"If the Execution Model is TessellationControl, and the MemoryModel is GLSL450, the Scope for memory must not be Workgroup", 121}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-FPRoundingMode-04675", 41}, { {"Rounding modes other than round-to-nearest-even and round-towards-zero must not be used for the FPRoundingMode decoration", 121}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Flat-04670", 31}, { {"The Flat, NoPerspective, Sample, and Centroid decorations must only be used on variables with the Output or Input Storage Class", 127}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Flat-04744", 31}, { {"Any variable with integer or double-precision floating-point type and with Input Storage Class in a fragment shader, must be decorated Flat", 139}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Flat-06201", 31}, { {"The Flat, NoPerspective, Sample, and Centroid decorations must not be used on variables with the Output storage class in a fragment shader", 138}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Flat-06202", 31}, { {"The Flat, NoPerspective, Sample, and Centroid decorations must not be used on variables with the Input storage class in a vertex shader", 135}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Function-04681", 35}, { {"A type T that is an array sized with a specialization constant must neither be, nor be contained in, the type T2 of a variable V, unless either: a) T is equal to T2, b) V is declared in the Function, or Private Storage Class, c) V is a non-Block variable in the Workgroup Storage Class, or d) V is an interface variable with an additional level of arrayness, as described in interface matching, and T is the member type of the array type T2", 440}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Function-12294", 35}, { {"A type T that is a vector sized with a specialization constant must neither be, nor be contained in, the type T2 of a variable V, unless either: a) T is equal to T2, b) V is declared in the Function, or Private Storage Class, c) V is a non-Block variable in the Workgroup Storage Class, or d) V is an interface variable with an additional level of arrayness, as described in interface matching, and T is the member type of the array type T2", 440}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-GLSLShared-04669", 37}, { {"The GLSLShared and GLSLPacked decorations must not be used", 58}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-HitAttributeKHR-04701", 42}, { {"HitAttributeKHR Storage Class must only be used in intersection, any-hit, or closest hit shaders", 96}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-HitAttributeKHR-04702", 42}, { {"There must be at most one variable with the HitAttributeKHR Storage Class in the input interface of an entry point", 114}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-HitAttributeKHR-04703", 42}, { {"A variable with HitAttributeKHR Storage Class must only be written to in an intersection shader", 95}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Image-04965", 32}, { {"The SPIR-V Type of the Image Format operand of an OpTypeImage must match the Sampled Type, as defined in Image Format and Type Matching", 135}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-IncomingCallableDataKHR-04705", 50}, { {"IncomingCallableDataKHR Storage Class must only be used in callable shaders", 75}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-IncomingCallableDataKHR-04706", 50}, { {"There must be at most one variable with the IncomingCallableDataKHR Storage Class in the input interface of an entry point", 122}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-IncomingRayPayloadKHR-04699", 48}, { {"IncomingRayPayloadKHR Storage Class must only be used in closest hit, any-hit, or miss shaders", 94}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-IncomingRayPayloadKHR-04700", 48}, { {"There must be at most one variable with the IncomingRayPayloadKHR Storage Class in the input interface of an entry point", 120}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Input-06778", 32}, { {"Variables with a Storage Class of Input in a fragment shader stage that are decorated with PerVertexKHR must be declared as arrays", 130}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Input-07290", 32}, { {"Variables with a Storage Class of Input or Output and a type of OpTypeBool must be decorated with the BuiltIn decoration", 120}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Input-09557", 32}, { {"The pointers of any Input or Output Interface user-defined variables must not contain any PhysicalStorageBuffer Storage Class pointers", 134}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Input-10588", 32}, { {"Variables in the Input storage class in the TessellationControl, TessellationEvaluation, Geometry, or Fragment execution model must not have overlapping Component and Location decorations as defined by Location and Component Assignment", 235}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Input-10604", 32}, { {"Any variable in the Input storage class in the Fragment execution model must not have an assigned Location shared with another variable with different decorations for PerVertexKHR, Flat, NoPerspective, Sample, or Centroid", 221}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-InputAttachmentArrayDynamicIndexing-10131", 62}, { {"If the InputAttachmentArrayDynamicIndexing capability is not declared, and an instruction accesses memory through an input attachment, the input attachment through which that memory is accessed must be determined by constant integral expressions", 245}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-InputAttachmentIndex-06678", 47}, { {"Variables decorated with InputAttachmentIndex must be in the UniformConstant Storage Class", 90}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Invariant-04677", 36}, { {"Variables decorated with Invariant and variables with structure types that have any members decorated with Invariant must be in the Output or Input Storage Class, Invariant used on an Input Storage Class variable or structure member has no effect", 246}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Location-04915", 35}, { {"The Location or Component decorations must not be used with BuiltIn", 67}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Location-04916", 35}, { {"The Location decorations must be used on user-defined variables", 63}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Location-04917", 35}, { {"If a user-defined variable is not a pointer to a Block decorated OpTypeStruct, then the variable must have a Location decoration", 128}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Location-04918", 35}, { {"If a user-defined variable has a Location decoration, and the variable is a pointer to a OpTypeStruct, then the members of that structure must not have Location decorations", 172}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Location-04919", 35}, { {"If a user-defined variable does not have a Location decoration, and the variable is a pointer to a Block decorated OpTypeStruct, then each member of the struct must have a Location decoration", 191}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Location-06672", 35}, { {"The Location or Component decorations must only be used with the Input, Output, RayPayloadKHR, IncomingRayPayloadKHR, HitAttributeKHR, HitObjectAttributeNV, CallableDataKHR, IncomingCallableDataKHR, or ShaderRecordBufferKHR storage classes", 239}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10865", 42}, { {"MemorySemantics must have at most one non-relaxed memory order bit set (Acquire, Release, or AcquireRelease)", 108}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10866", 42}, { {"MemorySemantics with SequentiallyConsistent memory order must not be used in the Vulkan API", 91}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10867", 42}, { {"MemorySemantics must not use Acquire or AcquireRelease memory order with OpAtomicStore", 86}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10868", 42}, { {"MemorySemantics must not use Release or AcquireRelease memory order with OpAtomicLoad", 85}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10869", 42}, { {"MemorySemantics must not use Relaxed memory order with OpMemoryBarrier", 70}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10870", 42}, { {"MemorySemantics with a non-relaxed memory order (Acquire, Release, or AcquireRelease) must have at least one Vulkan-supported storage class semantics bit set (UniformMemory, WorkgroupMemory, ImageMemory, or OutputMemory)", 220}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10871", 42}, { {"MemorySemantics with at least one Vulkan-supported storage class semantics bit set (UniformMemory, WorkgroupMemory, ImageMemory, or OutputMemory) must use a non-relaxed memory order (Acquire, Release, or AcquireRelease)", 219}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10872", 42}, { {"MemorySemantics with MakeAvailable bit set must use Release or AcquireRelease memory order", 90}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10873", 42}, { {"MemorySemantics with MakeVisible bit set must use Acquire or AcquireRelease memory order", 88}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MemorySemantics-10874", 42}, { {"MemorySemantics with Volatile bit set must not be used with barrier instructions (OpControlBarrier or OpMemoryBarrier)", 118}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07102", 34}, { {"The module must not contain both an entry point that uses the TaskEXT or MeshEXT Execution Model and an entry point that uses the TaskNV or MeshNV Execution Model", 162}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07106", 34}, { {"In mesh shaders using the MeshEXT Execution Model OpSetMeshOutputsEXT must be called before any outputs are written", 115}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07107", 34}, { {"In mesh shaders using the MeshEXT Execution Model all variables declared in the Output Storage Class must not be read", 117}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07108", 34}, { {"In mesh shaders using the MeshEXT Execution Model for OpSetMeshOutputsEXT instructions, the \"Vertex Count\" and \"Primitive Count\" operands must not depend on ViewIndex", 170}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07109", 34}, { {"In mesh shaders using the MeshEXT Execution Model variables decorated with PrimitivePointIndicesEXT, PrimitiveLineIndicesEXT, or PrimitiveTriangleIndicesEXT declared as an array must not be accessed by indices that depend on ViewIndex", 234}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07110", 34}, { {"In mesh shaders using the MeshEXT Execution Model any values stored in variables decorated with PrimitivePointIndicesEXT, PrimitiveLineIndicesEXT, or PrimitiveTriangleIndicesEXT must not depend on ViewIndex", 206}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07111", 34}, { {"In mesh shaders using the MeshEXT Execution Model variables in workgroup or private Storage Class declared as or containing a composite type must not be accessed by indices that depend on ViewIndex", 197}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07330", 34}, { {"In mesh shaders using the MeshEXT Execution Model the OutputVertices Execution Mode must be greater than 0", 106}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-MeshEXT-07331", 34}, { {"In mesh shaders using the MeshEXT Execution Model the OutputPrimitivesEXT Execution Mode must be greater than 0", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-NonCoherentTileAttachmentReadQCOM-10690", 60}, { {"If the NonCoherentTileAttachmentReadQCOM Execution Mode is used, the TileShadingQCOM capability must be enabled", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04633", 31}, { {"Every entry point must have no return value and accept no arguments", 67}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04634", 31}, { {"The static function-call graph for an entry point must not contain cycles; that is, static recursion is not allowed", 115}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04635", 31}, { {"The Logical or PhysicalStorageBuffer64 addressing model must be selected", 72}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04636", 31}, { {"Scope for execution must be limited to Workgroup or Subgroup", 60}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04637", 31}, { {"If the Scope for execution is Workgroup, then it must only be used in the task, mesh, tessellation control, or compute Execution Model", 134}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04638", 31}, { {"Scope for memory must be limited to Device, QueueFamily, Workgroup, ShaderCallKHR, Subgroup, or Invocation", 106}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04640", 31}, { {"If the Scope for memory is ShaderCallKHR, then it must only be used in ray generation, intersection, closest hit, any-hit, miss, and callable Execution Model", 157}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04641", 31}, { {"If the Scope for memory is Invocation, then MemorySemantics must use Relaxed memory order", 89}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04642", 31}, { {"Scope for group operations must be limited to Subgroup", 54}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04643", 31}, { {"Storage Class must be limited to UniformConstant, Input, Uniform, Output, Workgroup, Private, Function, PushConstant, Image, StorageBuffer, RayPayloadKHR, IncomingRayPayloadKHR, HitAttributeKHR, CallableDataKHR, IncomingCallableDataKHR, ShaderRecordBufferKHR, PhysicalStorageBuffer, or TileImageEXT", 298}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04644", 31}, { {"If the Storage Class is Output, then it must not be used in the GlCompute, RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", 175}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04645", 31}, { {"If the Storage Class is Workgroup, then it must only be used in the task, mesh, or compute Execution Model", 106}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04667", 31}, { {"If the DescriptorHeapEXT capability is not declared, structure types must not contain opaque types", 98}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04686", 31}, { {"The Pointer operand of all atomic instructions must have a Storage Class limited to Uniform, Workgroup, Image, StorageBuffer, PhysicalStorageBuffer, or TaskPayloadWorkgroupEXT", 175}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-04745", 31}, { {"All block members in a variable with a Storage Class of PushConstant declared as an array must only be accessed by dynamically uniform indices", 142}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-07321", 31}, { {"If the Scope for memory is Workgroup, then it must only be used in the task, mesh, tessellation control, or compute Execution Model", 131}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-08720", 31}, { {"If the Storage Class is TileImageEXT, then it must only be used in the fragment execution model", 95}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-08724", 31}, { {"The TileImageEXT Storage Class must only be used for declaring tile image variables", 83}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-10684", 31}, { {"All variables must have valid explicit layout decorations as described in Shader Interfaces", 91}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-None-10685", 31}, { {"Either a TileShadingRateQCOM, LocalSize, or LocalSizeId Execution Mode, or an object decorated with the WorkgroupSize decoration must be specified for each entry point with a task, mesh, or compute Execution Model", 213}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Offset-04687", 33}, { {"Output variables or block members decorated with Offset that have a 64-bit type, or a composite type containing a 64-bit type, must specify an Offset value aligned to a 8 byte boundary", 184}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Offset-04689", 33}, { {"The size of any output block containing any member decorated with Offset that is a 64-bit type must be a multiple of 8", 118}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Offset-04690", 33}, { {"The first member of an output block specifying a Offset decoration must specify a Offset value that is aligned to an 8 byte boundary if that block contains any member decorated with Offset and is a 64-bit type", 209}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Offset-04691", 33}, { {"Output variables or block members decorated with Offset that have a 32-bit type, or a composite type contains a 32-bit type, must specify an Offset value aligned to a 4 byte boundary", 182}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Offset-04692", 33}, { {"Output variables, blocks or block members decorated with Offset must only contain base types that have components that are either 32-bit or 64-bit in size", 154}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Offset-04716", 33}, { {"Only variables or block members in the output interface decorated with Offset can be captured for transform feedback, and those variables or block members must also be decorated with XfbBuffer and XfbStride, or inherit XfbBuffer and XfbStride decorations from a block containing them", 283}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Offset-04865", 33}, { {"Any image instruction which uses an Offset, ConstOffset, or ConstOffsets image operand, must only consume a \"Sampled Image\" operand whose type has its \"Sampled\" operand set to 1", 181}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpArrayLength-11805", 40}, { {"OpArrayLength and OpUntypedArrayLengthKHR must not be used with an OpTypeRuntimeArray that is the last member of a Block-decorated OpTypeStruct in the Uniform storage Storage Class", 180}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpControlBarrier-04682", 43}, { {"If OpControlBarrier is used in ray generation, intersection, any-hit, closest hit, miss, fragment, vertex, tessellation evaluation, or geometry shaders, the execution Scope must be Subgroup", 189}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpEntryPoint-06674", 39}, { {"Each OpEntryPoint must not statically use more than one variable in the PushConstant Storage Class", 98}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpEntryPoint-08721", 39}, { {"Each OpEntryPoint must not have more than one Input variable assigned the same Component word inside a Location slot, either explicitly or implicitly", 149}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpEntryPoint-08722", 39}, { {"Each OpEntryPoint must not have more than one Output variable assigned the same Component word inside a Location slot, either explicitly or implicitly", 150}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpEntryPoint-09658", 39}, { {"For a given OpEntryPoint, any BuiltIn decoration must not be used more than once by the Input interface", 103}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpEntryPoint-09659", 39}, { {"For a given OpEntryPoint, any BuiltIn decoration must not be used more than once by the Output interface", 104}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpGraphInputARM-09931", 42}, { {"The InputIndex and ElementIndex operands to OpGraphInputARM must be the of a constant instruction", 97}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpGraphSetOutputARM-09932", 46}, { {"The OutputIndex and ElementIndex operands to OpGraphSetOutputARM must be the of a constant instruction", 102}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpGroupNonUniformBallotBitCount-04685", 58}, { {"If OpGroupNonUniformBallotBitCount is used, the group operation must be limited to Reduce, InclusiveScan, or ExclusiveScan", 122}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpImage-04777", 34}, { {"OpImage*Dref* instructions must not consume an image whose Dim is 3D", 68}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpImageGather-04664", 40}, { {"The \"Component\" operand of OpImageGather, and OpImageSparseGather must be the of a constant instruction", 105}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpImageQuerySizeLod-04659", 46}, { {"OpImageQuerySizeLod, OpImageQueryLod, and OpImageQueryLevels must only consume an \"Image\" operand whose type has its \"Sampled\" operand set to 1", 147}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpImageTexelPointer-04658", 46}, { {"If an OpImageTexelPointer is used in an atomic operation, the image type of the image parameter to OpImageTexelPointer must have an image format of R64i, R64ui, R32f, R32i, or R32ui", 181}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpReadClockKHR-04652", 41}, { {"Scope for OpReadClockKHR must be limited to Subgroup or Device", 62}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeFloat-10370", 38}, { {"Variables with a type of OpTypeFloat and an encoding of BFloat16KHR must not be declared with a Storage Class of Input or Output", 128}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeFloat-10823", 38}, { {"Variables with a type of OpTypeFloat and an encoding of Float8E4M3EXT or Float8E5M2EXT must not be declared with a Storage Class of Input or Output", 147}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeForwardPointer-04711", 47}, { {"OpTypeForwardPointer must have a Storage Class of PhysicalStorageBuffer", 71}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeImage-04656", 38}, { {"OpTypeImage must declare a scalar 32-bit float, 64-bit integer, or 32-bit integer type for the \"Sampled Type\" (RelaxedPrecision can be applied to a sampling instruction and to the variable holding the result of a sampling instruction)", 236}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeImage-04657", 38}, { {"OpTypeImage must have a \"Sampled\" operand of 1 (sampled image) or 2 (storage image)", 85}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeImage-06214", 38}, { {"An OpTypeImage with a \"Dim\" operand of SubpassData must have an \"Arrayed\" operand of 0 (non-arrayed) and a \"Sampled\" operand of 2 (storage image)", 151}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeImage-06924", 38}, { {"Objects of types OpTypeImage, OpTypeSampler, OpTypeSampledImage, OpTypeAccelerationStructureKHR, OpTypeTensorARM, and arrays of these types must not be stored to or modified", 173}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeImage-09638", 38}, { {"An OpTypeImage must not have a \"Dim\" operand of Rect", 54}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeImage-10693", 38}, { {"OpTypeImage variables in the TileAttachmentQCOM Storage Class must have Dim equal to 2D", 87}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeImage-10694", 38}, { {"OpTypeImage variables in the TileAttachmentQCOM Storage Class must Sampled equal to 1 or 2", 90}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeRuntimeArray-04680", 45}, { {"OpTypeRuntimeArray must only be instantiated by a variable as: the last member of a Block-decorated OpTypeStruct in StorageBuffer or PhysicalStorageBuffer storage Storage Class BufferBlock-decorated OpTypeStruct in the Uniform storage Storage Class the last member of a Block-decorated OpTypeStruct in the Uniform storage Storage Class the outermost dimension of an arrayed variable in the StorageBuffer, Uniform, or UniformConstant storage Storage Class the NodePayloadAMDX storage Storage Class when the CoalescingAMDX Execution Mode is specified", 548}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeSampledImage-06671", 45}, { {"OpTypeSampledImage must have a OpTypeImage with a \"Sampled\" operand of 1 (sampled image)", 90}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpTypeUntypedPointerKHR-11417", 50}, { {"The Storage Class of OpTypeUntypedPointerKHR must be Image, UniformConstant,Workgroup, StorageBuffer, Uniform, PushConstant, or PhysicalStorageBuffer", 149}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpUntypedImageTexelPointerEXT-11416", 56}, { {"If an OpUntypedImageTexelPointerEXT instruction is used in an atomic operation, the image type operand must have an image format of R64i, R64ui, R32f, R32i, or R32ui", 165}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpUntypedVariableKHR-11167", 47}, { {"Any OpUntypedVariableKHR with a Storage Class other than UniformConstant must have a Data Type operand specified", 112}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpUntypedVariableKHR-11347", 47}, { {"Any OpUntypedVariableKHR in the UniformConstant storage class without a Data Type must be decorated with SamplerHeapEXT or ResourceHeapEXT", 138}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpVariable-04651", 37}, { {"Any variable with an Initializer operand must have Output, Private, Function, or Workgroup as its Storage Class operand", 119}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpVariable-04734", 37}, { {"Any variable with an Initializer operand and Workgroup as its Storage Class operand must use OpConstantNull as the initializer", 126}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OpVariable-06673", 37}, { {"There must not be more than one variable in the PushConstant Storage Class listed in the Interface for each OpEntryPoint", 120}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-OriginLowerLeft-04653", 42}, { {"The OriginLowerLeft Execution Mode must not be used; fragment entry points must declare OriginUpperLeft", 103}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Output-10586", 33}, { {"Variables in the Output storage class in the Vertex, TessellationControl, TessellationEvaluation, or Geometry execution model must not have overlapping Component and Location decorations as defined by Location and Component Assignment", 234}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Output-10587", 33}, { {"Variables in the Output storage class in the Fragment execution model must not have both identical Index decorations and overlapping Component and Location decorations as defined by Location and Component Assignment", 215}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-PerVertexKHR-06777", 39}, { {"The PerVertexKHR decoration must only be used on variables with the Input Storage Class in a fragment shader", 108}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04708", 50}, { {"If the PhysicalStorageBuffer64 addressing model is enabled, all instructions that support memory access operands and that use a physical pointer must include the Aligned operand", 177}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04709", 50}, { {"If the PhysicalStorageBuffer64 addressing model is enabled, any access chain instruction that accesses into a RowMajor matrix must only be used as the Pointer operand to OpLoad or OpStore", 187}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04710", 50}, { {"If the PhysicalStorageBuffer64 addressing model is enabled, OpConvertUToPtr and OpConvertPtrToU must use an integer type whose Width is 64", 138}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-06314", 50}, { {"If the PhysicalStorageBuffer64 addressing model is enabled any load or store through a physical pointer type must have an Aligned operand which is a multiple of the size of the largest scalar type in the pointed-to type", 219}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-PixelCenterInteger-04654", 45}, { {"The PixelCenterInteger Execution Mode must not be used (pixels are always centered at half-integer coordinates)", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Pointer-08973", 34}, { {"The Storage Class of the Pointer operand to OpCooperativeMatrixLoadKHR or OpCooperativeMatrixStoreKHR must be limited to Workgroup, StorageBuffer, or PhysicalStorageBuffer", 171}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-PushConstant-06675", 39}, { {"Any variable in the PushConstant or StorageBuffer storage class must be decorated as Block", 90}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-PushConstant-06808", 39}, { {"Any variable in the PushConstant Storage Class must be typed as OpTypeStruct", 76}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-RayPayloadKHR-04698", 40}, { {"RayPayloadKHR Storage Class must only be used in ray generation, closest hit or miss shaders", 92}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Result-04780", 33}, { {"The Result Type operand of any OpImageRead or OpImageSparseRead instruction must be a vector of four components", 111}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Result-11336", 33}, { {"If the Result Type operand of OpLoad is OpTypeSampler, Pointer must be derived from a variable decorated with Binding and DescriptorSet, or decorated with BuiltIn and SamplerHeapEXT", 181}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Result-11337", 33}, { {"If the Result Type operand of OpLoad is OpTypeImage, Pointer must be derived from a variable decorated with Binding and DescriptorSet, or decorated with BuiltIn and ResourceHeapEXT", 180}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Result-11339", 33}, { {"If the Result Type operand of OpLoad is OpTypeAccelerationStructureKHR, and Pointer is not in the Private or Function Storage Class, Pointer must be derived from a variable decorated with Binding and DescriptorSet, or decorated with BuiltIn and ResourceHeapEXT", 260}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Result-11346", 33}, { {"The Result Type operand of OpBufferPointerEXT must have a Type operand that is explicitly laid out", 98}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-SampledImageArrayDynamicIndexing-10128", 59}, { {"If the SampledImageArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a sampled image or sampler, the sampled image or sampler through which that memory is accessed must be determined by constant integral expressions", 257}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Scope-12243", 32}, { {"The Scope operand of OpTypeCooperativeMatrixKHR must be limited to Workgroup or Subgroup", 88}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-ShaderRecordBufferKHR-07119", 48}, { {"ShaderRecordBufferKHR Storage Class must only be used in ray generation, intersection, any-hit, closest hit, callable, or miss shaders", 134}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-StorageBufferArrayDynamicIndexing-10129", 60}, { {"If the StorageBufferArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a storage buffer, the storage buffer through which that memory is accessed must be determined by constant integral expressions", 238}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-StorageImageArrayDynamicIndexing-10130", 59}, { {"If the StorageImageArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a storage image, the storage image through which that memory is accessed must be determined by constant integral expressions", 235}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-StorageTexelBufferArrayDynamicIndexing-10133", 65}, { {"If the StorageTexelBufferArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a storage texel buffer, the storage texel buffer through which that memory is accessed must be determined by constant integral expressions", 255}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Stream-04694", 33}, { {"If any variables or block members in the output interface of the entry point being compiled are decorated with Stream, then all variables belonging to the same XfbBuffer must specify the same Stream value", 204}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-SubgroupVoteKHR-07951", 42}, { {"If none of the SubgroupVoteKHR, GroupNonUniform, or SubgroupBallotKHR capabilities are declared, Scope for memory must not be Subgroup", 134}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-SubpassData-04660", 38}, { {"The (u,v) coordinates used for a SubpassData must be the of a constant vector (0,0)", 83}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TessLevelInner-10880", 41}, { {"Any variable decorated with TessLevelInner or TessLevelOuter must also be decorated with Patch", 94}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TileAttachmentQCOM-10689", 45}, { {"If the TileAttachmentQCOM Storage Class is used, the TileShadingQCOM capability must be enabled", 95}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TileAttachmentQCOM-10695", 45}, { {"Any variable in the TileAttachmentQCOM Storage Class must be decorated with DescriptorSet and Binding", 101}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TileAttachmentQCOM-10696", 45}, { {"Any variable in the TileAttachmentQCOM Storage Class must not be decorated with Component decoration", 100}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TileAttachmentQCOM-10697", 45}, { {"An OpTypeImage variables in the TileAttachmentQCOM Storage Class must not be consumed by an OpImageQuery* instruction", 117}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TileImageEXT-08723", 39}, { {"The tile image variable declarations must obey the constraints on the TileImageEXT Storage Class and the Location decoration described in Fragment Tile Image Interface", 167}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TileShadingQCOM-10686", 42}, { {"TileShadingQCOM capability must not be enabled in any stage other than compute or fragment", 90}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TileShadingRateQCOM-10691", 46}, { {"If the TileShadingRateQCOM Execution Mode is used, the TileShadingQCOM capability must be enabled", 97}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-TileShadingRateQCOM-10692", 46}, { {"If the TileShadingRateQCOM Execution Mode is used, LocalSize and LocalSizeId Execution Mode must not be specified", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UnequalMemorySemantics-10875", 49}, { {"UnequalMemorySemantics of OpAtomicCompareExchange must not use Release or AcquireRelease memory order", 101}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UnequalMemorySemantics-10876", 49}, { {"UnequalMemorySemantics of OpAtomicCompareExchange must not use a stronger memory order than the corresponding EqualMemorySemantics", 130}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UnequalMemorySemantics-10877", 49}, { {"UnequalMemorySemantics of OpAtomicCompareExchange must not have any Vulkan-supported storage class semantics bit set (UniformMemory, WorkgroupMemory, ImageMemory, or OutputMemory) unless this bit is also set in the corresponding EqualMemorySemantics", 249}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UnequalMemorySemantics-10878", 49}, { {"UnequalMemorySemantics of OpAtomicCompareExchange must not have MakeVisible bit set unless this bit is also set in the corresponding EqualMemorySemantics", 153}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UnequalMemorySemantics-10879", 49}, { {"UnequalMemorySemantics of OpAtomicCompareExchange must have Volatile bit set if and only if this bit is also set in the corresponding EqualMemorySemantics", 154}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Uniform-06676", 34}, { {"Any variable in the Uniform Storage Class must be decorated as Block or BufferBlock", 83}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Uniform-06807", 34}, { {"Any variable in the Uniform or StorageBuffer Storage Class must be typed as OpTypeStruct or an array of this type", 113}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-Uniform-06925", 34}, { {"Any variable in the Uniform Storage Class decorated as Block must not be stored to or modified", 94}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UniformBufferArrayDynamicIndexing-10127", 60}, { {"If the UniformBufferArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a uniform buffer, the uniform buffer through which that memory is accessed must be determined by constant integral expressions", 238}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UniformConstant-04655", 42}, { {"Any variable in the UniformConstant Storage Class must be typed as either OpTypeImage, OpTypeSampler, OpTypeSampledImage, OpTypeAccelerationStructureKHR, OpTypeTensorARM or an array of one of these types", 203}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UniformConstant-06677", 42}, { {"Any variable in the UniformConstant, StorageBuffer, or Uniform Storage Class must be decorated with DescriptorSet, Binding, or BuiltIn with SamplerHeapEXT or ResourceHeapEXT", 173}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-UniformTexelBufferArrayDynamicIndexing-10132", 65}, { {"If the UniformTexelBufferArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a uniform texel buffer, the uniform texel buffer through which that memory is accessed must be determined by constant integral expressions", 255}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-ViewportMaskNV-04674", 41}, { {"The ViewportMaskNV and ViewportIndex decorations must not both be statically used by one or more OpEntryPoint's that form the pre-rasterization shader stages of a graphics pipeline", 180}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-ViewportRelativeNV-04672", 45}, { {"The ViewportRelativeNV decoration must only be used on a variable decorated with Layer in the vertex, tessellation evaluation, or geometry shader stages", 152}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-ViewportRelativeNV-04673", 45}, { {"The ViewportRelativeNV decoration must not be used unless a variable decorated with one of ViewportIndex or ViewportMaskNV is also statically used by the same OpEntryPoint", 171}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-VulkanMemoryModel-04678", 44}, { {"If the VulkanMemoryModel capability is not declared, the Volatile decoration must be used on any variable declaration that includes one of the SMIDNV, WarpIDNV, SubgroupSize, SubgroupLocalInvocationId, SubgroupEqMask, SubgroupGeMask, SubgroupGtMask, SubgroupLeMask, or SubgroupLtMask BuiltIn decorations when used in the ray generation, closest hit, miss, intersection, or callable shaders, or with the RayTmaxKHR Builtin decoration when used in an intersection shader", 468}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-VulkanMemoryModel-04679", 44}, { {"If the VulkanMemoryModel capability is declared, the OpLoad instruction must use MemorySemantics with the Volatile flag when it accesses into any variable that includes one of the SMIDNV, WarpIDNV, SubgroupSize, SubgroupLocalInvocationId, SubgroupEqMask, SubgroupGeMask, SubgroupGtMask, SubgroupLeMask, or SubgroupLtMask BuiltIn decorations when used in the ray generation, closest hit, miss, intersection, or callable shaders, or with the RayTmaxKHR Builtin decoration when used in an intersection shader", 505}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-XfbBuffer-04693", 36}, { {"All variables or block members in the output interface of the entry point being compiled decorated with a specific XfbBuffer value must all be decorated with identical XfbStride values", 184}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-XfbBuffer-04696", 36}, { {"For any two variables or block members in the output interface of the entry point being compiled with the same XfbBuffer value, the ranges determined by the Offset decoration and the size of the type must not overlap", 216}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-StandaloneSpirv-XfbBuffer-04697", 36}, { {"All block members in the output interface of the entry point being compiled that are in the same block and have a declared or inherited XfbBuffer decoration must specify the same XfbBuffer value", 194}, { "appendices/spirvenv.html", 24} } },
        { {"VUID-SubgroupEqMask-SubgroupEqMask-04370", 40}, { {"The variable decorated with SubgroupEqMask must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupEqMask-SubgroupEqMask-04371", 40}, { {"The variable decorated with SubgroupEqMask must be declared as a four-component vector of 32-bit integer values", 111}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupGeMask-SubgroupGeMask-04372", 40}, { {"The variable decorated with SubgroupGeMask must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupGeMask-SubgroupGeMask-04373", 40}, { {"The variable decorated with SubgroupGeMask must be declared as a four-component vector of 32-bit integer values", 111}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupGtMask-SubgroupGtMask-04374", 40}, { {"The variable decorated with SubgroupGtMask must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupGtMask-SubgroupGtMask-04375", 40}, { {"The variable decorated with SubgroupGtMask must be declared as a four-component vector of 32-bit integer values", 111}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupId-SubgroupId-04367", 32}, { {"The SubgroupId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", 117}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupId-SubgroupId-04368", 32}, { {"The variable decorated with SubgroupId must be declared using the Input Storage Class", 85}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupId-SubgroupId-04369", 32}, { {"The variable decorated with SubgroupId must be declared as a scalar 32-bit integer value", 88}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupLeMask-SubgroupLeMask-04376", 40}, { {"The variable decorated with SubgroupLeMask must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupLeMask-SubgroupLeMask-04377", 40}, { {"The variable decorated with SubgroupLeMask must be declared as a four-component vector of 32-bit integer values", 111}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupLocalInvocationId-SubgroupLocalInvocationId-04380", 62}, { {"The variable decorated with SubgroupLocalInvocationId must be declared using the Input Storage Class", 100}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupLocalInvocationId-SubgroupLocalInvocationId-04381", 62}, { {"The variable decorated with SubgroupLocalInvocationId must be declared as a scalar 32-bit integer value", 103}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupLtMask-SubgroupLtMask-04378", 40}, { {"The variable decorated with SubgroupLtMask must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupLtMask-SubgroupLtMask-04379", 40}, { {"The variable decorated with SubgroupLtMask must be declared as a four-component vector of 32-bit integer values", 111}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupSize-SubgroupSize-04382", 36}, { {"The variable decorated with SubgroupSize must be declared using the Input Storage Class", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-SubgroupSize-SubgroupSize-04383", 36}, { {"The variable decorated with SubgroupSize must be declared as a scalar 32-bit integer value", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TaskCountNV-TaskCountNV-04384", 34}, { {"The TaskCountNV decoration must be used only within the TaskNV Execution Model", 78}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TaskCountNV-TaskCountNV-04385", 34}, { {"The variable decorated with TaskCountNV must be declared using the Output Storage Class", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TaskCountNV-TaskCountNV-04386", 34}, { {"The variable decorated with TaskCountNV must be declared as a scalar 32-bit integer value", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessCoord-TessCoord-04387", 30}, { {"The TessCoord decoration must be used only within the TessellationEvaluation Execution Model", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessCoord-TessCoord-04388", 30}, { {"The variable decorated with TessCoord must be declared using the Input Storage Class", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessCoord-TessCoord-04389", 30}, { {"The variable decorated with TessCoord must be declared as a three-component vector of 32-bit floating-point values", 114}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessLevelInner-TessLevelInner-04394", 40}, { {"The TessLevelInner decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", 120}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessLevelInner-TessLevelInner-04395", 40}, { {"The variable decorated with TessLevelInner within the TessellationControl Execution Model must be declared using the Output Storage Class", 137}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessLevelInner-TessLevelInner-04396", 40}, { {"The variable decorated with TessLevelInner within the TessellationEvaluation Execution Model must be declared using the Input Storage Class", 139}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessLevelInner-TessLevelInner-04397", 40}, { {"The variable decorated with TessLevelInner must be declared as an array of size two, containing 32-bit floating-point values", 124}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessLevelOuter-TessLevelOuter-04390", 40}, { {"The TessLevelOuter decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", 120}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessLevelOuter-TessLevelOuter-04391", 40}, { {"The variable decorated with TessLevelOuter within the TessellationControl Execution Model must be declared using the Output Storage Class", 137}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessLevelOuter-TessLevelOuter-04392", 40}, { {"The variable decorated with TessLevelOuter within the TessellationEvaluation Execution Model must be declared using the Input Storage Class", 139}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TessLevelOuter-TessLevelOuter-04393", 40}, { {"The variable decorated with TessLevelOuter must be declared as an array of size four, containing 32-bit floating-point values", 125}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileApronSizeQCOM-TileApronSizeQCOM-10632", 46}, { {"The TileApronSizeQCOM decoration must be used only within the Fragment Execution Model or GLCompute Execution Model", 115}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileApronSizeQCOM-TileApronSizeQCOM-10633", 46}, { {"The variable decorated with TileApronSizeQCOM must be declared using the Input Storage Class", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileApronSizeQCOM-TileApronSizeQCOM-10634", 46}, { {"The variable decorated with TileApronSizeQCOM must be declared as a two-component vector of 32-bit integer values", 113}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileDimensionQCOM-TileDimensionQCOM-10629", 46}, { {"The TileDimensionQCOM decoration must be used only within the Fragment Execution Model or GLCompute Execution Model", 115}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileDimensionQCOM-TileDimensionQCOM-10630", 46}, { {"The variable decorated with TileDimensionQCOM must be declared using the Input Storage Class", 92}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileDimensionQCOM-TileDimensionQCOM-10631", 46}, { {"The variable decorated with TileDimensionQCOM must be declared as a two-component vector of 32-bit integer values", 113}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileOffsetQCOM-TileOffsetQCOM-10626", 40}, { {"The TileOffsetQCOM decoration must be used only within the Fragment Execution Model or GLCompute Execution Model", 112}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileOffsetQCOM-TileOffsetQCOM-10627", 40}, { {"The variable decorated with TileOffsetQCOM must be declared using the Input Storage Class", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-TileOffsetQCOM-TileOffsetQCOM-10628", 40}, { {"The variable decorated with TileOffsetQCOM must be declared as a two-component vector of 32-bit integer values", 110}, { "chapters/interfaces.html", 24} } },
        { {"VUID-VertexCountHUAWEI-VertexCountHUAWEI-07809", 46}, { {"The VertexCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", 98}, { "chapters/interfaces.html", 24} } },
        { {"VUID-VertexCountHUAWEI-VertexCountHUAWEI-07810", 46}, { {"The variable decorated with VertexCountHUAWEI must be declared as a scalar 32-bit integer value", 95}, { "chapters/interfaces.html", 24} } },
        { {"VUID-VertexIndex-VertexIndex-04398", 34}, { {"The VertexIndex decoration must be used only within the Vertex Execution Model", 78}, { "chapters/interfaces.html", 24} } },
        { {"VUID-VertexIndex-VertexIndex-04399", 34}, { {"The variable decorated with VertexIndex must be declared using the Input Storage Class", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-VertexIndex-VertexIndex-04400", 34}, { {"The variable decorated with VertexIndex must be declared as a scalar 32-bit integer value", 89}, { "chapters/interfaces.html", 24} } },
        { {"VUID-VertexOffsetHUAWEI-VertexOffsetHUAWEI-07811", 48}, { {"The VertexOffsetHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", 99}, { "chapters/interfaces.html", 24} } },
        { {"VUID-VertexOffsetHUAWEI-VertexOffsetHUAWEI-07812", 48}, { {"The variable decorated with VertexOffsetHUAWEI must be declared as a scalar 32-bit integer value", 96}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewIndex-ViewIndex-04401", 30}, { {"The ViewIndex decoration must be used only within the MeshEXT, Vertex, Geometry, TessellationControl, TessellationEvaluation or Fragment Execution Model", 152}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewIndex-ViewIndex-04402", 30}, { {"The variable decorated with ViewIndex must be declared using the Input Storage Class", 84}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewIndex-ViewIndex-04403", 30}, { {"The variable decorated with ViewIndex must be declared as a scalar 32-bit integer value", 87}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-04404", 38}, { {"The ViewportIndex decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, Geometry, or Fragment Execution Model", 144}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-04405", 38}, { {"If the shaderOutputViewportIndex feature is not enabled then the ViewportIndex decoration must be used only within the Geometry or Fragment Execution Model", 155}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-04406", 38}, { {"The variable decorated with ViewportIndex within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, or Geometry Execution Model must be declared using the Output Storage Class", 177}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-04407", 38}, { {"The variable decorated with ViewportIndex within the Fragment Execution Model must be declared using the Input Storage Class", 124}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-04408", 38}, { {"The variable decorated with ViewportIndex must be declared as a scalar 32-bit integer value for all supported execution models except MeshEXT", 141}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-07060", 38}, { {"The variable decorated with ViewportIndex within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", 135}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-10601", 38}, { {"ViewportIndex within the MeshEXT Execution Model must decorate a scalar 32-bit integer member of a structure decorated as Block, or decorate a variable of type OpTypeArray of scalar 32-bit integer values", 203}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-10602", 38}, { {"If ViewportIndex is declared as an array of 32-bit integer values, within the MeshEXT Execution Model, size of the array must match the value specified by OutputPrimitivesEXT", 174}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportIndex-ViewportIndex-10603", 38}, { {"If ViewportIndex decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", 185}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskNV-ViewportMaskNV-04409", 40}, { {"The ViewportMaskNV decoration must be used only within the Vertex, MeshNV, TessellationEvaluation, or Geometry Execution Model", 126}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskNV-ViewportMaskNV-04410", 40}, { {"The variable decorated with ViewportMaskNV must be declared using the Output Storage Class", 90}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskNV-ViewportMaskNV-04411", 40}, { {"The variable decorated with ViewportMaskNV must be declared as an array of 32-bit integer values", 96}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04412", 54}, { {"The ViewportMaskPerViewNV decoration must be used only within the Vertex, MeshNV, TessellationControl, TessellationEvaluation, or Geometry Execution Model", 154}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04413", 54}, { {"The variable decorated with ViewportMaskPerViewNV must be declared using the Output Storage Class", 97}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04414", 54}, { {"The variable decorated with ViewportMaskPerViewNV must be declared as an array of 32-bit integer values", 103}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04415", 54}, { {"The array decorated with ViewportMaskPerViewNV must be a size less than or equal to 32", 86}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04416", 54}, { {"The array decorated with ViewportMaskPerViewNV must be a size greater than the maximum view in the subpass's view mask", 118}, { "chapters/interfaces.html", 24} } },
        { {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04417", 54}, { {"The array variable decorated with ViewportMaskPerViewNV must only be indexed by a constant or specialization constant", 117}, { "chapters/interfaces.html", 24} } },
        { {"VUID-VkAabbPositionsKHR-minX-03546", 34}, { {"minX must be less than or equal to maxX", 39}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAabbPositionsKHR-minY-03547", 34}, { {"minY must be less than or equal to maxY", 39}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAabbPositionsKHR-minZ-03548", 34}, { {"minZ must be less than or equal to maxZ", 39}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-commonparent", 61}, { {"Both of dstAccelerationStructure, and srcAccelerationStructure that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 182}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-dstAccelerationStructure-04927", 79}, { {"If dstAccelerationStructure was created with VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in VkAccelerationStructureCreateInfoKHR::createFlags, VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV must be set in flags", 216}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-03796", 60}, { {"If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR bit set", 175}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-04928", 60}, { {"If VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in flags, dstAccelerationStructure must have been created with VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in VkAccelerationStructureCreateInfoKHR::createFlags", 222}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-04929", 60}, { {"If VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in flags, type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", 125}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-07334", 60}, { {"If flags has the VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_BIT_EXT bit set then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_BIT_EXT bit set", 203}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-parameter", 64}, { {"flags must be a valid combination of VkBuildAccelerationStructureFlagBitsKHR values", 83}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pGeometries-03788", 66}, { {"If geometryCount is not 0, exactly one of pGeometries or ppGeometries must be a valid pointer, the other must be NULL", 117}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pGeometries-parameter", 70}, { {"If geometryCount is not 0, and pGeometries is not NULL, pGeometries must be a valid pointer to an array of geometryCount valid VkAccelerationStructureGeometryKHR structures", 172}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pNext-pNext", 60}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-ppGeometries-parameter", 71}, { {"If geometryCount is not 0, and ppGeometries is not NULL, ppGeometries must be a valid pointer to an array of geometryCount valid pointers to valid VkAccelerationStructureGeometryKHR structures", 192}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-sType-sType", 60}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR", 78}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03654", 59}, { {"type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", 59}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03789", 59}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, the geometryType member of elements of either pGeometries or ppGeometries must be VK_GEOMETRY_TYPE_INSTANCES_KHR", 169}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03790", 59}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, geometryCount must be 1", 80}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03791", 59}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR the geometryType member of elements of either pGeometries or ppGeometries must not be VK_GEOMETRY_TYPE_INSTANCES_KHR", 175}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03792", 59}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then the geometryType member of each geometry in either pGeometries or ppGeometries must be the same", 159}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03793", 59}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then geometryCount must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxGeometryCount", 176}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03794", 59}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_AABBS_KHR, the total number of AABBs in all geometries must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPrimitiveCount", 299}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03795", 59}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_TRIANGLES_KHR, the total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPrimitiveCount", 307}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-10884", 59}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_DENSE_GEOMETRY_FORMAT_TRIANGLES_AMDX, then geometryCount must be 1", 211}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-parameter", 63}, { {"type must be a valid VkAccelerationStructureTypeKHR value", 57}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildRangeInfoKHR-None-10775", 56}, { {"For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry does not use indices, then VkAccelerationStructureGeometryTrianglesDataKHR::maxVertex must be greater than or equal to firstVertex + primitiveCount x 3 - 1", 226}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildRangeInfoKHR-maxVertex-10774", 61}, { {"For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry uses indices, then VkAccelerationStructureGeometryTrianglesDataKHR::maxVertex must be greater than or equal to firstVertex plus the maximum index value found in the VkAccelerationStructureGeometryTrianglesDataKHR::indexData in the range [primitiveOffset, primitiveOffset primitiveCount x 3]", 361}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03656", 67}, { {"For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry uses indices, the offset primitiveOffset from VkAccelerationStructureGeometryTrianglesDataKHR::indexData must be a multiple of the element size of VkAccelerationStructureGeometryTrianglesDataKHR::indexType", 276}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03657", 67}, { {"For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry does not use indices, the offset primitiveOffset from VkAccelerationStructureGeometryTrianglesDataKHR::vertexData must be a multiple of: the size of the format specified in VkAccelerationStructureGeometryTrianglesDataKHR::vertexFormat, if that format is a packed format the component size of the VkAccelerationStructureGeometryTrianglesDataKHR::vertexFormat, if that format is not a packed format", 467}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03659", 67}, { {"For geometries of type VK_GEOMETRY_TYPE_AABBS_KHR, the offset primitiveOffset from VkAccelerationStructureGeometryAabbsDataKHR::data must be a multiple of 8", 156}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03660", 67}, { {"For geometries of type VK_GEOMETRY_TYPE_INSTANCES_KHR, the offset primitiveOffset from VkAccelerationStructureGeometryInstancesDataKHR::data must be a multiple of 16", 165}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildRangeInfoKHR-transformOffset-03658", 67}, { {"For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, the offset transformOffset from VkAccelerationStructureGeometryTrianglesDataKHR::transformData must be a multiple of 16", 174}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildRangeInfoKHR-vertexData-10418", 62}, { {"The number of vertices consumed from VkAccelerationStructureGeometryTrianglesDataKHR::vertexData must be less than or equal to VkAccelerationStructureGeometryTrianglesDataKHR::maxVertex + 1", 189}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureBuildSizesInfoKHR-pNext-pNext", 57}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureBuildSizesInfoKHR-sType-sType", 57}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR", 75}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-08091", 84}, { {"If accelerationStructure is not VK_NULL_HANDLE then accelerationStructure must have been created with VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkAccelerationStructureCreateInfoKHR::createFlags", 232}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-08093", 84}, { {"If accelerationStructure is not VK_NULL_HANDLE then accelerationStructureNV must be VK_NULL_HANDLE", 98}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-parameter", 88}, { {"If accelerationStructure is not VK_NULL_HANDLE, accelerationStructure must be a valid VkAccelerationStructureKHR handle", 119}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-08092", 86}, { {"If accelerationStructureNV is not VK_NULL_HANDLE then accelerationStructureNV must have been created with VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkAccelerationStructureCreateInfoNV::info.flags", 234}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-08094", 86}, { {"If accelerationStructureNV is not VK_NULL_HANDLE then accelerationStructure must be VK_NULL_HANDLE", 98}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-parameter", 90}, { {"If accelerationStructureNV is not VK_NULL_HANDLE, accelerationStructureNV must be a valid VkAccelerationStructureNV handle", 122}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-commonparent", 69}, { {"Both of accelerationStructure, and accelerationStructureNV that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 178}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-pNext-pNext", 68}, { {"pNext must be NULL", 18}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-sType-sType", 68}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", 87}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-03614", 54}, { {"buffer must have been created with the VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR usage flag set", 108}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-03615", 54}, { {"buffer must not have been created with VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT", 76}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-parameter", 58}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-03613", 59}, { {"If createFlags includes VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR, VkPhysicalDeviceAccelerationStructureFeaturesKHR::accelerationStructureCaptureReplay must be VK_TRUE", 196}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-04954", 59}, { {"If VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV is set in createFlags and type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, one member of the pNext chain must be a pointer to a valid instance of VkAccelerationStructureMotionInfoNV", 236}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-04955", 59}, { {"If any geometry includes VkAccelerationStructureGeometryMotionTrianglesDataNV then createFlags must contain VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV", 154}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-08108", 59}, { {"If createFlags includes VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", 156}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-parameter", 63}, { {"createFlags must be a valid combination of VkAccelerationStructureCreateFlagBitsKHR values", 90}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-03612", 61}, { {"If deviceAddress is not zero, createFlags must include VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR", 125}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09488", 61}, { {"If deviceAddress is not zero, it must have been retrieved from an identically created acceleration structure, except for buffer and deviceAddress", 145}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09489", 61}, { {"If deviceAddress is not zero, buffer must have been created identically to the buffer used to create the acceleration structure from which deviceAddress was retrieved, except for VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress", 239}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09490", 61}, { {"If deviceAddress is not zero, buffer must have been created with a VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress that was retrieved from vkGetBufferOpaqueCaptureAddress for the buffer that was used to create the acceleration structure from which deviceAddress was retrieved", 288}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-parameter", 65}, { {"If deviceAddress is not 0, deviceAddress must be a valid VkDeviceAddress value", 78}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-offset-03616", 54}, { {"The sum of offset and size must be less than or equal to the size of buffer", 75}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-offset-03734", 54}, { {"offset must be a multiple of 256 bytes", 38}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-pNext-08109", 53}, { {"If the pNext chain includes a VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, createFlags must contain VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT", 182}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-pNext-pNext", 53}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAccelerationStructureMotionInfoNV or VkOpaqueCaptureDescriptorDataCreateInfoEXT", 212}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR", 70}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-sType-unique", 54}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoKHR-type-parameter", 56}, { {"type must be a valid VkAccelerationStructureTypeKHR value", 57}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoNV-compactedSize-02421", 60}, { {"If compactedSize is not 0 then both info.geometryCount and info.instanceCount must be 0", 87}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoNV-info-parameter", 55}, { {"info must be a valid VkAccelerationStructureInfoNV structure", 60}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoNV-pNext-pNext", 52}, { {"pNext must be NULL or a pointer to a valid instance of VkOpaqueCaptureDescriptorDataCreateInfoEXT", 97}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoNV-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV", 69}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureCreateInfoNV-sType-unique", 53}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-compressedData-10885", 85}, { {"The buffer from which compressedData.deviceAddress is queried must have been created with the VK_BUFFER_USAGE_2_COMPRESSED_DATA_DGF1_BIT_AMDX usage flag set", 156}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-compressedData-parameter", 89}, { {"compressedData must be a valid VkDeviceOrHostAddressConstKHR union", 66}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-denseGeometryFormat-10886", 90}, { {"The VkPhysicalDeviceDenseGeometryFormatFeaturesAMDX::denseGeometryFormat feature must be enabled", 96}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-format-10887", 77}, { {"If format is VK_COMPRESSED_TRIANGLE_FORMAT_DGF1_AMDX, then compressedData must be aligned to VK_COMPRESSED_TRIANGLE_FORMAT_DGF1_BYTE_ALIGNMENT_AMDX (128) bytes", 159}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-format-10888", 77}, { {"If format is VK_COMPRESSED_TRIANGLE_FORMAT_DGF1_AMDX, then dataSize must be a multiple of VK_COMPRESSED_TRIANGLE_FORMAT_DGF1_BYTE_STRIDE_AMDX (128) bytes", 153}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-format-parameter", 81}, { {"format must be a valid VkCompressedTriangleFormatAMDX value", 59}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-pNext-10890", 76}, { {"pNext must be NULL or a pointer to a valid VkAccelerationStructureTrianglesOpacityMicromapEXT structure", 103}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-pNext-10891", 76}, { {"If pNext is a pointer to a valid VkAccelerationStructureTrianglesOpacityMicromapEXT structure, the micromap feature must be enabled", 131}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX-sType-sType", 76}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DENSE_GEOMETRY_FORMAT_TRIANGLES_DATA_AMDX", 96}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-accelerationStructure-parameter", 80}, { {"accelerationStructure must be a valid VkAccelerationStructureKHR handle", 71}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-pNext-pNext", 60}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-sType-sType", 60}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR", 78}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-pNext-pNext", 60}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-sType-sType", 60}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR", 78}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-stride-03545", 61}, { {"stride must be a multiple of 8", 30}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-stride-03820", 61}, { {"stride must be less than or equal to 2^32-1", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryInstancesDataKHR-pNext-pNext", 64}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryInstancesDataKHR-sType-sType", 64}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR", 82}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryKHR-aabbs-parameter", 55}, { {"If geometryType is VK_GEOMETRY_TYPE_AABBS_KHR, the aabbs member of geometry must be a valid VkAccelerationStructureGeometryAabbsDataKHR structure", 145}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryKHR-flags-parameter", 55}, { {"flags must be a valid combination of VkGeometryFlagBitsKHR values", 65}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryKHR-geometryType-parameter", 62}, { {"geometryType must be a valid VkGeometryTypeKHR value", 52}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryKHR-instances-parameter", 59}, { {"If geometryType is VK_GEOMETRY_TYPE_INSTANCES_KHR, the instances member of geometry must be a valid VkAccelerationStructureGeometryInstancesDataKHR structure", 157}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryKHR-pNext-pNext", 51}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAccelerationStructureDenseGeometryFormatTrianglesDataAMDX, VkAccelerationStructureGeometryLinearSweptSpheresDataNV, or VkAccelerationStructureGeometrySpheresDataNV", 296}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryKHR-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR", 67}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryKHR-sType-unique", 52}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryKHR-triangles-parameter", 59}, { {"If geometryType is VK_GEOMETRY_TYPE_TRIANGLES_KHR, the triangles member of geometry must be a valid VkAccelerationStructureGeometryTrianglesDataKHR structure", 157}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-None-10419", 71}, { {"The linearSweptSpheres feature must be enabled", 46}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-endCapsMode-parameter", 82}, { {"endCapsMode must be a valid VkRayTracingLssPrimitiveEndCapsModeNV value", 71}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexData-10428", 76}, { {"indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_KHR", 87}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexData-parameter", 80}, { {"indexData must be a valid VkDeviceOrHostAddressConstKHR union", 61}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexType-parameter", 80}, { {"indexType must be a valid VkIndexType value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexingMode-10427", 79}, { {"If indexingMode is VK_RAY_TRACING_LSS_INDEXING_MODE_SUCCESSIVE_NV, indexData must not be NULL", 93}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexingMode-parameter", 83}, { {"indexingMode must be a valid VkRayTracingLssIndexingModeNV value", 64}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusData-10426", 77}, { {"All values referenced in radiusData must be greater than or equal to 0", 70}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusData-parameter", 81}, { {"radiusData must be a valid VkDeviceOrHostAddressConstKHR union", 62}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusFormat-10424", 79}, { {"The format features of radiusFormat must contain VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_RADIUS_BUFFER_BIT_NV", 112}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusFormat-parameter", 83}, { {"radiusFormat must be a valid VkFormat value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-sType-sType", 72}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_LINEAR_SWEPT_SPHERES_DATA_NV", 92}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexData-parameter", 81}, { {"vertexData must be a valid VkDeviceOrHostAddressConstKHR union", 62}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexFormat-10423", 79}, { {"The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", 111}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexFormat-parameter", 83}, { {"vertexFormat must be a valid VkFormat value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexStride-10421", 79}, { {"vertexStride must be a multiple of: the size of the format specified in vertexFormat if that format is a packed format the component size specified in vertexFormat if that format is not a packed format", 201}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexStride-10422", 79}, { {"vertexStride and radiusStride must be less than or equal to 2^32-1", 66}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryMotionTrianglesDataNV-sType-sType", 69}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV", 88}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-None-10429", 60}, { {"The spheres feature must be enabled", 35}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-indexData-10437", 65}, { {"indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, VK_INDEX_TYPE_NONE_KHR", 84}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-indexData-parameter", 69}, { {"indexData must be a valid VkDeviceOrHostAddressConstKHR union", 61}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-indexType-parameter", 69}, { {"indexType must be a valid VkIndexType value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusData-10436", 66}, { {"All values referenced in radiusData must be greater than or equal to 0", 70}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusData-parameter", 70}, { {"radiusData must be a valid VkDeviceOrHostAddressConstKHR union", 62}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusFormat-10435", 68}, { {"The format features of radiusFormat must contain VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_RADIUS_BUFFER_BIT_NV", 112}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusFormat-parameter", 72}, { {"radiusFormat must be a valid VkFormat value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-sType-sType", 61}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_SPHERES_DATA_NV", 79}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexData-parameter", 70}, { {"vertexData must be a valid VkDeviceOrHostAddressConstKHR union", 62}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexFormat-10434", 68}, { {"The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", 111}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexFormat-parameter", 72}, { {"vertexFormat must be a valid VkFormat value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexStride-10431", 68}, { {"vertexStride must be a multiple of: the size of the format specified in vertexFormat if that format is a packed format the smallest component size specified in vertexFormat if that format is not a packed format", 210}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexStride-10432", 68}, { {"vertexStride and radiusStride must be less than or equal to 2^32-1", 66}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-indexType-03798", 68}, { {"indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_KHR", 87}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-indexType-parameter", 72}, { {"indexType must be a valid VkIndexType value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-pNext-pNext", 64}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAccelerationStructureGeometryMotionTrianglesDataNV, VkAccelerationStructureTrianglesDisplacementMicromapNV, or VkAccelerationStructureTrianglesOpacityMicromapEXT", 294}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-sType-sType", 64}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR", 82}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-sType-unique", 65}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat-03797", 71}, { {"The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", 111}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat-parameter", 75}, { {"vertexFormat must be a valid VkFormat value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexStride-03735", 71}, { {"vertexStride must be a multiple of the size in bytes of the smallest component of vertexFormat", 94}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexStride-03819", 71}, { {"vertexStride must be less than or equal to 2^32-1", 49}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureInfoNV-flags-02592", 46}, { {"If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV bit set", 173}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-flags-parameter", 50}, { {"flags must be a valid combination of VkBuildAccelerationStructureFlagBitsNV values", 82}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-geometryCount-02422", 54}, { {"geometryCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxGeometryCount", 100}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-instanceCount-02423", 54}, { {"instanceCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxInstanceCount", 100}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-instanceData-02782", 53}, { {"If instanceData is not VK_NULL_HANDLE, instanceData must have been created with the VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag set", 133}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-maxTriangleCount-02424", 57}, { {"The total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxTriangleCount", 134}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-pGeometries-parameter", 56}, { {"If geometryCount is not 0, pGeometries must be a valid pointer to an array of geometryCount valid VkGeometryNV structures", 121}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-pNext-pNext", 46}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV", 62}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-scratch-02781", 48}, { {"scratch must have been created with the VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag set", 89}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-type-02425", 45}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV then geometryCount must be 0", 83}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-type-02426", 45}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then instanceCount must be 0", 86}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-type-02786", 45}, { {"If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then the geometryType member of each geometry in pGeometries must be the same", 135}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-type-04623", 45}, { {"type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", 59}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInfoNV-type-parameter", 49}, { {"type must be a valid VkAccelerationStructureTypeNV value", 56}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureInstanceKHR-flags-parameter", 55}, { {"flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", 73}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureMatrixMotionInstanceNV-flags-parameter", 66}, { {"flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", 73}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-accelerationStructure-parameter", 84}, { {"accelerationStructure must be a valid VkAccelerationStructureNV handle", 70}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-pNext-pNext", 64}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-sType-sType", 64}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV", 82}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-type-parameter", 67}, { {"type must be a valid VkAccelerationStructureMemoryRequirementsTypeNV value", 74}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureMotionInfoNV-flags-zerobitmask", 58}, { {"flags must be 0", 15}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureMotionInfoNV-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV", 69}, { "chapters/resources.html", 23} } },
        { {"VUID-VkAccelerationStructureMotionInstanceNV-flags-zerobitmask", 62}, { {"flags must be 0", 15}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureMotionInstanceNV-matrixMotionInstance-parameter", 75}, { {"If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV, the matrixMotionInstance member of data must be a valid VkAccelerationStructureMatrixMotionInstanceNV structure", 187}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureMotionInstanceNV-srtMotionInstance-parameter", 72}, { {"If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV, the srtMotionInstance member of data must be a valid VkAccelerationStructureSRTMotionInstanceNV structure", 178}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureMotionInstanceNV-staticInstance-parameter", 69}, { {"If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV, the staticInstance member of data must be a valid VkAccelerationStructureInstanceKHR structure", 163}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureMotionInstanceNV-type-parameter", 59}, { {"type must be a valid VkAccelerationStructureMotionInstanceTypeNV value", 70}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureSRTMotionInstanceNV-flags-parameter", 63}, { {"flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", 73}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementBiasAndScaleFormat-09501", 96}, { {"displacementBiasAndScaleFormat must not be VK_FORMAT_UNDEFINED", 62}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementBiasAndScaleFormat-parameter", 100}, { {"displacementBiasAndScaleFormat must be a valid VkFormat value", 61}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementVectorFormat-09502", 90}, { {"displacementVectorFormat must not be VK_FORMAT_UNDEFINED", 56}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementVectorFormat-parameter", 94}, { {"displacementVectorFormat must be a valid VkFormat value", 55}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-indexType-parameter", 79}, { {"indexType must be a valid VkIndexType value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-micromap-parameter", 78}, { {"If micromap is not VK_NULL_HANDLE, micromap must be a valid VkMicromapEXT handle", 80}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-pUsageCounts-07992", 78}, { {"Only one of pUsageCounts or ppUsageCounts can be a valid pointer, the other must be NULL", 88}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-pUsageCounts-parameter", 82}, { {"If usageCountsCount is not 0, and pUsageCounts is not NULL, pUsageCounts must be a valid pointer to an array of usageCountsCount VkMicromapUsageEXT structures", 158}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-ppUsageCounts-parameter", 83}, { {"If usageCountsCount is not 0, and ppUsageCounts is not NULL, ppUsageCounts must be a valid pointer to an array of usageCountsCount valid pointers to VkMicromapUsageEXT structures", 178}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-sType-sType", 71}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV", 89}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-10719", 71}, { {"indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_KHR", 87}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-10722", 71}, { {"If indexType is not VK_INDEX_TYPE_NONE_KHR, then indexStride must be a multiple of the size in bytes of indexType", 113}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-10723", 71}, { {"If indexType is not VK_INDEX_TYPE_NONE_KHR, then indexStride must be less than or equal to 2^32-1", 97}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-parameter", 75}, { {"indexType must be a valid VkIndexType value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-micromap-parameter", 74}, { {"If micromap is not VK_NULL_HANDLE, micromap must be a valid VkMicromapEXT handle", 80}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-pUsageCounts-07335", 74}, { {"Only one of pUsageCounts or ppUsageCounts can be a valid pointer, the other must be NULL", 88}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-pUsageCounts-parameter", 78}, { {"If usageCountsCount is not 0, and pUsageCounts is not NULL, pUsageCounts must be a valid pointer to an array of usageCountsCount VkMicromapUsageEXT structures", 158}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-ppUsageCounts-parameter", 79}, { {"If usageCountsCount is not 0, and ppUsageCounts is not NULL, ppUsageCounts must be a valid pointer to an array of usageCountsCount valid pointers to VkMicromapUsageEXT structures", 178}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-sType-sType", 67}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT", 85}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureVersionInfoKHR-pNext-pNext", 54}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureVersionInfoKHR-pVersionData-parameter", 65}, { {"pVersionData must be a valid pointer to an array of \\(2 \\times \\mathtt{VK\\_UUID\\_SIZE}\\) uint8_t values", 109}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAccelerationStructureVersionInfoKHR-sType-sType", 54}, { {"sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR", 71}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkAcquireNextImageInfoKHR-commonparent", 43}, { {"Each of fence, semaphore, and swapchain that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 159}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01290", 47}, { {"deviceMask must be a valid device mask", 38}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01291", 47}, { {"deviceMask must not be zero", 27}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-fence-01289", 42}, { {"If fence is not VK_NULL_HANDLE, fence must be unsignaled", 56}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-fence-10067", 42}, { {"If fence is not VK_NULL_HANDLE, fence must not be associated with any other queue command that has not yet completed execution on that queue", 140}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-fence-parameter", 46}, { {"If fence is not VK_NULL_HANDLE, fence must be a valid VkFence handle", 68}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-pNext-pNext", 42}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR", 59}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-semaphore-01288", 46}, { {"If semaphore is not VK_NULL_HANDLE, it must be unsignaled", 57}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-semaphore-01781", 46}, { {"If semaphore is not VK_NULL_HANDLE, it must not have any uncompleted signal or wait operations pending", 102}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-semaphore-01782", 46}, { {"semaphore and fence must not both be equal to VK_NULL_HANDLE", 60}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-semaphore-03266", 46}, { {"semaphore must have a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY", 65}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-semaphore-parameter", 50}, { {"If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle", 80}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-swapchain-01675", 46}, { {"swapchain must not be in the retired state", 42}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireNextImageInfoKHR-swapchain-parameter", 50}, { {"swapchain must be a valid VkSwapchainKHR handle", 47}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAcquireProfilingLockInfoKHR-flags-zerobitmask", 52}, { {"flags must be 0", 15}, { "chapters/queries.html", 21} } },
        { {"VUID-VkAcquireProfilingLockInfoKHR-pNext-pNext", 46}, { {"pNext must be NULL", 18}, { "chapters/queries.html", 21} } },
        { {"VUID-VkAcquireProfilingLockInfoKHR-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR", 63}, { "chapters/queries.html", 21} } },
        { {"VUID-VkAllocationCallbacks-pfnAllocation-00632", 46}, { {"pfnAllocation must be a valid pointer to a valid application-defined PFN_vkAllocationFunction", 93}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAllocationCallbacks-pfnFree-00634", 40}, { {"pfnFree must be a valid pointer to a valid application-defined PFN_vkFreeFunction", 81}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAllocationCallbacks-pfnInternalAllocation-00635", 54}, { {"If either of pfnInternalAllocation or pfnInternalFree is not NULL, both must be valid callbacks", 95}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAllocationCallbacks-pfnReallocation-00633", 48}, { {"pfnReallocation must be a valid pointer to a valid application-defined PFN_vkReallocationFunction", 97}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAmigoProfilingSubmitInfoSEC-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC", 63}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkAndroidHardwareBufferFormatProperties2ANDROID-sType-sType", 64}, { {"sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID", 83}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAndroidHardwareBufferFormatPropertiesANDROID-sType-sType", 63}, { {"sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID", 81}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAndroidHardwareBufferFormatResolvePropertiesANDROID-sType-sType", 70}, { {"sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID", 89}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAndroidHardwareBufferPropertiesANDROID-pNext-pNext", 57}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAndroidHardwareBufferFormatProperties2ANDROID, VkAndroidHardwareBufferFormatPropertiesANDROID, or VkAndroidHardwareBufferFormatResolvePropertiesANDROID", 284}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-sType", 57}, { {"sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID", 74}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-unique", 58}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/memory.html", 20} } },
        { {"VUID-VkAndroidHardwareBufferUsageANDROID-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID", 69}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkAndroidSurfaceCreateInfoKHR-flags-zerobitmask", 52}, { {"flags must be 0", 15}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAndroidSurfaceCreateInfoKHR-pNext-pNext", 46}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAndroidSurfaceCreateInfoKHR-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR", 63}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAndroidSurfaceCreateInfoKHR-window-01248", 47}, { {"window must point to a valid Android ANativeWindow", 50}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAntiLagDataAMD-mode-parameter", 36}, { {"mode must be a valid VkAntiLagModeAMD value", 43}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAntiLagDataAMD-pPresentationInfo-parameter", 49}, { {"If pPresentationInfo is not NULL, pPresentationInfo must be a valid pointer to a valid VkAntiLagPresentationInfoAMD structure", 125}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAntiLagDataAMD-sType-sType", 33}, { {"sType must be VK_STRUCTURE_TYPE_ANTI_LAG_DATA_AMD", 49}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAntiLagPresentationInfoAMD-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_ANTI_LAG_PRESENTATION_INFO_AMD", 62}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkAntiLagPresentationInfoAMD-stage-parameter", 49}, { {"stage must be a valid VkAntiLagStageAMD value", 45}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkApplicationInfo-apiVersion-04010", 39}, { {"If apiVersion is not 0, then it must be greater than or equal to VK_API_VERSION_1_0", 83}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkApplicationInfo-pApplicationName-parameter", 49}, { {"If pApplicationName is not NULL, pApplicationName must be a null-terminated UTF-8 string", 88}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkApplicationInfo-pEngineName-parameter", 44}, { {"If pEngineName is not NULL, pEngineName must be a null-terminated UTF-8 string", 78}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkApplicationInfo-pNext-pNext", 34}, { {"pNext must be NULL", 18}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkApplicationInfo-sType-sType", 34}, { {"sType must be VK_STRUCTURE_TYPE_APPLICATION_INFO", 48}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkAttachmentDescription-attachmentFeedbackLoopLayout-07309", 63}, { {"If the attachmentFeedbackLoopLayout feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", 138}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-attachmentFeedbackLoopLayout-07310", 63}, { {"If the attachmentFeedbackLoopLayout feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", 136}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-dynamicRenderingLocalRead-09544", 60}, { {"If the dynamicRenderingLocalRead feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", 119}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-dynamicRenderingLocalRead-09545", 60}, { {"If the dynamicRenderingLocalRead feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", 117}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-finalLayout-00843", 46}, { {"finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT or VK_IMAGE_LAYOUT_PREINITIALIZED", 123}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-finalLayout-parameter", 50}, { {"finalLayout must be a valid VkImageLayout value", 47}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-flags-11773", 40}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR, flags must not include VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR", 173}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-flags-11774", 40}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR or VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR, resolveSrgbFormatSupportsTransferFunctionControl must be VK_TRUE", 218}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-flags-11775", 40}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR or VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR, maintenance10 must be enabled", 183}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-flags-11776", 40}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR or VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR, format must use sRGB encoding", 183}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-flags-11777", 40}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR or VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR, samples must be VK_SAMPLE_COUNT_1_BIT", 191}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-flags-parameter", 44}, { {"flags must be a valid combination of VkAttachmentDescriptionFlagBits values", 75}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03280", 41}, { {"If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", 154}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03281", 41}, { {"If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", 103}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03282", 41}, { {"If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", 152}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03283", 41}, { {"If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", 101}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03286", 41}, { {"If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 226}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03287", 41}, { {"If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 224}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03290", 41}, { {"If format is a depth/stencil format which includes only the depth component, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 190}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03291", 41}, { {"If format is a depth/stencil format which includes only the depth component, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 188}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03292", 41}, { {"If format is a depth/stencil format which includes only the stencil component, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", 188}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-03293", 41}, { {"If format is a depth/stencil format which includes only the stencil component, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", 186}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06242", 41}, { {"If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", 195}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06243", 41}, { {"If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", 193}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06487", 41}, { {"If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", 175}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06488", 41}, { {"If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", 173}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06698", 41}, { {"format must not be VK_FORMAT_UNDEFINED", 38}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06699", 41}, { {"If format includes a color or depth component and loadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", 144}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06700", 41}, { {"If format includes a stencil component and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", 144}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06906", 41}, { {"If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 199}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-06907", 41}, { {"If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 197}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-format-parameter", 45}, { {"format must be a valid VkFormat value", 37}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-initialLayout-parameter", 52}, { {"initialLayout must be a valid VkImageLayout value", 49}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-loadOp-parameter", 45}, { {"loadOp must be a valid VkAttachmentLoadOp value", 47}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-samples-08745", 42}, { {"samples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits) for the given format", 149}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-samples-parameter", 46}, { {"samples must be a valid VkSampleCountFlagBits value", 51}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03284", 62}, { {"If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", 257}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03285", 62}, { {"If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", 255}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-stencilLoadOp-parameter", 52}, { {"stencilLoadOp must be a valid VkAttachmentLoadOp value", 54}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-stencilStoreOp-parameter", 53}, { {"stencilStoreOp must be a valid VkAttachmentStoreOp value", 56}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-storeOp-parameter", 46}, { {"storeOp must be a valid VkAttachmentStoreOp value", 49}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-synchronization2-06908", 51}, { {"If the synchronization2 feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", 153}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription-synchronization2-06909", 51}, { {"If the synchronization2 feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", 151}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-attachmentFeedbackLoopLayout-07309", 64}, { {"If the attachmentFeedbackLoopLayout feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", 138}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-attachmentFeedbackLoopLayout-07310", 64}, { {"If the attachmentFeedbackLoopLayout feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", 136}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-dynamicRenderingLocalRead-09544", 61}, { {"If the dynamicRenderingLocalRead feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", 119}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-dynamicRenderingLocalRead-09545", 61}, { {"If the dynamicRenderingLocalRead feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", 117}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-finalLayout-00843", 47}, { {"finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT or VK_IMAGE_LAYOUT_PREINITIALIZED", 123}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-finalLayout-parameter", 51}, { {"finalLayout must be a valid VkImageLayout value", 47}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-flags-11773", 41}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR, flags must not include VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR", 173}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-flags-11774", 41}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR or VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR, resolveSrgbFormatSupportsTransferFunctionControl must be VK_TRUE", 218}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-flags-11775", 41}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR or VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR, maintenance10 must be enabled", 183}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-flags-11776", 41}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR or VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR, format must use sRGB encoding", 183}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-flags-11777", 41}, { {"If flags includes VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR or VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR, samples must be VK_SAMPLE_COUNT_1_BIT", 191}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-flags-parameter", 45}, { {"flags must be a valid combination of VkAttachmentDescriptionFlagBits values", 75}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-03280", 42}, { {"If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", 154}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-03281", 42}, { {"If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", 103}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-03282", 42}, { {"If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", 152}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-03283", 42}, { {"If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", 101}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-03286", 42}, { {"If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 226}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-03287", 42}, { {"If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 224}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-03290", 42}, { {"If format is a depth/stencil format which includes only the depth component, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 190}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-03291", 42}, { {"If format is a depth/stencil format which includes only the depth component, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 188}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06247", 42}, { {"If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure and format only includes a stencil component, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", 240}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06248", 42}, { {"If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure and format only includes a stencil component, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", 238}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06249", 42}, { {"If format is a depth/stencil format which includes both depth and stencil components, and initialLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure", 269}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06250", 42}, { {"If format is a depth/stencil format which includes both depth and stencil components, and finalLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure", 267}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06487", 42}, { {"If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", 175}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06488", 42}, { {"If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", 173}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06699", 42}, { {"If format includes a color or depth component and loadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", 144}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06906", 42}, { {"If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 199}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-06907", 42}, { {"If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", 197}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-09332", 42}, { {"If the externalFormatResolve feature is not enabled, format must not be VK_FORMAT_UNDEFINED", 91}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-09334", 42}, { {"If format is VK_FORMAT_UNDEFINED, there must be a VkExternalFormatANDROID structure in the pNext chain with a externalFormat that is not equal to 0", 147}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-format-parameter", 46}, { {"format must be a valid VkFormat value", 37}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-initialLayout-parameter", 53}, { {"initialLayout must be a valid VkImageLayout value", 49}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-loadOp-parameter", 46}, { {"loadOp must be a valid VkAttachmentLoadOp value", 47}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-pNext-06704", 41}, { {"If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure, format includes a stencil component, and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", 228}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-pNext-06705", 41}, { {"If the pNext chain includes a VkAttachmentDescriptionStencilLayout structure, format includes a stencil component, and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then VkAttachmentDescriptionStencilLayout::stencilInitialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", 265}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-pNext-pNext", 41}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAttachmentDescriptionStencilLayout, VkExternalFormatANDROID, or VkExternalFormatOHOS", 217}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-sType-sType", 41}, { {"sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2", 56}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-sType-unique", 42}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-samples-08745", 43}, { {"samples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits) for the given format", 149}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-samples-parameter", 47}, { {"samples must be a valid VkSampleCountFlagBits value", 51}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03284", 63}, { {"If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", 257}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03285", 63}, { {"If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", 255}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-stencilLoadOp-parameter", 53}, { {"stencilLoadOp must be a valid VkAttachmentLoadOp value", 54}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-stencilStoreOp-parameter", 54}, { {"stencilStoreOp must be a valid VkAttachmentStoreOp value", 56}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-storeOp-parameter", 47}, { {"storeOp must be a valid VkAttachmentStoreOp value", 49}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-synchronization2-06908", 52}, { {"If the synchronization2 feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", 153}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescription2-synchronization2-06909", 52}, { {"If the synchronization2 feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", 151}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescriptionStencilLayout-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT", 69}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03309", 66}, { {"stencilFinalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", 376}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03310", 66}, { {"stencilFinalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT or VK_IMAGE_LAYOUT_PREINITIALIZED", 130}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-parameter", 70}, { {"stencilFinalLayout must be a valid VkImageLayout value", 54}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-03308", 68}, { {"stencilInitialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", 378}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-parameter", 72}, { {"stencilInitialLayout must be a valid VkImageLayout value", 56}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentFeedbackLoopInfoEXT-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_ATTACHMENT_FEEDBACK_LOOP_INFO_EXT", 65}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentFeedbackLoopInfoEXT-unifiedImageLayouts-10782", 62}, { {"If the unifiedImageLayouts feature is not enabled, feedbackLoopEnable must be VK_FALSE", 86}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference-attachmentFeedbackLoopLayout-07311", 61}, { {"If the attachmentFeedbackLoopLayout feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", 131}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference-dynamicRenderingLocalRead-09546", 58}, { {"If the dynamicRenderingLocalRead feature is not enabled, layout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", 112}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference-layout-03077", 39}, { {"If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT, VK_IMAGE_LAYOUT_PREINITIALIZED, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", 193}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference-layout-parameter", 43}, { {"layout must be a valid VkImageLayout value", 42}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference-separateDepthStencilLayouts-03313", 60}, { {"If the separateDepthStencilLayouts feature is not enabled, and attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", 294}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference-synchronization2-06910", 49}, { {"If the synchronization2 feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", 146}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-attachmentFeedbackLoopLayout-07311", 62}, { {"If the attachmentFeedbackLoopLayout feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", 131}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-dynamicRenderingLocalRead-09546", 59}, { {"If the dynamicRenderingLocalRead feature is not enabled, layout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", 112}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-layout-03077", 40}, { {"If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT, VK_IMAGE_LAYOUT_PREINITIALIZED, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", 193}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-layout-parameter", 44}, { {"layout must be a valid VkImageLayout value", 42}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-pNext-pNext", 39}, { {"pNext must be NULL or a pointer to a valid instance of VkAttachmentReferenceStencilLayout", 89}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", 54}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-sType-unique", 40}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-separateDepthStencilLayouts-03313", 61}, { {"If the separateDepthStencilLayouts feature is not enabled, and attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", 294}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReference2-synchronization2-06910", 50}, { {"If the synchronization2 feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", 146}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReferenceStencilLayout-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT", 67}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-03318", 59}, { {"stencilLayout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", 463}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-parameter", 63}, { {"stencilLayout must be a valid VkImageLayout value", 49}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentSampleCountInfoAMD-sType-sType", 47}, { {"sType must be VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD", 64}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkAttachmentSampleLocationsEXT-attachmentIndex-01531", 57}, { {"attachmentIndex must be less than the attachmentCount specified in VkRenderPassCreateInfo the render pass specified by VkRenderPassBeginInfo::renderPass was created with", 169}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkAttachmentSampleLocationsEXT-sampleLocationsInfo-parameter", 65}, { {"sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure", 70}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkBeginCustomResolveInfoEXT-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_BEGIN_CUSTOM_RESOLVE_INFO_EXT", 61}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-03620", 72}, { {"accelerationStructure must not already be backed by a memory object", 67}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-parameter", 76}, { {"accelerationStructure must be a valid VkAccelerationStructureNV handle", 70}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-commonparent", 57}, { {"Both of accelerationStructure, and memory must have been created, allocated, or retrieved from the same VkDevice", 112}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-03622", 57}, { {"memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", 307}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-parameter", 61}, { {"memory must be a valid VkDeviceMemory handle", 44}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-03621", 63}, { {"memoryOffset must be less than the size of memory", 49}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-03623", 63}, { {"memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", 273}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-pDeviceIndices-parameter", 69}, { {"If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", 116}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-pNext-pNext", 56}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-sType-sType", 56}, { {"sType must be VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV", 74}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindAccelerationStructureMemoryInfoNV-size-03624", 55}, { {"The size member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV must be less than or equal to the size of memory minus memoryOffset", 292}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryDeviceGroupInfo-deviceIndexCount-01606", 61}, { {"deviceIndexCount must either be zero or equal to the number of physical devices in the logical device", 101}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-01607", 59}, { {"All elements of pDeviceIndices must be valid device indices", 59}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-parameter", 63}, { {"If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", 116}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryDeviceGroupInfo-sType-sType", 50}, { {"sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO", 68}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-None-01898", 38}, { {"If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit set, the buffer must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", 189}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-None-01899", 38}, { {"If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit not set, the buffer must not be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", 197}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-None-10739", 38}, { {"If memory was not allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer", 274}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-None-10741", 38}, { {"If memory was not allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, size member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer must be less than or equal to the size of memory minus memoryOffset", 289}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-apiVersion-07920", 44}, { {"If the VK_KHR_dedicated_allocation extension is not enabled, VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and buffer was not created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image", 312}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-buffer-01030", 40}, { {"buffer must not have been created with any sparse memory binding flags", 70}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-buffer-01038", 40}, { {"If buffer was created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been allocated with VkDedicatedAllocationMemoryAllocateInfoNV::buffer equal to a buffer handle created with identical creation parameters to buffer and memoryOffset must be zero", 300}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-buffer-01444", 40}, { {"If buffer requires a dedicated allocation (as reported by vkGetBufferMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for buffer), memory must have been allocated with VkMemoryDedicatedAllocateInfo::buffer equal to buffer", 254}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-buffer-06408", 40}, { {"If buffer was created with VkBufferCollectionBufferCreateInfoFUCHSIA chained to VkBufferCreateInfo::pNext, memory must be allocated with a VkImportMemoryBufferCollectionFUCHSIA chained to VkMemoryAllocateInfo::pNext", 215}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-buffer-07459", 40}, { {"buffer must not have been bound to a memory object", 50}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-buffer-09201", 40}, { {"If the buffer was created with the VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", 203}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-buffer-11408", 40}, { {"If the buffer was created with the VK_BUFFER_USAGE_DESCRIPTOR_HEAP_BIT_EXT or VK_BUFFER_USAGE_2_DESCRIPTOR_HEAP_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", 215}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-buffer-parameter", 44}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-bufferDeviceAddress-03339", 53}, { {"If the VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddress feature is enabled and buffer was created with the VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT usage flag set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", 267}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-bufferDeviceAddressCaptureReplay-09200", 66}, { {"If the VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddressCaptureReplay feature is enabled and buffer was created with the VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", 297}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-commonparent", 40}, { {"Both of buffer, and memory must have been created, allocated, or retrieved from the same VkDevice", 97}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-descriptorBufferCaptureReplay-08112", 63}, { {"If the buffer was created with the VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", 188}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-01035", 40}, { {"memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer", 202}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-01508", 40}, { {"If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::buffer was not VK_NULL_HANDLE, then buffer must equal VkMemoryDedicatedAllocateInfo::buffer, and memoryOffset must be zero", 291}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-02726", 40}, { {"If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", 210}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-02985", 40}, { {"If memory was allocated by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", 281}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-02986", 40}, { {"If memory was allocated with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", 291}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-10740", 40}, { {"If memory was allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, memoryOffset must be an integer multiple of the alignment member of the VkTileMemoryRequirementsQCOM structure returned from a call to vkGetBufferMemoryRequirements with buffer", 278}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-10742", 40}, { {"If memory was allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, size member of the VkTileMemoryRequirementsQCOM structure returned from a call to vkGetBufferMemoryRequirements with buffer must be less than or equal to the size of memory minus memoryOffset", 293}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-10925", 40}, { {"If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, VkMemoryDedicatedAllocateInfo::image must have been VK_NULL_HANDLE", 200}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memory-parameter", 44}, { {"memory must be a valid VkDeviceMemory handle", 44}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-memoryOffset-01031", 46}, { {"memoryOffset must be less than the size of memory", 49}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-pNext-01605", 39}, { {"If the pNext chain includes a VkBindBufferMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindBufferMemoryDeviceGroupInfo::pDeviceIndices must have been allocated", 186}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-pNext-pNext", 39}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBindBufferMemoryDeviceGroupInfo or VkBindMemoryStatus", 186}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO", 55}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindBufferMemoryInfo-sType-unique", 40}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-bindPoint-09786", 64}, { {"bindPoint must have been returned as part of a VkDataGraphPipelineSessionBindPointRequirementARM whose bindPointType member is VK_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_TYPE_MEMORY_ARM by a prior call to vkGetDataGraphPipelineSessionMemoryRequirementsARM for session", 266}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-bindPoint-parameter", 68}, { {"bindPoint must be a valid VkDataGraphPipelineSessionBindPointARM value", 70}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-commonparent", 61}, { {"Both of memory, and session must have been created, allocated, or retrieved from the same VkDevice", 98}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-memory-09788", 61}, { {"memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetDataGraphPipelineSessionMemoryRequirementsARM with session", 224}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-memory-parameter", 65}, { {"memory must be a valid VkDeviceMemory handle", 44}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-memoryOffset-09787", 67}, { {"memoryOffset must be less than the size of memory", 49}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-memoryOffset-09789", 67}, { {"memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetDataGraphPipelineSessionMemoryRequirementsARM with session", 190}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-objectIndex-09805", 66}, { {"objectIndex must be less than the value of numObjects returned by vkGetDataGraphPipelineSessionBindPointRequirementsARM for bindPoint", 133}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-pNext-pNext", 60}, { {"pNext must be NULL", 18}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-sType-sType", 60}, { {"sType must be VK_STRUCTURE_TYPE_BIND_DATA_GRAPH_PIPELINE_SESSION_MEMORY_INFO_ARM", 80}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-session-09785", 62}, { {"session must not have been bound to a memory object for bindPoint", 65}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-session-09791", 62}, { {"If session was created with the VK_DATA_GRAPH_PIPELINE_SESSION_CREATE_PROTECTED_BIT_ARM bit set, the session must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", 216}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-session-09792", 62}, { {"If session was created with the VK_DATA_GRAPH_PIPELINE_SESSION_CREATE_PROTECTED_BIT_ARM bit not set, the session must not be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", 224}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-session-parameter", 66}, { {"session must be a valid VkDataGraphPipelineSessionARM handle", 60}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-size-09790", 59}, { {"The size member of the VkMemoryRequirements structure returned from a call to vkGetDataGraphPipelineSessionMemoryRequirementsARM with session must be less than or equal to the size of memory minus memoryOffset", 209}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-None-09495", 61}, { {"If the dynamicPipelineLayout feature is not enabled, layout must be a valid VkPipelineLayout handle", 99}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-layout-09496", 63}, { {"If layout is VK_NULL_HANDLE, the pNext chain must include a valid VkPipelineLayoutCreateInfo structure", 102}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-layout-parameter", 67}, { {"If layout is not VK_NULL_HANDLE, layout must be a valid VkPipelineLayout handle", 79}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-pNext-pNext", 62}, { {"pNext must be NULL or a pointer to a valid instance of VkPipelineLayoutCreateInfo", 81}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-sType-sType", 62}, { {"sType must be VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT", 81}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-sType-unique", 63}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-set-08070", 60}, { {"The VkDescriptorSetLayout at index set when layout was created must have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT bit set", 170}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-set-08071", 60}, { {"set must be less than or equal to VkPipelineLayoutCreateInfo::setLayoutCount provided when layout was created", 109}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-stageFlags-parameter", 71}, { {"stageFlags must be a valid combination of VkShaderStageFlagBits values", 70}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-stageFlags-requiredbitmask", 77}, { {"stageFlags must not be 0", 24}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-None-09495", 40}, { {"If the dynamicPipelineLayout feature is not enabled, layout must be a valid VkPipelineLayout handle", 99}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-commonparent", 42}, { {"Both of layout, and the elements of pDescriptorSets that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 171}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-descriptorSetCount-arraylength", 60}, { {"descriptorSetCount must be greater than 0", 41}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-dynamicOffsetCount-00359", 54}, { {"dynamicOffsetCount must be equal to the total number of dynamic descriptors in pDescriptorSets", 94}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-firstSet-00360", 44}, { {"The sum of firstSet and descriptorSetCount must be less than or equal to VkPipelineLayoutCreateInfo::setLayoutCount provided when layout was created", 148}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-layout-09496", 42}, { {"If layout is VK_NULL_HANDLE, the pNext chain must include a valid VkPipelineLayoutCreateInfo structure", 102}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-layout-parameter", 46}, { {"If layout is not VK_NULL_HANDLE, layout must be a valid VkPipelineLayout handle", 79}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-00358", 51}, { {"Each element of pDescriptorSets that is not VK_NULL_HANDLE must have been allocated with a VkDescriptorSetLayout that matches (is the same as, or identically defined as) the VkDescriptorSetLayout at set n in layout, where n is the sum of firstSet and the index into pDescriptorSets", 281}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-01979", 51}, { {"For each dynamic uniform or storage buffer binding in pDescriptorSets, the sum of the effective offset and the range of the binding must be less than or equal to the size of the buffer", 184}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-04616", 51}, { {"Each element of pDescriptorSets must not have been allocated from a VkDescriptorPool with the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag set", 146}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-06563", 51}, { {"If the graphicsPipelineLibrary feature is not enabled, each element of pDescriptorSets must be a valid VkDescriptorSet", 118}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-06715", 51}, { {"For each dynamic uniform or storage buffer binding in pDescriptorSets, if the range was set with VK_WHOLE_SIZE then pDynamicOffsets which corresponds to the descriptor binding must be 0", 185}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-08010", 51}, { {"Each element of pDescriptorSets must have been allocated with a VkDescriptorSetLayout which was not created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT", 170}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-09914", 51}, { {"If any element of pDescriptorSets was allocated from a descriptor pool created with a VkDescriptorPoolCreateInfo structure that had a VkDataGraphProcessingEngineCreateInfoARM structure specifying foreign data processing engines in its pNext chain, then the command pool from which commandBuffer was allocated must have been created with a VkCommandPoolCreateInfo structure that had a VkDataGraphProcessingEngineCreateInfoARM structure in its pNext chain specifying a superset of all the foreign data processing engines specified when creating the descriptor pools from which the elements of pDescriptorSets were allocated", 621}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-09915", 51}, { {"If none of the elements of pDescriptorSets were allocated from a descriptor pool created with a VkDescriptorPoolCreateInfo structure that had a VkDataGraphProcessingEngineCreateInfoARM structure specifying foreign data processing engines in its pNext chain, then the command pool from which commandBuffer was allocated must not have been created with a VkCommandPoolCreateInfo structure that had a VkDataGraphProcessingEngineCreateInfoARM structure in its pNext chain", 467}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-parameter", 55}, { {"pDescriptorSets must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSet handles", 103}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDynamicOffsets-01971", 51}, { {"Each element of pDynamicOffsets which corresponds to a descriptor binding with type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC must be a multiple of VkPhysicalDeviceLimits::minUniformBufferOffsetAlignment", 203}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDynamicOffsets-01972", 51}, { {"Each element of pDynamicOffsets which corresponds to a descriptor binding with type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must be a multiple of VkPhysicalDeviceLimits::minStorageBufferOffsetAlignment", 203}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pDynamicOffsets-parameter", 55}, { {"If dynamicOffsetCount is not 0, and pDynamicOffsets is not NULL, pDynamicOffsets must be a valid pointer to an array of dynamicOffsetCount or VK_NULL_HANDLE uint32_t values", 172}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-pNext-pNext", 41}, { {"pNext must be NULL or a pointer to a valid instance of VkPipelineLayoutCreateInfo", 81}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-sType-sType", 41}, { {"sType must be VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO", 57}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-sType-unique", 42}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-stageFlags-parameter", 50}, { {"stageFlags must be a valid combination of VkShaderStageFlagBits values", 70}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindDescriptorSetsInfo-stageFlags-requiredbitmask", 56}, { {"stageFlags must not be 0", 24}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBindHeapInfoEXT-pNext-pNext", 34}, { {"pNext must be NULL", 18}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkBindHeapInfoEXT-sType-sType", 34}, { {"sType must be VK_STRUCTURE_TYPE_BIND_HEAP_INFO_EXT", 50}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01633", 60}, { {"At least one of deviceIndexCount and splitInstanceBindRegionCount must be zero", 78}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01634", 60}, { {"deviceIndexCount must either be zero or equal to the number of physical devices in the logical device", 101}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01640", 50}, { {"The extent.width member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block width of all non-metadata aspects of the image, or else extent.width + offset.x must equal the width of the image subresource", 245}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01641", 50}, { {"The extent.height member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block height of all non-metadata aspects of the image, or else extent.height + offset.y must equal the height of the image subresource", 249}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01638", 50}, { {"The offset.x member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block width (VkSparseImageFormatProperties::imageGranularity.width) of all non-metadata aspects of the image", 211}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01639", 50}, { {"The offset.y member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block height (VkSparseImageFormatProperties::imageGranularity.height) of all non-metadata aspects of the image", 213}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-01635", 58}, { {"All elements of pDeviceIndices must be valid device indices", 59}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-parameter", 62}, { {"If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", 116}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-01637", 69}, { {"Elements of pSplitInstanceBindRegions that correspond to the same instance of an image must not overlap", 103}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-parameter", 73}, { {"If splitInstanceBindRegionCount is not 0, pSplitInstanceBindRegions must be a valid pointer to an array of splitInstanceBindRegionCount VkRect2D structures", 155}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO", 67}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryDeviceGroupInfo-splitInstanceBindRegionCount-01636", 72}, { {"splitInstanceBindRegionCount must either be zero or equal to the number of physical devices in the logical device squared", 121}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-None-01901", 37}, { {"If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit set, the image must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", 186}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-None-01902", 37}, { {"If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit not set, the image must not be bound to a memory object created with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", 192}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-apiVersion-07921", 43}, { {"If the VK_KHR_dedicated_allocation extension is not enabled, VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and image was not created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image", 310}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-commonparent", 39}, { {"Both of image, and memory that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 145}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-01045", 38}, { {"image must not have been created with any sparse memory binding flags", 69}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-01050", 38}, { {"If image was created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been created with VkDedicatedAllocationMemoryAllocateInfoNV::image equal to an image handle created with identical creation parameters to image and memoryOffset must be zero", 294}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-01445", 38}, { {"If image requires a dedicated allocation (as reported by vkGetImageMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for image), memory must have been created with VkMemoryDedicatedAllocateInfo::image equal to image", 247}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-01630", 38}, { {"If image was created with a valid swapchain handle in VkImageSwapchainCreateInfoKHR::swapchain, then the pNext chain must include a VkBindImageMemorySwapchainInfoKHR structure containing the same swapchain handle", 212}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-07460", 38}, { {"image must not have been bound to a memory object", 49}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-07736", 38}, { {"If image was created with the VK_IMAGE_CREATE_DISJOINT_BIT bit set, then the pNext chain must include a VkBindImagePlaneMemoryInfo structure", 140}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-08113", 38}, { {"If the image was created with the VK_IMAGE_CREATE_DESCRIPTOR_HEAP_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", 184}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-09202", 38}, { {"If the image was created with the VK_IMAGE_CREATE_DESCRIPTOR_HEAP_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", 199}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-image-parameter", 42}, { {"image must be a valid VkImage handle", 36}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-memory-02628", 39}, { {"If the dedicatedAllocationImageAliasing feature is not enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero", 352}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-memory-02629", 39}, { {"If the dedicatedAllocationImageAliasing feature is enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then memoryOffset must be zero, and image must be either equal to VkMemoryDedicatedAllocateInfo::image or an image that was created using the same parameters in VkImageCreateInfo, with the exception that extent and arrayLayers may differ subject to the following restrictions: every dimension in the extent parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created; and the arrayLayers parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created", 835}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-memory-02728", 39}, { {"If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", 208}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-memory-02989", 39}, { {"If memory was created by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", 277}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-memory-02990", 39}, { {"If memory was created with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", 287}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-memory-10926", 39}, { {"If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, VkMemoryDedicatedAllocateInfo::buffer must have been VK_NULL_HANDLE", 201}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-memoryOffset-01046", 45}, { {"memoryOffset must be less than the size of memory", 49}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01615", 38}, { {"If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, and memory was not allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, then memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image", 389}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01616", 38}, { {"If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, and memory was not allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, then memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image", 355}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01617", 38}, { {"If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, and memory was not allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, then the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image", 402}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01618", 38}, { {"If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, image must have been created with the VK_IMAGE_CREATE_DISJOINT_BIT bit set", 142}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01619", 38}, { {"If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", 448}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01620", 38}, { {"If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", 414}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01621", 38}, { {"If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", 461}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01626", 38}, { {"If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindImageMemoryDeviceGroupInfo::pDeviceIndices must have been allocated", 184}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01627", 38}, { {"If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, and VkBindImageMemoryDeviceGroupInfo::splitInstanceBindRegionCount is not zero, then image must have been created with the VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT bit set", 252}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01628", 38}, { {"If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions must be valid rectangles contained within the dimensions of image", 215}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01629", 38}, { {"If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, the union of the areas of all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions that correspond to the same instance of image must cover the entire image", 249}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01631", 38}, { {"If the pNext chain includes a VkBindImageMemorySwapchainInfoKHR structure, memory must be VK_NULL_HANDLE", 104}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-01632", 38}, { {"If the pNext chain does not include a VkBindImageMemorySwapchainInfoKHR structure, memory must be a valid VkDeviceMemory handle", 127}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-12329", 38}, { {"If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, and memory was allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, then memoryOffset must be an integer multiple of the alignment member of the VkTileMemoryRequirementsQCOM structure returned from a call to vkGetImageMemoryRequirements2 with image", 359}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-12330", 38}, { {"If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, and memory was allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, then size member of the VkTileMemoryRequirementsQCOM structure returned from a call to vkGetImageMemoryRequirements2 with image must be less than or equal to the size of memory minus memoryOffset", 374}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-pNext-pNext", 38}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBindImageMemoryDeviceGroupInfo, VkBindImageMemorySwapchainInfoKHR, VkBindImagePlaneMemoryInfo, or VkBindMemoryStatus", 249}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-sType-sType", 38}, { {"sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO", 54}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemoryInfo-sType-unique", 39}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemorySwapchainInfoKHR-imageIndex-01644", 55}, { {"imageIndex must be less than the number of images in swapchain", 62}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemorySwapchainInfoKHR-sType-sType", 50}, { {"sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR", 68}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-07756", 54}, { {"If the swapchain has been created with VK_SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_KHR, imageIndex must be one that has previously been returned by vkAcquireNextImageKHR or vkAcquireNextImage2KHR", 202}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-parameter", 58}, { {"swapchain must be a valid VkSwapchainKHR handle", 47}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02283", 49}, { {"If the image's tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid multi-planar aspect mask bit", 144}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02284", 49}, { {"If the image's tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", 361}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter", 53}, { {"planeAspect must be a valid VkImageAspectFlagBits value", 55}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindImagePlaneMemoryInfo-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO", 60}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindIndexBufferIndirectCommandEXT-None-11117", 51}, { {"The buffer's usage flags from which the address was acquired must have the VK_BUFFER_USAGE_INDEX_BUFFER_BIT bit set", 115}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindIndexBufferIndirectCommandEXT-bufferAddress-11118", 60}, { {"The bufferAddress must be aligned to the VkIndexType of the indexType used", 74}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindIndexBufferIndirectCommandEXT-bufferAddress-parameter", 64}, { {"bufferAddress must be a valid VkDeviceAddress value", 51}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindIndexBufferIndirectCommandEXT-indexType-parameter", 60}, { {"indexType must be a valid VkIndexType value", 43}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindIndexBufferIndirectCommandNV-None-02946", 50}, { {"The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_INDEX_BUFFER_BIT bit set", 114}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindIndexBufferIndirectCommandNV-bufferAddress-02947", 59}, { {"The bufferAddress must be aligned to the indexType used", 55}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindIndexBufferIndirectCommandNV-bufferAddress-parameter", 63}, { {"bufferAddress must be a valid VkDeviceAddress value", 51}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindIndexBufferIndirectCommandNV-indexType-parameter", 59}, { {"indexType must be a valid VkIndexType value", 43}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindMemoryStatus-pResult-parameter", 41}, { {"pResult must be a valid pointer to a VkResult value", 51}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindMemoryStatus-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS", 50}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindPipelineIndirectCommandNV-None-09092", 47}, { {"The referenced pipeline must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", 95}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindPipelineIndirectCommandNV-None-09093", 47}, { {"The referenced pipeline must have been updated with vkCmdUpdatePipelineIndirectBufferNV", 87}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindPipelineIndirectCommandNV-None-09094", 47}, { {"The referenced pipeline's address must have been queried with vkGetPipelineIndirectDeviceAddressNV", 98}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindPipelineIndirectCommandNV-deviceGeneratedComputePipelines-09091", 74}, { {"The VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature must be enabled", 117}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindPipelineIndirectCommandNV-pipelineAddress-parameter", 62}, { {"pipelineAddress must be a valid VkDeviceAddress value", 53}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindShaderGroupIndirectCommandNV-None-02944", 50}, { {"The current bound graphics pipeline, as well as the pipelines it may reference, must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", 151}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindShaderGroupIndirectCommandNV-index-02945", 51}, { {"The index must be within range of the accessible shader groups of the current bound graphics pipeline. See vkCmdBindPipelineShaderGroupNV for further details", 157}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindSparseInfo-commonparent", 34}, { {"Both of the elements of pSignalSemaphores, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 198}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pBufferBinds-parameter", 44}, { {"If bufferBindCount is not 0, pBufferBinds must be a valid pointer to an array of bufferBindCount valid VkSparseBufferMemoryBindInfo structures", 142}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pImageBinds-parameter", 43}, { {"If imageBindCount is not 0, pImageBinds must be a valid pointer to an array of imageBindCount valid VkSparseImageMemoryBindInfo structures", 138}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pImageOpaqueBinds-parameter", 49}, { {"If imageOpaqueBindCount is not 0, pImageOpaqueBinds must be a valid pointer to an array of imageOpaqueBindCount valid VkSparseImageOpaqueMemoryBindInfo structures", 162}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pNext-03247", 33}, { {"If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pWaitSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its waitSemaphoreValueCount member must equal waitSemaphoreCount", 257}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pNext-03248", 33}, { {"If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its signalSemaphoreValueCount member must equal signalSemaphoreCount", 263}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pNext-09753", 33}, { {"If the pNext chain of this structure includes a VkFrameBoundaryTensorsARM structure then it must also include a VkFrameBoundaryEXT structure", 140}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pNext-pNext", 33}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupBindSparseInfo, VkFrameBoundaryEXT, VkFrameBoundaryTensorsARM, or VkTimelineSemaphoreSubmitInfo", 239}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pSignalSemaphores-03249", 45}, { {"For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value greater than the current value of the semaphore when the semaphore signal operation is executed", 295}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pSignalSemaphores-03251", 45}, { {"For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", 400}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pSignalSemaphores-parameter", 49}, { {"If signalSemaphoreCount is not 0, pSignalSemaphores must be a valid pointer to an array of signalSemaphoreCount valid VkSemaphore handles", 137}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pWaitSemaphores-03246", 43}, { {"If any element of pWaitSemaphores or pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then the pNext chain must include a VkTimelineSemaphoreSubmitInfo structure", 195}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pWaitSemaphores-03250", 43}, { {"For each element of pWaitSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pWaitSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", 396}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-pWaitSemaphores-parameter", 47}, { {"If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles", 131}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-sType-sType", 33}, { {"sType must be VK_STRUCTURE_TYPE_BIND_SPARSE_INFO", 48}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindSparseInfo-sType-unique", 34}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-commonparent", 43}, { {"Both of memory, and tensor must have been created, allocated, or retrieved from the same VkDevice", 97}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-memory-09714", 43}, { {"memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetTensorMemoryRequirementsARM with tensor", 205}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-memory-09806", 43}, { {"If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfoTensorARM structure in its pNext chain, and VkMemoryDedicatedAllocateInfoTensorARM::tensor was not VK_NULL_HANDLE, then tensor must equal VkMemoryDedicatedAllocateInfoTensorARM::tensor, and memoryOffset must be zero", 318}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-memory-09895", 43}, { {"If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryTensorCreateInfoARM::handleTypes when tensor was created", 213}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-memory-09896", 43}, { {"If memory was allocated by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryTensorCreateInfoARM::handleTypes when tensor was created", 284}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-memory-09897", 43}, { {"If memory was allocated with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryTensorCreateInfoARM::handleTypes when tensor was created", 294}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-memory-parameter", 47}, { {"memory must be a valid VkDeviceMemory handle", 44}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-memoryOffset-09713", 49}, { {"memoryOffset must be less than the size of memory", 49}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-memoryOffset-09715", 49}, { {"memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetTensorMemoryRequirementsARM with tensor", 171}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-pNext-pNext", 42}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_BIND_TENSOR_MEMORY_INFO_ARM", 59}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-size-09716", 41}, { {"The size member of the VkMemoryRequirements structure returned from a call to vkGetTensorMemoryRequirementsARM with tensor must be less than or equal to the size of memory minus memoryOffset", 190}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-09712", 43}, { {"tensor must not already be backed by a memory object", 52}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-09717", 43}, { {"If tensor requires a dedicated allocation (as reported by vkGetTensorMemoryRequirementsARM in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for tensor), memory must have been created with VkMemoryDedicatedAllocateInfoTensorARM::tensor equal to tensor", 263}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-09718", 43}, { {"If tensor was created with the VK_TENSOR_CREATE_PROTECTED_BIT_ARM bit set, the tensor must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", 193}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-09719", 43}, { {"If tensor was created with the VK_TENSOR_CREATE_PROTECTED_BIT_ARM bit not set, the tensor must not be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", 201}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-09943", 43}, { {"If tensor was created with the VK_TENSOR_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_ARM bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", 184}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-09944", 43}, { {"If tensor was created with the VK_TENSOR_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_ARM bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", 199}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-11406", 43}, { {"If tensor was created with the VK_TENSOR_CREATE_DESCRIPTOR_HEAP_CAPTURE_REPLAY_BIT_ARM bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", 182}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-11407", 43}, { {"If tensor was created with the VK_TENSOR_CREATE_DESCRIPTOR_HEAP_CAPTURE_REPLAY_BIT_ARM bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", 197}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindTensorMemoryInfoARM-tensor-parameter", 47}, { {"tensor must be a valid VkTensorARM handle", 41}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBindVertexBufferIndirectCommandEXT-None-11120", 52}, { {"The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_VERTEX_BUFFER_BIT bit set", 115}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindVertexBufferIndirectCommandEXT-bufferAddress-parameter", 65}, { {"bufferAddress must be a valid VkDeviceAddress value", 51}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindVertexBufferIndirectCommandNV-None-02949", 51}, { {"The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_VERTEX_BUFFER_BIT bit set", 115}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindVertexBufferIndirectCommandNV-bufferAddress-parameter", 64}, { {"bufferAddress must be a valid VkDeviceAddress value", 51}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkBindVideoSessionMemoryInfoKHR-memory-parameter", 53}, { {"memory must be a valid VkDeviceMemory handle", 44}, { "chapters/videocoding.html", 25} } },
        { {"VUID-VkBindVideoSessionMemoryInfoKHR-memoryOffset-07201", 55}, { {"memoryOffset must be less than the size of memory", 49}, { "chapters/videocoding.html", 25} } },
        { {"VUID-VkBindVideoSessionMemoryInfoKHR-memorySize-07202", 53}, { {"memorySize must be less than or equal to the size of memory minus memoryOffset", 78}, { "chapters/videocoding.html", 25} } },
        { {"VUID-VkBindVideoSessionMemoryInfoKHR-pNext-pNext", 48}, { {"pNext must be NULL", 18}, { "chapters/videocoding.html", 25} } },
        { {"VUID-VkBindVideoSessionMemoryInfoKHR-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR", 66}, { "chapters/videocoding.html", 25} } },
        { {"VUID-VkBlitImageCubicWeightsInfoQCOM-cubicWeights-parameter", 59}, { {"cubicWeights must be a valid VkCubicFilterWeightsQCOM value", 59}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageCubicWeightsInfoQCOM-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM", 66}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-aspectMask-00241", 38}, { {"For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-aspectMask-00242", 38}, { {"For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-commonparent", 34}, { {"Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", 101}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-00224", 36}, { {"dstImage must have been created with the VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag set", 87}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-00225", 36}, { {"If dstImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 109}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-00234", 36}, { {"dstImage must have been created with a samples value of VK_SAMPLE_COUNT_1_BIT", 77}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-00250", 36}, { {"If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffsets[0].y must be 0 and dstOffsets[1].y must be 1", 131}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-00252", 36}, { {"If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffsets[0].z must be 0 and dstOffsets[1].z must be 1", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-02000", 36}, { {"The format features of dstImage must contain VK_FORMAT_FEATURE_BLIT_DST_BIT", 75}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-02545", 36}, { {"dstImage and srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 105}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-06422", 36}, { {"dstImage must not use a format that requires a sampler Y'CBCR conversion", 72}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImage-parameter", 40}, { {"dstImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImageLayout-00226", 42}, { {"dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImageLayout-01399", 42}, { {"dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", 122}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstImageLayout-parameter", 46}, { {"dstImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstOffset-00248", 37}, { {"For each element of pRegions, dstOffsets[0].x and dstOffsets[1].x must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", 185}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstOffset-00249", 37}, { {"For each element of pRegions, dstOffsets[0].y and dstOffsets[1].y must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", 186}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstOffset-00251", 37}, { {"For each element of pRegions, dstOffsets[0].z and dstOffsets[1].z must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", 185}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstSubresource-01706", 42}, { {"The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-dstSubresource-01708", 42}, { {"If dstSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", 251}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-filter-00237", 34}, { {"If filter is VK_FILTER_CUBIC_EXT, srcImage must be of type VK_IMAGE_TYPE_2D", 75}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-filter-02001", 34}, { {"If filter is VK_FILTER_LINEAR, then the format features of srcImage must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT", 130}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-filter-02002", 34}, { {"If filter is VK_FILTER_CUBIC_EXT, then the format features of srcImage must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT", 136}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-filter-09204", 34}, { {"If filter is VK_FILTER_CUBIC_EXT and if the selectableCubicWeights feature is not enabled then the cubic weights must be VK_CUBIC_FILTER_WEIGHTS_CATMULL_ROM_QCOM", 161}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-filter-parameter", 38}, { {"filter must be a valid VkFilter value", 37}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-maintenance8-10207", 40}, { {"If the maintenance8 feature is enabled and srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer must be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1", 231}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-maintenance8-10208", 40}, { {"If the maintenance8 feature is enabled and dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstSubresource.baseArrayLayer must be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1", 231}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-maintenance8-10579", 40}, { {"If the maintenance8 feature is enabled, dstImage is VK_IMAGE_TYPE_3D, and srcImage is not of type VK_IMAGE_TYPE_3D, then for each element of pRegions, the absolute difference of the z member of each member of dstOffsets must equal srcSubresource.layerCount", 256}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-maintenance8-10580", 40}, { {"If the maintenance8 feature is enabled, srcImage is VK_IMAGE_TYPE_3D, and dstImage is not of type VK_IMAGE_TYPE_3D, then for each element of pRegions, the absolute difference of the z member of each member of srcOffsets must equal dstSubresource.layerCount", 256}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-pNext-pNext", 33}, { {"pNext must be NULL or a pointer to a valid instance of VkBlitImageCubicWeightsInfoQCOM", 86}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-pRegions-00217", 36}, { {"The union of all destination regions, specified by the elements of pRegions, must not overlap in memory with any texel that may be sampled during the blit operation", 164}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-pRegions-04561", 36}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage and dstImage must not be block-compressed images", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-pRegions-parameter", 40}, { {"pRegions must be a valid pointer to an array of regionCount valid VkImageBlit2 structures", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-regionCount-arraylength", 45}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-sType-sType", 33}, { {"sType must be VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2", 49}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-sType-unique", 34}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00219", 36}, { {"srcImage must have been created with the VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag set", 87}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00220", 36}, { {"If srcImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 109}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00229", 36}, { {"If either of srcImage or dstImage was created with a signed integer VkFormat, the other must also have been created with a signed integer VkFormat", 146}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00230", 36}, { {"If either of srcImage or dstImage was created with an unsigned integer VkFormat, the other must also have been created with an unsigned integer VkFormat", 152}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00231", 36}, { {"If either of srcImage or dstImage was created with a depth/stencil format, the other must have exactly the same format", 118}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00232", 36}, { {"If srcImage was created with a depth/stencil format, filter must be VK_FILTER_NEAREST", 85}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00233", 36}, { {"srcImage must have been created with a samples value of VK_SAMPLE_COUNT_1_BIT", 77}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00240", 36}, { {"If the maintenance8 feature is not enabled and either srcImage or dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer and dstSubresource.baseArrayLayer must each be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1", 293}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00245", 36}, { {"If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffsets[0].y must be 0 and srcOffsets[1].y must be 1", 131}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-00247", 36}, { {"If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffsets[0].z must be 0 and srcOffsets[1].z must be 1", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-01999", 36}, { {"The format features of srcImage must contain VK_FORMAT_FEATURE_BLIT_SRC_BIT", 75}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-06421", 36}, { {"srcImage must not use a format that requires a sampler Y'CBCR conversion", 72}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-09459", 36}, { {"If srcImage and dstImage are the same, and an elements of pRegions contains the srcSubresource and dstSubresource with matching mipLevel and overlapping array layers, then the srcImageLayout and dstImageLayout must be VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", 279}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImage-parameter", 40}, { {"srcImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImageLayout-00221", 42}, { {"srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImageLayout-01398", 42}, { {"srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", 122}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcImageLayout-parameter", 46}, { {"srcImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcOffset-00243", 37}, { {"For each element of pRegions, srcOffsets[0].x and srcOffsets[1].x must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", 185}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcOffset-00244", 37}, { {"For each element of pRegions, srcOffsets[0].y and srcOffsets[1].y must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", 186}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcOffset-00246", 37}, { {"For each element of pRegions, srcOffsets[0].z and srcOffsets[1].z must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", 185}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcSubresource-01705", 42}, { {"The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2-srcSubresource-01707", 42}, { {"If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", 251}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2KHR-pRegions-06207", 39}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must be of type VK_IMAGE_TYPE_2D", 133}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBlitImageInfo2KHR-pRegions-06208", 39}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must not have a multi-planar format", 136}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferCaptureDescriptorDataInfoEXT-buffer-08075", 54}, { {"buffer must have been created with VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkBufferCreateInfo::flags", 125}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBufferCaptureDescriptorDataInfoEXT-buffer-parameter", 58}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBufferCaptureDescriptorDataInfoEXT-pNext-pNext", 53}, { {"pNext must be NULL", 18}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBufferCaptureDescriptorDataInfoEXT-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", 71}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-collection-parameter", 67}, { {"collection must be a valid VkBufferCollectionFUCHSIA handle", 59}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-index-06388", 58}, { {"index must be less than VkBufferCollectionPropertiesFUCHSIA::bufferCount", 72}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-sType-sType", 58}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA", 76}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionConstraintsInfoFUCHSIA-pNext-pNext", 57}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionConstraintsInfoFUCHSIA-sType-sType", 57}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA", 74}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionCreateInfoFUCHSIA-collectionToken-06393", 62}, { {"collectionToken must be a valid zx_handle_t to a Zircon channel allocated from Sysmem (fuchsia.sysmem.Allocator/AllocateSharedCollection) with ZX_DEFAULT_CHANNEL_RIGHTS rights", 175}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionCreateInfoFUCHSIA-pNext-pNext", 52}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionCreateInfoFUCHSIA-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA", 69}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-collection-parameter", 66}, { {"collection must be a valid VkBufferCollectionFUCHSIA handle", 59}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-index-06391", 57}, { {"index must be less than VkBufferCollectionPropertiesFUCHSIA::bufferCount", 72}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-sType-sType", 57}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA", 75}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionPropertiesFUCHSIA-pNext-pNext", 52}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCollectionPropertiesFUCHSIA-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA", 68}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferConstraintsInfoFUCHSIA-bufferCollectionConstraints-parameter", 73}, { {"bufferCollectionConstraints must be a valid VkBufferCollectionConstraintsInfoFUCHSIA structure", 94}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferConstraintsInfoFUCHSIA-createInfo-parameter", 56}, { {"createInfo must be a valid VkBufferCreateInfo structure", 55}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferConstraintsInfoFUCHSIA-pNext-pNext", 47}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferConstraintsInfoFUCHSIA-requiredFormatFeatures-06404", 64}, { {"The requiredFormatFeatures bitmask of VkFormatFeatureFlagBits must be chosen from among the buffer compatible format features listed in buffer compatible format features", 169}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferConstraintsInfoFUCHSIA-requiredFormatFeatures-parameter", 68}, { {"requiredFormatFeatures must be a valid combination of VkFormatFeatureFlagBits values", 84}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferConstraintsInfoFUCHSIA-sType-sType", 47}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA", 63}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCopy-size-01988", 28}, { {"The size must be greater than 0", 31}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferCopy2-pNext-pNext", 30}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferCopy2-sType-sType", 30}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_COPY_2", 45}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferCopy2-size-01988", 29}, { {"The size must be greater than 0", 31}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferCreateInfo-None-01888", 34}, { {"If any of the bits VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT are set, VK_BUFFER_CREATE_PROTECTED_BIT must not also be set", 194}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-None-09499", 34}, { {"If the pNext chain does not include a VkBufferUsageFlags2CreateInfo structure, usage must be a valid combination of VkBufferUsageFlagBits values", 144}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-None-09500", 34}, { {"If the pNext chain does not include a VkBufferUsageFlags2CreateInfo structure, usage must not be 0", 98}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-deviceAddress-02604", 43}, { {"If VkBufferDeviceAddressCreateInfoEXT::deviceAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", 135}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-00915", 35}, { {"If the sparseBinding feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT", 103}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-00916", 35}, { {"If the sparseResidencyBuffer feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT", 113}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-00917", 35}, { {"If the sparseResidencyAliased feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_ALIASED_BIT", 112}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-00918", 35}, { {"If flags contains VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT", 152}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-01887", 35}, { {"If the protectedMemory feature is not enabled, flags must not contain VK_BUFFER_CREATE_PROTECTED_BIT", 100}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-03338", 35}, { {"If flags includes VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::bufferDeviceAddressCaptureReplay feature or the bufferDeviceAddressCaptureReplay feature must be enabled", 226}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-08099", 35}, { {"If flags includes VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", 134}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-08325", 35}, { {"If flags includes VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then videoMaintenance1 must be enabled", 108}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-09641", 35}, { {"If flags includes VK_BUFFER_CREATE_PROTECTED_BIT, then the effective usage must not contain bits other than VK_BUFFER_USAGE_TRANSFER_SRC_BIT VK_BUFFER_USAGE_TRANSFER_DST_BIT VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT VK_BUFFER_USAGE_STORAGE_BUFFER_BIT VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT VK_BUFFER_USAGE_2_VIDEO_DECODE_SRC_BIT_KHR VK_BUFFER_USAGE_2_VIDEO_ENCODE_DST_BIT_KHR VK_BUFFER_USAGE_2_DESCRIPTOR_HEAP_BIT_EXT", 495}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-flags-parameter", 39}, { {"flags must be a valid combination of VkBufferCreateFlagBits values", 66}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-opaqueCaptureAddress-03337", 50}, { {"If VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", 146}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-pNext-00920", 35}, { {"If the pNext chain includes a VkExternalMemoryBufferCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalBufferProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalBufferProperties with pExternalBufferInfo->handleType equal to any one of the handle types specified in VkExternalMemoryBufferCreateInfo::handleTypes", 404}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-pNext-01571", 35}, { {"If the pNext chain includes a VkDedicatedAllocationBufferCreateInfoNV structure, and the dedicatedAllocation member of the chained structure is VK_TRUE, then flags must not include VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT", 295}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-pNext-08100", 35}, { {"If the pNext chain includes a VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, flags must contain VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT", 160}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-pNext-10249", 35}, { {"If the pNext chain includes a VkVideoProfileListInfoKHR structure and for any element of its pProfiles member videoCodecOperation is VK_VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the videoEncodeAV1 feature must be enabled", 225}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-pNext-10783", 35}, { {"If the pNext chain includes a VkVideoProfileListInfoKHR structure and for any element of its pProfiles member videoCodecOperation is VK_VIDEO_CODEC_OPERATION_DECODE_VP9_BIT_KHR, then the videoDecodeVP9 feature must be enabled", 225}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-pNext-10919", 35}, { {"If the pNext chain includes a VkVideoEncodeProfileRgbConversionInfoVALVE structure, then the videoEncodeRgbConversion feature must be enabled", 141}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-pNext-pNext", 35}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferCollectionBufferCreateInfoFUCHSIA, VkBufferDeviceAddressCreateInfoEXT, VkBufferOpaqueCaptureAddressCreateInfo, VkBufferUsageFlags2CreateInfo, VkDedicatedAllocationBufferCreateInfoNV, VkExternalMemoryBufferCreateInfo, VkOpaqueCaptureDescriptorDataCreateInfoEXT, or VkVideoProfileListInfoKHR", 428}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO", 50}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-sType-unique", 36}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-sharingMode-00913", 41}, { {"If sharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values", 142}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-sharingMode-00914", 41}, { {"If sharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1", 90}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-sharingMode-01419", 41}, { {"If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties2 or vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device", 303}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-sharingMode-parameter", 45}, { {"sharingMode must be a valid VkSharingMode value", 47}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-size-00912", 34}, { {"size must be greater than 0", 27}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-size-06409", 34}, { {"size must be less than or equal to VkPhysicalDeviceMaintenance4Properties::maxBufferSize", 88}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-tileMemoryHeap-10762", 44}, { {"If the tileMemoryHeap feature is not enabled, usage must not include VK_BUFFER_USAGE_TILE_MEMORY_BIT_QCOM", 105}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-04813", 35}, { {"If usage includes VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR or VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR, and flags does not include VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the pNext chain must include a VkVideoProfileListInfoKHR structure with profileCount greater than 0 and pProfiles including at least one VkVideoProfileInfoKHR structure with a videoCodecOperation member specifying a decode operation", 420}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-04814", 35}, { {"If usage includes VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR or VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR, and flags does not include VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the pNext chain must include a VkVideoProfileListInfoKHR structure with profileCount greater than 0 and pProfiles including at least one VkVideoProfileInfoKHR structure with a videoCodecOperation member specifying an encode operation", 421}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-08097", 35}, { {"If usage includes VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT, creating this VkBuffer must not cause the total required space for all currently valid buffers using this flag on the device to exceed VkPhysicalDeviceDescriptorBufferPropertiesEXT::samplerDescriptorBufferAddressSpaceSize or VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferAddressSpaceSize", 373}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-08098", 35}, { {"If usage includes VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT, creating this VkBuffer must not cause the total required space for all currently valid buffers using this flag on the device to exceed VkPhysicalDeviceDescriptorBufferPropertiesEXT::resourceDescriptorBufferAddressSpaceSize or VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferAddressSpaceSize", 375}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-08101", 35}, { {"If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, the descriptorBufferPushDescriptors feature must be enabled", 137}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-08102", 35}, { {"If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors must be VK_FALSE", 166}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-08103", 35}, { {"If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, usage must contain at least one of VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT or VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT", 216}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-10763", 35}, { {"If usage includes VK_BUFFER_USAGE_TILE_MEMORY_BIT_QCOM, then flags must not contain any of the following bits VK_BUFFER_CREATE_SPARSE_BINDING_BIT VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT VK_BUFFER_CREATE_SPARSE_ALIASED_BIT VK_BUFFER_CREATE_PROTECTED_BIT VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR", 410}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferCreateInfo-usage-10764", 35}, { {"If usage includes VK_BUFFER_USAGE_TILE_MEMORY_BIT_QCOM, then only the following usages may be set: VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT VK_BUFFER_USAGE_STORAGE_BUFFER_BIT VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT and if VkPhysicalDeviceTileMemoryHeapPropertiesQCOM::tileBufferTransfers is VK_TRUE then additionally VK_BUFFER_USAGE_TRANSFER_SRC_BIT or VK_BUFFER_USAGE_TRANSFER_DST_BIT", 463}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferDeviceAddressCreateInfoEXT-deviceAddress-parameter", 63}, { {"If deviceAddress is not 0, deviceAddress must be a valid VkDeviceAddress value", 78}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferDeviceAddressCreateInfoEXT-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT", 69}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferDeviceAddressInfo-buffer-02601", 43}, { {"buffer must have been created with the VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT usage flag set", 95}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferDeviceAddressInfo-buffer-parameter", 47}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferDeviceAddressInfo-pNext-pNext", 42}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferDeviceAddressInfo-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", 58}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferImageCopy-aspectMask-09103", 39}, { {"The aspectMask member of imageSubresource must only have a single bit set", 73}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy-bufferImageHeight-09102", 46}, { {"bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy-bufferRowLength-09101", 44}, { {"bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", 86}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy-imageExtent-06659", 40}, { {"imageExtent.width must not be 0", 31}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy-imageExtent-06660", 40}, { {"imageExtent.height must not be 0", 32}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy-imageExtent-06661", 40}, { {"imageExtent.depth must not be 0", 31}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy-imageSubresource-parameter", 49}, { {"imageSubresource must be a valid VkImageSubresourceLayers structure", 67}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-aspectMask-09103", 40}, { {"The aspectMask member of imageSubresource must only have a single bit set", 73}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-bufferImageHeight-09102", 47}, { {"bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-bufferRowLength-09101", 45}, { {"bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", 86}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-imageExtent-06659", 41}, { {"imageExtent.width must not be 0", 31}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-imageExtent-06660", 41}, { {"imageExtent.height must not be 0", 32}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-imageExtent-06661", 41}, { {"imageExtent.depth must not be 0", 31}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-imageSubresource-parameter", 50}, { {"imageSubresource must be a valid VkImageSubresourceLayers structure", 67}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-pNext-pNext", 35}, { {"pNext must be NULL or a pointer to a valid instance of VkCopyCommandTransformInfoQCOM", 85}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2", 51}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferImageCopy2-sType-unique", 36}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/copies.html", 20} } },
        { {"VUID-VkBufferMemoryBarrier-None-09049", 37}, { {"If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, at least one of srcQueueFamilyIndex and dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED", 213}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-None-09050", 37}, { {"If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED or VK_QUEUE_FAMILY_EXTERNAL", 201}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-None-09051", 37}, { {"If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED or VK_QUEUE_FAMILY_EXTERNAL", 201}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-None-09097", 37}, { {"If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", 234}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-None-09098", 37}, { {"If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", 234}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-buffer-01931", 39}, { {"If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 107}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-buffer-09095", 39}, { {"If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", 241}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-buffer-09096", 39}, { {"If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", 241}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-buffer-parameter", 43}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-dstQueueFamilyIndex-09100", 52}, { {"If the VK_EXT_queue_family_foreign extension is not enabled dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", 119}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-offset-01187", 39}, { {"offset must be less than the size of buffer", 43}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-pNext-pNext", 38}, { {"pNext must be NULL or a pointer to a valid instance of VkExternalMemoryAcquireUnmodifiedEXT", 91}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-sType-sType", 38}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", 53}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-sType-unique", 39}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-size-01188", 37}, { {"If size is not equal to VK_WHOLE_SIZE, size must be greater than 0", 66}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-size-01189", 37}, { {"If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset", 110}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier-srcQueueFamilyIndex-09099", 52}, { {"If the VK_EXT_queue_family_foreign extension is not enabled srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", 119}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-None-09097", 38}, { {"If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", 234}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-None-09098", 38}, { {"If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", 234}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-buffer-01931", 40}, { {"If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 107}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-buffer-09095", 40}, { {"If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", 241}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-buffer-09096", 40}, { {"If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", 241}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-buffer-parameter", 44}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03900", 47}, { {"If dstAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_COPY_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 308}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03901", 47}, { {"If dstAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 232}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03902", 47}, { {"If dstAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 254}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03903", 47}, { {"If dstAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 256}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03904", 47}, { {"If dstAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 209}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03905", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 216}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03906", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 216}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03907", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 217}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03909", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 209}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03910", 47}, { {"If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 216}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03911", 47}, { {"If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 217}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03912", 47}, { {"If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 267}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03913", 47}, { {"If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 268}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03914", 47}, { {"If dstAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 430}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03915", 47}, { {"If dstAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 462}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03916", 47}, { {"If dstAccessMask includes VK_ACCESS_2_HOST_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", 107}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03917", 47}, { {"If dstAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", 108}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03918", 47}, { {"If dstAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 228}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03919", 47}, { {"If dstAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 230}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03920", 47}, { {"If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 223}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03922", 47}, { {"If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 231}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03923", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 220}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03924", 47}, { {"If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 181}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03925", 47}, { {"If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 182}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03926", 47}, { {"If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 232}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03927", 47}, { {"If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 305}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03928", 47}, { {"If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 255}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04747", 47}, { {"If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 269}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04858", 47}, { {"If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", 131}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04859", 47}, { {"If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", 132}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04860", 47}, { {"If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", 131}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04861", 47}, { {"If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", 132}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04994", 47}, { {"If dstAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, dstStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", 143}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-06256", 47}, { {"If the rayQuery feature is not enabled and dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", 247}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07272", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT or VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", 185}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07454", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 310}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07455", 47}, { {"If dstAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", 129}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07456", 47}, { {"If dstAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", 130}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07457", 47}, { {"If dstAccessMask includes VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", 130}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07458", 47}, { {"If dstAccessMask includes VK_ACCESS_2_MICROMAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", 189}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-08118", 47}, { {"If dstAccessMask includes VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", 219}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-10670", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT or VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT", 183}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-10671", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT or VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT", 184}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-11294", 47}, { {"If dstAccessMask includes VK_ACCESS_2_SAMPLER_HEAP_READ_BIT_EXT or VK_ACCESS_2_RESOURCE_HEAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", 256}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-11771", 47}, { {"If dstAccessMask includes VK_ACCESS_2_MEMORY_DECOMPRESSION_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MEMORY_DECOMPRESSION_BIT_EXT", 147}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-11772", 47}, { {"If dstAccessMask includes VK_ACCESS_2_MEMORY_DECOMPRESSION_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MEMORY_DECOMPRESSION_BIT_EXT", 148}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter", 51}, { {"dstAccessMask must be a valid combination of VkAccessFlagBits2 values", 69}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstQueueFamilyIndex-09100", 53}, { {"If the VK_EXT_queue_family_foreign extension is not enabled dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", 119}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-03929", 46}, { {"If the geometryShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT", 115}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-03930", 46}, { {"If the tessellationShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT", 189}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-03931", 46}, { {"If the conditionalRendering feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", 131}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-03932", 46}, { {"If the fragmentDensityMap feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", 132}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-03933", 46}, { {"If the transformFeedback feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", 125}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-03934", 46}, { {"If the meshShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT", 111}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-03935", 46}, { {"If the taskShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT", 111}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-04957", 46}, { {"If the subpassShading feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI", 121}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-04995", 46}, { {"If the invocationMask feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", 122}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-07316", 46}, { {"If neither of the shadingRateImage or the attachmentFragmentShadingRate features are enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", 184}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-07946", 46}, { {"If neither the VK_NV_ray_tracing extension or the rayTracingPipeline feature are enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", 166}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-10751", 46}, { {"If the accelerationStructure feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", 139}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-10752", 46}, { {"If the rayTracingMaintenance1 feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR", 139}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-10753", 46}, { {"If the micromap feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", 112}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-dstStageMask-parameter", 50}, { {"dstStageMask must be a valid combination of VkPipelineStageFlagBits2 values", 75}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-offset-01187", 40}, { {"offset must be less than the size of buffer", 43}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-pNext-pNext", 39}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExternalMemoryAcquireUnmodifiedEXT or VkMemoryBarrierAccessFlags3KHR", 201}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", 55}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-sType-unique", 40}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-size-01188", 38}, { {"If size is not equal to VK_WHOLE_SIZE, size must be greater than 0", 66}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-size-01189", 38}, { {"If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset", 110}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03900", 47}, { {"If srcAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_COPY_INDIRECT_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 308}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03901", 47}, { {"If srcAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 232}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03902", 47}, { {"If srcAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 254}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03903", 47}, { {"If srcAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 256}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03904", 47}, { {"If srcAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 209}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03905", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 216}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03906", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 216}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03907", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 217}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03909", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 209}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03910", 47}, { {"If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 216}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03911", 47}, { {"If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 217}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03912", 47}, { {"If srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 267}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03913", 47}, { {"If srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 268}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03914", 47}, { {"If srcAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 430}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03915", 47}, { {"If srcAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 462}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03916", 47}, { {"If srcAccessMask includes VK_ACCESS_2_HOST_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", 107}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03917", 47}, { {"If srcAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", 108}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03918", 47}, { {"If srcAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 228}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03919", 47}, { {"If srcAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 230}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03920", 47}, { {"If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 223}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03922", 47}, { {"If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 231}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03923", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 220}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03924", 47}, { {"If srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 181}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03925", 47}, { {"If srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 182}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03926", 47}, { {"If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 232}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03927", 47}, { {"If srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 305}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03928", 47}, { {"If srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 255}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04747", 47}, { {"If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", 269}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04858", 47}, { {"If srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", 131}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04859", 47}, { {"If srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", 132}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04860", 47}, { {"If srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", 131}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04861", 47}, { {"If srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", 132}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04994", 47}, { {"If srcAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, srcStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", 143}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-06256", 47}, { {"If the rayQuery feature is not enabled and srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, srcStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", 247}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07272", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT or VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", 185}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07454", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADER_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", 310}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07455", 47}, { {"If srcAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", 129}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07456", 47}, { {"If srcAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", 130}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07457", 47}, { {"If srcAccessMask includes VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", 130}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07458", 47}, { {"If srcAccessMask includes VK_ACCESS_2_MICROMAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", 189}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-08118", 47}, { {"If srcAccessMask includes VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", 219}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-10670", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT or VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT", 183}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-10671", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT or VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT", 184}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-11294", 47}, { {"If srcAccessMask includes VK_ACCESS_2_SAMPLER_HEAP_READ_BIT_EXT or VK_ACCESS_2_RESOURCE_HEAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", 256}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-11771", 47}, { {"If srcAccessMask includes VK_ACCESS_2_MEMORY_DECOMPRESSION_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MEMORY_DECOMPRESSION_BIT_EXT", 147}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-11772", 47}, { {"If srcAccessMask includes VK_ACCESS_2_MEMORY_DECOMPRESSION_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MEMORY_DECOMPRESSION_BIT_EXT", 148}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter", 51}, { {"srcAccessMask must be a valid combination of VkAccessFlagBits2 values", 69}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcQueueFamilyIndex-09099", 53}, { {"If the VK_EXT_queue_family_foreign extension is not enabled srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", 119}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-03851", 46}, { {"If either srcStageMask or dstStageMask includes VK_PIPELINE_STAGE_2_HOST_BIT, srcQueueFamilyIndex and dstQueueFamilyIndex must be equal", 135}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-03929", 46}, { {"If the geometryShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT", 115}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-03930", 46}, { {"If the tessellationShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT", 189}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-03931", 46}, { {"If the conditionalRendering feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", 131}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-03932", 46}, { {"If the fragmentDensityMap feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", 132}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-03933", 46}, { {"If the transformFeedback feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", 125}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-03934", 46}, { {"If the meshShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT", 111}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-03935", 46}, { {"If the taskShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT", 111}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-04957", 46}, { {"If the subpassShading feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI", 121}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-04995", 46}, { {"If the invocationMask feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", 122}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-07316", 46}, { {"If neither of the shadingRateImage or the attachmentFragmentShadingRate features are enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", 184}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-07946", 46}, { {"If neither the VK_NV_ray_tracing extension or the rayTracingPipeline feature are enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", 166}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-10751", 46}, { {"If the accelerationStructure feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", 139}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-10752", 46}, { {"If the rayTracingMaintenance1 feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR", 139}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-10753", 46}, { {"If the micromap feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", 112}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryBarrier2-srcStageMask-parameter", 50}, { {"srcStageMask must be a valid combination of VkPipelineStageFlagBits2 values", 75}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkBufferMemoryRequirementsInfo2-buffer-parameter", 53}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferMemoryRequirementsInfo2-pNext-pNext", 48}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferMemoryRequirementsInfo2-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2", 65}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferOpaqueCaptureAddressCreateInfo-sType-sType", 55}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO", 73}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferUsageFlags2CreateInfo-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO", 64}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferUsageFlags2CreateInfo-usage-parameter", 50}, { {"usage must be a valid combination of VkBufferUsageFlagBits2 values", 66}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferUsageFlags2CreateInfo-usage-requiredbitmask", 56}, { {"usage must not be 0", 19}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-None-12278", 38}, { {"If Vulkan 1.3 is not supported and the ycbcr2plane444Formats feature is not enabled, format must not be VK_FORMAT_G8_B8R8_2PLANE_444_UNORM, VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16, VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16, or VK_FORMAT_G16_B16R16_2PLANE_444_UNORM", 286}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-buffer-00932", 40}, { {"buffer must have been created with at least one of the VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT or VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT usage flags set", 155}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-buffer-00935", 40}, { {"If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 107}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-buffer-02750", 40}, { {"If the texelBufferAlignment feature is enabled and if buffer was created with the VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT usage flag set, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentProperties::storageTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentProperties::storageTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", 540}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-buffer-02751", 40}, { {"If the texelBufferAlignment feature is enabled and if buffer was created with the VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT usage flag set, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentProperties::uniformTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentProperties::uniformTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", 540}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-buffer-parameter", 44}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-flags-zerobitmask", 45}, { {"flags must be 0", 15}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-format-08778", 40}, { {"If the buffer view usage contains VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, then format features of format must contain VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT", 162}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-format-08779", 40}, { {"If the buffer view usage contains VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, then format features of format must contain VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT", 162}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-format-parameter", 44}, { {"format must be a valid VkFormat value", 37}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-offset-00925", 40}, { {"offset must be less than the size of buffer", 43}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-offset-00931", 40}, { {"If range is not equal to VK_WHOLE_SIZE, the sum of offset and range must be less than or equal to the size of buffer", 116}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-offset-02749", 40}, { {"If the texelBufferAlignment feature is not enabled, offset must be a multiple of VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment", 134}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-pNext-06782", 39}, { {"If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT", 159}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-pNext-08780", 39}, { {"If the pNext chain includes a VkBufferUsageFlags2CreateInfo, its usage must not contain any other bit than VK_BUFFER_USAGE_2_UNIFORM_TEXEL_BUFFER_BIT or VK_BUFFER_USAGE_2_STORAGE_TEXEL_BUFFER_BIT", 195}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-pNext-08781", 39}, { {"If the pNext chain includes a VkBufferUsageFlags2CreateInfo, its usage must be a subset of the VkBufferCreateInfo::usage specified or VkBufferUsageFlags2CreateInfo::usage from VkBufferCreateInfo::pNext when creating buffer", 222}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-pNext-pNext", 39}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferUsageFlags2CreateInfo or VkExportMetalObjectCreateInfoEXT", 196}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-range-00928", 39}, { {"If range is not equal to VK_WHOLE_SIZE, range must be greater than 0", 68}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-range-00929", 39}, { {"If range is not equal to VK_WHOLE_SIZE, range must be an integer multiple of the texel block size of format", 107}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-range-00930", 39}, { {"If range is not equal to VK_WHOLE_SIZE, the number of texel buffer elements given by (floor(range / (texel block size)) x (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", 321}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-range-04059", 39}, { {"If range is equal to VK_WHOLE_SIZE, the number of texel buffer elements given by (floor((size - offset) / (texel block size)) x (texels per block)) where size is the size of buffer, and texel block size and texels per block are as defined in the Compatible Formats table for format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", 359}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO", 55}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBufferViewCreateInfo-sType-unique", 40}, { {"The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT", 142}, { "chapters/resources.html", 23} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureIndirectCommandNV-argData-10565", 75}, { {"An instance index must not be referenced by more than one structure in argData", 78}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureIndirectCommandNV-opType-parameter", 78}, { {"opType must be a valid VkPartitionedAccelerationStructureOpTypeNV value", 71}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-dstAccelerationStructureData-10561", 85}, { {"dstAccelerationStructureData must not be NULL", 45}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-dstAccelerationStructureData-10562", 85}, { {"Memory at dstAccelerationStructureData must be equal or larger than the VkAccelerationStructureBuildSizesInfoKHR::accelerationStructureSize value returned from vkGetPartitionedAccelerationStructuresBuildSizesNV with the same build parameters", 241}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-dstAccelerationStructureData-parameter", 89}, { {"dstAccelerationStructureData must be a valid VkDeviceAddress value", 66}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-input-parameter", 66}, { {"input must be a valid VkPartitionedAccelerationStructureInstancesInputNV structure", 82}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-pNext-pNext", 62}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-sType-sType", 62}, { {"sType must be VK_STRUCTURE_TYPE_BUILD_PARTITIONED_ACCELERATION_STRUCTURE_INFO_NV", 80}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-scratchData-10558", 68}, { {"If the buildScratchSize member of the VkAccelerationStructureBuildSizesInfoKHR structure returned from a call to vkGetPartitionedAccelerationStructuresBuildSizesNV is not 0, then scratchData must be a valid VkDeviceAddress", 222}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-scratchData-10559", 68}, { {"Memory at scratchData must be equal or larger than the VkAccelerationStructureBuildSizesInfoKHR::buildScratchSize value returned from vkGetPartitionedAccelerationStructuresBuildSizesNV with the same build parameters", 215}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-scratchData-parameter", 72}, { {"scratchData must be a valid VkDeviceAddress value", 49}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcAccelerationStructureData-10560", 85}, { {"If srcAccelerationStructureData is not NULL, it must have previously been built as a PTLAS", 90}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcAccelerationStructureData-parameter", 89}, { {"If srcAccelerationStructureData is not 0, srcAccelerationStructureData must be a valid VkDeviceAddress value", 108}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcInfos-10564", 65}, { {"Each element of srcInfos array must have a unique VkBuildPartitionedAccelerationStructureIndirectCommandNV::opType", 114}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcInfos-parameter", 69}, { {"srcInfos must be a valid VkDeviceAddress value", 46}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcInfosCount-10563", 70}, { {"srcInfosCount must be 4-byte aligned", 36}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcInfosCount-parameter", 74}, { {"srcInfosCount must be a valid VkDeviceAddress value", 51}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCalibratedTimestampInfoKHR-pNext-pNext", 45}, { {"pNext must be NULL or a pointer to a valid instance of VkSwapchainCalibratedTimestampInfoEXT", 92}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkCalibratedTimestampInfoKHR-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR", 61}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkCalibratedTimestampInfoKHR-sType-unique", 46}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkCalibratedTimestampInfoKHR-timeDomain-02354", 50}, { {"timeDomain must be one of the VkTimeDomainKHR values returned by vkGetPhysicalDeviceCalibrateableTimeDomainsKHR", 111}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkCalibratedTimestampInfoKHR-timeDomain-12227", 50}, { {"If timeDomain is VK_TIME_DOMAIN_SWAPCHAIN_LOCAL_EXT or VK_TIME_DOMAIN_PRESENT_STAGE_LOCAL_EXT, the pNext chain must include a VkSwapchainCalibratedTimestampInfoEXT structure", 173}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkCalibratedTimestampInfoKHR-timeDomain-parameter", 54}, { {"timeDomain must be a valid VkTimeDomainKHR value", 48}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkCheckpointData2NV-pNext-pNext", 36}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkCheckpointData2NV-sType-sType", 36}, { {"sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV", 52}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkCheckpointDataNV-pNext-pNext", 35}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkCheckpointDataNV-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV", 50}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkClearAttachment-aspectMask-00019", 39}, { {"If aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, it must not include VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", 126}, { "chapters/clears.html", 20} } },
        { {"VUID-VkClearAttachment-aspectMask-00020", 39}, { {"aspectMask must not include VK_IMAGE_ASPECT_METADATA_BIT", 56}, { "chapters/clears.html", 20} } },
        { {"VUID-VkClearAttachment-aspectMask-02246", 39}, { {"aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", 82}, { "chapters/clears.html", 20} } },
        { {"VUID-VkClearAttachment-aspectMask-parameter", 43}, { {"aspectMask must be a valid combination of VkImageAspectFlagBits values", 70}, { "chapters/clears.html", 20} } },
        { {"VUID-VkClearAttachment-aspectMask-requiredbitmask", 49}, { {"aspectMask must not be 0", 24}, { "chapters/clears.html", 20} } },
        { {"VUID-VkClearDepthStencilValue-depth-00022", 41}, { {"Unless the VK_EXT_depth_range_unrestricted extension is enabled depth must be between 0.0 and 1.0, inclusive", 108}, { "chapters/clears.html", 20} } },
        { {"VUID-VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV-clusterReferences-10484", 89}, { {"All cluster references in clusterReferences must be unique", 58}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV-clusterReferences-10485", 89}, { {"clusterReferences must have at least clusterReferencesCount values", 66}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV-clusterReferences-parameter", 93}, { {"clusterReferences must be a valid VkDeviceAddress value", 55}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV-clusterReferencesStride-10486", 95}, { {"clusterReferencesStride must be greater than or equal to 8", 58}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-baseGeometryIndex-10496", 85}, { {"The maximum geometry index after using the values in baseGeometryIndex and geometryIndexBuffer must be less than VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxClusterGeometryIndex", 194}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-clusterFlags-parameter", 84}, { {"clusterFlags must be a valid combination of VkClusterAccelerationStructureClusterFlagBitsNV values", 98}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-clusterID-10488", 77}, { {"clusterID must not be 0xFFFFFFFF", 32}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-geometryIndexAndFlagsBuffer-parameter", 99}, { {"If geometryIndexAndFlagsBuffer is not 0, geometryIndexAndFlagsBuffer must be a valid VkDeviceAddress value", 106}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-indexBuffer-parameter", 83}, { {"indexBuffer must be a valid VkDeviceAddress value", 49}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-indexBufferStride-10494", 85}, { {"indexBufferStride must be 0 or a multiple of indexType", 54}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-indexType-10491", 77}, { {"indexType must only have a single bit set", 41}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-opacityMicromapArray-10881", 88}, { {"If opacityMicromapArray is not 0, then the cluster acceleration structure must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_CLUSTER_OPACITY_MICROMAPS_BIT_NV flag set in VkClusterAccelerationStructureInputInfoNV::flags", 231}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-opacityMicromapArray-parameter", 92}, { {"If opacityMicromapArray is not 0, opacityMicromapArray must be a valid VkDeviceAddress value", 92}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-opacityMicromapIndexBuffer-parameter", 98}, { {"If opacityMicromapIndexBuffer is not 0, opacityMicromapIndexBuffer must be a valid VkDeviceAddress value", 104}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-opacityMicromapIndexType-10492", 92}, { {"opacityMicromapIndexType must only have a single bit set", 56}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-positionTruncateBitCount-10493", 92}, { {"positionTruncateBitCount must be greater than or equal to VkClusterAccelerationStructureTriangleClusterInputNV::minPositionTruncateBitCount and less than or equal to 32", 168}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-triangleCount-10489", 81}, { {"triangleCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxTrianglesPerCluster", 124}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-vertexBuffer-parameter", 84}, { {"vertexBuffer must be a valid VkDeviceAddress value", 50}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-vertexBufferStride-10495", 86}, { {"vertexBufferStride must be 0 or a multiple of value specified in VkClusterAccelerationStructureTriangleClusterInputNV::vertexFormat", 131}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-vertexCount-10490", 79}, { {"vertexCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxVerticesPerCluster", 121}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-baseGeometryIndex-10506", 93}, { {"The maximum geometry index after using the values in baseGeometryIndex and geometryIndexBuffer must be less than VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxClusterGeometryIndex", 194}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-clusterFlags-parameter", 92}, { {"clusterFlags must be a valid combination of VkClusterAccelerationStructureClusterFlagBitsNV values", 98}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-clusterID-10497", 85}, { {"clusterID must not be 0xFFFFFFFF", 32}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-geometryIndexAndFlagsBuffer-parameter", 107}, { {"If geometryIndexAndFlagsBuffer is not 0, geometryIndexAndFlagsBuffer must be a valid VkDeviceAddress value", 106}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-indexBuffer-parameter", 91}, { {"indexBuffer must be a valid VkDeviceAddress value", 49}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-indexBufferStride-10503", 93}, { {"indexBufferStride must be 0 or a multiple of indexType", 54}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-indexType-10500", 85}, { {"indexType must only have a single bit set", 41}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-instantiationBoundingBoxLimit-10505", 105}, { {"instantiationBoundingBoxLimit must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterTemplateBoundsByteAlignment", 141}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-instantiationBoundingBoxLimit-parameter", 109}, { {"If instantiationBoundingBoxLimit is not 0, instantiationBoundingBoxLimit must be a valid VkDeviceAddress value", 110}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-opacityMicromapArray-10882", 96}, { {"If opacityMicromapArray is not 0, then the template cluster acceleration structure must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_CLUSTER_OPACITY_MICROMAPS_BIT_NV flag set in VkClusterAccelerationStructureInputInfoNV::flags", 240}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-opacityMicromapArray-parameter", 100}, { {"If opacityMicromapArray is not 0, opacityMicromapArray must be a valid VkDeviceAddress value", 92}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-opacityMicromapIndexBuffer-parameter", 106}, { {"If opacityMicromapIndexBuffer is not 0, opacityMicromapIndexBuffer must be a valid VkDeviceAddress value", 104}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-opacityMicromapIndexType-10501", 100}, { {"opacityMicromapIndexType must only have a single bit set", 56}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-positionTruncateBitCount-10502", 100}, { {"positionTruncateBitCount must be greater than or equal to VkClusterAccelerationStructureTriangleClusterInputNV::minPositionTruncateBitCount and less than or equal to 32", 168}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-triangleCount-10498", 89}, { {"triangleCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxTrianglesPerCluster", 124}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-vertexBuffer-parameter", 92}, { {"If vertexBuffer is not 0, vertexBuffer must be a valid VkDeviceAddress value", 76}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-vertexBufferStride-10504", 94}, { {"vertexBufferStride must be 0 or a multiple of value specified in VkClusterAccelerationStructureTriangleClusterInputNV::vertexFormat", 131}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-vertexCount-10499", 87}, { {"vertexCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxVerticesPerCluster", 121}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureClustersBottomLevelInputNV-pNext-pNext", 73}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureClustersBottomLevelInputNV-sType-sType", 73}, { {"sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_CLUSTERS_BOTTOM_LEVEL_INPUT_NV", 93}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-addressResolutionFlags-parameter", 82}, { {"addressResolutionFlags must be a valid combination of VkClusterAccelerationStructureAddressResolutionFlagBitsNV values", 118}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-buildScratchSize-12321", 72}, { {"If the buildScratchSize member of the VkAccelerationStructureBuildSizesInfoKHR structure returned from a call to vkGetClusterAccelerationStructureBuildSizesNV is not 0, then VkClusterAccelerationStructureCommandsInfoNV::scratchData, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::scratchData when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SCRATCH_DATA_BIT_NV, must be a valid VkDeviceAddress", 530}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-dstAddressesArray-10474", 73}, { {"The stride in dstAddressesArray must be greater than or equal to 8", 66}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-dstImplicitData-parameter", 75}, { {"If dstImplicitData is not 0, dstImplicitData must be a valid VkDeviceAddress value", 82}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-dstSizesArray-10475", 69}, { {"The stride in dstSizesArray must be greater than or equal to 4", 62}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-10469", 61}, { {"If input.opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV, the total memory moved must not be larger than the size provided in VkClusterAccelerationStructureMoveObjectsInputNV::maxMovedBytes", 209}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-12317", 61}, { {"If input.opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_NV, then depending on the VkClusterAccelerationStructureInputInfoNV::opMode, VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV, or addresses specified in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray, or the addresses indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV, must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterByteAlignment", 966}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-12318", 61}, { {"If input.opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_TEMPLATE_NV, then depending on the VkClusterAccelerationStructureInputInfoNV::opMode, VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV, or addresses specified in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray, or the addresses indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV, must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterTemplateByteAlignment", 983}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-12319", 61}, { {"If input.opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_INSTANTIATE_TRIANGLE_CLUSTER_NV, then depending on the VkClusterAccelerationStructureInputInfoNV::opMode, VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV, or addresses specified in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray, or the addresses indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV, must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterByteAlignment", 972}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-12323", 61}, { {"If input.opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_CLUSTERS_BOTTOM_LEVEL_NV, the total and per argument number of cluster acceleration structures referenced in VkClusterAccelerationStructureCommandsInfoNV::srcInfosArray, or the structures indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::srcInfosArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SRC_INFOS_ARRAY_BIT_NV, must be equal or less than the maximum values with which memory requirements were queried in vkGetClusterAccelerationStructureBuildSizesNV with VkClusterAccelerationStructureOpInputNV::pClustersBottomLevel", 716}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-parameter", 65}, { {"input must be a valid VkClusterAccelerationStructureInputInfoNV structure", 73}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-12309", 62}, { {"If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV, VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV, must be a valid VkDeviceAddress", 493}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-12310", 62}, { {"If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV and input.opType is not VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV, the memory in VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData, or the memory indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV must be equal to or larger than the VkAccelerationStructureBuildSizesInfoKHR::accelerationStructureSize value returned from vkGetClusterAccelerationStructureBuildSizesNV with same input parameters", 752}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-12311", 62}, { {"If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV and input.opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV, the memory in VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData, or the memory indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstImplicitData when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV, must be equal to or larger than the sum of all the built acceleration structures that are being moved", 654}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-12312", 62}, { {"If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_COMPUTE_SIZES_NV, VkClusterAccelerationStructureCommandsInfoNV::dstSizesArray, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstSizesArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_SIZES_ARRAY_BIT_NV, must be a valid VkDeviceAddress", 479}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-12313", 62}, { {"If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV, the address in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV, must be a valid VkDeviceAddress", 512}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-12314", 62}, { {"If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV, the addresses in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray, or the memory indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV, must be large enough to accommodate built or moved clusters", 541}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-12315", 62}, { {"If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV, the buffers in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray, or the buffers indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV, must not overlap", 497}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-12316", 62}, { {"If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV, the addresses in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray, or the addresses indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::dstAddressesArray when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV, must be aligned based on the cluster acceleration structure type and its alignment properties as described in VkPhysicalDeviceClusterAccelerationStructurePropertiesNV", 651}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-pNext-pNext", 61}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-sType-sType", 61}, { {"sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_COMMANDS_INFO_NV", 79}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-scratchData-12320", 67}, { {"VkClusterAccelerationStructureCommandsInfoNV::scratchData, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::scratchData when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SCRATCH_DATA_BIT_NV, must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterScratchByteAlignment", 429}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-scratchData-parameter", 71}, { {"scratchData must be a valid VkDeviceAddress value", 49}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-srcInfosArray-10476", 69}, { {"The stride in srcInfosArray must be greater than the type of structure the address is describing", 96}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-srcInfosCount-12322", 69}, { {"VkClusterAccelerationStructureCommandsInfoNV::srcInfosCount, or the address indirectly referenced in VkClusterAccelerationStructureCommandsInfoNV::srcInfosCount when VkClusterAccelerationStructureCommandsInfoNV::addressResolutionFlags contains VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SRC_INFOS_COUNT_BIT_NV, must be 4-byte aligned", 354}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureCommandsInfoNV-srcInfosCount-parameter", 73}, { {"If srcInfosCount is not 0, srcInfosCount must be a valid VkDeviceAddress value", 78}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV-reserved-10487", 81}, { {"reserved must be 0", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureGetTemplateIndicesInfoNV-clusterTemplateAddress-10833", 88}, { {"clusterTemplateAddress must be a template cluster acceleration structure", 72}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureGetTemplateIndicesInfoNV-clusterTemplateAddress-parameter", 92}, { {"clusterTemplateAddress must be a valid VkDeviceAddress value", 60}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInputInfoNV-flags-parameter", 62}, { {"flags must be a valid combination of VkBuildAccelerationStructureFlagBitsKHR values", 83}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInputInfoNV-opMode-parameter", 63}, { {"opMode must be a valid VkClusterAccelerationStructureOpModeNV value", 67}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInputInfoNV-opType-parameter", 63}, { {"opType must be a valid VkClusterAccelerationStructureOpTypeNV value", 67}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInputInfoNV-pClustersBottomLevel-parameter", 77}, { {"If opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_CLUSTERS_BOTTOM_LEVEL_NV, the pClustersBottomLevel member of opInput must be a valid pointer to a VkClusterAccelerationStructureClustersBottomLevelInputNV structure", 225}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInputInfoNV-pMoveObjects-parameter", 69}, { {"If opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV, the pMoveObjects member of opInput must be a valid pointer to a VkClusterAccelerationStructureMoveObjectsInputNV structure", 194}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInputInfoNV-pNext-pNext", 58}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInputInfoNV-pTriangleClusters-parameter", 74}, { {"If opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_NV, VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_TEMPLATE_NV, VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_INSTANTIATE_TRIANGLE_CLUSTER_NV, or VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_GET_CLUSTER_TEMPLATE_INDICES_NV, the pTriangleClusters member of opInput must be a valid pointer to a VkClusterAccelerationStructureTriangleClusterInputNV structure", 444}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInputInfoNV-sType-sType", 58}, { {"sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_INPUT_INFO_NV", 76}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-clusterTemplateAddress-parameter", 92}, { {"clusterTemplateAddress must be a valid VkDeviceAddress value", 60}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-geometryIndexOffset-10510", 85}, { {"The maximum geometry index after using the value in geometryIndexOffset must be less than VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxClusterGeometryIndex", 171}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-reserved-10509", 74}, { {"reserved must be 0", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-vertexBuffer-10507", 78}, { {"vertexBuffer must not be 0 if the template was built without vertex data", 72}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-vertexBuffer-10508", 78}, { {"The format in vertexBuffer must match the original format specified in VkClusterAccelerationStructureTriangleClusterInputNV", 123}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureMoveObjectsInfoNV-srcAccelerationStructure-10483", 83}, { {"srcAccelerationStructure must be a type of cluster acceleration structure", 73}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureMoveObjectsInfoNV-srcAccelerationStructure-parameter", 87}, { {"srcAccelerationStructure must be a valid VkDeviceAddress value", 62}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureMoveObjectsInputNV-pNext-pNext", 65}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureMoveObjectsInputNV-sType-sType", 65}, { {"sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_MOVE_OBJECTS_INPUT_NV", 84}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureMoveObjectsInputNV-type-parameter", 68}, { {"type must be a valid VkClusterAccelerationStructureTypeNV value", 63}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-maxClusterTriangleCount-10440", 87}, { {"maxClusterTriangleCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxTrianglesPerCluster", 134}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-maxClusterVertexCount-10441", 85}, { {"maxClusterVertexCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxVerticesPerCluster", 131}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-minPositionTruncateBitCount-10442", 91}, { {"minPositionTruncateBitCount must be less than or equal to 32", 60}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-pNext-pNext", 69}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-sType-sType", 69}, { {"sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_TRIANGLE_CLUSTER_INPUT_NV", 88}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-vertexFormat-10439", 76}, { {"The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", 111}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-vertexFormat-parameter", 80}, { {"vertexFormat must be a valid VkFormat value", 43}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCoarseSampleLocationNV-pixelX-02078", 42}, { {"pixelX must be less than the width (in pixels) of the fragment", 62}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleLocationNV-pixelY-02079", 42}, { {"pixelY must be less than the height (in pixels) of the fragment", 63}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleLocationNV-sample-02080", 42}, { {"sample must be less than the number of coverage samples in each pixel belonging to the fragment", 95}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-02077", 55}, { {"The array pSampleLocations must contain exactly one entry for every combination of valid values for pixelX, pixelY, and sample in the structure VkCoarseSampleOrderCustomNV", 171}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-parameter", 59}, { {"pSampleLocations must be a valid pointer to an array of sampleLocationCount VkCoarseSampleLocationNV structures", 111}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleOrderCustomNV-sampleCount-02074", 50}, { {"sampleCount must correspond to a sample count enumerated in VkSampleCountFlags whose corresponding bit is set in VkPhysicalDeviceLimits::framebufferNoAttachmentsSampleCounts", 173}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02075", 58}, { {"sampleLocationCount must be equal to the product of sampleCount, the fragment width for shadingRate, and the fragment height for shadingRate", 140}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02076", 58}, { {"sampleLocationCount must be less than or equal to the value of VkPhysicalDeviceShadingRateImagePropertiesNV::shadingRateMaxCoarseSamples", 136}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-arraylength", 64}, { {"sampleLocationCount must be greater than 0", 42}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-02073", 50}, { {"shadingRate must be a shading rate that generates fragments with more than one pixel", 84}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-parameter", 54}, { {"shadingRate must be a valid VkShadingRatePaletteEntryNV value", 61}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkColorBlendAdvancedEXT-advancedBlendOp-parameter", 54}, { {"advancedBlendOp must be a valid VkBlendOp value", 47}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendAdvancedEXT-blendOverlap-07507", 47}, { {"If the correlated overlap property is not supported, blendOverlap must be VK_BLEND_OVERLAP_UNCORRELATED_EXT", 107}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendAdvancedEXT-blendOverlap-parameter", 51}, { {"blendOverlap must be a valid VkBlendOverlapEXT value", 52}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendAdvancedEXT-dstPremultiplied-07506", 51}, { {"If the non-premultiplied destination color property is not supported, dstPremultiplied must be VK_TRUE", 102}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendAdvancedEXT-srcPremultiplied-07505", 51}, { {"If the non-premultiplied source color property is not supported, srcPremultiplied must be VK_TRUE", 97}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-alphaBlendOp-parameter", 51}, { {"alphaBlendOp must be a valid VkBlendOp value", 44}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-colorBlendOp-07361", 47}, { {"colorBlendOp and alphaBlendOp must not be a VkBlendOp from VK_EXT_blend_operation_advanced", 90}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-colorBlendOp-parameter", 51}, { {"colorBlendOp must be a valid VkBlendOp value", 44}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-constantAlphaColorBlendFactors-07362", 65}, { {"If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::constantAlphaColorBlendFactors is VK_FALSE, srcColorBlendFactor must not be VK_BLEND_FACTOR_CONSTANT_ALPHA or VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA", 255}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-constantAlphaColorBlendFactors-07363", 65}, { {"If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::constantAlphaColorBlendFactors is VK_FALSE, dstColorBlendFactor must not be VK_BLEND_FACTOR_CONSTANT_ALPHA or VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA", 255}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-dstAlphaBlendFactor-parameter", 58}, { {"dstAlphaBlendFactor must be a valid VkBlendFactor value", 55}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-dstColorBlendFactor-parameter", 58}, { {"dstColorBlendFactor must be a valid VkBlendFactor value", 55}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07357", 47}, { {"If the dualSrcBlend feature is not enabled, srcColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", 209}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07358", 47}, { {"If the dualSrcBlend feature is not enabled, dstColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", 209}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07359", 47}, { {"If the dualSrcBlend feature is not enabled, srcAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", 209}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07360", 47}, { {"If the dualSrcBlend feature is not enabled, dstAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", 209}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-srcAlphaBlendFactor-parameter", 58}, { {"srcAlphaBlendFactor must be a valid VkBlendFactor value", 55}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkColorBlendEquationEXT-srcColorBlendFactor-parameter", 58}, { {"srcColorBlendFactor must be a valid VkBlendFactor value", 55}, { "chapters/framebuffer.html", 25} } },
        { {"VUID-VkCommandBufferAllocateInfo-commandPool-parameter", 54}, { {"commandPool must be a valid VkCommandPool handle", 48}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferAllocateInfo-level-parameter", 48}, { {"level must be a valid VkCommandBufferLevel value", 48}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferAllocateInfo-pNext-pNext", 44}, { {"pNext must be NULL", 18}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferAllocateInfo-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO", 60}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-00055", 41}, { {"If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the framebuffer member of pInheritanceInfo must be either VK_NULL_HANDLE, or a valid VkFramebuffer that is compatible with the renderPass member of pInheritanceInfo", 232}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-06000", 41}, { {"If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is not VK_NULL_HANDLE, the renderPass member of pInheritanceInfo must be a valid VkRenderPass", 206}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-06001", 41}, { {"If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is not VK_NULL_HANDLE, the subpass member of pInheritanceInfo must be a valid subpass index within the renderPass member of pInheritanceInfo", 253}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-06002", 41}, { {"If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is VK_NULL_HANDLE, the pNext chain of pInheritanceInfo must include a VkCommandBufferInheritanceRenderingInfo structure", 232}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-06003", 41}, { {"If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the renderPass member of pInheritanceInfo is VK_NULL_HANDLE, and the pNext chain of pInheritanceInfo includes a VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV structure, the colorAttachmentCount member of that structure must be equal to the value of VkCommandBufferInheritanceRenderingInfo::colorAttachmentCount", 396}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-09123", 41}, { {"If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the VkCommandPool that commandBuffer was allocated from must support graphics operations", 156}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-09240", 41}, { {"If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the dynamicRendering feature is not enabled, the renderPass member of pInheritanceInfo must not be VK_NULL_HANDLE", 184}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-10617", 41}, { {"If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT , the renderPass member of pInheritanceInfo is not VK_NULL_HANDLE, and renderPass was created with tile shading enabled, VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM must be included in VkRenderPassTileShadingCreateInfoQCOM::flags", 296}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-10618", 41}, { {"If flags does not contain VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT , the renderPass member of pInheritanceInfo is VK_NULL_HANDLE, or renderPass was not created with tile shading enabled, VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM must not be included in VkRenderPassTileShadingCreateInfoQCOM::flags", 307}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-10619", 41}, { {"If VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM is included in VkRenderPassTileShadingCreateInfoQCOM::flags, VkRenderPassTileShadingCreateInfoQCOM::tileApronSize must be equal to the tileApronSize used to create renderPass", 221}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-flags-parameter", 45}, { {"flags must be a valid combination of VkCommandBufferUsageFlagBits values", 72}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-pNext-pNext", 41}, { {"pNext must be NULL or a pointer to a valid instance of VkDeviceGroupCommandBufferBeginInfo", 90}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-sType-sType", 41}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO", 57}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferBeginInfo-sType-unique", 42}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-conditionalRenderingEnable-01977", 91}, { {"If the inheritedConditionalRendering feature is not enabled, conditionalRenderingEnable must be VK_FALSE", 104}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType-sType", 70}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT", 89}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceDescriptorHeapInfoEXT-descriptorHeap-11200", 73}, { {"If the descriptorHeap feature is not enabled, pSamplerHeapBindInfo must be NULL", 79}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceDescriptorHeapInfoEXT-descriptorHeap-11201", 73}, { {"If the descriptorHeap feature is not enabled, pResourceHeapBindInfo must be NULL", 80}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceDescriptorHeapInfoEXT-pResourceHeapBindInfo-11471", 80}, { {"If pResourceHeapBindInfo is not NULL, pResourceHeapBindInfo->heapRange must be a device address range allocated to the application from a buffer created with the VK_BUFFER_USAGE_DESCRIPTOR_HEAP_BIT_EXT usage flag set", 216}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceDescriptorHeapInfoEXT-pResourceHeapBindInfo-parameter", 84}, { {"If pResourceHeapBindInfo is not NULL, pResourceHeapBindInfo must be a valid pointer to a valid VkBindHeapInfoEXT structure", 122}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceDescriptorHeapInfoEXT-pSamplerHeapBindInfo-11470", 79}, { {"If pSamplerHeapBindInfo is not NULL, pSamplerHeapBindInfo->heapRange must be a device address range allocated to the application from a buffer created with the VK_BUFFER_USAGE_DESCRIPTOR_HEAP_BIT_EXT usage flag set", 214}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceDescriptorHeapInfoEXT-pSamplerHeapBindInfo-parameter", 83}, { {"If pSamplerHeapBindInfo is not NULL, pSamplerHeapBindInfo must be a valid pointer to a valid VkBindHeapInfoEXT structure", 120}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceDescriptorHeapInfoEXT-sType-sType", 64}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_DESCRIPTOR_HEAP_INFO_EXT", 83}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-commonparent", 48}, { {"Both of framebuffer, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 155}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-occlusionQueryEnable-00056", 62}, { {"If the inheritedQueries feature is not enabled, occlusionQueryEnable must be VK_FALSE", 85}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-pNext-pNext", 47}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAttachmentSampleCountInfoAMD, VkCommandBufferInheritanceConditionalRenderingInfoEXT, VkCommandBufferInheritanceDescriptorHeapInfoEXT, VkCommandBufferInheritanceRenderPassTransformInfoQCOM, VkCommandBufferInheritanceRenderingInfo, VkCommandBufferInheritanceViewportScissorInfoNV, VkCustomResolveCreateInfoEXT, VkExternalFormatANDROID, VkExternalFormatOHOS, VkMultiviewPerViewAttributesInfoNVX, VkRenderPassTileShadingCreateInfoQCOM, VkRenderingAttachmentLocationInfo, VkRenderingInputAttachmentIndexInfo, or VkTileMemoryBindInfoQCOM", 664}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-00058", 60}, { {"If the pipelineStatisticsQuery feature is not enabled, pipelineStatistics must be 0", 83}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-02789", 60}, { {"If the pipelineStatisticsQuery feature is enabled, pipelineStatistics must be a valid combination of VkQueryPipelineStatisticFlagBits values", 140}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-queryFlags-00057", 52}, { {"If the inheritedQueries feature is enabled, queryFlags must be a valid combination of VkQueryControlFlagBits values", 115}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-queryFlags-02788", 52}, { {"If the inheritedQueries feature is not enabled, queryFlags must be 0", 68}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-sType-sType", 47}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO", 63}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceInfo-sType-unique", 48}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-sType-sType", 70}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM", 90}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-transform-02864", 74}, { {"transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", 180}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-colorAttachmentCount-06004", 71}, { {"If colorAttachmentCount is not 0, rasterizationSamples must be a valid VkSampleCountFlagBits value", 98}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06007", 72}, { {"If depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", 163}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06200", 72}, { {"If depthAttachmentFormat is not VK_FORMAT_UNDEFINED and stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, depthAttachmentFormat must equal stencilAttachmentFormat", 164}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06540", 72}, { {"If depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a depth component", 104}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-parameter", 76}, { {"depthAttachmentFormat must be a valid VkFormat value", 52}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-flags-parameter", 60}, { {"flags must be a valid combination of VkRenderingFlagBits values", 63}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-multiview-06008", 60}, { {"If the multiview feature is not enabled, viewMask must be 0", 59}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-pColorAttachmentFormats-06492", 74}, { {"If any element of pColorAttachmentFormats is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT , or VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV if the linearColorAttachment feature is enabled", 276}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-pColorAttachmentFormats-parameter", 78}, { {"If colorAttachmentCount is not 0, pColorAttachmentFormats must be a valid pointer to an array of colorAttachmentCount valid VkFormat values", 139}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-rasterizationSamples-parameter", 75}, { {"If rasterizationSamples is not 0, rasterizationSamples must be a valid VkSampleCountFlagBits value", 98}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-sType-sType", 56}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO", 73}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-06199", 74}, { {"If stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", 165}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-06541", 74}, { {"If stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a stencil aspect", 105}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-parameter", 78}, { {"stencilAttachmentFormat must be a valid VkFormat value", 54}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-variableMultisampleRate-06005", 74}, { {"If the variableMultisampleRate feature is not enabled, rasterizationSamples must be a valid VkSampleCountFlagBits value", 119}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceRenderingInfo-viewMask-06009", 59}, { {"The index of the most significant bit in viewMask must be less than maxMultiviewViewCount", 89}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-sType-sType", 64}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV", 83}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04782", 76}, { {"If the inheritedViewportScissor2D feature is not enabled, viewportScissor2D must be VK_FALSE", 92}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04783", 76}, { {"If the multiViewport feature is not enabled and viewportScissor2D is VK_TRUE, then viewportDepthCount must be 1", 111}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04784", 76}, { {"If viewportScissor2D is VK_TRUE, then viewportDepthCount must be greater than 0", 79}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04785", 76}, { {"If viewportScissor2D is VK_TRUE, then pViewportDepths must be a valid pointer to an array of viewportDepthCount valid VkViewport structures, except any requirements on x, y, width, and height do not apply", 204}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04786", 76}, { {"If viewportScissor2D is VK_TRUE, then the command buffer must be recorded with the VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT", 131}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferSubmitInfo-commandBuffer-03890", 50}, { {"commandBuffer must not have been allocated with VK_COMMAND_BUFFER_LEVEL_SECONDARY", 81}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferSubmitInfo-commandBuffer-09445", 50}, { {"If any render pass instance in commandBuffer was recorded with a VkRenderPassStripeBeginInfoARM structure in its pNext chain and did not specify the VK_RENDERING_RESUMING_BIT flag, a VkRenderPassStripeSubmitInfoARM must be included in the pNext chain", 250}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferSubmitInfo-commandBuffer-parameter", 54}, { {"commandBuffer must be a valid VkCommandBuffer handle", 52}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferSubmitInfo-deviceMask-03891", 47}, { {"If deviceMask is not 0, it must be a valid device mask", 54}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferSubmitInfo-pNext-09446", 42}, { {"If a VkRenderPassStripeSubmitInfoARM is included in the pNext chain, the value of VkRenderPassStripeSubmitInfoARM::stripeSemaphoreInfoCount must be equal to the sum of the VkRenderPassStripeBeginInfoARM::stripeInfoCount parameters provided to render pass instances recorded in commandBuffer that did not specify the VK_RENDERING_RESUMING_BIT flag", 346}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferSubmitInfo-pNext-pNext", 42}, { {"pNext must be NULL or a pointer to a valid instance of VkRenderPassStripeSubmitInfoARM", 86}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferSubmitInfo-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO", 58}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandBufferSubmitInfo-sType-unique", 43}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandPoolCreateInfo-flags-02860", 40}, { {"If the protectedMemory feature is not enabled, the VK_COMMAND_POOL_CREATE_PROTECTED_BIT bit of flags must not be set", 116}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandPoolCreateInfo-flags-parameter", 44}, { {"flags must be a valid combination of VkCommandPoolCreateFlagBits values", 71}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandPoolCreateInfo-pNext-09908", 40}, { {"If the pNext chain includes a VkDataGraphProcessingEngineCreateInfoARM structure, then queueFamilyIndex must designate a queue family that supports VK_QUEUE_DATA_GRAPH_BIT_ARM", 175}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandPoolCreateInfo-pNext-09909", 40}, { {"If the pNext chain includes a VkDataGraphProcessingEngineCreateInfoARM structure, each member of pProcessingEngines must be identical to VkQueueFamilyDataGraphPropertiesARM::engine retrieved from vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM with queueFamilyIndex and the physicalDevice that was used to create device", 324}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandPoolCreateInfo-pNext-pNext", 40}, { {"pNext must be NULL or a pointer to a valid instance of VkDataGraphProcessingEngineCreateInfoARM", 95}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandPoolCreateInfo-queueFamilyIndex-11830", 51}, { {"If queueFamilyIndex designates a queue family that supports VK_QUEUE_DATA_GRAPH_BIT_ARM and enumerates a foreign engine through vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM with type VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_NEURAL_QCOM or VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_COMPUTE_QCOM, the pNext chain must include VkDataGraphProcessingEngineCreateInfoARM with VkPhysicalDeviceDataGraphProcessingEngineARM::isForeign set to VK_TRUE for all elements of pProcessingEngines", 510}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandPoolCreateInfo-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO", 56}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkCommandPoolCreateInfo-sType-unique", 41}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkComponentMapping-a-parameter", 35}, { {"a must be a valid VkComponentSwizzle value", 42}, { "chapters/resources.html", 23} } },
        { {"VUID-VkComponentMapping-b-parameter", 35}, { {"b must be a valid VkComponentSwizzle value", 42}, { "chapters/resources.html", 23} } },
        { {"VUID-VkComponentMapping-g-parameter", 35}, { {"g must be a valid VkComponentSwizzle value", 42}, { "chapters/resources.html", 23} } },
        { {"VUID-VkComponentMapping-r-parameter", 35}, { {"r must be a valid VkComponentSwizzle value", 42}, { "chapters/resources.html", 23} } },
        { {"VUID-VkComputeOccupancyPriorityParametersNV-occupancyPriority-12298", 67}, { {"occupancyPriority must be between 0 and 1, inclusive", 52}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkComputeOccupancyPriorityParametersNV-occupancyThrottling-12299", 69}, { {"occupancyThrottling must be between 0 and 1, inclusive", 54}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkComputeOccupancyPriorityParametersNV-pNext-pNext", 55}, { {"pNext must be NULL", 18}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkComputeOccupancyPriorityParametersNV-sType-sType", 55}, { {"sType must be VK_STRUCTURE_TYPE_COMPUTE_OCCUPANCY_PRIORITY_PARAMETERS_NV", 72}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkComputePipelineCreateInfo-None-09497", 43}, { {"If the pNext chain does not include a VkPipelineCreateFlags2CreateInfo structure, flags must be a valid combination of VkPipelineCreateFlagBits values", 150}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-None-10391", 43}, { {"If a resource variables is declared in a shader as an array of descriptors, then the descriptor type of that variable must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", 169}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-None-11367", 43}, { {"If VkPipelineCreateFlags2CreateInfoKHR::flags does not include VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT, layout must not be VK_NULL_HANDLE", 142}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-commonparent", 45}, { {"Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 158}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-03365", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", 85}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-03366", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", 89}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-03367", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", 82}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-03368", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", 90}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-03369", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", 76}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-03370", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", 72}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-03576", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", 96}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-04945", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", 73}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-07367", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT", 78}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-07369", 44}, { {"flags must not include both VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT and VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT", 119}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-07984", 44}, { {"If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid compute VkPipeline handle", 151}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-07985", 44}, { {"If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", 193}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-07986", 44}, { {"If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, basePipelineIndex must be -1 or basePipelineHandle must be VK_NULL_HANDLE", 135}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-07996", 44}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV", 82}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-09007", 44}, { {"If the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature is not enabled, flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", 187}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-09008", 44}, { {"If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the pNext chain must include a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV specifying the address where the pipeline's metadata will be saved", 234}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-09178", 44}, { {"If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, the shader specified by stage must not declare the ShaderEnqueueAMDX capability", 141}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-11007", 44}, { {"If flags includes VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then the VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT::deviceGeneratedCommands feature must be enabled", 174}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-11311", 44}, { {"If VkPipelineCreateFlags2CreateInfoKHR::flags includes VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT, layout must be VK_NULL_HANDLE", 130}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-11312", 44}, { {"If VkPipelineCreateFlags2CreateInfoKHR::flags includes VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT, all shader variables in the shader resource interface with a DescriptorSet and Binding decoration must have a mapping declared in VkShaderDescriptorSetAndBindingMappingInfoEXT::pMappings", 287}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-flags-11798", 44}, { {"If shader64BitIndexing feature is not enabled, flags must not contain VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT", 114}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-layout-01687", 45}, { {"If layout is not VK_NULL_HANDLE, the number of resources in layout accessible to the compute shader stage must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", 180}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-layout-07987", 45}, { {"If a push constant block is declared in a shader and layout is not VK_NULL_HANDLE, a push constant range in layout must match the shader stage", 142}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-layout-07988", 45}, { {"If a resource variable is declared in a shader and layout is not VK_NULL_HANDLE, the corresponding descriptor set in layout must match the shader stage", 151}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-layout-07990", 45}, { {"If a resource variable is declared in a shader, layout is not VK_NULL_HANDLE, and the descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in layout must match the descriptor type", 214}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-layout-07991", 45}, { {"If a resource variable is declared in a shader as an array and layout is not VK_NULL_HANDLE, the corresponding descriptor binding used to create layout must have a descriptorCount that is greater than or equal to the length of the array", 236}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-layout-10069", 45}, { {"If a push constant block is declared in a shader and layout is not VK_NULL_HANDLE, the block must be contained inside the push constant range in layout that matches the stage", 174}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-layout-parameter", 49}, { {"If layout is not VK_NULL_HANDLE, layout must be a valid VkPipelineLayout handle", 79}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-pNext-pNext", 44}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV, VkPipelineBinaryInfoKHR, VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreateFlags2CreateInfo, VkPipelineCreationFeedbackCreateInfo, VkPipelineRobustnessCreateInfo, or VkSubpassShadingPipelineCreateInfoHUAWEI", 382}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-pipelineCreationCacheControl-02878", 67}, { {"If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT nor VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT", 190}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-pipelineProtectedAccess-07368", 62}, { {"If the pipelineProtectedAccess feature is not enabled, flags must not include VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT nor VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT", 169}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-pipelineStageCreationFeedbackCount-06566", 73}, { {"If VkPipelineCreationFeedbackCreateInfo::pipelineStageCreationFeedbackCount is not 0, it must be 1", 98}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO", 60}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-sType-unique", 45}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-shaderEnqueue-09177", 52}, { {"If the shaderEnqueue feature is not enabled, flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", 102}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-stage-00701", 44}, { {"The stage member of stage must be VK_SHADER_STAGE_COMPUTE_BIT", 61}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-stage-00702", 44}, { {"The shader code for the entry point identified by stage and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", 195}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineCreateInfo-stage-parameter", 48}, { {"stage must be a valid VkPipelineShaderStageCreateInfo structure", 63}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceAddress-09011", 62}, { {"deviceAddress must be aligned to the VkMemoryRequirements2::memoryRequirements.alignment, as returned by vkGetPipelineIndirectMemoryRequirementsNV", 146}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceAddress-09012", 62}, { {"deviceAddress must have been allocated from a buffer that was created with both the VK_BUFFER_USAGE_TRANSFER_DST_BIT and VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT usage flags set", 172}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceAddress-parameter", 66}, { {"deviceAddress must be a valid VkDeviceAddress value", 51}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceGeneratedComputePipelines-09009", 80}, { {"The VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature must be enabled", 117}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-flags-09010", 54}, { {"The pipeline creation flags in VkComputePipelineCreateInfo::flags must include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", 122}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09014", 83}, { {"If pipelineDeviceAddressCaptureReplay is non-zero then the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputeCaptureReplay feature must be enabled", 176}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09015", 83}, { {"If pipelineDeviceAddressCaptureReplay is non-zero then that address must have been allocated with flag VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT set", 159}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09016", 83}, { {"If pipelineDeviceAddressCaptureReplay is non-zero, the pipeline must have been recreated for replay", 99}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09017", 83}, { {"pipelineDeviceAddressCaptureReplay must satisfy the alignment and size requirements similar to deviceAddress", 108}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-parameter", 87}, { {"If pipelineDeviceAddressCaptureReplay is not 0, pipelineDeviceAddressCaptureReplay must be a valid VkDeviceAddress value", 120}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-sType-sType", 54}, { {"sType must be VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV", 72}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkComputePipelineIndirectBufferInfoNV-size-09013", 53}, { {"size must be greater than or equal to the VkMemoryRequirements2::memoryRequirements.size, as returned by vkGetPipelineIndirectMemoryRequirementsNV", 146}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01981", 52}, { {"If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 107}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01982", 52}, { {"buffer must have been created with the VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT usage flag set", 99}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-parameter", 56}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkConditionalRenderingBeginInfoEXT-flags-parameter", 55}, { {"flags must be a valid combination of VkConditionalRenderingFlagBitsEXT values", 77}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01983", 52}, { {"offset must be less than the size of buffer by at least 32 bits", 63}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01984", 52}, { {"offset must be a multiple of 4", 30}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkConditionalRenderingBeginInfoEXT-pNext-pNext", 51}, { {"pNext must be NULL", 18}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkConditionalRenderingBeginInfoEXT-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT", 68}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstComponentType-10080", 66}, { {"If dstComponentType is not a supported VkCooperativeVectorPropertiesNV::matrixInterpretation value as reported by vkGetPhysicalDeviceCooperativeVectorPropertiesNV, then dstComponentType must be VK_COMPONENT_TYPE_FLOAT32_KHR", 223}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstComponentType-10082", 66}, { {"If dstComponentType is VK_COMPONENT_TYPE_FLOAT_E4M3_NV or VK_COMPONENT_TYPE_FLOAT_E5M2_NV, then dstLayout must be VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_INFERENCING_OPTIMAL_NV or VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_TRAINING_OPTIMAL_NV", 231}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstComponentType-parameter", 70}, { {"dstComponentType must be a valid VkComponentTypeKHR value", 57}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstData-parameter", 61}, { {"dstData must be a valid VkDeviceOrHostAddressKHR union", 54}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstLayout-10078", 59}, { {"If dstLayout is row-major or column-major, then dstStride must be greater than the length of a row/column, and a multiple of the element size", 141}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstLayout-parameter", 63}, { {"dstLayout must be a valid VkCooperativeVectorMatrixLayoutNV value", 65}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-pDstSize-parameter", 62}, { {"pDstSize must be a valid pointer to a size_t value", 50}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-pNext-pNext", 55}, { {"pNext must be NULL", 18}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-sType-sType", 55}, { {"sType must be VK_STRUCTURE_TYPE_CONVERT_COOPERATIVE_VECTOR_MATRIX_INFO_NV", 73}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcComponentType-10079", 66}, { {"If srcComponentType is not a supported VkCooperativeVectorPropertiesNV::matrixInterpretation value as reported by vkGetPhysicalDeviceCooperativeVectorPropertiesNV, then srcComponentType must be VK_COMPONENT_TYPE_FLOAT32_KHR", 223}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcComponentType-10081", 66}, { {"If srcComponentType and dstComponentType are not equal, then one must be VK_COMPONENT_TYPE_FLOAT32_KHR or VK_COMPONENT_TYPE_FLOAT16_KHR and the other must be a lower-precision floating-point type", 195}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcComponentType-parameter", 70}, { {"srcComponentType must be a valid VkComponentTypeKHR value", 57}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcData-parameter", 61}, { {"srcData must be a valid VkDeviceOrHostAddressConstKHR union", 59}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcLayout-10077", 59}, { {"If srcLayout is row-major or column-major, then srcStride must be greater than the length of a row/column, and a multiple of the element size", 141}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcLayout-parameter", 63}, { {"srcLayout must be a valid VkCooperativeVectorMatrixLayoutNV value", 65}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeMatrixFlexibleDimensionsPropertiesNV-pNext-pNext", 66}, { {"pNext must be NULL", 18}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeMatrixFlexibleDimensionsPropertiesNV-sType-sType", 66}, { {"sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_FLEXIBLE_DIMENSIONS_PROPERTIES_NV", 84}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeMatrixPropertiesKHR-pNext-pNext", 49}, { {"pNext must be NULL", 18}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeMatrixPropertiesKHR-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR", 65}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeMatrixPropertiesNV-pNext-pNext", 48}, { {"pNext must be NULL", 18}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeMatrixPropertiesNV-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV", 64}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeVectorPropertiesNV-biasInterpretation-parameter", 65}, { {"biasInterpretation must be a valid VkComponentTypeKHR value", 59}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeVectorPropertiesNV-inputInterpretation-parameter", 66}, { {"inputInterpretation must be a valid VkComponentTypeKHR value", 60}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeVectorPropertiesNV-inputType-parameter", 56}, { {"inputType must be a valid VkComponentTypeKHR value", 50}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeVectorPropertiesNV-matrixInterpretation-parameter", 67}, { {"matrixInterpretation must be a valid VkComponentTypeKHR value", 61}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeVectorPropertiesNV-pNext-pNext", 48}, { {"pNext must be NULL", 18}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeVectorPropertiesNV-resultType-parameter", 57}, { {"resultType must be a valid VkComponentTypeKHR value", 51}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCooperativeVectorPropertiesNV-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_COOPERATIVE_VECTOR_PROPERTIES_NV", 64}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-buffer-03718", 52}, { {"The buffer used to create src must be bound to device memory", 60}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-buffer-03719", 52}, { {"The buffer used to create dst must be bound to device memory", 60}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-commonparent", 52}, { {"Both of dst, and src must have been created, allocated, or retrieved from the same VkDevice", 91}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-dst-07791", 49}, { {"The range of memory backing dst that is accessed by this command must not overlap the memory backing src that is accessed by this command", 137}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-dst-parameter", 53}, { {"dst must be a valid VkAccelerationStructureKHR handle", 53}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-mode-03410", 50}, { {"mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR or VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR", 109}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-mode-parameter", 54}, { {"mode must be a valid VkCopyAccelerationStructureModeKHR value", 61}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-pNext-pNext", 51}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR", 68}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-src-03411", 49}, { {"If mode is VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR, src must have been constructed with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR in the build", 165}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-src-04963", 49}, { {"The source acceleration structure src must have been constructed prior to the execution of this command", 103}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureInfoKHR-src-parameter", 53}, { {"src must be a valid VkAccelerationStructureKHR handle", 53}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-dst-03561", 57}, { {"The memory pointed to by dst must be at least as large as the serialization size of src, as reported by vkWriteAccelerationStructuresPropertiesKHR or vkCmdWriteAccelerationStructuresPropertiesKHR with a query type of VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR", 276}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-mode-03412", 58}, { {"mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR", 62}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-mode-parameter", 62}, { {"mode must be a valid VkCopyAccelerationStructureModeKHR value", 61}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-pNext-pNext", 59}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-sType-sType", 59}, { {"sType must be VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR", 78}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-src-04959", 57}, { {"The source acceleration structure src must have been constructed prior to the execution of this command", 103}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-src-parameter", 61}, { {"src must be a valid VkAccelerationStructureKHR handle", 53}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyBufferInfo2-commonparent", 35}, { {"Both of dstBuffer, and srcBuffer must have been created, allocated, or retrieved from the same VkDevice", 103}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-dstBuffer-00120", 38}, { {"dstBuffer must have been created with the VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag set", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-dstBuffer-00121", 38}, { {"If dstBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 110}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-dstBuffer-parameter", 42}, { {"dstBuffer must be a valid VkBuffer handle", 41}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-dstOffset-00114", 38}, { {"The dstOffset member of each element of pRegions must be less than the size of dstBuffer", 88}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-pNext-pNext", 34}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-pRegions-00117", 37}, { {"The union of the source regions, and the union of the destination regions, specified by the elements of pRegions, must not overlap in memory", 140}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-pRegions-parameter", 41}, { {"pRegions must be a valid pointer to an array of regionCount valid VkBufferCopy2 structures", 90}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-regionCount-arraylength", 46}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-sType-sType", 34}, { {"sType must be VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-size-00115", 33}, { {"The size member of each element of pRegions must be less than or equal to the size of srcBuffer minus srcOffset", 111}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-size-00116", 33}, { {"The size member of each element of pRegions must be less than or equal to the size of dstBuffer minus dstOffset", 111}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-srcBuffer-00118", 38}, { {"srcBuffer must have been created with the VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag set", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-srcBuffer-00119", 38}, { {"If srcBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 110}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-srcBuffer-parameter", 42}, { {"srcBuffer must be a valid VkBuffer handle", 41}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferInfo2-srcOffset-00113", 38}, { {"The srcOffset member of each element of pRegions must be less than the size of srcBuffer", 88}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-bufferImageHeight-09107", 53}, { {"For each element of pRegions, bufferImageHeight must be a multiple of the texel block extent height of the VkFormat of dstImage", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-bufferRowLength-09106", 51}, { {"For each element of pRegions, bufferRowLength must be a multiple of the texel block extent width of the VkFormat of dstImage", 124}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-bufferRowLength-09108", 51}, { {"For each element of pRegions, bufferRowLength divided by the texel block extent width and then multiplied by the texel block size of dstImage must be less than or equal to 2^31-1", 178}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-commonparent", 42}, { {"Both of dstImage, and srcBuffer must have been created, allocated, or retrieved from the same VkDevice", 102}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-00177", 44}, { {"dstImage must have been created with the VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag set", 87}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-00207", 44}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", 334}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-00208", 44}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", 342}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-00209", 44}, { {"For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", 239}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-01997", 44}, { {"The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", 79}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07274", 44}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07275", 44}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07276", 44}, { {"For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", 122}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07966", 44}, { {"If dstImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07969", 44}, { {"dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07973", 44}, { {"dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", 64}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07975", 44}, { {"If dstImage does not have either a depth/stencil format or a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the texel block size", 172}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07976", 44}, { {"If dstImage has a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible Formats of Planes of Multi-Planar Formats", 275}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07978", 44}, { {"If dstImage has a depth/stencil format, the bufferOffset member of any element of pRegions must be a multiple of 4", 114}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07979", 44}, { {"If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", 132}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07980", 44}, { {"If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07981", 44}, { {"If dstImage has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", 153}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-07983", 44}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", 154}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImage-parameter", 48}, { {"dstImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-00180", 50}, { {"dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-01396", 50}, { {"dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", 123}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-parameter", 54}, { {"dstImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-09104", 47}, { {"For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of dstImage", 205}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-10051", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", 355}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-10052", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", 358}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-10053", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-10054", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-10055", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", 338}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-10056", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", 337}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-10057", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", 257}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageOffset-10058", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", 256}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageSubresource-07967", 52}, { {"The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", 153}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageSubresource-07968", 52}, { {"If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", 257}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-imageSubresource-09105", 52}, { {"For each element of pRegions, imageSubresource.aspectMask must specify aspects present in dstImage", 98}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-pNext-pNext", 41}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-pRegions-00171", 44}, { {"srcBuffer must be large enough to contain all buffer locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-pRegions-00173", 44}, { {"The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", 140}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-pRegions-04565", 44}, { {"The image region specified by each element of pRegions that does not contain VkCopyCommandTransformInfoQCOM in its pNext chain must be contained within the specified imageSubresource of dstImage", 194}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-pRegions-06223", 44}, { {"For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of dstImage", 270}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-pRegions-06224", 44}, { {"For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of dstImage", 272}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-pRegions-07931", 44}, { {"If VK_EXT_depth_range_unrestricted is not enabled, for each element of pRegions whose imageSubresource contains a depth aspect, the data in srcBuffer must be in the range [0,1]", 176}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-pRegions-parameter", 48}, { {"pRegions must be a valid pointer to an array of regionCount valid VkBufferImageCopy2 structures", 95}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-regionCount-arraylength", 53}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-sType-sType", 41}, { {"sType must be VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2", 59}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-srcBuffer-00174", 45}, { {"srcBuffer must have been created with the VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag set", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-srcBuffer-00176", 45}, { {"If srcBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 110}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2-srcBuffer-parameter", 49}, { {"srcBuffer must be a valid VkBuffer handle", 41}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04554", 47}, { {"If the image region specified by each element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, the rotated destination region must be contained within dstImage", 182}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04555", 47}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must have a 1x1x1 texel block extent", 137}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-06203", 47}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must be of type VK_IMAGE_TYPE_2D", 133}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-06204", 47}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must not have a multi-planar format", 136}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyCommandTransformInfoQCOM-sType-sType", 47}, { {"sType must be VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM", 64}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyCommandTransformInfoQCOM-transform-04560", 51}, { {"transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", 180}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyDescriptorSet-commonparent", 37}, { {"Both of dstSet, and srcSet must have been created, allocated, or retrieved from the same VkDevice", 97}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-dstArrayElement-00348", 46}, { {"The sum of dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by dstBinding, and all applicable consecutive bindings", 200}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-dstBinding-00347", 41}, { {"dstBinding must be a valid binding within dstSet", 48}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-dstBinding-02224", 41}, { {"If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, dstArrayElement must be an integer multiple of 4", 169}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-dstBinding-02632", 41}, { {"The type of dstBinding within dstSet must be equal to the type of srcBinding within srcSet", 90}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-dstBinding-02753", 41}, { {"If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_SAMPLER, then dstSet must not have been allocated with a layout that included immutable samplers for dstBinding", 210}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-dstSet-04612", 37}, { {"If VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the new active descriptor type must exist in the corresponding pMutableDescriptorTypeLists list for dstBinding if the new active descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT", 274}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-dstSet-04614", 37}, { {"If VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, and the new active descriptor type is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the pMutableDescriptorTypeLists for srcBinding and dstBinding must match exactly", 242}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-dstSet-parameter", 41}, { {"dstSet must be a valid VkDescriptorSet handle", 45}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-pNext-pNext", 36}, { {"pNext must be NULL", 18}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-sType-sType", 36}, { {"sType must be VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET", 51}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcArrayElement-00346", 46}, { {"The sum of srcArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by srcBinding, and all applicable consecutive bindings", 200}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcBinding-00345", 41}, { {"srcBinding must be a valid binding within srcSet", 48}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcBinding-02223", 41}, { {"If the descriptor type of the descriptor set binding specified by srcBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, srcArrayElement must be an integer multiple of 4", 169}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcBinding-02225", 41}, { {"If the descriptor type of the descriptor set binding specified by either srcBinding or dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, descriptorCount must be an integer multiple of 4", 190}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcSet-00349", 37}, { {"If srcSet is equal to dstSet, then the source and destination ranges of descriptors must not overlap, where the ranges may include array elements from consecutive bindings", 171}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcSet-01918", 37}, { {"If srcSet's layout was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must also have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", 234}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcSet-01920", 37}, { {"If the descriptor pool from which srcSet was allocated was created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must also have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", 284}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcSet-04613", 37}, { {"If VkDescriptorSetLayoutBinding for srcSet at srcBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT and the VkDescriptorSetLayoutBinding for dstSet at dstBinding is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the active descriptor type for the source descriptor must match the descriptor type of dstBinding", 289}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcSet-04885", 37}, { {"If srcSet's layout was created without either the VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT flag or the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must have been created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", 309}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcSet-04887", 37}, { {"If the descriptor pool from which srcSet was allocated was created without either the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag or the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must have been created without the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", 348}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyDescriptorSet-srcSet-parameter", 41}, { {"srcSet must be a valid VkDescriptorSet handle", 45}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkCopyImageInfo2-None-01549", 32}, { {"In a copy to or from a plane of a multi-planar image, the VkFormat of the image and plane must be compatible according to the description of compatible planes for the plane being copied", 185}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-apiVersion-07932", 38}, { {"If the VK_KHR_maintenance1 extension is not enabled, or VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and either srcImage or dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer and dstSubresource.baseArrayLayer must both be 0, and srcSubresource.layerCount and dstSubresource.layerCount must both be 1", 370}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-apiVersion-07933", 38}, { {"If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, srcImage and dstImage must have the same VkImageType", 173}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-apiVersion-08969", 38}, { {"If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, srcImage or dstImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, extent.depth must be 1", 228}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-aspect-06662", 34}, { {"If the aspect member of any element of pRegions includes any flag other than VK_IMAGE_ASPECT_STENCIL_BIT or srcImage was not created with separate stencil usage, srcImage must have been created with the VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag set", 249}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-aspect-06663", 34}, { {"If the aspect member of any element of pRegions includes any flag other than VK_IMAGE_ASPECT_STENCIL_BIT or dstImage was not created with separate stencil usage, dstImage must have been created with the VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag set", 249}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-aspect-06664", 34}, { {"If the aspect member of any element of pRegions includes VK_IMAGE_ASPECT_STENCIL_BIT, and srcImage was created with separate stencil usage, srcImage must have been created with the VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag set", 227}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-aspect-06665", 34}, { {"If the aspect member of any element of pRegions includes VK_IMAGE_ASPECT_STENCIL_BIT, and dstImage was created with separate stencil usage, srcImage must have been created with the VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag set", 227}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-aspectMask-00142", 38}, { {"For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-aspectMask-00143", 38}, { {"For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-commonparent", 34}, { {"Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", 101}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-00152", 36}, { {"If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.y must be 0", 97}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-01557", 36}, { {"If dstImage has a multi-planar format and the srcImage does not have a multi-planar image format, then for each element of pRegions, srcSubresource.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", 192}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-01786", 36}, { {"If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.z must be 0", 97}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-01788", 36}, { {"If dstImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffset.z must be 0", 97}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-01792", 36}, { {"If dstImage is of type VK_IMAGE_TYPE_2D, and srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, extent.depth must equal dstSubresource.layerCount", 167}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-01996", 36}, { {"The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", 79}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-04444", 36}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstSubresource.baseArrayLayer must be 0 and dstSubresource.layerCount must be 1", 155}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-07966", 36}, { {"If dstImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-07969", 36}, { {"dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-08714", 36}, { {"If dstImage has a multi-planar format, then for each element of pRegions, dstSubresource.aspectMask must be a single valid multi-planar aspect mask bit", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImage-parameter", 40}, { {"dstImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImageLayout-00133", 42}, { {"dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImageLayout-01395", 42}, { {"dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", 123}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstImageLayout-parameter", 46}, { {"dstImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstOffset-00150", 37}, { {"For each element of pRegions, dstOffset.x and (extent.width + dstOffset.x), where extent is adjusted for size-compatibility, must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", 244}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstOffset-00151", 37}, { {"For each element of pRegions, dstOffset.y and (extent.height + dstOffset.y), where extent is adjusted for size-compatibility, must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", 246}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstOffset-00153", 37}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstOffset.z and (extent.depth + dstOffset.z), where extent is adjusted for size-compatibility, must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", 290}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstOffset-01784", 37}, { {"The dstOffset and extent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", 205}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstSubresource-07967", 42}, { {"The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstSubresource-07968", 42}, { {"If dstSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", 251}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-dstSubresource-10215", 42}, { {"If dstSubresource.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, then srcSubresource.aspectMask must not contain both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", 169}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pNext-pNext", 33}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-00124", 36}, { {"The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", 140}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-07278", 36}, { {"For each element of pRegions, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-07279", 36}, { {"For each element of pRegions, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", 121}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-07280", 36}, { {"For each element of pRegions, srcOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-07281", 36}, { {"For each element of pRegions, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-07282", 36}, { {"For each element of pRegions, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", 121}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-07283", 36}, { {"For each element of pRegions, dstOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-12201", 36}, { {"For each element of pRegions where srcSubresource.aspectMask and dstSubresource.aspectMask each contain at least one of VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT, srcSubresource.aspectMask and dstSubresource.aspectMask must match", 244}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-pRegions-parameter", 40}, { {"pRegions must be a valid pointer to an array of regionCount valid VkImageCopy2 structures", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-regionCount-arraylength", 45}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-sType-sType", 33}, { {"sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2", 49}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-00136", 36}, { {"The sample count of srcImage and dstImage must match", 52}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-00146", 36}, { {"If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.y must be 0 and extent.height must be 1", 125}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01548", 36}, { {"If the VkFormat of each of srcImage and dstImage is not a multi-planar format, the VkFormat of each of srcImage and dstImage must be size-compatible", 148}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01551", 36}, { {"If neither srcImage nor dstImage has a multi-planar format and the maintenance8 feature is not enabled then for each element of pRegions, srcSubresource.aspectMask and dstSubresource.aspectMask must match", 204}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01556", 36}, { {"If srcImage has a multi-planar format and the dstImage does not have a multi-planar image format, then for each element of pRegions, dstSubresource.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", 192}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01728", 36}, { {"For each element of pRegions, if the sum of srcOffset.x and extent.width does not equal the width of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", 237}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01729", 36}, { {"For each element of pRegions, if the sum of srcOffset.y and extent.height does not equal the height of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", 241}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01730", 36}, { {"For each element of pRegions, if the sum of srcOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", 237}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01785", 36}, { {"If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.z must be 0 and extent.depth must be 1", 124}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01787", 36}, { {"If srcImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffset.z must be 0", 97}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01790", 36}, { {"If srcImage and dstImage are both of type VK_IMAGE_TYPE_2D, then for each element of pRegions, extent.depth must be 1", 117}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01791", 36}, { {"If srcImage is of type VK_IMAGE_TYPE_2D, and dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, extent.depth must equal srcSubresource.layerCount", 167}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-01995", 36}, { {"The format features of srcImage must contain VK_FORMAT_FEATURE_TRANSFER_SRC_BIT", 79}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-04443", 36}, { {"If srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer must be 0 and srcSubresource.layerCount must be 1", 155}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-07743", 36}, { {"If srcImage and dstImage have a different VkImageType, and the maintenance5 feature is not enabled, one must be VK_IMAGE_TYPE_3D and the other must be VK_IMAGE_TYPE_2D", 167}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-07966", 36}, { {"If srcImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-07969", 36}, { {"srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-08713", 36}, { {"If srcImage has a multi-planar format, then for each element of pRegions, srcSubresource.aspectMask must be a single valid multi-planar aspect mask bit", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-08793", 36}, { {"If srcImage and dstImage have the same VkImageType, for each element of pRegions, if neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount members of srcSubresource or dstSubresource must match", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-08794", 36}, { {"If srcImage and dstImage have the same VkImageType, and one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", 315}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-09247", 36}, { {"If the VkFormat of each of srcImage and dstImage is a compressed image format, the formats must have the same texel block extent", 128}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-09460", 36}, { {"If srcImage and dstImage are the same, and any elements of pRegions contains the srcSubresource and dstSubresource with matching mipLevel and overlapping array layers, then the srcImageLayout and dstImageLayout must be VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", 280}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-10907", 36}, { {"If either the VkFormat of each of srcImage and dstImage is not a compressed image format, and dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, extent.depth must be 1", 189}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-10908", 36}, { {"If either the VkFormat of each of srcImage and dstImage is not a compressed image format, and dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, extent.height must be 1, where extent is adjusted for size-compatibility", 239}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImage-parameter", 40}, { {"srcImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImageLayout-00128", 42}, { {"srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImageLayout-01917", 42}, { {"srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", 123}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcImageLayout-parameter", 46}, { {"srcImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcOffset-00144", 37}, { {"For each element of pRegions, srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", 194}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcOffset-00145", 37}, { {"For each element of pRegions, srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", 196}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcOffset-00147", 37}, { {"If srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", 240}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcOffset-01783", 37}, { {"The srcOffset and extent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", 205}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcSubresource-07967", 42}, { {"The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcSubresource-07968", 42}, { {"If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", 251}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcSubresource-10211", 42}, { {"If srcSubresource.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT and dstSubresource.aspectMask is VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT, then the VkFormat values of srcImage and dstImage must be compatible according to the list of compatible depth-stencil and color formats", 285}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcSubresource-10212", 42}, { {"If srcSubresource.aspectMask is VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT and dstSubresource.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, then the VkFormat values of srcImage and dstImage must be compatible according to the list of compatible depth-stencil and color formats", 285}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageInfo2-srcSubresource-10214", 42}, { {"If srcSubresource.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, then dstSubresource.aspectMask must not contain both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", 169}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-bufferImageHeight-09107", 53}, { {"For each element of pRegions, bufferImageHeight must be a multiple of the texel block extent height of the VkFormat of srcImage", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-bufferRowLength-09106", 51}, { {"For each element of pRegions, bufferRowLength must be a multiple of the texel block extent width of the VkFormat of srcImage", 124}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-bufferRowLength-09108", 51}, { {"For each element of pRegions, bufferRowLength divided by the texel block extent width and then multiplied by the texel block size of srcImage must be less than or equal to 2^31-1", 178}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-commonparent", 42}, { {"Both of dstBuffer, and srcImage must have been created, allocated, or retrieved from the same VkDevice", 102}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-dstBuffer-00191", 45}, { {"dstBuffer must have been created with the VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag set", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-dstBuffer-00192", 45}, { {"If dstBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 110}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-dstBuffer-parameter", 49}, { {"dstBuffer must be a valid VkBuffer handle", 41}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-00197", 47}, { {"For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of srcImage", 270}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-00198", 47}, { {"For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of srcImage", 272}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-09104", 47}, { {"For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of srcImage", 205}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-10051", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", 355}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-10052", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", 358}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-10053", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-10054", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-10055", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", 338}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-10056", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", 337}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-10057", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", 257}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageOffset-10058", 47}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", 256}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageSubresource-07967", 52}, { {"The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", 153}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageSubresource-07968", 52}, { {"If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", 257}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-imageSubresource-09105", 52}, { {"For each element of pRegions, imageSubresource.aspectMask must specify aspects present in srcImage", 98}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-pNext-pNext", 41}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-pRegions-00183", 44}, { {"dstBuffer must be large enough to contain all buffer locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-pRegions-00184", 44}, { {"The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", 140}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-pRegions-04566", 44}, { {"The image region specified by each element of pRegions that does not contain VkCopyCommandTransformInfoQCOM in its pNext chain must be contained within the specified imageSubresource of srcImage", 194}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-pRegions-parameter", 48}, { {"pRegions must be a valid pointer to an array of regionCount valid VkBufferImageCopy2 structures", 95}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-regionCount-arraylength", 53}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-sType-sType", 41}, { {"sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2", 59}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-00186", 44}, { {"srcImage must have been created with the VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag set", 87}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-00207", 44}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", 334}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-00208", 44}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", 342}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-00209", 44}, { {"For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", 239}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-01998", 44}, { {"The format features of srcImage must contain VK_FORMAT_FEATURE_TRANSFER_SRC_BIT", 79}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07274", 44}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07275", 44}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07276", 44}, { {"For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", 122}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07966", 44}, { {"If srcImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07969", 44}, { {"srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07973", 44}, { {"srcImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", 64}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07975", 44}, { {"If srcImage does not have either a depth/stencil format or a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the texel block size", 172}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07976", 44}, { {"If srcImage has a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible Formats of Planes of Multi-Planar Formats", 275}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07978", 44}, { {"If srcImage has a depth/stencil format, the bufferOffset member of any element of pRegions must be a multiple of 4", 114}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07979", 44}, { {"If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", 132}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07980", 44}, { {"If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07981", 44}, { {"If srcImage has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", 153}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-07983", 44}, { {"If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", 154}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImage-parameter", 48}, { {"srcImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-00189", 50}, { {"srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-01397", 50}, { {"srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", 123}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-parameter", 54}, { {"srcImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04557", 47}, { {"If the image region specified by each element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, the rotated source region must be contained within srcImage", 177}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04558", 47}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must have a 1x1x1 texel block extent", 137}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-06205", 47}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must be of type VK_IMAGE_TYPE_2D", 133}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-06206", 47}, { {"If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must not have a multi-planar format", 136}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-commonparent", 40}, { {"Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", 101}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-00207", 42}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of dstOffset.x and extent.width does not equal the width of the subresource specified by dstSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", 330}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-00208", 42}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of dstOffset.y and extent.height does not equal the height of the subresource specified by dstSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", 338}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-00209", 42}, { {"For each element of pRegions, if the sum of dstOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", 237}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07274", 42}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", 259}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07275", 42}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", 259}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07276", 42}, { {"For each element of pRegions, dstOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07966", 42}, { {"If dstImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07969", 42}, { {"dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07979", 42}, { {"If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.y must be 0 and extent.height must be 1", 125}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07980", 42}, { {"If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffset.z must be 0 and extent.depth must be 1", 144}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07981", 42}, { {"If dstImage has a multi-planar format, then for each element of pRegions, dstSubresource.aspectMask must be a single valid multi-planar aspect mask bit", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-07983", 42}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, dstSubresource.baseArrayLayer must be 0 and dstSubresource.layerCount must be 1", 150}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-09109", 42}, { {"If dstImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-09111", 42}, { {"If the stencil aspect of dstImage is accessed, and dstImage was not created with separate stencil usage, dstImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 193}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-09112", 42}, { {"If the stencil aspect of dstImage is accessed, and dstImage was created with separate stencil usage, dstImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 189}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-09113", 42}, { {"If non-stencil aspects of dstImage are accessed, dstImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 137}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-09115", 42}, { {"If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the extent member of each element of pRegions must equal the extents of dstImage identified by dstSubresource", 158}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImage-parameter", 46}, { {"dstImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImageLayout-09071", 48}, { {"dstImageLayout must specify the current layout of the image subresources of dstImage specified in pRegions", 106}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImageLayout-09073", 48}, { {"dstImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyProperties::pCopyDstLayouts", 116}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstImageLayout-parameter", 52}, { {"dstImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-09104", 43}, { {"For each element of pRegions, dstOffset.z and (extent.depth + dstOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", 194}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-09114", 43}, { {"If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the x, y, and z members of the dstOffset member of each element of pRegions must be 0", 134}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-10051", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and dstOffset.x does not equal the width of the subresource specified by dstSubresource, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", 349}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-10052", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and dstOffset.y does not equal the height of the subresource specified by dstSubresource, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", 352}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-10053", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of dstOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", 253}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-10054", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of dstOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", 253}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-10055", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of dstOffset.x and extent.height does not equal the width of the subresource specified by dstSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", 334}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-10056", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of dstOffset.y and extent.width does not equal the height of the subresource specified by dstSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", 333}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-10057", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of dstOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstOffset-10058", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of dstOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", 254}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstSubresource-07967", 48}, { {"The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstSubresource-07968", 48}, { {"If dstSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", 251}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstSubresource-07971", 48}, { {"For each element of pRegions, dstOffset.x and (extent.width + dstOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", 194}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstSubresource-07972", 48}, { {"For each element of pRegions, dstOffset.y and (extent.height + dstOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", 196}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-dstSubresource-09105", 48}, { {"For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-flags-parameter", 43}, { {"flags must be a valid combination of VkHostImageCopyFlagBits values", 67}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-pNext-pNext", 39}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-pRegions-parameter", 46}, { {"pRegions must be a valid pointer to an array of regionCount valid VkImageCopy2 structures", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-regionCount-arraylength", 51}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO", 56}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-00207", 42}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of srcOffset.x and extent.width does not equal the width of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", 330}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-00208", 42}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of srcOffset.y and extent.height does not equal the height of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", 338}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-00209", 42}, { {"For each element of pRegions, if the sum of srcOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", 237}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07274", 42}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", 259}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07275", 42}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", 259}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07276", 42}, { {"For each element of pRegions, srcOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07966", 42}, { {"If srcImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07969", 42}, { {"srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07979", 42}, { {"If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.y must be 0 and extent.height must be 1", 125}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07980", 42}, { {"If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffset.z must be 0 and extent.depth must be 1", 144}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07981", 42}, { {"If srcImage has a multi-planar format, then for each element of pRegions, srcSubresource.aspectMask must be a single valid multi-planar aspect mask bit", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-07983", 42}, { {"If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, srcSubresource.baseArrayLayer must be 0 and srcSubresource.layerCount must be 1", 150}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-09069", 42}, { {"srcImage and dstImage must have been created with identical image creation parameters", 85}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-09109", 42}, { {"If srcImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-09111", 42}, { {"If the stencil aspect of srcImage is accessed, and srcImage was not created with separate stencil usage, srcImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 193}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-09112", 42}, { {"If the stencil aspect of srcImage is accessed, and srcImage was created with separate stencil usage, srcImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 189}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-09113", 42}, { {"If non-stencil aspects of srcImage are accessed, srcImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 137}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-09115", 42}, { {"If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the extent member of each element of pRegions must equal the extents of srcImage identified by srcSubresource", 158}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImage-parameter", 46}, { {"srcImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImageLayout-09070", 48}, { {"srcImageLayout must specify the current layout of the image subresources of srcImage specified in pRegions", 106}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImageLayout-09072", 48}, { {"srcImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyProperties::pCopySrcLayouts", 116}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcImageLayout-parameter", 52}, { {"srcImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-09104", 43}, { {"For each element of pRegions, srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", 194}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-09114", 43}, { {"If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the x, y, and z members of the srcOffset member of each element of pRegions must be 0", 134}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-10051", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and srcOffset.x does not equal the width of the subresource specified by srcSubresource, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", 349}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-10052", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and srcOffset.y does not equal the height of the subresource specified by srcSubresource, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", 352}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-10053", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of srcOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", 253}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-10054", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of srcOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", 253}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-10055", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of srcOffset.x and extent.height does not equal the width of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", 334}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-10056", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of srcOffset.y and extent.width does not equal the height of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", 333}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-10057", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of srcOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcOffset-10058", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of srcOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", 254}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcSubresource-07967", 48}, { {"The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcSubresource-07968", 48}, { {"If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", 251}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcSubresource-07971", 48}, { {"For each element of pRegions, srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", 194}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcSubresource-07972", 48}, { {"For each element of pRegions, srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", 196}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToImageInfo-srcSubresource-09105", 48}, { {"For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-flags-09394", 40}, { {"If flags includes VK_HOST_IMAGE_COPY_MEMCPY_BIT, for each region in pRegions, memoryRowLength and memoryImageHeight must both be 0", 130}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-flags-parameter", 44}, { {"flags must be a valid combination of VkHostImageCopyFlagBits values", 67}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-09104", 46}, { {"For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of srcImage", 205}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-09114", 46}, { {"If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the x, y, and z members of the imageOffset member of each element of pRegions must be 0", 136}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-10051", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", 355}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-10052", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", 358}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-10053", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-10054", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-10055", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", 338}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-10056", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", 337}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-10057", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", 257}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageOffset-10058", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", 256}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageSubresource-07967", 51}, { {"The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", 153}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageSubresource-07968", 51}, { {"If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", 257}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageSubresource-07971", 51}, { {"For each element of pRegions, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of srcImage", 205}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageSubresource-07972", 51}, { {"For each element of pRegions, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of srcImage", 207}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-imageSubresource-09105", 51}, { {"For each element of pRegions, imageSubresource.aspectMask must specify aspects present in srcImage", 98}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-memoryImageHeight-09107", 52}, { {"For each element of pRegions, memoryImageHeight must be a multiple of the texel block extent height of the VkFormat of srcImage", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-memoryRowLength-09106", 50}, { {"For each element of pRegions, memoryRowLength must be a multiple of the texel block extent width of the VkFormat of srcImage", 124}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-memoryRowLength-09108", 50}, { {"For each element of pRegions, memoryRowLength divided by the texel block extent width and then multiplied by the texel block size of srcImage must be less than or equal to 2^31-1", 178}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-pNext-pNext", 40}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-pRegions-parameter", 47}, { {"pRegions must be a valid pointer to an array of regionCount valid VkImageToMemoryCopy structures", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-regionCount-arraylength", 52}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO", 57}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-00207", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", 334}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-00208", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", 342}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-00209", 43}, { {"For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", 239}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07274", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07275", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07276", 43}, { {"For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", 122}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07966", 43}, { {"If srcImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07969", 43}, { {"srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07973", 43}, { {"srcImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", 64}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07979", 43}, { {"If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", 132}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07980", 43}, { {"If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07981", 43}, { {"If srcImage has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", 153}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-07983", 43}, { {"If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", 154}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-09109", 43}, { {"If srcImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-09111", 43}, { {"If the stencil aspect of srcImage is accessed, and srcImage was not created with separate stencil usage, srcImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 193}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-09112", 43}, { {"If the stencil aspect of srcImage is accessed, and srcImage was created with separate stencil usage, srcImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 189}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-09113", 43}, { {"If non-stencil aspects of srcImage are accessed, srcImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 137}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-09115", 43}, { {"If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the imageExtent member of each element of pRegions must equal the extents of srcImage identified by imageSubresource", 165}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImage-parameter", 47}, { {"srcImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImageLayout-09064", 49}, { {"srcImageLayout must specify the current layout of the image subresources of srcImage specified in pRegions", 106}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImageLayout-09065", 49}, { {"srcImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyProperties::pCopySrcLayouts", 116}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyImageToMemoryInfo-srcImageLayout-parameter", 53}, { {"srcImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-dstAddress-10959", 52}, { {"The dstAddress must be 4 byte aligned", 37}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-dstAddress-10962", 52}, { {"The memory in range [dstAddress, dstAddress + size - 1] must be within the bounds of the memory allocation backing dstAddress", 125}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-dstAddress-12212", 52}, { {"The range of memory defined by dstAddress and size must be a device address range allocated to the application from a buffer created with the VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag set", 189}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-dstAddress-parameter", 56}, { {"dstAddress must be a valid VkDeviceAddress value", 48}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-size-10960", 46}, { {"The size must be 4 byte aligned", 31}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-srcAddress-10958", 52}, { {"The srcAddress must be 4 byte aligned", 37}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-srcAddress-10961", 52}, { {"The memory in range [srcAddress, srcAddress + size - 1] must be within the bounds of the memory allocation backing srcAddress", 125}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-srcAddress-12211", 52}, { {"The range of memory defined by srcAddress and size must be a device address range allocated to the application from a buffer created with the VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag set", 189}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectCommandKHR-srcAddress-parameter", 56}, { {"srcAddress must be a valid VkDeviceAddress value", 48}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-copyAddressRange-10942", 55}, { {"copyAddressRange.address must be 4 byte aligned", 47}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-copyAddressRange-10943", 55}, { {"copyAddressRange.stride must be a multiple of 4 and must be greater than or equal to sizeof(VkCopyMemoryIndirectCommandKHR)", 123}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-copyAddressRange-10945", 55}, { {"Any of the source or destination memory regions specified in copyAddressRange must not overlap with any of the specified destination memory regions", 147}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-copyAddressRange-12210", 55}, { {"copyAddressRange must be a device address range allocated to the application from a buffer created with the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT usage flag set", 158}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-copyCount-10944", 48}, { {"copyCount must be less than or equal to copyAddressRange.size / copyAddressRange.stride", 87}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-dstCopyFlags-10939", 51}, { {"If dstCopyFlags contains VK_ADDRESS_COPY_SPARSE_BIT_KHR, the destination memory regions accessed must be bound to memory", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-dstCopyFlags-10941", 51}, { {"dstCopyFlags must not contain VK_ADDRESS_COPY_PROTECTED_BIT_KHR", 63}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-dstCopyFlags-parameter", 55}, { {"dstCopyFlags must be a valid combination of VkAddressCopyFlagBitsKHR values", 75}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-dstCopyFlags-requiredbitmask", 61}, { {"dstCopyFlags must not be 0", 26}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-pNext-pNext", 44}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_INDIRECT_INFO_KHR", 61}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-srcCopyFlags-10938", 51}, { {"If srcCopyFlags contains VK_ADDRESS_COPY_SPARSE_BIT_KHR, the source memory regions accessed must be bound to memory", 115}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-srcCopyFlags-10940", 51}, { {"srcCopyFlags must not contain VK_ADDRESS_COPY_PROTECTED_BIT_KHR", 63}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-srcCopyFlags-parameter", 55}, { {"srcCopyFlags must be a valid combination of VkAddressCopyFlagBitsKHR values", 75}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryIndirectInfoKHR-srcCopyFlags-requiredbitmask", 61}, { {"srcCopyFlags must not be 0", 26}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-dst-03746", 57}, { {"dst must have been created with a size greater than or equal to that used to serialize the data in src", 102}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-dst-parameter", 61}, { {"dst must be a valid VkAccelerationStructureKHR handle", 53}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-mode-03413", 58}, { {"mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR", 64}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-mode-parameter", 62}, { {"mode must be a valid VkCopyAccelerationStructureModeKHR value", 61}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-pInfo-03414", 59}, { {"The data in src must have a format compatible with the destination physical device as returned by vkGetDeviceAccelerationStructureCompatibilityKHR", 146}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-pNext-pNext", 59}, { {"pNext must be NULL", 18}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-sType-sType", 59}, { {"sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR", 78}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-src-04960", 57}, { {"The source memory pointed to by src must contain data previously serialized using vkCmdCopyAccelerationStructureToMemoryKHR, potentially modified to relocate acceleration structure references as described in that command", 220}, { "chapters/accelstructures.html", 29} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-bufferImageHeight-10965", 66}, { {"bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", 89}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-bufferRowLength-10964", 64}, { {"bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", 86}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-dstImage-12282", 57}, { {"If dstImage does not have either a depth/stencil format or a multi-planar format, srcAddress must be a multiple of the texel block size", 135}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-dstImage-12283", 57}, { {"If dstImage has a multi-planar format, srcAddress must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible Formats of Planes of Multi-Planar Formats", 238}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-dstImage-12285", 57}, { {"If dstImage is of type VK_IMAGE_TYPE_1D, imageOffset.y must be 0 and imageExtent.height must be 1", 97}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-dstImage-12286", 57}, { {"If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, imageOffset.z must be 0 and imageExtent.depth must be 1", 116}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-imageExtent-10967", 60}, { {"imageExtent must specify a valid region in the destination image and can be 0", 77}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-imageOffset-10966", 60}, { {"imageOffset must specify a valid offset in the destination image", 64}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-imageOffset-10969", 60}, { {"The imageOffset and imageExtent members of each region must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", 199}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-imageOffset-10970", 60}, { {"For each destination region, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified subresource", 187}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-imageOffset-10971", 60}, { {"For each destination region, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified subresource", 189}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-imageSubresource-12284", 65}, { {"The members of imageSubresource must be identical to the members of the VkImageSubresourceLayers structure specified in the corresponding index of the pCopyMemoryToImageIndirectInfo->pImageSubresources array of vkCmdCopyMemoryToImageIndirectKHR during command recording", 269}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-imageSubresource-parameter", 69}, { {"imageSubresource must be a valid VkImageSubresourceLayers structure", 67}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-srcAddress-10963", 59}, { {"The srcAddress must be 4 byte aligned", 37}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-srcAddress-10968", 59}, { {"The memory region starting at srcAddress and described by bufferRowLength and bufferImageHeight must not exceed the bounds of the memory allocation backing memory at srcAddress", 176}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-srcAddress-12214", 59}, { {"srcAddress must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag set", 143}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectCommandKHR-srcAddress-parameter", 63}, { {"srcAddress must be a valid VkDeviceAddress value", 48}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-aspectMask-07662", 56}, { {"The aspectMask member for every subresource in pImageSubresources must only have a single bit set", 97}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-aspectMask-12287", 56}, { {"The aspectMask member for every subresource in pImageSubresources must specify an aspect present in dstImage", 108}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-commandBuffer-07674", 59}, { {"If the queue family used to create the VkCommandPool which commandBuffer was allocated from does not support VK_QUEUE_GRAPHICS_BIT, for each region, the aspectMask member of pImageSubresources must not be VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-copyAddressRange-10952", 62}, { {"copyAddressRange.address must be 4 byte aligned", 47}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-copyAddressRange-10953", 62}, { {"copyAddressRange.stride must be a multiple of 4 and must be greater than or equal to sizeof(VkCopyMemoryToImageIndirectCommandKHR)", 130}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-copyAddressRange-10975", 62}, { {"Any of the source or destination memory regions specified in copyAddressRange must not overlap with any of the specified destination memory regions at the time this command is executed on device", 194}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-copyAddressRange-12213", 62}, { {"copyAddressRange must be a device address range allocated to the application from a buffer created with the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT usage flag set", 158}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-copyCount-10951", 55}, { {"copyCount must be less than or equal to copyAddressRange.size / copyAddressRange.stride", 87}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-copyCount-arraylength", 61}, { {"copyCount must be greater than 0", 32}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-07661", 54}, { {"dstImage must not be a protected image", 38}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-07664", 54}, { {"dstImage must have been created with the VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag set", 87}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-07665", 54}, { {"If dstImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-07673", 54}, { {"dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-07973", 54}, { {"dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", 64}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-10955", 54}, { {"The format features of dstImage must contain VK_FORMAT_FEATURE_2_COPY_IMAGE_INDIRECT_DST_BIT_KHR", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-10974", 54}, { {"The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", 79}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-12288", 54}, { {"If dstImage is not of type VK_IMAGE_TYPE_3D, and the specified layerCount of each region in pImageSubresources is not VK_REMAINING_ARRAY_LAYERS, the specified baseArrayLayer + layerCount of each region in pImageSubresources must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", 326}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-12289", 54}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, and the specified layerCount of each region in pImageSubresources is not VK_REMAINING_ARRAY_LAYERS, for each destination region, (imageSubresource.baseArrayLayer + imageSubresource.layerCount) must be less than or equal to the depth of the specified subresource", 302}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-12290", 54}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, and the specified layerCount of each region in pImageSubresources is not VK_REMAINING_ARRAY_LAYERS, for each destination region, if (imageSubresource.baseArrayLayer + imageSubresource.layerCount) does not equal the depth of the specified subresource, imageSubresource.layerCount must be a multiple of the texel block extent depth of the VkFormat of dstImage", 398}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-12291", 54}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, for each destination region, imageSubresource.baseArrayLayer must be a multiple of the texel block extent depth of the VkFormat of dstImage", 180}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-12292", 54}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, for each destination region, imageSubresource.baseArrayLayer must be less than or equal to the depth of the specified subresource", 170}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImage-parameter", 58}, { {"dstImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImageLayout-07667", 60}, { {"dstImageLayout must specify the layout of the image subresources of dstImage at the time this command is executed on a VkDevice", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImageLayout-07669", 60}, { {"dstImageLayout must be VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, or VK_IMAGE_LAYOUT_GENERAL", 123}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-dstImageLayout-parameter", 64}, { {"dstImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-mipLevel-07670", 54}, { {"The specified mipLevel of each region in pImageSubresources must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", 148}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-pImageSubresources-parameter", 68}, { {"pImageSubresources must be a valid pointer to an array of copyCount valid VkImageSubresourceLayers structures", 109}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-pNext-pNext", 51}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INDIRECT_INFO_KHR", 70}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-srcCopyFlags-10950", 58}, { {"If srcCopyFlags contains VK_ADDRESS_COPY_SPARSE_BIT_KHR, the source memory regions accessed must be bound to memory", 115}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-srcCopyFlags-parameter", 62}, { {"srcCopyFlags must be a valid combination of VkAddressCopyFlagBitsKHR values", 75}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageIndirectInfoKHR-srcCopyFlags-requiredbitmask", 68}, { {"srcCopyFlags must not be 0", 26}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-00207", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", 334}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-00208", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", 342}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-00209", 43}, { {"For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", 239}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07274", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07275", 43}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", 261}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07276", 43}, { {"For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", 122}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07966", 43}, { {"If dstImage is non-sparse then the image or each specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", 149}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07969", 43}, { {"dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07973", 43}, { {"dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", 64}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07979", 43}, { {"If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", 132}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07980", 43}, { {"If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", 151}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07981", 43}, { {"If dstImage has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", 153}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-07983", 43}, { {"If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", 154}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-09109", 43}, { {"If dstImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-09111", 43}, { {"If the stencil aspect of dstImage is accessed, and dstImage was not created with separate stencil usage, dstImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 193}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-09112", 43}, { {"If the stencil aspect of dstImage is accessed, and dstImage was created with separate stencil usage, dstImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 189}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-09113", 43}, { {"If non-stencil aspects of dstImage are accessed, dstImage must have been created with the VK_IMAGE_USAGE_HOST_TRANSFER_BIT usage flag set", 137}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-09115", 43}, { {"If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the imageExtent member of each element of pRegions must equal the extents of dstImage identified by imageSubresource", 165}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImage-parameter", 47}, { {"dstImage must be a valid VkImage handle", 39}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImageLayout-09059", 49}, { {"dstImageLayout must specify the current layout of the image subresources of dstImage specified in pRegions", 106}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImageLayout-09060", 49}, { {"dstImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyProperties::pCopyDstLayouts", 116}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-dstImageLayout-parameter", 53}, { {"dstImageLayout must be a valid VkImageLayout value", 50}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-flags-09393", 40}, { {"If flags includes VK_HOST_IMAGE_COPY_MEMCPY_BIT, for each region in pRegions, memoryRowLength and memoryImageHeight must both be 0", 130}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-flags-parameter", 44}, { {"flags must be a valid combination of VkHostImageCopyFlagBits values", 67}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-09104", 46}, { {"For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of dstImage", 205}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-09114", 46}, { {"If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the x, y, and z members of the imageOffset member of each element of pRegions must be 0", 136}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-10051", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", 355}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-10052", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", 358}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-10053", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-10054", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", 255}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-10055", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", 338}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-10056", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", 337}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-10057", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", 257}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageOffset-10058", 46}, { {"For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", 256}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageSubresource-07967", 51}, { {"The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", 153}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageSubresource-07968", 51}, { {"If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", 257}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageSubresource-07971", 51}, { {"For each element of pRegions, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of dstImage", 205}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageSubresource-07972", 51}, { {"For each element of pRegions, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of dstImage", 207}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-imageSubresource-09105", 51}, { {"For each element of pRegions, imageSubresource.aspectMask must specify aspects present in dstImage", 98}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-memoryImageHeight-09107", 52}, { {"For each element of pRegions, memoryImageHeight must be a multiple of the texel block extent height of the VkFormat of dstImage", 127}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-memoryRowLength-09106", 50}, { {"For each element of pRegions, memoryRowLength must be a multiple of the texel block extent width of the VkFormat of dstImage", 124}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-memoryRowLength-09108", 50}, { {"For each element of pRegions, memoryRowLength divided by the texel block extent width and then multiplied by the texel block size of dstImage must be less than or equal to 2^31-1", 178}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-pNext-pNext", 40}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-pRegions-parameter", 47}, { {"pRegions must be a valid pointer to an array of regionCount valid VkMemoryToImageCopy structures", 96}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-regionCount-arraylength", 52}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToImageInfo-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO", 57}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyMemoryToMicromapInfoEXT-dst-07550", 44}, { {"dst must have been created with a size greater than or equal to that used to serialize the data in src", 102}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMemoryToMicromapInfoEXT-dst-parameter", 48}, { {"dst must be a valid VkMicromapEXT handle", 40}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMemoryToMicromapInfoEXT-mode-07548", 45}, { {"mode must be VK_COPY_MICROMAP_MODE_DESERIALIZE_EXT", 50}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMemoryToMicromapInfoEXT-mode-parameter", 49}, { {"mode must be a valid VkCopyMicromapModeEXT value", 48}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMemoryToMicromapInfoEXT-pNext-pNext", 46}, { {"pNext must be NULL", 18}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMemoryToMicromapInfoEXT-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT", 64}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMemoryToMicromapInfoEXT-src-07547", 44}, { {"The source memory pointed to by src must contain data previously serialized using vkCmdCopyMicromapToMemoryEXT", 110}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMemoryToMicromapInfoEXT-src-07549", 44}, { {"The data in src must have a format compatible with the destination physical device as returned by vkGetDeviceMicromapCompatibilityEXT", 133}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-buffer-07534", 39}, { {"The buffer used to create src must be bound to device memory", 60}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-buffer-07535", 39}, { {"The buffer used to create dst must be bound to device memory", 60}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-commonparent", 39}, { {"Both of dst, and src must have been created, allocated, or retrieved from the same VkDevice", 91}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-dst-parameter", 40}, { {"dst must be a valid VkMicromapEXT handle", 40}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-mode-07531", 37}, { {"mode must be VK_COPY_MICROMAP_MODE_COMPACT_EXT or VK_COPY_MICROMAP_MODE_CLONE_EXT", 81}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-mode-07533", 37}, { {"If mode is VK_COPY_MICROMAP_MODE_COMPACT_EXT, src must have been constructed with VK_BUILD_MICROMAP_ALLOW_COMPACTION_BIT_EXT in the build", 137}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-mode-parameter", 41}, { {"mode must be a valid VkCopyMicromapModeEXT value", 48}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-pNext-pNext", 38}, { {"pNext must be NULL", 18}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-sType-sType", 38}, { {"sType must be VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT", 54}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-src-07532", 36}, { {"The source acceleration structure src must have been constructed prior to the execution of this command", 103}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapInfoEXT-src-parameter", 40}, { {"src must be a valid VkMicromapEXT handle", 40}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapToMemoryInfoEXT-dst-07541", 44}, { {"The memory pointed to by dst must be at least as large as the serialization size of src, as reported by vkWriteMicromapsPropertiesEXT or vkCmdWriteMicromapsPropertiesEXT with a query type of VK_QUERY_TYPE_MICROMAP_SERIALIZATION_SIZE_EXT", 236}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapToMemoryInfoEXT-mode-07542", 45}, { {"mode must be VK_COPY_MICROMAP_MODE_SERIALIZE_EXT", 48}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapToMemoryInfoEXT-mode-parameter", 49}, { {"mode must be a valid VkCopyMicromapModeEXT value", 48}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapToMemoryInfoEXT-pNext-pNext", 46}, { {"pNext must be NULL", 18}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapToMemoryInfoEXT-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT", 64}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapToMemoryInfoEXT-src-07540", 44}, { {"The source micromap src must have been constructed prior to the execution of this command", 89}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyMicromapToMemoryInfoEXT-src-parameter", 48}, { {"src must be a valid VkMicromapEXT handle", 40}, { "chapters/VK_EXT_opacity_micromap/micromaps.html", 47} } },
        { {"VUID-VkCopyTensorInfoARM-commonparent", 37}, { {"Both of dstTensor, and srcTensor must have been created, allocated, or retrieved from the same VkDevice", 103}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-dimensionCount-09684", 45}, { {"srcTensor and dstTensor must have been created with equal values for VkTensorDescriptionARM::dimensionCount", 107}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-dstTensor-09692", 40}, { {"The format features of dstTensor must contain VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT", 82}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-dstTensor-09693", 40}, { {"dstTensor must have been created with the VK_TENSOR_USAGE_TRANSFER_DST_BIT_ARM usage flag set", 93}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-dstTensor-09695", 40}, { {"If dstTensor is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 110}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-dstTensor-parameter", 44}, { {"dstTensor must be a valid VkTensorARM handle", 44}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-pDimensions-09685", 42}, { {"For each of the elements of VkTensorDescriptionARM::pDimensions, srcTensor and dstTensor must be the same size", 110}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-pNext-pNext", 36}, { {"pNext must be NULL", 18}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-pRegions-09687", 39}, { {"Each element of pRegions must be a VkTensorCopyARM structure whose pSrcOffset is NULL or has all its elements equal to 0", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-pRegions-09688", 39}, { {"Each element of pRegions must be a VkTensorCopyARM structure whose pDstOffset is NULL or has all its elements equal to 0", 120}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-pRegions-09689", 39}, { {"Each element of pRegions must be a VkTensorCopyARM structure whose pExtent is NULL or equal to the VkTensorDescriptionARM::pDimensions array specified when srcTensor and dstTensor were created", 192}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-pRegions-09954", 39}, { {"Each element of pRegions must be a VkTensorCopyARM structure whose dimensionCount, if it is not equal to 0, is equal to the largest of the VkTensorDescriptionARM::dimensionCount of srcTensor or dstTensor", 203}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-pRegions-parameter", 43}, { {"pRegions must be a valid pointer to an array of regionCount valid VkTensorCopyARM structures", 92}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-regionCount-09686", 42}, { {"regionCount must be equal to 1", 30}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-regionCount-arraylength", 48}, { {"regionCount must be greater than 0", 34}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-sType-sType", 36}, { {"sType must be VK_STRUCTURE_TYPE_COPY_TENSOR_INFO_ARM", 52}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-srcTensor-09690", 40}, { {"The format features of srcTensor must contain VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT", 82}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-srcTensor-09691", 40}, { {"srcTensor must have been created with the VK_TENSOR_USAGE_TRANSFER_SRC_BIT_ARM usage flag set", 93}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-srcTensor-09694", 40}, { {"If srcTensor is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", 110}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCopyTensorInfoARM-srcTensor-parameter", 44}, { {"srcTensor must be a valid VkTensorARM handle", 44}, { "chapters/copies.html", 20} } },
        { {"VUID-VkCuFunctionCreateInfoNVX-module-parameter", 47}, { {"module must be a valid VkCuModuleNVX handle", 43}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuFunctionCreateInfoNVX-pName-parameter", 46}, { {"pName must be a null-terminated UTF-8 string", 44}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuFunctionCreateInfoNVX-pNext-pNext", 42}, { {"pNext must be NULL", 18}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuFunctionCreateInfoNVX-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX", 59}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuLaunchInfoNVX-function-parameter", 41}, { {"function must be a valid VkCuFunctionNVX handle", 47}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuLaunchInfoNVX-pExtras-parameter", 40}, { {"If extraCount is not 0, pExtras must be a valid pointer to an array of extraCount bytes", 87}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuLaunchInfoNVX-pNext-pNext", 34}, { {"pNext must be NULL", 18}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuLaunchInfoNVX-pParams-parameter", 40}, { {"If paramCount is not 0, pParams must be a valid pointer to an array of paramCount bytes", 87}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuLaunchInfoNVX-sType-sType", 34}, { {"sType must be VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX", 50}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuModuleCreateInfoNVX-pData-parameter", 44}, { {"If dataSize is not 0, pData must be a valid pointer to an array of dataSize bytes", 81}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuModuleCreateInfoNVX-pNext-pNext", 40}, { {"pNext must be NULL or a pointer to a valid instance of VkCuModuleTexturingModeCreateInfoNVX", 91}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuModuleCreateInfoNVX-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX", 57}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuModuleCreateInfoNVX-sType-unique", 41}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCuModuleTexturingModeCreateInfoNVX-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX", 72}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkCudaFunctionCreateInfoNV-module-parameter", 48}, { {"module must be a valid VkCudaModuleNV handle", 44}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCudaFunctionCreateInfoNV-pName-parameter", 47}, { {"pName must be a null-terminated UTF-8 string", 44}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCudaFunctionCreateInfoNV-pNext-pNext", 43}, { {"pNext must be NULL", 18}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCudaFunctionCreateInfoNV-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_CUDA_FUNCTION_CREATE_INFO_NV", 60}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCudaLaunchInfoNV-extraCount-09411", 40}, { {"extraCount must be 0", 20}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-function-parameter", 42}, { {"function must be a valid VkCudaFunctionNV handle", 48}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-gridDimX-09406", 38}, { {"gridDimX must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0]", 90}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-gridDimY-09407", 38}, { {"gridDimY must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1]", 90}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-gridDimZ-09408", 38}, { {"gridDimZ must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2]", 90}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-pExtras-09412", 37}, { {"pExtras must be NULL", 20}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-pNext-pNext", 35}, { {"pNext must be NULL", 18}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-pParams-09410", 37}, { {"pParams must be a pointer to a table of paramCount parameters, corresponding to the arguments of function", 105}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-paramCount-09409", 40}, { {"paramCount must be the total amount of parameters listed in the pParams table", 77}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaLaunchInfoNV-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_CUDA_LAUNCH_INFO_NV", 51}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkCudaModuleCreateInfoNV-dataSize-09413", 44}, { {"dataSize must be the total size in bytes of the PTX files or binary cache passed to pData", 89}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCudaModuleCreateInfoNV-dataSize-arraylength", 50}, { {"dataSize must be greater than 0", 31}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCudaModuleCreateInfoNV-pData-parameter", 45}, { {"pData must be a valid pointer to an array of dataSize bytes", 59}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCudaModuleCreateInfoNV-pNext-pNext", 41}, { {"pNext must be NULL", 18}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCudaModuleCreateInfoNV-sType-sType", 41}, { {"sType must be VK_STRUCTURE_TYPE_CUDA_MODULE_CREATE_INFO_NV", 58}, { "chapters/shaders.html", 21} } },
        { {"VUID-VkCustomResolveCreateInfoEXT-colorAttachmentCount-11507", 60}, { {"colorAttachmentCount must be less than or equal to maxColorAttachments", 70}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkCustomResolveCreateInfoEXT-depthAttachmentFormat-11508", 61}, { {"If depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a depth component", 104}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkCustomResolveCreateInfoEXT-depthAttachmentFormat-11509", 61}, { {"If depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", 163}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkCustomResolveCreateInfoEXT-depthAttachmentFormat-11513", 61}, { {"If depthAttachmentFormat is not VK_FORMAT_UNDEFINED and stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, depthAttachmentFormat must equal stencilAttachmentFormat", 164}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkCustomResolveCreateInfoEXT-pColorAttachmentFormats-11510", 63}, { {"If any element of pColorAttachmentFormats is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT , or VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV if the linearColorAttachment feature is enabled", 276}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkCustomResolveCreateInfoEXT-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_CUSTOM_RESOLVE_CREATE_INFO_EXT", 62}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkCustomResolveCreateInfoEXT-stencilAttachmentFormat-11511", 63}, { {"If stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a stencil aspect", 105}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkCustomResolveCreateInfoEXT-stencilAttachmentFormat-11512", 63}, { {"If stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", 165}, { "chapters/pipelines.html", 23} } },
        { {"VUID-VkD3D12FenceSubmitInfoKHR-pSignalSemaphoreValues-parameter", 63}, { {"If signalSemaphoreValuesCount is not 0, and pSignalSemaphoreValues is not NULL, pSignalSemaphoreValues must be a valid pointer to an array of signalSemaphoreValuesCount uint64_t values", 184}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkD3D12FenceSubmitInfoKHR-pWaitSemaphoreValues-parameter", 61}, { {"If waitSemaphoreValuesCount is not 0, and pWaitSemaphoreValues is not NULL, pWaitSemaphoreValues must be a valid pointer to an array of waitSemaphoreValuesCount uint64_t values", 176}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkD3D12FenceSubmitInfoKHR-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR", 59}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkD3D12FenceSubmitInfoKHR-signalSemaphoreValuesCount-00080", 63}, { {"signalSemaphoreValuesCount must be the same value as VkSubmitInfo::signalSemaphoreCount, where this structure is in the pNext chain of a VkSubmitInfo structure", 159}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkD3D12FenceSubmitInfoKHR-waitSemaphoreValuesCount-00079", 61}, { {"waitSemaphoreValuesCount must be the same value as VkSubmitInfo::waitSemaphoreCount, where this structure is in the pNext chain of a VkSubmitInfo structure", 155}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDataGraphPipelineBuiltinModelCreateInfoQCOM-pOperation-11842", 67}, { {"All members of pOperation must be identical to a VkQueueFamilyDataGraphPropertiesARM::operation retrieved from vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM with the physicalDevice that was used to create device and paired in the retrieved results with a VkQueueFamilyDataGraphPropertiesARM::engine identical to an element of VkDataGraphProcessingEngineCreateInfoARM::pProcessingEngines provided in the pNext chain", 421}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineBuiltinModelCreateInfoQCOM-pOperation-parameter", 71}, { {"pOperation must be a valid pointer to a valid VkPhysicalDeviceDataGraphOperationSupportARM structure", 100}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineBuiltinModelCreateInfoQCOM-sType-sType", 62}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_BUILTIN_MODEL_CREATE_INFO_QCOM", 82}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCompilerControlCreateInfoARM-pVendorOptions-parameter", 77}, { {"pVendorOptions must be a null-terminated UTF-8 string", 53}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCompilerControlCreateInfoARM-sType-sType", 64}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_COMPILER_CONTROL_CREATE_INFO_ARM", 84}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-id-09850", 44}, { {"If the pNext chain of this structure includes a VkTensorDescriptionARM structure, then its usage member must contain VK_TENSOR_USAGE_DATA_GRAPH_BIT_ARM", 151}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-pConstantData-parameter", 59}, { {"pConstantData must be a pointer value", 37}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-pNext-09775", 47}, { {"If the pNext chain of this structure includes one or more VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM structures then it must also include a VkTensorDescriptionARM structure", 192}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-pNext-09776", 47}, { {"If the pNext chain of this structure includes one or more VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM structures then, for each structure, VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM::dimension must be less than VkTensorDescriptionARM::dimensionCount", 288}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-pNext-09777", 47}, { {"If the pNext chain of this structure includes a VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM structure then, for each structure, VkTensorDescriptionARM::pDimensions[VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM::dimension] must be a multiple of VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM::groupSize", 353}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-pNext-09870", 47}, { {"If the pNext chain of this structure includes multiple VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM structures then no two structures may have their VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM::dimension member set to the same value", 269}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-pNext-09917", 47}, { {"If the pNext chain of this structure includes a VkTensorDescriptionARM structure, then its tiling member must be VK_TENSOR_TILING_LINEAR_ARM", 140}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-pNext-pNext", 47}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM or VkTensorDescriptionARM", 219}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-sType-sType", 47}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_ARM", 64}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantARM-sType-unique", 48}, { {"The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM", 172}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM-sType-sType", 79}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_TENSOR_SEMI_STRUCTURED_SPARSITY_INFO_ARM", 101}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-None-11840", 48}, { {"If a VkDataGraphPipelineIdentifierCreateInfoARM or VkDataGraphPipelineBuiltinModelCreateInfoQCOM structure is included in the pNext chain, then flags must contain VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT", 221}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-None-11841", 48}, { {"If a VkDataGraphPipelineIdentifierCreateInfoARM or VkDataGraphPipelineBuiltinModelCreateInfoQCOM structure is included in the pNext chain, then resourceInfoCount must be 0 and pResourceInfos must be NULL", 203}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-dataGraphDescriptorBuffer-09885", 69}, { {"If the dataGraphDescriptorBuffer feature is not enabled, flags must not contain VK_PIPELINE_CREATE_2_DESCRIPTOR_BUFFER_BIT_EXT", 126}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-dataGraphShaderModule-09886", 65}, { {"If the dataGraphShaderModule feature is not enabled, a VkDataGraphPipelineShaderModuleCreateInfoARM structure must not be included in the pNext chain", 149}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-dataGraphUpdateAfterBind-09768", 68}, { {"If the dataGraphUpdateAfterBind feature is not enabled, layout must not use any VkDescriptorSetLayout object created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set", 192}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-flags-09764", 49}, { {"flags may only contain VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT_EXT, VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT_EXT, VK_PIPELINE_CREATE_2_DISABLE_OPTIMIZATION_BIT, VK_PIPELINE_CREATE_2_DESCRIPTOR_BUFFER_BIT_EXT, VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_KHR or VK_PIPELINE_CREATE_2_EARLY_RETURN_ON_FAILURE_BIT_KHR", 338}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-flags-09773", 49}, { {"flags must not include both VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT_EXT and VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT_EXT", 131}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-flags-parameter", 53}, { {"flags must be a valid combination of VkPipelineCreateFlagBits2KHR values", 72}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-layout-09767", 50}, { {"layout must have been created with pushConstantRangeCount equal to 0 and pPushConstantRanges equal to NULL", 106}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-layout-09769", 50}, { {"If a VkDataGraphPipelineShaderModuleCreateInfoARM structure is included in the pNext chain and a resource variable is declared in the shader module, the corresponding descriptor binding used to create layout must have a descriptorType that corresponds to the type of the resource variable", 288}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-layout-09934", 50}, { {"If a VkDataGraphPipelineShaderModuleCreateInfoARM structure is included in the pNext chain and an array resource variable is declared in the shader module, the corresponding descriptor binding used to create layout must have a descriptorCount that is greater than or equal to the length of the array", 299}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-layout-parameter", 54}, { {"layout must be a valid VkPipelineLayout handle", 46}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09763", 49}, { {"One and only one of the following structures must be included in the pNext chain: VkDataGraphPipelineShaderModuleCreateInfoARM VkDataGraphPipelineIdentifierCreateInfoARM VkDataGraphPipelineBuiltinModelCreateInfoQCOM", 215}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09804", 49}, { {"If the pNext chain includes an VkPipelineCreationFeedbackCreateInfo structure, then its pipelineStageCreationFeedbackCount must be 0", 132}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09948", 49}, { {"If a VkDataGraphProcessingEngineCreateInfoARM structure is included in the pNext chain, each member of pProcessingEngines must be identical to an VkQueueFamilyDataGraphPropertiesARM::engine retrieved from vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM with the physicalDevice that was used to create device", 312}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09949", 49}, { {"If a VkDataGraphProcessingEngineCreateInfoARM structure is not included in the pNext chain, VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_DEFAULT_ARM must be set in an VkQueueFamilyDataGraphPropertiesARM::engine retrieved from vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM with the physicalDevice that was used to create device", 341}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-pNext", 49}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDataGraphPipelineBuiltinModelCreateInfoQCOM, VkDataGraphPipelineCompilerControlCreateInfoARM, VkDataGraphPipelineIdentifierCreateInfoARM, VkDataGraphPipelineShaderModuleCreateInfoARM, VkDataGraphProcessingEngineCreateInfoARM, VkPipelineCreationFeedbackCreateInfo, or VkShaderModuleCreateInfo", 424}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pResourceInfos-parameter", 62}, { {"pResourceInfos must be a valid pointer to an array of resourceInfoCount valid VkDataGraphPipelineResourceInfoARM structures", 123}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pSetLayouts-09770", 55}, { {"The descriptor set layouts in VkPipelineLayoutCreateInfo::pSetLayouts used to create layout must not include any VkDescriptorSetLayoutBinding whose descriptor type is VK_DESCRIPTOR_TYPE_MUTABLE_EXT", 197}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pipelineCreationCacheControl-09871", 72}, { {"If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_KHR or VK_PIPELINE_CREATE_2_EARLY_RETURN_ON_FAILURE_BIT_KHR", 201}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-pipelineProtectedAccess-09772", 67}, { {"If the pipelineProtectedAccess feature is not enabled, flags must not include VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT_EXT or VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT_EXT", 180}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-resourceInfoCount-arraylength", 67}, { {"resourceInfoCount must be greater than 0", 40}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CREATE_INFO_ARM", 67}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineCreateInfoARM-sType-unique", 50}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineDispatchInfoARM-flags-zerobitmask", 57}, { {"flags must be 0", 15}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineDispatchInfoARM-pNext-pNext", 51}, { {"pNext must be NULL", 18}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineDispatchInfoARM-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_DISPATCH_INFO_ARM", 69}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineIdentifierCreateInfoARM-identifierSize-arraylength", 74}, { {"identifierSize must be greater than 0", 37}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineIdentifierCreateInfoARM-pIdentifier-parameter", 69}, { {"pIdentifier must be a valid pointer to an array of identifierSize uint8_t values", 80}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineIdentifierCreateInfoARM-sType-sType", 59}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_IDENTIFIER_CREATE_INFO_ARM", 78}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineInfoARM-dataGraphPipeline-09803", 55}, { {"dataGraphPipeline must have been created with vkCreateDataGraphPipelinesARM", 75}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineInfoARM-dataGraphPipeline-parameter", 59}, { {"dataGraphPipeline must be a valid VkPipeline handle", 51}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineInfoARM-pNext-pNext", 43}, { {"pNext must be NULL", 18}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineInfoARM-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_INFO_ARM", 60}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelinePropertyQueryResultARM-pData-parameter", 62}, { {"If dataSize is not 0, and pData is not NULL, pData must be a valid pointer to an array of dataSize bytes", 104}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelinePropertyQueryResultARM-pNext-pNext", 58}, { {"pNext must be NULL", 18}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelinePropertyQueryResultARM-property-parameter", 65}, { {"property must be a valid VkDataGraphPipelinePropertyARM value", 61}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelinePropertyQueryResultARM-sType-sType", 58}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_PROPERTY_QUERY_RESULT_ARM", 77}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineResourceInfoARM-descriptorSet-09851", 59}, { {"If the pNext chain of this structure includes a VkTensorDescriptionARM structure, then its usage must contain VK_TENSOR_USAGE_DATA_GRAPH_BIT_ARM", 144}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineResourceInfoARM-pNext-pNext", 51}, { {"pNext must be NULL or a pointer to a valid instance of VkTensorDescriptionARM", 77}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineResourceInfoARM-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_RESOURCE_INFO_ARM", 69}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineResourceInfoARM-sType-unique", 52}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionBindPointRequirementARM-pNext-pNext", 66}, { {"pNext must be NULL", 18}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionBindPointRequirementARM-sType-sType", 66}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENT_ARM", 86}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionBindPointRequirementsInfoARM-pNext-pNext", 71}, { {"pNext must be NULL", 18}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionBindPointRequirementsInfoARM-sType-sType", 71}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENTS_INFO_ARM", 92}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionBindPointRequirementsInfoARM-session-parameter", 77}, { {"session must be a valid VkDataGraphPipelineSessionARM handle", 60}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionCreateInfoARM-dataGraphPipeline-09781", 68}, { {"dataGraphPipeline must have been obtained via a call to vkCreateDataGraphPipelinesARM", 85}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionCreateInfoARM-dataGraphPipeline-parameter", 72}, { {"dataGraphPipeline must be a valid VkPipeline handle", 51}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionCreateInfoARM-flags-parameter", 60}, { {"flags must be a valid combination of VkDataGraphPipelineSessionCreateFlagBitsARM values", 87}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionCreateInfoARM-pNext-pNext", 56}, { {"pNext must be NULL", 18}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionCreateInfoARM-protectedMemory-09782", 66}, { {"If the protectedMemory feature is not enabled, flags must not contain VK_DATA_GRAPH_PIPELINE_SESSION_CREATE_PROTECTED_BIT_ARM", 125}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionCreateInfoARM-sType-sType", 56}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_CREATE_INFO_ARM", 75}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-bindPoint-parameter", 76}, { {"bindPoint must be a valid VkDataGraphPipelineSessionBindPointARM value", 70}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-objectIndex-09855", 74}, { {"objectIndex must be less than the number of objects returned by vkGetDataGraphPipelineSessionBindPointRequirementsARM via VkDataGraphPipelineSessionBindPointRequirementARM::numObjects with VkDataGraphPipelineSessionMemoryRequirementsInfoARM::bindPoint equal to bindPoint", 270}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-pNext-pNext", 68}, { {"pNext must be NULL", 18}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-sType-sType", 68}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_MEMORY_REQUIREMENTS_INFO_ARM", 88}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-session-parameter", 74}, { {"session must be a valid VkDataGraphPipelineSessionARM handle", 60}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-dataGraphSpecializationConstants-09849", 88}, { {"If the dataGraphSpecializationConstants feature is not enabled then pSpecializationInfo must be NULL and module must not contain any OpSpec* instructions", 153}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-module-parameter", 66}, { {"If module is not VK_NULL_HANDLE, module must be a valid VkShaderModule handle", 77}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pConstants-parameter", 70}, { {"If constantCount is not 0, and pConstants is not NULL, pConstants must be a valid pointer to an array of constantCount valid VkDataGraphPipelineConstantARM structures", 166}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pName-09872", 61}, { {"pName must be the name of an OpGraphEntryPointARM in module", 59}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pName-parameter", 65}, { {"pName must be a null-terminated UTF-8 string", 44}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pNext-09873", 61}, { {"If the pNext chain includes a VkShaderModuleCreateInfo structure, then module must be VK_NULL_HANDLE", 100}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pNext-09874", 61}, { {"If the pNext chain does not include a VkShaderModuleCreateInfo structure, then module must be a valid VkShaderModule", 116}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pSpecializationInfo-parameter", 79}, { {"If pSpecializationInfo is not NULL, pSpecializationInfo must be a valid pointer to a valid VkSpecializationInfo structure", 121}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-sType-sType", 61}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SHADER_MODULE_CREATE_INFO_ARM", 81}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphProcessingEngineCreateInfoARM-dataGraph-09953", 61}, { {"The dataGraph feature must be enabled", 37}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphProcessingEngineCreateInfoARM-pProcessingEngines-09918", 70}, { {"pProcessingEngines must not contain identical VkPhysicalDeviceDataGraphProcessingEngineARM structures", 101}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphProcessingEngineCreateInfoARM-pProcessingEngines-09956", 70}, { {"For each element of pProcessingEngines, its type member must be a valid VkPhysicalDeviceDataGraphProcessingEngineTypeARM value", 126}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphProcessingEngineCreateInfoARM-pProcessingEngines-11843", 70}, { {"If any element of pProcessingEngines has a type of VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_NEURAL_QCOM or VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_COMPUTE_QCOM and isForeign set to VK_TRUE, processingEngineCount must equal 1", 249}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphProcessingEngineCreateInfoARM-pProcessingEngines-11844", 70}, { {"If any element of pProcessingEngines has a type of VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_NEURAL_QCOM or VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_COMPUTE_QCOM, the dataGraphModel feature must be enabled", 228}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphProcessingEngineCreateInfoARM-pProcessingEngines-parameter", 74}, { {"pProcessingEngines must be a valid pointer to an array of processingEngineCount VkPhysicalDeviceDataGraphProcessingEngineARM structures", 135}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphProcessingEngineCreateInfoARM-processingEngineCount-arraylength", 79}, { {"processingEngineCount must be greater than 0", 44}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDataGraphProcessingEngineCreateInfoARM-sType-sType", 57}, { {"sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PROCESSING_ENGINE_CREATE_INFO_ARM", 76}, { "chapters/VK_ARM_data_graph/graphs.html", 38} } },
        { {"VUID-VkDebugMarkerMarkerInfoEXT-pMarkerName-parameter", 53}, { {"pMarkerName must be a null-terminated UTF-8 string", 50}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerMarkerInfoEXT-pNext-pNext", 43}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerMarkerInfoEXT-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT", 60}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01491", 48}, { {"object must not be VK_NULL_HANDLE", 33}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01492", 48}, { {"object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship", 141}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-01490", 52}, { {"objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", 62}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-parameter", 56}, { {"objectType must be a valid VkDebugReportObjectTypeEXT value", 59}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectNameInfoEXT-pNext-pNext", 47}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectNameInfoEXT-pObjectName-parameter", 57}, { {"pObjectName must be a null-terminated UTF-8 string", 50}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectNameInfoEXT-sType-sType", 47}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT", 65}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01494", 47}, { {"object must not be VK_NULL_HANDLE", 33}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01495", 47}, { {"object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship", 141}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-01493", 51}, { {"objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", 62}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-parameter", 55}, { {"objectType must be a valid VkDebugReportObjectTypeEXT value", 59}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectTagInfoEXT-pNext-pNext", 46}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectTagInfoEXT-pTag-parameter", 49}, { {"pTag must be a valid pointer to an array of tagSize bytes", 57}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectTagInfoEXT-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT", 64}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugMarkerObjectTagInfoEXT-tagSize-arraylength", 54}, { {"tagSize must be greater than 0", 30}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugReportCallbackCreateInfoEXT-flags-parameter", 55}, { {"flags must be a valid combination of VkDebugReportFlagBitsEXT values", 68}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugReportCallbackCreateInfoEXT-pfnCallback-parameter", 61}, { {"pfnCallback must be a valid PFN_vkDebugReportCallbackEXT value", 62}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugReportCallbackCreateInfoEXT-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT", 69}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsLabelEXT-pLabelName-parameter", 46}, { {"pLabelName must be a null-terminated UTF-8 string", 49}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsLabelEXT-pNext-pNext", 37}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsLabelEXT-sType-sType", 37}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT", 53}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-flags-zerobitmask", 59}, { {"flags must be 0", 15}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pCmdBufLabels-parameter", 65}, { {"If cmdBufLabelCount is not 0, pCmdBufLabels must be a valid pointer to an array of cmdBufLabelCount valid VkDebugUtilsLabelEXT structures", 137}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessage-parameter", 60}, { {"If pMessage is not NULL, pMessage must be a null-terminated UTF-8 string", 72}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessageIdName-parameter", 66}, { {"If pMessageIdName is not NULL, pMessageIdName must be a null-terminated UTF-8 string", 84}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pNext-pNext", 53}, { {"pNext must be NULL or a pointer to a valid instance of VkDeviceAddressBindingCallbackDataEXT", 92}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pObjects-parameter", 60}, { {"If objectCount is not 0, pObjects must be a valid pointer to an array of objectCount valid VkDebugUtilsObjectNameInfoEXT structures", 131}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pQueueLabels-parameter", 64}, { {"If queueLabelCount is not 0, pQueueLabels must be a valid pointer to an array of queueLabelCount valid VkDebugUtilsLabelEXT structures", 134}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT", 71}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-unique", 54}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCreateInfoEXT-flags-zerobitmask", 57}, { {"flags must be 0", 15}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-parameter", 65}, { {"messageSeverity must be a valid combination of VkDebugUtilsMessageSeverityFlagBitsEXT values", 92}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-requiredbitmask", 71}, { {"messageSeverity must not be 0", 29}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-parameter", 61}, { {"messageType must be a valid combination of VkDebugUtilsMessageTypeFlagBitsEXT values", 84}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-requiredbitmask", 67}, { {"messageType must not be 0", 25}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-parameter", 65}, { {"pfnUserCallback must be a valid PFN_vkDebugUtilsMessengerCallbackEXT value", 74}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsMessengerCreateInfoEXT-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT", 69}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02589", 51}, { {"If objectType is VK_OBJECT_TYPE_UNKNOWN, objectHandle must not be VK_NULL_HANDLE", 80}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02590", 51}, { {"If objectType is not VK_OBJECT_TYPE_UNKNOWN, objectHandle must be VK_NULL_HANDLE or a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table", 212}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-parameter", 55}, { {"objectType must be a valid VkObjectType value", 45}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectNameInfoEXT-pObjectName-parameter", 56}, { {"If pObjectName is not NULL, pObjectName must be a null-terminated UTF-8 string", 78}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectNameInfoEXT-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT", 64}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectTagInfoEXT-objectHandle-01910", 52}, { {"objectHandle must be a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table", 149}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-01908", 50}, { {"objectType must not be VK_OBJECT_TYPE_UNKNOWN", 45}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-parameter", 54}, { {"objectType must be a valid VkObjectType value", 45}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectTagInfoEXT-pNext-pNext", 45}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectTagInfoEXT-pTag-parameter", 48}, { {"pTag must be a valid pointer to an array of tagSize bytes", 57}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectTagInfoEXT-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT", 63}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDebugUtilsObjectTagInfoEXT-tagSize-arraylength", 53}, { {"tagSize must be greater than 0", 30}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDecompressMemoryInfoEXT-decompressionMethod-07690", 56}, { {"The decompressionMethod must have a single bit set", 50}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryInfoEXT-decompressionMethod-11762", 56}, { {"If decompressionMethod is VK_MEMORY_DECOMPRESSION_METHOD_GDEFLATE_1_0_BIT_EXT, then for each element of pRegions, decompressedSize must be less than or equal to 65536 bytes", 172}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryInfoEXT-decompressionMethod-11763", 56}, { {"decompressionMethod must be a valid bit specified in VkPhysicalDeviceMemoryDecompressionPropertiesEXT::decompressionMethods", 123}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryInfoEXT-decompressionMethod-parameter", 60}, { {"decompressionMethod must be a valid combination of VkMemoryDecompressionMethodFlagBitsEXT values", 96}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryInfoEXT-decompressionMethod-requiredbitmask", 66}, { {"decompressionMethod must not be 0", 33}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryInfoEXT-pNext-pNext", 42}, { {"pNext must be NULL", 18}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryInfoEXT-pRegions-parameter", 49}, { {"pRegions must be a valid pointer to an array of regionCount VkDecompressMemoryRegionEXT structures", 98}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryInfoEXT-regionCount-arraylength", 54}, { {"regionCount must be greater than 0", 34}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryInfoEXT-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_DECOMPRESS_MEMORY_INFO_EXT", 58}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-compressedSize-11795", 53}, { {"compressedSize must not be zero", 31}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-decompressedSize-07689", 55}, { {"decompressedSize must be large enough to hold the decompressed data based on the decompressionMethod", 100}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-decompressedSize-11796", 55}, { {"decompressedSize must not be zero", 33}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-dstAddress-07687", 49}, { {"dstAddress must be 4 byte aligned", 33}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-dstAddress-07688", 49}, { {"The memory range defined by dstAddress and decompressedSize must be contained within the size of the buffer bound to dstAddress, minus the offset of dstAddress from the base address of that buffer", 196}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-dstAddress-11765", 49}, { {"dstAddress must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_2_MEMORY_DECOMPRESSION_BIT_EXT usage flag set", 157}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-dstAddress-parameter", 53}, { {"dstAddress must be a valid VkDeviceAddress value", 48}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-srcAddress-07685", 49}, { {"srcAddress must be 4 byte aligned", 33}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-srcAddress-07686", 49}, { {"The memory range defined by srcAddress and compressedSize must be contained within the size of the buffer bound to srcAddress, minus the offset of srcAddress from the base address of that buffer", 194}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-srcAddress-07691", 49}, { {"The memory range defined by srcAddress and compressedSize must not overlap the memory range defined by dstAddress and decompressedSize", 134}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-srcAddress-11764", 49}, { {"srcAddress must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_2_MEMORY_DECOMPRESSION_BIT_EXT usage flag set", 157}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionEXT-srcAddress-parameter", 53}, { {"srcAddress must be a valid VkDeviceAddress value", 48}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-compressedSize-11795", 52}, { {"compressedSize must not be zero", 31}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-decompressedSize-07689", 54}, { {"decompressedSize must be large enough to hold the decompressed data based on the decompressionMethod", 100}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-decompressedSize-11796", 54}, { {"decompressedSize must not be zero", 33}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-07690", 57}, { {"The decompressionMethod must have a single bit set", 50}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-09395", 57}, { {"If decompressionMethod is VK_MEMORY_DECOMPRESSION_METHOD_GDEFLATE_1_0_BIT_EXT, then decompressedSize must be less than or equal to 65536 bytes", 142}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-dstAddress-07687", 48}, { {"dstAddress must be 4 byte aligned", 33}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-dstAddress-07688", 48}, { {"The memory range defined by dstAddress and decompressedSize must be contained within the size of the buffer bound to dstAddress, minus the offset of dstAddress from the base address of that buffer", 196}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-srcAddress-07685", 48}, { {"srcAddress must be 4 byte aligned", 33}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-srcAddress-07686", 48}, { {"The memory range defined by srcAddress and compressedSize must be contained within the size of the buffer bound to srcAddress, minus the offset of srcAddress from the base address of that buffer", 194}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDecompressMemoryRegionNV-srcAddress-07691", 48}, { {"The memory range defined by srcAddress and compressedSize must not overlap the memory range defined by dstAddress and decompressedSize", 134}, { "chapters/memory_decompression.html", 34} } },
        { {"VUID-VkDedicatedAllocationBufferCreateInfoNV-sType-sType", 56}, { {"sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV", 74}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDedicatedAllocationImageCreateInfoNV-dedicatedAllocation-00994", 69}, { {"If dedicatedAllocation is VK_TRUE, VkImageCreateInfo::flags must not include VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", 188}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDedicatedAllocationImageCreateInfoNV-sType-sType", 55}, { {"sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV", 73}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00651", 59}, { {"If buffer is not VK_NULL_HANDLE, the buffer must have been created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE", 149}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00653", 59}, { {"If buffer is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the buffer", 125}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00655", 59}, { {"If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory", 239}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-parameter", 63}, { {"If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", 71}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-commonparent", 59}, { {"Both of buffer, and image that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 145}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00649", 58}, { {"At least one of image and buffer must be VK_NULL_HANDLE", 55}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00650", 58}, { {"If image is not VK_NULL_HANDLE, the image must have been created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE", 146}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00652", 58}, { {"If image is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the image", 123}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00654", 58}, { {"If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory", 235}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-parameter", 62}, { {"If image is not VK_NULL_HANDLE, image must be a valid VkImage handle", 68}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-sType-sType", 58}, { {"sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV", 76}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDependencyInfo-dependencyFlags-parameter", 47}, { {"dependencyFlags must be a valid combination of VkDependencyFlagBits values", 74}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", 53}, { {"If bufferMemoryBarrierCount is not 0, pBufferMemoryBarriers must be a valid pointer to an array of bufferMemoryBarrierCount valid VkBufferMemoryBarrier2 structures", 163}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", 52}, { {"If imageMemoryBarrierCount is not 0, pImageMemoryBarriers must be a valid pointer to an array of imageMemoryBarrierCount valid VkImageMemoryBarrier2 structures", 159}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-pMemoryBarriers-10605", 43}, { {"For each element of pMemoryBarriers, the sType value of each structure in the pNext chain must be unique", 104}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-pMemoryBarriers-10606", 43}, { {"For each element of pMemoryBarriers, pNext must be either NULL or a pointer to a valid instance of VkMemoryBarrierAccessFlags3KHR", 129}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-pMemoryBarriers-parameter", 47}, { {"If memoryBarrierCount is not 0, pMemoryBarriers must be a valid pointer to an array of memoryBarrierCount valid VkMemoryBarrier2 structures", 139}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-pNext-09754", 33}, { {"If a VkTensorDependencyInfoARM structure is included in the pNext chain, a VkTensorMemoryBarrierARM structure must not be included in the pNext chain", 149}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-pNext-pNext", 33}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkTensorDependencyInfoARM or VkTensorMemoryBarrierARM", 184}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-sType-sType", 33}, { {"sType must be VK_STRUCTURE_TYPE_DEPENDENCY_INFO", 47}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDependencyInfo-sType-unique", 34}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDepthBiasInfoEXT-depthBiasClamp-08950", 44}, { {"If the depthBiasClamp feature is not enabled, depthBiasClamp must be 0.0", 72}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthBiasInfoEXT-pNext-pNext", 35}, { {"pNext must be NULL or a pointer to a valid instance of VkDepthBiasRepresentationInfoEXT", 87}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthBiasInfoEXT-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT", 51}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthBiasInfoEXT-sType-unique", 36}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthBiasRepresentationInfoEXT-depthBiasExact-08949", 58}, { {"If the depthBiasExact feature is not enabled, depthBiasExact must be VK_FALSE", 77}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthBiasRepresentationInfoEXT-depthBiasRepresentation-parameter", 71}, { {"depthBiasRepresentation must be a valid VkDepthBiasRepresentationEXT value", 74}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthBiasRepresentationInfoEXT-floatRepresentation-08948", 63}, { {"If the floatRepresentation feature is not enabled, depthBiasRepresentation must not be VK_DEPTH_BIAS_REPRESENTATION_FLOAT_EXT", 125}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthBiasRepresentationInfoEXT-leastRepresentableValueForceUnormRepresentation-08947", 91}, { {"If the leastRepresentableValueForceUnormRepresentation feature is not enabled, depthBiasRepresentation must not be VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORCE_UNORM_EXT", 185}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthBiasRepresentationInfoEXT-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT", 66}, { "chapters/primsrast.html", 23} } },
        { {"VUID-VkDepthClampRangeEXT-pDepthClampRange-00999", 48}, { {"minDepthClamp must be less than or equal to maxDepthClamp", 57}, { "chapters/fragops.html", 21} } },
        { {"VUID-VkDepthClampRangeEXT-pDepthClampRange-09648", 48}, { {"If the VK_EXT_depth_range_unrestricted extension is not enabled, minDepthClamp must be greater than or equal to 0.0", 115}, { "chapters/fragops.html", 21} } },
        { {"VUID-VkDepthClampRangeEXT-pDepthClampRange-09649", 48}, { {"If the VK_EXT_depth_range_unrestricted extension is not enabled, maxDepthClamp must be less than or equal to 1.0", 112}, { "chapters/fragops.html", 21} } },
        { {"VUID-VkDescriptorAddressInfoEXT-None-09508", 42}, { {"If address is not zero, and the descriptor is of type VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, then format must not be VK_FORMAT_UNDEFINED", 181}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-None-12271", 42}, { {"If Vulkan 1.3 is not supported and the ycbcr2plane444Formats feature is not enabled, format must not be VK_FORMAT_G8_B8R8_2PLANE_444_UNORM, VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16, VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16, or VK_FORMAT_G16_B16R16_2PLANE_444_UNORM", 286}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-address-08043", 45}, { {"If the nullDescriptor feature is not enabled, address must not be zero", 70}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-address-parameter", 49}, { {"If address is not 0, address must be a valid VkDeviceAddress value", 66}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-format-parameter", 48}, { {"format must be a valid VkFormat value", 37}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-nullDescriptor-08938", 52}, { {"If address is zero, range must be VK_WHOLE_SIZE", 47}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-nullDescriptor-08939", 52}, { {"If address is not zero, range must not be VK_WHOLE_SIZE", 55}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-pNext-pNext", 43}, { {"pNext must be NULL", 18}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-range-08045", 43}, { {"If address is not zero, then range must be less than or equal to the size of the buffer containing address minus the offset of address from the base address of the buffer", 170}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-range-08940", 43}, { {"range must not be zero", 22}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorAddressInfoEXT-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT", 59}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-None-09499", 48}, { {"If the pNext chain does not include a VkBufferUsageFlags2CreateInfo structure, usage must be a valid combination of VkBufferUsageFlagBits values", 144}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-None-09500", 48}, { {"If the pNext chain does not include a VkBufferUsageFlags2CreateInfo structure, usage must not be 0", 98}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-address-08057", 51}, { {"address must be aligned to VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferOffsetAlignment", 105}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-address-parameter", 55}, { {"address must be a valid VkDeviceAddress value", 45}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-bufferlessPushDescriptors-08056", 69}, { {"If VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors is VK_FALSE, and usage contains VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, then the pNext chain must include a VkDescriptorBufferBindingPushDescriptorBufferHandleEXT structure", 268}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-pNext-pNext", 49}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferUsageFlags2CreateInfo or VkDescriptorBufferBindingPushDescriptorBufferHandleEXT", 218}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT", 66}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-sType-unique", 50}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08122", 49}, { {"If usage includes VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT, address must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT usage flag set", 226}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08123", 49}, { {"If usage includes VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT, address must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT usage flag set", 228}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08124", 49}, { {"If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, address must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT usage flag set", 244}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingInfoEXT-usage-10998", 49}, { {"The usage must include at least one of VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT, VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT, or VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT", 203}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-buffer-parameter", 76}, { {"buffer must be a valid VkBuffer handle", 38}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-bufferlessPushDescriptors-08059", 91}, { {"VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors must be VK_FALSE", 89}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-sType-sType", 71}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT", 91}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferInfo-buffer-02998", 40}, { {"If the nullDescriptor feature is not enabled, buffer must not be VK_NULL_HANDLE", 79}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferInfo-buffer-02999", 40}, { {"If buffer is VK_NULL_HANDLE, offset must be zero and range must be VK_WHOLE_SIZE", 80}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferInfo-buffer-parameter", 44}, { {"If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", 71}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferInfo-offset-00340", 40}, { {"offset must be less than the size of buffer", 43}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferInfo-range-00341", 39}, { {"If range is not equal to VK_WHOLE_SIZE, range must be greater than 0", 68}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorBufferInfo-range-00342", 39}, { {"If range is not equal to VK_WHOLE_SIZE, range must be less than or equal to the size of buffer minus offset", 107}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08034", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and the nullDescriptor feature is not enabled, pCombinedImageSampler->imageView must not be VK_NULL_HANDLE", 184}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08035", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and the nullDescriptor feature is not enabled, pSampledImage must not be NULL and pSampledImage->imageView must not be VK_NULL_HANDLE", 202}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08036", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and the nullDescriptor feature is not enabled, pStorageImage must not be NULL and pStorageImage->imageView must not be VK_NULL_HANDLE", 202}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08037", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, and the nullDescriptor feature is not enabled, pUniformTexelBuffer must not be NULL", 159}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08038", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, and the nullDescriptor feature is not enabled, pStorageTexelBuffer must not be NULL", 159}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08039", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, and the nullDescriptor feature is not enabled, pUniformBuffer must not be NULL", 148}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08040", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, and the nullDescriptor feature is not enabled, pStorageBuffer must not be NULL", 148}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08041", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR, and the nullDescriptor feature is not enabled, accelerationStructure must not be 0", 164}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorDataEXT-type-08042", 35}, { {"If VkDescriptorGetInfoEXT::type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, and the nullDescriptor feature is not enabled, accelerationStructure must not be 0", 163}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-accelerationStructure-parameter", 59}, { {"If type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR or VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, the accelerationStructure member of data must be a valid VkDeviceAddress value", 184}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pCombinedImageSampler-parameter", 59}, { {"If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", 161}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pInputAttachmentImage-parameter", 59}, { {"If type is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the pInputAttachmentImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", 155}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pNext-pNext", 39}, { {"pNext must be NULL or a pointer to a valid instance of VkDescriptorGetTensorInfoARM", 83}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pSampledImage-parameter", 51}, { {"If type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and if pSampledImage is not NULL, the pSampledImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", 178}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pSampler-parameter", 46}, { {"If type is VK_DESCRIPTOR_TYPE_SAMPLER, the pSampler member of data must be a valid pointer to a valid VkSampler handle", 118}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pStorageBuffer-parameter", 52}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, and if pStorageBuffer is not NULL, the pStorageBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", 186}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pStorageImage-parameter", 51}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and if pStorageImage is not NULL, the pStorageImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", 178}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pStorageTexelBuffer-parameter", 57}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, and if pStorageTexelBuffer is not NULL, the pStorageTexelBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", 202}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pUniformBuffer-parameter", 52}, { {"If type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, and if pUniformBuffer is not NULL, the pUniformBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", 186}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-pUniformTexelBuffer-parameter", 57}, { {"If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, and if pUniformTexelBuffer is not NULL, the pUniformTexelBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", 202}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT", 55}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-sType-unique", 40}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-08018", 38}, { {"type must not be VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", 144}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-08019", 38}, { {"If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler->sampler member of data must be a VkSampler created on device", 141}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-08020", 38}, { {"If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", 164}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-08021", 38}, { {"If type is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the pInputAttachmentImage->imageView member of data must be a VkImageView created on device", 139}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-08022", 38}, { {"If type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and if pSampledImage is not NULL, the pSampledImage->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", 181}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-08023", 38}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and if pStorageImage is not NULL, the pStorageImage->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", 181}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-08028", 38}, { {"If type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR and accelerationStructure is not 0, accelerationStructure must contain the address of a VkAccelerationStructureKHR created on device", 189}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-08029", 38}, { {"If type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV and accelerationStructure is not 0, accelerationStructure must contain the handle of a VkAccelerationStructureNV created on device, returned by vkGetAccelerationStructureHandleNV", 234}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-09427", 38}, { {"If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, pUniformBuffer is not NULL , the number of texel buffer elements given by (floor(pUniformBuffer->range / (texel block size)) x (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for pUniformBuffer->format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", 394}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-09428", 38}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, pStorageBuffer is not NULL , the number of texel buffer elements given by (floor(pStorageBuffer->range / (texel block size)) x (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for pStorageBuffer->format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", 394}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-09701", 38}, { {"If type is VK_DESCRIPTOR_TYPE_TENSOR_ARM, a VkDescriptorGetTensorInfoARM structure must be included in the pNext chain and data is ignored", 138}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12216", 38}, { {"If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER and pCombinedImageSampler->imageView is not VK_NULL_HANDLE, the pCombinedImageSampler->imageView member of data must have been created with VK_IMAGE_USAGE_SAMPLED_BIT set", 223}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12217", 38}, { {"If type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, pSampledImage is not NULL, and pSampledImage->imageView is not VK_NULL_HANDLE, the pSampledImage->imageView member of data must have been created with VK_IMAGE_USAGE_SAMPLED_BIT set", 226}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12218", 38}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, pStorageImage is not NULL, and pStorageImage->imageView is not VK_NULL_HANDLE, the pStorageImage->imageView member of data must have been created with VK_IMAGE_USAGE_STORAGE_BIT set", 226}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12219", 38}, { {"If type is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the pInputAttachmentImage->imageView member of data must have been created with VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT set", 167}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12220", 38}, { {"If type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, pUniformBuffer is not NULL and pUniformBuffer->address is not zero, pUniformBuffer->address must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT usage flag set", 272}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12221", 38}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, pStorageBuffer is not NULL and pStorageBuffer->address is not zero, pStorageBuffer->address must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_STORAGE_BUFFER_BIT usage flag set", 272}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12222", 38}, { {"If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, pUniformTexelBuffer is not NULL and pUniformTexelBuffer->address is not zero, pUniformTexelBuffer->address must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT usage flag set", 299}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12223", 38}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, pStorageTexelBuffer is not NULL and pStorageTexelBuffer->address is not zero, pStorageTexelBuffer->address must be a device address allocated to the application from a buffer created with the VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT usage flag set", 299}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12265", 38}, { {"If type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER and pUniformBuffer is not NULL, pUniformBuffer->address must be aligned to VkPhysicalDeviceLimits::minUniformBufferOffsetAlignment", 175}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12266", 38}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER and pStorageBuffer is not NULL, pStorageBuffer->address must be aligned to VkPhysicalDeviceLimits::minStorageBufferOffsetAlignment", 175}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12267", 38}, { {"If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, the texelBufferAlignment feature is not enabled, and pUniformTexelBuffer is not NULL, pUniformTexelBuffer->address must be aligned to VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment", 239}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12268", 38}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, the texelBufferAlignment feature is not enabled, and pStorageTexelBuffer is not NULL, pStorageTexelBuffer->address must be aligned to VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment", 239}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12269", 38}, { {"If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, the texelBufferAlignment feature is enabled, and pUniformTexelBuffer is not NULL, pUniformTexelBuffer->address must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentProperties::uniformTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentProperties::uniformTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested pUniformTexelBuffer->format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", 578}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-12270", 38}, { {"If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, the texelBufferAlignment feature is enabled, and pStorageTexelBuffer is not NULL, pStorageTexelBuffer->address must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentProperties::storageTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentProperties::storageTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested pStorageTexelBuffer->format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", 578}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetInfoEXT-type-parameter", 42}, { {"type must be a valid VkDescriptorType value", 43}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetTensorInfoARM-nullDescriptor-09899", 54}, { {"If the nullDescriptor feature is not enabled, tensorView must not be VK_NULL_HANDLE", 83}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetTensorInfoARM-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_GET_TENSOR_INFO_ARM", 62}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorGetTensorInfoARM-tensorView-parameter", 54}, { {"If tensorView is not VK_NULL_HANDLE, tensorView must be a valid VkTensorViewARM handle", 86}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-commonparent", 39}, { {"Both of imageView, and sampler that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 150}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-descriptorType-06713", 47}, { {"If the image2DViewOf3D feature is not enabled or descriptorType is not VK_DESCRIPTOR_TYPE_STORAGE_IMAGE then imageView must not be a 2D view created from a 3D image", 164}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-descriptorType-06714", 47}, { {"If the sampler2DViewOf3D feature is not enabled or descriptorType is not VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER then imageView must not be a 2D view created from a 3D image", 211}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-imageLayout-09425", 44}, { {"If imageLayout is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, then the aspectMask used to create imageView must not include either VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", 185}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-imageLayout-09426", 44}, { {"If imageLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, then the aspectMask used to create imageView must not include VK_IMAGE_ASPECT_COLOR_BIT", 496}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-imageView-01976", 42}, { {"If imageView is created from a depth/stencil image, the aspectMask used to create the imageView must include either VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT but not both", 185}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-imageView-06712", 42}, { {"imageView must not be a 2D array image view created from a 3D image", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-imageView-07795", 42}, { {"If imageView is a 2D view created from a 3D image, then descriptorType must be VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER", 191}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-imageView-07796", 42}, { {"If imageView is a 2D view created from a 3D image, then the image must have been created with VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set", 140}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-mutableComparisonSamplers-04450", 58}, { {"If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::mutableComparisonSamplers is VK_FALSE, then sampler must have been created with VkSamplerCreateInfo::compareEnable set to VK_FALSE", 235}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorImageInfo-sampler-01564", 40}, { {"If sampler is used and the VkFormat of the image is a multi-planar format, the image must have been created with VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, and the aspectMask of the imageView must be a valid multi-planar aspect mask bit", 229}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorMappingSourceConstantOffsetEXT-pEmbeddedSampler-11415", 70}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, and there is a VkDebugUtilsObjectNameInfoEXT structure in its pNext chain, its objectType must be VK_OBJECT_TYPE_UNKNOWN", 185}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceConstantOffsetEXT-pEmbeddedSampler-11445", 70}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, its borderColor must not be VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", 159}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceConstantOffsetEXT-pEmbeddedSampler-parameter", 74}, { {"If pEmbeddedSampler is not NULL, pEmbeddedSampler must be a valid pointer to a valid VkSamplerCreateInfo structure", 114}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceHeapDataEXT-heapOffset-11263", 58}, { {"heapOffset must be a multiple of minUniformBufferOffsetAlignment", 64}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceHeapDataEXT-pushOffset-11264", 58}, { {"pushOffset must be a multiple of 4", 34}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceHeapDataEXT-pushOffset-11265", 58}, { {"pushOffset must be less than or equal to maxPushDataSize - 4", 60}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectAddressEXT-addressOffset-11268", 68}, { {"addressOffset must be a multiple of 8", 37}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectAddressEXT-pushOffset-11266", 65}, { {"pushOffset must be a multiple of 8", 34}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectAddressEXT-pushOffset-11267", 65}, { {"pushOffset must be less than or equal to maxPushDataSize - 8", 60}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexArrayEXT-addressOffset-11361", 71}, { {"addressOffset must be a multiple of 4", 37}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexArrayEXT-pEmbeddedSampler-11404", 74}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, and there is a VkDebugUtilsObjectNameInfoEXT structure in its pNext chain, its objectType must be VK_OBJECT_TYPE_UNKNOWN", 185}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexArrayEXT-pEmbeddedSampler-11448", 74}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, its borderColor must not be VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", 159}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexArrayEXT-pEmbeddedSampler-parameter", 78}, { {"If pEmbeddedSampler is not NULL, pEmbeddedSampler must be a valid pointer to a valid VkSamplerCreateInfo structure", 114}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexArrayEXT-pushOffset-11359", 68}, { {"pushOffset must be a multiple of 8", 34}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexArrayEXT-pushOffset-11360", 68}, { {"pushOffset must be less than or equal to maxPushDataSize - 8", 60}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexEXT-addressOffset-11262", 66}, { {"addressOffset must be a multiple of 4", 37}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexEXT-pEmbeddedSampler-11403", 69}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, and there is a VkDebugUtilsObjectNameInfoEXT structure in its pNext chain, its objectType must be VK_OBJECT_TYPE_UNKNOWN", 185}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexEXT-pEmbeddedSampler-11447", 69}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, its borderColor must not be VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", 159}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexEXT-pEmbeddedSampler-parameter", 73}, { {"If pEmbeddedSampler is not NULL, pEmbeddedSampler must be a valid pointer to a valid VkSamplerCreateInfo structure", 114}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexEXT-pushOffset-11260", 63}, { {"pushOffset must be a multiple of 8", 34}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceIndirectIndexEXT-pushOffset-11261", 63}, { {"pushOffset must be less than or equal to maxPushDataSize - 8", 60}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourcePushIndexEXT-pEmbeddedSampler-11402", 65}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, and there is a VkDebugUtilsObjectNameInfoEXT structure in its pNext chain, its objectType must be VK_OBJECT_TYPE_UNKNOWN", 185}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourcePushIndexEXT-pEmbeddedSampler-11446", 65}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, its borderColor must not be VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", 159}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourcePushIndexEXT-pEmbeddedSampler-parameter", 69}, { {"If pEmbeddedSampler is not NULL, pEmbeddedSampler must be a valid pointer to a valid VkSamplerCreateInfo structure", 114}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourcePushIndexEXT-pushOffset-11258", 59}, { {"pushOffset must be a multiple of 4", 34}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourcePushIndexEXT-pushOffset-11259", 59}, { {"pushOffset must be less than or equal to maxPushDataSize - 4", 60}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceShaderRecordIndexEXT-pEmbeddedSampler-11405", 73}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, and there is a VkDebugUtilsObjectNameInfoEXT structure in its pNext chain, its objectType must be VK_OBJECT_TYPE_UNKNOWN", 185}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceShaderRecordIndexEXT-pEmbeddedSampler-11449", 73}, { {"If pEmbeddedSampler is a valid pointer to a VkSamplerCreateInfo, its borderColor must not be VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", 159}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceShaderRecordIndexEXT-pEmbeddedSampler-parameter", 77}, { {"If pEmbeddedSampler is not NULL, pEmbeddedSampler must be a valid pointer to a valid VkSamplerCreateInfo structure", 114}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceShaderRecordIndexEXT-shaderRecordOffset-11269", 75}, { {"shaderRecordOffset must be a multiple of 4", 42}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorMappingSourceShaderRecordIndexEXT-shaderRecordOffset-11270", 75}, { {"shaderRecordOffset must be less than or equal to maxShaderGroupStride - 4", 73}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorPoolCreateInfo-descriptorPoolOverallocation-09227", 66}, { {"If the descriptorPoolOverallocation feature is not enabled, or flags does not have VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV set, maxSets must be greater than 0", 177}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-flags-04607", 43}, { {"If flags has the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT bit set, then the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT bit must not be set", 146}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-flags-04609", 43}, { {"If flags has the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT bit set, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType must be enabled", 157}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-flags-09228", 43}, { {"If flags has the VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV or VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV bits set, then descriptorPoolOverallocation must be enabled", 198}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-flags-parameter", 47}, { {"flags must be a valid combination of VkDescriptorPoolCreateFlagBits values", 74}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-mutableDescriptorType-04608", 59}, { {"If VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType is not enabled, pPoolSizes must not contain a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", 169}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-pNext-09946", 43}, { {"If a VkDataGraphProcessingEngineCreateInfoARM structure is included in the pNext chain, each member of pProcessingEngines must be identical to an VkQueueFamilyDataGraphPropertiesARM::engine retrieved from vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM with the physicalDevice that was used to create device", 312}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-pNext-pNext", 43}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDataGraphProcessingEngineCreateInfoARM, VkDescriptorPoolInlineUniformBlockCreateInfo, or VkMutableDescriptorTypeCreateInfoEXT", 258}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-04787", 48}, { {"If pPoolSizes contains a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, any other VK_DESCRIPTOR_TYPE_MUTABLE_EXT element in pPoolSizes must not have sets of supported descriptor types which partially overlap", 210}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-09424", 48}, { {"If pPoolSizes contains a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, the pNext chain must include a VkDescriptorPoolInlineUniformBlockCreateInfo structure whose maxInlineUniformBlockBindings member is not zero", 224}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-parameter", 52}, { {"If poolSizeCount is not 0, pPoolSizes must be a valid pointer to an array of poolSizeCount valid VkDescriptorPoolSize structures", 128}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO", 59}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolCreateInfo-sType-unique", 44}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolInlineUniformBlockCreateInfo-sType-sType", 61}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO", 80}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolSize-descriptorCount-00302", 47}, { {"descriptorCount must be greater than 0", 38}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolSize-type-02218", 36}, { {"If type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then descriptorCount must be a multiple of 4", 95}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorPoolSize-type-parameter", 40}, { {"type must be a valid VkDescriptorType value", 43}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-apiVersion-07895", 49}, { {"If the VK_KHR_maintenance1 extension is not enabled and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, descriptorSetCount must not be greater than the number of sets that are currently available for allocation in descriptorPool", 244}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-apiVersion-07896", 49}, { {"If the VK_KHR_maintenance1 extension is not enabled and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, descriptorPool must have enough free descriptor capacity remaining to allocate the descriptor sets of the specified layouts", 243}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-commonparent", 45}, { {"Both of descriptorPool, and the elements of pSetLayouts must have been created, allocated, or retrieved from the same VkDevice", 126}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-descriptorPool-parameter", 57}, { {"descriptorPool must be a valid VkDescriptorPool handle", 54}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-arraylength", 63}, { {"descriptorSetCount must be greater than 0", 41}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-pNext-pNext", 44}, { {"pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountAllocateInfo", 105}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-00308", 50}, { {"Each element of pSetLayouts must not have been created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT set", 115}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-03044", 50}, { {"If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", 222}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-04610", 50}, { {"If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag set", 214}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-08009", 50}, { {"Each element of pSetLayouts must not have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT bit set", 129}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-09380", 50}, { {"If pSetLayouts[i] was created with an element of pBindingFlags that includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, and VkDescriptorSetVariableDescriptorCountAllocateInfo is included in the pNext chain, and VkDescriptorSetVariableDescriptorCountAllocateInfo::descriptorSetCount is not zero, then VkDescriptorSetVariableDescriptorCountAllocateInfo::pDescriptorCounts[i] must be less than or equal to VkDescriptorSetLayoutBinding::descriptorCount for the corresponding binding used to create pSetLayouts[i]", 518}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-parameter", 54}, { {"pSetLayouts must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSetLayout handles", 105}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO", 60}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAllocateInfo-sType-unique", 45}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-constantOffset-parameter", 65}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT, the constantOffset member of sourceData must be a valid VkDescriptorMappingSourceConstantOffsetEXT structure", 181}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-indirectIndex-parameter", 64}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT, the indirectIndex member of sourceData must be a valid VkDescriptorMappingSourceIndirectIndexEXT structure", 178}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-indirectIndexArray-parameter", 69}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT, the indirectIndexArray member of sourceData must be a valid VkDescriptorMappingSourceIndirectIndexArrayEXT structure", 194}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-pNext-pNext", 52}, { {"pNext must be NULL or a pointer to a valid instance of VkPushConstantBankInfoNV", 79}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-pushIndex-parameter", 60}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT, the pushIndex member of sourceData must be a valid VkDescriptorMappingSourcePushIndexEXT structure", 166}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-resourceMask-parameter", 63}, { {"resourceMask must be a valid combination of VkSpirvResourceTypeFlagBitsEXT values", 81}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-resourceMask-requiredbitmask", 69}, { {"resourceMask must not be 0", 26}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_AND_BINDING_MAPPING_EXT", 70}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-sType-unique", 53}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-shaderRecordIndex-parameter", 68}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT, the shaderRecordIndex member of sourceData must be a valid VkDescriptorMappingSourceShaderRecordIndexEXT structure", 191}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11245", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_DATA_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_ADDRESS_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_INDIRECT_ADDRESS_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_RESOURCE_HEAP_DATA_EXT, bindingCount must be 1", 233}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11246", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_DATA_EXT, sourceData.pushDataOffset must be a multiple of 4", 106}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11247", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_ADDRESS_EXT, sourceData.pushAddressOffset must be a multiple of 8", 112}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11248", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_DATA_EXT or VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_ADDRESS_EXT, bindingCount must be 1", 146}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11249", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_DATA_EXT, sourceData.shaderRecordDataOffset must be a multiple of 4", 123}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11250", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_ADDRESS_EXT, sourceData.shaderRecordAddressOffset must be a multiple of 8", 129}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11251", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT, and descriptorSet, firstBinding, and bindingCount identify any OpTypeImage variables, any heapOffset, and heapArrayStride members of the corresponding member of sourceData must be 0 or a multiple of imageDescriptorAlignment", 542}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11252", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT, and descriptorSet, firstBinding, and bindingCount identify any OpTypeStruct variables, any heapOffset, and heapArrayStride members of the corresponding member of sourceData must be 0 or a multiple of bufferDescriptorAlignment", 544}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11253", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT, and descriptorSet, firstBinding, and bindingCount identify any OpTypeSampler variables, any heapOffset and heapArrayStride members of the corresponding member of sourceData must be 0 or a multiple of samplerDescriptorAlignment", 545}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11254", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT, and descriptorSet, firstBinding, and bindingCount identify any OpTypeSampledImage variables, any samplerHeapOffset and samplerHeapArrayStride members of the corresponding member of sourceData must be 0 or a multiple of samplerDescriptorAlignment", 564}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11356", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_RESOURCE_HEAP_DATA_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_DATA_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_DATA_EXT, resourceMask must include VK_SPIRV_RESOURCE_TYPE_UNIFORM_BUFFER_BIT_EXT", 237}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11357", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_ADDRESS_EXT or VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_ADDRESS_EXT, resourceMask must include at least one of VK_SPIRV_RESOURCE_TYPE_UNIFORM_BUFFER_BIT_EXT, VK_SPIRV_RESOURCE_TYPE_READ_ONLY_STORAGE_BUFFER_BIT_EXT, VK_SPIRV_RESOURCE_TYPE_READ_WRITE_STORAGE_BUFFER_BIT_EXT, or VK_SPIRV_RESOURCE_TYPE_ACCELERATION_STRUCTURE_BIT_EXT", 378}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11358", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT, and the mapping sets useCombinedImageSamplerIndex to VK_TRUE, resourceMask must include at least one of VK_SPIRV_RESOURCE_TYPE_COMBINED_SAMPLED_IMAGE_BIT_EXT, VK_SPIRV_RESOURCE_TYPE_SAMPLED_IMAGE_BIT_EXT, or VK_SPIRV_RESOURCE_TYPE_SAMPLER_BIT_EXT", 505}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11389", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT, and bindingCount is not 1, the pEmbeddedSampler member of the corresponding mapping structure must be NULL", 425}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-11390", 53}, { {"If source is VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT, VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT, or VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT, and descriptorSet, firstBinding, and bindingCount identify any OpTypeTensorARM variables, the heapOffset, and heapArrayStride members of the corresponding member of sourceData must be 0 or a multiple of tensorDescriptorAlignment", 547}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetAndBindingMappingEXT-source-parameter", 57}, { {"source must be a valid VkDescriptorMappingSourceEXT value", 57}, { "chapters/descriptorheaps.html", 29} } },
        { {"VUID-VkDescriptorSetBindingReferenceVALVE-descriptorSetLayout-parameter", 71}, { {"descriptorSetLayout must be a valid VkDescriptorSetLayout handle", 64}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkDescriptorSetBindingReferenceVALVE-pNext-pNext", 53}, { {"pNext must be NULL", 18}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkDescriptorSetBindingReferenceVALVE-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE", 70}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorCount-09465", 55}, { {"If descriptorCount is not 0, stageFlags must be VK_SHADER_STAGE_ALL or a valid combination of other VkShaderStageFlagBits values", 128}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-00282", 54}, { {"If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and descriptorCount is not 0 and pImmutableSamplers is not NULL, pImmutableSamplers must be a valid pointer to an array of descriptorCount valid VkSampler handles", 256}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-01510", 54}, { {"If descriptorType is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT and descriptorCount is not 0, then stageFlags must be 0 or VK_SHADER_STAGE_FRAGMENT_BIT", 144}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-02209", 54}, { {"If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then descriptorCount must be a multiple of 4", 105}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-04604", 54}, { {"If the inlineUniformBlock feature is not enabled, descriptorType must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", 116}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-04605", 54}, { {"If descriptorType is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then pImmutableSamplers must be NULL", 89}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-08004", 54}, { {"If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK and VkDescriptorSetLayoutCreateInfo::flags does not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT then descriptorCount must be less than or equal to VkPhysicalDeviceInlineUniformBlockProperties::maxInlineUniformBlockSize", 301}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-12200", 54}, { {"If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and descriptorCount is not 0 and pImmutableSamplers is not NULL, either each element of pImmutableSamplers must be a VkSampler that enables sampler Y'CBCR conversion or none of them enable sampler Y'CBCR conversion", 278}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-12215", 54}, { {"If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER, each element of pImmutableSamplers must not be a VkSampler object that enables sampler Y'CBCR conversion", 153}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter", 58}, { {"descriptorType must be a valid VkDescriptorType value", 53}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-flags-08005", 45}, { {"If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, descriptorType must be VK_DESCRIPTOR_TYPE_SAMPLER", 169}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-flags-08006", 45}, { {"If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, descriptorCount must be less than or equal to 1", 167}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-flags-08007", 45}, { {"If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, and descriptorCount is equal to 1, pImmutableSamplers must not be NULL", 190}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-flags-09466", 45}, { {"If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, and descriptorCount is not 0, then stageFlags must be a valid combination of VK_SHADER_STAGE_VERTEX_BIT, VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, VK_SHADER_STAGE_GEOMETRY_BIT, VK_SHADER_STAGE_FRAGMENT_BIT and VK_SHADER_STAGE_COMPUTE_BIT values", 390}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBinding-pImmutableSamplers-04009", 58}, { {"The sampler objects indicated by pImmutableSamplers must not have a borderColor with one of the values VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", 169}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-None-03011", 59}, { {"All bindings with descriptor type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 215}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-bindingCount-03002", 67}, { {"If bindingCount is not zero, bindingCount must equal VkDescriptorSetLayoutCreateInfo::bindingCount", 98}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingAccelerationStructureUpdateAfterBind-03570", 108}, { {"If VkPhysicalDeviceAccelerationStructureFeaturesKHR::descriptorBindingAccelerationStructureUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR or VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 307}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingInlineUniformBlockUpdateAfterBind-02211", 105}, { {"If VkPhysicalDeviceInlineUniformBlockFeatures::descriptorBindingInlineUniformBlockUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 244}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingPartiallyBound-03013", 86}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingPartiallyBound is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT", 183}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingSampledImageUpdateAfterBind-03006", 99}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingSampledImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_SAMPLER, VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, or VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 305}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageBufferUpdateAfterBind-03008", 100}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 233}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageImageUpdateAfterBind-03007", 99}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 231}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageTensorUpdateAfterBind-09697", 100}, { {"If VkPhysicalDeviceTensorFeaturesARM::descriptorBindingStorageTensorUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_TENSOR_ARM must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 220}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageTexelBufferUpdateAfterBind-03010", 105}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 244}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformBufferUpdateAfterBind-03005", 100}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 233}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformTexelBufferUpdateAfterBind-03009", 105}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", 244}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUpdateUnusedWhilePending-03012", 96}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUpdateUnusedWhilePending is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT", 205}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingVariableDescriptorCount-03014", 95}, { {"If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingVariableDescriptorCount is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT", 202}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-flags-03003", 60}, { {"If VkDescriptorSetLayoutCreateInfo::flags includes VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT, VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT, or VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT", 310}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03004", 68}, { {"If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, then it must be the element with the highest binding number", 152}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03015", 68}, { {"If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, that element's descriptorType must not be VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", 221}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-parameter", 72}, { {"If bindingCount is not 0, pBindingFlags must be a valid pointer to an array of bindingCount valid combinations of VkDescriptorBindingFlagBits values", 148}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-sType-sType", 60}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO", 79}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-binding-00279", 50}, { {"If the perStageDescriptorSet feature is not enabled, or flags does not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then the VkDescriptorSetLayoutBinding::binding members of the elements of the pBindings array must each have different values", 254}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-03001", 57}, { {"If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, then all bindings must not have descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", 212}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-04594", 57}, { {"If a binding has a descriptorType value of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then pImmutableSamplers must be NULL", 111}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00280", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", 222}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00281", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then the total number of elements of all bindings must be less than or equal to VkPhysicalDevicePushDescriptorProperties::maxPushDescriptors", 211}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-02208", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", 175}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-03000", 48}, { {"If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, flags must include VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT", 153}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04590", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT", 148}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04591", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", 145}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04592", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT, flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT", 155}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04596", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType must be enabled", 161}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08000", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", 228}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08001", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, flags must also contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT", 168}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08002", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT", 163}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08003", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT", 159}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-09463", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then perStageDescriptorSet must be enabled", 110}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-09464", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then there must not be any two elements of the pBindings array with the same VkDescriptorSetLayoutBinding::binding value and their VkDescriptorSetLayoutBinding::stageFlags containing the same bit", 263}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-10354", 48}, { {"If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, and the VK_KHR_push_descriptor extension is not enabled, pushDescriptor must be enabled", 158}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter", 52}, { {"flags must be a valid combination of VkDescriptorSetLayoutCreateFlagBits values", 79}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-mutableDescriptorType-04595", 64}, { {"If VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType is not enabled, pBindings must not contain a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", 168}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-pBindings-07303", 52}, { {"If any element pBindings[i] has a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then the pNext chain must include a VkMutableDescriptorTypeCreateInfoEXT structure, and mutableDescriptorTypeListCount must be greater than i", 225}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter", 56}, { {"If bindingCount is not 0, pBindings must be a valid pointer to an array of bindingCount valid VkDescriptorSetLayoutBinding structures", 133}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext", 48}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDescriptorSetLayoutBindingFlagsCreateInfo or VkMutableDescriptorTypeCreateInfoEXT", 214}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", 65}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutCreateInfo-sType-unique", 49}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutHostMappingInfoVALVE-pNext-pNext", 58}, { {"pNext must be NULL", 18}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkDescriptorSetLayoutHostMappingInfoVALVE-sType-sType", 58}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE", 77}, { "appendices/extensions.html", 26} } },
        { {"VUID-VkDescriptorSetLayoutSupport-pNext-pNext", 45}, { {"pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountLayoutSupport", 106}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutSupport-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT", 61}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetLayoutSupport-sType-unique", 46}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-descriptorSetCount-03045", 80}, { {"If descriptorSetCount is not zero, descriptorSetCount must equal VkDescriptorSetAllocateInfo::descriptorSetCount", 112}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts-parameter", 83}, { {"If descriptorSetCount is not 0, pDescriptorCounts must be a valid pointer to an array of descriptorSetCount uint32_t values", 123}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-sType-sType", 67}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO", 86}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorSetVariableDescriptorCountLayoutSupport-sType-sType", 68}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT", 87}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-commonparent", 54}, { {"Both of descriptorSetLayout, and pipelineLayout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 167}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount-arraylength", 80}, { {"descriptorUpdateEntryCount must be greater than 0", 49}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-flags-zerobitmask", 59}, { {"flags must be 0", 15}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries-parameter", 76}, { {"pDescriptorUpdateEntries must be a valid pointer to an array of descriptorUpdateEntryCount valid VkDescriptorUpdateTemplateEntry structures", 139}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-pNext-pNext", 53}, { {"pNext must be NULL", 18}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO", 70}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00350", 60}, { {"If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must be a valid VkDescriptorSetLayout handle", 134}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00351", 60}, { {"If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS, pipelineBindPoint must be a valid VkPipelineBindPoint value", 131}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00352", 60}, { {"If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS, pipelineLayout must be a valid VkPipelineLayout handle", 126}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00353", 60}, { {"If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS, set must be the unique set number in the pipeline layout that uses a descriptor set layout that was created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT", 236}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-04615", 60}, { {"If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must not contain a binding with type VK_DESCRIPTOR_TYPE_MUTABLE_EXT", 157}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-10355", 60}, { {"If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS, and the VK_KHR_push_descriptor extension is not enabled, pushDescriptor must be enabled", 159}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-parameter", 64}, { {"templateType must be a valid VkDescriptorUpdateTemplateType value", 65}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02226", 53}, { {"If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, dstArrayElement must be an integer multiple of 4", 111}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02227", 53}, { {"If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, descriptorCount must be an integer multiple of 4", 111}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateEntry-descriptorType-parameter", 61}, { {"descriptorType must be a valid VkDescriptorType value", 53}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateEntry-dstArrayElement-00355", 58}, { {"dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding implicitly specified when using a descriptor update template to update descriptors, and all applicable consecutive bindings", 248}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDescriptorUpdateTemplateEntry-dstBinding-00354", 53}, { {"dstBinding must be a valid binding in the descriptor set layout implicitly specified when using a descriptor update template to update descriptors", 146}, { "chapters/descriptorsets.html", 28} } },
        { {"VUID-VkDeviceAddress-None-10894", 31}, { {"If a VkDeviceAddress was retrieved from a non-sparse buffer, that buffer must be bound completely and contiguously to a single VkDeviceMemory object", 148}, { "chapters/fundamentals.html", 26} } },
        { {"VUID-VkDeviceAddress-size-11364", 31}, { {"A valid VkDeviceAddress must be equal to the sum of an address retrieved from a VkBuffer via vkGetBufferDeviceAddress, and any offset in the range [0, size), where size is the value of VkBufferCreateInfo::size used to create that VkBuffer", 238}, { "chapters/fundamentals.html", 26} } },
        { {"VUID-VkDeviceAddressBindingCallbackDataEXT-baseAddress-parameter", 64}, { {"baseAddress must be a valid VkDeviceAddress value", 49}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceAddressBindingCallbackDataEXT-bindingType-parameter", 64}, { {"bindingType must be a valid VkDeviceAddressBindingTypeEXT value", 63}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceAddressBindingCallbackDataEXT-flags-parameter", 58}, { {"flags must be a valid combination of VkDeviceAddressBindingFlagBitsEXT values", 77}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceAddressBindingCallbackDataEXT-sType-sType", 54}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT", 72}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceAddressRangeEXT-address-11365", 42}, { {"The sum of address and size must be less than or equal to the sum of an address retrieved from a VkBuffer and the value of VkBufferCreateInfo::size used to create that VkBuffer", 176}, { "chapters/fundamentals.html", 26} } },
        { {"VUID-VkDeviceAddressRangeEXT-address-parameter", 46}, { {"If address is not 0, address must be a valid VkDeviceAddress value", 66}, { "chapters/fundamentals.html", 26} } },
        { {"VUID-VkDeviceAddressRangeEXT-size-11411", 39}, { {"If size is not 0, address must not be 0", 39}, { "chapters/fundamentals.html", 26} } },
        { {"VUID-VkDeviceBufferMemoryRequirements-pCreateInfo-parameter", 59}, { {"pCreateInfo must be a valid pointer to a valid VkBufferCreateInfo structure", 75}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceBufferMemoryRequirements-pNext-pNext", 49}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceBufferMemoryRequirements-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS", 65}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceCreateInfo-None-04896", 34}, { {"If the sparseImageInt64Atomics feature is enabled, shaderImageInt64Atomics must be enabled", 90}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-None-04897", 34}, { {"If the sparseImageFloat32Atomics feature is enabled, shaderImageFloat32Atomics must be enabled", 94}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-None-04898", 34}, { {"If the sparseImageFloat32AtomicAdd feature is enabled, shaderImageFloat32AtomicAdd must be enabled", 98}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-None-08095", 34}, { {"If the descriptorBuffer feature is enabled, ppEnabledExtensionNames must not contain VK_AMD_shader_fragment_mask", 112}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-None-10778", 34}, { {"If the maintenance9 feature is not supported, queueCreateInfoCount must be greater than 0", 89}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-flags-zerobitmask", 41}, { {"flags must be 0", 15}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04481", 48}, { {"If the fragmentDensityMap feature is enabled, the pipelineFragmentShadingRate feature must not be enabled", 105}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04482", 48}, { {"If the fragmentDensityMap feature is enabled, the primitiveFragmentShadingRate feature must not be enabled", 106}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04483", 48}, { {"If the fragmentDensityMap feature is enabled, the attachmentFragmentShadingRate feature must not be enabled", 107}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pEnabledFeatures-parameter", 50}, { {"If pEnabledFeatures is not NULL, pEnabledFeatures must be a valid pointer to a valid VkPhysicalDeviceFeatures structure", 119}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-00373", 35}, { {"If the pNext chain includes a VkPhysicalDeviceFeatures2 structure, then pEnabledFeatures must be NULL", 101}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-02829", 35}, { {"If the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then it must not include a VkPhysicalDevice16BitStorageFeatures, VkPhysicalDeviceMultiviewFeatures, VkPhysicalDeviceVariablePointersFeatures, VkPhysicalDeviceProtectedMemoryFeatures, VkPhysicalDeviceSamplerYcbcrConversionFeatures, or VkPhysicalDeviceShaderDrawParametersFeatures structure", 362}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-02830", 35}, { {"If the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then it must not include a VkPhysicalDevice8BitStorageFeatures, VkPhysicalDeviceShaderAtomicInt64Features, VkPhysicalDeviceShaderFloat16Int8Features, VkPhysicalDeviceDescriptorIndexingFeatures, VkPhysicalDeviceScalarBlockLayoutFeatures, VkPhysicalDeviceImagelessFramebufferFeatures, VkPhysicalDeviceUniformBufferStandardLayoutFeatures, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, VkPhysicalDeviceHostQueryResetFeatures, VkPhysicalDeviceTimelineSemaphoreFeatures, VkPhysicalDeviceBufferDeviceAddressFeatures, or VkPhysicalDeviceVulkanMemoryModelFeatures structure", 698}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-04748", 35}, { {"If the pNext chain includes a VkPhysicalDeviceVulkan12Features structure and VkPhysicalDeviceVulkan12Features::bufferDeviceAddress is VK_TRUE, ppEnabledExtensionNames must not contain VK_EXT_buffer_device_address", 212}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-06532", 35}, { {"If the pNext chain includes a VkPhysicalDeviceVulkan13Features structure, then it must not include a VkPhysicalDeviceDynamicRenderingFeatures, VkPhysicalDeviceImageRobustnessFeatures, VkPhysicalDeviceInlineUniformBlockFeatures, VkPhysicalDeviceMaintenance4Features, VkPhysicalDevicePipelineCreationCacheControlFeatures, VkPhysicalDevicePrivateDataFeatures, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, VkPhysicalDeviceShaderIntegerDotProductFeatures, VkPhysicalDeviceShaderTerminateInvocationFeatures, VkPhysicalDeviceSubgroupSizeControlFeatures, VkPhysicalDeviceSynchronization2Features, VkPhysicalDeviceTextureCompressionASTCHDRFeatures, or VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures structure", 717}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-09396", 35}, { {"If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure, then it must not be included in the pNext chain of any of the VkDeviceQueueCreateInfo structures in pQueueCreateInfos", 202}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-09397", 35}, { {"If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure then VkPhysicalDeviceSchedulingControlsPropertiesARM::schedulingControlsFlags must contain VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM", 235}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-10360", 35}, { {"If the pNext chain includes a VkPhysicalDeviceVulkan14Features structure, then it must not include a VkPhysicalDeviceGlobalPriorityQueryFeatures, VkPhysicalDeviceShaderSubgroupRotateFeatures, VkPhysicalDeviceShaderFloatControls2Features, VkPhysicalDeviceShaderExpectAssumeFeatures, VkPhysicalDeviceLineRasterizationFeatures, VkPhysicalDeviceVertexAttributeDivisorFeatures, VkPhysicalDeviceIndexTypeUint8Features, VkPhysicalDeviceDynamicRenderingLocalReadFeatures, VkPhysicalDeviceMaintenance5Features, VkPhysicalDeviceMaintenance6Features, VkPhysicalDevicePipelineProtectedAccessFeatures, VkPhysicalDevicePipelineRobustnessFeatures, or VkPhysicalDeviceHostImageCopyFeatures structure", 683}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pNext-pNext", 35}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid struct for extending VkDeviceCreateInfo", 158}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pProperties-04451", 41}, { {"If the VK_KHR_portability_subset extension is included in pProperties of vkEnumerateDeviceExtensionProperties, ppEnabledExtensionNames must include \"VK_KHR_portability_subset\"", 177}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-06654", 47}, { {"If multiple elements of pQueueCreateInfos share the same queueFamilyIndex, then all of such elements must have the same global priority level, which can be specified explicitly by the including a VkDeviceQueueGlobalPriorityCreateInfo structure in the pNext chain, or by the implicit default value", 296}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-06755", 47}, { {"If multiple elements of pQueueCreateInfos share the same queueFamilyIndex, the sum of their queueCount members must be less than or equal to the queueCount member of the VkQueueFamilyProperties structure, as returned by vkGetPhysicalDeviceQueueFamilyProperties in the pQueueFamilyProperties[queueFamilyIndex]", 308}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-parameter", 51}, { {"If queueCreateInfoCount is not 0, pQueueCreateInfos must be a valid pointer to an array of queueCreateInfoCount valid VkDeviceQueueCreateInfo structures", 152}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-00374", 53}, { {"ppEnabledExtensionNames must not contain both VK_KHR_maintenance1 and VK_AMD_negative_viewport_height", 101}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-01840", 53}, { {"If VkPhysicalDeviceProperties::apiVersion advertises Vulkan 1.1 or later, ppEnabledExtensionNames must not contain VK_AMD_negative_viewport_height", 146}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02831", 53}, { {"If ppEnabledExtensionNames contains \"VK_KHR_draw_indirect_count\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::drawIndirectCount must be VK_TRUE", 214}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02832", 53}, { {"If ppEnabledExtensionNames contains \"VK_KHR_sampler_mirror_clamp_to_edge\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerMirrorClampToEdge must be VK_TRUE", 230}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02833", 53}, { {"If ppEnabledExtensionNames contains \"VK_EXT_descriptor_indexing\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::descriptorIndexing must be VK_TRUE", 215}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02834", 53}, { {"If ppEnabledExtensionNames contains \"VK_EXT_sampler_filter_minmax\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerFilterMinmax must be VK_TRUE", 218}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02835", 53}, { {"If ppEnabledExtensionNames contains \"VK_EXT_shader_viewport_index_layer\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::shaderOutputViewportIndex and VkPhysicalDeviceVulkan12Features::shaderOutputLayer must both be VK_TRUE", 291}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-03328", 53}, { {"ppEnabledExtensionNames must not contain both VK_KHR_buffer_device_address and VK_EXT_buffer_device_address", 107}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-04476", 53}, { {"If ppEnabledExtensionNames contains \"VK_KHR_shader_draw_parameters\" and the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then VkPhysicalDeviceVulkan11Features::shaderDrawParameters must be VK_TRUE", 220}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-10858", 53}, { {"If ppEnabledExtensionNames contains \"VK_KHR_push_descriptor\" and the pNext chain includes a VkPhysicalDeviceVulkan14Features structure, then VkPhysicalDeviceVulkan14Features::pushDescriptor must be VK_TRUE", 207}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-parameter", 57}, { {"If enabledExtensionCount is not 0, ppEnabledExtensionNames must be a valid pointer to an array of enabledExtensionCount null-terminated UTF-8 strings", 149}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-ppEnabledLayerNames-parameter", 53}, { {"If enabledLayerCount is not 0, ppEnabledLayerNames must be a valid pointer to an array of enabledLayerCount null-terminated UTF-8 strings", 137}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-queueFamilyIndex-02802", 46}, { {"The queueFamilyIndex member of each element of pQueueCreateInfos must be unique within pQueueCreateInfos , except that two members can share the same queueFamilyIndex if one describes protected-capable queues and one describes queues that are not protected-capable", 264}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-queueFamilyIndex-11831", 46}, { {"If any element of pQueueCreateInfos specifies a queueFamilyIndex that supports VK_QUEUE_DATA_GRAPH_BIT_ARM and that queueFamilyIndex enumerates an engine through vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM with type VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_NEURAL_QCOM or VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_COMPUTE_QCOM, a VkPhysicalDeviceDataGraphModelFeaturesQCOM structure must be included in pNext with dataGraphModel set to VK_TRUE", 475}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-robustBufferAccess-10247", 48}, { {"If the robustBufferAccess feature is enabled, and robustBufferAccessUpdateAfterBind is VK_FALSE, then descriptorBindingUniformBufferUpdateAfterBind, descriptorBindingStorageBufferUpdateAfterBind, descriptorBindingUniformTexelBufferUpdateAfterBind, and descriptorBindingStorageTexelBufferUpdateAfterBind must not be enabled", 322}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO", 50}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-sType-unique", 36}, { {"The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkDeviceDeviceMemoryReportCreateInfoEXT or VkDevicePrivateDataCreateInfo", 182}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-shadingRateImage-04478", 46}, { {"If the shadingRateImage feature is enabled, the pipelineFragmentShadingRate feature must not be enabled", 103}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-shadingRateImage-04479", 46}, { {"If the shadingRateImage feature is enabled, the primitiveFragmentShadingRate feature must not be enabled", 104}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-shadingRateImage-04480", 46}, { {"If the shadingRateImage feature is enabled, the attachmentFragmentShadingRate feature must not be enabled", 105}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceCreateInfo-sparseImageFloat32AtomicMinMax-04975", 60}, { {"If the sparseImageFloat32AtomicMinMax feature is enabled, shaderImageFloat32AtomicMinMax must be enabled", 104}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-flags-zerobitmask", 62}, { {"flags must be 0", 15}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pfnUserCallback-parameter", 70}, { {"pfnUserCallback must be a valid PFN_vkDeviceMemoryReportCallbackEXT value", 73}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-sType-sType", 56}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT", 75}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceDiagnosticsConfigCreateInfoNV-flags-parameter", 58}, { {"flags must be a valid combination of VkDeviceDiagnosticsConfigFlagBitsNV values", 79}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceDiagnosticsConfigCreateInfoNV-sType-sType", 54}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV", 72}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceEventInfoEXT-deviceEvent-parameter", 47}, { {"deviceEvent must be a valid VkDeviceEventTypeEXT value", 54}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDeviceEventInfoEXT-pNext-pNext", 37}, { {"pNext must be NULL", 18}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDeviceEventInfoEXT-sType-sType", 37}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT", 53}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDeviceFaultAddressInfoEXT-addressType-parameter", 54}, { {"addressType must be a valid VkDeviceFaultAddressTypeEXT value", 61}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceFaultAddressInfoEXT-reportedAddress-parameter", 58}, { {"reportedAddress must be a valid VkDeviceAddress value", 53}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceFaultCountsEXT-pNext-pNext", 39}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceFaultCountsEXT-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT", 55}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceFaultInfoEXT-pNext-pNext", 37}, { {"pNext must be NULL", 18}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceFaultInfoEXT-sType-sType", 37}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT", 53}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerSize-07340", 66}, { {"headerSize must be 56", 21}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerVersion-07341", 69}, { {"headerVersion must be VK_DEVICE_FAULT_VENDOR_BINARY_HEADER_VERSION_ONE_EXT", 74}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerVersion-parameter", 73}, { {"headerVersion must be a valid VkDeviceFaultVendorBinaryHeaderVersionEXT value", 77}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkDeviceGroupBindSparseInfo-memoryDeviceIndex-01119", 56}, { {"Each memory allocation bound in this batch must have allocated an instance for memoryDeviceIndex", 96}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkDeviceGroupBindSparseInfo-resourceDeviceIndex-01118", 58}, { {"resourceDeviceIndex and memoryDeviceIndex must both be valid device indices", 75}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkDeviceGroupBindSparseInfo-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO", 61}, { "chapters/sparsemem.html", 23} } },
        { {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00106", 57}, { {"deviceMask must be a valid device mask value", 44}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00107", 57}, { {"deviceMask must not be zero", 27}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupCommandBufferBeginInfo-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO", 70}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00375", 57}, { {"Each element of pPhysicalDevices must be unique", 47}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00376", 57}, { {"All elements of pPhysicalDevices must be in the same device group as enumerated by vkEnumeratePhysicalDeviceGroups", 114}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-parameter", 61}, { {"If physicalDeviceCount is not 0, pPhysicalDevices must be a valid pointer to an array of physicalDeviceCount valid VkPhysicalDevice handles", 139}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceGroupDeviceCreateInfo-physicalDeviceCount-00377", 60}, { {"If physicalDeviceCount is not 0, the physicalDevice parameter of vkCreateDevice must be an element of pPhysicalDevices", 118}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceGroupDeviceCreateInfo-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO", 63}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceGroupPresentCapabilitiesKHR-pNext-pNext", 52}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentCapabilitiesKHR-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR", 69}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-mode-01298", 43}, { {"If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero", 218}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-mode-01299", 43}, { {"If mode is VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and some physical device in the logical device must include that bit in its VkDeviceGroupPresentCapabilitiesKHR::presentMask", 245}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-mode-01300", 43}, { {"If mode is VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR, then each element of pDeviceMasks must have a value for which all set bits are set in one of the elements of VkDeviceGroupPresentCapabilitiesKHR::presentMask", 210}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-mode-01301", 43}, { {"If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR, then for each bit set in each element of pDeviceMasks, the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero", 217}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-mode-01303", 43}, { {"mode must have exactly one bit set, and that bit must have been included in VkDeviceGroupSwapchainCreateInfoKHR::modes", 118}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-mode-parameter", 47}, { {"mode must be a valid VkDeviceGroupPresentModeFlagBitsKHR value", 62}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-01302", 51}, { {"The value of each element of pDeviceMasks must be equal to the device mask passed in VkAcquireNextImageInfoKHR::deviceMask when the image index was last acquired", 161}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-parameter", 55}, { {"If swapchainCount is not 0, pDeviceMasks must be a valid pointer to an array of swapchainCount uint32_t values", 110}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR", 61}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupPresentInfoKHR-swapchainCount-01297", 53}, { {"swapchainCount must equal 0 or VkPresentInfoKHR::swapchainCount", 63}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00905", 54}, { {"deviceMask must be a valid device mask value", 44}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00906", 54}, { {"deviceMask must not be zero", 27}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00907", 54}, { {"deviceMask must be a subset of the command buffer's initial device mask", 71}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceRenderAreaCount-00908", 65}, { {"deviceRenderAreaCount must either be zero or equal to the number of physical devices in the logical device", 106}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-extent-08998", 50}, { {"The extent.width member of any element of pDeviceRenderAreas must be greater than 0", 83}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-extent-08999", 50}, { {"The extent.height member of any element of pDeviceRenderAreas must be greater than 0", 84}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06166", 50}, { {"The offset.x member of any element of pDeviceRenderAreas must be greater than or equal to 0", 91}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06167", 50}, { {"The offset.y member of any element of pDeviceRenderAreas must be greater than or equal to 0", 91}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06168", 50}, { {"The sum of the offset.x and extent.width members of any element of pDeviceRenderAreas must be less than or equal to maxFramebufferWidth", 135}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06169", 50}, { {"The sum of the offset.y and extent.height members of any element of pDeviceRenderAreas must be less than or equal to maxFramebufferHeight", 137}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas-parameter", 66}, { {"If deviceRenderAreaCount is not 0, pDeviceRenderAreas must be a valid pointer to an array of deviceRenderAreaCount VkRect2D structures", 134}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupRenderPassBeginInfo-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO", 67}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-commandBufferCount-00083", 53}, { {"commandBufferCount must equal VkSubmitInfo::commandBufferCount", 62}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-00086", 60}, { {"All elements of pCommandBufferDeviceMasks must be valid device masks", 68}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-parameter", 64}, { {"If commandBufferCount is not 0, pCommandBufferDeviceMasks must be a valid pointer to an array of commandBufferCount uint32_t values", 131}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices-parameter", 68}, { {"If signalSemaphoreCount is not 0, pSignalSemaphoreDeviceIndices must be a valid pointer to an array of signalSemaphoreCount uint32_t values", 139}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-00085", 62}, { {"All elements of pWaitSemaphoreDeviceIndices and pSignalSemaphoreDeviceIndices must be valid device indices", 106}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-parameter", 66}, { {"If waitSemaphoreCount is not 0, pWaitSemaphoreDeviceIndices must be a valid pointer to an array of waitSemaphoreCount uint32_t values", 133}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO", 56}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-signalSemaphoreCount-00084", 55}, { {"signalSemaphoreCount must equal VkSubmitInfo::signalSemaphoreCount", 66}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSubmitInfo-waitSemaphoreCount-00082", 53}, { {"waitSemaphoreCount must equal VkSubmitInfo::waitSemaphoreCount", 62}, { "chapters/cmdbuffers.html", 24} } },
        { {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-parameter", 56}, { {"modes must be a valid combination of VkDeviceGroupPresentModeFlagBitsKHR values", 79}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-requiredbitmask", 62}, { {"modes must not be 0", 19}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR", 70}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06416", 54}, { {"The pCreateInfo->pNext chain must not contain a VkImageSwapchainCreateInfoKHR structure", 87}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06417", 54}, { {"If pCreateInfo->format specifies a multi-planar format and pCreateInfo->flags has VK_IMAGE_CREATE_DISJOINT_BIT set then planeAspect must not be VK_IMAGE_ASPECT_NONE_KHR", 168}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06419", 54}, { {"If pCreateInfo->flags has VK_IMAGE_CREATE_DISJOINT_BIT set and if the pCreateInfo->tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid multi-planar aspect mask bit", 212}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06420", 54}, { {"If pCreateInfo->tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", 362}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06776", 54}, { {"The pCreateInfo->pNext chain must not contain a VkImageDrmFormatModifierExplicitCreateInfoEXT structure", 103}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-parameter", 58}, { {"pCreateInfo must be a valid pointer to a valid VkImageCreateInfo structure", 74}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pNext-06996", 48}, { {"Applications also must not call vkGetDeviceImageMemoryRequirements with a VkImageCreateInfo whose pNext chain includes a VkExternalFormatANDROID structure with non-zero externalFormat", 183}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pNext-08962", 48}, { {"Applications also must not call vkGetDeviceImageMemoryRequirements with a VkImageCreateInfo whose pNext chain includes a VkExternalFormatQNX structure with non-zero externalFormat", 179}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-pNext-pNext", 48}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-planeAspect-parameter", 58}, { {"If planeAspect is not 0, planeAspect must be a valid VkImageAspectFlagBits value", 80}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageMemoryRequirements-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS", 64}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-arrayLayer-01717", 50}, { {"The arrayLayer member of pSubresource must be less than the arrayLayers specified in pCreateInfo", 96}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-aspectMask-00997", 50}, { {"The aspectMask member of pSubresource must only have a single bit set", 69}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-format-04462", 46}, { {"If format of the pCreateInfo has a depth component, the aspectMask member of pSubresource must contain VK_IMAGE_ASPECT_DEPTH_BIT", 128}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-format-04463", 46}, { {"If format of the pCreateInfo has a stencil component, the aspectMask member of pSubresource must contain VK_IMAGE_ASPECT_STENCIL_BIT", 132}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-format-04464", 46}, { {"If format of the pCreateInfo does not contain a stencil or depth component, the aspectMask member of pSubresource must not contain VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", 187}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-format-08886", 46}, { {"If format of the image is a color format that is not a multi-planar format, and tiling of the pCreateInfo is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, the aspectMask member of pSubresource must be VK_IMAGE_ASPECT_COLOR_BIT", 231}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-mipLevel-01716", 48}, { {"The mipLevel member of pSubresource must be less than the mipLevels specified in pCreateInfo", 92}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-pCreateInfo-parameter", 55}, { {"pCreateInfo must be a valid pointer to a valid VkImageCreateInfo structure", 74}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-pNext-pNext", 45}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-pSubresource-parameter", 56}, { {"pSubresource must be a valid pointer to a valid VkImageSubresource2 structure", 77}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO", 61}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceImageSubresourceInfo-tiling-08717", 46}, { {"If the tiling of the pCreateInfo is VK_IMAGE_TILING_LINEAR and has a multi-planar format, then the aspectMask member of pSubresource must be a single valid multi-planar aspect mask bit", 184}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-03336", 56}, { {"memory must have been allocated with VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT", 74}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-parameter", 60}, { {"memory must be a valid VkDeviceMemory handle", 44}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-pNext-pNext", 55}, { {"pNext must be NULL", 18}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-sType-sType", 55}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO", 73}, { "chapters/memory.html", 20} } },
        { {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior-parameter", 79}, { {"overallocationBehavior must be a valid VkMemoryOverallocationBehaviorAMD value", 78}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-sType-sType", 58}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD", 76}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceMemoryReportCallbackDataEXT-pNext-pNext", 52}, { {"pNext must be NULL", 18}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceMemoryReportCallbackDataEXT-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT", 70}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDevicePipelineBinaryInternalCacheControlKHR-disableInternalCache-09602", 77}, { {"If VkPhysicalDevicePipelineBinaryPropertiesKHR::pipelineBinaryInternalCacheControl is VK_FALSE, disableInternalCache must be VK_FALSE", 133}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDevicePipelineBinaryInternalCacheControlKHR-sType-sType", 62}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR", 81}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDevicePrivateDataCreateInfo-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO", 63}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-flags-02861", 40}, { {"If the protectedMemory feature is not enabled, the VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT bit of flags must not be set", 116}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-flags-06449", 40}, { {"If flags includes VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT, queueFamilyIndex must be the index of a queue family that includes the VK_QUEUE_PROTECTED_BIT capability", 160}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-flags-parameter", 44}, { {"flags must be a valid combination of VkDeviceQueueCreateFlagBits values", 71}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-internallySynchronizedQueues-12348", 63}, { {"If the internallySynchronizedQueues feature is not enabled, flags must not include VK_DEVICE_QUEUE_CREATE_INTERNALLY_SYNCHRONIZED_BIT_KHR", 137}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-pNext-09398", 40}, { {"If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure then VkPhysicalDeviceSchedulingControlsPropertiesARM::schedulingControlsFlags must contain VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM", 235}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-pNext-pNext", 40}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceQueueGlobalPriorityCreateInfo or VkDeviceQueueShaderCoreControlCreateInfoARM", 215}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-00383", 51}, { {"Each element of pQueuePriorities must be between 0.0 and 1.0 inclusive", 70}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-parameter", 55}, { {"pQueuePriorities must be a valid pointer to an array of queueCount float values", 79}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-queueCount-00382", 45}, { {"queueCount must be less than or equal to the queueCount member of the VkQueueFamilyProperties structure, as returned by vkGetPhysicalDeviceQueueFamilyProperties in the pQueueFamilyProperties[queueFamilyIndex]", 208}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-queueCount-arraylength", 51}, { {"queueCount must be greater than 0", 33}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-queueFamilyIndex-00381", 51}, { {"queueFamilyIndex must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties", 113}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO", 56}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueCreateInfo-sType-unique", 41}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueGlobalPriorityCreateInfo-globalPriority-parameter", 67}, { {"globalPriority must be a valid VkQueueGlobalPriority value", 58}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueGlobalPriorityCreateInfo-sType-sType", 54}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO", 72}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueInfo2-flags-06225", 35}, { {"flags must be equal to VkDeviceQueueCreateInfo::flags for a VkDeviceQueueCreateInfo structure for the queue family indicated by queueFamilyIndex when device was created", 168}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueInfo2-flags-parameter", 39}, { {"flags must be a valid combination of VkDeviceQueueCreateFlagBits values", 71}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueInfo2-pNext-pNext", 35}, { {"pNext must be NULL", 18}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueInfo2-queueFamilyIndex-01842", 46}, { {"queueFamilyIndex must be one of the queue family indices specified when device was created, via the VkDeviceQueueCreateInfo structure", 133}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueInfo2-queueIndex-01843", 40}, { {"queueIndex must be less than VkDeviceQueueCreateInfo::queueCount for the corresponding queue family and flags indicated by queueFamilyIndex and flags when device was created", 173}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueInfo2-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2", 51}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueShaderCoreControlCreateInfoARM-sType-sType", 60}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM", 80}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceQueueShaderCoreControlCreateInfoARM-shaderCoreCount-09399", 70}, { {"shaderCoreCount must be greater than 0 and less than or equal to the total number of shader cores as reported via VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM::shaderCoreCount", 178}, { "chapters/devsandqueues.html", 27} } },
        { {"VUID-VkDeviceTensorMemoryRequirementsARM-pCreateInfo-parameter", 62}, { {"pCreateInfo must be a valid pointer to a valid VkTensorCreateInfoARM structure", 78}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceTensorMemoryRequirementsARM-pNext-pNext", 52}, { {"pNext must be NULL", 18}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDeviceTensorMemoryRequirementsARM-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_DEVICE_TENSOR_MEMORY_REQUIREMENTS_ARM", 69}, { "chapters/resources.html", 23} } },
        { {"VUID-VkDirectDriverLoadingInfoLUNARG-flags-zerobitmask", 54}, { {"flags must be 0", 15}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkDirectDriverLoadingInfoLUNARG-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG", 65}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkDirectDriverLoadingListLUNARG-driverCount-arraylength", 60}, { {"driverCount must be greater than 0", 34}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkDirectDriverLoadingListLUNARG-mode-parameter", 51}, { {"mode must be a valid VkDirectDriverLoadingModeLUNARG value", 58}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkDirectDriverLoadingListLUNARG-pDrivers-parameter", 55}, { {"pDrivers must be a valid pointer to an array of driverCount valid VkDirectDriverLoadingInfoLUNARG structures", 108}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkDirectDriverLoadingListLUNARG-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG", 65}, { "chapters/initialization.html", 28} } },
        { {"VUID-VkDirectFBSurfaceCreateInfoEXT-dfb-04117", 45}, { {"dfb must point to a valid DirectFB IDirectFB", 44}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDirectFBSurfaceCreateInfoEXT-flags-zerobitmask", 53}, { {"flags must be 0", 15}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDirectFBSurfaceCreateInfoEXT-pNext-pNext", 47}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDirectFBSurfaceCreateInfoEXT-sType-sType", 47}, { {"sType must be VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT", 64}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDirectFBSurfaceCreateInfoEXT-surface-04118", 49}, { {"surface must point to a valid DirectFB IDirectFBSurface", 55}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDispatchGraphInfoAMDX-payloadCount-09171", 47}, { {"payloadCount must be no greater than maxExecutionGraphShaderPayloadCount", 72}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkDispatchIndirectCommand-x-00417", 38}, { {"x must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0]", 83}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkDispatchIndirectCommand-y-00418", 38}, { {"y must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1]", 83}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkDispatchIndirectCommand-z-00419", 38}, { {"z must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2]", 83}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkDispatchTileInfoQCOM-pNext-pNext", 39}, { {"pNext must be NULL", 18}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkDispatchTileInfoQCOM-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_DISPATCH_TILE_INFO_QCOM", 55}, { "chapters/dispatch.html", 22} } },
        { {"VUID-VkDisplayEventInfoEXT-displayEvent-parameter", 49}, { {"displayEvent must be a valid VkDisplayEventTypeEXT value", 56}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDisplayEventInfoEXT-pNext-pNext", 38}, { {"pNext must be NULL", 18}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDisplayEventInfoEXT-sType-sType", 38}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT", 54}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkDisplayModeCreateInfoKHR-flags-zerobitmask", 49}, { {"flags must be 0", 15}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeCreateInfoKHR-pNext-pNext", 43}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeCreateInfoKHR-parameters-parameter", 52}, { {"parameters must be a valid VkDisplayModeParametersKHR structure", 63}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeCreateInfoKHR-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR", 60}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeParametersKHR-height-01991", 44}, { {"The height member of visibleRegion must be greater than 0", 57}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeParametersKHR-refreshRate-01992", 49}, { {"refreshRate must be greater than 0", 34}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeParametersKHR-width-01990", 43}, { {"The width member of visibleRegion must be greater than 0", 56}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeProperties2KHR-pNext-pNext", 44}, { {"pNext must be NULL or a pointer to a valid instance of VkDisplayModeStereoPropertiesNV", 86}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeProperties2KHR-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR", 61}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeProperties2KHR-sType-unique", 45}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayModeStereoPropertiesNV-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_STEREO_PROPERTIES_NV", 65}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType-sType", 57}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD", 75}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPlaneCapabilities2KHR-pNext-pNext", 47}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPlaneCapabilities2KHR-sType-sType", 47}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR", 64}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPlaneInfo2KHR-mode-parameter", 42}, { {"mode must be a valid VkDisplayModeKHR handle", 44}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPlaneInfo2KHR-pNext-pNext", 39}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPlaneInfo2KHR-sType-sType", 39}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR", 56}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPlaneProperties2KHR-pNext-pNext", 45}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPlaneProperties2KHR-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR", 62}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPowerInfoEXT-pNext-pNext", 38}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPowerInfoEXT-powerState-parameter", 47}, { {"powerState must be a valid VkDisplayPowerStateEXT value", 55}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPowerInfoEXT-sType-sType", 38}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT", 54}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPresentInfoKHR-dstRect-01258", 42}, { {"dstRect must specify a rectangular region that is a subset of the visibleRegion parameter of the display mode the swapchain being presented uses", 144}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPresentInfoKHR-persistentContent-01259", 52}, { {"If the persistentContent member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display the present operation targets is VK_FALSE, then persistent must be VK_FALSE", 215}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPresentInfoKHR-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR", 56}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayPresentInfoKHR-srcRect-01257", 42}, { {"srcRect must specify a rectangular region that is a subset of the image being presented", 87}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayProperties2KHR-pNext-pNext", 40}, { {"pNext must be NULL", 18}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplayProperties2KHR-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR", 56}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01254", 50}, { {"If alphaMode is VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR then globalAlpha must be between 0 and 1, inclusive", 105}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01255", 50}, { {"alphaMode must be one of the bits present in the supportedAlpha member of VkDisplayPlaneCapabilitiesKHR for the display plane corresponding to displayMode", 154}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-parameter", 54}, { {"alphaMode must be a valid VkDisplayPlaneAlphaFlagBitsKHR value", 62}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-displayMode-parameter", 56}, { {"displayMode must be a valid VkDisplayModeKHR handle", 51}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-flags-zerobitmask", 52}, { {"flags must be 0", 15}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-pNext-10284", 46}, { {"If the pNext chain includes a VkDisplaySurfaceStereoCreateInfoNV structure whose stereoType member is VK_DISPLAY_SURFACE_STEREO_TYPE_HDMI_3D_NV, then the hdmi3DSupported member of the VkDisplayModeStereoPropertiesNV structure in the pNext chain of the VkDisplayModeProperties2KHR structure returned by vkGetDisplayModeProperties2KHR for the display mode corresponding to displayMode must be VK_TRUE", 398}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-pNext-pNext", 46}, { {"pNext must be NULL or a pointer to a valid instance of VkDisplaySurfaceStereoCreateInfoNV", 89}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-planeIndex-01252", 51}, { {"planeIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR", 151}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-planeReorderPossible-01253", 61}, { {"If the planeReorderPossible member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display corresponding to displayMode is VK_TRUE then planeStackIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR; otherwise planeStackIndex must equal the currentStackIndex member of VkDisplayPlanePropertiesKHR returned by vkGetPhysicalDeviceDisplayPlanePropertiesKHR for the display plane corresponding to displayMode", 550}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR", 63}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-sType-unique", 47}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-transform-06740", 50}, { {"transform must be one of the bits present in the supportedTransforms member of VkDisplayPropertiesKHR for the display corresponding to displayMode", 146}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-transform-parameter", 54}, { {"transform must be a valid VkSurfaceTransformFlagBitsKHR value", 61}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceCreateInfoKHR-width-01256", 46}, { {"The width and height members of imageExtent must be less than or equal to VkPhysicalDeviceLimits::maxImageDimension2D", 117}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceStereoCreateInfoNV-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_DISPLAY_SURFACE_STEREO_CREATE_INFO_NV", 69}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDisplaySurfaceStereoCreateInfoNV-stereoType-parameter", 60}, { {"stereoType must be a valid VkDisplaySurfaceStereoTypeNV value", 61}, { "chapters/VK_KHR_surface/wsi.html", 32} } },
        { {"VUID-VkDrawIndexedIndirectCommand-None-09462", 44}, { {"If shader objects are used for drawing or the bound graphics pipeline state was created with the VK_DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state enabled, any member of the pVertexBindingDescriptions parameter to the vkCmdSetVertexInputEXT call that sets this dynamic state has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorProperties::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", 434}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawIndexedIndirectCommand-firstInstance-00554", 53}, { {"If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0", 80}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawIndexedIndirectCommand-pNext-09461", 45}, { {"If the bound graphics pipeline state was created with VkPipelineVertexInputDivisorStateCreateInfo in the pNext chain of VkGraphicsPipelineCreateInfo::pVertexInputState, any member of VkPipelineVertexInputDivisorStateCreateInfo::pVertexBindingDivisors has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorProperties::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", 412}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawIndexedIndirectCommand-robustBufferAccess2-08798", 59}, { {"If the robustBufferAccess2 feature is not enabled, (indexSize x (firstIndex + indexCount) + offset) must be less than or equal to the size of the bound index buffer, with indexSize being based on the type specified by indexType, where the index buffer, indexType, and offset are specified via vkCmdBindIndexBuffer or vkCmdBindIndexBuffer2. If vkCmdBindIndexBuffer2 is used to bind the index buffer, the size of the bound index buffer is vkCmdBindIndexBuffer2::size", 464}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawIndirectCommand-None-09462", 37}, { {"If shader objects are used for drawing or the bound graphics pipeline state was created with the VK_DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state enabled, any member of the pVertexBindingDescriptions parameter to the vkCmdSetVertexInputEXT call that sets this dynamic state has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorProperties::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", 434}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawIndirectCommand-firstInstance-00501", 46}, { {"If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0", 80}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawIndirectCommand-pNext-09461", 38}, { {"If the bound graphics pipeline state was created with VkPipelineVertexInputDivisorStateCreateInfo in the pNext chain of VkGraphicsPipelineCreateInfo::pVertexInputState, any member of VkPipelineVertexInputDivisorStateCreateInfo::pVertexBindingDivisors has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorProperties::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", 412}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawIndirectCountIndirectCommandEXT-None-11122", 53}, { {"The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", 117}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkDrawIndirectCountIndirectCommandEXT-bufferAddress-parameter", 66}, { {"bufferAddress must be a valid VkDeviceAddress value", 51}, { "chapters/device_generated_commands/generatedcommands.html", 57} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07322", 52}, { {"If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountX must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[0]", 225}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07323", 52}, { {"If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountY must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[1]", 225}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07324", 52}, { {"If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[2]", 225}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07325", 52}, { {"If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, The product of groupCountX, groupCountY and groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupTotalCount", 271}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07326", 52}, { {"If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountX must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[0]", 233}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07327", 52}, { {"If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountY must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[1]", 233}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07328", 52}, { {"If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[2]", 233}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07329", 52}, { {"If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, The product of groupCountX, groupCountY and groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupTotalCount", 279}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrawMeshTasksIndirectCommandNV-taskCount-02175", 53}, { {"taskCount must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxDrawMeshTasksCount", 101}, { "chapters/drawing.html", 21} } },
        { {"VUID-VkDrmFormatModifierPropertiesList2EXT-sType-sType", 54}, { {"sType must be VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT", 73}, { "chapters/formats.html", 21} } },
        { {"VUID-VkDrmFormatModifierPropertiesListEXT-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT", 71}, { "chapters/formats.html", 21} } },
        { {"VUID-VkEventCreateInfo-flags-parameter", 38}, { {"flags must be a valid combination of VkEventCreateFlagBits values", 65}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkEventCreateInfo-pNext-06790", 34}, { {"If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT", 164}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkEventCreateInfo-pNext-pNext", 34}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportMetalObjectCreateInfoEXT or VkImportMetalSharedEventInfoEXT", 198}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkEventCreateInfo-sType-sType", 34}, { {"sType must be VK_STRUCTURE_TYPE_EVENT_CREATE_INFO", 49}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkEventCreateInfo-sType-unique", 35}, { {"The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT", 142}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-CoalescedInputCountAMDX-09137", 73}, { {"There must be no two nodes in the pipeline that share the same name where one includes CoalescedInputCountAMDX and the other does not", 133}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09134", 54}, { {"There must be no two nodes in the pipeline that share both the same shader name and index, as specified by VkPipelineShaderStageNodeCreateInfoAMDX", 146}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09135", 54}, { {"There must be no two nodes in the pipeline that share the same shader name and have input payload declarations with different sizes", 131}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09136", 54}, { {"There must be no two nodes in the pipeline that share the same name but have different execution models", 103}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09497", 54}, { {"If the pNext chain does not include a VkPipelineCreateFlags2CreateInfo structure, flags must be a valid combination of VkPipelineCreateFlagBits values", 150}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-10391", 54}, { {"If a resource variables is declared in a shader as an array of descriptors, then the descriptor type of that variable must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", 169}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-11363", 54}, { {"If VkPipelineCreateFlags2CreateInfoKHR::flags does not include VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT, layout must not be VK_NULL_HANDLE", 142}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-PayloadNodeNameAMDX-09139", 69}, { {"If an output payload declared in any shader in the pipeline has a PayloadNodeNameAMDX decoration with a Node Name that matches the shader name of any other node in the graph, the size of the output payload must match the size of the input payload in the matching node", 267}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-StaticNumWorkgroupsAMDX-09138", 73}, { {"There must be no two nodes in the pipeline that share the same name where one includes StaticNumWorkgroupsAMDX and the other does not", 133}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-commonparent", 56}, { {"Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 158}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03365", 55}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", 85}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03366", 55}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", 89}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03367", 55}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", 82}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03368", 55}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", 90}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03369", 55}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", 76}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03370", 55}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", 72}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03576", 55}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", 96}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-04945", 55}, { {"flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", 73}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07369", 55}, { {"flags must not include both VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT and VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT", 119}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07984", 55}, { {"If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid execution graph VkPipeline handle", 159}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07985", 55}, { {"If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", 193}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07986", 55}, { {"If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, basePipelineIndex must be -1 or basePipelineHandle must be VK_NULL_HANDLE", 135}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-09007", 55}, { {"If the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature is not enabled, flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", 187}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-09008", 55}, { {"If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the pNext chain must include a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV specifying the address where the pipeline's metadata will be saved", 234}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-10184", 55}, { {"If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, and an output payload declared in any shader in the pipeline does not have a PayloadNodeSparseArrayAMDX decoration, there must be a node in the graph corresponding to every index from 0 to its PayloadNodeArraySizeAMDX decoration", 290}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-11007", 55}, { {"If flags includes VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then the VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT::deviceGeneratedCommands feature must be enabled", 174}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-11271", 55}, { {"If VkPipelineCreateFlags2CreateInfoKHR::flags includes VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT, all libraries linked to this pipeline must also have that flag set", 167}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-11272", 55}, { {"If VkPipelineCreateFlags2CreateInfoKHR::flags does not include VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT, all libraries linked to this pipeline must also not have that flag set", 179}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-11311", 55}, { {"If VkPipelineCreateFlags2CreateInfoKHR::flags includes VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT, layout must be VK_NULL_HANDLE", 130}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-11312", 55}, { {"If VkPipelineCreateFlags2CreateInfoKHR::flags includes VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT, all shader variables in the shader resource interface with a DescriptorSet and Binding decoration must have a mapping declared in VkShaderDescriptorSetAndBindingMappingInfoEXT::pMappings", 287}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-11798", 55}, { {"If shader64BitIndexing feature is not enabled, flags must not contain VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT", 114}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-12334", 55}, { {"flags must not include VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT nor VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT", 114}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07987", 56}, { {"If a push constant block is declared in a shader and layout is not VK_NULL_HANDLE, a push constant range in layout must match the shader stage", 142}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07988", 56}, { {"If a resource variable is declared in a shader and layout is not VK_NULL_HANDLE, the corresponding descriptor set in layout must match the shader stage", 151}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07990", 56}, { {"If a resource variable is declared in a shader, layout is not VK_NULL_HANDLE, and the descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in layout must match the descriptor type", 214}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07991", 56}, { {"If a resource variable is declared in a shader as an array and layout is not VK_NULL_HANDLE, the corresponding descriptor binding used to create layout must have a descriptorCount that is greater than or equal to the length of the array", 236}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-09130", 56}, { {"If layout is not VK_NULL_HANDLE, it must be consistent with the layout of the shaders specified in pStages", 106}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-09132", 56}, { {"If layout is not VK_NULL_HANDLE, the number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", 202}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-10069", 56}, { {"If a push constant block is declared in a shader and layout is not VK_NULL_HANDLE, the block must be contained inside the push constant range in layout that matches the stage", 174}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-parameter", 60}, { {"If layout is not VK_NULL_HANDLE, layout must be a valid VkPipelineLayout handle", 79}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-09131", 62}, { {"If pLibraryInfo is not NULL and layout is not VK_NULL_HANDLE, each element of pLibraryInfo->pLibraries must have been created with a layout that is compatible with the layout in this pipeline", 191}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-09133", 62}, { {"If pLibraryInfo is not NULL, each element of pLibraryInfo->pLibraries must be either a compute pipeline, an execution graph pipeline, or a graphics pipeline", 156}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-10181", 62}, { {"If pLibraryInfo is not NULL, each element of pLibraryInfo->pLibraries that is a compute pipeline or a graphics pipeline must have been created with VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX set", 197}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-10183", 62}, { {"Any element of pLibraryInfo->pLibraries identifying a graphics pipeline must have been created with all possible state subsets", 126}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-parameter", 66}, { {"If pLibraryInfo is not NULL, pLibraryInfo must be a valid pointer to a valid VkPipelineLibraryCreateInfoKHR structure", 117}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pNext-pNext", 55}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineCompilerControlCreateInfoAMD or VkPipelineCreationFeedbackCreateInfo", 209}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pStages-09129", 57}, { {"The shader code for the entry point identified by each element of pStages and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", 213}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pStages-parameter", 61}, { {"If stageCount is not 0, and pStages is not NULL, pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", 155}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pipelineCreationCacheControl-02878", 78}, { {"If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT nor VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT", 190}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pipelineProtectedAccess-07368", 73}, { {"If the pipelineProtectedAccess feature is not enabled, flags must not include VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT nor VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT", 169}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-sType-sType", 55}, { {"sType must be VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX", 73}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-sType-unique", 56}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-shaderMeshEnqueue-10182", 67}, { {"If the shaderMeshEnqueue feature is not enabled, and pLibraryInfo->pLibraries is not NULL, pLibraryInfo->pLibraries must not contain any graphics pipelines", 155}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-stage-09128", 55}, { {"The stage member of any element of pStages must be VK_SHADER_STAGE_COMPUTE_BIT", 78}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExecutionGraphPipelineScratchSizeAMDX-sType-sType", 56}, { {"sType must be VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX", 74}, { "chapters/executiongraphs.html", 29} } },
        { {"VUID-VkExportFenceCreateInfo-handleTypes-01446", 46}, { {"The bits in handleTypes must be supported and compatible, as reported by VkExternalFenceProperties", 98}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportFenceCreateInfo-handleTypes-parameter", 50}, { {"handleTypes must be a valid combination of VkExternalFenceHandleTypeFlagBits values", 83}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportFenceCreateInfo-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO", 56}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportFenceWin32HandleInfoKHR-handleTypes-01447", 54}, { {"If VkExportFenceCreateInfo::handleTypes does not include VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, a VkExportFenceWin32HandleInfoKHR structure must not be included in the pNext chain of VkFenceCreateInfo", 209}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportFenceWin32HandleInfoKHR-pAttributes-parameter", 58}, { {"If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", 100}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportFenceWin32HandleInfoKHR-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR", 66}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportMemoryAllocateInfo-handleTypes-09860", 49}, { {"The bits in handleTypes must be supported and compatible, as reported by VkExternalTensorPropertiesARM, VkExternalImageFormatProperties, or VkExternalBufferProperties", 166}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryAllocateInfo-handleTypes-parameter", 53}, { {"handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", 84}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryAllocateInfo-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO", 59}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryAllocateInfoNV-handleTypes-parameter", 55}, { {"handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", 86}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryAllocateInfoNV-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV", 62}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryWin32HandleInfoKHR-handleTypes-00657", 55}, { {"If VkExportMemoryAllocateInfo::handleTypes does not include VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, a VkExportMemoryWin32HandleInfoKHR structure must not be included in the pNext chain of VkMemoryAllocateInfo", 217}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryWin32HandleInfoKHR-pAttributes-parameter", 59}, { {"If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", 100}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryWin32HandleInfoKHR-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR", 67}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryWin32HandleInfoNV-pAttributes-parameter", 58}, { {"If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", 100}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMemoryWin32HandleInfoNV-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV", 66}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalBufferInfoEXT-memory-parameter", 48}, { {"memory must be a valid VkDeviceMemory handle", 44}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalBufferInfoEXT-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT", 60}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalCommandQueueInfoEXT-queue-parameter", 53}, { {"queue must be a valid VkQueue handle", 36}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalCommandQueueInfoEXT-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT", 67}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalDeviceInfoEXT-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT", 60}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalIOSurfaceInfoEXT-image-parameter", 50}, { {"image must be a valid VkImage handle", 36}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalIOSurfaceInfoEXT-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT", 64}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectCreateInfoEXT-exportObjectType-parameter", 64}, { {"If exportObjectType is not 0, exportObjectType must be a valid VkExportMetalObjectTypeFlagBitsEXT value", 103}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectCreateInfoEXT-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT", 67}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06791", 44}, { {"If the pNext chain includes a VkExportMetalDeviceInfoEXT structure, the VkInstance must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkInstanceCreateInfo structure in the vkCreateInstance command", 327}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06792", 44}, { {"If the pNext chain includes a VkExportMetalCommandQueueInfoEXT structure, the VkInstance must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkInstanceCreateInfo structure in the vkCreateInstance command", 340}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06793", 44}, { {"If the pNext chain includes a VkExportMetalBufferInfoEXT structure, the VkDeviceMemory in its memory member must have been allocated with VK_EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkMemoryAllocateInfo structure in the vkAllocateMemory command", 354}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06794", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, exactly one of its image, imageView, or bufferView members must not be VK_NULL_HANDLE", 154}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06795", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its image member is not VK_NULL_HANDLE, the VkImage in its image member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageCreateInfo structure in the vkCreateImage command", 384}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06796", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its imageView member is not VK_NULL_HANDLE, the VkImageView in its imageView member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageViewCreateInfo structure in the vkCreateImageView command", 404}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06797", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its bufferView member is not VK_NULL_HANDLE, the VkBufferView in its bufferView member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkBufferViewCreateInfo structure in the vkCreateBufferView command", 409}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06798", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if either its image or imageView member is not VK_NULL_HANDLE, then plane must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT", 243}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06799", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImage in its image member does not have a multi-planar format, then its plane member must be VK_IMAGE_ASPECT_PLANE_0_BIT", 202}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06800", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImage in its image member has a multi-planar format with only two planes, then its plane member must not be VK_IMAGE_ASPECT_PLANE_2_BIT", 217}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06801", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImageView in its imageView member does not have a multi-planar format, then its plane member must be VK_IMAGE_ASPECT_PLANE_0_BIT", 210}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06802", 44}, { {"If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImageView in its imageView member has a multi-planar format with only two planes, then its plane member must not be VK_IMAGE_ASPECT_PLANE_2_BIT", 225}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06803", 44}, { {"If the pNext chain includes a VkExportMetalIOSurfaceInfoEXT structure, the VkImage in its image member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageCreateInfo structure in the vkCreateImage command", 344}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06804", 44}, { {"If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, exactly one of its semaphore or event members must not be VK_NULL_HANDLE", 145}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06805", 44}, { {"If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, and its semaphore member is not VK_NULL_HANDLE, the VkSemaphore in its semaphore member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkSemaphoreCreateInfo structure in the vkCreateSemaphore command", 413}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-06806", 44}, { {"If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, and its event member is not VK_NULL_HANDLE, the VkEvent in its event member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkEventCreateInfo structure in the vkCreateEvent command", 393}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-pNext-pNext", 44}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportMetalBufferInfoEXT, VkExportMetalCommandQueueInfoEXT, VkExportMetalDeviceInfoEXT, VkExportMetalIOSurfaceInfoEXT, VkExportMetalSharedEventInfoEXT, or VkExportMetalTextureInfoEXT", 315}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT", 61}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalObjectsInfoEXT-sType-unique", 45}, { {"The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkExportMetalBufferInfoEXT, VkExportMetalCommandQueueInfoEXT, VkExportMetalIOSurfaceInfoEXT, VkExportMetalSharedEventInfoEXT, or VkExportMetalTextureInfoEXT", 266}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalSharedEventInfoEXT-commonparent", 49}, { {"Both of event, and semaphore that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 148}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalSharedEventInfoEXT-event-parameter", 52}, { {"If event is not VK_NULL_HANDLE, event must be a valid VkEvent handle", 68}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalSharedEventInfoEXT-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT", 66}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalSharedEventInfoEXT-semaphore-parameter", 56}, { {"If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle", 80}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalTextureInfoEXT-bufferView-parameter", 53}, { {"If bufferView is not VK_NULL_HANDLE, bufferView must be a valid VkBufferView handle", 83}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalTextureInfoEXT-commonparent", 45}, { {"Each of bufferView, image, and imageView that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 160}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalTextureInfoEXT-image-parameter", 48}, { {"If image is not VK_NULL_HANDLE, image must be a valid VkImage handle", 68}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalTextureInfoEXT-imageView-parameter", 52}, { {"If imageView is not VK_NULL_HANDLE, imageView must be a valid VkImageView handle", 80}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalTextureInfoEXT-plane-parameter", 48}, { {"plane must be a valid VkImageAspectFlagBits value", 49}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportMetalTextureInfoEXT-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT", 61}, { "chapters/memory.html", 20} } },
        { {"VUID-VkExportSemaphoreCreateInfo-handleTypes-01124", 50}, { {"The bits in handleTypes must be supported and compatible, as reported by VkExternalSemaphoreProperties", 102}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportSemaphoreCreateInfo-handleTypes-parameter", 54}, { {"handleTypes must be a valid combination of VkExternalSemaphoreHandleTypeFlagBits values", 87}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportSemaphoreCreateInfo-sType-sType", 44}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO", 60}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportSemaphoreWin32HandleInfoKHR-handleTypes-01125", 58}, { {"If VkExportSemaphoreCreateInfo::handleTypes does not include VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, VkExportSemaphoreWin32HandleInfoKHR must not be included in the pNext chain of VkSemaphoreCreateInfo", 266}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportSemaphoreWin32HandleInfoKHR-pAttributes-parameter", 62}, { {"If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", 100}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExportSemaphoreWin32HandleInfoKHR-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR", 70}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExternalBufferProperties-pNext-pNext", 43}, { {"pNext must be NULL", 18}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalBufferProperties-sType-sType", 43}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES", 58}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalComputeQueueCreateInfoNV-pNext-pNext", 51}, { {"pNext must be NULL", 18}, { "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html", 71} } },
        { {"VUID-VkExternalComputeQueueCreateInfoNV-preferredQueue-parameter", 64}, { {"preferredQueue must be a valid VkQueue handle", 45}, { "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html", 71} } },
        { {"VUID-VkExternalComputeQueueCreateInfoNV-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_CREATE_INFO_NV", 69}, { "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html", 71} } },
        { {"VUID-VkExternalComputeQueueDataParamsNV-pNext-pNext", 51}, { {"pNext must be NULL", 18}, { "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html", 71} } },
        { {"VUID-VkExternalComputeQueueDataParamsNV-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DATA_PARAMS_NV", 69}, { "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html", 71} } },
        { {"VUID-VkExternalComputeQueueDeviceCreateInfoNV-sType-sType", 57}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DEVICE_CREATE_INFO_NV", 76}, { "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html", 71} } },
        { {"VUID-VkExternalFenceProperties-pNext-pNext", 42}, { {"pNext must be NULL", 18}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalFenceProperties-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES", 57}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalFormatANDROID-externalFormat-01894", 49}, { {"externalFormat must be 0 or a value returned in the externalFormat member of VkAndroidHardwareBufferFormatPropertiesANDROID by an earlier call to vkGetAndroidHardwareBufferPropertiesANDROID", 189}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalFormatANDROID-sType-sType", 40}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID", 55}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalFormatOHOS-sType-sType", 37}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_OHOS", 52}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalFormatQNX-externalFormat-08956", 45}, { {"externalFormat must be 0 or a value returned in the externalFormat member of VkScreenBufferFormatPropertiesQNX by an earlier call to vkGetScreenBufferPropertiesQNX", 163}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalFormatQNX-sType-sType", 36}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX", 51}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalImageFormatProperties-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES", 64}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalMemoryAcquireUnmodifiedEXT-acquireUnmodifiedMemory-08922", 71}, { {"If acquireUnmodifiedMemory is VK_TRUE, and the memory barrier's srcQueueFamilyIndex is a special queue family reserved for external memory ownership transfers (as described in Queue Family Ownership Transfer), then each range of VkDeviceMemory bound to the resource must have remained unmodified during all time since the resource's most recent release of ownership to the queue family", 385}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExternalMemoryAcquireUnmodifiedEXT-sType-sType", 53}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT", 70}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkExternalMemoryBufferCreateInfo-handleTypes-parameter", 59}, { {"handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", 84}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalMemoryBufferCreateInfo-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO", 66}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalMemoryImageCreateInfo-handleTypes-parameter", 58}, { {"handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", 84}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalMemoryImageCreateInfo-sType-sType", 48}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO", 65}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalMemoryImageCreateInfoNV-handleTypes-parameter", 60}, { {"handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", 86}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalMemoryImageCreateInfoNV-sType-sType", 50}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV", 68}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalMemoryTensorCreateInfoARM-handleTypes-parameter", 62}, { {"handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", 84}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalMemoryTensorCreateInfoARM-sType-sType", 52}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_TENSOR_CREATE_INFO_ARM", 70}, { "chapters/resources.html", 23} } },
        { {"VUID-VkExternalSemaphoreProperties-pNext-pNext", 46}, { {"pNext must be NULL", 18}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalSemaphoreProperties-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES", 61}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalTensorPropertiesARM-externalMemoryProperties-parameter", 69}, { {"externalMemoryProperties must be a valid VkExternalMemoryProperties structure", 77}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalTensorPropertiesARM-pNext-pNext", 46}, { {"pNext must be NULL", 18}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkExternalTensorPropertiesARM-sType-sType", 46}, { {"sType must be VK_STRUCTURE_TYPE_EXTERNAL_TENSOR_PROPERTIES_ARM", 62}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkFenceCreateInfo-flags-parameter", 38}, { {"flags must be a valid combination of VkFenceCreateFlagBits values", 65}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceCreateInfo-pNext-pNext", 34}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportFenceCreateInfo or VkExportFenceWin32HandleInfoKHR", 189}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceCreateInfo-sType-sType", 34}, { {"sType must be VK_STRUCTURE_TYPE_FENCE_CREATE_INFO", 49}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceCreateInfo-sType-unique", 35}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetFdInfoKHR-fence-01455", 36}, { {"fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType", 251}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetFdInfoKHR-fence-parameter", 40}, { {"fence must be a valid VkFence handle", 36}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetFdInfoKHR-handleType-01453", 41}, { {"handleType must have been included in VkExportFenceCreateInfo::handleTypes when fence's current payload was created", 115}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetFdInfoKHR-handleType-01454", 41}, { {"If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution", 166}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetFdInfoKHR-handleType-01456", 41}, { {"handleType must be defined as a POSIX file descriptor handle", 60}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetFdInfoKHR-handleType-parameter", 45}, { {"handleType must be a valid VkExternalFenceHandleTypeFlagBits value", 66}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetFdInfoKHR-pNext-pNext", 36}, { {"pNext must be NULL", 18}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetFdInfoKHR-sType-sType", 36}, { {"sType must be VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR", 53}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-fence-01450", 45}, { {"fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType", 251}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-fence-parameter", 49}, { {"fence must be a valid VkFence handle", 36}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01448", 50}, { {"handleType must have been included in VkExportFenceCreateInfo::handleTypes when the fence's current payload was created", 119}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01449", 50}, { {"If handleType is defined as an NT handle, vkGetFenceWin32HandleKHR must be called no more than once for each valid unique combination of fence and handleType", 157}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01451", 50}, { {"If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution", 166}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01452", 50}, { {"handleType must be defined as an NT handle or a global share handle", 67}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-parameter", 54}, { {"handleType must be a valid VkExternalFenceHandleTypeFlagBits value", 66}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-pNext-pNext", 45}, { {"pNext must be NULL", 18}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFenceGetWin32HandleInfoKHR-sType-sType", 45}, { {"sType must be VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR", 63}, { "chapters/synchronization.html", 29} } },
        { {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-pNext-02627", 63}, { {"If the pNext chain of the VkImageFormatProperties2 structure includes a VkFilterCubicImageViewImageFormatPropertiesEXT structure, the pNext chain of the VkPhysicalDeviceImageFormatInfo2 structure must include a VkPhysicalDeviceImageViewImageFormatInfoEXT structure with an imageViewType that is compatible with imageType", 320}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-sType-sType", 63}, { {"sType must be VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT", 83}, { "chapters/capabilities.html", 26} } },
        { {"VUID-VkFormatProperties2-pNext-pNext", 36}, { {"Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDrmFormatModifierPropertiesList2EXT, VkDrmFormatModifierPropertiesListEXT, VkFormatProperties3, VkSubpassResolvePerformanceQueryEXT, or VkTensorFormatPropertiesARM", 296}, { "chapters/formats.html", 21} } },
        { {"VUID-VkFormatProperties2-sType-sType", 36}, { {"sType must be VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2", 51}, { "chapters/formats.html", 21} } },
        { {"VUID-VkFormatProperties2-sType-unique", 37}, { {"The sType value of each structure in the pNext chain must be unique", 67}, { "chapters/formats.html", 21} } },
        { {"VUID-VkFormatProperties3-sType-sType", 36}, { {"sType must be VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3", 51}, { "chapters/formats.html", 21} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04524", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, its layout member must be equal to VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR", 223}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04525", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be a power of two value", 166}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04526", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be less than or equal to maxFragmentShadingRateAttachmentTexelSize.width", 215}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04527", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be greater than or equal to minFragmentShadingRateAttachmentTexelSize.width", 218}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04528", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be a power of two value", 167}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04529", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be less than or equal to maxFragmentShadingRateAttachmentTexelSize.height", 217}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04530", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be greater than or equal to minFragmentShadingRateAttachmentTexelSize.height", 220}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04531", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, the quotient of shadingRateAttachmentTexelSize.width and shadingRateAttachmentTexelSize.height must be less than or equal to maxFragmentShadingRateAttachmentTexelSizeAspectRatio", 278}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04532", 80}, { {"If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, the quotient of shadingRateAttachmentTexelSize.height and shadingRateAttachmentTexelSize.width must be less than or equal to maxFragmentShadingRateAttachmentTexelSizeAspectRatio", 278}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-parameter", 84}, { {"If pFragmentShadingRateAttachment is not NULL, pFragmentShadingRateAttachment must be a valid pointer to a valid VkAttachmentReference2 structure", 145}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFragmentShadingRateAttachmentInfoKHR-sType-sType", 55}, { {"sType must be VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR", 73}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFrameBoundaryEXT-commonparent", 36}, { {"Both of the elements of pBuffers, and the elements of pImages that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 181}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFrameBoundaryEXT-flags-parameter", 39}, { {"flags must be a valid combination of VkFrameBoundaryFlagBitsEXT values", 70}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFrameBoundaryEXT-pBuffers-parameter", 42}, { {"If bufferCount is not 0, and pBuffers is not NULL, pBuffers must be a valid pointer to an array of bufferCount valid VkBuffer handles", 133}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFrameBoundaryEXT-pImages-parameter", 41}, { {"If imageCount is not 0, and pImages is not NULL, pImages must be a valid pointer to an array of imageCount valid VkImage handles", 128}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFrameBoundaryEXT-pTag-parameter", 38}, { {"If tagSize is not 0, and pTag is not NULL, pTag must be a valid pointer to an array of tagSize bytes", 100}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFrameBoundaryEXT-sType-sType", 35}, { {"sType must be VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT", 50}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFrameBoundaryTensorsARM-pTensors-parameter", 49}, { {"pTensors must be a valid pointer to an array of tensorCount valid VkTensorARM handles", 85}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFrameBoundaryTensorsARM-sType-sType", 42}, { {"sType must be VK_STRUCTURE_TYPE_FRAME_BOUNDARY_TENSORS_ARM", 58}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFrameBoundaryTensorsARM-tensorCount-arraylength", 54}, { {"tensorCount must be greater than 0", 34}, { "chapters/debugging.html", 23} } },
        { {"VUID-VkFramebufferAttachmentImageInfo-flags-parameter", 53}, { {"flags must be a valid combination of VkImageCreateFlagBits values", 65}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferAttachmentImageInfo-pNext-pNext", 49}, { {"pNext must be NULL", 18}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferAttachmentImageInfo-pViewFormats-parameter", 60}, { {"If viewFormatCount is not 0, pViewFormats must be a valid pointer to an array of viewFormatCount valid VkFormat values", 118}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferAttachmentImageInfo-sType-sType", 49}, { {"sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO", 65}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferAttachmentImageInfo-usage-parameter", 53}, { {"usage must be a valid combination of VkImageUsageFlagBits values", 64}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferAttachmentImageInfo-usage-requiredbitmask", 59}, { {"usage must not be 0", 19}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferAttachmentImageInfo-viewFormatCount-09536", 59}, { {"If viewFormatCount is not 0, and the render pass is not being used with an external format resolve attachment, each element of pViewFormats must not be VK_FORMAT_UNDEFINED", 171}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos-parameter", 71}, { {"If attachmentImageInfoCount is not 0, pAttachmentImageInfos must be a valid pointer to an array of attachmentImageInfoCount valid VkFramebufferAttachmentImageInfo structures", 173}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferAttachmentsCreateInfo-sType-sType", 51}, { {"sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO", 67}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-attachmentCount-00876", 50}, { {"attachmentCount must be equal to the attachment count specified in renderPass", 77}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-commonparent", 41}, { {"Both of renderPass, and the elements of pAttachments that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", 172}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-02778", 40}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT and attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkImageView handles", 185}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03189", 40}, { {"If the imagelessFramebuffer feature is not enabled, flags must not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT", 110}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03190", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the pNext chain must include a VkFramebufferAttachmentsCreateInfo structure", 130}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03191", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the attachmentImageInfoCount member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain must be equal to either zero or attachmentCount", 207}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03196", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of width/maxFragmentDensityTexelSize.width", 389}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03197", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of height/maxFragmentDensityTexelSize.height", 401}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03201", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a color attachment or resolve attachment by renderPass must include VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", 341}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03202", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", 335}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03203", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil resolve attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", 343}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03204", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as an input attachment by renderPass must include VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", 320}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-03205", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, at least one element of the pViewFormats member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be equal to the corresponding value of VkAttachmentDescription::format used to create renderPass", 333}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04113", 40}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with VkImageViewCreateInfo::viewType not equal to VK_IMAGE_VIEW_TYPE_3D", 186}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04533", 40}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageCreateInfo::extent.width greater than or equal to width", 268}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04534", 40}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageCreateInfo::extent.height greater than or equal to height", 270}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04535", 40}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageViewCreateInfo::subresourceRange.layerCount greater than or equal to layers", 288}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04537", 40}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than the index of the most significant bit set in any of those view masks", 337}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04538", 40}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was not specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than layers", 279}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04539", 40}, { {"If the maintenance7 feature is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is used as a fragment shading rate attachment must have a width at least as large as ceil(width / texelWidth), where texelWidth is the largest value of shadingRateAttachmentTexelSize.width in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", 625}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04540", 40}, { {"If the maintenance7 feature is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is used as a fragment shading rate attachment must have a height at least as large as ceil(height / texelHeight), where texelHeight is the largest value of shadingRateAttachmentTexelSize.height in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", 630}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04541", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as an input, color, resolve or depth/stencil attachment in renderPass must be greater than or equal to width", 313}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04542", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as an input, color, resolve or depth/stencil attachment in renderPass must be greater than or equal to height", 315}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04543", 40}, { {"If the maintenance7 feature is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be greater than or equal to ceil(width / texelWidth), where texelWidth is the largest value of shadingRateAttachmentTexelSize.width in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", 725}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04544", 40}, { {"If the maintenance7 feature is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be greater than or equal to ceil(height / texelHeight), where texelHeight is the largest value of shadingRateAttachmentTexelSize.height in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", 730}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04545", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be either 1, or greater than or equal to layers", 300}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04548", 40}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have been created with the VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR usage flag set", 259}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04549", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a fragment shading rate attachment by renderPass must include VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", 355}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-04587", 40}, { {"If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT and renderPass was specified with non-zero view masks, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be either 1, or greater than the index of the most significant bit set in any of those view masks", 404}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-flags-parameter", 44}, { {"flags must be a valid combination of VkFramebufferCreateFlagBits values", 71}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-height-00887", 41}, { {"height must be greater than 0", 29}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-height-00888", 41}, { {"height must be less than or equal to maxFramebufferHeight", 57}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-layers-00889", 41}, { {"layers must be greater than 0", 29}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-layers-00890", 41}, { {"layers must be less than or equal to maxFramebufferLayers", 57}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-nullColorAttachmentWithExternalFormatResolve-09349", 79}, { {"If the nullColorAttachmentWithExternalFormatResolve is VK_FALSE, and flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the format of the color attachment for each subpass in renderPass that includes an external format image as a resolve attachment must have a format equal to the value of VkAndroidHardwareBufferFormatResolvePropertiesANDROID::colorAttachmentFormat as returned by a call to vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer that was used to create the image view use as its resolve attachment", 545}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-00877", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a color attachment or resolve attachment by renderPass must have been created with the VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT usage flag set", 245}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-00879", 47}, { {"If renderpass is not VK_NULL_HANDLE, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input attachment by renderPass must have been created with the VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT usage flag set", 258}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-00880", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a VkFormat value that matches the VkFormat specified by the corresponding VkAttachmentDescription in renderPass", 231}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-00881", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a samples value that matches the samples value specified by the corresponding VkAttachmentDescription in renderPass", 235}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-00883", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must only specify a single mip level", 128}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-00884", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with the identity swizzle", 140}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-00891", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is a 2D or 2D array image view taken from a 3D image must not be a depth/stencil format", 184}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-02552", 47}, { {"Each element of pAttachments that is used as a fragment density map attachment by renderPass must not have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", 183}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-02555", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a width at least as large as the ceiling of width/maxFragmentDensityTexelSize.width", 234}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-02556", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a height at least as large as the ceiling of height/maxFragmentDensityTexelSize.height", 237}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-02633", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil attachment by renderPass must have been created with the VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT usage flag set", 239}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-02634", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil resolve attachment by renderPass must have been created with the VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT usage flag set", 247}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-09350", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, then if an element of pAttachments has a format of VK_FORMAT_UNDEFINED, it must have been created with a VkExternalFormatANDROID::externalFormat value identical to that provided in the VkExternalFormatANDROID::externalFormat specified by the corresponding VkAttachmentDescription2 in renderPass", 357}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pAttachments-12327", 47}, { {"If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, then each element of pAttachments that is used as a resolve attachment by renderPass must not be bound to a VkDeviceMemory object allocated from a VkMemoryHeap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property", 276}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-pNext-pNext", 40}, { {"pNext must be NULL or a pointer to a valid instance of VkFramebufferAttachmentsCreateInfo", 89}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-renderPass-02531", 45}, { {"If renderPass was specified with non-zero view masks, layers must be 1", 70}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-renderPass-02553", 45}, { {"If renderPass has a fragment density map attachment and the fragmentDensityMapNonSubsampledImages feature is not enabled, each element of pAttachments must have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT unless that element is the fragment density map attachment", 296}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-renderPass-02746", 45}, { {"Each element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1 or if renderPass was specified with non-zero view masks, greater than the index of the most significant bit set in any of those view masks", 252}, { "chapters/renderpass.html", 24} } },
        { {"VUID-VkFramebufferCreateInfo-renderPass-03198", 45}, { {"If multiview is enabled for renderPass and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain used as an input, color, resolve, or depth/stencil attachment in renderPass must be greater than the maximum bit index set in the view mask in the subpasses in which it is used in renderPass", 436}, { "chapters/renderpass.html", 24} } },
 