set(CMAKE_FIND_LIBRARY_PREFIXES "lib" "")
set(CMAKE_FIND_LIBRARY_SUFFIXES ".lib" ".a" ".so" ".sl" ".dylib" ".dll.a" ".l")

find_library(TESTC1_LIB
  NAMES testc1 testc1_test_debug_postfix
  PATHS ${top}/archive/${cfg_dir}
  NO_DEFAULT_PATH)

find_library(TESTC2_LIB
  NAMES testc2 testc2_test_debug_postfix
  PATHS ${top}/archive/${cfg_dir} ${top}/library/${cfg_dir}
  NO_DEFAULT_PATH)

find_program(CONLY_EXE
  NAMES COnly
  PATHS ${top}/runtime/${cfg_dir}
  NO_DEFAULT_PATH)

file(RELATIVE_PATH TESTC1_LIB_FILE "${top}" "${TESTC1_LIB}")
file(RELATIVE_PATH TESTC2_LIB_FILE "${top}" "${TESTC2_LIB}")
file(RELATIVE_PATH CONLY_EXE_FILE "${top}" "${CONLY_EXE}")

file(WRITE ${top}/OutDir.h "/* Generated by ${CMAKE_CURRENT_LIST_FILE} */
#ifndef OutDir_h
#define OutDir_h

#define TESTC1_LIB \"${TESTC1_LIB_FILE}\"
#define TESTC2_LIB \"${TESTC2_LIB_FILE}\"
#define CONLY_EXE  \"${CONLY_EXE_FILE}\"

#endif
")
