/* reader.c -- Module allows arbitrary parsing of streams. */

#include "language.h"

#if defined (__cplusplus)
extern "C"
{
#endif

static void pf_reader_make_stream (PFunArgs);
static void pf_reader_destroy_stream (PFunArgs);
static void pf_reader_push_string (PFunArgs);
static void pf_reader_recent_newlines (PFunArgs);
static void pf_reader_get_behaviour (PFunArgs);
static void pf_reader_default_behaviour (PFunArgs);
static void pf_reader_set_behaviour (PFunArgs);
static void pf_reader_get_line (PFunArgs);
static void pf_reader_get_token (PFunArgs);
static void pf_reader_get_expr (PFunArgs);

static PFunDesc ftab[] =
{
  { "READER::MAKE-STREAM",		0, 0, pf_reader_make_stream },
  { "READER::DESTRORY-STREAM",		0, 0, pf_reader_destroy_stream },
  { "READER::PUSH-STRING",		0, 0, pf_reader_push_string },
  { "READER::RECENT-NEWLINES",		0, 0, pf_reader_recent_newlines },
  { "READER::GET-BEHAVIOUR",		0, 0, pf_reader_get_behaviour },
  { "READER::SET-BEHAVIOUR",		0, 0, pf_reader_set_behaviour },
  { "READER::DEFAULT-BEHAVIOUR",	0, 0, pf_reader_default_behaviour },
  { "READER::GET-LINE",			0, 0, pf_reader_get_line },
  { "READER::GET-TOKEN",		0, 0, pf_reader_get_token },
  { "READER::GET-EXPR",			0, 0, pf_reader_get_expr },

  { (char *)NULL,			0, 0, (PFunHandler *)NULL }
};

void
module_initialize (void)
{
  static int called = 0;

  if (!called)
    {
      register int i;
      Symbol *sym, *funcnames;

      called++;
      funcnames = symbol_intern ("modules::syms-of-reader");

      /* Install the names and pointers. */
      for (i = 0; ftab[i].tag != (char *)NULL; i++)
	{
	  sym = symbol_intern_in_package (mhtml_function_package, ftab[i].tag);
	  symbol_add_value (funcnames, ftab[i].tag);
	  sym->type = symtype_FUNCTION;
	  sym->values = (char **)(&ftab[i]);
	}
    }
}

#if !defined (__cplusplus)
void _init (void) { module_initialize (); }
#endif

#include "reader-sub.c"

DEFINE_SECTION (GENERIC-LEXER, read; reading; token,
"The functions in this section allow for the reading of arbitrarily structured
files, and provide a programmable tokenizer/reader for that purpose.
The reader is capable of backtracking, understanding arbitrary comment styles,
and reading complex delimited expressions.", "")

DEFUN (pf_reader_make_stream, &optional streamvar,
"Create a new reader stream, perhaps using the stream specified by
<var streamvar>, a stream opened with
<funref stream-operators with-open-stream>.

If no <var streamvar> is given, a string-only stream is created.
Returns a <i>reader-stream</i> reference which can be used in calls
to the other <tag reader::...> functions.")
{
}

static void
pf_reader_destroy_stream (PFunArgs) {}

static void
pf_reader_push_string (PFunArgs) {}

static void
pf_reader_recent_newlines (PFunArgs) {}

static void
pf_reader_get_behaviour (PFunArgs) {}

static void
pf_reader_default_behaviour (PFunArgs) {}

static void
pf_reader_set_behaviour (PFunArgs) {}

static void
pf_reader_get_line (PFunArgs) {}

static void
pf_reader_get_token (PFunArgs) {}

static void
pf_reader_get_expr (PFunArgs) {}

#if defined (__cplusplus)
}
#endif
