DOC_SECTION (MISCELLANEOUS-TAGS)
DOC_SECTION (ARRAYS)
DEFUN (pf_array-delete-index,  index arrayvar,
" Delete the element of <var arrayvar> indicated by <var index>.
 The remainder of the array after <var index> is shifted back by one,
 so that the array ends up with one less element than it had before.
")
DOC_SECTION (MISCELLANEOUS-FUNCTIONS)
DEFUN (pf_comma-separated,  array,
" Produce a human readable string of the elements in the array
 variable <var array> separated by commas where appropriate, and
 the word \"and\" after the penultimate item.

")
DOC_SECTION (ARITHMETIC-OPERATORS)
DEFUN (pf_comma-separated-digits,  num,
" Produce NUM in standard human readable format, inserting commas
 where appropriate.

 Example:
 <example>
 <comma-separated-digits 2367> --> 2,367
 </example>
")
DOC_SECTION (VARIABLES)
DEFUN (pf_content-length, ,
" Return the length of the contents of <var var>.
 If <var var> is an array or string, returns the number of
 elements in the array.
 If <var var> is a binary variable, returns the amount of data
 stored within.
 If <var var> is a function, returns the empty string.
")
DOC_SECTION (PACKAGES)
DEFUN (pf_copy-package,  src dest,
" Copy the contents of the package <var src> to the package <var dest>.
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_count-this-page,  key,
" Add the current hit on this page to the pagecounter database, and
 return the current number of hits.  The pagecounter database is
 only accessed if this is the first time that this function is
 called on this page.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_dir::basename,  pathname,
" Return the \"basename\" of <var pathname>.  This simply returns the last
 component of <var pathname>.

 Example:
 <complete-example>
 <dir::basename /foo/bar/baz>
 </complete-example>
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_dir::canonicalize-pathname,  path,
" Make <var path> be absolute in the file system.

 If <var path> starts with a \"/\", then do nothing, otherwise, prefix
 it with <varref mhtml::include-prefix> and
 <varref mhtml::relative-prefix>.

 Given an empty <var path>, return the full path to the directory that
 this page resides in.

 Example:
 <complete-example>
 <dir::canonicalize-pathname foo.mhtml>
 </complete-example>
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_dir::names-in-dir,  dir type matching,
" Return an array of the fully qualified pathnames in <var dir> which
 are of type <var type> (either \"<code>FILE</code>\" or
 \"<code>DIRECTORY</code>\") and which satisfy the regular
 expression <var matching>.

 <var dir> defaults to the directory of the currently executing page.
 <var type> defaults to \"<code>FILE</code>\".
 <var matching> defaults to all possible filenames.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_directory-p,  var,
" Treat the argument <var var> as the name of a variable which contains
 an alist produced by <funref file-operators get-file-properties> or
 <funref file-operators directory-contents>, and return \"true\" if
 the referenced file object is a directory, as opposed to a file.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_directory?,  pathname,
" Return \"true\" if <var pathname> is a directory, or \"\" if not.
")
DOC_SECTION (LANGUAGE-OPERATORS)
DEFUN (pf_dump-all-packages, ,
" Call <funref language-operators dump-package> on every defined package.
")
DOC_SECTION (LANGUAGE-OPERATORS)
DEFUN (pf_dump-package,  pack &optional recurse?,
" Dump the contents of <var pack> in a format suitable for including in
 <code>HTML</code> output.  If second argument <var RECURSE?> is
 non-empty, then recursively dump the contents of any alists
 found as values in <var pack>.
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_e-mail::sendmail,  from to[] cc[] bcc[] headers[] message,
" Send the mail message MESSAGE using a network stream from FROM to TO.

 The host used to connect to for SMTP defaults to the value of
 the variable E-MAIL::MAILHOST, or \"localhost\" if that variable is
 not defined.

 TO, CC, BCC and HEADERS are arrays containing elements of the indicated
 type.

 <example>
 <e-mail::sendmail webmaster@mysite.com bfox@ua.com \"\" \"\"
    \"Subject: Testing e-mail::sendmail
     Reply-to: nobody@nobody.com\"
    \"This is the body of the message.\">
 </example>
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_file-newer?,  file1 file2,
" Return \"true\" if <var file1> has been written more recently than
 <var file2>.

 Both <var file1> and <var file2> are fully qualified pathnames.
")
DOC_SECTION (MISCELLANEOUS-FUNCTIONS)
DEFMACRO (pf_form-to-database,  database &key dbname key redirect-to action-name,
" Used almost exactly like <code>FORM</code>, this stores the
 values entered into the form into the specified database.  Takes
 keyword arguments of <var dbname>, <var key>, <var redirect-to>,
 and <var action-name>.

 <ul>
 <li> <var dbname>
 The name of the database to store the results in.  If it
 isn't supplied, \"anonymous.db\" is used.  The name of the
 database file is always relative to the current directory.

 <li> <var key>
 The name of the input field which contains the unique key
 for this record.  For example, this might be \"name\" for a
 rolodex application which asked for that information field.

 <li> <var redirect-to>
 The URL of the page to go to after the data is stored.
 If this is not specified, the user remains on the page
 containing this form.

 <li> <var action-name>
 The text to place in the button which submits the form.
 Defaults to \"Submit Form\".
</ul>
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::get-document,  host port path &key strip-headers,
" Get an HTTP document specified by <var host>, <var port> and <var path>.

 If a redirection is necessary in order to get the final
 document, the variable <code>http::redirected-url</code> is set
 to the fully qualified URI of the document.

 If the document could not be retrieved, the variable
 <code>http::error-status</code> contains the word \"NO-DATA\", and
 the variable <code>http::explanation</code> contains an human
 readable string explaining the problem.

 If <var strip-headers> is given, the HTTP protocol headers are
 stripped from the document before it is returned.

")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::host-part,  url,
" Return the hostname and port portion of the fully qualified <var url>.
 <complete-example>
 <http::host-part http://www.metahtml.com/page.mhtml>
 </complete-example>
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::include,  url,
" Include the contents of the Web document referenced by <var url>
 in the page.
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::path-part,  url,
" Return the path portion of the fully qualified <var url>.
 This is the part of <var url> that is meaningful to the host.
 <complete-example>
 <http::path-part http://www.metahtml.com:8080/page.mhtml?foo=bar>
 </complete-example>
")
DOC_SECTION (NETWORK-APPENDIX)
DEFUN (pf_http::port-part,  url,
" Return the port portion of the fully qualified <var url>.
 If the <var url> doesn't have a port specifier, the value \"80\" is
 returned.
 <complete-example>
 <http::port-part http://www.metahtml.com:8080/page.mhtml>
 </complete-example>
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_locale::select-common-country,  postname sitename,
" Produce a selection widget suitable for placing in a form which
 allows the user to select a country from a pull-down menu.
 <var postname> is the name of the variable which should be posted
 when the form is submitted.
 <var sitename> is the name of another variable which can contain the
 currently selected country.

 This differs from <funref html-helpers local::select-country>
 only in the number of countries that are displayed.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_locale::select-country,  postname sitename,
" Produce a selection widget suitable for placing in a form which
 allows the user to select a country from a pull-down menu.
 <var postname> is the name of the variable which should be posted
 when the form is submitted.
 <var sitename> is the name of another variable which can contain the
 currently selected country -- this variable must be fully
 qualified with its package name (i.e., DEFAULT::FOO, or SITE::COUNTRY).
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_locale::select-from-country,  postname sitename country-array,
" Produce a selection widget suitable for placing in a form which
 allows the user to select a country from a pull-down menu.
 <var postname> is the name of the variable which should be posted
 when the form is submitted.
 <var sitename> is the name of another variable which can contain the
 currently selected country -- this variable must be fully
 qualified with its package name (i.e., DEFAULT::FOO, or SITE::COUNTRY).
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_locale::select-state,  postname sitename,
" Produce a selection widget suitable for placing in a form which
 allows the user to select a US state name from a pull-down menu.
 <var postname> is the name of the variable which should be posted
 when the form is submitted.
 <var sitename> is the name of another variable which can contain the
 currently selected state.
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_mailable-address,  addr,
" Return \"true\" if ADDR appears to be a correctly formatted E-mail address.
")
DOC_SECTION (PACKAGE-OPERATORS)
DEFUN (pf_make-alist,  &rest args,
" Return an alist from the name=value pairs passed.
 <complete-example>
 <make-alist foo=bar baz=this>
 </complete-example>
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_make-directories,  path,
" Create all of the directories in <var path> (a fully qualified path to
 a directory) if they are not already present.
")
DOC_SECTION (MISCELLANEOUS-FUNCTIONS)
DEFUN (pf_make-identifier,  limit,
" Create an identifier that is <var limit> characters in length.
 The identifier characters are taken from the array MI::ALPHABET.
 MI::ALPHABET defaults to uppercase letters and numbers excluding
 \"I\", \"O\", zero, and one.
")
DOC_SECTION (PACKAGES)
DEFUN (pf_make-innocuous,  &rest packages[],
" Causes each variable in the specified <var packages> to have
 non-interpretable text.
 This is done by substituting HTML constructs for angle braces,
 among other things.

")
DOC_SECTION (HTML-HELPERS)
DEFMACRO (pf_menu,  title &key nobr,
" Create an HTML menu with title, text and links.
 
 Calling sequence:
 <example>
 <menu \"This Is The Title\">
   This is link text: target.mhtml
   External Site:  http://www.external.com/welcome.mhtml
 </menu>
 </example>
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_message, ,
" Add BODY to the contents of the session variable \"message\".
 Also see <funref html-helpers show-message>.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_meta-html, ,
" Produces the canonical form of the words \"Meta-HTML\".
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_mhtml::engine-per-page-function, ,
" Code that sets up the URL rewriter.  This has to be a per-page function
 because we haven't computed the URL of the document at the time
 this engine.conf file is read, so variables such as mhtml::http-prefix
 aren't set yet, and will be changed at the time the page location is
 computed.
")
DOC_SECTION (MISCELLANEOUS-FUNCTIONS)
DEFUN (pf_number-to-english,  value,
" Take the numeric value of VALUE and produce an English representation
 of it.  For example: 232 --: Two Hundred and Thirty-Two.
")
DOC_SECTION (MISCELLANEOUS-FUNCTIONS)
DEFUN (pf_number-to-englith,  value,
" Take the numeric value of VALUE and produce an English representation
 of it as a counting value.  For example:
 232 --> Two Hundred and Thirty-Second.
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_pagecount::available-fonts, ,
" Return an array of the names of the fonts available on this system
 for displaying digit counters.
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_pagecount::english-counter, ,
" Produce an English text representation of the number of times
 this page has been accessed.  Implicitly calls count-this-page.
 This might produce: One Thousand Two Hundred and Fifty.
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_pagecount::englith-counter, ,
" Produce an English text representation of the number of times
 this page has been accessed.  Implicitly calls count-this-page.
 This might produce: One Thousand Two Hundred and Fiftieth.
")
DOC_SECTION (PAGECOUNT-APPENDIX)
DEFUN (pf_pagecount::gif-counter,  fontname,
" Produce a sequence of GIFS representing the number of times this
 page has been accessed.  Implicitly calls count-this-page.
 The gifs are rendered using the font specified in FONTNAME.
")
DOC_SECTION (MISCELLANEOUS-TAGS)
DEFUN (pf_parse-date-string,  string,
" Populates the DATE package with the result of parsing DATE::DATE-STRING.
 If STRING is passed, that string is used instead of DATE::DATE-STRING,
 and should be the date in human readable format, just as <date> returns.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_path::find-executable,  basename,
" Return the fully qualified path to the program which would be
 executed by CGI-EXEC for BASENAME.

 Example:
 <example>
 <path::find-executable ls> --> /bin/ls
 </example>
")
DOC_SECTION (ARITMETIC-OPERATORS)
DEFUN (pf_percent,  num total,
" Return the percentage of TOTAL that NUM is.
 <example>
 <percent 20 200> --> 10.00
 </example>
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_select-option, ,
" Use instead of the <example code><option></example> HTML tag within
 the select HTML tag.

 It assumes that the text you wish to display on the page is in
 fact the value you wish to return from the form when this option
 is selected.  Particularly suited to situations where it is 
 helpful to know what the currently 'SELECTED' option might be.
 Example:
 <example>
 <select name=airport>
   <select-option airport Atlanta>
   <select-option airport Boston>
   <select-option airport Chicago>
   <select-option airport \"Los Angeles\">
   <select-option airport \"New York\">
   <select-option airport Miami>
   <select-option airport \"San Francisco\">
 </select>
</example>
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_select-option-value, ,
" Use instead of the <example code><option></example> HTML tag
 within the `SELECT' HTML tag, when the text you wish to display
 is actually different from that you wish to post back to the
 server.  Also suited to helping the user see what the currently
 'SELECTED' option might be.
 
 Example:
 <example>
 <select name=airport>
   <select-option-value airport ALT Atlanta>
   <select-option-value airport BTN Boston>
   <select-option-value airport CHI Chicago>
   <select-option-value airport LAS \"Los Angeles\">
   <select-option-value airport NY  \"New York\">
   <select-option-value airport MI  Miami>
   <select-option-value airport SFO \"San Francisco\">
 </select>
 </example>
 San Francisco is displayed on the page but SFO is actually
 what is returned as the selected options value.

")
DOC_SECTION (PACKAGES)
DEFUN (pf_session-destroy-package,  package,
" Delete all of the variables referenced by <var package> in the
 current session.  Also see <funref packages session-export>.
")
DOC_SECTION (SESSION-OPERATORS)
DEFUN (pf_session::initialize,  &optional timeout timeout-page,
" Create or resume a session for the currently connected browser.
 <var timeout> is the length of time this session should stick around
 in the session database expressed in minutes; it defaults to 200.

 If the variable <code>SESSION::INHIBIT-SESSION</code> is
 non-empty, then no session processing is done.

")
DOC_SECTION (SESSION-OPERATORS)
DEFUN (pf_session::reset-cookie, ,
" Place this at the end of a page which is supposed to timeout the
 user's session.  It sends the browser a Set-Cookie header which
 makes the cookie go away.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_show-message, ,
" Display the contents of the session variable \"message\",
 and then remove that variable from the session.
 Also see <funref html-helpers message>.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_source-link,  text,
" You write `Click <source-link here> for source.'
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_source-of,  web-path highlight-keywords-p,
" Display the contents of <var web-path> in <code>HTML</code>.
 Use sparingly.
 If <var highlight-keywords-p> is non-empty, then make each
 <Meta-HTML> function in the displayed text be a link which will
 display the contents of the the manual page for that keyword.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_thisdir, ,
" The fully qualified pathname to the directory containing the currently
 executing document.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_thisdoc, ,
" The complete URL to this document, without the query string or
 path information.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_thisfile, ,
" The fully qualified pathname to the document which is currently
 executing.
")
DOC_SECTION (HTML-HELPERS)
DEFUN (pf_thispage, ,
" The local web-based URL to this document, without the query string
 or path information.
")
DOC_SECTION (FILE-OPERATORS)
DEFUN (pf_webpath-exists,  document-path,
" Returns \"true\" if the specified <var document-path> exists with
 \"/\" being equal to the document root directory.
")
