/* __mp_bases -- Structure for conversion between internal binary
   format and strings in base 2..255.  The fields are explained in
   gmp-impl.h.


Copyright 1991, 1993, 1994, 1996, 2000 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#if GENERATE_TABLE
/* This is for the code at the end, for generating these tables.  */
#include <stdio.h>
#include <math.h>
#endif

#include "gmp.h"
#include "gmp-impl.h"

#if BITS_PER_MP_LIMB == 4
const struct bases __mp_bases[256] =
{
  /*  0 */ {0, 0.0, 0, 0},
  /*  1 */ {0, 1e37, 0, 0},
  /*  2 */ {4, 1.0000000000000000, 0x1, 0x0},
  /*  3 */ {2, 0.6309297535714574, 0x9, 0xc},
  /*  4 */ {2, 0.5000000000000000, 0x2, 0x0},
  /*  5 */ {1, 0.4306765580733931, 0x5, 0x9},
  /*  6 */ {1, 0.3868528072345416, 0x6, 0x5},
  /*  7 */ {1, 0.3562071871080222, 0x7, 0x2},
  /*  8 */ {1, 0.3333333333333333, 0x3, 0x0},
  /*  9 */ {1, 0.3154648767857287, 0x9, 0xc},
  /* 10 */ {1, 0.3010299956639812, 0xa, 0x9},
  /* 11 */ {1, 0.2890648263178878, 0xb, 0x7},
  /* 12 */ {1, 0.2789429456511298, 0xc, 0x5},
  /* 13 */ {1, 0.2702381544273197, 0xd, 0x3},
  /* 14 */ {1, 0.2626495350371935, 0xe, 0x2},
  /* 15 */ {1, 0.2559580248098155, 0xf, 0x1},
  /* 16 */ {1, 0.2500000000000000, 0x4, 0x0},
  /* 17 */ {0, 0.2446505421182260, 0x1, 0x10},
  /* 18 */ {0, 0.2398124665681314, 0x1, 0x10},
  /* 19 */ {0, 0.2354089133666382, 0x1, 0x10},
  /* 20 */ {0, 0.2313782131597592, 0x1, 0x10},
  /* 21 */ {0, 0.2276702486969530, 0x1, 0x10},
  /* 22 */ {0, 0.2242438242175754, 0x1, 0x10},
  /* 23 */ {0, 0.2210647294575037, 0x1, 0x10},
  /* 24 */ {0, 0.2181042919855316, 0x1, 0x10},
  /* 25 */ {0, 0.2153382790366965, 0x1, 0x10},
  /* 26 */ {0, 0.2127460535533632, 0x1, 0x10},
  /* 27 */ {0, 0.2103099178571525, 0x1, 0x10},
  /* 28 */ {0, 0.2080145976765095, 0x1, 0x10},
  /* 29 */ {0, 0.2058468324604344, 0x1, 0x10},
  /* 30 */ {0, 0.2037950470905062, 0x1, 0x10},
  /* 31 */ {0, 0.2018490865820999, 0x1, 0x10},
  /* 32 */ {0, 0.2000000000000000, 0x5, 0x0},
  /* 33 */ {0, 0.1982398631705605, 0x1, 0x10},
  /* 34 */ {0, 0.1965616322328226, 0x1, 0x10},
  /* 35 */ {0, 0.1949590218937863, 0x1, 0x10},
  /* 36 */ {0, 0.1934264036172708, 0x1, 0x10},
  /* 37 */ {0, 0.1919587200065601, 0x1, 0x10},
  /* 38 */ {0, 0.1905514124267734, 0x1, 0x10},
  /* 39 */ {0, 0.1892003595168700, 0x1, 0x10},
  /* 40 */ {0, 0.1879018247091076, 0x1, 0x10},
  /* 41 */ {0, 0.1866524112389434, 0x1, 0x10},
  /* 42 */ {0, 0.1854490234153689, 0x1, 0x10},
  /* 43 */ {0, 0.1842888331487062, 0x1, 0x10},
  /* 44 */ {0, 0.1831692509136336, 0x1, 0x10},
  /* 45 */ {0, 0.1820879004699383, 0x1, 0x10},
  /* 46 */ {0, 0.1810425967800402, 0x1, 0x10},
  /* 47 */ {0, 0.1800313266566926, 0x1, 0x10},
  /* 48 */ {0, 0.1790522317510414, 0x1, 0x10},
  /* 49 */ {0, 0.1781035935540111, 0x1, 0x10},
  /* 50 */ {0, 0.1771838201355579, 0x1, 0x10},
  /* 51 */ {0, 0.1762914343888821, 0x1, 0x10},
  /* 52 */ {0, 0.1754250635819545, 0x1, 0x10},
  /* 53 */ {0, 0.1745834300480449, 0x1, 0x10},
  /* 54 */ {0, 0.1737653428714400, 0x1, 0x10},
  /* 55 */ {0, 0.1729696904450771, 0x1, 0x10},
  /* 56 */ {0, 0.1721954337940981, 0x1, 0x10},
  /* 57 */ {0, 0.1714416005739134, 0x1, 0x10},
  /* 58 */ {0, 0.1707072796637201, 0x1, 0x10},
  /* 59 */ {0, 0.1699916162869140, 0x1, 0x10},
  /* 60 */ {0, 0.1692938075987814, 0x1, 0x10},
  /* 61 */ {0, 0.1686130986895011, 0x1, 0x10},
  /* 62 */ {0, 0.1679487789570419, 0x1, 0x10},
  /* 63 */ {0, 0.1673001788101741, 0x1, 0x10},
  /* 64 */ {0, 0.1666666666666667, 0x6, 0x0},
  /* 65 */ {0, 0.1660476462159378, 0x1, 0x10},
  /* 66 */ {0, 0.1654425539190583, 0x1, 0x10},
  /* 67 */ {0, 0.1648508567221603, 0x1, 0x10},
  /* 68 */ {0, 0.1642720499620502, 0x1, 0x10},
  /* 69 */ {0, 0.1637056554452156, 0x1, 0x10},
  /* 70 */ {0, 0.1631512196835108, 0x1, 0x10},
  /* 71 */ {0, 0.1626083122716342, 0x1, 0x10},
  /* 72 */ {0, 0.1620765243931223, 0x1, 0x10},
  /* 73 */ {0, 0.1615554674429964, 0x1, 0x10},
  /* 74 */ {0, 0.1610447717564444, 0x1, 0x10},
  /* 75 */ {0, 0.1605440854340214, 0x1, 0x10},
  /* 76 */ {0, 0.1600530732548213, 0x1, 0x10},
  /* 77 */ {0, 0.1595714156699382, 0x1, 0x10},
  /* 78 */ {0, 0.1590988078692941, 0x1, 0x10},
  /* 79 */ {0, 0.1586349589155960, 0x1, 0x10},
  /* 80 */ {0, 0.1581795909397823, 0x1, 0x10},
  /* 81 */ {0, 0.1577324383928644, 0x1, 0x10},
  /* 82 */ {0, 0.1572932473495469, 0x1, 0x10},
  /* 83 */ {0, 0.1568617748594410, 0x1, 0x10},
  /* 84 */ {0, 0.1564377883420715, 0x1, 0x10},
  /* 85 */ {0, 0.1560210650222250, 0x1, 0x10},
  /* 86 */ {0, 0.1556113914024939, 0x1, 0x10},
  /* 87 */ {0, 0.1552085627701551, 0x1, 0x10},
  /* 88 */ {0, 0.1548123827357682, 0x1, 0x10},
  /* 89 */ {0, 0.1544226628011101, 0x1, 0x10},
  /* 90 */ {0, 0.1540392219542636, 0x1, 0x10},
  /* 91 */ {0, 0.1536618862898642, 0x1, 0x10},
  /* 92 */ {0, 0.1532904886526781, 0x1, 0x10},
  /* 93 */ {0, 0.1529248683028321, 0x1, 0x10},
  /* 94 */ {0, 0.1525648706011593, 0x1, 0x10},
  /* 95 */ {0, 0.1522103467132434, 0x1, 0x10},
  /* 96 */ {0, 0.1518611533308632, 0x1, 0x10},
  /* 97 */ {0, 0.1515171524096389, 0x1, 0x10},
  /* 98 */ {0, 0.1511782109217764, 0x1, 0x10},
  /* 99 */ {0, 0.1508442006228941, 0x1, 0x10},
  /* 100 */ {0, 0.1505149978319906, 0x1, 0x10},
  /* 101 */ {0, 0.1501904832236880, 0x1, 0x10},
  /* 102 */ {0, 0.1498705416319474, 0x1, 0x10},
  /* 103 */ {0, 0.1495550618645152, 0x1, 0x10},
  /* 104 */ {0, 0.1492439365274121, 0x1, 0x10},
  /* 105 */ {0, 0.1489370618588283, 0x1, 0x10},
  /* 106 */ {0, 0.1486343375718350, 0x1, 0x10},
  /* 107 */ {0, 0.1483356667053617, 0x1, 0x10},
  /* 108 */ {0, 0.1480409554829326, 0x1, 0x10},
  /* 109 */ {0, 0.1477501131786861, 0x1, 0x10},
  /* 110 */ {0, 0.1474630519902391, 0x1, 0x10},
  /* 111 */ {0, 0.1471796869179852, 0x1, 0x10},
  /* 112 */ {0, 0.1468999356504447, 0x1, 0x10},
  /* 113 */ {0, 0.1466237184553111, 0x1, 0x10},
  /* 114 */ {0, 0.1463509580758620, 0x1, 0x10},
  /* 115 */ {0, 0.1460815796324244, 0x1, 0x10},
  /* 116 */ {0, 0.1458155105286054, 0x1, 0x10},
  /* 117 */ {0, 0.1455526803620167, 0x1, 0x10},
  /* 118 */ {0, 0.1452930208392429, 0x1, 0x10},
  /* 119 */ {0, 0.1450364656948130, 0x1, 0x10},
  /* 120 */ {0, 0.1447829506139581, 0x1, 0x10},
  /* 121 */ {0, 0.1445324131589439, 0x1, 0x10},
  /* 122 */ {0, 0.1442847926987864, 0x1, 0x10},
  /* 123 */ {0, 0.1440400303421672, 0x1, 0x10},
  /* 124 */ {0, 0.1437980688733776, 0x1, 0x10},
  /* 125 */ {0, 0.1435588526911310, 0x1, 0x10},
  /* 126 */ {0, 0.1433223277500932, 0x1, 0x10},
  /* 127 */ {0, 0.1430884415049874, 0x1, 0x10},
  /* 128 */ {0, 0.1428571428571428, 0x7, 0x0},
  /* 129 */ {0, 0.1426283821033600, 0x1, 0x10},
  /* 130 */ {0, 0.1424021108869747, 0x1, 0x10},
  /* 131 */ {0, 0.1421782821510107, 0x1, 0x10},
  /* 132 */ {0, 0.1419568500933153, 0x1, 0x10},
  /* 133 */ {0, 0.1417377701235801, 0x1, 0x10},
  /* 134 */ {0, 0.1415209988221527, 0x1, 0x10},
  /* 135 */ {0, 0.1413064939005528, 0x1, 0x10},
  /* 136 */ {0, 0.1410942141636095, 0x1, 0x10},
  /* 137 */ {0, 0.1408841194731412, 0x1, 0x10},
  /* 138 */ {0, 0.1406761707131039, 0x1, 0x10},
  /* 139 */ {0, 0.1404703297561400, 0x1, 0x10},
  /* 140 */ {0, 0.1402665594314587, 0x1, 0x10},
  /* 141 */ {0, 0.1400648234939879, 0x1, 0x10},
  /* 142 */ {0, 0.1398650865947379, 0x1, 0x10},
  /* 143 */ {0, 0.1396673142523192, 0x1, 0x10},
  /* 144 */ {0, 0.1394714728255649, 0x1, 0x10},
  /* 145 */ {0, 0.1392775294872041, 0x1, 0x10},
  /* 146 */ {0, 0.1390854521985406, 0x1, 0x10},
  /* 147 */ {0, 0.1388952096850913, 0x1, 0x10},
  /* 148 */ {0, 0.1387067714131417, 0x1, 0x10},
  /* 149 */ {0, 0.1385201075671774, 0x1, 0x10},
  /* 150 */ {0, 0.1383351890281539, 0x1, 0x10},
  /* 151 */ {0, 0.1381519873525671, 0x1, 0x10},
  /* 152 */ {0, 0.1379704747522905, 0x1, 0x10},
  /* 153 */ {0, 0.1377906240751463, 0x1, 0x10},
  /* 154 */ {0, 0.1376124087861776, 0x1, 0x10},
  /* 155 */ {0, 0.1374358029495937, 0x1, 0x10},
  /* 156 */ {0, 0.1372607812113589, 0x1, 0x10},
  /* 157 */ {0, 0.1370873187823978, 0x1, 0x10},
  /* 158 */ {0, 0.1369153914223921, 0x1, 0x10},
  /* 159 */ {0, 0.1367449754241439, 0x1, 0x10},
  /* 160 */ {0, 0.1365760475984821, 0x1, 0x10},
  /* 161 */ {0, 0.1364085852596902, 0x1, 0x10},
  /* 162 */ {0, 0.1362425662114337, 0x1, 0x10},
  /* 163 */ {0, 0.1360779687331669, 0x1, 0x10},
  /* 164 */ {0, 0.1359147715670014, 0x1, 0x10},
  /* 165 */ {0, 0.1357529539050150, 0x1, 0x10},
  /* 166 */ {0, 0.1355924953769864, 0x1, 0x10},
  /* 167 */ {0, 0.1354333760385373, 0x1, 0x10},
  /* 168 */ {0, 0.1352755763596663, 0x1, 0x10},
  /* 169 */ {0, 0.1351190772136599, 0x1, 0x10},
  /* 170 */ {0, 0.1349638598663645, 0x1, 0x10},
  /* 171 */ {0, 0.1348099059658080, 0x1, 0x10},
  /* 172 */ {0, 0.1346571975321549, 0x1, 0x10},
  /* 173 */ {0, 0.1345057169479844, 0x1, 0x10},
  /* 174 */ {0, 0.1343554469488779, 0x1, 0x10},
  /* 175 */ {0, 0.1342063706143054, 0x1, 0x10},
  /* 176 */ {0, 0.1340584713587979, 0x1, 0x10},
  /* 177 */ {0, 0.1339117329233981, 0x1, 0x10},
  /* 178 */ {0, 0.1337661393673756, 0x1, 0x10},
  /* 179 */ {0, 0.1336216750601996, 0x1, 0x10},
  /* 180 */ {0, 0.1334783246737591, 0x1, 0x10},
  /* 181 */ {0, 0.1333360731748201, 0x1, 0x10},
  /* 182 */ {0, 0.1331949058177136, 0x1, 0x10},
  /* 183 */ {0, 0.1330548081372441, 0x1, 0x10},
  /* 184 */ {0, 0.1329157659418126, 0x1, 0x10},
  /* 185 */ {0, 0.1327777653067443, 0x1, 0x10},
  /* 186 */ {0, 0.1326407925678156, 0x1, 0x10},
  /* 187 */ {0, 0.1325048343149731, 0x1, 0x10},
  /* 188 */ {0, 0.1323698773862368, 0x1, 0x10},
  /* 189 */ {0, 0.1322359088617821, 0x1, 0x10},
  /* 190 */ {0, 0.1321029160581950, 0x1, 0x10},
  /* 191 */ {0, 0.1319708865228925, 0x1, 0x10},
  /* 192 */ {0, 0.1318398080287045, 0x1, 0x10},
  /* 193 */ {0, 0.1317096685686114, 0x1, 0x10},
  /* 194 */ {0, 0.1315804563506306, 0x1, 0x10},
  /* 195 */ {0, 0.1314521597928493, 0x1, 0x10},
  /* 196 */ {0, 0.1313247675185968, 0x1, 0x10},
  /* 197 */ {0, 0.1311982683517524, 0x1, 0x10},
  /* 198 */ {0, 0.1310726513121843, 0x1, 0x10},
  /* 199 */ {0, 0.1309479056113158, 0x1, 0x10},
  /* 200 */ {0, 0.1308240206478128, 0x1, 0x10},
  /* 201 */ {0, 0.1307009860033912, 0x1, 0x10},
  /* 202 */ {0, 0.1305787914387386, 0x1, 0x10},
  /* 203 */ {0, 0.1304574268895465, 0x1, 0x10},
  /* 204 */ {0, 0.1303368824626505, 0x1, 0x10},
  /* 205 */ {0, 0.1302171484322746, 0x1, 0x10},
  /* 206 */ {0, 0.1300982152363760, 0x1, 0x10},
  /* 207 */ {0, 0.1299800734730872, 0x1, 0x10},
  /* 208 */ {0, 0.1298627138972530, 0x1, 0x10},
  /* 209 */ {0, 0.1297461274170591, 0x1, 0x10},
  /* 210 */ {0, 0.1296303050907487, 0x1, 0x10},
  /* 211 */ {0, 0.1295152381234257, 0x1, 0x10},
  /* 212 */ {0, 0.1294009178639407, 0x1, 0x10},
  /* 213 */ {0, 0.1292873358018581, 0x1, 0x10},
  /* 214 */ {0, 0.1291744835645007, 0x1, 0x10},
  /* 215 */ {0, 0.1290623529140715, 0x1, 0x10},
  /* 216 */ {0, 0.1289509357448472, 0x1, 0x10},
  /* 217 */ {0, 0.1288402240804449, 0x1, 0x10},
  /* 218 */ {0, 0.1287302100711566, 0x1, 0x10},
  /* 219 */ {0, 0.1286208859913518, 0x1, 0x10},
  /* 220 */ {0, 0.1285122442369443, 0x1, 0x10},
  /* 221 */ {0, 0.1284042773229231, 0x1, 0x10},
  /* 222 */ {0, 0.1282969778809442, 0x1, 0x10},
  /* 223 */ {0, 0.1281903386569819, 0x1, 0x10},
  /* 224 */ {0, 0.1280843525090381, 0x1, 0x10},
  /* 225 */ {0, 0.1279790124049077, 0x1, 0x10},
  /* 226 */ {0, 0.1278743114199984, 0x1, 0x10},
  /* 227 */ {0, 0.1277702427352035, 0x1, 0x10},
  /* 228 */ {0, 0.1276667996348261, 0x1, 0x10},
  /* 229 */ {0, 0.1275639755045533, 0x1, 0x10},
  /* 230 */ {0, 0.1274617638294791, 0x1, 0x10},
  /* 231 */ {0, 0.1273601581921740, 0x1, 0x10},
  /* 232 */ {0, 0.1272591522708010, 0x1, 0x10},
  /* 233 */ {0, 0.1271587398372755, 0x1, 0x10},
  /* 234 */ {0, 0.1270589147554692, 0x1, 0x10},
  /* 235 */ {0, 0.1269596709794558, 0x1, 0x10},
  /* 236 */ {0, 0.1268610025517973, 0x1, 0x10},
  /* 237 */ {0, 0.1267629036018709, 0x1, 0x10},
  /* 238 */ {0, 0.1266653683442337, 0x1, 0x10},
  /* 239 */ {0, 0.1265683910770258, 0x1, 0x10},
  /* 240 */ {0, 0.1264719661804097, 0x1, 0x10},
  /* 241 */ {0, 0.1263760881150453, 0x1, 0x10},
  /* 242 */ {0, 0.1262807514205999, 0x1, 0x10},
  /* 243 */ {0, 0.1261859507142915, 0x1, 0x10},
  /* 244 */ {0, 0.1260916806894653, 0x1, 0x10},
  /* 245 */ {0, 0.1259979361142023, 0x1, 0x10},
  /* 246 */ {0, 0.1259047118299582, 0x1, 0x10},
  /* 247 */ {0, 0.1258120027502338, 0x1, 0x10},
  /* 248 */ {0, 0.1257198038592741, 0x1, 0x10},
  /* 249 */ {0, 0.1256281102107963, 0x1, 0x10},
  /* 250 */ {0, 0.1255369169267456, 0x1, 0x10},
  /* 251 */ {0, 0.1254462191960791, 0x1, 0x10},
  /* 252 */ {0, 0.1253560122735751, 0x1, 0x10},
  /* 253 */ {0, 0.1252662914786691, 0x1, 0x10},
  /* 254 */ {0, 0.1251770521943144, 0x1, 0x10},
  /* 255 */ {0, 0.1250882898658681, 0x1, 0x10},
};
#endif /* 4 */
#if BITS_PER_MP_LIMB == 8
const struct bases __mp_bases[256] =
{
  /*  0 */ {0, 0.0, 0, 0},
  /*  1 */ {0, 1e37, 0, 0},
  /*  2 */ {8, 1.0000000000000000, 0x1, 0x0},
  /*  3 */ {5, 0.6309297535714574, 0xf3, 0xd},
  /*  4 */ {4, 0.5000000000000000, 0x2, 0x0},
  /*  5 */ {3, 0.4306765580733931, 0x7d, 0x6},
  /*  6 */ {3, 0.3868528072345416, 0xd8, 0x2f},
  /*  7 */ {2, 0.3562071871080222, 0x31, 0x4e},
  /*  8 */ {2, 0.3333333333333333, 0x3, 0x0},
  /*  9 */ {2, 0.3154648767857287, 0x51, 0x94},
  /* 10 */ {2, 0.3010299956639812, 0x64, 0x47},
  /* 11 */ {2, 0.2890648263178878, 0x79, 0xe},
  /* 12 */ {2, 0.2789429456511298, 0x90, 0xc7},
  /* 13 */ {2, 0.2702381544273197, 0xa9, 0x83},
  /* 14 */ {2, 0.2626495350371935, 0xc4, 0x4e},
  /* 15 */ {2, 0.2559580248098155, 0xe1, 0x23},
  /* 16 */ {2, 0.2500000000000000, 0x4, 0x0},
  /* 17 */ {1, 0.2446505421182260, 0x11, 0xe1},
  /* 18 */ {1, 0.2398124665681314, 0x12, 0xc7},
  /* 19 */ {1, 0.2354089133666382, 0x13, 0xaf},
  /* 20 */ {1, 0.2313782131597592, 0x14, 0x99},
  /* 21 */ {1, 0.2276702486969530, 0x15, 0x86},
  /* 22 */ {1, 0.2242438242175754, 0x16, 0x74},
  /* 23 */ {1, 0.2210647294575037, 0x17, 0x64},
  /* 24 */ {1, 0.2181042919855316, 0x18, 0x55},
  /* 25 */ {1, 0.2153382790366965, 0x19, 0x47},
  /* 26 */ {1, 0.2127460535533632, 0x1a, 0x3b},
  /* 27 */ {1, 0.2103099178571525, 0x1b, 0x2f},
  /* 28 */ {1, 0.2080145976765095, 0x1c, 0x24},
  /* 29 */ {1, 0.2058468324604344, 0x1d, 0x1a},
  /* 30 */ {1, 0.2037950470905062, 0x1e, 0x11},
  /* 31 */ {1, 0.2018490865820999, 0x1f, 0x8},
  /* 32 */ {1, 0.2000000000000000, 0x5, 0x0},
  /* 33 */ {1, 0.1982398631705605, 0x21, 0xf0},
  /* 34 */ {1, 0.1965616322328226, 0x22, 0xe1},
  /* 35 */ {1, 0.1949590218937863, 0x23, 0xd4},
  /* 36 */ {1, 0.1934264036172708, 0x24, 0xc7},
  /* 37 */ {1, 0.1919587200065601, 0x25, 0xba},
  /* 38 */ {1, 0.1905514124267734, 0x26, 0xaf},
  /* 39 */ {1, 0.1892003595168700, 0x27, 0xa4},
  /* 40 */ {1, 0.1879018247091076, 0x28, 0x99},
  /* 41 */ {1, 0.1866524112389434, 0x29, 0x8f},
  /* 42 */ {1, 0.1854490234153689, 0x2a, 0x86},
  /* 43 */ {1, 0.1842888331487062, 0x2b, 0x7d},
  /* 44 */ {1, 0.1831692509136336, 0x2c, 0x74},
  /* 45 */ {1, 0.1820879004699383, 0x2d, 0x6c},
  /* 46 */ {1, 0.1810425967800402, 0x2e, 0x64},
  /* 47 */ {1, 0.1800313266566926, 0x2f, 0x5c},
  /* 48 */ {1, 0.1790522317510414, 0x30, 0x55},
  /* 49 */ {1, 0.1781035935540111, 0x31, 0x4e},
  /* 50 */ {1, 0.1771838201355579, 0x32, 0x47},
  /* 51 */ {1, 0.1762914343888821, 0x33, 0x41},
  /* 52 */ {1, 0.1754250635819545, 0x34, 0x3b},
  /* 53 */ {1, 0.1745834300480449, 0x35, 0x35},
  /* 54 */ {1, 0.1737653428714400, 0x36, 0x2f},
  /* 55 */ {1, 0.1729696904450771, 0x37, 0x29},
  /* 56 */ {1, 0.1721954337940981, 0x38, 0x24},
  /* 57 */ {1, 0.1714416005739134, 0x39, 0x1f},
  /* 58 */ {1, 0.1707072796637201, 0x3a, 0x1a},
  /* 59 */ {1, 0.1699916162869140, 0x3b, 0x15},
  /* 60 */ {1, 0.1692938075987814, 0x3c, 0x11},
  /* 61 */ {1, 0.1686130986895011, 0x3d, 0xc},
  /* 62 */ {1, 0.1679487789570419, 0x3e, 0x8},
  /* 63 */ {1, 0.1673001788101741, 0x3f, 0x4},
  /* 64 */ {1, 0.1666666666666667, 0x6, 0x0},
  /* 65 */ {1, 0.1660476462159378, 0x41, 0xf8},
  /* 66 */ {1, 0.1654425539190583, 0x42, 0xf0},
  /* 67 */ {1, 0.1648508567221603, 0x43, 0xe9},
  /* 68 */ {1, 0.1642720499620502, 0x44, 0xe1},
  /* 69 */ {1, 0.1637056554452156, 0x45, 0xda},
  /* 70 */ {1, 0.1631512196835108, 0x46, 0xd4},
  /* 71 */ {1, 0.1626083122716342, 0x47, 0xcd},
  /* 72 */ {1, 0.1620765243931223, 0x48, 0xc7},
  /* 73 */ {1, 0.1615554674429964, 0x49, 0xc0},
  /* 74 */ {1, 0.1610447717564444, 0x4a, 0xba},
  /* 75 */ {1, 0.1605440854340214, 0x4b, 0xb4},
  /* 76 */ {1, 0.1600530732548213, 0x4c, 0xaf},
  /* 77 */ {1, 0.1595714156699382, 0x4d, 0xa9},
  /* 78 */ {1, 0.1590988078692941, 0x4e, 0xa4},
  /* 79 */ {1, 0.1586349589155960, 0x4f, 0x9e},
  /* 80 */ {1, 0.1581795909397823, 0x50, 0x99},
  /* 81 */ {1, 0.1577324383928644, 0x51, 0x94},
  /* 82 */ {1, 0.1572932473495469, 0x52, 0x8f},
  /* 83 */ {1, 0.1568617748594410, 0x53, 0x8a},
  /* 84 */ {1, 0.1564377883420715, 0x54, 0x86},
  /* 85 */ {1, 0.1560210650222250, 0x55, 0x81},
  /* 86 */ {1, 0.1556113914024939, 0x56, 0x7d},
  /* 87 */ {1, 0.1552085627701551, 0x57, 0x78},
  /* 88 */ {1, 0.1548123827357682, 0x58, 0x74},
  /* 89 */ {1, 0.1544226628011101, 0x59, 0x70},
  /* 90 */ {1, 0.1540392219542636, 0x5a, 0x6c},
  /* 91 */ {1, 0.1536618862898642, 0x5b, 0x68},
  /* 92 */ {1, 0.1532904886526781, 0x5c, 0x64},
  /* 93 */ {1, 0.1529248683028321, 0x5d, 0x60},
  /* 94 */ {1, 0.1525648706011593, 0x5e, 0x5c},
  /* 95 */ {1, 0.1522103467132434, 0x5f, 0x58},
  /* 96 */ {1, 0.1518611533308632, 0x60, 0x55},
  /* 97 */ {1, 0.1515171524096389, 0x61, 0x51},
  /* 98 */ {1, 0.1511782109217764, 0x62, 0x4e},
  /* 99 */ {1, 0.1508442006228941, 0x63, 0x4a},
  /* 100 */ {1, 0.1505149978319906, 0x64, 0x47},
  /* 101 */ {1, 0.1501904832236880, 0x65, 0x44},
  /* 102 */ {1, 0.1498705416319474, 0x66, 0x41},
  /* 103 */ {1, 0.1495550618645152, 0x67, 0x3e},
  /* 104 */ {1, 0.1492439365274121, 0x68, 0x3b},
  /* 105 */ {1, 0.1489370618588283, 0x69, 0x38},
  /* 106 */ {1, 0.1486343375718350, 0x6a, 0x35},
  /* 107 */ {1, 0.1483356667053617, 0x6b, 0x32},
  /* 108 */ {1, 0.1480409554829326, 0x6c, 0x2f},
  /* 109 */ {1, 0.1477501131786861, 0x6d, 0x2c},
  /* 110 */ {1, 0.1474630519902391, 0x6e, 0x29},
  /* 111 */ {1, 0.1471796869179852, 0x6f, 0x27},
  /* 112 */ {1, 0.1468999356504447, 0x70, 0x24},
  /* 113 */ {1, 0.1466237184553111, 0x71, 0x21},
  /* 114 */ {1, 0.1463509580758620, 0x72, 0x1f},
  /* 115 */ {1, 0.1460815796324244, 0x73, 0x1c},
  /* 116 */ {1, 0.1458155105286054, 0x74, 0x1a},
  /* 117 */ {1, 0.1455526803620167, 0x75, 0x18},
  /* 118 */ {1, 0.1452930208392429, 0x76, 0x15},
  /* 119 */ {1, 0.1450364656948130, 0x77, 0x13},
  /* 120 */ {1, 0.1447829506139581, 0x78, 0x11},
  /* 121 */ {1, 0.1445324131589439, 0x79, 0xe},
  /* 122 */ {1, 0.1442847926987864, 0x7a, 0xc},
  /* 123 */ {1, 0.1440400303421672, 0x7b, 0xa},
  /* 124 */ {1, 0.1437980688733776, 0x7c, 0x8},
  /* 125 */ {1, 0.1435588526911310, 0x7d, 0x6},
  /* 126 */ {1, 0.1433223277500932, 0x7e, 0x4},
  /* 127 */ {1, 0.1430884415049874, 0x7f, 0x2},
  /* 128 */ {1, 0.1428571428571428, 0x7, 0x0},
  /* 129 */ {1, 0.1426283821033600, 0x81, 0xfc},
  /* 130 */ {1, 0.1424021108869747, 0x82, 0xf8},
  /* 131 */ {1, 0.1421782821510107, 0x83, 0xf4},
  /* 132 */ {1, 0.1419568500933153, 0x84, 0xf0},
  /* 133 */ {1, 0.1417377701235801, 0x85, 0xec},
  /* 134 */ {1, 0.1415209988221527, 0x86, 0xe9},
  /* 135 */ {1, 0.1413064939005528, 0x87, 0xe5},
  /* 136 */ {1, 0.1410942141636095, 0x88, 0xe1},
  /* 137 */ {1, 0.1408841194731412, 0x89, 0xde},
  /* 138 */ {1, 0.1406761707131039, 0x8a, 0xda},
  /* 139 */ {1, 0.1404703297561400, 0x8b, 0xd7},
  /* 140 */ {1, 0.1402665594314587, 0x8c, 0xd4},
  /* 141 */ {1, 0.1400648234939879, 0x8d, 0xd0},
  /* 142 */ {1, 0.1398650865947379, 0x8e, 0xcd},
  /* 143 */ {1, 0.1396673142523192, 0x8f, 0xca},
  /* 144 */ {1, 0.1394714728255649, 0x90, 0xc7},
  /* 145 */ {1, 0.1392775294872041, 0x91, 0xc3},
  /* 146 */ {1, 0.1390854521985406, 0x92, 0xc0},
  /* 147 */ {1, 0.1388952096850913, 0x93, 0xbd},
  /* 148 */ {1, 0.1387067714131417, 0x94, 0xba},
  /* 149 */ {1, 0.1385201075671774, 0x95, 0xb7},
  /* 150 */ {1, 0.1383351890281539, 0x96, 0xb4},
  /* 151 */ {1, 0.1381519873525671, 0x97, 0xb2},
  /* 152 */ {1, 0.1379704747522905, 0x98, 0xaf},
  /* 153 */ {1, 0.1377906240751463, 0x99, 0xac},
  /* 154 */ {1, 0.1376124087861776, 0x9a, 0xa9},
  /* 155 */ {1, 0.1374358029495937, 0x9b, 0xa6},
  /* 156 */ {1, 0.1372607812113589, 0x9c, 0xa4},
  /* 157 */ {1, 0.1370873187823978, 0x9d, 0xa1},
  /* 158 */ {1, 0.1369153914223921, 0x9e, 0x9e},
  /* 159 */ {1, 0.1367449754241439, 0x9f, 0x9c},
  /* 160 */ {1, 0.1365760475984821, 0xa0, 0x99},
  /* 161 */ {1, 0.1364085852596902, 0xa1, 0x97},
  /* 162 */ {1, 0.1362425662114337, 0xa2, 0x94},
  /* 163 */ {1, 0.1360779687331669, 0xa3, 0x92},
  /* 164 */ {1, 0.1359147715670014, 0xa4, 0x8f},
  /* 165 */ {1, 0.1357529539050150, 0xa5, 0x8d},
  /* 166 */ {1, 0.1355924953769864, 0xa6, 0x8a},
  /* 167 */ {1, 0.1354333760385373, 0xa7, 0x88},
  /* 168 */ {1, 0.1352755763596663, 0xa8, 0x86},
  /* 169 */ {1, 0.1351190772136599, 0xa9, 0x83},
  /* 170 */ {1, 0.1349638598663645, 0xaa, 0x81},
  /* 171 */ {1, 0.1348099059658080, 0xab, 0x7f},
  /* 172 */ {1, 0.1346571975321549, 0xac, 0x7d},
  /* 173 */ {1, 0.1345057169479844, 0xad, 0x7a},
  /* 174 */ {1, 0.1343554469488779, 0xae, 0x78},
  /* 175 */ {1, 0.1342063706143054, 0xaf, 0x76},
  /* 176 */ {1, 0.1340584713587979, 0xb0, 0x74},
  /* 177 */ {1, 0.1339117329233981, 0xb1, 0x72},
  /* 178 */ {1, 0.1337661393673756, 0xb2, 0x70},
  /* 179 */ {1, 0.1336216750601996, 0xb3, 0x6e},
  /* 180 */ {1, 0.1334783246737591, 0xb4, 0x6c},
  /* 181 */ {1, 0.1333360731748201, 0xb5, 0x6a},
  /* 182 */ {1, 0.1331949058177136, 0xb6, 0x68},
  /* 183 */ {1, 0.1330548081372441, 0xb7, 0x66},
  /* 184 */ {1, 0.1329157659418126, 0xb8, 0x64},
  /* 185 */ {1, 0.1327777653067443, 0xb9, 0x62},
  /* 186 */ {1, 0.1326407925678156, 0xba, 0x60},
  /* 187 */ {1, 0.1325048343149731, 0xbb, 0x5e},
  /* 188 */ {1, 0.1323698773862368, 0xbc, 0x5c},
  /* 189 */ {1, 0.1322359088617821, 0xbd, 0x5a},
  /* 190 */ {1, 0.1321029160581950, 0xbe, 0x58},
  /* 191 */ {1, 0.1319708865228925, 0xbf, 0x57},
  /* 192 */ {1, 0.1318398080287045, 0xc0, 0x55},
  /* 193 */ {1, 0.1317096685686114, 0xc1, 0x53},
  /* 194 */ {1, 0.1315804563506306, 0xc2, 0x51},
  /* 195 */ {1, 0.1314521597928493, 0xc3, 0x50},
  /* 196 */ {1, 0.1313247675185968, 0xc4, 0x4e},
  /* 197 */ {1, 0.1311982683517524, 0xc5, 0x4c},
  /* 198 */ {1, 0.1310726513121843, 0xc6, 0x4a},
  /* 199 */ {1, 0.1309479056113158, 0xc7, 0x49},
  /* 200 */ {1, 0.1308240206478128, 0xc8, 0x47},
  /* 201 */ {1, 0.1307009860033912, 0xc9, 0x46},
  /* 202 */ {1, 0.1305787914387386, 0xca, 0x44},
  /* 203 */ {1, 0.1304574268895465, 0xcb, 0x42},
  /* 204 */ {1, 0.1303368824626505, 0xcc, 0x41},
  /* 205 */ {1, 0.1302171484322746, 0xcd, 0x3f},
  /* 206 */ {1, 0.1300982152363760, 0xce, 0x3e},
  /* 207 */ {1, 0.1299800734730872, 0xcf, 0x3c},
  /* 208 */ {1, 0.1298627138972530, 0xd0, 0x3b},
  /* 209 */ {1, 0.1297461274170591, 0xd1, 0x39},
  /* 210 */ {1, 0.1296303050907487, 0xd2, 0x38},
  /* 211 */ {1, 0.1295152381234257, 0xd3, 0x36},
  /* 212 */ {1, 0.1294009178639407, 0xd4, 0x35},
  /* 213 */ {1, 0.1292873358018581, 0xd5, 0x33},
  /* 214 */ {1, 0.1291744835645007, 0xd6, 0x32},
  /* 215 */ {1, 0.1290623529140715, 0xd7, 0x30},
  /* 216 */ {1, 0.1289509357448472, 0xd8, 0x2f},
  /* 217 */ {1, 0.1288402240804449, 0xd9, 0x2e},
  /* 218 */ {1, 0.1287302100711566, 0xda, 0x2c},
  /* 219 */ {1, 0.1286208859913518, 0xdb, 0x2b},
  /* 220 */ {1, 0.1285122442369443, 0xdc, 0x29},
  /* 221 */ {1, 0.1284042773229231, 0xdd, 0x28},
  /* 222 */ {1, 0.1282969778809442, 0xde, 0x27},
  /* 223 */ {1, 0.1281903386569819, 0xdf, 0x25},
  /* 224 */ {1, 0.1280843525090381, 0xe0, 0x24},
  /* 225 */ {1, 0.1279790124049077, 0xe1, 0x23},
  /* 226 */ {1, 0.1278743114199984, 0xe2, 0x21},
  /* 227 */ {1, 0.1277702427352035, 0xe3, 0x20},
  /* 228 */ {1, 0.1276667996348261, 0xe4, 0x1f},
  /* 229 */ {1, 0.1275639755045533, 0xe5, 0x1e},
  /* 230 */ {1, 0.1274617638294791, 0xe6, 0x1c},
  /* 231 */ {1, 0.1273601581921740, 0xe7, 0x1b},
  /* 232 */ {1, 0.1272591522708010, 0xe8, 0x1a},
  /* 233 */ {1, 0.1271587398372755, 0xe9, 0x19},
  /* 234 */ {1, 0.1270589147554692, 0xea, 0x18},
  /* 235 */ {1, 0.1269596709794558, 0xeb, 0x16},
  /* 236 */ {1, 0.1268610025517973, 0xec, 0x15},
  /* 237 */ {1, 0.1267629036018709, 0xed, 0x14},
  /* 238 */ {1, 0.1266653683442337, 0xee, 0x13},
  /* 239 */ {1, 0.1265683910770258, 0xef, 0x12},
  /* 240 */ {1, 0.1264719661804097, 0xf0, 0x11},
  /* 241 */ {1, 0.1263760881150453, 0xf1, 0xf},
  /* 242 */ {1, 0.1262807514205999, 0xf2, 0xe},
  /* 243 */ {1, 0.1261859507142915, 0xf3, 0xd},
  /* 244 */ {1, 0.1260916806894653, 0xf4, 0xc},
  /* 245 */ {1, 0.1259979361142023, 0xf5, 0xb},
  /* 246 */ {1, 0.1259047118299582, 0xf6, 0xa},
  /* 247 */ {1, 0.1258120027502338, 0xf7, 0x9},
  /* 248 */ {1, 0.1257198038592741, 0xf8, 0x8},
  /* 249 */ {1, 0.1256281102107963, 0xf9, 0x7},
  /* 250 */ {1, 0.1255369169267456, 0xfa, 0x6},
  /* 251 */ {1, 0.1254462191960791, 0xfb, 0x5},
  /* 252 */ {1, 0.1253560122735751, 0xfc, 0x4},
  /* 253 */ {1, 0.1252662914786691, 0xfd, 0x3},
  /* 254 */ {1, 0.1251770521943144, 0xfe, 0x2},
  /* 255 */ {1, 0.1250882898658681, 0xff, 0x1},
};
#endif /* 8 */
#if BITS_PER_MP_LIMB == 16
const struct bases __mp_bases[256] =
{
  /*  0 */ {0, 0.0, 0, 0},
  /*  1 */ {0, 1e37, 0, 0},
  /*  2 */ {16, 1.0000000000000000, 0x1, 0x0},
  /*  3 */ {10, 0.6309297535714574, 0xe6a9, 0x1c1f},
  /*  4 */ {8, 0.5000000000000000, 0x2, 0x0},
  /*  5 */ {6, 0.4306765580733931, 0x3d09, 0xc6f},
  /*  6 */ {6, 0.3868528072345416, 0xb640, 0x6798},
  /*  7 */ {5, 0.3562071871080222, 0x41a7, 0xf31d},
  /*  8 */ {5, 0.3333333333333333, 0x3, 0x0},
  /*  9 */ {5, 0.3154648767857287, 0xe6a9, 0x1c1f},
  /* 10 */ {4, 0.3010299956639812, 0x2710, 0xa36e},
  /* 11 */ {4, 0.2890648263178878, 0x3931, 0x1e7a},
  /* 12 */ {4, 0.2789429456511298, 0x5100, 0x948b},
  /* 13 */ {4, 0.2702381544273197, 0x6f91, 0x25b5},
  /* 14 */ {4, 0.2626495350371935, 0x9610, 0xb4b9},
  /* 15 */ {4, 0.2559580248098155, 0xc5c1, 0x4b66},
  /* 16 */ {4, 0.2500000000000000, 0x4, 0x0},
  /* 17 */ {3, 0.2446505421182260, 0x1331, 0xaadb},
  /* 18 */ {3, 0.2398124665681314, 0x16c8, 0x6798},
  /* 19 */ {3, 0.2354089133666382, 0x1acb, 0x31c0},
  /* 20 */ {3, 0.2313782131597592, 0x1f40, 0x624},
  /* 21 */ {3, 0.2276702486969530, 0x242d, 0xc4e6},
  /* 22 */ {3, 0.2242438242175754, 0x2998, 0x89e7},
  /* 23 */ {3, 0.2210647294575037, 0x2f87, 0x58ba},
  /* 24 */ {3, 0.2181042919855316, 0x3600, 0x2f68},
  /* 25 */ {3, 0.2153382790366965, 0x3d09, 0xc6f},
  /* 26 */ {3, 0.2127460535533632, 0x44a8, 0xdd46},
  /* 27 */ {3, 0.2103099178571525, 0x4ce3, 0xaa2f},
  /* 28 */ {3, 0.2080145976765095, 0x55c0, 0x7e22},
  /* 29 */ {3, 0.2058468324604344, 0x5f45, 0x57f3},
  /* 30 */ {3, 0.2037950470905062, 0x6978, 0x36b0},
  /* 31 */ {3, 0.2018490865820999, 0x745f, 0x1994},
  /* 32 */ {3, 0.2000000000000000, 0x5, 0x0},
  /* 33 */ {3, 0.1982398631705605, 0x8c61, 0xd2d9},
  /* 34 */ {3, 0.1965616322328226, 0x9988, 0xaadb},
  /* 35 */ {3, 0.1949590218937863, 0xa77b, 0x874e},
  /* 36 */ {3, 0.1934264036172708, 0xb640, 0x6798},
  /* 37 */ {3, 0.1919587200065601, 0xc5dd, 0x4b37},
  /* 38 */ {3, 0.1905514124267734, 0xd658, 0x31c0},
  /* 39 */ {3, 0.1892003595168700, 0xe7b7, 0x1ad4},
  /* 40 */ {3, 0.1879018247091076, 0xfa00, 0x624},
  /* 41 */ {2, 0.1866524112389434, 0x691, 0x37e3},
  /* 42 */ {2, 0.1854490234153689, 0x6e4, 0x2937},
  /* 43 */ {2, 0.1842888331487062, 0x739, 0x1b8d},
  /* 44 */ {2, 0.1831692509136336, 0x790, 0xecf},
  /* 45 */ {2, 0.1820879004699383, 0x7e9, 0x2e8},
  /* 46 */ {2, 0.1810425967800402, 0x844, 0xef8b},
  /* 47 */ {2, 0.1800313266566926, 0x8a1, 0xdaae},
  /* 48 */ {2, 0.1790522317510414, 0x900, 0xc71c},
  /* 49 */ {2, 0.1781035935540111, 0x961, 0xb4b9},
  /* 50 */ {2, 0.1771838201355579, 0x9c4, 0xa36e},
  /* 51 */ {2, 0.1762914343888821, 0xa29, 0x9324},
  /* 52 */ {2, 0.1754250635819545, 0xa90, 0x83c9},
  /* 53 */ {2, 0.1745834300480449, 0xaf9, 0x754a},
  /* 54 */ {2, 0.1737653428714400, 0xb64, 0x6798},
  /* 55 */ {2, 0.1729696904450771, 0xbd1, 0x5aa2},
  /* 56 */ {2, 0.1721954337940981, 0xc40, 0x4e5e},
  /* 57 */ {2, 0.1714416005739134, 0xcb1, 0x42bc},
  /* 58 */ {2, 0.1707072796637201, 0xd24, 0x37b4},
  /* 59 */ {2, 0.1699916162869140, 0xd99, 0x2d3a},
  /* 60 */ {2, 0.1692938075987814, 0xe10, 0x2345},
  /* 61 */ {2, 0.1686130986895011, 0xe89, 0x19cc},
  /* 62 */ {2, 0.1679487789570419, 0xf04, 0x10c8},
  /* 63 */ {2, 0.1673001788101741, 0xf81, 0x831},
  /* 64 */ {2, 0.1666666666666667, 0x6, 0x0},
  /* 65 */ {2, 0.1660476462159378, 0x1081, 0xf05e},
  /* 66 */ {2, 0.1654425539190583, 0x1104, 0xe170},
  /* 67 */ {2, 0.1648508567221603, 0x1189, 0xd32c},
  /* 68 */ {2, 0.1642720499620502, 0x1210, 0xc589},
  /* 69 */ {2, 0.1637056554452156, 0x1299, 0xb87c},
  /* 70 */ {2, 0.1631512196835108, 0x1324, 0xabfd},
  /* 71 */ {2, 0.1626083122716342, 0x13b1, 0xa004},
  /* 72 */ {2, 0.1620765243931223, 0x1440, 0x948b},
  /* 73 */ {2, 0.1615554674429964, 0x14d1, 0x8989},
  /* 74 */ {2, 0.1610447717564444, 0x1564, 0x7ef8},
  /* 75 */ {2, 0.1605440854340214, 0x15f9, 0x74d3},
  /* 76 */ {2, 0.1600530732548213, 0x1690, 0x6b14},
  /* 77 */ {2, 0.1595714156699382, 0x1729, 0x61b5},
  /* 78 */ {2, 0.1590988078692941, 0x17c4, 0x58b3},
  /* 79 */ {2, 0.1586349589155960, 0x1861, 0x5007},
  /* 80 */ {2, 0.1581795909397823, 0x1900, 0x47ae},
  /* 81 */ {2, 0.1577324383928644, 0x19a1, 0x3fa3},
  /* 82 */ {2, 0.1572932473495469, 0x1a44, 0x37e3},
  /* 83 */ {2, 0.1568617748594410, 0x1ae9, 0x306b},
  /* 84 */ {2, 0.1564377883420715, 0x1b90, 0x2937},
  /* 85 */ {2, 0.1560210650222250, 0x1c39, 0x2243},
  /* 86 */ {2, 0.1556113914024939, 0x1ce4, 0x1b8d},
  /* 87 */ {2, 0.1552085627701551, 0x1d91, 0x1512},
  /* 88 */ {2, 0.1548123827357682, 0x1e40, 0xecf},
  /* 89 */ {2, 0.1544226628011101, 0x1ef1, 0x8c2},
  /* 90 */ {2, 0.1540392219542636, 0x1fa4, 0x2e8},
  /* 91 */ {2, 0.1536618862898642, 0x2059, 0xfa7f},
  /* 92 */ {2, 0.1532904886526781, 0x2110, 0xef8b},
  /* 93 */ {2, 0.1529248683028321, 0x21c9, 0xe4f2},
  /* 94 */ {2, 0.1525648706011593, 0x2284, 0xdaae},
  /* 95 */ {2, 0.1522103467132434, 0x2341, 0xd0be},
  /* 96 */ {2, 0.1518611533308632, 0x2400, 0xc71c},
  /* 97 */ {2, 0.1515171524096389, 0x24c1, 0xbdc6},
  /* 98 */ {2, 0.1511782109217764, 0x2584, 0xb4b9},
  /* 99 */ {2, 0.1508442006228941, 0x2649, 0xabf2},
  /* 100 */ {2, 0.1505149978319906, 0x2710, 0xa36e},
  /* 101 */ {2, 0.1501904832236880, 0x27d9, 0x9b2a},
  /* 102 */ {2, 0.1498705416319474, 0x28a4, 0x9324},
  /* 103 */ {2, 0.1495550618645152, 0x2971, 0x8b5a},
  /* 104 */ {2, 0.1492439365274121, 0x2a40, 0x83c9},
  /* 105 */ {2, 0.1489370618588283, 0x2b11, 0x7c6f},
  /* 106 */ {2, 0.1486343375718350, 0x2be4, 0x754a},
  /* 107 */ {2, 0.1483356667053617, 0x2cb9, 0x6e58},
  /* 108 */ {2, 0.1480409554829326, 0x2d90, 0x6798},
  /* 109 */ {2, 0.1477501131786861, 0x2e69, 0x6106},
  /* 110 */ {2, 0.1474630519902391, 0x2f44, 0x5aa2},
  /* 111 */ {2, 0.1471796869179852, 0x3021, 0x546b},
  /* 112 */ {2, 0.1468999356504447, 0x3100, 0x4e5e},
  /* 113 */ {2, 0.1466237184553111, 0x31e1, 0x4879},
  /* 114 */ {2, 0.1463509580758620, 0x32c4, 0x42bc},
  /* 115 */ {2, 0.1460815796324244, 0x33a9, 0x3d26},
  /* 116 */ {2, 0.1458155105286054, 0x3490, 0x37b4},
  /* 117 */ {2, 0.1455526803620167, 0x3579, 0x3266},
  /* 118 */ {2, 0.1452930208392429, 0x3664, 0x2d3a},
  /* 119 */ {2, 0.1450364656948130, 0x3751, 0x282f},
  /* 120 */ {2, 0.1447829506139581, 0x3840, 0x2345},
  /* 121 */ {2, 0.1445324131589439, 0x3931, 0x1e7a},
  /* 122 */ {2, 0.1442847926987864, 0x3a24, 0x19cc},
  /* 123 */ {2, 0.1440400303421672, 0x3b19, 0x153c},
  /* 124 */ {2, 0.1437980688733776, 0x3c10, 0x10c8},
  /* 125 */ {2, 0.1435588526911310, 0x3d09, 0xc6f},
  /* 126 */ {2, 0.1433223277500932, 0x3e04, 0x831},
  /* 127 */ {2, 0.1430884415049874, 0x3f01, 0x40c},
  /* 128 */ {2, 0.1428571428571428, 0x7, 0x0},
  /* 129 */ {2, 0.1426283821033600, 0x4101, 0xf817},
  /* 130 */ {2, 0.1424021108869747, 0x4204, 0xf05e},
  /* 131 */ {2, 0.1421782821510107, 0x4309, 0xe8d1},
  /* 132 */ {2, 0.1419568500933153, 0x4410, 0xe170},
  /* 133 */ {2, 0.1417377701235801, 0x4519, 0xda3a},
  /* 134 */ {2, 0.1415209988221527, 0x4624, 0xd32c},
  /* 135 */ {2, 0.1413064939005528, 0x4731, 0xcc47},
  /* 136 */ {2, 0.1410942141636095, 0x4840, 0xc589},
  /* 137 */ {2, 0.1408841194731412, 0x4951, 0xbef0},
  /* 138 */ {2, 0.1406761707131039, 0x4a64, 0xb87c},
  /* 139 */ {2, 0.1404703297561400, 0x4b79, 0xb22b},
  /* 140 */ {2, 0.1402665594314587, 0x4c90, 0xabfd},
  /* 141 */ {2, 0.1400648234939879, 0x4da9, 0xa5f0},
  /* 142 */ {2, 0.1398650865947379, 0x4ec4, 0xa004},
  /* 143 */ {2, 0.1396673142523192, 0x4fe1, 0x9a38},
  /* 144 */ {2, 0.1394714728255649, 0x5100, 0x948b},
  /* 145 */ {2, 0.1392775294872041, 0x5221, 0x8efb},
  /* 146 */ {2, 0.1390854521985406, 0x5344, 0x8989},
  /* 147 */ {2, 0.1388952096850913, 0x5469, 0x8433},
  /* 148 */ {2, 0.1387067714131417, 0x5590, 0x7ef8},
  /* 149 */ {2, 0.1385201075671774, 0x56b9, 0x79d9},
  /* 150 */ {2, 0.1383351890281539, 0x57e4, 0x74d3},
  /* 151 */ {2, 0.1381519873525671, 0x5911, 0x6fe7},
  /* 152 */ {2, 0.1379704747522905, 0x5a40, 0x6b14},
  /* 153 */ {2, 0.1377906240751463, 0x5b71, 0x6659},
  /* 154 */ {2, 0.1376124087861776, 0x5ca4, 0x61b5},
  /* 155 */ {2, 0.1374358029495937, 0x5dd9, 0x5d29},
  /* 156 */ {2, 0.1372607812113589, 0x5f10, 0x58b3},
  /* 157 */ {2, 0.1370873187823978, 0x6049, 0x5452},
  /* 158 */ {2, 0.1369153914223921, 0x6184, 0x5007},
  /* 159 */ {2, 0.1367449754241439, 0x62c1, 0x4bd0},
  /* 160 */ {2, 0.1365760475984821, 0x6400, 0x47ae},
  /* 161 */ {2, 0.1364085852596902, 0x6541, 0x439f},
  /* 162 */ {2, 0.1362425662114337, 0x6684, 0x3fa3},
  /* 163 */ {2, 0.1360779687331669, 0x67c9, 0x3bba},
  /* 164 */ {2, 0.1359147715670014, 0x6910, 0x37e3},
  /* 165 */ {2, 0.1357529539050150, 0x6a59, 0x341f},
  /* 166 */ {2, 0.1355924953769864, 0x6ba4, 0x306b},
  /* 167 */ {2, 0.1354333760385373, 0x6cf1, 0x2cc9},
  /* 168 */ {2, 0.1352755763596663, 0x6e40, 0x2937},
  /* 169 */ {2, 0.1351190772136599, 0x6f91, 0x25b5},
  /* 170 */ {2, 0.1349638598663645, 0x70e4, 0x2243},
  /* 171 */ {2, 0.1348099059658080, 0x7239, 0x1ee0},
  /* 172 */ {2, 0.1346571975321549, 0x7390, 0x1b8d},
  /* 173 */ {2, 0.1345057169479844, 0x74e9, 0x1848},
  /* 174 */ {2, 0.1343554469488779, 0x7644, 0x1512},
  /* 175 */ {2, 0.1342063706143054, 0x77a1, 0x11e9},
  /* 176 */ {2, 0.1340584713587979, 0x7900, 0xecf},
  /* 177 */ {2, 0.1339117329233981, 0x7a61, 0xbc2},
  /* 178 */ {2, 0.1337661393673756, 0x7bc4, 0x8c2},
  /* 179 */ {2, 0.1336216750601996, 0x7d29, 0x5ce},
  /* 180 */ {2, 0.1334783246737591, 0x7e90, 0x2e8},
  /* 181 */ {2, 0.1333360731748201, 0x7ff9, 0xe},
  /* 182 */ {2, 0.1331949058177136, 0x8164, 0xfa7f},
  /* 183 */ {2, 0.1330548081372441, 0x82d1, 0xf4fa},
  /* 184 */ {2, 0.1329157659418126, 0x8440, 0xef8b},
  /* 185 */ {2, 0.1327777653067443, 0x85b1, 0xea34},
  /* 186 */ {2, 0.1326407925678156, 0x8724, 0xe4f2},
  /* 187 */ {2, 0.1325048343149731, 0x8899, 0xdfc6},
  /* 188 */ {2, 0.1323698773862368, 0x8a10, 0xdaae},
  /* 189 */ {2, 0.1322359088617821, 0x8b89, 0xd5ac},
  /* 190 */ {2, 0.1321029160581950, 0x8d04, 0xd0be},
  /* 191 */ {2, 0.1319708865228925, 0x8e81, 0xcbe3},
  /* 192 */ {2, 0.1318398080287045, 0x9000, 0xc71c},
  /* 193 */ {2, 0.1317096685686114, 0x9181, 0xc268},
  /* 194 */ {2, 0.1315804563506306, 0x9304, 0xbdc6},
  /* 195 */ {2, 0.1314521597928493, 0x9489, 0xb937},
  /* 196 */ {2, 0.1313247675185968, 0x9610, 0xb4b9},
  /* 197 */ {2, 0.1311982683517524, 0x9799, 0xb04d},
  /* 198 */ {2, 0.1310726513121843, 0x9924, 0xabf2},
  /* 199 */ {2, 0.1309479056113158, 0x9ab1, 0xa7a8},
  /* 200 */ {2, 0.1308240206478128, 0x9c40, 0xa36e},
  /* 201 */ {2, 0.1307009860033912, 0x9dd1, 0x9f44},
  /* 202 */ {2, 0.1305787914387386, 0x9f64, 0x9b2a},
  /* 203 */ {2, 0.1304574268895465, 0xa0f9, 0x9720},
  /* 204 */ {2, 0.1303368824626505, 0xa290, 0x9324},
  /* 205 */ {2, 0.1302171484322746, 0xa429, 0x8f38},
  /* 206 */ {2, 0.1300982152363760, 0xa5c4, 0x8b5a},
  /* 207 */ {2, 0.1299800734730872, 0xa761, 0x878a},
  /* 208 */ {2, 0.1298627138972530, 0xa900, 0x83c9},
  /* 209 */ {2, 0.1297461274170591, 0xaaa1, 0x8015},
  /* 210 */ {2, 0.1296303050907487, 0xac44, 0x7c6f},
  /* 211 */ {2, 0.1295152381234257, 0xade9, 0x78d6},
  /* 212 */ {2, 0.1294009178639407, 0xaf90, 0x754a},
  /* 213 */ {2, 0.1292873358018581, 0xb139, 0x71cb},
  /* 214 */ {2, 0.1291744835645007, 0xb2e4, 0x6e58},
  /* 215 */ {2, 0.1290623529140715, 0xb491, 0x6af2},
  /* 216 */ {2, 0.1289509357448472, 0xb640, 0x6798},
  /* 217 */ {2, 0.1288402240804449, 0xb7f1, 0x6449},
  /* 218 */ {2, 0.1287302100711566, 0xb9a4, 0x6106},
  /* 219 */ {2, 0.1286208859913518, 0xbb59, 0x5dcf},
  /* 220 */ {2, 0.1285122442369443, 0xbd10, 0x5aa2},
  /* 221 */ {2, 0.1284042773229231, 0xbec9, 0x5781},
  /* 222 */ {2, 0.1282969778809442, 0xc084, 0x546b},
  /* 223 */ {2, 0.1281903386569819, 0xc241, 0x515f},
  /* 224 */ {2, 0.1280843525090381, 0xc400, 0x4e5e},
  /* 225 */ {2, 0.1279790124049077, 0xc5c1, 0x4b66},
  /* 226 */ {2, 0.1278743114199984, 0xc784, 0x4879},
  /* 227 */ {2, 0.1277702427352035, 0xc949, 0x4596},
  /* 228 */ {2, 0.1276667996348261, 0xcb10, 0x42bc},
  /* 229 */ {2, 0.1275639755045533, 0xccd9, 0x3fec},
  /* 230 */ {2, 0.1274617638294791, 0xcea4, 0x3d26},
  /* 231 */ {2, 0.1273601581921740, 0xd071, 0x3a68},
  /* 232 */ {2, 0.1272591522708010, 0xd240, 0x37b4},
  /* 233 */ {2, 0.1271587398372755, 0xd411, 0x3509},
  /* 234 */ {2, 0.1270589147554692, 0xd5e4, 0x3266},
  /* 235 */ {2, 0.1269596709794558, 0xd7b9, 0x2fcc},
  /* 236 */ {2, 0.1268610025517973, 0xd990, 0x2d3a},
  /* 237 */ {2, 0.1267629036018709, 0xdb69, 0x2ab1},
  /* 238 */ {2, 0.1266653683442337, 0xdd44, 0x282f},
  /* 239 */ {2, 0.1265683910770258, 0xdf21, 0x25b6},
  /* 240 */ {2, 0.1264719661804097, 0xe100, 0x2345},
  /* 241 */ {2, 0.1263760881150453, 0xe2e1, 0x20db},
  /* 242 */ {2, 0.1262807514205999, 0xe4c4, 0x1e7a},
  /* 243 */ {2, 0.1261859507142915, 0xe6a9, 0x1c1f},
  /* 244 */ {2, 0.1260916806894653, 0xe890, 0x19cc},
  /* 245 */ {2, 0.1259979361142023, 0xea79, 0x1780},
  /* 246 */ {2, 0.1259047118299582, 0xec64, 0x153c},
  /* 247 */ {2, 0.1258120027502338, 0xee51, 0x12fe},
  /* 248 */ {2, 0.1257198038592741, 0xf040, 0x10c8},
  /* 249 */ {2, 0.1256281102107963, 0xf231, 0xe98},
  /* 250 */ {2, 0.1255369169267456, 0xf424, 0xc6f},
  /* 251 */ {2, 0.1254462191960791, 0xf619, 0xa4d},
  /* 252 */ {2, 0.1253560122735751, 0xf810, 0x831},
  /* 253 */ {2, 0.1252662914786691, 0xfa09, 0x61b},
  /* 254 */ {2, 0.1251770521943144, 0xfc04, 0x40c},
  /* 255 */ {2, 0.1250882898658681, 0xfe01, 0x203},
};
#endif /* 16 */
#if BITS_PER_MP_LIMB == 32
const struct bases __mp_bases[256] =
{
  /*  0 */ {0, 0.0, 0, 0},
  /*  1 */ {0, 1e37, 0, 0},
  /*  2 */ {32, 1.0000000000000000, 0x1, 0x0},
  /*  3 */ {20, 0.6309297535714574, 0xcfd41b91, 0x3b563c24},
  /*  4 */ {16, 0.5000000000000000, 0x2, 0x0},
  /*  5 */ {13, 0.4306765580733931, 0x48c27395, 0xc25c2684},
  /*  6 */ {12, 0.3868528072345416, 0x81bf1000, 0xf91bd1b6},
  /*  7 */ {11, 0.3562071871080222, 0x75db9c97, 0x1607a2cb},
  /*  8 */ {10, 0.3333333333333333, 0x3, 0x0},
  /*  9 */ {10, 0.3154648767857287, 0xcfd41b91, 0x3b563c24},
  /* 10 */ {9, 0.3010299956639812, 0x3b9aca00, 0x12e0be82},
  /* 11 */ {9, 0.2890648263178878, 0x8c8b6d2b, 0xd24cde04},
  /* 12 */ {8, 0.2789429456511298, 0x19a10000, 0x3fa39ab5},
  /* 13 */ {8, 0.2702381544273197, 0x309f1021, 0x50f8ac5f},
  /* 14 */ {8, 0.2626495350371935, 0x57f6c100, 0x74843b1e},
  /* 15 */ {8, 0.2559580248098155, 0x98c29b81, 0xad0326c2},
  /* 16 */ {8, 0.2500000000000000, 0x4, 0x0},
  /* 17 */ {7, 0.2446505421182260, 0x18754571, 0x4ef0b6bd},
  /* 18 */ {7, 0.2398124665681314, 0x247dbc80, 0xc0fc48a1},
  /* 19 */ {7, 0.2354089133666382, 0x3547667b, 0x33838942},
  /* 20 */ {7, 0.2313782131597592, 0x4c4b4000, 0xad7f29ab},
  /* 21 */ {7, 0.2276702486969530, 0x6b5a6e1d, 0x313c3d15},
  /* 22 */ {7, 0.2242438242175754, 0x94ace180, 0xb8cca9e0},
  /* 23 */ {7, 0.2210647294575037, 0xcaf18367, 0x42ed6de9},
  /* 24 */ {6, 0.2181042919855316, 0xb640000, 0x67980e0b},
  /* 25 */ {6, 0.2153382790366965, 0xe8d4a51, 0x19799812},
  /* 26 */ {6, 0.2127460535533632, 0x1269ae40, 0xbce85396},
  /* 27 */ {6, 0.2103099178571525, 0x17179149, 0x62c103a9},
  /* 28 */ {6, 0.2080145976765095, 0x1cb91000, 0x1d353d43},
  /* 29 */ {6, 0.2058468324604344, 0x23744899, 0xce1decea},
  /* 30 */ {6, 0.2037950470905062, 0x2b73a840, 0x790fc511},
  /* 31 */ {6, 0.2018490865820999, 0x34e63b41, 0x35b865a0},
  /* 32 */ {6, 0.2000000000000000, 0x5, 0x0},
  /* 33 */ {6, 0.1982398631705605, 0x4cfa3cc1, 0xa9aed1b3},
  /* 34 */ {6, 0.1965616322328226, 0x5c13d840, 0x63dfc229},
  /* 35 */ {6, 0.1949590218937863, 0x6d91b519, 0x2b0fee30},
  /* 36 */ {6, 0.1934264036172708, 0x81bf1000, 0xf91bd1b6},
  /* 37 */ {6, 0.1919587200065601, 0x98ede0c9, 0xac89c3a9},
  /* 38 */ {6, 0.1905514124267734, 0xb3773e40, 0x6d2c32fe},
  /* 39 */ {6, 0.1892003595168700, 0xd1bbc4d1, 0x387907c9},
  /* 40 */ {6, 0.1879018247091076, 0xf4240000, 0xc6f7a0b},
  /* 41 */ {5, 0.1866524112389434, 0x6e7d349, 0x28928154},
  /* 42 */ {5, 0.1854490234153689, 0x7ca30a0, 0x6e8629d},
  /* 43 */ {5, 0.1842888331487062, 0x8c32bbb, 0xd373dca0},
  /* 44 */ {5, 0.1831692509136336, 0x9d46c00, 0xa0b17895},
  /* 45 */ {5, 0.1820879004699383, 0xaffacfd, 0x746811a5},
  /* 46 */ {5, 0.1810425967800402, 0xc46bee0, 0x4da6500f},
  /* 47 */ {5, 0.1800313266566926, 0xdab86ef, 0x2ba23582},
  /* 48 */ {5, 0.1790522317510414, 0xf300000, 0xdb20a88},
  /* 49 */ {5, 0.1781035935540111, 0x10d63af1, 0xe68d5ce4},
  /* 50 */ {5, 0.1771838201355579, 0x12a05f20, 0xb7cdfd9d},
  /* 51 */ {5, 0.1762914343888821, 0x1490aae3, 0x8e583933},
  /* 52 */ {5, 0.1754250635819545, 0x16a97400, 0x697cc3ea},
  /* 53 */ {5, 0.1745834300480449, 0x18ed2825, 0x48a5ca6c},
  /* 54 */ {5, 0.1737653428714400, 0x1b5e4d60, 0x2b52db16},
  /* 55 */ {5, 0.1729696904450771, 0x1dff8297, 0x111586a6},
  /* 56 */ {5, 0.1721954337940981, 0x20d38000, 0xf31d2b36},
  /* 57 */ {5, 0.1714416005739134, 0x23dd1799, 0xc8d76d19},
  /* 58 */ {5, 0.1707072796637201, 0x271f35a0, 0xa2cb1eb4},
  /* 59 */ {5, 0.1699916162869140, 0x2a9ce10b, 0x807c3ec3},
  /* 60 */ {5, 0.1692938075987814, 0x2e593c00, 0x617ec8bf},
  /* 61 */ {5, 0.1686130986895011, 0x3257844d, 0x45746cbe},
  /* 62 */ {5, 0.1679487789570419, 0x369b13e0, 0x2c0aa273},
  /* 63 */ {5, 0.1673001788101741, 0x3b27613f, 0x14f90805},
  /* 64 */ {5, 0.1666666666666667, 0x6, 0x0},
  /* 65 */ {5, 0.1660476462159378, 0x4528a141, 0xd9cf0829},
  /* 66 */ {5, 0.1654425539190583, 0x4aa51420, 0xb6fc4841},
  /* 67 */ {5, 0.1648508567221603, 0x50794633, 0x973054cb},
  /* 68 */ {5, 0.1642720499620502, 0x56a94400, 0x7a1dbe4b},
  /* 69 */ {5, 0.1637056554452156, 0x5d393975, 0x5f7fcd7f},
  /* 70 */ {5, 0.1631512196835108, 0x642d7260, 0x47196c84},
  /* 71 */ {5, 0.1626083122716342, 0x6b8a5ae7, 0x30b43635},
  /* 72 */ {5, 0.1620765243931223, 0x73548000, 0x1c1fa5f6},
  /* 73 */ {5, 0.1615554674429964, 0x7b908fe9, 0x930634a},
  /* 74 */ {5, 0.1610447717564444, 0x84435aa0, 0xef7f4a3c},
  /* 75 */ {5, 0.1605440854340214, 0x8d71d25b, 0xcf5552d2},
  /* 76 */ {5, 0.1600530732548213, 0x97210c00, 0xb1a47c8e},
  /* 77 */ {5, 0.1595714156699382, 0xa1563f9d, 0x9634b43e},
  /* 78 */ {5, 0.1590988078692941, 0xac16c8e0, 0x7cd3817d},
  /* 79 */ {5, 0.1586349589155960, 0xb768278f, 0x65536761},
  /* 80 */ {5, 0.1581795909397823, 0xc3500000, 0x4f8b588e},
  /* 81 */ {5, 0.1577324383928644, 0xcfd41b91, 0x3b563c24},
  /* 82 */ {5, 0.1572932473495469, 0xdcfa6920, 0x28928154},
  /* 83 */ {5, 0.1568617748594410, 0xeac8fd83, 0x1721bfb0},
  /* 84 */ {5, 0.1564377883420715, 0xf9461400, 0x6e8629d},
  /* 85 */ {4, 0.1560210650222250, 0x31c84b1, 0x491cc17c},
  /* 86 */ {4, 0.1556113914024939, 0x342ab10, 0x3a11d83b},
  /* 87 */ {4, 0.1552085627701551, 0x36a2c21, 0x2be074cd},
  /* 88 */ {4, 0.1548123827357682, 0x3931000, 0x1e7a02e7},
  /* 89 */ {4, 0.1544226628011101, 0x3bd5ee1, 0x11d10edd},
  /* 90 */ {4, 0.1540392219542636, 0x3e92110, 0x5d92c68},
  /* 91 */ {4, 0.1536618862898642, 0x4165ef1, 0xf50dbfb2},
  /* 92 */ {4, 0.1532904886526781, 0x4452100, 0xdf9f1316},
  /* 93 */ {4, 0.1529248683028321, 0x4756fd1, 0xcb52a684},
  /* 94 */ {4, 0.1525648706011593, 0x4a75410, 0xb8163e97},
  /* 95 */ {4, 0.1522103467132434, 0x4dad681, 0xa5d8f269},
  /* 96 */ {4, 0.1518611533308632, 0x5100000, 0x948b0fcd},
  /* 97 */ {4, 0.1515171524096389, 0x546d981, 0x841e0215},
  /* 98 */ {4, 0.1511782109217764, 0x57f6c10, 0x74843b1e},
  /* 99 */ {4, 0.1508442006228941, 0x5b9c0d1, 0x65b11e6e},
  /* 100 */ {4, 0.1505149978319906, 0x5f5e100, 0x5798ee23},
  /* 101 */ {4, 0.1501904832236880, 0x633d5f1, 0x4a30b99b},
  /* 102 */ {4, 0.1498705416319474, 0x673a910, 0x3d6e4d94},
  /* 103 */ {4, 0.1495550618645152, 0x6b563e1, 0x314825b0},
  /* 104 */ {4, 0.1492439365274121, 0x6f91000, 0x25b55f2e},
  /* 105 */ {4, 0.1489370618588283, 0x73eb721, 0x1aadaccb},
  /* 106 */ {4, 0.1486343375718350, 0x7866310, 0x10294ba2},
  /* 107 */ {4, 0.1483356667053617, 0x7d01db1, 0x620f8f6},
  /* 108 */ {4, 0.1480409554829326, 0x81bf100, 0xf91bd1b6},
  /* 109 */ {4, 0.1477501131786861, 0x869e711, 0xe6d37b2a},
  /* 110 */ {4, 0.1474630519902391, 0x8ba0a10, 0xd55cff6e},
  /* 111 */ {4, 0.1471796869179852, 0x90c6441, 0xc4ad2db2},
  /* 112 */ {4, 0.1468999356504447, 0x9610000, 0xb4b985cf},
  /* 113 */ {4, 0.1466237184553111, 0x9b7e7c1, 0xa5782bef},
  /* 114 */ {4, 0.1463509580758620, 0xa112610, 0x96dfdd2a},
  /* 115 */ {4, 0.1460815796324244, 0xa6cc591, 0x88e7e509},
  /* 116 */ {4, 0.1458155105286054, 0xacad100, 0x7b8813d3},
  /* 117 */ {4, 0.1455526803620167, 0xb2b5331, 0x6eb8b595},
  /* 118 */ {4, 0.1452930208392429, 0xb8e5710, 0x627289db},
  /* 119 */ {4, 0.1450364656948130, 0xbf3e7a1, 0x56aebc07},
  /* 120 */ {4, 0.1447829506139581, 0xc5c1000, 0x4b66dc33},
  /* 121 */ {4, 0.1445324131589439, 0xcc6db61, 0x4094d8a3},
  /* 122 */ {4, 0.1442847926987864, 0xd345510, 0x3632f7a5},
  /* 123 */ {4, 0.1440400303421672, 0xda48871, 0x2c3bd1f0},
  /* 124 */ {4, 0.1437980688733776, 0xe178100, 0x22aa4d5f},
  /* 125 */ {4, 0.1435588526911310, 0xe8d4a51, 0x19799812},
  /* 126 */ {4, 0.1433223277500932, 0xf05f010, 0x10a523e5},
  /* 127 */ {4, 0.1430884415049874, 0xf817e01, 0x828a237},
  /* 128 */ {4, 0.1428571428571428, 0x7, 0x0},
  /* 129 */ {4, 0.1426283821033600, 0x10818201, 0xf04ec452},
  /* 130 */ {4, 0.1424021108869747, 0x11061010, 0xe136444a},
  /* 131 */ {4, 0.1421782821510107, 0x118db651, 0xd2af9589},
  /* 132 */ {4, 0.1419568500933153, 0x12188100, 0xc4b42a83},
  /* 133 */ {4, 0.1417377701235801, 0x12a67c71, 0xb73dccf5},
  /* 134 */ {4, 0.1415209988221527, 0x1337b510, 0xaa4698c5},
  /* 135 */ {4, 0.1413064939005528, 0x13cc3761, 0x9dc8f729},
  /* 136 */ {4, 0.1410942141636095, 0x14641000, 0x91bf9a30},
  /* 137 */ {4, 0.1408841194731412, 0x14ff4ba1, 0x86257887},
  /* 138 */ {4, 0.1406761707131039, 0x159df710, 0x7af5c98c},
  /* 139 */ {4, 0.1404703297561400, 0x16401f31, 0x702c01a0},
  /* 140 */ {4, 0.1402665594314587, 0x16e5d100, 0x65c3ceb1},
  /* 141 */ {4, 0.1400648234939879, 0x178f1991, 0x5bb91502},
  /* 142 */ {4, 0.1398650865947379, 0x183c0610, 0x5207ec23},
  /* 143 */ {4, 0.1396673142523192, 0x18eca3c1, 0x48ac9c19},
  /* 144 */ {4, 0.1394714728255649, 0x19a10000, 0x3fa39ab5},
  /* 145 */ {4, 0.1392775294872041, 0x1a592841, 0x36e98912},
  /* 146 */ {4, 0.1390854521985406, 0x1b152a10, 0x2e7b3140},
  /* 147 */ {4, 0.1388952096850913, 0x1bd51311, 0x2655840b},
  /* 148 */ {4, 0.1387067714131417, 0x1c98f100, 0x1e7596ea},
  /* 149 */ {4, 0.1385201075671774, 0x1d60d1b1, 0x16d8a20d},
  /* 150 */ {4, 0.1383351890281539, 0x1e2cc310, 0xf7bfe87},
  /* 151 */ {4, 0.1381519873525671, 0x1efcd321, 0x85d2492},
  /* 152 */ {4, 0.1379704747522905, 0x1fd11000, 0x179a9f4},
  /* 153 */ {4, 0.1377906240751463, 0x20a987e1, 0xf59e80eb},
  /* 154 */ {4, 0.1376124087861776, 0x21864910, 0xe8b768db},
  /* 155 */ {4, 0.1374358029495937, 0x226761f1, 0xdc39d6d5},
  /* 156 */ {4, 0.1372607812113589, 0x234ce100, 0xd021c5d1},
  /* 157 */ {4, 0.1370873187823978, 0x2436d4d1, 0xc46b5e37},
  /* 158 */ {4, 0.1369153914223921, 0x25254c10, 0xb912f39c},
  /* 159 */ {4, 0.1367449754241439, 0x26185581, 0xae150294},
  /* 160 */ {4, 0.1365760475984821, 0x27100000, 0xa36e2eb1},
  /* 161 */ {4, 0.1364085852596902, 0x280c5a81, 0x991b4094},
  /* 162 */ {4, 0.1362425662114337, 0x290d7410, 0x8f19241e},
  /* 163 */ {4, 0.1360779687331669, 0x2a135bd1, 0x8564e6b7},
  /* 164 */ {4, 0.1359147715670014, 0x2b1e2100, 0x7bfbb5b4},
  /* 165 */ {4, 0.1357529539050150, 0x2c2dd2f1, 0x72dadcc8},
  /* 166 */ {4, 0.1355924953769864, 0x2d428110, 0x69ffc498},
  /* 167 */ {4, 0.1354333760385373, 0x2e5c3ae1, 0x6167f154},
  /* 168 */ {4, 0.1352755763596663, 0x2f7b1000, 0x5911016e},
  /* 169 */ {4, 0.1351190772136599, 0x309f1021, 0x50f8ac5f},
  /* 170 */ {4, 0.1349638598663645, 0x31c84b10, 0x491cc17c},
  /* 171 */ {4, 0.1348099059658080, 0x32f6d0b1, 0x417b26d8},
  /* 172 */ {4, 0.1346571975321549, 0x342ab100, 0x3a11d83b},
  /* 173 */ {4, 0.1345057169479844, 0x3563fc11, 0x32dee622},
  /* 174 */ {4, 0.1343554469488779, 0x36a2c210, 0x2be074cd},
  /* 175 */ {4, 0.1342063706143054, 0x37e71341, 0x2514bb58},
  /* 176 */ {4, 0.1340584713587979, 0x39310000, 0x1e7a02e7},
  /* 177 */ {4, 0.1339117329233981, 0x3a8098c1, 0x180ea5d0},
  /* 178 */ {4, 0.1337661393673756, 0x3bd5ee10, 0x11d10edd},
  /* 179 */ {4, 0.1336216750601996, 0x3d311091, 0xbbfb88e},
  /* 180 */ {4, 0.1334783246737591, 0x3e921100, 0x5d92c68},
  /* 181 */ {4, 0.1333360731748201, 0x3ff90031, 0x1c024c},
  /* 182 */ {4, 0.1331949058177136, 0x4165ef10, 0xf50dbfb2},
  /* 183 */ {4, 0.1330548081372441, 0x42d8eea1, 0xea30efa3},
  /* 184 */ {4, 0.1329157659418126, 0x44521000, 0xdf9f1316},
  /* 185 */ {4, 0.1327777653067443, 0x45d16461, 0xd555c0c9},
  /* 186 */ {4, 0.1326407925678156, 0x4756fd10, 0xcb52a684},
  /* 187 */ {4, 0.1325048343149731, 0x48e2eb71, 0xc193881f},
  /* 188 */ {4, 0.1323698773862368, 0x4a754100, 0xb8163e97},
  /* 189 */ {4, 0.1322359088617821, 0x4c0e0f51, 0xaed8b724},
  /* 190 */ {4, 0.1321029160581950, 0x4dad6810, 0xa5d8f269},
  /* 191 */ {4, 0.1319708865228925, 0x4f535d01, 0x9d15039d},
  /* 192 */ {4, 0.1318398080287045, 0x51000000, 0x948b0fcd},
  /* 193 */ {4, 0.1317096685686114, 0x52b36301, 0x8c394d1d},
  /* 194 */ {4, 0.1315804563506306, 0x546d9810, 0x841e0215},
  /* 195 */ {4, 0.1314521597928493, 0x562eb151, 0x7c3784f8},
  /* 196 */ {4, 0.1313247675185968, 0x57f6c100, 0x74843b1e},
  /* 197 */ {4, 0.1311982683517524, 0x59c5d971, 0x6d02985d},
  /* 198 */ {4, 0.1310726513121843, 0x5b9c0d10, 0x65b11e6e},
  /* 199 */ {4, 0.1309479056113158, 0x5d796e61, 0x5e8e5c64},
  /* 200 */ {4, 0.1308240206478128, 0x5f5e1000, 0x5798ee23},
  /* 201 */ {4, 0.1307009860033912, 0x614a04a1, 0x50cf7bde},
  /* 202 */ {4, 0.1305787914387386, 0x633d5f10, 0x4a30b99b},
  /* 203 */ {4, 0.1304574268895465, 0x65383231, 0x43bb66bd},
  /* 204 */ {4, 0.1303368824626505, 0x673a9100, 0x3d6e4d94},
  /* 205 */ {4, 0.1302171484322746, 0x69448e91, 0x374842ee},
  /* 206 */ {4, 0.1300982152363760, 0x6b563e10, 0x314825b0},
  /* 207 */ {4, 0.1299800734730872, 0x6d6fb2c1, 0x2b6cde75},
  /* 208 */ {4, 0.1298627138972530, 0x6f910000, 0x25b55f2e},
  /* 209 */ {4, 0.1297461274170591, 0x71ba3941, 0x2020a2c5},
  /* 210 */ {4, 0.1296303050907487, 0x73eb7210, 0x1aadaccb},
  /* 211 */ {4, 0.1295152381234257, 0x7624be11, 0x155b891f},
  /* 212 */ {4, 0.1294009178639407, 0x78663100, 0x10294ba2},
  /* 213 */ {4, 0.1292873358018581, 0x7aafdeb1, 0xb160fe9},
  /* 214 */ {4, 0.1291744835645007, 0x7d01db10, 0x620f8f6},
  /* 215 */ {4, 0.1290623529140715, 0x7f5c3a21, 0x14930ef},
  /* 216 */ {4, 0.1289509357448472, 0x81bf1000, 0xf91bd1b6},
  /* 217 */ {4, 0.1288402240804449, 0x842a70e1, 0xefdcb0c7},
  /* 218 */ {4, 0.1287302100711566, 0x869e7110, 0xe6d37b2a},
  /* 219 */ {4, 0.1286208859913518, 0x891b24f1, 0xddfeb94a},
  /* 220 */ {4, 0.1285122442369443, 0x8ba0a100, 0xd55cff6e},
  /* 221 */ {4, 0.1284042773229231, 0x8e2ef9d1, 0xcceced50},
  /* 222 */ {4, 0.1282969778809442, 0x90c64410, 0xc4ad2db2},
  /* 223 */ {4, 0.1281903386569819, 0x93669481, 0xbc9c75f9},
  /* 224 */ {4, 0.1280843525090381, 0x96100000, 0xb4b985cf},
  /* 225 */ {4, 0.1279790124049077, 0x98c29b81, 0xad0326c2},
  /* 226 */ {4, 0.1278743114199984, 0x9b7e7c10, 0xa5782bef},
  /* 227 */ {4, 0.1277702427352035, 0x9e43b6d1, 0x9e1771a9},
  /* 228 */ {4, 0.1276667996348261, 0xa1126100, 0x96dfdd2a},
  /* 229 */ {4, 0.1275639755045533, 0xa3ea8ff1, 0x8fd05c41},
  /* 230 */ {4, 0.1274617638294791, 0xa6cc5910, 0x88e7e509},
  /* 231 */ {4, 0.1273601581921740, 0xa9b7d1e1, 0x8225759d},
  /* 232 */ {4, 0.1272591522708010, 0xacad1000, 0x7b8813d3},
  /* 233 */ {4, 0.1271587398372755, 0xafac2921, 0x750eccf9},
  /* 234 */ {4, 0.1270589147554692, 0xb2b53310, 0x6eb8b595},
  /* 235 */ {4, 0.1269596709794558, 0xb5c843b1, 0x6884e923},
  /* 236 */ {4, 0.1268610025517973, 0xb8e57100, 0x627289db},
  /* 237 */ {4, 0.1267629036018709, 0xbc0cd111, 0x5c80c07b},
  /* 238 */ {4, 0.1266653683442337, 0xbf3e7a10, 0x56aebc07},
  /* 239 */ {4, 0.1265683910770258, 0xc27a8241, 0x50fbb19b},
  /* 240 */ {4, 0.1264719661804097, 0xc5c10000, 0x4b66dc33},
  /* 241 */ {4, 0.1263760881150453, 0xc91209c1, 0x45ef7c7c},
  /* 242 */ {4, 0.1262807514205999, 0xcc6db610, 0x4094d8a3},
  /* 243 */ {4, 0.1261859507142915, 0xcfd41b91, 0x3b563c24},
  /* 244 */ {4, 0.1260916806894653, 0xd3455100, 0x3632f7a5},
  /* 245 */ {4, 0.1259979361142023, 0xd6c16d31, 0x312a60c3},
  /* 246 */ {4, 0.1259047118299582, 0xda488710, 0x2c3bd1f0},
  /* 247 */ {4, 0.1258120027502338, 0xdddab5a1, 0x2766aa45},
  /* 248 */ {4, 0.1257198038592741, 0xe1781000, 0x22aa4d5f},
  /* 249 */ {4, 0.1256281102107963, 0xe520ad61, 0x1e06233c},
  /* 250 */ {4, 0.1255369169267456, 0xe8d4a510, 0x19799812},
  /* 251 */ {4, 0.1254462191960791, 0xec940e71, 0x15041c33},
  /* 252 */ {4, 0.1253560122735751, 0xf05f0100, 0x10a523e5},
  /* 253 */ {4, 0.1252662914786691, 0xf4359451, 0xc5c2749},
  /* 254 */ {4, 0.1251770521943144, 0xf817e010, 0x828a237},
  /* 255 */ {4, 0.1250882898658681, 0xfc05fc01, 0x40a1423},
};
#endif /* 32 */
#if BITS_PER_MP_LIMB == 64
const struct bases __mp_bases[256] =
{
  /*  0 */ {0, 0.0, 0, 0},
  /*  1 */ {0, 1e37, 0, 0},
  /*  2 */ {64, 1.0000000000000000, 0x1, 0x0},
  /*  3 */ {40, 0.6309297535714574, CNST_LIMB(0xa8b8b452291fe821), CNST_LIMB(0x846d550e37b5063d)},
  /*  4 */ {32, 0.5000000000000000, 0x2, 0x0},
  /*  5 */ {27, 0.4306765580733931, CNST_LIMB(0x6765c793fa10079d), CNST_LIMB(0x3ce9a36f23c0fc90)},
  /*  6 */ {24, 0.3868528072345416, CNST_LIMB(0x41c21cb8e1000000), CNST_LIMB(0xf24f62335024a295)},
  /*  7 */ {22, 0.3562071871080222, CNST_LIMB(0x3642798750226111), CNST_LIMB(0x2df495ccaa57147b)},
  /*  8 */ {21, 0.3333333333333333, 0x3, 0x0},
  /*  9 */ {20, 0.3154648767857287, CNST_LIMB(0xa8b8b452291fe821), CNST_LIMB(0x846d550e37b5063d)},
  /* 10 */ {19, 0.3010299956639812, CNST_LIMB(0x8ac7230489e80000), CNST_LIMB(0xd83c94fb6d2ac34a)},
  /* 11 */ {18, 0.2890648263178878, CNST_LIMB(0x4d28cb56c33fa539), CNST_LIMB(0xa8adf7ae45e7577b)},
  /* 12 */ {17, 0.2789429456511298, CNST_LIMB(0x1eca170c00000000), CNST_LIMB(0xa10c2bec5da8f8f)},
  /* 13 */ {17, 0.2702381544273197, CNST_LIMB(0x780c7372621bd74d), CNST_LIMB(0x10f4becafe412ec3)},
  /* 14 */ {16, 0.2626495350371935, CNST_LIMB(0x1e39a5057d810000), CNST_LIMB(0xf08480f672b4e86)},
  /* 15 */ {16, 0.2559580248098155, CNST_LIMB(0x5b27ac993df97701), CNST_LIMB(0x6779c7f90dc42f48)},
  /* 16 */ {16, 0.2500000000000000, 0x4, 0x0},
  /* 17 */ {15, 0.2446505421182260, CNST_LIMB(0x27b95e997e21d9f1), CNST_LIMB(0x9c71e11bab279323)},
  /* 18 */ {15, 0.2398124665681314, CNST_LIMB(0x5da0e1e53c5c8000), CNST_LIMB(0x5dfaa697ec6f6a1c)},
  /* 19 */ {15, 0.2354089133666382, CNST_LIMB(0xd2ae3299c1c4aedb), CNST_LIMB(0x3711783f6be7e9ec)},
  /* 20 */ {14, 0.2313782131597592, CNST_LIMB(0x16bcc41e90000000), CNST_LIMB(0x6849b86a12b9b01e)},
  /* 21 */ {14, 0.2276702486969530, CNST_LIMB(0x2d04b7fdd9c0ef49), CNST_LIMB(0x6bf097ba5ca5e239)},
  /* 22 */ {14, 0.2242438242175754, CNST_LIMB(0x5658597bcaa24000), CNST_LIMB(0x7b8015c8d7af8f08)},
  /* 23 */ {14, 0.2210647294575037, CNST_LIMB(0xa0e2073737609371), CNST_LIMB(0x975a24b3a3151b38)},
  /* 24 */ {13, 0.2181042919855316, CNST_LIMB(0xc29e98000000000), CNST_LIMB(0x50bd367972689db1)},
  /* 25 */ {13, 0.2153382790366965, CNST_LIMB(0x14adf4b7320334b9), CNST_LIMB(0x8c240c4aecb13bb5)},
  /* 26 */ {13, 0.2127460535533632, CNST_LIMB(0x226ed36478bfa000), CNST_LIMB(0xdbd2e56854e118c9)},
  /* 27 */ {13, 0.2103099178571525, CNST_LIMB(0x383d9170b85ff80b), CNST_LIMB(0x2351ffcaa9c7c4ae)},
  /* 28 */ {13, 0.2080145976765095, CNST_LIMB(0x5a3c23e39c000000), CNST_LIMB(0x6b24188ca33b0636)},
  /* 29 */ {13, 0.2058468324604344, CNST_LIMB(0x8e65137388122bcd), CNST_LIMB(0xcc3dceaf2b8ba99d)},
  /* 30 */ {13, 0.2037950470905062, CNST_LIMB(0xdd41bb36d259e000), CNST_LIMB(0x2832e835c6c7d6b6)},
  /* 31 */ {12, 0.2018490865820999, CNST_LIMB(0xaee5720ee830681), CNST_LIMB(0x76b6aa272e1873c5)},
  /* 32 */ {12, 0.2000000000000000, 0x5, 0x0},
  /* 33 */ {12, 0.1982398631705605, CNST_LIMB(0x172588ad4f5f0981), CNST_LIMB(0x61eaf5d402c7bf4f)},
  /* 34 */ {12, 0.1965616322328226, CNST_LIMB(0x211e44f7d02c1000), CNST_LIMB(0xeeb658123ffb27ec)},
  /* 35 */ {12, 0.1949590218937863, CNST_LIMB(0x2ee56725f06e5c71), CNST_LIMB(0x5d5e3762e6fdf509)},
  /* 36 */ {12, 0.1934264036172708, CNST_LIMB(0x41c21cb8e1000000), CNST_LIMB(0xf24f62335024a295)},
  /* 37 */ {12, 0.1919587200065601, CNST_LIMB(0x5b5b57f8a98a5dd1), CNST_LIMB(0x66ae7831762efb6f)},
  /* 38 */ {12, 0.1905514124267734, CNST_LIMB(0x7dcff8986ea31000), CNST_LIMB(0x47388865a00f544)},
  /* 39 */ {12, 0.1892003595168700, CNST_LIMB(0xabd4211662a6b2a1), CNST_LIMB(0x7d673c33a123b54c)},
  /* 40 */ {12, 0.1879018247091076, CNST_LIMB(0xe8d4a51000000000), CNST_LIMB(0x19799812dea11197)},
  /* 41 */ {11, 0.1866524112389434, CNST_LIMB(0x7a32956ad081b79), CNST_LIMB(0xc27e62e0686feae)},
  /* 42 */ {11, 0.1854490234153689, CNST_LIMB(0x9f49aaff0e86800), CNST_LIMB(0x9b6e7507064ce7c7)},
  /* 43 */ {11, 0.1842888331487062, CNST_LIMB(0xce583bb812d37b3), CNST_LIMB(0x3d9ac2bf66cfed94)},
  /* 44 */ {11, 0.1831692509136336, CNST_LIMB(0x109b79a654c00000), CNST_LIMB(0xed46bc50ce59712a)},
  /* 45 */ {11, 0.1820879004699383, CNST_LIMB(0x1543beff214c8b95), CNST_LIMB(0x813d97e2c89b8d46)},
  /* 46 */ {11, 0.1810425967800402, CNST_LIMB(0x1b149a79459a3800), CNST_LIMB(0x2e81751956af8083)},
  /* 47 */ {11, 0.1800313266566926, CNST_LIMB(0x224edfb5434a830f), CNST_LIMB(0xdd8e0a95e30c0988)},
  /* 48 */ {11, 0.1790522317510414, CNST_LIMB(0x2b3fb00000000000), CNST_LIMB(0x7ad4dd48a0b5b167)},
  /* 49 */ {11, 0.1781035935540111, CNST_LIMB(0x3642798750226111), CNST_LIMB(0x2df495ccaa57147b)},
  /* 50 */ {11, 0.1771838201355579, CNST_LIMB(0x43c33c1937564800), CNST_LIMB(0xe392010175ee5962)},
  /* 51 */ {11, 0.1762914343888821, CNST_LIMB(0x54411b2441c3cd8b), CNST_LIMB(0x84eaf11b2fe7738e)},
  /* 52 */ {11, 0.1754250635819545, CNST_LIMB(0x6851455acd400000), CNST_LIMB(0x3a1e3971e008995d)},
  /* 53 */ {11, 0.1745834300480449, CNST_LIMB(0x80a23b117c8feb6d), CNST_LIMB(0xfd7a462344ffce25)},
  /* 54 */ {11, 0.1737653428714400, CNST_LIMB(0x9dff7d32d5dc1800), CNST_LIMB(0x9eca40b40ebcef8a)},
  /* 55 */ {11, 0.1729696904450771, CNST_LIMB(0xc155af6faeffe6a7), CNST_LIMB(0x52fa161a4a48e43d)},
  /* 56 */ {11, 0.1721954337940981, CNST_LIMB(0xebb7392e00000000), CNST_LIMB(0x1607a2cbacf930c1)},
  /* 57 */ {10, 0.1714416005739134, CNST_LIMB(0x50633659656d971), CNST_LIMB(0x97a014f8e3be55f1)},
  /* 58 */ {10, 0.1707072796637201, CNST_LIMB(0x5fa8624c7fba400), CNST_LIMB(0x568df8b76cbf212c)},
  /* 59 */ {10, 0.1699916162869140, CNST_LIMB(0x717d9faa73c5679), CNST_LIMB(0x20ba7c4b4e6ef492)},
  /* 60 */ {10, 0.1692938075987814, CNST_LIMB(0x86430aac6100000), CNST_LIMB(0xe81ee46b9ef492f5)},
  /* 61 */ {10, 0.1686130986895011, CNST_LIMB(0x9e64d9944b57f29), CNST_LIMB(0x9dc0d10d51940416)},
  /* 62 */ {10, 0.1679487789570419, CNST_LIMB(0xba5ca5392cb0400), CNST_LIMB(0x5fa8ed2f450272a5)},
  /* 63 */ {10, 0.1673001788101741, CNST_LIMB(0xdab2ce1d022cd81), CNST_LIMB(0x2ba9eb8c5e04e641)},
  /* 64 */ {10, 0.1666666666666667, 0x6, 0x0},
  /* 65 */ {10, 0.1660476462159378, CNST_LIMB(0x12aeed5fd3e2d281), CNST_LIMB(0xb67759cc00287bf1)},
  /* 66 */ {10, 0.1654425539190583, CNST_LIMB(0x15c3da1572d50400), CNST_LIMB(0x78621feeb7f4ed33)},
  /* 67 */ {10, 0.1648508567221603, CNST_LIMB(0x194c05534f75ee29), CNST_LIMB(0x43d55b5f72943bc0)},
  /* 68 */ {10, 0.1642720499620502, CNST_LIMB(0x1d56299ada100000), CNST_LIMB(0x173decb64d1d4409)},
  /* 69 */ {10, 0.1637056554452156, CNST_LIMB(0x21f2a089a4ff4f79), CNST_LIMB(0xe29fb54fd6b6074f)},
  /* 70 */ {10, 0.1631512196835108, CNST_LIMB(0x2733896c68d9a400), CNST_LIMB(0xa1f1f5c210d54e62)},
  /* 71 */ {10, 0.1626083122716342, CNST_LIMB(0x2d2cf2c33b533c71), CNST_LIMB(0x6aac7f9bfafd57b2)},
  /* 72 */ {10, 0.1620765243931223, CNST_LIMB(0x33f506e440000000), CNST_LIMB(0x3b563c2478b72ee2)},
  /* 73 */ {10, 0.1615554674429964, CNST_LIMB(0x3ba43bec1d062211), CNST_LIMB(0x12b536b574e92d1b)},
  /* 74 */ {10, 0.1610447717564444, CNST_LIMB(0x4455872d8fd4e400), CNST_LIMB(0xdf86c03020404fa5)},
  /* 75 */ {10, 0.1605440854340214, CNST_LIMB(0x4e2694539f2f6c59), CNST_LIMB(0xa34adf02234eea8e)},
  /* 76 */ {10, 0.1600530732548213, CNST_LIMB(0x5938006c18900000), CNST_LIMB(0x6f46eb8574eb59dd)},
  /* 77 */ {10, 0.1595714156699382, CNST_LIMB(0x65ad9912474aa649), CNST_LIMB(0x42459b481df47cec)},
  /* 78 */ {10, 0.1590988078692941, CNST_LIMB(0x73ae9ff4241ec400), CNST_LIMB(0x1b424b95d80ca505)},
  /* 79 */ {10, 0.1586349589155960, CNST_LIMB(0x836612ee9c4ce1e1), CNST_LIMB(0xf2c1b982203a0dac)},
  /* 80 */ {10, 0.1581795909397823, CNST_LIMB(0x9502f90000000000), CNST_LIMB(0xb7cdfd9d7bdbab7d)},
  /* 81 */ {10, 0.1577324383928644, CNST_LIMB(0xa8b8b452291fe821), CNST_LIMB(0x846d550e37b5063d)},
  /* 82 */ {10, 0.1572932473495469, CNST_LIMB(0xbebf59a07dab4400), CNST_LIMB(0x57931eeaf85cf64f)},
  /* 83 */ {10, 0.1568617748594410, CNST_LIMB(0xd7540d4093bc3109), CNST_LIMB(0x305a944507c82f47)},
  /* 84 */ {10, 0.1564377883420715, CNST_LIMB(0xf2b96616f1900000), CNST_LIMB(0xe007ccc9c22781a)},
  /* 85 */ {9, 0.1560210650222250, CNST_LIMB(0x336de62af2bca35), CNST_LIMB(0x3e92c42e000eeed4)},
  /* 86 */ {9, 0.1556113914024939, CNST_LIMB(0x39235ec33d49600), CNST_LIMB(0x1ebe59130db2795e)},
  /* 87 */ {9, 0.1552085627701551, CNST_LIMB(0x3f674e539585a17), CNST_LIMB(0x268859e90f51b89)},
  /* 88 */ {9, 0.1548123827357682, CNST_LIMB(0x4645b6958000000), CNST_LIMB(0xd24cde0463108cfa)},
  /* 89 */ {9, 0.1544226628011101, CNST_LIMB(0x4dcb74afbc49c19), CNST_LIMB(0xa536009f37adc383)},
  /* 90 */ {9, 0.1540392219542636, CNST_LIMB(0x56064e1d18d9a00), CNST_LIMB(0x7cea06ce1c9ace10)},
  /* 91 */ {9, 0.1536618862898642, CNST_LIMB(0x5f04fe2cd8a39fb), CNST_LIMB(0x58db032e72e8ba43)},
  /* 92 */ {9, 0.1532904886526781, CNST_LIMB(0x68d74421f5c0000), CNST_LIMB(0x388cc17cae105447)},
  /* 93 */ {9, 0.1529248683028321, CNST_LIMB(0x738df1f6ab4827d), CNST_LIMB(0x1b92672857620ce0)},
  /* 94 */ {9, 0.1525648706011593, CNST_LIMB(0x7f3afbc9cfb5e00), CNST_LIMB(0x18c6a9575c2ade4)},
  /* 95 */ {9, 0.1522103467132434, CNST_LIMB(0x8bf187fba88f35f), CNST_LIMB(0xd44da7da8e44b24f)},
  /* 96 */ {9, 0.1518611533308632, CNST_LIMB(0x99c600000000000), CNST_LIMB(0xaa2f78f1b4cc6794)},
  /* 97 */ {9, 0.1515171524096389, CNST_LIMB(0xa8ce21eb6531361), CNST_LIMB(0x843c067d091ee4cc)},
  /* 98 */ {9, 0.1511782109217764, CNST_LIMB(0xb92112c1a0b6200), CNST_LIMB(0x62005e1e913356e3)},
  /* 99 */ {9, 0.1508442006228941, CNST_LIMB(0xcad7718b8747c43), CNST_LIMB(0x4316eed01dedd518)},
  /* 100 */ {9, 0.1505149978319906, CNST_LIMB(0xde0b6b3a7640000), CNST_LIMB(0x2725dd1d243aba0e)},
  /* 101 */ {9, 0.1501904832236880, CNST_LIMB(0xf2d8cf5fe6d74c5), CNST_LIMB(0xddd9057c24cb54f)},
  /* 102 */ {9, 0.1498705416319474, CNST_LIMB(0x1095d25bfa712600), CNST_LIMB(0xedeee175a736d2a1)},
  /* 103 */ {9, 0.1495550618645152, CNST_LIMB(0x121b7c4c3698faa7), CNST_LIMB(0xc4699f3df8b6b328)},
  /* 104 */ {9, 0.1492439365274121, CNST_LIMB(0x13c09e8d68000000), CNST_LIMB(0x9ebbe7d859cb5a7c)},
  /* 105 */ {9, 0.1489370618588283, CNST_LIMB(0x15876ccb0b709ca9), CNST_LIMB(0x7c828b9887eb2179)},
  /* 106 */ {9, 0.1486343375718350, CNST_LIMB(0x17723c2976da2a00), CNST_LIMB(0x5d652ab99001adcf)},
  /* 107 */ {9, 0.1483356667053617, CNST_LIMB(0x198384e9c259048b), CNST_LIMB(0x4114f1754e5d7b32)},
  /* 108 */ {9, 0.1480409554829326, CNST_LIMB(0x1bbde41dfeec0000), CNST_LIMB(0x274b7c902f7e0188)},
  /* 109 */ {9, 0.1477501131786861, CNST_LIMB(0x1e241d6e3337910d), CNST_LIMB(0xfc9e0fbb32e210c)},
  /* 110 */ {9, 0.1474630519902391, CNST_LIMB(0x20b91cee9901ee00), CNST_LIMB(0xf4afa3e594f8ea1f)},
  /* 111 */ {9, 0.1471796869179852, CNST_LIMB(0x237ff9079863dfef), CNST_LIMB(0xcd85c32e9e4437b0)},
  /* 112 */ {9, 0.1468999356504447, CNST_LIMB(0x267bf47000000000), CNST_LIMB(0xa9bbb147e0dd92a8)},
  /* 113 */ {9, 0.1466237184553111, CNST_LIMB(0x29b08039fbeda7f1), CNST_LIMB(0x8900447b70e8eb82)},
  /* 114 */ {9, 0.1463509580758620, CNST_LIMB(0x2d213df34f65f200), CNST_LIMB(0x6b0a92adaad5848a)},
  /* 115 */ {9, 0.1460815796324244, CNST_LIMB(0x30d201d957a7c2d3), CNST_LIMB(0x4f990ad8740f0ee5)},
  /* 116 */ {9, 0.1458155105286054, CNST_LIMB(0x34c6d52160f40000), CNST_LIMB(0x3670a9663a8d3610)},
  /* 117 */ {9, 0.1455526803620167, CNST_LIMB(0x3903f855d8f4c755), CNST_LIMB(0x1f5c44188057be3c)},
  /* 118 */ {9, 0.1452930208392429, CNST_LIMB(0x3d8de5c8ec59b600), CNST_LIMB(0xa2bea956c4e4977)},
  /* 119 */ {9, 0.1450364656948130, CNST_LIMB(0x4269541d1ff01337), CNST_LIMB(0xed68b23033c3637e)},
  /* 120 */ {9, 0.1447829506139581, CNST_LIMB(0x479b38e478000000), CNST_LIMB(0xc99cf624e50549c5)},
  /* 121 */ {9, 0.1445324131589439, CNST_LIMB(0x4d28cb56c33fa539), CNST_LIMB(0xa8adf7ae45e7577b)},
  /* 122 */ {9, 0.1442847926987864, CNST_LIMB(0x5317871fa13aba00), CNST_LIMB(0x8a5bc740b1c113e5)},
  /* 123 */ {9, 0.1440400303421672, CNST_LIMB(0x596d2f44de9fa71b), CNST_LIMB(0x6e6c7efb81cfbb9b)},
  /* 124 */ {9, 0.1437980688733776, CNST_LIMB(0x602fd125c47c0000), CNST_LIMB(0x54aba5c5cada5f10)},
  /* 125 */ {9, 0.1435588526911310, CNST_LIMB(0x6765c793fa10079d), CNST_LIMB(0x3ce9a36f23c0fc90)},
  /* 126 */ {9, 0.1433223277500932, CNST_LIMB(0x6f15be069b847e00), CNST_LIMB(0x26fb43de2c8cd2a8)},
  /* 127 */ {9, 0.1430884415049874, CNST_LIMB(0x7746b3e82a77047f), CNST_LIMB(0x12b94793db8486a1)},
  /* 128 */ {9, 0.1428571428571428, 0x7, 0x0},
  /* 129 */ {9, 0.1426283821033600, CNST_LIMB(0x894953f7ea890481), CNST_LIMB(0xdd5deca404c0156d)},
  /* 130 */ {9, 0.1424021108869747, CNST_LIMB(0x932abffea4848200), CNST_LIMB(0xbd51373330291de0)},
  /* 131 */ {9, 0.1421782821510107, CNST_LIMB(0x9dacb687d3d6a163), CNST_LIMB(0x9fa4025d66f23085)},
  /* 132 */ {9, 0.1419568500933153, CNST_LIMB(0xa8d8102a44840000), CNST_LIMB(0x842530ee2db4949d)},
  /* 133 */ {9, 0.1417377701235801, CNST_LIMB(0xb4b60f9d140541e5), CNST_LIMB(0x6aa7f2766b03dc25)},
  /* 134 */ {9, 0.1415209988221527, CNST_LIMB(0xc15065d4856e4600), CNST_LIMB(0x53035ba7ebf32e8d)},
  /* 135 */ {9, 0.1413064939005528, CNST_LIMB(0xceb1363f396d23c7), CNST_LIMB(0x3d12091fc9fb4914)},
  /* 136 */ {9, 0.1410942141636095, CNST_LIMB(0xdce31b2488000000), CNST_LIMB(0x28b1cb81b1ef1849)},
  /* 137 */ {9, 0.1408841194731412, CNST_LIMB(0xebf12a24bca135c9), CNST_LIMB(0x15c35be67ae3e2c9)},
  /* 138 */ {9, 0.1406761707131039, CNST_LIMB(0xfbe6f8dbf88f4a00), CNST_LIMB(0x42a17bd09be1ff0)},
  /* 139 */ {8, 0.1404703297561400, CNST_LIMB(0x1ef156c084ce761), CNST_LIMB(0x8bf461f03cf0bbf)},
  /* 140 */ {8, 0.1402665594314587, CNST_LIMB(0x20c4e3b94a10000), CNST_LIMB(0xf3fbb43f68a32d05)},
  /* 141 */ {8, 0.1400648234939879, CNST_LIMB(0x22b0695a08ba421), CNST_LIMB(0xd84f44c48564dc19)},
  /* 142 */ {8, 0.1398650865947379, CNST_LIMB(0x24b4f35d7a4c100), CNST_LIMB(0xbe58ebcce7956abe)},
  /* 143 */ {8, 0.1396673142523192, CNST_LIMB(0x26d397284975781), CNST_LIMB(0xa5fac463c7c134b7)},
  /* 144 */ {8, 0.1394714728255649, CNST_LIMB(0x290d74100000000), CNST_LIMB(0x8f19241e28c7d757)},
  /* 145 */ {8, 0.1392775294872041, CNST_LIMB(0x2b63b3a37866081), CNST_LIMB(0x799a6d046c0ae1ae)},
  /* 146 */ {8, 0.1390854521985406, CNST_LIMB(0x2dd789f4d894100), CNST_LIMB(0x6566e37d746a9e40)},
  /* 147 */ {8, 0.1388952096850913, CNST_LIMB(0x306a35e51b58721), CNST_LIMB(0x526887dbfb5f788f)},
  /* 148 */ {8, 0.1387067714131417, CNST_LIMB(0x331d01712e10000), CNST_LIMB(0x408af3382b8efd3d)},
  /* 149 */ {8, 0.1385201075671774, CNST_LIMB(0x35f14200a827c61), CNST_LIMB(0x2fbb374806ec05f1)},
  /* 150 */ {8, 0.1383351890281539, CNST_LIMB(0x38e858b62216100), CNST_LIMB(0x1fe7c0f0afce87fe)},
  /* 151 */ {8, 0.1381519873525671, CNST_LIMB(0x3c03b2c13176a41), CNST_LIMB(0x11003d517540d32e)},
  /* 152 */ {8, 0.1379704747522905, CNST_LIMB(0x3f44c9b21000000), CNST_LIMB(0x2f5810f98eff0dc)},
  /* 153 */ {8, 0.1377906240751463, CNST_LIMB(0x42ad23cef3113c1), CNST_LIMB(0xeb72e35e7840d910)},
  /* 154 */ {8, 0.1376124087861776, CNST_LIMB(0x463e546b19a2100), CNST_LIMB(0xd27de19593dc3614)},
  /* 155 */ {8, 0.1374358029495937, CNST_LIMB(0x49f9fc3f96684e1), CNST_LIMB(0xbaf391fd3e5e6fc2)},
  /* 156 */ {8, 0.1372607812113589, CNST_LIMB(0x4de1c9c5dc10000), CNST_LIMB(0xa4bd38c55228c81d)},
  /* 157 */ {8, 0.1370873187823978, CNST_LIMB(0x51f77994116d2a1), CNST_LIMB(0x8fc5a8de8e1de782)},
  /* 158 */ {8, 0.1369153914223921, CNST_LIMB(0x563cd6bb3398100), CNST_LIMB(0x7bf9265bea9d3a3b)},
  /* 159 */ {8, 0.1367449754241439, CNST_LIMB(0x5ab3bb270beeb01), CNST_LIMB(0x69454b325983dccd)},
  /* 160 */ {8, 0.1365760475984821, CNST_LIMB(0x5f5e10000000000), CNST_LIMB(0x5798ee2308c39df9)},
  /* 161 */ {8, 0.1364085852596902, CNST_LIMB(0x643dce0ec16f501), CNST_LIMB(0x46e40ba0fa66a753)},
  /* 162 */ {8, 0.1362425662114337, CNST_LIMB(0x6954fe21e3e8100), CNST_LIMB(0x3717b0870b0db3a7)},
  /* 163 */ {8, 0.1360779687331669, CNST_LIMB(0x6ea5b9755f440a1), CNST_LIMB(0x2825e6775d11cdeb)},
  /* 164 */ {8, 0.1359147715670014, CNST_LIMB(0x74322a1c0410000), CNST_LIMB(0x1a01a1c09d1b4dac)},
  /* 165 */ {8, 0.1357529539050150, CNST_LIMB(0x79fc8b6ae8a46e1), CNST_LIMB(0xc9eb0a8bebc8f3e)},
  /* 166 */ {8, 0.1355924953769864, CNST_LIMB(0x80072a66d512100), CNST_LIMB(0xffe357ff59e6a004)},
  /* 167 */ {8, 0.1354333760385373, CNST_LIMB(0x86546633b42b9c1), CNST_LIMB(0xe7dfd1be05fa61a8)},
  /* 168 */ {8, 0.1352755763596663, CNST_LIMB(0x8ce6b0861000000), CNST_LIMB(0xd11ed6fc78f760e5)},
  /* 169 */ {8, 0.1351190772136599, CNST_LIMB(0x93c08e16a022441), CNST_LIMB(0xbb8db609dd29ebfe)},
  /* 170 */ {8, 0.1349638598663645, CNST_LIMB(0x9ae49717f026100), CNST_LIMB(0xa71aec8d1813d532)},
  /* 171 */ {8, 0.1348099059658080, CNST_LIMB(0xa25577ae24c1a61), CNST_LIMB(0x93b612a9f20fbc02)},
  /* 172 */ {8, 0.1346571975321549, CNST_LIMB(0xaa15f068e610000), CNST_LIMB(0x814fc7b19a67d317)},
  /* 173 */ {8, 0.1345057169479844, CNST_LIMB(0xb228d6bf7577921), CNST_LIMB(0x6fd9a03f2e0a4b7c)},
  /* 174 */ {8, 0.1343554469488779, CNST_LIMB(0xba91158ef5c4100), CNST_LIMB(0x5f4615a38d0d316e)},
  /* 175 */ {8, 0.1342063706143054, CNST_LIMB(0xc351ad9aec0b681), CNST_LIMB(0x4f8876863479a286)},
  /* 176 */ {8, 0.1340584713587979, CNST_LIMB(0xcc6db6100000000), CNST_LIMB(0x4094d8a3041b60eb)},
  /* 177 */ {8, 0.1339117329233981, CNST_LIMB(0xd5e85d09025c181), CNST_LIMB(0x32600b8ed883a09b)},
  /* 178 */ {8, 0.1337661393673756, CNST_LIMB(0xdfc4e816401c100), CNST_LIMB(0x24df8c6eb4b6d1f1)},
  /* 179 */ {8, 0.1336216750601996, CNST_LIMB(0xea06b4c72947221), CNST_LIMB(0x18097a8ee151acef)},
  /* 180 */ {8, 0.1334783246737591, CNST_LIMB(0xf4b139365210000), CNST_LIMB(0xbd48cc8ec1cd8e3)},
  /* 181 */ {8, 0.1333360731748201, CNST_LIMB(0xffc80497d520961), CNST_LIMB(0x3807a8d67485fb)},
  /* 182 */ {8, 0.1331949058177136, CNST_LIMB(0x10b4ebfca1dee100), CNST_LIMB(0xea5768860b62e8d8)},
  /* 183 */ {8, 0.1330548081372441, CNST_LIMB(0x117492de921fc141), CNST_LIMB(0xd54faf5b635c5005)},
  /* 184 */ {8, 0.1329157659418126, CNST_LIMB(0x123bb2ce41000000), CNST_LIMB(0xc14a56233a377926)},
  /* 185 */ {8, 0.1327777653067443, CNST_LIMB(0x130a8b6157bdecc1), CNST_LIMB(0xae39a88db7cd329f)},
  /* 186 */ {8, 0.1326407925678156, CNST_LIMB(0x13e15dede0e8a100), CNST_LIMB(0x9c10bde69efa7ab6)},
  /* 187 */ {8, 0.1325048343149731, CNST_LIMB(0x14c06d941c0ca7e1), CNST_LIMB(0x8ac36c42a2836497)},
  /* 188 */ {8, 0.1323698773862368, CNST_LIMB(0x15a7ff487a810000), CNST_LIMB(0x7a463c8b84f5ef67)},
  /* 189 */ {8, 0.1322359088617821, CNST_LIMB(0x169859ddc5c697a1), CNST_LIMB(0x6a8e5f5ad090fd4b)},
  /* 190 */ {8, 0.1321029160581950, CNST_LIMB(0x1791c60f6fed0100), CNST_LIMB(0x5b91a2943596fc56)},
  /* 191 */ {8, 0.1319708865228925, CNST_LIMB(0x18948e8c0e6fba01), CNST_LIMB(0x4d4667b1c468e8f0)},
  /* 192 */ {8, 0.1318398080287045, CNST_LIMB(0x19a1000000000000), CNST_LIMB(0x3fa39ab547994daf)},
  /* 193 */ {8, 0.1317096685686114, CNST_LIMB(0x1ab769203dafc601), CNST_LIMB(0x32a0a9b2faee1e2a)},
  /* 194 */ {8, 0.1315804563506306, CNST_LIMB(0x1bd81ab557f30100), CNST_LIMB(0x26357ceac0e96962)},
  /* 195 */ {8, 0.1314521597928493, CNST_LIMB(0x1d0367a69fed1ba1), CNST_LIMB(0x1a5a6f65caa5859e)},
  /* 196 */ {8, 0.1313247675185968, CNST_LIMB(0x1e39a5057d810000), CNST_LIMB(0xf08480f672b4e86)},
  /* 197 */ {8, 0.1311982683517524, CNST_LIMB(0x1f7b2a18f29ac3e1), CNST_LIMB(0x4383340615612ca)},
  /* 198 */ {8, 0.1310726513121843, CNST_LIMB(0x20c850694c2aa100), CNST_LIMB(0xf3c77969ee4be5a2)},
  /* 199 */ {8, 0.1309479056113158, CNST_LIMB(0x222173cc014980c1), CNST_LIMB(0xe00993cc187c5ec9)},
  /* 200 */ {8, 0.1308240206478128, CNST_LIMB(0x2386f26fc1000000), CNST_LIMB(0xcd2b297d889bc2b6)},
  /* 201 */ {8, 0.1307009860033912, CNST_LIMB(0x24f92ce8af296d41), CNST_LIMB(0xbb214d5064862b22)},
  /* 202 */ {8, 0.1305787914387386, CNST_LIMB(0x2678863cd0ece100), CNST_LIMB(0xa9e1a7ca7ea10e20)},
  /* 203 */ {8, 0.1304574268895465, CNST_LIMB(0x280563f0a9472d61), CNST_LIMB(0x99626e72b39ea0cf)},
  /* 204 */ {8, 0.1303368824626505, CNST_LIMB(0x29a02e1406210000), CNST_LIMB(0x899a5ba9c13fafd9)},
  /* 205 */ {8, 0.1302171484322746, CNST_LIMB(0x2b494f4efe6d2e21), CNST_LIMB(0x7a80a705391e96ff)},
  /* 206 */ {8, 0.1300982152363760, CNST_LIMB(0x2d0134ef21cbc100), CNST_LIMB(0x6c0cfe23de23042a)},
  /* 207 */ {8, 0.1299800734730872, CNST_LIMB(0x2ec84ef4da2ef581), CNST_LIMB(0x5e377df359c944dd)},
  /* 208 */ {8, 0.1298627138972530, CNST_LIMB(0x309f102100000000), CNST_LIMB(0x50f8ac5fc8f53985)},
  /* 209 */ {8, 0.1297461274170591, CNST_LIMB(0x3285ee02a1420281), CNST_LIMB(0x44497266278e35b7)},
  /* 210 */ {8, 0.1296303050907487, CNST_LIMB(0x347d6104fc324100), CNST_LIMB(0x382316831f7ee175)},
  /* 211 */ {8, 0.1295152381234257, CNST_LIMB(0x3685e47dade53d21), CNST_LIMB(0x2c7f377833b8946e)},
  /* 212 */ {8, 0.1294009178639407, CNST_LIMB(0x389ff6bb15610000), CNST_LIMB(0x2157c761ab4163ef)},
  /* 213 */ {8, 0.1292873358018581, CNST_LIMB(0x3acc1912ebb57661), CNST_LIMB(0x16a7071803cc49a9)},
  /* 214 */ {8, 0.1291744835645007, CNST_LIMB(0x3d0acff111946100), CNST_LIMB(0xc6781d80f8224fc)},
  /* 215 */ {8, 0.1290623529140715, CNST_LIMB(0x3f5ca2e692eaf841), CNST_LIMB(0x294092d370a900b)},
  /* 216 */ {8, 0.1289509357448472, CNST_LIMB(0x41c21cb8e1000000), CNST_LIMB(0xf24f62335024a295)},
  /* 217 */ {8, 0.1288402240804449, CNST_LIMB(0x443bcb714399a5c1), CNST_LIMB(0xe03b98f103fad6d2)},
  /* 218 */ {8, 0.1287302100711566, CNST_LIMB(0x46ca406c81af2100), CNST_LIMB(0xcee3d32cad2a9049)},
  /* 219 */ {8, 0.1286208859913518, CNST_LIMB(0x496e106ac22aaae1), CNST_LIMB(0xbe3f9df9277fdada)},
  /* 220 */ {8, 0.1285122442369443, CNST_LIMB(0x4c27d39fa5410000), CNST_LIMB(0xae46f0d94c05e933)},
  /* 221 */ {8, 0.1284042773229231, CNST_LIMB(0x4ef825c296e43ca1), CNST_LIMB(0x9ef2280fb437a33d)},
  /* 222 */ {8, 0.1282969778809442, CNST_LIMB(0x51dfa61f5ad88100), CNST_LIMB(0x9039ff426d3f284b)},
  /* 223 */ {8, 0.1281903386569819, CNST_LIMB(0x54def7a6d2f16901), CNST_LIMB(0x82178c6d6b51f8f4)},
  /* 224 */ {8, 0.1280843525090381, CNST_LIMB(0x57f6c10000000000), CNST_LIMB(0x74843b1ee4c1e053)},
  /* 225 */ {8, 0.1279790124049077, CNST_LIMB(0x5b27ac993df97701), CNST_LIMB(0x6779c7f90dc42f48)},
  /* 226 */ {8, 0.1278743114199984, CNST_LIMB(0x5e7268b9bbdf8100), CNST_LIMB(0x5af23c74f9ad9fe9)},
  /* 227 */ {8, 0.1277702427352035, CNST_LIMB(0x61d7a7932ff3d6a1), CNST_LIMB(0x4ee7eae2acdc617e)},
  /* 228 */ {8, 0.1276667996348261, CNST_LIMB(0x65581f53c8c10000), CNST_LIMB(0x43556aa2ac262a0b)},
  /* 229 */ {8, 0.1275639755045533, CNST_LIMB(0x68f48a385b8320e1), CNST_LIMB(0x3835949593b8ddd1)},
  /* 230 */ {8, 0.1274617638294791, CNST_LIMB(0x6cada69ed07c2100), CNST_LIMB(0x2d837fbe78458762)},
  /* 231 */ {8, 0.1273601581921740, CNST_LIMB(0x70843718cdbf27c1), CNST_LIMB(0x233a7e150a54a555)},
  /* 232 */ {8, 0.1272591522708010, CNST_LIMB(0x7479027ea1000000), CNST_LIMB(0x19561984a50ff8fe)},
  /* 233 */ {8, 0.1271587398372755, CNST_LIMB(0x788cd40268f39641), CNST_LIMB(0xfd211159fe3490f)},
  /* 234 */ {8, 0.1270589147554692, CNST_LIMB(0x7cc07b437ecf6100), CNST_LIMB(0x6aa563e655033e3)},
  /* 235 */ {8, 0.1269596709794558, CNST_LIMB(0x8114cc6220762061), CNST_LIMB(0xfbb614b3f2d3b14c)},
  /* 236 */ {8, 0.1268610025517973, CNST_LIMB(0x858aa0135be10000), CNST_LIMB(0xeac0f8837fb05773)},
  /* 237 */ {8, 0.1267629036018709, CNST_LIMB(0x8a22d3b53c54c321), CNST_LIMB(0xda6e4c10e8615ca5)},
  /* 238 */ {8, 0.1266653683442337, CNST_LIMB(0x8ede496339f34100), CNST_LIMB(0xcab755a8d01fa67f)},
  /* 239 */ {8, 0.1265683910770258, CNST_LIMB(0x93bde80aec3a1481), CNST_LIMB(0xbb95a9ae71aa3e0c)},
  /* 240 */ {8, 0.1264719661804097, CNST_LIMB(0x98c29b8100000000), CNST_LIMB(0xad0326c296b4f529)},
  /* 241 */ {8, 0.1263760881150453, CNST_LIMB(0x9ded549671832381), CNST_LIMB(0x9ef9f21eed31b7c1)},
  /* 242 */ {8, 0.1262807514205999, CNST_LIMB(0xa33f092e0b1ac100), CNST_LIMB(0x91747422be14b0b2)},
  /* 243 */ {8, 0.1261859507142915, CNST_LIMB(0xa8b8b452291fe821), CNST_LIMB(0x846d550e37b5063d)},
  /* 244 */ {8, 0.1260916806894653, CNST_LIMB(0xae5b564ac3a10000), CNST_LIMB(0x77df79e9a96c06f6)},
  /* 245 */ {8, 0.1259979361142023, CNST_LIMB(0xb427f4b3be74c361), CNST_LIMB(0x6bc6019636c7d0c2)},
  /* 246 */ {8, 0.1259047118299582, CNST_LIMB(0xba1f9a938041e100), CNST_LIMB(0x601c4205aebd9e47)},
  /* 247 */ {8, 0.1258120027502338, CNST_LIMB(0xc0435871d1110f41), CNST_LIMB(0x54ddc59756f05016)},
  /* 248 */ {8, 0.1257198038592741, CNST_LIMB(0xc694446f01000000), CNST_LIMB(0x4a0648979c838c18)},
  /* 249 */ {8, 0.1256281102107963, CNST_LIMB(0xcd137a5b57ac3ec1), CNST_LIMB(0x3f91b6e0bb3a053d)},
  /* 250 */ {8, 0.1255369169267456, CNST_LIMB(0xd3c21bcecceda100), CNST_LIMB(0x357c299a88ea76a5)},
  /* 251 */ {8, 0.1254462191960791, CNST_LIMB(0xdaa150410b788de1), CNST_LIMB(0x2bc1e517aecc56e3)},
  /* 252 */ {8, 0.1253560122735751, CNST_LIMB(0xe1b24521be010000), CNST_LIMB(0x225f56ceb3da9f5d)},
  /* 253 */ {8, 0.1252662914786691, CNST_LIMB(0xe8f62df12777c1a1), CNST_LIMB(0x1951136d53ad63ac)},
  /* 254 */ {8, 0.1251770521943144, CNST_LIMB(0xf06e445906fc0100), CNST_LIMB(0x1093d504b3cd7d93)},
  /* 255 */ {8, 0.1250882898658681, CNST_LIMB(0xf81bc845c81bf801), CNST_LIMB(0x824794d1ec1814f)},
};
#endif /* 64 */


#if GENERATE_TABLE

unsigned int
ulog2 (x)
     unsigned int x;
{
  unsigned int i;
  for (i = 0;  x != 0;  i++)
    x >>= 1;
  return i;
}

main (int argc, char **argv)
{
  int i;
  unsigned int idig;
  mpz_t big_base, big_base_inverted, t;
  double fdig;
  int dummy;
  int normalization_steps;
  int bits_per_mp_limb;
  char *cnst_limb_str1, *cnst_limb_str2;

  mpz_init (big_base);
  mpz_init (big_base_inverted);
  mpz_init (t);

  bits_per_mp_limb = 8 * sizeof (long);
  if (argc == 2)
    bits_per_mp_limb = atoi (argv[1]);

  if (bits_per_mp_limb >= 64)
    {
      cnst_limb_str1 = "CNST_LIMB(";
      cnst_limb_str2 = ")";
    }
  else
    {
      cnst_limb_str1 = "";
      cnst_limb_str2 = "";
    }

  printf ("#if BITS_PER_MP_LIMB == %d\n", bits_per_mp_limb);
  puts ("const struct bases __mp_bases[256] =\n{");
  puts ("  /*  0 */ {0, 0.0, 0, 0},");
  puts ("  /*  1 */ {0, 1e37, 0, 0},");
  for (i = 2; i < 256; i++)
    {
      fdig = 0.69314718055994530942 / log ((double) i);
      idig = floor (bits_per_mp_limb * fdig);
      if ((i & (i - 1)) == 0)
	{
	  printf ("  /* %2u */ {%u, %.16f, 0x%lx, 0x0},\n",
		  i, idig, fdig, ulog2 (i) - 1);
	}
      else
	{
	  mpz_ui_pow_ui (big_base,
			 (unsigned long int) i, (unsigned long int) idig);
	  normalization_steps = bits_per_mp_limb - mpz_sizeinbase (big_base, 2);
	  mpz_set_ui (t, 1L);
	  mpz_mul_2exp (t, t, 2 * bits_per_mp_limb - normalization_steps);
	  mpz_tdiv_q (big_base_inverted, t, big_base);
	  mpz_set_ui (t, 1L);
	  mpz_mul_2exp (t, t, bits_per_mp_limb);
	  mpz_sub (big_base_inverted, big_base_inverted, t);
	  printf ("  /* %2u */ {%u, %.16f, %s0x", i, idig, fdig, cnst_limb_str1);
	  mpz_out_str (0, 16, big_base); printf ("%s, %s0x", cnst_limb_str2, cnst_limb_str1);
	  mpz_out_str (0, 16, big_base_inverted); printf ("%s},\n", cnst_limb_str2);
	}
    }

  puts ("};");
  printf ("#endif /* %d */\n", bits_per_mp_limb);

  exit (0);
}
#endif
