=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class PkiWriteRoleRequest
    # If set, clients can request certificates for any domain, regardless of allowed_domains restrictions. See the documentation for more information.
    attr_accessor :allow_any_name

    # If set, clients can request certificates for the base domains themselves, e.g. \"example.com\" of domains listed in allowed_domains. This is a separate option as in some cases this can be considered a security threat. See the documentation for more information.
    attr_accessor :allow_bare_domains

    # If set, domains specified in allowed_domains can include shell-style glob patterns, e.g. \"ftp*.example.com\". See the documentation for more information.
    attr_accessor :allow_glob_domains

    # If set, IP Subject Alternative Names are allowed. Any valid IP is accepted and No authorization checking is performed.
    attr_accessor :allow_ip_sans

    # Whether to allow \"localhost\" and \"localdomain\" as a valid common name in a request, independent of allowed_domains value.
    attr_accessor :allow_localhost

    # If set, clients can request certificates for subdomains of domains listed in allowed_domains, including wildcard subdomains. See the documentation for more information.
    attr_accessor :allow_subdomains

    # If set, allows certificates with wildcards in the common name to be issued, conforming to RFC 6125's Section 6.4.3; e.g., \"*.example.net\" or \"b*z.example.net\". See the documentation for more information.
    attr_accessor :allow_wildcard_certificates

    # Specifies the domains this role is allowed to issue certificates for. This is used with the allow_bare_domains, allow_subdomains, and allow_glob_domains to determine matches for the common name, DNS-typed SAN entries, and Email-typed SAN entries of certificates. See the documentation for more information. This parameter accepts a comma-separated string or list of domains.
    attr_accessor :allowed_domains

    # If set, Allowed domains can be specified using identity template policies. Non-templated domains are also permitted.
    attr_accessor :allowed_domains_template

    # If set, an array of allowed other names to put in SANs. These values support globbing and must be in the format <oid>;<type>:<value>. Currently only \"utf8\" is a valid type. All values, including globbing values, must use this syntax, with the exception being a single \"*\" which allows any OID and any value (but type must still be utf8).
    attr_accessor :allowed_other_sans

    # If set, an array of allowed serial numbers to put in Subject. These values support globbing.
    attr_accessor :allowed_serial_numbers

    # If set, an array of allowed URIs for URI Subject Alternative Names. Any valid URI is accepted, these values support globbing.
    attr_accessor :allowed_uri_sans

    # If set, Allowed URI SANs can be specified using identity template policies. Non-templated URI SANs are also permitted.
    attr_accessor :allowed_uri_sans_template

    # If set, an array of allowed user-ids to put in user system login name specified here: https://www.rfc-editor.org/rfc/rfc1274#section-9.3.1
    attr_accessor :allowed_user_ids

    # Backend Type
    attr_accessor :backend

    # Mark Basic Constraints valid when issuing non-CA certificates.
    attr_accessor :basic_constraints_valid_for_non_ca

    # If set, certificates are flagged for client auth use. Defaults to true. See also RFC 5280 Section 4.2.1.12.
    attr_accessor :client_flag

    # List of allowed validations to run against the Common Name field. Values can include 'email' to validate the CN is a email address, 'hostname' to validate the CN is a valid hostname (potentially including wildcards). When multiple validations are specified, these take OR semantics (either email OR hostname are allowed). The special value 'disabled' allows disabling all CN name validations, allowing for arbitrary non-Hostname, non-Email address CNs.
    attr_accessor :cn_validations

    # If set, certificates are flagged for code signing use. Defaults to false. See also RFC 5280 Section 4.2.1.12.
    attr_accessor :code_signing_flag

    # If set, Country will be set to this value in certificates issued by this role.
    attr_accessor :country

    # If set, certificates are flagged for email protection use. Defaults to false. See also RFC 5280 Section 4.2.1.12.
    attr_accessor :email_protection_flag

    # If set, only valid host names are allowed for CN and DNS SANs, and the host part of email addresses. Defaults to true.
    attr_accessor :enforce_hostnames

    # A comma-separated string or list of extended key usages. Valid values can be found at https://golang.org/pkg/crypto/x509/#ExtKeyUsage -- simply drop the \"ExtKeyUsage\" part of the name. To remove all key usages from being set, set this value to an empty list. See also RFC 5280 Section 4.2.1.12.
    attr_accessor :ext_key_usage

    # A comma-separated string or list of extended key usage oids.
    attr_accessor :ext_key_usage_oids

    # If set, certificates issued/signed against this role will have OpenBao leases attached to them. Defaults to \"false\". Certificates can be added to the CRL by \"bao revoke <lease_id>\" when certificates are associated with leases. It can also be done using the \"pki/revoke\" endpoint. However, when lease generation is disabled, invoking \"pki/revoke\" would be the only way to add the certificates to the CRL. When large number of certificates are generated with long lifetimes, it is recommended that lease generation be disabled, as large amount of leases adversely affect the startup time of OpenBao.
    attr_accessor :generate_lease

    # Reference to the issuer used to sign requests serviced by this role.
    attr_accessor :issuer_ref

    # The number of bits to use. Allowed values are 0 (universal default); with rsa key_type: 2048 (default), 3072, or 4096; with ec key_type: 224, 256 (default), 384, or 521; ignored with ed25519.
    attr_accessor :key_bits

    # The type of key to use; defaults to RSA. \"rsa\" \"ec\", \"ed25519\" and \"any\" are the only valid values.
    attr_accessor :key_type

    # A comma-separated string or list of key usages (not extended key usages). Valid values can be found at https://golang.org/pkg/crypto/x509/#KeyUsage -- simply drop the \"KeyUsage\" part of the name. To remove all key usages from being set, set this value to an empty list. See also RFC 5280 Section 4.2.1.3.
    attr_accessor :key_usage

    # If set, Locality will be set to this value in certificates issued by this role.
    attr_accessor :locality

    # The maximum allowed lease duration. If not set, defaults to the system maximum lease TTL.
    attr_accessor :max_ttl

    # If set, certificates issued/signed against this role will not be stored in the storage backend. This can improve performance when issuing large numbers of certificates. However, certificates issued in this way cannot be enumerated or revoked, so this option is recommended only for certificates that are non-sensitive, or extremely short-lived. This option implies a value of \"false\" for \"generate_lease\".
    attr_accessor :no_store

    # Set the not after field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ.
    attr_accessor :not_after

    # The duration before now which the certificate needs to be backdated by.
    attr_accessor :not_before_duration

    # If set, O (Organization) will be set to this value in certificates issued by this role.
    attr_accessor :organization

    # If set, OU (OrganizationalUnit) will be set to this value in certificates issued by this role.
    attr_accessor :ou

    # A comma-separated string or list of policy OIDs, or a JSON list of qualified policy information, which must include an oid, and may include a notice and/or cps url, using the form [{\"oid\"=\"1.3.6.1.4.1.7.8\",\"notice\"=\"I am a user Notice\"}, {\"oid\"=\"1.3.6.1.4.1.44947.1.2.4 \",\"cps\"=\"https://example.com\"}].
    attr_accessor :policy_identifiers

    # If set, Postal Code will be set to this value in certificates issued by this role.
    attr_accessor :postal_code

    # If set, Province will be set to this value in certificates issued by this role.
    attr_accessor :province

    # If set to false, makes the 'common_name' field optional while generating a certificate.
    attr_accessor :require_cn

    # If set, certificates are flagged for server auth use. Defaults to true. See also RFC 5280 Section 4.2.1.12.
    attr_accessor :server_flag

    # The number of bits to use in the signature algorithm; accepts 256 for SHA-2-256, 384 for SHA-2-384, and 512 for SHA-2-512. Defaults to 0 to automatically detect based on key length (SHA-2-256 for RSA keys, and matching the curve size for NIST P-Curves).
    attr_accessor :signature_bits

    # If set, Street Address will be set to this value in certificates issued by this role.
    attr_accessor :street_address

    # The lease duration (validity period of the certificate) if no specific lease duration is requested. The lease duration controls the expiration of certificates issued by this backend. Defaults to the system default value or the value of max_ttl, whichever is shorter.
    attr_accessor :ttl

    # If set, when used with a signing profile, the common name in the CSR will be used. This does *not* include any requested Subject Alternative Names; use use_csr_sans for that. Defaults to true.
    attr_accessor :use_csr_common_name

    # If set, when used with a signing profile, the SANs in the CSR will be used. This does *not* include the Common Name (cn); use use_csr_common_name for that. Defaults to true.
    attr_accessor :use_csr_sans

    # Whether or not to use PSS signatures when using a RSA key-type issuer. Defaults to false.
    attr_accessor :use_pss

    class EnumAttributeValidator
      attr_reader :datatype
      attr_reader :allowable_values

      def initialize(datatype, allowable_values)
        @allowable_values = allowable_values.map do |value|
          case datatype.to_s
          when /Integer/i
            value.to_i
          when /Float/i
            value.to_f
          else
            value
          end
        end
      end

      def valid?(value)
        !value || allowable_values.include?(value)
      end
    end

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'allow_any_name' => :'allow_any_name',
        :'allow_bare_domains' => :'allow_bare_domains',
        :'allow_glob_domains' => :'allow_glob_domains',
        :'allow_ip_sans' => :'allow_ip_sans',
        :'allow_localhost' => :'allow_localhost',
        :'allow_subdomains' => :'allow_subdomains',
        :'allow_wildcard_certificates' => :'allow_wildcard_certificates',
        :'allowed_domains' => :'allowed_domains',
        :'allowed_domains_template' => :'allowed_domains_template',
        :'allowed_other_sans' => :'allowed_other_sans',
        :'allowed_serial_numbers' => :'allowed_serial_numbers',
        :'allowed_uri_sans' => :'allowed_uri_sans',
        :'allowed_uri_sans_template' => :'allowed_uri_sans_template',
        :'allowed_user_ids' => :'allowed_user_ids',
        :'backend' => :'backend',
        :'basic_constraints_valid_for_non_ca' => :'basic_constraints_valid_for_non_ca',
        :'client_flag' => :'client_flag',
        :'cn_validations' => :'cn_validations',
        :'code_signing_flag' => :'code_signing_flag',
        :'country' => :'country',
        :'email_protection_flag' => :'email_protection_flag',
        :'enforce_hostnames' => :'enforce_hostnames',
        :'ext_key_usage' => :'ext_key_usage',
        :'ext_key_usage_oids' => :'ext_key_usage_oids',
        :'generate_lease' => :'generate_lease',
        :'issuer_ref' => :'issuer_ref',
        :'key_bits' => :'key_bits',
        :'key_type' => :'key_type',
        :'key_usage' => :'key_usage',
        :'locality' => :'locality',
        :'max_ttl' => :'max_ttl',
        :'no_store' => :'no_store',
        :'not_after' => :'not_after',
        :'not_before_duration' => :'not_before_duration',
        :'organization' => :'organization',
        :'ou' => :'ou',
        :'policy_identifiers' => :'policy_identifiers',
        :'postal_code' => :'postal_code',
        :'province' => :'province',
        :'require_cn' => :'require_cn',
        :'server_flag' => :'server_flag',
        :'signature_bits' => :'signature_bits',
        :'street_address' => :'street_address',
        :'ttl' => :'ttl',
        :'use_csr_common_name' => :'use_csr_common_name',
        :'use_csr_sans' => :'use_csr_sans',
        :'use_pss' => :'use_pss'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'allow_any_name' => :'Boolean',
        :'allow_bare_domains' => :'Boolean',
        :'allow_glob_domains' => :'Boolean',
        :'allow_ip_sans' => :'Boolean',
        :'allow_localhost' => :'Boolean',
        :'allow_subdomains' => :'Boolean',
        :'allow_wildcard_certificates' => :'Boolean',
        :'allowed_domains' => :'Array<String>',
        :'allowed_domains_template' => :'Boolean',
        :'allowed_other_sans' => :'Array<String>',
        :'allowed_serial_numbers' => :'Array<String>',
        :'allowed_uri_sans' => :'Array<String>',
        :'allowed_uri_sans_template' => :'Boolean',
        :'allowed_user_ids' => :'Array<String>',
        :'backend' => :'String',
        :'basic_constraints_valid_for_non_ca' => :'Boolean',
        :'client_flag' => :'Boolean',
        :'cn_validations' => :'Array<String>',
        :'code_signing_flag' => :'Boolean',
        :'country' => :'Array<String>',
        :'email_protection_flag' => :'Boolean',
        :'enforce_hostnames' => :'Boolean',
        :'ext_key_usage' => :'Array<String>',
        :'ext_key_usage_oids' => :'Array<String>',
        :'generate_lease' => :'Boolean',
        :'issuer_ref' => :'String',
        :'key_bits' => :'Integer',
        :'key_type' => :'String',
        :'key_usage' => :'Array<String>',
        :'locality' => :'Array<String>',
        :'max_ttl' => :'Integer',
        :'no_store' => :'Boolean',
        :'not_after' => :'String',
        :'not_before_duration' => :'Integer',
        :'organization' => :'Array<String>',
        :'ou' => :'Array<String>',
        :'policy_identifiers' => :'Array<String>',
        :'postal_code' => :'Array<String>',
        :'province' => :'Array<String>',
        :'require_cn' => :'Boolean',
        :'server_flag' => :'Boolean',
        :'signature_bits' => :'Integer',
        :'street_address' => :'Array<String>',
        :'ttl' => :'Integer',
        :'use_csr_common_name' => :'Boolean',
        :'use_csr_sans' => :'Boolean',
        :'use_pss' => :'Boolean'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::PkiWriteRoleRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::PkiWriteRoleRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'allow_any_name')
        self.allow_any_name = attributes[:'allow_any_name']
      end

      if attributes.key?(:'allow_bare_domains')
        self.allow_bare_domains = attributes[:'allow_bare_domains']
      end

      if attributes.key?(:'allow_glob_domains')
        self.allow_glob_domains = attributes[:'allow_glob_domains']
      end

      if attributes.key?(:'allow_ip_sans')
        self.allow_ip_sans = attributes[:'allow_ip_sans']
      else
        self.allow_ip_sans = true
      end

      if attributes.key?(:'allow_localhost')
        self.allow_localhost = attributes[:'allow_localhost']
      else
        self.allow_localhost = true
      end

      if attributes.key?(:'allow_subdomains')
        self.allow_subdomains = attributes[:'allow_subdomains']
      end

      if attributes.key?(:'allow_wildcard_certificates')
        self.allow_wildcard_certificates = attributes[:'allow_wildcard_certificates']
      else
        self.allow_wildcard_certificates = true
      end

      if attributes.key?(:'allowed_domains')
        if (value = attributes[:'allowed_domains']).is_a?(Array)
          self.allowed_domains = value
        end
      end

      if attributes.key?(:'allowed_domains_template')
        self.allowed_domains_template = attributes[:'allowed_domains_template']
      else
        self.allowed_domains_template = false
      end

      if attributes.key?(:'allowed_other_sans')
        if (value = attributes[:'allowed_other_sans']).is_a?(Array)
          self.allowed_other_sans = value
        end
      end

      if attributes.key?(:'allowed_serial_numbers')
        if (value = attributes[:'allowed_serial_numbers']).is_a?(Array)
          self.allowed_serial_numbers = value
        end
      end

      if attributes.key?(:'allowed_uri_sans')
        if (value = attributes[:'allowed_uri_sans']).is_a?(Array)
          self.allowed_uri_sans = value
        end
      end

      if attributes.key?(:'allowed_uri_sans_template')
        self.allowed_uri_sans_template = attributes[:'allowed_uri_sans_template']
      else
        self.allowed_uri_sans_template = false
      end

      if attributes.key?(:'allowed_user_ids')
        if (value = attributes[:'allowed_user_ids']).is_a?(Array)
          self.allowed_user_ids = value
        end
      end

      if attributes.key?(:'backend')
        self.backend = attributes[:'backend']
      end

      if attributes.key?(:'basic_constraints_valid_for_non_ca')
        self.basic_constraints_valid_for_non_ca = attributes[:'basic_constraints_valid_for_non_ca']
      end

      if attributes.key?(:'client_flag')
        self.client_flag = attributes[:'client_flag']
      else
        self.client_flag = true
      end

      if attributes.key?(:'cn_validations')
        if (value = attributes[:'cn_validations']).is_a?(Array)
          self.cn_validations = value
        end
      end

      if attributes.key?(:'code_signing_flag')
        self.code_signing_flag = attributes[:'code_signing_flag']
      end

      if attributes.key?(:'country')
        if (value = attributes[:'country']).is_a?(Array)
          self.country = value
        end
      end

      if attributes.key?(:'email_protection_flag')
        self.email_protection_flag = attributes[:'email_protection_flag']
      end

      if attributes.key?(:'enforce_hostnames')
        self.enforce_hostnames = attributes[:'enforce_hostnames']
      else
        self.enforce_hostnames = true
      end

      if attributes.key?(:'ext_key_usage')
        if (value = attributes[:'ext_key_usage']).is_a?(Array)
          self.ext_key_usage = value
        end
      end

      if attributes.key?(:'ext_key_usage_oids')
        if (value = attributes[:'ext_key_usage_oids']).is_a?(Array)
          self.ext_key_usage_oids = value
        end
      end

      if attributes.key?(:'generate_lease')
        self.generate_lease = attributes[:'generate_lease']
      end

      if attributes.key?(:'issuer_ref')
        self.issuer_ref = attributes[:'issuer_ref']
      else
        self.issuer_ref = 'default'
      end

      if attributes.key?(:'key_bits')
        self.key_bits = attributes[:'key_bits']
      else
        self.key_bits = 0
      end

      if attributes.key?(:'key_type')
        self.key_type = attributes[:'key_type']
      else
        self.key_type = 'rsa'
      end

      if attributes.key?(:'key_usage')
        if (value = attributes[:'key_usage']).is_a?(Array)
          self.key_usage = value
        end
      end

      if attributes.key?(:'locality')
        if (value = attributes[:'locality']).is_a?(Array)
          self.locality = value
        end
      end

      if attributes.key?(:'max_ttl')
        self.max_ttl = attributes[:'max_ttl']
      end

      if attributes.key?(:'no_store')
        self.no_store = attributes[:'no_store']
      end

      if attributes.key?(:'not_after')
        self.not_after = attributes[:'not_after']
      end

      if attributes.key?(:'not_before_duration')
        self.not_before_duration = attributes[:'not_before_duration']
      else
        self.not_before_duration = 30
      end

      if attributes.key?(:'organization')
        if (value = attributes[:'organization']).is_a?(Array)
          self.organization = value
        end
      end

      if attributes.key?(:'ou')
        if (value = attributes[:'ou']).is_a?(Array)
          self.ou = value
        end
      end

      if attributes.key?(:'policy_identifiers')
        if (value = attributes[:'policy_identifiers']).is_a?(Array)
          self.policy_identifiers = value
        end
      end

      if attributes.key?(:'postal_code')
        if (value = attributes[:'postal_code']).is_a?(Array)
          self.postal_code = value
        end
      end

      if attributes.key?(:'province')
        if (value = attributes[:'province']).is_a?(Array)
          self.province = value
        end
      end

      if attributes.key?(:'require_cn')
        self.require_cn = attributes[:'require_cn']
      else
        self.require_cn = true
      end

      if attributes.key?(:'server_flag')
        self.server_flag = attributes[:'server_flag']
      else
        self.server_flag = true
      end

      if attributes.key?(:'signature_bits')
        self.signature_bits = attributes[:'signature_bits']
      else
        self.signature_bits = 0
      end

      if attributes.key?(:'street_address')
        if (value = attributes[:'street_address']).is_a?(Array)
          self.street_address = value
        end
      end

      if attributes.key?(:'ttl')
        self.ttl = attributes[:'ttl']
      end

      if attributes.key?(:'use_csr_common_name')
        self.use_csr_common_name = attributes[:'use_csr_common_name']
      else
        self.use_csr_common_name = true
      end

      if attributes.key?(:'use_csr_sans')
        self.use_csr_sans = attributes[:'use_csr_sans']
      else
        self.use_csr_sans = true
      end

      if attributes.key?(:'use_pss')
        self.use_pss = attributes[:'use_pss']
      else
        self.use_pss = false
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      key_type_validator = EnumAttributeValidator.new('String', ["rsa", "ec", "ed25519", "any"])
      return false unless key_type_validator.valid?(@key_type)
      true
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] key_type Object to be assigned
    def key_type=(key_type)
      validator = EnumAttributeValidator.new('String', ["rsa", "ec", "ed25519", "any"])
      unless validator.valid?(key_type)
        fail ArgumentError, "invalid value for \"key_type\", must be one of #{validator.allowable_values}."
      end
      @key_type = key_type
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          allow_any_name == o.allow_any_name &&
          allow_bare_domains == o.allow_bare_domains &&
          allow_glob_domains == o.allow_glob_domains &&
          allow_ip_sans == o.allow_ip_sans &&
          allow_localhost == o.allow_localhost &&
          allow_subdomains == o.allow_subdomains &&
          allow_wildcard_certificates == o.allow_wildcard_certificates &&
          allowed_domains == o.allowed_domains &&
          allowed_domains_template == o.allowed_domains_template &&
          allowed_other_sans == o.allowed_other_sans &&
          allowed_serial_numbers == o.allowed_serial_numbers &&
          allowed_uri_sans == o.allowed_uri_sans &&
          allowed_uri_sans_template == o.allowed_uri_sans_template &&
          allowed_user_ids == o.allowed_user_ids &&
          backend == o.backend &&
          basic_constraints_valid_for_non_ca == o.basic_constraints_valid_for_non_ca &&
          client_flag == o.client_flag &&
          cn_validations == o.cn_validations &&
          code_signing_flag == o.code_signing_flag &&
          country == o.country &&
          email_protection_flag == o.email_protection_flag &&
          enforce_hostnames == o.enforce_hostnames &&
          ext_key_usage == o.ext_key_usage &&
          ext_key_usage_oids == o.ext_key_usage_oids &&
          generate_lease == o.generate_lease &&
          issuer_ref == o.issuer_ref &&
          key_bits == o.key_bits &&
          key_type == o.key_type &&
          key_usage == o.key_usage &&
          locality == o.locality &&
          max_ttl == o.max_ttl &&
          no_store == o.no_store &&
          not_after == o.not_after &&
          not_before_duration == o.not_before_duration &&
          organization == o.organization &&
          ou == o.ou &&
          policy_identifiers == o.policy_identifiers &&
          postal_code == o.postal_code &&
          province == o.province &&
          require_cn == o.require_cn &&
          server_flag == o.server_flag &&
          signature_bits == o.signature_bits &&
          street_address == o.street_address &&
          ttl == o.ttl &&
          use_csr_common_name == o.use_csr_common_name &&
          use_csr_sans == o.use_csr_sans &&
          use_pss == o.use_pss
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [allow_any_name, allow_bare_domains, allow_glob_domains, allow_ip_sans, allow_localhost, allow_subdomains, allow_wildcard_certificates, allowed_domains, allowed_domains_template, allowed_other_sans, allowed_serial_numbers, allowed_uri_sans, allowed_uri_sans_template, allowed_user_ids, backend, basic_constraints_valid_for_non_ca, client_flag, cn_validations, code_signing_flag, country, email_protection_flag, enforce_hostnames, ext_key_usage, ext_key_usage_oids, generate_lease, issuer_ref, key_bits, key_type, key_usage, locality, max_ttl, no_store, not_after, not_before_duration, organization, ou, policy_identifiers, postal_code, province, require_cn, server_flag, signature_bits, street_address, ttl, use_csr_common_name, use_csr_sans, use_pss].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
