/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.xdbm.search.evaluator;


import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.UndefinedNode;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;


/**
 * An Evaluator that always return false, for the case we have no entry to return
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class EmptyEvaluator implements Evaluator<UndefinedNode>
{
    /**
     * Create a new instance of the PassThroughEvaluator
     * @throws Exception
     */
    public EmptyEvaluator()
    {
    }


    /**
     * {@inheritDoc}
     */
    public boolean evaluate( IndexEntry<?, String> indexEntry ) throws LdapException
    {
        return false;
    }


    /**
     * {@inheritDoc}
     */
    public boolean evaluate( Entry entry ) throws Exception
    {
        return false;
    }


    /**
     * Gets the expression used by this expression Evaluator.
     *
     * @return the AST for the expression
     */
    public UndefinedNode getExpression()
    {
        return UndefinedNode.UNDEFINED_NODE;
    }


    /**
     * @see Object#toString()
     */
    public String toString( String tabs )
    {
        StringBuilder sb = new StringBuilder();

        sb.append( tabs ).append( "EmptyEvaluator\n" );

        return sb.toString();
    }


    /**
     * @see Object#toString()
     */
    public String toString()
    {
        return toString( "" );
    }
}