/*
 * $Id$
 *
 * Copyright (c) 1997 Andrew G. Morgan <morgan@parc.power.net>
 *
 * This file contains the functions that directly interface with the
 * kernel.  Currently, they are simulated in user-space.
 */

#include <sys/audit.h>
#include "audit.h"

/* p161 - manipulate the system's audit state for the current process
   - returns the previous audit state (or -1 on error) */

aud_state_t aud_switch(aud_state_t aud_state)
{
    errno = ENOSYS;
    return (aud_state_t) -1;
}

/* p163 - write an audit record to the end of indicated file - returns
   0(success) or -1(failure) */

int aud_write(int audit_fd, aud_rec_t ar)
{
    errno = ENOSYS;
    return -1;
}

/* p157 - read an audit record from file - returns audit record (or NULL) */

aud_rec_t aud_read(int audit_fd)
{
    errno = ENOSYS;
    return (aud_rec_t) NULL;
}

/* p135 - get the audit id of the indicated process/ who is
   responsible for this process? */

aud_id_t aud_get_id(pid_t process)
{
    errno = ENOSYS;
    return (aud_id_t) -1;
}

/* The following is not a POSIX defined function. However, there must be
   some method for an application like 'login' to set the audit id of a
   process.  Use of this system call should definitely be audited. */

aud_id_t aud_set_id(pid_t process)
{
    errno = ENOSYS;
    return (aud_id_t) -1;
}

/*
 * $Log$
 */
