/*
 * $Id$
 *
 * Copyright (c) 1997 Andrew G. Morgan <morgan@parc.power.net>
 *
 * This file contains the functions that manipulate subjects in an
 * audit structure.
 */

#include "audit.h"

/* p122 - delete a set of subject attributes - returns 0(success)
   -1(failure) */

int aud_delete_subj(aud_subj_t aud_subj_d)
{
    return __aud_delete_section(__AUD_MAGIC_SUBJ, aud_subj_d);
}

/* p123 - delete data item from a set subject attributes - returns 0(success)
   -1(failure) */

int aud_delete_subj_info(aud_subj_t aud_subj_d, int item_id)
{
    return __aud_delete_section_info(__AUD_MAGIC_SUBJ, aud_subj_d, item_id);
}

/* p139 - obtain a subject entry from this audit record - returns
   non-negative number of such objects in this record. */

int aud_get_subj(aud_rec_t ar, int index, aud_subj_t *aud_subj_p)
{
    return __aud_get_section(__AUD_MAGIC_SUBJ, ar, index,
			     (const void **) aud_subj_p);
}

/* p141 - obtain the data items from a audit subject - returns
   non-negative number of data items associated with subject */

int aud_get_subj_info(aud_subj_t aud_subj_d, int item_id,
		      const aud_info_t **aud_subj_info_p)
{
    return __aud_get_subj_info(__AUD_MAGIC_SUBJ, aud_subj_d, item_id,
			       aud_subj_info_p);
}

/* p154 - add a subject to an audit record - returns 0(success)
   -1(failure) */

int aud_put_subj(aud_rec_t ar, const aud_subj_t *next_p, aud_subj_t *new_p)
{
    return __aud_put_subj(__AUD_MAGIC_SUBJ, ar,
			  (const struct __aud_section_s **) next_p,
			  (const struct __aud_section_s **) new_p);
}

/* p155 - add a subject data item to a subject record - returns 0(success)
   -1(failure) */

int aud_put_subj_info(aud_subj_t aud_subj_d, int position, int item_id,
		      const aud_info_t *aud_subj_info_p)
{
    return __aud_put_subj_info(__AUD_MAGIC_SUBJ, aud_subj_d, position,
			       item_id, aud_subj_info_p);
}

/*
 * $Log$
 */
