#ifndef XCONV_H
#define XCONV_H

#include <sys/types.h>
#include "pipe.h"

/*
 * this is the structure (array) we will pass to the widget. It is used
 * in the non-windowing code, and is generated from the arbitrary module
 * request.
 */

enum _PAMGraphicsReturn {
        PGR_Running,
        PGR_Success,
        PGR_Abort,
        PGR_Fallthrough
};

/* PAM process' only reference to X child */

typedef struct {
    struct pipeio_t cpipe;                        /* conversation in/out */
    pid_t child;
} ConversingStruct;

extern int StartGraphicsInterface(int argc, char **argv,
				  ConversingStruct **appdata);

extern int EndGraphicsInterface(ConversingStruct **appdata, int success);

void InterruptGraphics(ConversingStruct *io);

#endif /* XCONV_H */
