#ifndef _Auth_h
#define _Auth_h

/*
 * Copyright (c) 1997 Ben Buxton
 */

#include <X11/Xmu/Converters.h>
#include <X11/StringDefs.h>

/****************************************************************
 *
 * Auth widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/
#define XtNlabelFore "labelFore"
#define XtNmessageFore "messageFore"
#define XtNmessageBack "messagBack"
#define XtNpromptFore "promptFore"
#define XtNentryFore "entryFore"
#define XtNshadowWidth "shadowWidth"
#define XtCShadowWidth "ShadowWidth"
#define XtNtopShadowPixel "topShadowPixel"
#define XtNbotShadowPixel "botShadowPixel"
#define XtCTopShadowPixel "TopShadowPixel"
#define XtCBotShadowPixel "BotShadowPixel"
#define XtNlabelFont "labelFont"
#define XtNpromptFont "promptFont"
#define XtNentryFont "entryFont"
#define XtNmessageFont "messageFont"
#define XtNbannerString "bannerString"
#define XtNuserString "userString"
#define XtNpassString "passString"
#define XtNmessageString "messageString"
#define XtNentryMargin "entryMargin"
#define XtCEntryMargin "EntryMargin"
#define XtNabortNotify "abortNotify"
#define XtNokNotify "okNotify"
#define XtNclearPrompts "clearPrompts"
#define XtNclearMessage "clearMessage"

#define XtNaddEchoString      "addEchoString"
#define XtNaddLabelString     "addLabelString"
#define XtNaddNoEchoString    "addNoEchoString"

#define LOGIN_OK 0
#define LOGIN_SAFE 1


/* declare specific TemplateWidget class and instance datatypes */

typedef struct _AuthClassRec*	AuthWidgetClass;
typedef struct _AuthRec*		AuthWidget;

/* Declared here as callbacks for the widget use it */
typedef struct {
        char    *labeltext;
        int     type; /* echo, noecho, error, message */
        char    *entrytext;
        int     left; /* Left position of cursor */
        int     right;
        struct Prompt *next;
} Prompt;

/* declare the class constant */

extern WidgetClass authWidgetClass;

#endif /* _Auth_h */
