/*
 * linux/mm/oom_panic.c
 *
 * This is a very simple component that will cause the kernel to
 * panic on out-of-memory conditions.  The behavior of panic can be
 * further controlled with /proc/sys/kernel/panic.
 *
 *       --rustyl <rusty@linux.intel.com>
 *
 * Final modularization (C) 2003  Tvrtko A. Ursulin (tvrtko.ursulin@zg.htnet.hr)
 *
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/notifier.h>
#include <linux/oom_notifier.h>

static int oom_notify(struct notifier_block * s, unsigned long v, void * d)
{
	panic("Out-Of-Memory");
	return 0;
}

static struct notifier_block oom_nb = {
	.notifier_call = oom_notify,
};

static int __init init_oom_panic(void)
{
	int err;

	info("Installing oom_panic handler");
	err = register_oom_notifier(&oom_nb);
	if (err)
		error("Error installing oom_panic handler!");

	return err;
}

static void __exit exit_oom_panic(void)
{
	unregister_oom_notifier(&oom_nb);
}

MODULE_LICENSE("GPL");

module_init(init_oom_panic);
module_exit(exit_oom_panic);
