/************************************* */
/* Rule Set Based Access Control       */
/* Author and (c) 1999,2000: Amon Ott  */
/* file system                         */
/* Helper functions for all parts      */
/* Last modified: 07/Sep/2000          */
/************************************* */

#ifndef __RSBAC_FS_H
#define __RSBAC_FS_H

#include <linux/fs.h>

/* original lookup_dentry function without rsbac patch for adf call */

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
struct dentry * rsbac_lookup_dentry(const char *, struct dentry *, u_int);
#else
struct dentry * rsbac_lookup_hash(struct qstr *name, struct dentry * base);
struct dentry * rsbac_lookup_one_len(const char * name, struct dentry * base, int len);

#ifndef SOCKFS_MAGIC
#define SOCKFS_MAGIC 0x534F434B
#endif
#endif

struct super_block * rsbac_get_super_block(kdev_t kdev);

extern void __fput(struct file *);

#ifndef SHM_FS_MAGIC
#define SHM_FS_MAGIC 0x02011994
#endif

#endif
