#ifndef __LINUX_BADMEM_H
#define __LINUX_BADMEM_H

#include <linux/config.h>
#include <linux/mm.h>
#include <linux/pagemap.h>

#define BADMEM_VERSION "V4.9"
#define BADMEM_FEATURES "BIGMEMalpha PROC MEMMAP MODSYSTEMbeta"

// The maximum number of values (address, mask pairs) covering bad RAM.
// This value is hardcoded (!) in init/main.c, get_options()
#define BADMEM_MAXPARAMS 10
extern void badmem_markpages(void);

#ifndef CONFIG_BADMEM_MODSYSTEM
extern ulong badmem_params[BADMEM_MAXPARAMS+1];
extern int badmem_paramcount;
#else
extern char badmem_instmodules[BADMEM_MAXPARAMS+1][32]; // the installed modules which we get by command line (LILO)
#endif

// cross import of page_is_ram() from arch/i386/mm/init.c
// sorry, for this really dirty hack; has anyone a better idea?
extern int page_is_ram (unsigned long pagenr);

extern int badmemmemmap_read_proc (char *buf, char **start, off_t off, int count, int *eof, void *data);
extern int badmemmemmap_write_proc (struct file *file, const char *buffer, unsigned long count, void *data); 


#ifdef CONFIG_BADMEM_MODSYSTEM
struct badmem_modules {
   char *mod_name;
   int mdflen;
   char *mdfdata;
};

extern struct badmem_modules badmem_modtab[];
extern int absolutemode;  // Defines whether there are absolute addresses (!= 0) or not (== 0)
extern char mdf__absolute[];
#endif

#endif /* IFNDEF __LINUX_BADMEM_H */
