#ifndef __UWIOCTL_H_
#define __UWIOCTL_H_


// **********************************************************************
// * uwioctl.h                                                          *
// *                                                                    *
// * Written by Matthew DeLoera (deloera@us.ibm.com)                    *
// * (C) Copyright IBM Corporation, 1998-2001                           *
// *                                                                    *
// *  This software may be used and distributed according to the terms  *
// *  of the GNU Public License, incorporated herein by reference.      *
// **********************************************************************

// **********************************************************************
// * uwioctl.h - This header contains all shared library related types  *
// *             and constants.                                         *
// *                                                                    *
// * Changes                                                            *
// * -------                                                            *
// * 01/29/2001 - Cleaned up for open source release.                   *
// **********************************************************************


// ***********
// * DEFINES *
// ***********

#define IOCTL_DEREGISTER                  0xC0DE
#define IOCTL_REGISTER                    0xC1DE
#define IOCTL_RW                          0xC2DE
#define IOCTL_CANCELBYPID                 0xC3DE
#define IOCTL_DEBUG                       0xC4DE
#define IOCTL_DISCONNECT                  0xC5DE
#define IOCTL_GETPID                      0xC6DE
#define IOCTL_RW_PENDING                  0xC7DE           
#define IOCTL_RW_INITIATED                0xC8DE           
#define IOCTL_WRITE_DESKTOP_STATUS        0xC9DE           
#define IOCTL_GET_INPUT_DATA              0xCADE           
#define IOCTL_WRITE_DISPLAY_STATUS        0xCBDE           
#define IOCTL_GET_VNC_STATUS              0xCCDE           
#define IOCTL_SEND_REVERSE_HB             0xCDDE           
#define IOCTL_COUNTSP                     0xCEDE


#define MAGIC_NUMBER_INIT                 0x0000

#define DDERR_SUCCESS                     0x00000000
#define DDERR_EVENT_CANCELLED             0xBAD00001
#define DDERR_EVENT_ALREADY_REGISTERED    0xBAD00002
#define DDERR_INTERRUPTED                 0xBAD00003
#define DDERR_DRIVER_CLOSED               0xBAD00005
#define DDERR_PID_NOT_REGISTERED          0xBAD00006
#define DDERR_UNKNOWN_IOCTL               0xBAD00007
#define DDERR_RCV_TIMEOUT                 0xBAD00020
#define DDERR_SEND_BYTE_FAILED            0xBAD00030
#define DDERR_SVALLOC_CMD                 0xBAD00050
#define DDERR_ZALLOC_CMD                  0xBAD00055
#define DDERR_ZALLOC_CMD_BUFFER           0xBAD00056
#define DDERR_SVALLOC_EVENT               0xBAD00060
#define DDERR_ZALLOC_EVENT                0xBAD00065
#define DDERR_COPYIN_I2O_MESSAGE          0xBAD00070
#define DDERR_UNEXPECTED_CMD_RESPONSE     0xBAD00075
#define DDERR_PENDING_CMD_INTERRUPTED     0xBAD00080       // PHR_174969
#define DDERR_INITIATED_CMD_INTERRUPTED   0xBAD00085       // PHR_174969 
#define DDERR_SEND_RESOLUTION             0xBAD00090       // PHR_188142

 

#define DDERR_CMD_INITIATED               0xBAD0CC00
#define DDERR_CMD_PENDING                 0xBAD0CC05
#define DDERR_EV_INITIATED                0xBAD0EE00
#define DDERR_EV_PENDING                  0xBAD0EE05
#define DDERR_EV_SIGNAL                   0xBAD0EE10

#define RC_SEND_RESOLUTION                20               // PHR_188142
                                                     
                                                     
// ************
// * TYPEDEFS *
// ************

typedef u_char    UINT8;
typedef u_char    UCHAR;
typedef u_short   UINT16;
typedef u_short   USHORT;

// Start of PHR_180930
/* i386 these typedefs are not portable to 64 bit machines.  
I replaced them with portable definitions note that ULONG is a 32 bit type.
That is somewhat inelegant and I may fix it later.  fwt

typedef u_long       UINT;
typedef u_long       UINT32;
typedef u_long       ULONG;
*/
                 
typedef u_int	     UINT;
typedef u_int32_t	 UINT32;
typedef u_int32_t	 ULONG;
// End of PHR_180930

typedef u_char   *PUCHAR;
typedef u_short  *PUSHORT;
typedef u_long   *PULONG;
typedef short     SHORT;
typedef long      LONG;
typedef void      VOID;
typedef char     *PCHAR;

typedef struct _dd_ioctl_info            
{
     unsigned int   uiPID;
     u_short  magicNumber;
     int      returnCode;
     int      bufferLength;
     u_char  *pBuffer;
} DD_IOCTL_INFO, *PDD_IOCTL_INFO;


#endif
