// RUN: %clang_tsan %s -o %t -framework Foundation
// RUN: %run %t 2>&1

#import <Foundation/Foundation.h>

long global;

int main() {
    NSLog(@"Hello world.");

    global = 42;
    
    dispatch_semaphore_t sem = dispatch_semaphore_create(0);
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        global = 43;
        dispatch_semaphore_signal(sem);
    });
    
    dispatch_semaphore_wait(sem, DISPATCH_TIME_FOREVER);
    global = 44;

    NSLog(@"Done.");
    return 0;
}

// CHECK: Hello world.
// CHECK: Done.
// CHECK-NOT: WARNING: ThreadSanitizer
