// RUN: llvm-mc -triple x86_64-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: vpmullq %xmm22, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x22,0xf5,0x00,0x40,0xd6]
          vpmullq %xmm22, %xmm17, %xmm26

// CHECK: vpmullq %xmm22, %xmm17, %xmm26 {%k6}
// CHECK:  encoding: [0x62,0x22,0xf5,0x06,0x40,0xd6]
          vpmullq %xmm22, %xmm17, %xmm26 {%k6}

// CHECK: vpmullq %xmm22, %xmm17, %xmm26 {%k6} {z}
// CHECK:  encoding: [0x62,0x22,0xf5,0x86,0x40,0xd6]
          vpmullq %xmm22, %xmm17, %xmm26 {%k6} {z}

// CHECK: vpmullq (%rcx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x40,0x11]
          vpmullq (%rcx), %xmm17, %xmm26

// CHECK: vpmullq 291(%rax,%r14,8), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x22,0xf5,0x00,0x40,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmullq 291(%rax,%r14,8), %xmm17, %xmm26

// CHECK: vpmullq (%rcx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x10,0x40,0x11]
          vpmullq (%rcx){1to2}, %xmm17, %xmm26

// CHECK: vpmullq 2032(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x40,0x52,0x7f]
          vpmullq 2032(%rdx), %xmm17, %xmm26

// CHECK: vpmullq 2048(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x40,0x92,0x00,0x08,0x00,0x00]
          vpmullq 2048(%rdx), %xmm17, %xmm26

// CHECK: vpmullq -2048(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x40,0x52,0x80]
          vpmullq -2048(%rdx), %xmm17, %xmm26

// CHECK: vpmullq -2064(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x00,0x40,0x92,0xf0,0xf7,0xff,0xff]
          vpmullq -2064(%rdx), %xmm17, %xmm26

// CHECK: vpmullq 1016(%rdx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x10,0x40,0x52,0x7f]
          vpmullq 1016(%rdx){1to2}, %xmm17, %xmm26

// CHECK: vpmullq 1024(%rdx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x10,0x40,0x92,0x00,0x04,0x00,0x00]
          vpmullq 1024(%rdx){1to2}, %xmm17, %xmm26

// CHECK: vpmullq -1024(%rdx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x10,0x40,0x52,0x80]
          vpmullq -1024(%rdx){1to2}, %xmm17, %xmm26

// CHECK: vpmullq -1032(%rdx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x62,0xf5,0x10,0x40,0x92,0xf8,0xfb,0xff,0xff]
          vpmullq -1032(%rdx){1to2}, %xmm17, %xmm26

// CHECK: vpmullq %ymm25, %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x02,0xb5,0x20,0x40,0xc9]
          vpmullq %ymm25, %ymm25, %ymm25

// CHECK: vpmullq %ymm25, %ymm25, %ymm25 {%k3}
// CHECK:  encoding: [0x62,0x02,0xb5,0x23,0x40,0xc9]
          vpmullq %ymm25, %ymm25, %ymm25 {%k3}

// CHECK: vpmullq %ymm25, %ymm25, %ymm25 {%k3} {z}
// CHECK:  encoding: [0x62,0x02,0xb5,0xa3,0x40,0xc9]
          vpmullq %ymm25, %ymm25, %ymm25 {%k3} {z}

// CHECK: vpmullq (%rcx), %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x40,0x09]
          vpmullq (%rcx), %ymm25, %ymm25

// CHECK: vpmullq 291(%rax,%r14,8), %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x22,0xb5,0x20,0x40,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmullq 291(%rax,%r14,8), %ymm25, %ymm25

// CHECK: vpmullq (%rcx){1to4}, %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x30,0x40,0x09]
          vpmullq (%rcx){1to4}, %ymm25, %ymm25

// CHECK: vpmullq 4064(%rdx), %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x40,0x4a,0x7f]
          vpmullq 4064(%rdx), %ymm25, %ymm25

// CHECK: vpmullq 4096(%rdx), %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x40,0x8a,0x00,0x10,0x00,0x00]
          vpmullq 4096(%rdx), %ymm25, %ymm25

// CHECK: vpmullq -4096(%rdx), %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x40,0x4a,0x80]
          vpmullq -4096(%rdx), %ymm25, %ymm25

// CHECK: vpmullq -4128(%rdx), %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x20,0x40,0x8a,0xe0,0xef,0xff,0xff]
          vpmullq -4128(%rdx), %ymm25, %ymm25

// CHECK: vpmullq 1016(%rdx){1to4}, %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x30,0x40,0x4a,0x7f]
          vpmullq 1016(%rdx){1to4}, %ymm25, %ymm25

// CHECK: vpmullq 1024(%rdx){1to4}, %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x30,0x40,0x8a,0x00,0x04,0x00,0x00]
          vpmullq 1024(%rdx){1to4}, %ymm25, %ymm25

// CHECK: vpmullq -1024(%rdx){1to4}, %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x30,0x40,0x4a,0x80]
          vpmullq -1024(%rdx){1to4}, %ymm25, %ymm25

// CHECK: vpmullq -1032(%rdx){1to4}, %ymm25, %ymm25
// CHECK:  encoding: [0x62,0x62,0xb5,0x30,0x40,0x8a,0xf8,0xfb,0xff,0xff]
          vpmullq -1032(%rdx){1to4}, %ymm25, %ymm25

// CHECK: vandpd %xmm20, %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xa1,0x95,0x00,0x54,0xec]
          vandpd %xmm20, %xmm29, %xmm21

// CHECK: vandpd %xmm20, %xmm29, %xmm21 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x95,0x06,0x54,0xec]
          vandpd %xmm20, %xmm29, %xmm21 {%k6}

// CHECK: vandpd %xmm20, %xmm29, %xmm21 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x95,0x86,0x54,0xec]
          vandpd %xmm20, %xmm29, %xmm21 {%k6} {z}

// CHECK: vandpd (%rcx), %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x54,0x29]
          vandpd (%rcx), %xmm29, %xmm21

// CHECK: vandpd 291(%rax,%r14,8), %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xa1,0x95,0x00,0x54,0xac,0xf0,0x23,0x01,0x00,0x00]
          vandpd 291(%rax,%r14,8), %xmm29, %xmm21

// CHECK: vandpd (%rcx){1to2}, %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x54,0x29]
          vandpd (%rcx){1to2}, %xmm29, %xmm21

// CHECK: vandpd 2032(%rdx), %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x54,0x6a,0x7f]
          vandpd 2032(%rdx), %xmm29, %xmm21

// CHECK: vandpd 2048(%rdx), %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x54,0xaa,0x00,0x08,0x00,0x00]
          vandpd 2048(%rdx), %xmm29, %xmm21

// CHECK: vandpd -2048(%rdx), %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x54,0x6a,0x80]
          vandpd -2048(%rdx), %xmm29, %xmm21

// CHECK: vandpd -2064(%rdx), %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x54,0xaa,0xf0,0xf7,0xff,0xff]
          vandpd -2064(%rdx), %xmm29, %xmm21

// CHECK: vandpd 1016(%rdx){1to2}, %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x54,0x6a,0x7f]
          vandpd 1016(%rdx){1to2}, %xmm29, %xmm21

// CHECK: vandpd 1024(%rdx){1to2}, %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x54,0xaa,0x00,0x04,0x00,0x00]
          vandpd 1024(%rdx){1to2}, %xmm29, %xmm21

// CHECK: vandpd -1024(%rdx){1to2}, %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x54,0x6a,0x80]
          vandpd -1024(%rdx){1to2}, %xmm29, %xmm21

// CHECK: vandpd -1032(%rdx){1to2}, %xmm29, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x54,0xaa,0xf8,0xfb,0xff,0xff]
          vandpd -1032(%rdx){1to2}, %xmm29, %xmm21

// CHECK: vandpd %ymm28, %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x01,0xd5,0x20,0x54,0xe4]
          vandpd %ymm28, %ymm21, %ymm28

// CHECK: vandpd %ymm28, %ymm21, %ymm28 {%k4}
// CHECK:  encoding: [0x62,0x01,0xd5,0x24,0x54,0xe4]
          vandpd %ymm28, %ymm21, %ymm28 {%k4}

// CHECK: vandpd %ymm28, %ymm21, %ymm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0xd5,0xa4,0x54,0xe4]
          vandpd %ymm28, %ymm21, %ymm28 {%k4} {z}

// CHECK: vandpd (%rcx), %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x54,0x21]
          vandpd (%rcx), %ymm21, %ymm28

// CHECK: vandpd 291(%rax,%r14,8), %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x21,0xd5,0x20,0x54,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vandpd 291(%rax,%r14,8), %ymm21, %ymm28

// CHECK: vandpd (%rcx){1to4}, %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x54,0x21]
          vandpd (%rcx){1to4}, %ymm21, %ymm28

// CHECK: vandpd 4064(%rdx), %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x54,0x62,0x7f]
          vandpd 4064(%rdx), %ymm21, %ymm28

// CHECK: vandpd 4096(%rdx), %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x54,0xa2,0x00,0x10,0x00,0x00]
          vandpd 4096(%rdx), %ymm21, %ymm28

// CHECK: vandpd -4096(%rdx), %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x54,0x62,0x80]
          vandpd -4096(%rdx), %ymm21, %ymm28

// CHECK: vandpd -4128(%rdx), %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x54,0xa2,0xe0,0xef,0xff,0xff]
          vandpd -4128(%rdx), %ymm21, %ymm28

// CHECK: vandpd 1016(%rdx){1to4}, %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x54,0x62,0x7f]
          vandpd 1016(%rdx){1to4}, %ymm21, %ymm28

// CHECK: vandpd 1024(%rdx){1to4}, %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x54,0xa2,0x00,0x04,0x00,0x00]
          vandpd 1024(%rdx){1to4}, %ymm21, %ymm28

// CHECK: vandpd -1024(%rdx){1to4}, %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x54,0x62,0x80]
          vandpd -1024(%rdx){1to4}, %ymm21, %ymm28

// CHECK: vandpd -1032(%rdx){1to4}, %ymm21, %ymm28
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x54,0xa2,0xf8,0xfb,0xff,0xff]
          vandpd -1032(%rdx){1to4}, %ymm21, %ymm28

// CHECK: vandps %xmm24, %xmm21, %xmm23
// CHECK:  encoding: [0x62,0x81,0x54,0x00,0x54,0xf8]
          vandps %xmm24, %xmm21, %xmm23

// CHECK: vandps %xmm24, %xmm21, %xmm23 {%k5}
// CHECK:  encoding: [0x62,0x81,0x54,0x05,0x54,0xf8]
          vandps %xmm24, %xmm21, %xmm23 {%k5}

// CHECK: vandps %xmm24, %xmm21, %xmm23 {%k5} {z}
// CHECK:  encoding: [0x62,0x81,0x54,0x85,0x54,0xf8]
          vandps %xmm24, %xmm21, %xmm23 {%k5} {z}

// CHECK: vandps (%rcx), %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x54,0x39]
          vandps (%rcx), %xmm21, %xmm23

// CHECK: vandps 291(%rax,%r14,8), %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xa1,0x54,0x00,0x54,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vandps 291(%rax,%r14,8), %xmm21, %xmm23

// CHECK: vandps (%rcx){1to4}, %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x54,0x39]
          vandps (%rcx){1to4}, %xmm21, %xmm23

// CHECK: vandps 2032(%rdx), %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x54,0x7a,0x7f]
          vandps 2032(%rdx), %xmm21, %xmm23

// CHECK: vandps 2048(%rdx), %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x54,0xba,0x00,0x08,0x00,0x00]
          vandps 2048(%rdx), %xmm21, %xmm23

// CHECK: vandps -2048(%rdx), %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x54,0x7a,0x80]
          vandps -2048(%rdx), %xmm21, %xmm23

// CHECK: vandps -2064(%rdx), %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x54,0xba,0xf0,0xf7,0xff,0xff]
          vandps -2064(%rdx), %xmm21, %xmm23

// CHECK: vandps 508(%rdx){1to4}, %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x54,0x7a,0x7f]
          vandps 508(%rdx){1to4}, %xmm21, %xmm23

// CHECK: vandps 512(%rdx){1to4}, %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x54,0xba,0x00,0x02,0x00,0x00]
          vandps 512(%rdx){1to4}, %xmm21, %xmm23

// CHECK: vandps -512(%rdx){1to4}, %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x54,0x7a,0x80]
          vandps -512(%rdx){1to4}, %xmm21, %xmm23

// CHECK: vandps -516(%rdx){1to4}, %xmm21, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x54,0xba,0xfc,0xfd,0xff,0xff]
          vandps -516(%rdx){1to4}, %xmm21, %xmm23

// CHECK: vandps %ymm23, %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x21,0x6c,0x20,0x54,0xd7]
          vandps %ymm23, %ymm18, %ymm26

// CHECK: vandps %ymm23, %ymm18, %ymm26 {%k6}
// CHECK:  encoding: [0x62,0x21,0x6c,0x26,0x54,0xd7]
          vandps %ymm23, %ymm18, %ymm26 {%k6}

// CHECK: vandps %ymm23, %ymm18, %ymm26 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0x6c,0xa6,0x54,0xd7]
          vandps %ymm23, %ymm18, %ymm26 {%k6} {z}

// CHECK: vandps (%rcx), %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x20,0x54,0x11]
          vandps (%rcx), %ymm18, %ymm26

// CHECK: vandps 291(%rax,%r14,8), %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x21,0x6c,0x20,0x54,0x94,0xf0,0x23,0x01,0x00,0x00]
          vandps 291(%rax,%r14,8), %ymm18, %ymm26

// CHECK: vandps (%rcx){1to8}, %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x30,0x54,0x11]
          vandps (%rcx){1to8}, %ymm18, %ymm26

// CHECK: vandps 4064(%rdx), %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x20,0x54,0x52,0x7f]
          vandps 4064(%rdx), %ymm18, %ymm26

// CHECK: vandps 4096(%rdx), %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x20,0x54,0x92,0x00,0x10,0x00,0x00]
          vandps 4096(%rdx), %ymm18, %ymm26

// CHECK: vandps -4096(%rdx), %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x20,0x54,0x52,0x80]
          vandps -4096(%rdx), %ymm18, %ymm26

// CHECK: vandps -4128(%rdx), %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x20,0x54,0x92,0xe0,0xef,0xff,0xff]
          vandps -4128(%rdx), %ymm18, %ymm26

// CHECK: vandps 508(%rdx){1to8}, %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x30,0x54,0x52,0x7f]
          vandps 508(%rdx){1to8}, %ymm18, %ymm26

// CHECK: vandps 512(%rdx){1to8}, %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x30,0x54,0x92,0x00,0x02,0x00,0x00]
          vandps 512(%rdx){1to8}, %ymm18, %ymm26

// CHECK: vandps -512(%rdx){1to8}, %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x30,0x54,0x52,0x80]
          vandps -512(%rdx){1to8}, %ymm18, %ymm26

// CHECK: vandps -516(%rdx){1to8}, %ymm18, %ymm26
// CHECK:  encoding: [0x62,0x61,0x6c,0x30,0x54,0x92,0xfc,0xfd,0xff,0xff]
          vandps -516(%rdx){1to8}, %ymm18, %ymm26

// CHECK: vandnpd %xmm25, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x01,0xa5,0x00,0x55,0xc9]
          vandnpd %xmm25, %xmm27, %xmm25

// CHECK: vandnpd %xmm25, %xmm27, %xmm25 {%k5}
// CHECK:  encoding: [0x62,0x01,0xa5,0x05,0x55,0xc9]
          vandnpd %xmm25, %xmm27, %xmm25 {%k5}

// CHECK: vandnpd %xmm25, %xmm27, %xmm25 {%k5} {z}
// CHECK:  encoding: [0x62,0x01,0xa5,0x85,0x55,0xc9]
          vandnpd %xmm25, %xmm27, %xmm25 {%k5} {z}

// CHECK: vandnpd (%rcx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x00,0x55,0x09]
          vandnpd (%rcx), %xmm27, %xmm25

// CHECK: vandnpd 291(%rax,%r14,8), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x21,0xa5,0x00,0x55,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vandnpd 291(%rax,%r14,8), %xmm27, %xmm25

// CHECK: vandnpd (%rcx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x10,0x55,0x09]
          vandnpd (%rcx){1to2}, %xmm27, %xmm25

// CHECK: vandnpd 2032(%rdx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x00,0x55,0x4a,0x7f]
          vandnpd 2032(%rdx), %xmm27, %xmm25

// CHECK: vandnpd 2048(%rdx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x00,0x55,0x8a,0x00,0x08,0x00,0x00]
          vandnpd 2048(%rdx), %xmm27, %xmm25

// CHECK: vandnpd -2048(%rdx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x00,0x55,0x4a,0x80]
          vandnpd -2048(%rdx), %xmm27, %xmm25

// CHECK: vandnpd -2064(%rdx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x00,0x55,0x8a,0xf0,0xf7,0xff,0xff]
          vandnpd -2064(%rdx), %xmm27, %xmm25

// CHECK: vandnpd 1016(%rdx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x10,0x55,0x4a,0x7f]
          vandnpd 1016(%rdx){1to2}, %xmm27, %xmm25

// CHECK: vandnpd 1024(%rdx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x10,0x55,0x8a,0x00,0x04,0x00,0x00]
          vandnpd 1024(%rdx){1to2}, %xmm27, %xmm25

// CHECK: vandnpd -1024(%rdx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x10,0x55,0x4a,0x80]
          vandnpd -1024(%rdx){1to2}, %xmm27, %xmm25

// CHECK: vandnpd -1032(%rdx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x10,0x55,0x8a,0xf8,0xfb,0xff,0xff]
          vandnpd -1032(%rdx){1to2}, %xmm27, %xmm25

// CHECK: vandnpd %ymm22, %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xa1,0xed,0x20,0x55,0xf6]
          vandnpd %ymm22, %ymm18, %ymm22

// CHECK: vandnpd %ymm22, %ymm18, %ymm22 {%k7}
// CHECK:  encoding: [0x62,0xa1,0xed,0x27,0x55,0xf6]
          vandnpd %ymm22, %ymm18, %ymm22 {%k7}

// CHECK: vandnpd %ymm22, %ymm18, %ymm22 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0xed,0xa7,0x55,0xf6]
          vandnpd %ymm22, %ymm18, %ymm22 {%k7} {z}

// CHECK: vandnpd (%rcx), %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0x55,0x31]
          vandnpd (%rcx), %ymm18, %ymm22

// CHECK: vandnpd 291(%rax,%r14,8), %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xa1,0xed,0x20,0x55,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vandnpd 291(%rax,%r14,8), %ymm18, %ymm22

// CHECK: vandnpd (%rcx){1to4}, %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0x55,0x31]
          vandnpd (%rcx){1to4}, %ymm18, %ymm22

// CHECK: vandnpd 4064(%rdx), %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0x55,0x72,0x7f]
          vandnpd 4064(%rdx), %ymm18, %ymm22

// CHECK: vandnpd 4096(%rdx), %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0x55,0xb2,0x00,0x10,0x00,0x00]
          vandnpd 4096(%rdx), %ymm18, %ymm22

// CHECK: vandnpd -4096(%rdx), %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0x55,0x72,0x80]
          vandnpd -4096(%rdx), %ymm18, %ymm22

// CHECK: vandnpd -4128(%rdx), %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0x55,0xb2,0xe0,0xef,0xff,0xff]
          vandnpd -4128(%rdx), %ymm18, %ymm22

// CHECK: vandnpd 1016(%rdx){1to4}, %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0x55,0x72,0x7f]
          vandnpd 1016(%rdx){1to4}, %ymm18, %ymm22

// CHECK: vandnpd 1024(%rdx){1to4}, %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0x55,0xb2,0x00,0x04,0x00,0x00]
          vandnpd 1024(%rdx){1to4}, %ymm18, %ymm22

// CHECK: vandnpd -1024(%rdx){1to4}, %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0x55,0x72,0x80]
          vandnpd -1024(%rdx){1to4}, %ymm18, %ymm22

// CHECK: vandnpd -1032(%rdx){1to4}, %ymm18, %ymm22
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0x55,0xb2,0xf8,0xfb,0xff,0xff]
          vandnpd -1032(%rdx){1to4}, %ymm18, %ymm22

// CHECK: vandnps %xmm27, %xmm21, %xmm21
// CHECK:  encoding: [0x62,0x81,0x54,0x00,0x55,0xeb]
          vandnps %xmm27, %xmm21, %xmm21

// CHECK: vandnps %xmm27, %xmm21, %xmm21 {%k2}
// CHECK:  encoding: [0x62,0x81,0x54,0x02,0x55,0xeb]
          vandnps %xmm27, %xmm21, %xmm21 {%k2}

// CHECK: vandnps %xmm27, %xmm21, %xmm21 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x54,0x82,0x55,0xeb]
          vandnps %xmm27, %xmm21, %xmm21 {%k2} {z}

// CHECK: vandnps (%rcx), %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x55,0x29]
          vandnps (%rcx), %xmm21, %xmm21

// CHECK: vandnps 291(%rax,%r14,8), %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xa1,0x54,0x00,0x55,0xac,0xf0,0x23,0x01,0x00,0x00]
          vandnps 291(%rax,%r14,8), %xmm21, %xmm21

// CHECK: vandnps (%rcx){1to4}, %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x55,0x29]
          vandnps (%rcx){1to4}, %xmm21, %xmm21

// CHECK: vandnps 2032(%rdx), %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x55,0x6a,0x7f]
          vandnps 2032(%rdx), %xmm21, %xmm21

// CHECK: vandnps 2048(%rdx), %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x55,0xaa,0x00,0x08,0x00,0x00]
          vandnps 2048(%rdx), %xmm21, %xmm21

// CHECK: vandnps -2048(%rdx), %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x55,0x6a,0x80]
          vandnps -2048(%rdx), %xmm21, %xmm21

// CHECK: vandnps -2064(%rdx), %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x55,0xaa,0xf0,0xf7,0xff,0xff]
          vandnps -2064(%rdx), %xmm21, %xmm21

// CHECK: vandnps 508(%rdx){1to4}, %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x55,0x6a,0x7f]
          vandnps 508(%rdx){1to4}, %xmm21, %xmm21

// CHECK: vandnps 512(%rdx){1to4}, %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x55,0xaa,0x00,0x02,0x00,0x00]
          vandnps 512(%rdx){1to4}, %xmm21, %xmm21

// CHECK: vandnps -512(%rdx){1to4}, %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x55,0x6a,0x80]
          vandnps -512(%rdx){1to4}, %xmm21, %xmm21

// CHECK: vandnps -516(%rdx){1to4}, %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x55,0xaa,0xfc,0xfd,0xff,0xff]
          vandnps -516(%rdx){1to4}, %xmm21, %xmm21

// CHECK: vandnps %ymm25, %ymm23, %ymm19
// CHECK:  encoding: [0x62,0x81,0x44,0x20,0x55,0xd9]
          vandnps %ymm25, %ymm23, %ymm19

// CHECK: vandnps %ymm25, %ymm23, %ymm19 {%k1}
// CHECK:  encoding: [0x62,0x81,0x44,0x21,0x55,0xd9]
          vandnps %ymm25, %ymm23, %ymm19 {%k1}

// CHECK: vandnps %ymm25, %ymm23, %ymm19 {%k1} {z}
// CHECK:  encoding: [0x62,0x81,0x44,0xa1,0x55,0xd9]
          vandnps %ymm25, %ymm23, %ymm19 {%k1} {z}

// CHECK: vandnps (%rcx), %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x20,0x55,0x19]
          vandnps (%rcx), %ymm23, %ymm19

// CHECK: vandnps 291(%rax,%r14,8), %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xa1,0x44,0x20,0x55,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vandnps 291(%rax,%r14,8), %ymm23, %ymm19

// CHECK: vandnps (%rcx){1to8}, %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x30,0x55,0x19]
          vandnps (%rcx){1to8}, %ymm23, %ymm19

// CHECK: vandnps 4064(%rdx), %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x20,0x55,0x5a,0x7f]
          vandnps 4064(%rdx), %ymm23, %ymm19

// CHECK: vandnps 4096(%rdx), %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x20,0x55,0x9a,0x00,0x10,0x00,0x00]
          vandnps 4096(%rdx), %ymm23, %ymm19

// CHECK: vandnps -4096(%rdx), %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x20,0x55,0x5a,0x80]
          vandnps -4096(%rdx), %ymm23, %ymm19

// CHECK: vandnps -4128(%rdx), %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x20,0x55,0x9a,0xe0,0xef,0xff,0xff]
          vandnps -4128(%rdx), %ymm23, %ymm19

// CHECK: vandnps 508(%rdx){1to8}, %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x30,0x55,0x5a,0x7f]
          vandnps 508(%rdx){1to8}, %ymm23, %ymm19

// CHECK: vandnps 512(%rdx){1to8}, %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x30,0x55,0x9a,0x00,0x02,0x00,0x00]
          vandnps 512(%rdx){1to8}, %ymm23, %ymm19

// CHECK: vandnps -512(%rdx){1to8}, %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x30,0x55,0x5a,0x80]
          vandnps -512(%rdx){1to8}, %ymm23, %ymm19

// CHECK: vandnps -516(%rdx){1to8}, %ymm23, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x44,0x30,0x55,0x9a,0xfc,0xfd,0xff,0xff]
          vandnps -516(%rdx){1to8}, %ymm23, %ymm19

// CHECK: vorpd  %xmm18, %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xa1,0xa5,0x00,0x56,0xfa]
          vorpd  %xmm18, %xmm27, %xmm23

// CHECK: vorpd  %xmm18, %xmm27, %xmm23 {%k1}
// CHECK:  encoding: [0x62,0xa1,0xa5,0x01,0x56,0xfa]
          vorpd  %xmm18, %xmm27, %xmm23 {%k1}

// CHECK: vorpd  %xmm18, %xmm27, %xmm23 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0xa5,0x81,0x56,0xfa]
          vorpd  %xmm18, %xmm27, %xmm23 {%k1} {z}

// CHECK: vorpd  (%rcx), %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0x56,0x39]
          vorpd  (%rcx), %xmm27, %xmm23

// CHECK: vorpd  291(%rax,%r14,8), %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xa1,0xa5,0x00,0x56,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vorpd  291(%rax,%r14,8), %xmm27, %xmm23

// CHECK: vorpd  (%rcx){1to2}, %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0x56,0x39]
          vorpd  (%rcx){1to2}, %xmm27, %xmm23

// CHECK: vorpd  2032(%rdx), %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0x56,0x7a,0x7f]
          vorpd  2032(%rdx), %xmm27, %xmm23

// CHECK: vorpd  2048(%rdx), %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0x56,0xba,0x00,0x08,0x00,0x00]
          vorpd  2048(%rdx), %xmm27, %xmm23

// CHECK: vorpd  -2048(%rdx), %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0x56,0x7a,0x80]
          vorpd  -2048(%rdx), %xmm27, %xmm23

// CHECK: vorpd  -2064(%rdx), %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0x56,0xba,0xf0,0xf7,0xff,0xff]
          vorpd  -2064(%rdx), %xmm27, %xmm23

// CHECK: vorpd  1016(%rdx){1to2}, %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0x56,0x7a,0x7f]
          vorpd  1016(%rdx){1to2}, %xmm27, %xmm23

// CHECK: vorpd  1024(%rdx){1to2}, %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0x56,0xba,0x00,0x04,0x00,0x00]
          vorpd  1024(%rdx){1to2}, %xmm27, %xmm23

// CHECK: vorpd  -1024(%rdx){1to2}, %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0x56,0x7a,0x80]
          vorpd  -1024(%rdx){1to2}, %xmm27, %xmm23

// CHECK: vorpd  -1032(%rdx){1to2}, %xmm27, %xmm23
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0x56,0xba,0xf8,0xfb,0xff,0xff]
          vorpd  -1032(%rdx){1to2}, %xmm27, %xmm23

// CHECK: vorpd  %ymm20, %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x56,0xd4]
          vorpd  %ymm20, %ymm29, %ymm26

// CHECK: vorpd  %ymm20, %ymm29, %ymm26 {%k5}
// CHECK:  encoding: [0x62,0x21,0x95,0x25,0x56,0xd4]
          vorpd  %ymm20, %ymm29, %ymm26 {%k5}

// CHECK: vorpd  %ymm20, %ymm29, %ymm26 {%k5} {z}
// CHECK:  encoding: [0x62,0x21,0x95,0xa5,0x56,0xd4]
          vorpd  %ymm20, %ymm29, %ymm26 {%k5} {z}

// CHECK: vorpd  (%rcx), %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x56,0x11]
          vorpd  (%rcx), %ymm29, %ymm26

// CHECK: vorpd  291(%rax,%r14,8), %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x56,0x94,0xf0,0x23,0x01,0x00,0x00]
          vorpd  291(%rax,%r14,8), %ymm29, %ymm26

// CHECK: vorpd  (%rcx){1to4}, %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x56,0x11]
          vorpd  (%rcx){1to4}, %ymm29, %ymm26

// CHECK: vorpd  4064(%rdx), %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x56,0x52,0x7f]
          vorpd  4064(%rdx), %ymm29, %ymm26

// CHECK: vorpd  4096(%rdx), %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x56,0x92,0x00,0x10,0x00,0x00]
          vorpd  4096(%rdx), %ymm29, %ymm26

// CHECK: vorpd  -4096(%rdx), %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x56,0x52,0x80]
          vorpd  -4096(%rdx), %ymm29, %ymm26

// CHECK: vorpd  -4128(%rdx), %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x56,0x92,0xe0,0xef,0xff,0xff]
          vorpd  -4128(%rdx), %ymm29, %ymm26

// CHECK: vorpd  1016(%rdx){1to4}, %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x56,0x52,0x7f]
          vorpd  1016(%rdx){1to4}, %ymm29, %ymm26

// CHECK: vorpd  1024(%rdx){1to4}, %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x56,0x92,0x00,0x04,0x00,0x00]
          vorpd  1024(%rdx){1to4}, %ymm29, %ymm26

// CHECK: vorpd  -1024(%rdx){1to4}, %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x56,0x52,0x80]
          vorpd  -1024(%rdx){1to4}, %ymm29, %ymm26

// CHECK: vorpd  -1032(%rdx){1to4}, %ymm29, %ymm26
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x56,0x92,0xf8,0xfb,0xff,0xff]
          vorpd  -1032(%rdx){1to4}, %ymm29, %ymm26

// CHECK: vorps  %xmm27, %xmm28, %xmm19
// CHECK:  encoding: [0x62,0x81,0x1c,0x00,0x56,0xdb]
          vorps  %xmm27, %xmm28, %xmm19

// CHECK: vorps  %xmm27, %xmm28, %xmm19 {%k4}
// CHECK:  encoding: [0x62,0x81,0x1c,0x04,0x56,0xdb]
          vorps  %xmm27, %xmm28, %xmm19 {%k4}

// CHECK: vorps  %xmm27, %xmm28, %xmm19 {%k4} {z}
// CHECK:  encoding: [0x62,0x81,0x1c,0x84,0x56,0xdb]
          vorps  %xmm27, %xmm28, %xmm19 {%k4} {z}

// CHECK: vorps  (%rcx), %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x00,0x56,0x19]
          vorps  (%rcx), %xmm28, %xmm19

// CHECK: vorps  291(%rax,%r14,8), %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xa1,0x1c,0x00,0x56,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vorps  291(%rax,%r14,8), %xmm28, %xmm19

// CHECK: vorps  (%rcx){1to4}, %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x10,0x56,0x19]
          vorps  (%rcx){1to4}, %xmm28, %xmm19

// CHECK: vorps  2032(%rdx), %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x00,0x56,0x5a,0x7f]
          vorps  2032(%rdx), %xmm28, %xmm19

// CHECK: vorps  2048(%rdx), %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x00,0x56,0x9a,0x00,0x08,0x00,0x00]
          vorps  2048(%rdx), %xmm28, %xmm19

// CHECK: vorps  -2048(%rdx), %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x00,0x56,0x5a,0x80]
          vorps  -2048(%rdx), %xmm28, %xmm19

// CHECK: vorps  -2064(%rdx), %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x00,0x56,0x9a,0xf0,0xf7,0xff,0xff]
          vorps  -2064(%rdx), %xmm28, %xmm19

// CHECK: vorps  508(%rdx){1to4}, %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x10,0x56,0x5a,0x7f]
          vorps  508(%rdx){1to4}, %xmm28, %xmm19

// CHECK: vorps  512(%rdx){1to4}, %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x10,0x56,0x9a,0x00,0x02,0x00,0x00]
          vorps  512(%rdx){1to4}, %xmm28, %xmm19

// CHECK: vorps  -512(%rdx){1to4}, %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x10,0x56,0x5a,0x80]
          vorps  -512(%rdx){1to4}, %xmm28, %xmm19

// CHECK: vorps  -516(%rdx){1to4}, %xmm28, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x1c,0x10,0x56,0x9a,0xfc,0xfd,0xff,0xff]
          vorps  -516(%rdx){1to4}, %xmm28, %xmm19

// CHECK: vorps  %ymm26, %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x01,0x2c,0x20,0x56,0xda]
          vorps  %ymm26, %ymm26, %ymm27

// CHECK: vorps  %ymm26, %ymm26, %ymm27 {%k1}
// CHECK:  encoding: [0x62,0x01,0x2c,0x21,0x56,0xda]
          vorps  %ymm26, %ymm26, %ymm27 {%k1}

// CHECK: vorps  %ymm26, %ymm26, %ymm27 {%k1} {z}
// CHECK:  encoding: [0x62,0x01,0x2c,0xa1,0x56,0xda]
          vorps  %ymm26, %ymm26, %ymm27 {%k1} {z}

// CHECK: vorps  (%rcx), %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x56,0x19]
          vorps  (%rcx), %ymm26, %ymm27

// CHECK: vorps  291(%rax,%r14,8), %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x21,0x2c,0x20,0x56,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vorps  291(%rax,%r14,8), %ymm26, %ymm27

// CHECK: vorps  (%rcx){1to8}, %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x56,0x19]
          vorps  (%rcx){1to8}, %ymm26, %ymm27

// CHECK: vorps  4064(%rdx), %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x56,0x5a,0x7f]
          vorps  4064(%rdx), %ymm26, %ymm27

// CHECK: vorps  4096(%rdx), %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x56,0x9a,0x00,0x10,0x00,0x00]
          vorps  4096(%rdx), %ymm26, %ymm27

// CHECK: vorps  -4096(%rdx), %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x56,0x5a,0x80]
          vorps  -4096(%rdx), %ymm26, %ymm27

// CHECK: vorps  -4128(%rdx), %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x56,0x9a,0xe0,0xef,0xff,0xff]
          vorps  -4128(%rdx), %ymm26, %ymm27

// CHECK: vorps  508(%rdx){1to8}, %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x56,0x5a,0x7f]
          vorps  508(%rdx){1to8}, %ymm26, %ymm27

// CHECK: vorps  512(%rdx){1to8}, %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x56,0x9a,0x00,0x02,0x00,0x00]
          vorps  512(%rdx){1to8}, %ymm26, %ymm27

// CHECK: vorps  -512(%rdx){1to8}, %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x56,0x5a,0x80]
          vorps  -512(%rdx){1to8}, %ymm26, %ymm27

// CHECK: vorps  -516(%rdx){1to8}, %ymm26, %ymm27
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x56,0x9a,0xfc,0xfd,0xff,0xff]
          vorps  -516(%rdx){1to8}, %ymm26, %ymm27

// CHECK: vxorpd %xmm23, %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xa1,0xd5,0x00,0x57,0xd7]
          vxorpd %xmm23, %xmm21, %xmm18

// CHECK: vxorpd %xmm23, %xmm21, %xmm18 {%k2}
// CHECK:  encoding: [0x62,0xa1,0xd5,0x02,0x57,0xd7]
          vxorpd %xmm23, %xmm21, %xmm18 {%k2}

// CHECK: vxorpd %xmm23, %xmm21, %xmm18 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0xd5,0x82,0x57,0xd7]
          vxorpd %xmm23, %xmm21, %xmm18 {%k2} {z}

// CHECK: vxorpd (%rcx), %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0x11]
          vxorpd (%rcx), %xmm21, %xmm18

// CHECK: vxorpd 291(%rax,%r14,8), %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xa1,0xd5,0x00,0x57,0x94,0xf0,0x23,0x01,0x00,0x00]
          vxorpd 291(%rax,%r14,8), %xmm21, %xmm18

// CHECK: vxorpd (%rcx){1to2}, %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0x11]
          vxorpd (%rcx){1to2}, %xmm21, %xmm18

// CHECK: vxorpd 2032(%rdx), %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0x52,0x7f]
          vxorpd 2032(%rdx), %xmm21, %xmm18

// CHECK: vxorpd 2048(%rdx), %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0x92,0x00,0x08,0x00,0x00]
          vxorpd 2048(%rdx), %xmm21, %xmm18

// CHECK: vxorpd -2048(%rdx), %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0x52,0x80]
          vxorpd -2048(%rdx), %xmm21, %xmm18

// CHECK: vxorpd -2064(%rdx), %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0x92,0xf0,0xf7,0xff,0xff]
          vxorpd -2064(%rdx), %xmm21, %xmm18

// CHECK: vxorpd 1016(%rdx){1to2}, %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0x52,0x7f]
          vxorpd 1016(%rdx){1to2}, %xmm21, %xmm18

// CHECK: vxorpd 1024(%rdx){1to2}, %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0x92,0x00,0x04,0x00,0x00]
          vxorpd 1024(%rdx){1to2}, %xmm21, %xmm18

// CHECK: vxorpd -1024(%rdx){1to2}, %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0x52,0x80]
          vxorpd -1024(%rdx){1to2}, %xmm21, %xmm18

// CHECK: vxorpd -1032(%rdx){1to2}, %xmm21, %xmm18
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0x92,0xf8,0xfb,0xff,0xff]
          vxorpd -1032(%rdx){1to2}, %xmm21, %xmm18

// CHECK: vxorpd %ymm19, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x57,0xc3]
          vxorpd %ymm19, %ymm29, %ymm24

// CHECK: vxorpd %ymm19, %ymm29, %ymm24 {%k7}
// CHECK:  encoding: [0x62,0x21,0x95,0x27,0x57,0xc3]
          vxorpd %ymm19, %ymm29, %ymm24 {%k7}

// CHECK: vxorpd %ymm19, %ymm29, %ymm24 {%k7} {z}
// CHECK:  encoding: [0x62,0x21,0x95,0xa7,0x57,0xc3]
          vxorpd %ymm19, %ymm29, %ymm24 {%k7} {z}

// CHECK: vxorpd (%rcx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x57,0x01]
          vxorpd (%rcx), %ymm29, %ymm24

// CHECK: vxorpd 291(%rax,%r14,8), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x57,0x84,0xf0,0x23,0x01,0x00,0x00]
          vxorpd 291(%rax,%r14,8), %ymm29, %ymm24

// CHECK: vxorpd (%rcx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x57,0x01]
          vxorpd (%rcx){1to4}, %ymm29, %ymm24

// CHECK: vxorpd 4064(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x57,0x42,0x7f]
          vxorpd 4064(%rdx), %ymm29, %ymm24

// CHECK: vxorpd 4096(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x57,0x82,0x00,0x10,0x00,0x00]
          vxorpd 4096(%rdx), %ymm29, %ymm24

// CHECK: vxorpd -4096(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x57,0x42,0x80]
          vxorpd -4096(%rdx), %ymm29, %ymm24

// CHECK: vxorpd -4128(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x57,0x82,0xe0,0xef,0xff,0xff]
          vxorpd -4128(%rdx), %ymm29, %ymm24

// CHECK: vxorpd 1016(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x57,0x42,0x7f]
          vxorpd 1016(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vxorpd 1024(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x57,0x82,0x00,0x04,0x00,0x00]
          vxorpd 1024(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vxorpd -1024(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x57,0x42,0x80]
          vxorpd -1024(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vxorpd -1032(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x57,0x82,0xf8,0xfb,0xff,0xff]
          vxorpd -1032(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vxorps %xmm19, %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xa1,0x6c,0x00,0x57,0xe3]
          vxorps %xmm19, %xmm18, %xmm20

// CHECK: vxorps %xmm19, %xmm18, %xmm20 {%k1}
// CHECK:  encoding: [0x62,0xa1,0x6c,0x01,0x57,0xe3]
          vxorps %xmm19, %xmm18, %xmm20 {%k1}

// CHECK: vxorps %xmm19, %xmm18, %xmm20 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0x6c,0x81,0x57,0xe3]
          vxorps %xmm19, %xmm18, %xmm20 {%k1} {z}

// CHECK: vxorps (%rcx), %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x00,0x57,0x21]
          vxorps (%rcx), %xmm18, %xmm20

// CHECK: vxorps 291(%rax,%r14,8), %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xa1,0x6c,0x00,0x57,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vxorps 291(%rax,%r14,8), %xmm18, %xmm20

// CHECK: vxorps (%rcx){1to4}, %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x10,0x57,0x21]
          vxorps (%rcx){1to4}, %xmm18, %xmm20

// CHECK: vxorps 2032(%rdx), %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x00,0x57,0x62,0x7f]
          vxorps 2032(%rdx), %xmm18, %xmm20

// CHECK: vxorps 2048(%rdx), %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x00,0x57,0xa2,0x00,0x08,0x00,0x00]
          vxorps 2048(%rdx), %xmm18, %xmm20

// CHECK: vxorps -2048(%rdx), %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x00,0x57,0x62,0x80]
          vxorps -2048(%rdx), %xmm18, %xmm20

// CHECK: vxorps -2064(%rdx), %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x00,0x57,0xa2,0xf0,0xf7,0xff,0xff]
          vxorps -2064(%rdx), %xmm18, %xmm20

// CHECK: vxorps 508(%rdx){1to4}, %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x10,0x57,0x62,0x7f]
          vxorps 508(%rdx){1to4}, %xmm18, %xmm20

// CHECK: vxorps 512(%rdx){1to4}, %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x10,0x57,0xa2,0x00,0x02,0x00,0x00]
          vxorps 512(%rdx){1to4}, %xmm18, %xmm20

// CHECK: vxorps -512(%rdx){1to4}, %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x10,0x57,0x62,0x80]
          vxorps -512(%rdx){1to4}, %xmm18, %xmm20

// CHECK: vxorps -516(%rdx){1to4}, %xmm18, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x6c,0x10,0x57,0xa2,0xfc,0xfd,0xff,0xff]
          vxorps -516(%rdx){1to4}, %xmm18, %xmm20

// CHECK: vxorps %ymm24, %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x01,0x5c,0x20,0x57,0xd8]
          vxorps %ymm24, %ymm20, %ymm27

// CHECK: vxorps %ymm24, %ymm20, %ymm27 {%k2}
// CHECK:  encoding: [0x62,0x01,0x5c,0x22,0x57,0xd8]
          vxorps %ymm24, %ymm20, %ymm27 {%k2}

// CHECK: vxorps %ymm24, %ymm20, %ymm27 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0x5c,0xa2,0x57,0xd8]
          vxorps %ymm24, %ymm20, %ymm27 {%k2} {z}

// CHECK: vxorps (%rcx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x20,0x57,0x19]
          vxorps (%rcx), %ymm20, %ymm27

// CHECK: vxorps 291(%rax,%r14,8), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x21,0x5c,0x20,0x57,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vxorps 291(%rax,%r14,8), %ymm20, %ymm27

// CHECK: vxorps (%rcx){1to8}, %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x30,0x57,0x19]
          vxorps (%rcx){1to8}, %ymm20, %ymm27

// CHECK: vxorps 4064(%rdx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x20,0x57,0x5a,0x7f]
          vxorps 4064(%rdx), %ymm20, %ymm27

// CHECK: vxorps 4096(%rdx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x20,0x57,0x9a,0x00,0x10,0x00,0x00]
          vxorps 4096(%rdx), %ymm20, %ymm27

// CHECK: vxorps -4096(%rdx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x20,0x57,0x5a,0x80]
          vxorps -4096(%rdx), %ymm20, %ymm27

// CHECK: vxorps -4128(%rdx), %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x20,0x57,0x9a,0xe0,0xef,0xff,0xff]
          vxorps -4128(%rdx), %ymm20, %ymm27

// CHECK: vxorps 508(%rdx){1to8}, %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x30,0x57,0x5a,0x7f]
          vxorps 508(%rdx){1to8}, %ymm20, %ymm27

// CHECK: vxorps 512(%rdx){1to8}, %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x30,0x57,0x9a,0x00,0x02,0x00,0x00]
          vxorps 512(%rdx){1to8}, %ymm20, %ymm27

// CHECK: vxorps -512(%rdx){1to8}, %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x30,0x57,0x5a,0x80]
          vxorps -512(%rdx){1to8}, %ymm20, %ymm27

// CHECK: vxorps -516(%rdx){1to8}, %ymm20, %ymm27
// CHECK:  encoding: [0x62,0x61,0x5c,0x30,0x57,0x9a,0xfc,0xfd,0xff,0xff]
          vxorps -516(%rdx){1to8}, %ymm20, %ymm27

// CHECK: vandpd %xmm27, %xmm25, %xmm19
// CHECK:  encoding: [0x62,0x81,0xb5,0x00,0x54,0xdb]
          vandpd %xmm27, %xmm25, %xmm19

// CHECK: vandpd %xmm27, %xmm25, %xmm19 {%k6}
// CHECK:  encoding: [0x62,0x81,0xb5,0x06,0x54,0xdb]
          vandpd %xmm27, %xmm25, %xmm19 {%k6}

// CHECK: vandpd %xmm27, %xmm25, %xmm19 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0xb5,0x86,0x54,0xdb]
          vandpd %xmm27, %xmm25, %xmm19 {%k6} {z}

// CHECK: vandpd (%rcx), %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x00,0x54,0x19]
          vandpd (%rcx), %xmm25, %xmm19

// CHECK: vandpd 4660(%rax,%r14,8), %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xa1,0xb5,0x00,0x54,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vandpd 4660(%rax,%r14,8), %xmm25, %xmm19

// CHECK: vandpd (%rcx){1to2}, %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x10,0x54,0x19]
          vandpd (%rcx){1to2}, %xmm25, %xmm19

// CHECK: vandpd 2032(%rdx), %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x00,0x54,0x5a,0x7f]
          vandpd 2032(%rdx), %xmm25, %xmm19

// CHECK: vandpd 2048(%rdx), %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x00,0x54,0x9a,0x00,0x08,0x00,0x00]
          vandpd 2048(%rdx), %xmm25, %xmm19

// CHECK: vandpd -2048(%rdx), %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x00,0x54,0x5a,0x80]
          vandpd -2048(%rdx), %xmm25, %xmm19

// CHECK: vandpd -2064(%rdx), %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x00,0x54,0x9a,0xf0,0xf7,0xff,0xff]
          vandpd -2064(%rdx), %xmm25, %xmm19

// CHECK: vandpd 1016(%rdx){1to2}, %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x10,0x54,0x5a,0x7f]
          vandpd 1016(%rdx){1to2}, %xmm25, %xmm19

// CHECK: vandpd 1024(%rdx){1to2}, %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x10,0x54,0x9a,0x00,0x04,0x00,0x00]
          vandpd 1024(%rdx){1to2}, %xmm25, %xmm19

// CHECK: vandpd -1024(%rdx){1to2}, %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x10,0x54,0x5a,0x80]
          vandpd -1024(%rdx){1to2}, %xmm25, %xmm19

// CHECK: vandpd -1032(%rdx){1to2}, %xmm25, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xb5,0x10,0x54,0x9a,0xf8,0xfb,0xff,0xff]
          vandpd -1032(%rdx){1to2}, %xmm25, %xmm19

// CHECK: vandpd %ymm21, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x54,0xc5]
          vandpd %ymm21, %ymm29, %ymm24

// CHECK: vandpd %ymm21, %ymm29, %ymm24 {%k2}
// CHECK:  encoding: [0x62,0x21,0x95,0x22,0x54,0xc5]
          vandpd %ymm21, %ymm29, %ymm24 {%k2}

// CHECK: vandpd %ymm21, %ymm29, %ymm24 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x95,0xa2,0x54,0xc5]
          vandpd %ymm21, %ymm29, %ymm24 {%k2} {z}

// CHECK: vandpd (%rcx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x54,0x01]
          vandpd (%rcx), %ymm29, %ymm24

// CHECK: vandpd 4660(%rax,%r14,8), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x54,0x84,0xf0,0x34,0x12,0x00,0x00]
          vandpd 4660(%rax,%r14,8), %ymm29, %ymm24

// CHECK: vandpd (%rcx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x54,0x01]
          vandpd (%rcx){1to4}, %ymm29, %ymm24

// CHECK: vandpd 4064(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x54,0x42,0x7f]
          vandpd 4064(%rdx), %ymm29, %ymm24

// CHECK: vandpd 4096(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x54,0x82,0x00,0x10,0x00,0x00]
          vandpd 4096(%rdx), %ymm29, %ymm24

// CHECK: vandpd -4096(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x54,0x42,0x80]
          vandpd -4096(%rdx), %ymm29, %ymm24

// CHECK: vandpd -4128(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x54,0x82,0xe0,0xef,0xff,0xff]
          vandpd -4128(%rdx), %ymm29, %ymm24

// CHECK: vandpd 1016(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x54,0x42,0x7f]
          vandpd 1016(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vandpd 1024(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x54,0x82,0x00,0x04,0x00,0x00]
          vandpd 1024(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vandpd -1024(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x54,0x42,0x80]
          vandpd -1024(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vandpd -1032(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x54,0x82,0xf8,0xfb,0xff,0xff]
          vandpd -1032(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vandps %xmm17, %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xa1,0x34,0x00,0x54,0xf1]
          vandps %xmm17, %xmm25, %xmm22

// CHECK: vandps %xmm17, %xmm25, %xmm22 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x34,0x03,0x54,0xf1]
          vandps %xmm17, %xmm25, %xmm22 {%k3}

// CHECK: vandps %xmm17, %xmm25, %xmm22 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x34,0x83,0x54,0xf1]
          vandps %xmm17, %xmm25, %xmm22 {%k3} {z}

// CHECK: vandps (%rcx), %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x00,0x54,0x31]
          vandps (%rcx), %xmm25, %xmm22

// CHECK: vandps 4660(%rax,%r14,8), %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xa1,0x34,0x00,0x54,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vandps 4660(%rax,%r14,8), %xmm25, %xmm22

// CHECK: vandps (%rcx){1to4}, %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x10,0x54,0x31]
          vandps (%rcx){1to4}, %xmm25, %xmm22

// CHECK: vandps 2032(%rdx), %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x00,0x54,0x72,0x7f]
          vandps 2032(%rdx), %xmm25, %xmm22

// CHECK: vandps 2048(%rdx), %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x00,0x54,0xb2,0x00,0x08,0x00,0x00]
          vandps 2048(%rdx), %xmm25, %xmm22

// CHECK: vandps -2048(%rdx), %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x00,0x54,0x72,0x80]
          vandps -2048(%rdx), %xmm25, %xmm22

// CHECK: vandps -2064(%rdx), %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x00,0x54,0xb2,0xf0,0xf7,0xff,0xff]
          vandps -2064(%rdx), %xmm25, %xmm22

// CHECK: vandps 508(%rdx){1to4}, %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x10,0x54,0x72,0x7f]
          vandps 508(%rdx){1to4}, %xmm25, %xmm22

// CHECK: vandps 512(%rdx){1to4}, %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x10,0x54,0xb2,0x00,0x02,0x00,0x00]
          vandps 512(%rdx){1to4}, %xmm25, %xmm22

// CHECK: vandps -512(%rdx){1to4}, %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x10,0x54,0x72,0x80]
          vandps -512(%rdx){1to4}, %xmm25, %xmm22

// CHECK: vandps -516(%rdx){1to4}, %xmm25, %xmm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x10,0x54,0xb2,0xfc,0xfd,0xff,0xff]
          vandps -516(%rdx){1to4}, %xmm25, %xmm22

// CHECK: vandps %ymm18, %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xa1,0x34,0x20,0x54,0xf2]
          vandps %ymm18, %ymm25, %ymm22

// CHECK: vandps %ymm18, %ymm25, %ymm22 {%k1}
// CHECK:  encoding: [0x62,0xa1,0x34,0x21,0x54,0xf2]
          vandps %ymm18, %ymm25, %ymm22 {%k1}

// CHECK: vandps %ymm18, %ymm25, %ymm22 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0x34,0xa1,0x54,0xf2]
          vandps %ymm18, %ymm25, %ymm22 {%k1} {z}

// CHECK: vandps (%rcx), %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x20,0x54,0x31]
          vandps (%rcx), %ymm25, %ymm22

// CHECK: vandps 4660(%rax,%r14,8), %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xa1,0x34,0x20,0x54,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vandps 4660(%rax,%r14,8), %ymm25, %ymm22

// CHECK: vandps (%rcx){1to8}, %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x30,0x54,0x31]
          vandps (%rcx){1to8}, %ymm25, %ymm22

// CHECK: vandps 4064(%rdx), %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x20,0x54,0x72,0x7f]
          vandps 4064(%rdx), %ymm25, %ymm22

// CHECK: vandps 4096(%rdx), %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x20,0x54,0xb2,0x00,0x10,0x00,0x00]
          vandps 4096(%rdx), %ymm25, %ymm22

// CHECK: vandps -4096(%rdx), %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x20,0x54,0x72,0x80]
          vandps -4096(%rdx), %ymm25, %ymm22

// CHECK: vandps -4128(%rdx), %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x20,0x54,0xb2,0xe0,0xef,0xff,0xff]
          vandps -4128(%rdx), %ymm25, %ymm22

// CHECK: vandps 508(%rdx){1to8}, %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x30,0x54,0x72,0x7f]
          vandps 508(%rdx){1to8}, %ymm25, %ymm22

// CHECK: vandps 512(%rdx){1to8}, %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x30,0x54,0xb2,0x00,0x02,0x00,0x00]
          vandps 512(%rdx){1to8}, %ymm25, %ymm22

// CHECK: vandps -512(%rdx){1to8}, %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x30,0x54,0x72,0x80]
          vandps -512(%rdx){1to8}, %ymm25, %ymm22

// CHECK: vandps -516(%rdx){1to8}, %ymm25, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x34,0x30,0x54,0xb2,0xfc,0xfd,0xff,0xff]
          vandps -516(%rdx){1to8}, %ymm25, %ymm22

// CHECK: vandnpd %xmm23, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xa1,0xed,0x00,0x55,0xdf]
          vandnpd %xmm23, %xmm18, %xmm19

// CHECK: vandnpd %xmm23, %xmm18, %xmm19 {%k1}
// CHECK:  encoding: [0x62,0xa1,0xed,0x01,0x55,0xdf]
          vandnpd %xmm23, %xmm18, %xmm19 {%k1}

// CHECK: vandnpd %xmm23, %xmm18, %xmm19 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0xed,0x81,0x55,0xdf]
          vandnpd %xmm23, %xmm18, %xmm19 {%k1} {z}

// CHECK: vandnpd (%rcx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x55,0x19]
          vandnpd (%rcx), %xmm18, %xmm19

// CHECK: vandnpd 4660(%rax,%r14,8), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xa1,0xed,0x00,0x55,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vandnpd 4660(%rax,%r14,8), %xmm18, %xmm19

// CHECK: vandnpd (%rcx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x55,0x19]
          vandnpd (%rcx){1to2}, %xmm18, %xmm19

// CHECK: vandnpd 2032(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x55,0x5a,0x7f]
          vandnpd 2032(%rdx), %xmm18, %xmm19

// CHECK: vandnpd 2048(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x55,0x9a,0x00,0x08,0x00,0x00]
          vandnpd 2048(%rdx), %xmm18, %xmm19

// CHECK: vandnpd -2048(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x55,0x5a,0x80]
          vandnpd -2048(%rdx), %xmm18, %xmm19

// CHECK: vandnpd -2064(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x55,0x9a,0xf0,0xf7,0xff,0xff]
          vandnpd -2064(%rdx), %xmm18, %xmm19

// CHECK: vandnpd 1016(%rdx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x55,0x5a,0x7f]
          vandnpd 1016(%rdx){1to2}, %xmm18, %xmm19

// CHECK: vandnpd 1024(%rdx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x55,0x9a,0x00,0x04,0x00,0x00]
          vandnpd 1024(%rdx){1to2}, %xmm18, %xmm19

// CHECK: vandnpd -1024(%rdx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x55,0x5a,0x80]
          vandnpd -1024(%rdx){1to2}, %xmm18, %xmm19

// CHECK: vandnpd -1032(%rdx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x55,0x9a,0xf8,0xfb,0xff,0xff]
          vandnpd -1032(%rdx){1to2}, %xmm18, %xmm19

// CHECK: vandnpd %ymm28, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x01,0x95,0x20,0x55,0xcc]
          vandnpd %ymm28, %ymm29, %ymm25

// CHECK: vandnpd %ymm28, %ymm29, %ymm25 {%k7}
// CHECK:  encoding: [0x62,0x01,0x95,0x27,0x55,0xcc]
          vandnpd %ymm28, %ymm29, %ymm25 {%k7}

// CHECK: vandnpd %ymm28, %ymm29, %ymm25 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0x95,0xa7,0x55,0xcc]
          vandnpd %ymm28, %ymm29, %ymm25 {%k7} {z}

// CHECK: vandnpd (%rcx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x55,0x09]
          vandnpd (%rcx), %ymm29, %ymm25

// CHECK: vandnpd 4660(%rax,%r14,8), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x55,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vandnpd 4660(%rax,%r14,8), %ymm29, %ymm25

// CHECK: vandnpd (%rcx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x55,0x09]
          vandnpd (%rcx){1to4}, %ymm29, %ymm25

// CHECK: vandnpd 4064(%rdx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x55,0x4a,0x7f]
          vandnpd 4064(%rdx), %ymm29, %ymm25

// CHECK: vandnpd 4096(%rdx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x55,0x8a,0x00,0x10,0x00,0x00]
          vandnpd 4096(%rdx), %ymm29, %ymm25

// CHECK: vandnpd -4096(%rdx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x55,0x4a,0x80]
          vandnpd -4096(%rdx), %ymm29, %ymm25

// CHECK: vandnpd -4128(%rdx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x55,0x8a,0xe0,0xef,0xff,0xff]
          vandnpd -4128(%rdx), %ymm29, %ymm25

// CHECK: vandnpd 1016(%rdx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x55,0x4a,0x7f]
          vandnpd 1016(%rdx){1to4}, %ymm29, %ymm25

// CHECK: vandnpd 1024(%rdx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x55,0x8a,0x00,0x04,0x00,0x00]
          vandnpd 1024(%rdx){1to4}, %ymm29, %ymm25

// CHECK: vandnpd -1024(%rdx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x55,0x4a,0x80]
          vandnpd -1024(%rdx){1to4}, %ymm29, %ymm25

// CHECK: vandnpd -1032(%rdx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x55,0x8a,0xf8,0xfb,0xff,0xff]
          vandnpd -1032(%rdx){1to4}, %ymm29, %ymm25

// CHECK: vandnps %xmm23, %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x21,0x74,0x00,0x55,0xcf]
          vandnps %xmm23, %xmm17, %xmm25

// CHECK: vandnps %xmm23, %xmm17, %xmm25 {%k5}
// CHECK:  encoding: [0x62,0x21,0x74,0x05,0x55,0xcf]
          vandnps %xmm23, %xmm17, %xmm25 {%k5}

// CHECK: vandnps %xmm23, %xmm17, %xmm25 {%k5} {z}
// CHECK:  encoding: [0x62,0x21,0x74,0x85,0x55,0xcf]
          vandnps %xmm23, %xmm17, %xmm25 {%k5} {z}

// CHECK: vandnps (%rcx), %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x55,0x09]
          vandnps (%rcx), %xmm17, %xmm25

// CHECK: vandnps 4660(%rax,%r14,8), %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x21,0x74,0x00,0x55,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vandnps 4660(%rax,%r14,8), %xmm17, %xmm25

// CHECK: vandnps (%rcx){1to4}, %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x55,0x09]
          vandnps (%rcx){1to4}, %xmm17, %xmm25

// CHECK: vandnps 2032(%rdx), %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x55,0x4a,0x7f]
          vandnps 2032(%rdx), %xmm17, %xmm25

// CHECK: vandnps 2048(%rdx), %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x55,0x8a,0x00,0x08,0x00,0x00]
          vandnps 2048(%rdx), %xmm17, %xmm25

// CHECK: vandnps -2048(%rdx), %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x55,0x4a,0x80]
          vandnps -2048(%rdx), %xmm17, %xmm25

// CHECK: vandnps -2064(%rdx), %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x55,0x8a,0xf0,0xf7,0xff,0xff]
          vandnps -2064(%rdx), %xmm17, %xmm25

// CHECK: vandnps 508(%rdx){1to4}, %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x55,0x4a,0x7f]
          vandnps 508(%rdx){1to4}, %xmm17, %xmm25

// CHECK: vandnps 512(%rdx){1to4}, %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x55,0x8a,0x00,0x02,0x00,0x00]
          vandnps 512(%rdx){1to4}, %xmm17, %xmm25

// CHECK: vandnps -512(%rdx){1to4}, %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x55,0x4a,0x80]
          vandnps -512(%rdx){1to4}, %xmm17, %xmm25

// CHECK: vandnps -516(%rdx){1to4}, %xmm17, %xmm25
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x55,0x8a,0xfc,0xfd,0xff,0xff]
          vandnps -516(%rdx){1to4}, %xmm17, %xmm25

// CHECK: vandnps %ymm23, %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xa1,0x64,0x20,0x55,0xd7]
          vandnps %ymm23, %ymm19, %ymm18

// CHECK: vandnps %ymm23, %ymm19, %ymm18 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x64,0x26,0x55,0xd7]
          vandnps %ymm23, %ymm19, %ymm18 {%k6}

// CHECK: vandnps %ymm23, %ymm19, %ymm18 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x64,0xa6,0x55,0xd7]
          vandnps %ymm23, %ymm19, %ymm18 {%k6} {z}

// CHECK: vandnps (%rcx), %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x20,0x55,0x11]
          vandnps (%rcx), %ymm19, %ymm18

// CHECK: vandnps 4660(%rax,%r14,8), %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xa1,0x64,0x20,0x55,0x94,0xf0,0x34,0x12,0x00,0x00]
          vandnps 4660(%rax,%r14,8), %ymm19, %ymm18

// CHECK: vandnps (%rcx){1to8}, %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x30,0x55,0x11]
          vandnps (%rcx){1to8}, %ymm19, %ymm18

// CHECK: vandnps 4064(%rdx), %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x20,0x55,0x52,0x7f]
          vandnps 4064(%rdx), %ymm19, %ymm18

// CHECK: vandnps 4096(%rdx), %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x20,0x55,0x92,0x00,0x10,0x00,0x00]
          vandnps 4096(%rdx), %ymm19, %ymm18

// CHECK: vandnps -4096(%rdx), %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x20,0x55,0x52,0x80]
          vandnps -4096(%rdx), %ymm19, %ymm18

// CHECK: vandnps -4128(%rdx), %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x20,0x55,0x92,0xe0,0xef,0xff,0xff]
          vandnps -4128(%rdx), %ymm19, %ymm18

// CHECK: vandnps 508(%rdx){1to8}, %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x30,0x55,0x52,0x7f]
          vandnps 508(%rdx){1to8}, %ymm19, %ymm18

// CHECK: vandnps 512(%rdx){1to8}, %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x30,0x55,0x92,0x00,0x02,0x00,0x00]
          vandnps 512(%rdx){1to8}, %ymm19, %ymm18

// CHECK: vandnps -512(%rdx){1to8}, %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x30,0x55,0x52,0x80]
          vandnps -512(%rdx){1to8}, %ymm19, %ymm18

// CHECK: vandnps -516(%rdx){1to8}, %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x64,0x30,0x55,0x92,0xfc,0xfd,0xff,0xff]
          vandnps -516(%rdx){1to8}, %ymm19, %ymm18

// CHECK: vorpd  %xmm18, %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x21,0x95,0x00,0x56,0xd2]
          vorpd  %xmm18, %xmm29, %xmm26

// CHECK: vorpd  %xmm18, %xmm29, %xmm26 {%k2}
// CHECK:  encoding: [0x62,0x21,0x95,0x02,0x56,0xd2]
          vorpd  %xmm18, %xmm29, %xmm26 {%k2}

// CHECK: vorpd  %xmm18, %xmm29, %xmm26 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x95,0x82,0x56,0xd2]
          vorpd  %xmm18, %xmm29, %xmm26 {%k2} {z}

// CHECK: vorpd  (%rcx), %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x00,0x56,0x11]
          vorpd  (%rcx), %xmm29, %xmm26

// CHECK: vorpd  4660(%rax,%r14,8), %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x21,0x95,0x00,0x56,0x94,0xf0,0x34,0x12,0x00,0x00]
          vorpd  4660(%rax,%r14,8), %xmm29, %xmm26

// CHECK: vorpd  (%rcx){1to2}, %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x10,0x56,0x11]
          vorpd  (%rcx){1to2}, %xmm29, %xmm26

// CHECK: vorpd  2032(%rdx), %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x00,0x56,0x52,0x7f]
          vorpd  2032(%rdx), %xmm29, %xmm26

// CHECK: vorpd  2048(%rdx), %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x00,0x56,0x92,0x00,0x08,0x00,0x00]
          vorpd  2048(%rdx), %xmm29, %xmm26

// CHECK: vorpd  -2048(%rdx), %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x00,0x56,0x52,0x80]
          vorpd  -2048(%rdx), %xmm29, %xmm26

// CHECK: vorpd  -2064(%rdx), %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x00,0x56,0x92,0xf0,0xf7,0xff,0xff]
          vorpd  -2064(%rdx), %xmm29, %xmm26

// CHECK: vorpd  1016(%rdx){1to2}, %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x10,0x56,0x52,0x7f]
          vorpd  1016(%rdx){1to2}, %xmm29, %xmm26

// CHECK: vorpd  1024(%rdx){1to2}, %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x10,0x56,0x92,0x00,0x04,0x00,0x00]
          vorpd  1024(%rdx){1to2}, %xmm29, %xmm26

// CHECK: vorpd  -1024(%rdx){1to2}, %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x10,0x56,0x52,0x80]
          vorpd  -1024(%rdx){1to2}, %xmm29, %xmm26

// CHECK: vorpd  -1032(%rdx){1to2}, %xmm29, %xmm26
// CHECK:  encoding: [0x62,0x61,0x95,0x10,0x56,0x92,0xf8,0xfb,0xff,0xff]
          vorpd  -1032(%rdx){1to2}, %xmm29, %xmm26

// CHECK: vorpd  %ymm22, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x21,0xe5,0x20,0x56,0xe6]
          vorpd  %ymm22, %ymm19, %ymm28

// CHECK: vorpd  %ymm22, %ymm19, %ymm28 {%k1}
// CHECK:  encoding: [0x62,0x21,0xe5,0x21,0x56,0xe6]
          vorpd  %ymm22, %ymm19, %ymm28 {%k1}

// CHECK: vorpd  %ymm22, %ymm19, %ymm28 {%k1} {z}
// CHECK:  encoding: [0x62,0x21,0xe5,0xa1,0x56,0xe6]
          vorpd  %ymm22, %ymm19, %ymm28 {%k1} {z}

// CHECK: vorpd  (%rcx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0x56,0x21]
          vorpd  (%rcx), %ymm19, %ymm28

// CHECK: vorpd  4660(%rax,%r14,8), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x21,0xe5,0x20,0x56,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vorpd  4660(%rax,%r14,8), %ymm19, %ymm28

// CHECK: vorpd  (%rcx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0x56,0x21]
          vorpd  (%rcx){1to4}, %ymm19, %ymm28

// CHECK: vorpd  4064(%rdx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0x56,0x62,0x7f]
          vorpd  4064(%rdx), %ymm19, %ymm28

// CHECK: vorpd  4096(%rdx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0x56,0xa2,0x00,0x10,0x00,0x00]
          vorpd  4096(%rdx), %ymm19, %ymm28

// CHECK: vorpd  -4096(%rdx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0x56,0x62,0x80]
          vorpd  -4096(%rdx), %ymm19, %ymm28

// CHECK: vorpd  -4128(%rdx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0x56,0xa2,0xe0,0xef,0xff,0xff]
          vorpd  -4128(%rdx), %ymm19, %ymm28

// CHECK: vorpd  1016(%rdx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0x56,0x62,0x7f]
          vorpd  1016(%rdx){1to4}, %ymm19, %ymm28

// CHECK: vorpd  1024(%rdx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0x56,0xa2,0x00,0x04,0x00,0x00]
          vorpd  1024(%rdx){1to4}, %ymm19, %ymm28

// CHECK: vorpd  -1024(%rdx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0x56,0x62,0x80]
          vorpd  -1024(%rdx){1to4}, %ymm19, %ymm28

// CHECK: vorpd  -1032(%rdx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0x56,0xa2,0xf8,0xfb,0xff,0xff]
          vorpd  -1032(%rdx){1to4}, %ymm19, %ymm28

// CHECK: vorps  %xmm24, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x01,0x4c,0x00,0x56,0xe0]
          vorps  %xmm24, %xmm22, %xmm28

// CHECK: vorps  %xmm24, %xmm22, %xmm28 {%k6}
// CHECK:  encoding: [0x62,0x01,0x4c,0x06,0x56,0xe0]
          vorps  %xmm24, %xmm22, %xmm28 {%k6}

// CHECK: vorps  %xmm24, %xmm22, %xmm28 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0x4c,0x86,0x56,0xe0]
          vorps  %xmm24, %xmm22, %xmm28 {%k6} {z}

// CHECK: vorps  (%rcx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x00,0x56,0x21]
          vorps  (%rcx), %xmm22, %xmm28

// CHECK: vorps  4660(%rax,%r14,8), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x21,0x4c,0x00,0x56,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vorps  4660(%rax,%r14,8), %xmm22, %xmm28

// CHECK: vorps  (%rcx){1to4}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x10,0x56,0x21]
          vorps  (%rcx){1to4}, %xmm22, %xmm28

// CHECK: vorps  2032(%rdx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x00,0x56,0x62,0x7f]
          vorps  2032(%rdx), %xmm22, %xmm28

// CHECK: vorps  2048(%rdx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x00,0x56,0xa2,0x00,0x08,0x00,0x00]
          vorps  2048(%rdx), %xmm22, %xmm28

// CHECK: vorps  -2048(%rdx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x00,0x56,0x62,0x80]
          vorps  -2048(%rdx), %xmm22, %xmm28

// CHECK: vorps  -2064(%rdx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x00,0x56,0xa2,0xf0,0xf7,0xff,0xff]
          vorps  -2064(%rdx), %xmm22, %xmm28

// CHECK: vorps  508(%rdx){1to4}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x10,0x56,0x62,0x7f]
          vorps  508(%rdx){1to4}, %xmm22, %xmm28

// CHECK: vorps  512(%rdx){1to4}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x10,0x56,0xa2,0x00,0x02,0x00,0x00]
          vorps  512(%rdx){1to4}, %xmm22, %xmm28

// CHECK: vorps  -512(%rdx){1to4}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x10,0x56,0x62,0x80]
          vorps  -512(%rdx){1to4}, %xmm22, %xmm28

// CHECK: vorps  -516(%rdx){1to4}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x61,0x4c,0x10,0x56,0xa2,0xfc,0xfd,0xff,0xff]
          vorps  -516(%rdx){1to4}, %xmm22, %xmm28

// CHECK: vorps  %ymm25, %ymm24, %ymm20
// CHECK:  encoding: [0x62,0x81,0x3c,0x20,0x56,0xe1]
          vorps  %ymm25, %ymm24, %ymm20

// CHECK: vorps  %ymm25, %ymm24, %ymm20 {%k1}
// CHECK:  encoding: [0x62,0x81,0x3c,0x21,0x56,0xe1]
          vorps  %ymm25, %ymm24, %ymm20 {%k1}

// CHECK: vorps  %ymm25, %ymm24, %ymm20 {%k1} {z}
// CHECK:  encoding: [0x62,0x81,0x3c,0xa1,0x56,0xe1]
          vorps  %ymm25, %ymm24, %ymm20 {%k1} {z}

// CHECK: vorps  (%rcx), %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x20,0x56,0x21]
          vorps  (%rcx), %ymm24, %ymm20

// CHECK: vorps  4660(%rax,%r14,8), %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xa1,0x3c,0x20,0x56,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vorps  4660(%rax,%r14,8), %ymm24, %ymm20

// CHECK: vorps  (%rcx){1to8}, %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x30,0x56,0x21]
          vorps  (%rcx){1to8}, %ymm24, %ymm20

// CHECK: vorps  4064(%rdx), %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x20,0x56,0x62,0x7f]
          vorps  4064(%rdx), %ymm24, %ymm20

// CHECK: vorps  4096(%rdx), %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x20,0x56,0xa2,0x00,0x10,0x00,0x00]
          vorps  4096(%rdx), %ymm24, %ymm20

// CHECK: vorps  -4096(%rdx), %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x20,0x56,0x62,0x80]
          vorps  -4096(%rdx), %ymm24, %ymm20

// CHECK: vorps  -4128(%rdx), %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x20,0x56,0xa2,0xe0,0xef,0xff,0xff]
          vorps  -4128(%rdx), %ymm24, %ymm20

// CHECK: vorps  508(%rdx){1to8}, %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x30,0x56,0x62,0x7f]
          vorps  508(%rdx){1to8}, %ymm24, %ymm20

// CHECK: vorps  512(%rdx){1to8}, %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x30,0x56,0xa2,0x00,0x02,0x00,0x00]
          vorps  512(%rdx){1to8}, %ymm24, %ymm20

// CHECK: vorps  -512(%rdx){1to8}, %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x30,0x56,0x62,0x80]
          vorps  -512(%rdx){1to8}, %ymm24, %ymm20

// CHECK: vorps  -516(%rdx){1to8}, %ymm24, %ymm20
// CHECK:  encoding: [0x62,0xe1,0x3c,0x30,0x56,0xa2,0xfc,0xfd,0xff,0xff]
          vorps  -516(%rdx){1to8}, %ymm24, %ymm20

// CHECK: vxorpd %xmm18, %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xa1,0xd5,0x00,0x57,0xf2]
          vxorpd %xmm18, %xmm21, %xmm22

// CHECK: vxorpd %xmm18, %xmm21, %xmm22 {%k3}
// CHECK:  encoding: [0x62,0xa1,0xd5,0x03,0x57,0xf2]
          vxorpd %xmm18, %xmm21, %xmm22 {%k3}

// CHECK: vxorpd %xmm18, %xmm21, %xmm22 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0xd5,0x83,0x57,0xf2]
          vxorpd %xmm18, %xmm21, %xmm22 {%k3} {z}

// CHECK: vxorpd (%rcx), %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0x31]
          vxorpd (%rcx), %xmm21, %xmm22

// CHECK: vxorpd 4660(%rax,%r14,8), %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xa1,0xd5,0x00,0x57,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vxorpd 4660(%rax,%r14,8), %xmm21, %xmm22

// CHECK: vxorpd (%rcx){1to2}, %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0x31]
          vxorpd (%rcx){1to2}, %xmm21, %xmm22

// CHECK: vxorpd 2032(%rdx), %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0x72,0x7f]
          vxorpd 2032(%rdx), %xmm21, %xmm22

// CHECK: vxorpd 2048(%rdx), %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0xb2,0x00,0x08,0x00,0x00]
          vxorpd 2048(%rdx), %xmm21, %xmm22

// CHECK: vxorpd -2048(%rdx), %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0x72,0x80]
          vxorpd -2048(%rdx), %xmm21, %xmm22

// CHECK: vxorpd -2064(%rdx), %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x00,0x57,0xb2,0xf0,0xf7,0xff,0xff]
          vxorpd -2064(%rdx), %xmm21, %xmm22

// CHECK: vxorpd 1016(%rdx){1to2}, %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0x72,0x7f]
          vxorpd 1016(%rdx){1to2}, %xmm21, %xmm22

// CHECK: vxorpd 1024(%rdx){1to2}, %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0xb2,0x00,0x04,0x00,0x00]
          vxorpd 1024(%rdx){1to2}, %xmm21, %xmm22

// CHECK: vxorpd -1024(%rdx){1to2}, %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0x72,0x80]
          vxorpd -1024(%rdx){1to2}, %xmm21, %xmm22

// CHECK: vxorpd -1032(%rdx){1to2}, %xmm21, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xd5,0x10,0x57,0xb2,0xf8,0xfb,0xff,0xff]
          vxorpd -1032(%rdx){1to2}, %xmm21, %xmm22

// CHECK: vxorpd %ymm27, %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x01,0xd5,0x20,0x57,0xcb]
          vxorpd %ymm27, %ymm21, %ymm25

// CHECK: vxorpd %ymm27, %ymm21, %ymm25 {%k7}
// CHECK:  encoding: [0x62,0x01,0xd5,0x27,0x57,0xcb]
          vxorpd %ymm27, %ymm21, %ymm25 {%k7}

// CHECK: vxorpd %ymm27, %ymm21, %ymm25 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0xd5,0xa7,0x57,0xcb]
          vxorpd %ymm27, %ymm21, %ymm25 {%k7} {z}

// CHECK: vxorpd (%rcx), %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x57,0x09]
          vxorpd (%rcx), %ymm21, %ymm25

// CHECK: vxorpd 4660(%rax,%r14,8), %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x21,0xd5,0x20,0x57,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vxorpd 4660(%rax,%r14,8), %ymm21, %ymm25

// CHECK: vxorpd (%rcx){1to4}, %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x57,0x09]
          vxorpd (%rcx){1to4}, %ymm21, %ymm25

// CHECK: vxorpd 4064(%rdx), %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x57,0x4a,0x7f]
          vxorpd 4064(%rdx), %ymm21, %ymm25

// CHECK: vxorpd 4096(%rdx), %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x57,0x8a,0x00,0x10,0x00,0x00]
          vxorpd 4096(%rdx), %ymm21, %ymm25

// CHECK: vxorpd -4096(%rdx), %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x57,0x4a,0x80]
          vxorpd -4096(%rdx), %ymm21, %ymm25

// CHECK: vxorpd -4128(%rdx), %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x20,0x57,0x8a,0xe0,0xef,0xff,0xff]
          vxorpd -4128(%rdx), %ymm21, %ymm25

// CHECK: vxorpd 1016(%rdx){1to4}, %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x57,0x4a,0x7f]
          vxorpd 1016(%rdx){1to4}, %ymm21, %ymm25

// CHECK: vxorpd 1024(%rdx){1to4}, %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x57,0x8a,0x00,0x04,0x00,0x00]
          vxorpd 1024(%rdx){1to4}, %ymm21, %ymm25

// CHECK: vxorpd -1024(%rdx){1to4}, %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x57,0x4a,0x80]
          vxorpd -1024(%rdx){1to4}, %ymm21, %ymm25

// CHECK: vxorpd -1032(%rdx){1to4}, %ymm21, %ymm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x30,0x57,0x8a,0xf8,0xfb,0xff,0xff]
          vxorpd -1032(%rdx){1to4}, %ymm21, %ymm25

// CHECK: vxorps %xmm21, %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x54,0x00,0x57,0xcd]
          vxorps %xmm21, %xmm21, %xmm17

// CHECK: vxorps %xmm21, %xmm21, %xmm17 {%k5}
// CHECK:  encoding: [0x62,0xa1,0x54,0x05,0x57,0xcd]
          vxorps %xmm21, %xmm21, %xmm17 {%k5}

// CHECK: vxorps %xmm21, %xmm21, %xmm17 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0x54,0x85,0x57,0xcd]
          vxorps %xmm21, %xmm21, %xmm17 {%k5} {z}

// CHECK: vxorps (%rcx), %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x57,0x09]
          vxorps (%rcx), %xmm21, %xmm17

// CHECK: vxorps 4660(%rax,%r14,8), %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x54,0x00,0x57,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vxorps 4660(%rax,%r14,8), %xmm21, %xmm17

// CHECK: vxorps (%rcx){1to4}, %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x57,0x09]
          vxorps (%rcx){1to4}, %xmm21, %xmm17

// CHECK: vxorps 2032(%rdx), %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x57,0x4a,0x7f]
          vxorps 2032(%rdx), %xmm21, %xmm17

// CHECK: vxorps 2048(%rdx), %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x57,0x8a,0x00,0x08,0x00,0x00]
          vxorps 2048(%rdx), %xmm21, %xmm17

// CHECK: vxorps -2048(%rdx), %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x57,0x4a,0x80]
          vxorps -2048(%rdx), %xmm21, %xmm17

// CHECK: vxorps -2064(%rdx), %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x00,0x57,0x8a,0xf0,0xf7,0xff,0xff]
          vxorps -2064(%rdx), %xmm21, %xmm17

// CHECK: vxorps 508(%rdx){1to4}, %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x57,0x4a,0x7f]
          vxorps 508(%rdx){1to4}, %xmm21, %xmm17

// CHECK: vxorps 512(%rdx){1to4}, %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x57,0x8a,0x00,0x02,0x00,0x00]
          vxorps 512(%rdx){1to4}, %xmm21, %xmm17

// CHECK: vxorps -512(%rdx){1to4}, %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x57,0x4a,0x80]
          vxorps -512(%rdx){1to4}, %xmm21, %xmm17

// CHECK: vxorps -516(%rdx){1to4}, %xmm21, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x10,0x57,0x8a,0xfc,0xfd,0xff,0xff]
          vxorps -516(%rdx){1to4}, %xmm21, %xmm17

// CHECK: vxorps %ymm22, %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x21,0x34,0x20,0x57,0xe6]
          vxorps %ymm22, %ymm25, %ymm28

// CHECK: vxorps %ymm22, %ymm25, %ymm28 {%k3}
// CHECK:  encoding: [0x62,0x21,0x34,0x23,0x57,0xe6]
          vxorps %ymm22, %ymm25, %ymm28 {%k3}

// CHECK: vxorps %ymm22, %ymm25, %ymm28 {%k3} {z}
// CHECK:  encoding: [0x62,0x21,0x34,0xa3,0x57,0xe6]
          vxorps %ymm22, %ymm25, %ymm28 {%k3} {z}

// CHECK: vxorps (%rcx), %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x20,0x57,0x21]
          vxorps (%rcx), %ymm25, %ymm28

// CHECK: vxorps 4660(%rax,%r14,8), %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x21,0x34,0x20,0x57,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vxorps 4660(%rax,%r14,8), %ymm25, %ymm28

// CHECK: vxorps (%rcx){1to8}, %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x30,0x57,0x21]
          vxorps (%rcx){1to8}, %ymm25, %ymm28

// CHECK: vxorps 4064(%rdx), %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x20,0x57,0x62,0x7f]
          vxorps 4064(%rdx), %ymm25, %ymm28

// CHECK: vxorps 4096(%rdx), %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x20,0x57,0xa2,0x00,0x10,0x00,0x00]
          vxorps 4096(%rdx), %ymm25, %ymm28

// CHECK: vxorps -4096(%rdx), %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x20,0x57,0x62,0x80]
          vxorps -4096(%rdx), %ymm25, %ymm28

// CHECK: vxorps -4128(%rdx), %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x20,0x57,0xa2,0xe0,0xef,0xff,0xff]
          vxorps -4128(%rdx), %ymm25, %ymm28

// CHECK: vxorps 508(%rdx){1to8}, %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x30,0x57,0x62,0x7f]
          vxorps 508(%rdx){1to8}, %ymm25, %ymm28

// CHECK: vxorps 512(%rdx){1to8}, %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x30,0x57,0xa2,0x00,0x02,0x00,0x00]
          vxorps 512(%rdx){1to8}, %ymm25, %ymm28

// CHECK: vxorps -512(%rdx){1to8}, %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x30,0x57,0x62,0x80]
          vxorps -512(%rdx){1to8}, %ymm25, %ymm28

// CHECK: vxorps -516(%rdx){1to8}, %ymm25, %ymm28
// CHECK:  encoding: [0x62,0x61,0x34,0x30,0x57,0xa2,0xfc,0xfd,0xff,0xff]
          vxorps -516(%rdx){1to8}, %ymm25, %ymm28

// CHECK: vbroadcastf64x2 (%rcx), %ymm27
// CHECK:  encoding: [0x62,0x62,0xfd,0x28,0x1a,0x19]
          vbroadcastf64x2 (%rcx), %ymm27

// CHECK: vbroadcastf64x2 (%rcx), %ymm27 {%k5}
// CHECK:  encoding: [0x62,0x62,0xfd,0x2d,0x1a,0x19]
          vbroadcastf64x2 (%rcx), %ymm27 {%k5}

// CHECK: vbroadcastf64x2 (%rcx), %ymm27 {%k5} {z}
// CHECK:  encoding: [0x62,0x62,0xfd,0xad,0x1a,0x19]
          vbroadcastf64x2 (%rcx), %ymm27 {%k5} {z}

// CHECK: vbroadcastf64x2 291(%rax,%r14,8), %ymm27
// CHECK:  encoding: [0x62,0x22,0xfd,0x28,0x1a,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastf64x2 291(%rax,%r14,8), %ymm27

// CHECK: vbroadcastf64x2 2032(%rdx), %ymm27
// CHECK:  encoding: [0x62,0x62,0xfd,0x28,0x1a,0x5a,0x7f]
          vbroadcastf64x2 2032(%rdx), %ymm27

// CHECK: vbroadcastf64x2 2048(%rdx), %ymm27
// CHECK:  encoding: [0x62,0x62,0xfd,0x28,0x1a,0x9a,0x00,0x08,0x00,0x00]
          vbroadcastf64x2 2048(%rdx), %ymm27

// CHECK: vbroadcastf64x2 -2048(%rdx), %ymm27
// CHECK:  encoding: [0x62,0x62,0xfd,0x28,0x1a,0x5a,0x80]
          vbroadcastf64x2 -2048(%rdx), %ymm27

// CHECK: vbroadcastf64x2 -2064(%rdx), %ymm27
// CHECK:  encoding: [0x62,0x62,0xfd,0x28,0x1a,0x9a,0xf0,0xf7,0xff,0xff]
          vbroadcastf64x2 -2064(%rdx), %ymm27

// CHECK: vbroadcasti64x2 (%rcx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x5a,0x11]
          vbroadcasti64x2 (%rcx), %ymm18

// CHECK: vbroadcasti64x2 (%rcx), %ymm18 {%k1}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x29,0x5a,0x11]
          vbroadcasti64x2 (%rcx), %ymm18 {%k1}

// CHECK: vbroadcasti64x2 (%rcx), %ymm18 {%k1} {z}
// CHECK:  encoding: [0x62,0xe2,0xfd,0xa9,0x5a,0x11]
          vbroadcasti64x2 (%rcx), %ymm18 {%k1} {z}

// CHECK: vbroadcasti64x2 291(%rax,%r14,8), %ymm18
// CHECK:  encoding: [0x62,0xa2,0xfd,0x28,0x5a,0x94,0xf0,0x23,0x01,0x00,0x00]
          vbroadcasti64x2 291(%rax,%r14,8), %ymm18

// CHECK: vbroadcasti64x2 2032(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x5a,0x52,0x7f]
          vbroadcasti64x2 2032(%rdx), %ymm18

// CHECK: vbroadcasti64x2 2048(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x5a,0x92,0x00,0x08,0x00,0x00]
          vbroadcasti64x2 2048(%rdx), %ymm18

// CHECK: vbroadcasti64x2 -2048(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x5a,0x52,0x80]
          vbroadcasti64x2 -2048(%rdx), %ymm18

// CHECK: vbroadcasti64x2 -2064(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x5a,0x92,0xf0,0xf7,0xff,0xff]
          vbroadcasti64x2 -2064(%rdx), %ymm18

// CHECK: vrangepd $171, %xmm26, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x03,0xa5,0x00,0x50,0xca,0xab]
          vrangepd $0xab, %xmm26, %xmm27, %xmm25

// CHECK: vrangepd $171, %xmm26, %xmm27, %xmm25 {%k6}
// CHECK:  encoding: [0x62,0x03,0xa5,0x06,0x50,0xca,0xab]
          vrangepd $0xab, %xmm26, %xmm27, %xmm25 {%k6}

// CHECK: vrangepd $171, %xmm26, %xmm27, %xmm25 {%k6} {z}
// CHECK:  encoding: [0x62,0x03,0xa5,0x86,0x50,0xca,0xab]
          vrangepd $0xab, %xmm26, %xmm27, %xmm25 {%k6} {z}

// CHECK: vrangepd $123, %xmm26, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x03,0xa5,0x00,0x50,0xca,0x7b]
          vrangepd $0x7b, %xmm26, %xmm27, %xmm25

// CHECK: vrangepd $123, (%rcx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x00,0x50,0x09,0x7b]
          vrangepd $0x7b,(%rcx), %xmm27, %xmm25

// CHECK: vrangepd $123, 291(%rax,%r14,8), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x23,0xa5,0x00,0x50,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrangepd $0x7b,291(%rax,%r14,8), %xmm27, %xmm25

// CHECK: vrangepd $123, (%rcx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x10,0x50,0x09,0x7b]
          vrangepd $0x7b,(%rcx){1to2}, %xmm27, %xmm25

// CHECK: vrangepd $123, 2032(%rdx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x00,0x50,0x4a,0x7f,0x7b]
          vrangepd $0x7b,2032(%rdx), %xmm27, %xmm25

// CHECK: vrangepd $123, 2048(%rdx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x00,0x50,0x8a,0x00,0x08,0x00,0x00,0x7b]
          vrangepd $0x7b,2048(%rdx), %xmm27, %xmm25

// CHECK: vrangepd $123, -2048(%rdx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x00,0x50,0x4a,0x80,0x7b]
          vrangepd $0x7b,-2048(%rdx), %xmm27, %xmm25

// CHECK: vrangepd $123, -2064(%rdx), %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x00,0x50,0x8a,0xf0,0xf7,0xff,0xff,0x7b]
          vrangepd $0x7b,-2064(%rdx), %xmm27, %xmm25

// CHECK: vrangepd $123, 1016(%rdx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x10,0x50,0x4a,0x7f,0x7b]
          vrangepd $0x7b,1016(%rdx){1to2}, %xmm27, %xmm25

// CHECK: vrangepd $123, 1024(%rdx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x10,0x50,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vrangepd $0x7b,1024(%rdx){1to2}, %xmm27, %xmm25

// CHECK: vrangepd $123, -1024(%rdx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x10,0x50,0x4a,0x80,0x7b]
          vrangepd $0x7b,-1024(%rdx){1to2}, %xmm27, %xmm25

// CHECK: vrangepd $123, -1032(%rdx){1to2}, %xmm27, %xmm25
// CHECK:  encoding: [0x62,0x63,0xa5,0x10,0x50,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vrangepd $0x7b,-1032(%rdx){1to2}, %xmm27, %xmm25

// CHECK: vrangepd $171, %ymm28, %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x03,0xa5,0x20,0x50,0xec,0xab]
          vrangepd $0xab, %ymm28, %ymm27, %ymm29

// CHECK: vrangepd $171, %ymm28, %ymm27, %ymm29 {%k7}
// CHECK:  encoding: [0x62,0x03,0xa5,0x27,0x50,0xec,0xab]
          vrangepd $0xab, %ymm28, %ymm27, %ymm29 {%k7}

// CHECK: vrangepd $171, %ymm28, %ymm27, %ymm29 {%k7} {z}
// CHECK:  encoding: [0x62,0x03,0xa5,0xa7,0x50,0xec,0xab]
          vrangepd $0xab, %ymm28, %ymm27, %ymm29 {%k7} {z}

// CHECK: vrangepd $123, %ymm28, %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x03,0xa5,0x20,0x50,0xec,0x7b]
          vrangepd $0x7b, %ymm28, %ymm27, %ymm29

// CHECK: vrangepd $123, (%rcx), %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x20,0x50,0x29,0x7b]
          vrangepd $0x7b,(%rcx), %ymm27, %ymm29

// CHECK: vrangepd $123, 291(%rax,%r14,8), %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x23,0xa5,0x20,0x50,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrangepd $0x7b,291(%rax,%r14,8), %ymm27, %ymm29

// CHECK: vrangepd $123, (%rcx){1to4}, %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x30,0x50,0x29,0x7b]
          vrangepd $0x7b,(%rcx){1to4}, %ymm27, %ymm29

// CHECK: vrangepd $123, 4064(%rdx), %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x20,0x50,0x6a,0x7f,0x7b]
          vrangepd $0x7b,4064(%rdx), %ymm27, %ymm29

// CHECK: vrangepd $123, 4096(%rdx), %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x20,0x50,0xaa,0x00,0x10,0x00,0x00,0x7b]
          vrangepd $0x7b,4096(%rdx), %ymm27, %ymm29

// CHECK: vrangepd $123, -4096(%rdx), %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x20,0x50,0x6a,0x80,0x7b]
          vrangepd $0x7b,-4096(%rdx), %ymm27, %ymm29

// CHECK: vrangepd $123, -4128(%rdx), %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x20,0x50,0xaa,0xe0,0xef,0xff,0xff,0x7b]
          vrangepd $0x7b,-4128(%rdx), %ymm27, %ymm29

// CHECK: vrangepd $123, 1016(%rdx){1to4}, %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x30,0x50,0x6a,0x7f,0x7b]
          vrangepd $0x7b,1016(%rdx){1to4}, %ymm27, %ymm29

// CHECK: vrangepd $123, 1024(%rdx){1to4}, %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x30,0x50,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vrangepd $0x7b,1024(%rdx){1to4}, %ymm27, %ymm29

// CHECK: vrangepd $123, -1024(%rdx){1to4}, %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x30,0x50,0x6a,0x80,0x7b]
          vrangepd $0x7b,-1024(%rdx){1to4}, %ymm27, %ymm29

// CHECK: vrangepd $123, -1032(%rdx){1to4}, %ymm27, %ymm29
// CHECK:  encoding: [0x62,0x63,0xa5,0x30,0x50,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vrangepd $0x7b,-1032(%rdx){1to4}, %ymm27, %ymm29

// CHECK: vrangeps $171, %xmm24, %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x03,0x45,0x00,0x50,0xd8,0xab]
          vrangeps $0xab, %xmm24, %xmm23, %xmm27

// CHECK: vrangeps $171, %xmm24, %xmm23, %xmm27 {%k6}
// CHECK:  encoding: [0x62,0x03,0x45,0x06,0x50,0xd8,0xab]
          vrangeps $0xab, %xmm24, %xmm23, %xmm27 {%k6}

// CHECK: vrangeps $171, %xmm24, %xmm23, %xmm27 {%k6} {z}
// CHECK:  encoding: [0x62,0x03,0x45,0x86,0x50,0xd8,0xab]
          vrangeps $0xab, %xmm24, %xmm23, %xmm27 {%k6} {z}

// CHECK: vrangeps $123, %xmm24, %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x03,0x45,0x00,0x50,0xd8,0x7b]
          vrangeps $0x7b, %xmm24, %xmm23, %xmm27

// CHECK: vrangeps $123, (%rcx), %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x00,0x50,0x19,0x7b]
          vrangeps $0x7b,(%rcx), %xmm23, %xmm27

// CHECK: vrangeps $123, 291(%rax,%r14,8), %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x23,0x45,0x00,0x50,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrangeps $0x7b,291(%rax,%r14,8), %xmm23, %xmm27

// CHECK: vrangeps $123, (%rcx){1to4}, %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x10,0x50,0x19,0x7b]
          vrangeps $0x7b,(%rcx){1to4}, %xmm23, %xmm27

// CHECK: vrangeps $123, 2032(%rdx), %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x00,0x50,0x5a,0x7f,0x7b]
          vrangeps $0x7b,2032(%rdx), %xmm23, %xmm27

// CHECK: vrangeps $123, 2048(%rdx), %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x00,0x50,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vrangeps $0x7b,2048(%rdx), %xmm23, %xmm27

// CHECK: vrangeps $123, -2048(%rdx), %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x00,0x50,0x5a,0x80,0x7b]
          vrangeps $0x7b,-2048(%rdx), %xmm23, %xmm27

// CHECK: vrangeps $123, -2064(%rdx), %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x00,0x50,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vrangeps $0x7b,-2064(%rdx), %xmm23, %xmm27

// CHECK: vrangeps $123, 508(%rdx){1to4}, %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x10,0x50,0x5a,0x7f,0x7b]
          vrangeps $0x7b,508(%rdx){1to4}, %xmm23, %xmm27

// CHECK: vrangeps $123, 512(%rdx){1to4}, %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x10,0x50,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vrangeps $0x7b,512(%rdx){1to4}, %xmm23, %xmm27

// CHECK: vrangeps $123, -512(%rdx){1to4}, %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x10,0x50,0x5a,0x80,0x7b]
          vrangeps $0x7b,-512(%rdx){1to4}, %xmm23, %xmm27

// CHECK: vrangeps $123, -516(%rdx){1to4}, %xmm23, %xmm27
// CHECK:  encoding: [0x62,0x63,0x45,0x10,0x50,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vrangeps $0x7b,-516(%rdx){1to4}, %xmm23, %xmm27

// CHECK: vrangeps $171, %ymm21, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x23,0x45,0x20,0x50,0xc5,0xab]
          vrangeps $0xab, %ymm21, %ymm23, %ymm24

// CHECK: vrangeps $171, %ymm21, %ymm23, %ymm24 {%k7}
// CHECK:  encoding: [0x62,0x23,0x45,0x27,0x50,0xc5,0xab]
          vrangeps $0xab, %ymm21, %ymm23, %ymm24 {%k7}

// CHECK: vrangeps $171, %ymm21, %ymm23, %ymm24 {%k7} {z}
// CHECK:  encoding: [0x62,0x23,0x45,0xa7,0x50,0xc5,0xab]
          vrangeps $0xab, %ymm21, %ymm23, %ymm24 {%k7} {z}

// CHECK: vrangeps $123, %ymm21, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x23,0x45,0x20,0x50,0xc5,0x7b]
          vrangeps $0x7b, %ymm21, %ymm23, %ymm24

// CHECK: vrangeps $123, (%rcx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x20,0x50,0x01,0x7b]
          vrangeps $0x7b,(%rcx), %ymm23, %ymm24

// CHECK: vrangeps $123, 291(%rax,%r14,8), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x23,0x45,0x20,0x50,0x84,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrangeps $0x7b,291(%rax,%r14,8), %ymm23, %ymm24

// CHECK: vrangeps $123, (%rcx){1to8}, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x30,0x50,0x01,0x7b]
          vrangeps $0x7b,(%rcx){1to8}, %ymm23, %ymm24

// CHECK: vrangeps $123, 4064(%rdx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x20,0x50,0x42,0x7f,0x7b]
          vrangeps $0x7b,4064(%rdx), %ymm23, %ymm24

// CHECK: vrangeps $123, 4096(%rdx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x20,0x50,0x82,0x00,0x10,0x00,0x00,0x7b]
          vrangeps $0x7b,4096(%rdx), %ymm23, %ymm24

// CHECK: vrangeps $123, -4096(%rdx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x20,0x50,0x42,0x80,0x7b]
          vrangeps $0x7b,-4096(%rdx), %ymm23, %ymm24

// CHECK: vrangeps $123, -4128(%rdx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x20,0x50,0x82,0xe0,0xef,0xff,0xff,0x7b]
          vrangeps $0x7b,-4128(%rdx), %ymm23, %ymm24

// CHECK: vrangeps $123, 508(%rdx){1to8}, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x30,0x50,0x42,0x7f,0x7b]
          vrangeps $0x7b,508(%rdx){1to8}, %ymm23, %ymm24

// CHECK: vrangeps $123, 512(%rdx){1to8}, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x30,0x50,0x82,0x00,0x02,0x00,0x00,0x7b]
          vrangeps $0x7b,512(%rdx){1to8}, %ymm23, %ymm24

// CHECK: vrangeps $123, -512(%rdx){1to8}, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x30,0x50,0x42,0x80,0x7b]
          vrangeps $0x7b,-512(%rdx){1to8}, %ymm23, %ymm24

// CHECK: vrangeps $123, -516(%rdx){1to8}, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0x45,0x30,0x50,0x82,0xfc,0xfd,0xff,0xff,0x7b]
          vrangeps $0x7b,-516(%rdx){1to8}, %ymm23, %ymm24

// CHECK: vreducepd $171, %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xa3,0xfd,0x08,0x56,0xd1,0xab]
          vreducepd $0xab, %xmm17, %xmm18

// CHECK: vreducepd $171, %xmm17, %xmm18 {%k3}
// CHECK:  encoding: [0x62,0xa3,0xfd,0x0b,0x56,0xd1,0xab]
          vreducepd $0xab, %xmm17, %xmm18 {%k3}

// CHECK: vreducepd $171, %xmm17, %xmm18 {%k3} {z}
// CHECK:  encoding: [0x62,0xa3,0xfd,0x8b,0x56,0xd1,0xab]
          vreducepd $0xab, %xmm17, %xmm18 {%k3} {z}

// CHECK: vreducepd $123, %xmm17, %xmm18
// CHECK:  encoding: [0x62,0xa3,0xfd,0x08,0x56,0xd1,0x7b]
          vreducepd $0x7b, %xmm17, %xmm18

// CHECK: vreducepd $123, (%rcx), %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x56,0x11,0x7b]
          vreducepd $0x7b,(%rcx), %xmm18

// CHECK: vreducepd $123, 291(%rax,%r14,8), %xmm18
// CHECK:  encoding: [0x62,0xa3,0xfd,0x08,0x56,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vreducepd $0x7b,291(%rax,%r14,8), %xmm18

// CHECK: vreducepd $171, %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x03,0xfd,0x08,0x56,0xcc,0xab]
          vreducepd $0xab, %xmm28, %xmm25

// CHECK: vreducepd $171, %xmm28, %xmm25 {%k4}
// CHECK:  encoding: [0x62,0x03,0xfd,0x0c,0x56,0xcc,0xab]
          vreducepd $0xab, %xmm28, %xmm25 {%k4}

// CHECK: vreducepd $171, %xmm28, %xmm25 {%k4} {z}
// CHECK:  encoding: [0x62,0x03,0xfd,0x8c,0x56,0xcc,0xab]
          vreducepd $0xab, %xmm28, %xmm25 {%k4} {z}

// CHECK: vreducepd $123, %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x03,0xfd,0x08,0x56,0xcc,0x7b]
          vreducepd $0x7b, %xmm28, %xmm25

// CHECK: vreducepd $123, (%rcx), %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x56,0x09,0x7b]
          vreducepd $0x7b,(%rcx), %xmm25

// CHECK: vreducepd $123, 4660(%rax,%r14,8), %xmm25
// CHECK:  encoding: [0x62,0x23,0xfd,0x08,0x56,0x8c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vreducepd $0x7b,4660(%rax,%r14,8), %xmm25

// CHECK: vreducepd $123, (%rcx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x18,0x56,0x09,0x7b]
          vreducepd $0x7b,(%rcx){1to2}, %xmm25

// CHECK: vreducepd $123, 2032(%rdx), %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x56,0x4a,0x7f,0x7b]
          vreducepd $0x7b,2032(%rdx), %xmm25

// CHECK: vreducepd $123, 2048(%rdx), %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x56,0x8a,0x00,0x08,0x00,0x00,0x7b]
          vreducepd $0x7b,2048(%rdx), %xmm25

// CHECK: vreducepd $123, -2048(%rdx), %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x56,0x4a,0x80,0x7b]
          vreducepd $0x7b,-2048(%rdx), %xmm25

// CHECK: vreducepd $123, -2064(%rdx), %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x56,0x8a,0xf0,0xf7,0xff,0xff,0x7b]
          vreducepd $0x7b,-2064(%rdx), %xmm25

// CHECK: vreducepd $123, 1016(%rdx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x18,0x56,0x4a,0x7f,0x7b]
          vreducepd $0x7b,1016(%rdx){1to2}, %xmm25

// CHECK: vreducepd $123, 1024(%rdx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x18,0x56,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vreducepd $0x7b,1024(%rdx){1to2}, %xmm25

// CHECK: vreducepd $123, -1024(%rdx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x18,0x56,0x4a,0x80,0x7b]
          vreducepd $0x7b,-1024(%rdx){1to2}, %xmm25

// CHECK: vreducepd $123, -1032(%rdx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x18,0x56,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vreducepd $0x7b,-1032(%rdx){1to2}, %xmm25

// CHECK: vreducepd $171, %ymm17, %ymm28
// CHECK:  encoding: [0x62,0x23,0xfd,0x28,0x56,0xe1,0xab]
          vreducepd $0xab, %ymm17, %ymm28

// CHECK: vreducepd $171, %ymm17, %ymm28 {%k4}
// CHECK:  encoding: [0x62,0x23,0xfd,0x2c,0x56,0xe1,0xab]
          vreducepd $0xab, %ymm17, %ymm28 {%k4}

// CHECK: vreducepd $171, %ymm17, %ymm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x23,0xfd,0xac,0x56,0xe1,0xab]
          vreducepd $0xab, %ymm17, %ymm28 {%k4} {z}

// CHECK: vreducepd $123, %ymm17, %ymm28
// CHECK:  encoding: [0x62,0x23,0xfd,0x28,0x56,0xe1,0x7b]
          vreducepd $0x7b, %ymm17, %ymm28

// CHECK: vreducepd $123, (%rcx), %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0x21,0x7b]
          vreducepd $0x7b,(%rcx), %ymm28

// CHECK: vreducepd $123, 4660(%rax,%r14,8), %ymm28
// CHECK:  encoding: [0x62,0x23,0xfd,0x28,0x56,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vreducepd $0x7b,4660(%rax,%r14,8), %ymm28

// CHECK: vreducepd $123, (%rcx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0x21,0x7b]
          vreducepd $0x7b,(%rcx){1to4}, %ymm28

// CHECK: vreducepd $123, 4064(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0x62,0x7f,0x7b]
          vreducepd $0x7b,4064(%rdx), %ymm28

// CHECK: vreducepd $123, 4096(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vreducepd $0x7b,4096(%rdx), %ymm28

// CHECK: vreducepd $123, -4096(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0x62,0x80,0x7b]
          vreducepd $0x7b,-4096(%rdx), %ymm28

// CHECK: vreducepd $123, -4128(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vreducepd $0x7b,-4128(%rdx), %ymm28

// CHECK: vreducepd $123, 1016(%rdx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0x62,0x7f,0x7b]
          vreducepd $0x7b,1016(%rdx){1to4}, %ymm28

// CHECK: vreducepd $123, 1024(%rdx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0xa2,0x00,0x04,0x00,0x00,0x7b]
          vreducepd $0x7b,1024(%rdx){1to4}, %ymm28

// CHECK: vreducepd $123, -1024(%rdx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0x62,0x80,0x7b]
          vreducepd $0x7b,-1024(%rdx){1to4}, %ymm28

// CHECK: vreducepd $123, -1032(%rdx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          vreducepd $0x7b,-1032(%rdx){1to4}, %ymm28

// CHECK: vreduceps $171, %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x23,0x7d,0x08,0x56,0xed,0xab]
          vreduceps $0xab, %xmm21, %xmm29

// CHECK: vreduceps $171, %xmm21, %xmm29 {%k7}
// CHECK:  encoding: [0x62,0x23,0x7d,0x0f,0x56,0xed,0xab]
          vreduceps $0xab, %xmm21, %xmm29 {%k7}

// CHECK: vreduceps $171, %xmm21, %xmm29 {%k7} {z}
// CHECK:  encoding: [0x62,0x23,0x7d,0x8f,0x56,0xed,0xab]
          vreduceps $0xab, %xmm21, %xmm29 {%k7} {z}

// CHECK: vreduceps $123, %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x23,0x7d,0x08,0x56,0xed,0x7b]
          vreduceps $0x7b, %xmm21, %xmm29

// CHECK: vreduceps $123, (%rcx), %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x56,0x29,0x7b]
          vreduceps $0x7b,(%rcx), %xmm29

// CHECK: vreduceps $123, 4660(%rax,%r14,8), %xmm29
// CHECK:  encoding: [0x62,0x23,0x7d,0x08,0x56,0xac,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vreduceps $0x7b,4660(%rax,%r14,8), %xmm29

// CHECK: vreduceps $123, (%rcx){1to4}, %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x18,0x56,0x29,0x7b]
          vreduceps $0x7b,(%rcx){1to4}, %xmm29

// CHECK: vreduceps $123, 2032(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x56,0x6a,0x7f,0x7b]
          vreduceps $0x7b,2032(%rdx), %xmm29

// CHECK: vreduceps $123, 2048(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x56,0xaa,0x00,0x08,0x00,0x00,0x7b]
          vreduceps $0x7b,2048(%rdx), %xmm29

// CHECK: vreduceps $123, -2048(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x56,0x6a,0x80,0x7b]
          vreduceps $0x7b,-2048(%rdx), %xmm29

// CHECK: vreduceps $123, -2064(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x56,0xaa,0xf0,0xf7,0xff,0xff,0x7b]
          vreduceps $0x7b,-2064(%rdx), %xmm29

// CHECK: vreduceps $123, 508(%rdx){1to4}, %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x18,0x56,0x6a,0x7f,0x7b]
          vreduceps $0x7b,508(%rdx){1to4}, %xmm29

// CHECK: vreduceps $123, 512(%rdx){1to4}, %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x18,0x56,0xaa,0x00,0x02,0x00,0x00,0x7b]
          vreduceps $0x7b,512(%rdx){1to4}, %xmm29

// CHECK: vreduceps $123, -512(%rdx){1to4}, %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x18,0x56,0x6a,0x80,0x7b]
          vreduceps $0x7b,-512(%rdx){1to4}, %xmm29

// CHECK: vreduceps $123, -516(%rdx){1to4}, %xmm29
// CHECK:  encoding: [0x62,0x63,0x7d,0x18,0x56,0xaa,0xfc,0xfd,0xff,0xff,0x7b]
          vreduceps $0x7b,-516(%rdx){1to4}, %xmm29

// CHECK: vreduceps $171, %ymm23, %ymm25
// CHECK:  encoding: [0x62,0x23,0x7d,0x28,0x56,0xcf,0xab]
          vreduceps $0xab, %ymm23, %ymm25

// CHECK: vreduceps $171, %ymm23, %ymm25 {%k3}
// CHECK:  encoding: [0x62,0x23,0x7d,0x2b,0x56,0xcf,0xab]
          vreduceps $0xab, %ymm23, %ymm25 {%k3}

// CHECK: vreduceps $171, %ymm23, %ymm25 {%k3} {z}
// CHECK:  encoding: [0x62,0x23,0x7d,0xab,0x56,0xcf,0xab]
          vreduceps $0xab, %ymm23, %ymm25 {%k3} {z}

// CHECK: vreduceps $123, %ymm23, %ymm25
// CHECK:  encoding: [0x62,0x23,0x7d,0x28,0x56,0xcf,0x7b]
          vreduceps $0x7b, %ymm23, %ymm25

// CHECK: vreduceps $123, (%rcx), %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x09,0x7b]
          vreduceps $0x7b,(%rcx), %ymm25

// CHECK: vreduceps $123, 4660(%rax,%r14,8), %ymm25
// CHECK:  encoding: [0x62,0x23,0x7d,0x28,0x56,0x8c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vreduceps $0x7b,4660(%rax,%r14,8), %ymm25

// CHECK: vreduceps $123, (%rcx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x09,0x7b]
          vreduceps $0x7b,(%rcx){1to8}, %ymm25

// CHECK: vreduceps $123, 4064(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x4a,0x7f,0x7b]
          vreduceps $0x7b,4064(%rdx), %ymm25

// CHECK: vreduceps $123, 4096(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x8a,0x00,0x10,0x00,0x00,0x7b]
          vreduceps $0x7b,4096(%rdx), %ymm25

// CHECK: vreduceps $123, -4096(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x4a,0x80,0x7b]
          vreduceps $0x7b,-4096(%rdx), %ymm25

// CHECK: vreduceps $123, -4128(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x8a,0xe0,0xef,0xff,0xff,0x7b]
          vreduceps $0x7b,-4128(%rdx), %ymm25

// CHECK: vreduceps $123, 508(%rdx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x4a,0x7f,0x7b]
          vreduceps $0x7b,508(%rdx){1to8}, %ymm25

// CHECK: vreduceps $123, 512(%rdx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x8a,0x00,0x02,0x00,0x00,0x7b]
          vreduceps $0x7b,512(%rdx){1to8}, %ymm25

// CHECK: vreduceps $123, -512(%rdx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x4a,0x80,0x7b]
          vreduceps $0x7b,-512(%rdx){1to8}, %ymm25

// CHECK: vreduceps $123, -516(%rdx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x8a,0xfc,0xfd,0xff,0xff,0x7b]
          vreduceps $0x7b,-516(%rdx){1to8}, %ymm25

// CHECK: vreducepd $123, (%rcx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x18,0x56,0x11,0x7b]
          vreducepd $0x7b,(%rcx){1to2}, %xmm18

// CHECK: vreducepd $123, 2032(%rdx), %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x56,0x52,0x7f,0x7b]
          vreducepd $0x7b,2032(%rdx), %xmm18

// CHECK: vreducepd $123, 2048(%rdx), %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x56,0x92,0x00,0x08,0x00,0x00,0x7b]
          vreducepd $0x7b,2048(%rdx), %xmm18

// CHECK: vreducepd $123, -2048(%rdx), %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x56,0x52,0x80,0x7b]
          vreducepd $0x7b,-2048(%rdx), %xmm18

// CHECK: vreducepd $123, -2064(%rdx), %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x56,0x92,0xf0,0xf7,0xff,0xff,0x7b]
          vreducepd $0x7b,-2064(%rdx), %xmm18

// CHECK: vreducepd $123, 1016(%rdx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x18,0x56,0x52,0x7f,0x7b]
          vreducepd $0x7b,1016(%rdx){1to2}, %xmm18

// CHECK: vreducepd $123, 1024(%rdx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x18,0x56,0x92,0x00,0x04,0x00,0x00,0x7b]
          vreducepd $0x7b,1024(%rdx){1to2}, %xmm18

// CHECK: vreducepd $123, -1024(%rdx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x18,0x56,0x52,0x80,0x7b]
          vreducepd $0x7b,-1024(%rdx){1to2}, %xmm18

// CHECK: vreducepd $123, -1032(%rdx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x18,0x56,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vreducepd $0x7b,-1032(%rdx){1to2}, %xmm18

// CHECK: vreducepd $171, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x03,0xfd,0x28,0x56,0xcd,0xab]
          vreducepd $0xab, %ymm29, %ymm25

// CHECK: vreducepd $171, %ymm29, %ymm25 {%k1}
// CHECK:  encoding: [0x62,0x03,0xfd,0x29,0x56,0xcd,0xab]
          vreducepd $0xab, %ymm29, %ymm25 {%k1}

// CHECK: vreducepd $171, %ymm29, %ymm25 {%k1} {z}
// CHECK:  encoding: [0x62,0x03,0xfd,0xa9,0x56,0xcd,0xab]
          vreducepd $0xab, %ymm29, %ymm25 {%k1} {z}

// CHECK: vreducepd $123, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x03,0xfd,0x28,0x56,0xcd,0x7b]
          vreducepd $0x7b, %ymm29, %ymm25

// CHECK: vreducepd $123, (%rcx), %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0x09,0x7b]
          vreducepd $0x7b,(%rcx), %ymm25

// CHECK: vreducepd $123, 291(%rax,%r14,8), %ymm25
// CHECK:  encoding: [0x62,0x23,0xfd,0x28,0x56,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vreducepd $0x7b,291(%rax,%r14,8), %ymm25

// CHECK: vreducepd $123, (%rcx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0x09,0x7b]
          vreducepd $0x7b,(%rcx){1to4}, %ymm25

// CHECK: vreducepd $123, 4064(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0x4a,0x7f,0x7b]
          vreducepd $0x7b,4064(%rdx), %ymm25

// CHECK: vreducepd $123, 4096(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0x8a,0x00,0x10,0x00,0x00,0x7b]
          vreducepd $0x7b,4096(%rdx), %ymm25

// CHECK: vreducepd $123, -4096(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0x4a,0x80,0x7b]
          vreducepd $0x7b,-4096(%rdx), %ymm25

// CHECK: vreducepd $123, -4128(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x28,0x56,0x8a,0xe0,0xef,0xff,0xff,0x7b]
          vreducepd $0x7b,-4128(%rdx), %ymm25

// CHECK: vreducepd $123, 1016(%rdx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0x4a,0x7f,0x7b]
          vreducepd $0x7b,1016(%rdx){1to4}, %ymm25

// CHECK: vreducepd $123, 1024(%rdx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vreducepd $0x7b,1024(%rdx){1to4}, %ymm25

// CHECK: vreducepd $123, -1024(%rdx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0x4a,0x80,0x7b]
          vreducepd $0x7b,-1024(%rdx){1to4}, %ymm25

// CHECK: vreducepd $123, -1032(%rdx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x63,0xfd,0x38,0x56,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vreducepd $0x7b,-1032(%rdx){1to4}, %ymm25

// CHECK: vreduceps $171, %xmm23, %xmm20
// CHECK:  encoding: [0x62,0xa3,0x7d,0x08,0x56,0xe7,0xab]
          vreduceps $0xab, %xmm23, %xmm20

// CHECK: vreduceps $171, %xmm23, %xmm20 {%k7}
// CHECK:  encoding: [0x62,0xa3,0x7d,0x0f,0x56,0xe7,0xab]
          vreduceps $0xab, %xmm23, %xmm20 {%k7}

// CHECK: vreduceps $171, %xmm23, %xmm20 {%k7} {z}
// CHECK:  encoding: [0x62,0xa3,0x7d,0x8f,0x56,0xe7,0xab]
          vreduceps $0xab, %xmm23, %xmm20 {%k7} {z}

// CHECK: vreduceps $123, %xmm23, %xmm20
// CHECK:  encoding: [0x62,0xa3,0x7d,0x08,0x56,0xe7,0x7b]
          vreduceps $0x7b, %xmm23, %xmm20

// CHECK: vreduceps $123, (%rcx), %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x56,0x21,0x7b]
          vreduceps $0x7b,(%rcx), %xmm20

// CHECK: vreduceps $123, 291(%rax,%r14,8), %xmm20
// CHECK:  encoding: [0x62,0xa3,0x7d,0x08,0x56,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vreduceps $0x7b,291(%rax,%r14,8), %xmm20

// CHECK: vreduceps $123, (%rcx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x18,0x56,0x21,0x7b]
          vreduceps $0x7b,(%rcx){1to4}, %xmm20

// CHECK: vreduceps $123, 2032(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x56,0x62,0x7f,0x7b]
          vreduceps $0x7b,2032(%rdx), %xmm20

// CHECK: vreduceps $123, 2048(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x56,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vreduceps $0x7b,2048(%rdx), %xmm20

// CHECK: vreduceps $123, -2048(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x56,0x62,0x80,0x7b]
          vreduceps $0x7b,-2048(%rdx), %xmm20

// CHECK: vreduceps $123, -2064(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x56,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vreduceps $0x7b,-2064(%rdx), %xmm20

// CHECK: vreduceps $123, 508(%rdx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x18,0x56,0x62,0x7f,0x7b]
          vreduceps $0x7b,508(%rdx){1to4}, %xmm20

// CHECK: vreduceps $123, 512(%rdx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x18,0x56,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vreduceps $0x7b,512(%rdx){1to4}, %xmm20

// CHECK: vreduceps $123, -512(%rdx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x18,0x56,0x62,0x80,0x7b]
          vreduceps $0x7b,-512(%rdx){1to4}, %xmm20

// CHECK: vreduceps $123, -516(%rdx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe3,0x7d,0x18,0x56,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vreduceps $0x7b,-516(%rdx){1to4}, %xmm20

// CHECK: vreduceps $171, %ymm22, %ymm26
// CHECK:  encoding: [0x62,0x23,0x7d,0x28,0x56,0xd6,0xab]
          vreduceps $0xab, %ymm22, %ymm26

// CHECK: vreduceps $171, %ymm22, %ymm26 {%k6}
// CHECK:  encoding: [0x62,0x23,0x7d,0x2e,0x56,0xd6,0xab]
          vreduceps $0xab, %ymm22, %ymm26 {%k6}

// CHECK: vreduceps $171, %ymm22, %ymm26 {%k6} {z}
// CHECK:  encoding: [0x62,0x23,0x7d,0xae,0x56,0xd6,0xab]
          vreduceps $0xab, %ymm22, %ymm26 {%k6} {z}

// CHECK: vreduceps $123, %ymm22, %ymm26
// CHECK:  encoding: [0x62,0x23,0x7d,0x28,0x56,0xd6,0x7b]
          vreduceps $0x7b, %ymm22, %ymm26

// CHECK: vreduceps $123, (%rcx), %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x11,0x7b]
          vreduceps $0x7b,(%rcx), %ymm26

// CHECK: vreduceps $123, 291(%rax,%r14,8), %ymm26
// CHECK:  encoding: [0x62,0x23,0x7d,0x28,0x56,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vreduceps $0x7b,291(%rax,%r14,8), %ymm26

// CHECK: vreduceps $123, (%rcx){1to8}, %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x11,0x7b]
          vreduceps $0x7b,(%rcx){1to8}, %ymm26

// CHECK: vreduceps $123, 4064(%rdx), %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x52,0x7f,0x7b]
          vreduceps $0x7b,4064(%rdx), %ymm26

// CHECK: vreduceps $123, 4096(%rdx), %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x92,0x00,0x10,0x00,0x00,0x7b]
          vreduceps $0x7b,4096(%rdx), %ymm26

// CHECK: vreduceps $123, -4096(%rdx), %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x52,0x80,0x7b]
          vreduceps $0x7b,-4096(%rdx), %ymm26

// CHECK: vreduceps $123, -4128(%rdx), %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x28,0x56,0x92,0xe0,0xef,0xff,0xff,0x7b]
          vreduceps $0x7b,-4128(%rdx), %ymm26

// CHECK: vreduceps $123, 508(%rdx){1to8}, %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x52,0x7f,0x7b]
          vreduceps $0x7b,508(%rdx){1to8}, %ymm26

// CHECK: vreduceps $123, 512(%rdx){1to8}, %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x92,0x00,0x02,0x00,0x00,0x7b]
          vreduceps $0x7b,512(%rdx){1to8}, %ymm26

// CHECK: vreduceps $123, -512(%rdx){1to8}, %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x52,0x80,0x7b]
          vreduceps $0x7b,-512(%rdx){1to8}, %ymm26

// CHECK: vreduceps $123, -516(%rdx){1to8}, %ymm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x38,0x56,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vreduceps $0x7b,-516(%rdx){1to8}, %ymm26

// CHECK: vcvtpd2qq %xmm22, %xmm24
// CHECK:  encoding: [0x62,0x21,0xfd,0x08,0x7b,0xc6]
          vcvtpd2qq %xmm22, %xmm24

// CHECK: vcvtpd2qq %xmm22, %xmm24 {%k6}
// CHECK:  encoding: [0x62,0x21,0xfd,0x0e,0x7b,0xc6]
          vcvtpd2qq %xmm22, %xmm24 {%k6}

// CHECK: vcvtpd2qq %xmm22, %xmm24 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0xfd,0x8e,0x7b,0xc6]
          vcvtpd2qq %xmm22, %xmm24 {%k6} {z}

// CHECK: vcvtpd2qq (%rcx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x7b,0x01]
          vcvtpd2qq (%rcx), %xmm24

// CHECK: vcvtpd2qq 291(%rax,%r14,8), %xmm24
// CHECK:  encoding: [0x62,0x21,0xfd,0x08,0x7b,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2qq 291(%rax,%r14,8), %xmm24

// CHECK: vcvtpd2qq (%rcx){1to2}, %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x7b,0x01]
          vcvtpd2qq (%rcx){1to2}, %xmm24

// CHECK: vcvtpd2qq 2032(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x7b,0x42,0x7f]
          vcvtpd2qq 2032(%rdx), %xmm24

// CHECK: vcvtpd2qq 2048(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x7b,0x82,0x00,0x08,0x00,0x00]
          vcvtpd2qq 2048(%rdx), %xmm24

// CHECK: vcvtpd2qq -2048(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x7b,0x42,0x80]
          vcvtpd2qq -2048(%rdx), %xmm24

// CHECK: vcvtpd2qq -2064(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x7b,0x82,0xf0,0xf7,0xff,0xff]
          vcvtpd2qq -2064(%rdx), %xmm24

// CHECK: vcvtpd2qq 1016(%rdx){1to2}, %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x7b,0x42,0x7f]
          vcvtpd2qq 1016(%rdx){1to2}, %xmm24

// CHECK: vcvtpd2qq 1024(%rdx){1to2}, %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x7b,0x82,0x00,0x04,0x00,0x00]
          vcvtpd2qq 1024(%rdx){1to2}, %xmm24

// CHECK: vcvtpd2qq -1024(%rdx){1to2}, %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x7b,0x42,0x80]
          vcvtpd2qq -1024(%rdx){1to2}, %xmm24

// CHECK: vcvtpd2qq -1032(%rdx){1to2}, %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x7b,0x82,0xf8,0xfb,0xff,0xff]
          vcvtpd2qq -1032(%rdx){1to2}, %xmm24

// CHECK: vcvtpd2qq %ymm27, %ymm24
// CHECK:  encoding: [0x62,0x01,0xfd,0x28,0x7b,0xc3]
          vcvtpd2qq %ymm27, %ymm24

// CHECK: vcvtpd2qq %ymm27, %ymm24 {%k7}
// CHECK:  encoding: [0x62,0x01,0xfd,0x2f,0x7b,0xc3]
          vcvtpd2qq %ymm27, %ymm24 {%k7}

// CHECK: vcvtpd2qq %ymm27, %ymm24 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0xfd,0xaf,0x7b,0xc3]
          vcvtpd2qq %ymm27, %ymm24 {%k7} {z}

// CHECK: vcvtpd2qq (%rcx), %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7b,0x01]
          vcvtpd2qq (%rcx), %ymm24

// CHECK: vcvtpd2qq 291(%rax,%r14,8), %ymm24
// CHECK:  encoding: [0x62,0x21,0xfd,0x28,0x7b,0x84,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2qq 291(%rax,%r14,8), %ymm24

// CHECK: vcvtpd2qq (%rcx){1to4}, %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x38,0x7b,0x01]
          vcvtpd2qq (%rcx){1to4}, %ymm24

// CHECK: vcvtpd2qq 4064(%rdx), %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7b,0x42,0x7f]
          vcvtpd2qq 4064(%rdx), %ymm24

// CHECK: vcvtpd2qq 4096(%rdx), %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7b,0x82,0x00,0x10,0x00,0x00]
          vcvtpd2qq 4096(%rdx), %ymm24

// CHECK: vcvtpd2qq -4096(%rdx), %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7b,0x42,0x80]
          vcvtpd2qq -4096(%rdx), %ymm24

// CHECK: vcvtpd2qq -4128(%rdx), %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7b,0x82,0xe0,0xef,0xff,0xff]
          vcvtpd2qq -4128(%rdx), %ymm24

// CHECK: vcvtpd2qq 1016(%rdx){1to4}, %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x38,0x7b,0x42,0x7f]
          vcvtpd2qq 1016(%rdx){1to4}, %ymm24

// CHECK: vcvtpd2qq 1024(%rdx){1to4}, %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x38,0x7b,0x82,0x00,0x04,0x00,0x00]
          vcvtpd2qq 1024(%rdx){1to4}, %ymm24

// CHECK: vcvtpd2qq -1024(%rdx){1to4}, %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x38,0x7b,0x42,0x80]
          vcvtpd2qq -1024(%rdx){1to4}, %ymm24

// CHECK: vcvtpd2qq -1032(%rdx){1to4}, %ymm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x38,0x7b,0x82,0xf8,0xfb,0xff,0xff]
          vcvtpd2qq -1032(%rdx){1to4}, %ymm24

// CHECK: vcvtpd2uqq %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x79,0xf4]
          vcvtpd2uqq %xmm20, %xmm22

// CHECK: vcvtpd2uqq %xmm20, %xmm22 {%k3}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x0b,0x79,0xf4]
          vcvtpd2uqq %xmm20, %xmm22 {%k3}

// CHECK: vcvtpd2uqq %xmm20, %xmm22 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x8b,0x79,0xf4]
          vcvtpd2uqq %xmm20, %xmm22 {%k3} {z}

// CHECK: vcvtpd2uqq (%rcx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x79,0x31]
          vcvtpd2uqq (%rcx), %xmm22

// CHECK: vcvtpd2uqq 291(%rax,%r14,8), %xmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x79,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2uqq 291(%rax,%r14,8), %xmm22

// CHECK: vcvtpd2uqq (%rcx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x18,0x79,0x31]
          vcvtpd2uqq (%rcx){1to2}, %xmm22

// CHECK: vcvtpd2uqq 2032(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x79,0x72,0x7f]
          vcvtpd2uqq 2032(%rdx), %xmm22

// CHECK: vcvtpd2uqq 2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x79,0xb2,0x00,0x08,0x00,0x00]
          vcvtpd2uqq 2048(%rdx), %xmm22

// CHECK: vcvtpd2uqq -2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x79,0x72,0x80]
          vcvtpd2uqq -2048(%rdx), %xmm22

// CHECK: vcvtpd2uqq -2064(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x79,0xb2,0xf0,0xf7,0xff,0xff]
          vcvtpd2uqq -2064(%rdx), %xmm22

// CHECK: vcvtpd2uqq 1016(%rdx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x18,0x79,0x72,0x7f]
          vcvtpd2uqq 1016(%rdx){1to2}, %xmm22

// CHECK: vcvtpd2uqq 1024(%rdx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x18,0x79,0xb2,0x00,0x04,0x00,0x00]
          vcvtpd2uqq 1024(%rdx){1to2}, %xmm22

// CHECK: vcvtpd2uqq -1024(%rdx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x18,0x79,0x72,0x80]
          vcvtpd2uqq -1024(%rdx){1to2}, %xmm22

// CHECK: vcvtpd2uqq -1032(%rdx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x18,0x79,0xb2,0xf8,0xfb,0xff,0xff]
          vcvtpd2uqq -1032(%rdx){1to2}, %xmm22

// CHECK: vcvtpd2uqq %ymm24, %ymm21
// CHECK:  encoding: [0x62,0x81,0xfd,0x28,0x79,0xe8]
          vcvtpd2uqq %ymm24, %ymm21

// CHECK: vcvtpd2uqq %ymm24, %ymm21 {%k6}
// CHECK:  encoding: [0x62,0x81,0xfd,0x2e,0x79,0xe8]
          vcvtpd2uqq %ymm24, %ymm21 {%k6}

// CHECK: vcvtpd2uqq %ymm24, %ymm21 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0xfd,0xae,0x79,0xe8]
          vcvtpd2uqq %ymm24, %ymm21 {%k6} {z}

// CHECK: vcvtpd2uqq (%rcx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x79,0x29]
          vcvtpd2uqq (%rcx), %ymm21

// CHECK: vcvtpd2uqq 291(%rax,%r14,8), %ymm21
// CHECK:  encoding: [0x62,0xa1,0xfd,0x28,0x79,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2uqq 291(%rax,%r14,8), %ymm21

// CHECK: vcvtpd2uqq (%rcx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x79,0x29]
          vcvtpd2uqq (%rcx){1to4}, %ymm21

// CHECK: vcvtpd2uqq 4064(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x79,0x6a,0x7f]
          vcvtpd2uqq 4064(%rdx), %ymm21

// CHECK: vcvtpd2uqq 4096(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x79,0xaa,0x00,0x10,0x00,0x00]
          vcvtpd2uqq 4096(%rdx), %ymm21

// CHECK: vcvtpd2uqq -4096(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x79,0x6a,0x80]
          vcvtpd2uqq -4096(%rdx), %ymm21

// CHECK: vcvtpd2uqq -4128(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x79,0xaa,0xe0,0xef,0xff,0xff]
          vcvtpd2uqq -4128(%rdx), %ymm21

// CHECK: vcvtpd2uqq 1016(%rdx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x79,0x6a,0x7f]
          vcvtpd2uqq 1016(%rdx){1to4}, %ymm21

// CHECK: vcvtpd2uqq 1024(%rdx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x79,0xaa,0x00,0x04,0x00,0x00]
          vcvtpd2uqq 1024(%rdx){1to4}, %ymm21

// CHECK: vcvtpd2uqq -1024(%rdx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x79,0x6a,0x80]
          vcvtpd2uqq -1024(%rdx){1to4}, %ymm21

// CHECK: vcvtpd2uqq -1032(%rdx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x79,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtpd2uqq -1032(%rdx){1to4}, %ymm21

// CHECK: vcvtps2qq %xmm28, %xmm17
// CHECK:  encoding: [0x62,0x81,0x7d,0x08,0x7b,0xcc]
          vcvtps2qq %xmm28, %xmm17

// CHECK: vcvtps2qq %xmm28, %xmm17 {%k4}
// CHECK:  encoding: [0x62,0x81,0x7d,0x0c,0x7b,0xcc]
          vcvtps2qq %xmm28, %xmm17 {%k4}

// CHECK: vcvtps2qq %xmm28, %xmm17 {%k4} {z}
// CHECK:  encoding: [0x62,0x81,0x7d,0x8c,0x7b,0xcc]
          vcvtps2qq %xmm28, %xmm17 {%k4} {z}

// CHECK: vcvtps2qq (%rcx), %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x7b,0x09]
          vcvtps2qq (%rcx), %xmm17

// CHECK: vcvtps2qq 291(%rax,%r14,8), %xmm17
// CHECK:  encoding: [0x62,0xa1,0x7d,0x08,0x7b,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2qq 291(%rax,%r14,8), %xmm17

// CHECK: vcvtps2qq (%rcx){1to2}, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x18,0x7b,0x09]
          vcvtps2qq (%rcx){1to2}, %xmm17

// CHECK: vcvtps2qq 1016(%rdx), %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x7b,0x4a,0x7f]
          vcvtps2qq 1016(%rdx), %xmm17

// CHECK: vcvtps2qq 1024(%rdx), %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x7b,0x8a,0x00,0x04,0x00,0x00]
          vcvtps2qq 1024(%rdx), %xmm17

// CHECK: vcvtps2qq -1024(%rdx), %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x7b,0x4a,0x80]
          vcvtps2qq -1024(%rdx), %xmm17

// CHECK: vcvtps2qq -1032(%rdx), %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x7b,0x8a,0xf8,0xfb,0xff,0xff]
          vcvtps2qq -1032(%rdx), %xmm17

// CHECK: vcvtps2qq 508(%rdx){1to2}, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x18,0x7b,0x4a,0x7f]
          vcvtps2qq 508(%rdx){1to2}, %xmm17

// CHECK: vcvtps2qq 512(%rdx){1to2}, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x18,0x7b,0x8a,0x00,0x02,0x00,0x00]
          vcvtps2qq 512(%rdx){1to2}, %xmm17

// CHECK: vcvtps2qq -512(%rdx){1to2}, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x18,0x7b,0x4a,0x80]
          vcvtps2qq -512(%rdx){1to2}, %xmm17

// CHECK: vcvtps2qq -516(%rdx){1to2}, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x7d,0x18,0x7b,0x8a,0xfc,0xfd,0xff,0xff]
          vcvtps2qq -516(%rdx){1to2}, %xmm17

// CHECK: vcvtps2qq %xmm27, %ymm25
// CHECK:  encoding: [0x62,0x01,0x7d,0x28,0x7b,0xcb]
          vcvtps2qq %xmm27, %ymm25

// CHECK: vcvtps2qq %xmm27, %ymm25 {%k7}
// CHECK:  encoding: [0x62,0x01,0x7d,0x2f,0x7b,0xcb]
          vcvtps2qq %xmm27, %ymm25 {%k7}

// CHECK: vcvtps2qq %xmm27, %ymm25 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0x7d,0xaf,0x7b,0xcb]
          vcvtps2qq %xmm27, %ymm25 {%k7} {z}

// CHECK: vcvtps2qq (%rcx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7b,0x09]
          vcvtps2qq (%rcx), %ymm25

// CHECK: vcvtps2qq 291(%rax,%r14,8), %ymm25
// CHECK:  encoding: [0x62,0x21,0x7d,0x28,0x7b,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2qq 291(%rax,%r14,8), %ymm25

// CHECK: vcvtps2qq (%rcx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x38,0x7b,0x09]
          vcvtps2qq (%rcx){1to4}, %ymm25

// CHECK: vcvtps2qq 2032(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7b,0x4a,0x7f]
          vcvtps2qq 2032(%rdx), %ymm25

// CHECK: vcvtps2qq 2048(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7b,0x8a,0x00,0x08,0x00,0x00]
          vcvtps2qq 2048(%rdx), %ymm25

// CHECK: vcvtps2qq -2048(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7b,0x4a,0x80]
          vcvtps2qq -2048(%rdx), %ymm25

// CHECK: vcvtps2qq -2064(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7b,0x8a,0xf0,0xf7,0xff,0xff]
          vcvtps2qq -2064(%rdx), %ymm25

// CHECK: vcvtps2qq 508(%rdx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x38,0x7b,0x4a,0x7f]
          vcvtps2qq 508(%rdx){1to4}, %ymm25

// CHECK: vcvtps2qq 512(%rdx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x38,0x7b,0x8a,0x00,0x02,0x00,0x00]
          vcvtps2qq 512(%rdx){1to4}, %ymm25

// CHECK: vcvtps2qq -512(%rdx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x38,0x7b,0x4a,0x80]
          vcvtps2qq -512(%rdx){1to4}, %ymm25

// CHECK: vcvtps2qq -516(%rdx){1to4}, %ymm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x38,0x7b,0x8a,0xfc,0xfd,0xff,0xff]
          vcvtps2qq -516(%rdx){1to4}, %ymm25

// CHECK: vcvtps2uqq %xmm29, %xmm29
// CHECK:  encoding: [0x62,0x01,0x7d,0x08,0x79,0xed]
          vcvtps2uqq %xmm29, %xmm29

// CHECK: vcvtps2uqq %xmm29, %xmm29 {%k1}
// CHECK:  encoding: [0x62,0x01,0x7d,0x09,0x79,0xed]
          vcvtps2uqq %xmm29, %xmm29 {%k1}

// CHECK: vcvtps2uqq %xmm29, %xmm29 {%k1} {z}
// CHECK:  encoding: [0x62,0x01,0x7d,0x89,0x79,0xed]
          vcvtps2uqq %xmm29, %xmm29 {%k1} {z}

// CHECK: vcvtps2uqq (%rcx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x79,0x29]
          vcvtps2uqq (%rcx), %xmm29

// CHECK: vcvtps2uqq 291(%rax,%r14,8), %xmm29
// CHECK:  encoding: [0x62,0x21,0x7d,0x08,0x79,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2uqq 291(%rax,%r14,8), %xmm29

// CHECK: vcvtps2uqq (%rcx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x18,0x79,0x29]
          vcvtps2uqq (%rcx){1to2}, %xmm29

// CHECK: vcvtps2uqq 1016(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x79,0x6a,0x7f]
          vcvtps2uqq 1016(%rdx), %xmm29

// CHECK: vcvtps2uqq 1024(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x79,0xaa,0x00,0x04,0x00,0x00]
          vcvtps2uqq 1024(%rdx), %xmm29

// CHECK: vcvtps2uqq -1024(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x79,0x6a,0x80]
          vcvtps2uqq -1024(%rdx), %xmm29

// CHECK: vcvtps2uqq -1032(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x79,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtps2uqq -1032(%rdx), %xmm29

// CHECK: vcvtps2uqq 508(%rdx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x18,0x79,0x6a,0x7f]
          vcvtps2uqq 508(%rdx){1to2}, %xmm29

// CHECK: vcvtps2uqq 512(%rdx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x18,0x79,0xaa,0x00,0x02,0x00,0x00]
          vcvtps2uqq 512(%rdx){1to2}, %xmm29

// CHECK: vcvtps2uqq -512(%rdx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x18,0x79,0x6a,0x80]
          vcvtps2uqq -512(%rdx){1to2}, %xmm29

// CHECK: vcvtps2uqq -516(%rdx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0x7d,0x18,0x79,0xaa,0xfc,0xfd,0xff,0xff]
          vcvtps2uqq -516(%rdx){1to2}, %xmm29

// CHECK: vcvtps2uqq %xmm19, %ymm23
// CHECK:  encoding: [0x62,0xa1,0x7d,0x28,0x79,0xfb]
          vcvtps2uqq %xmm19, %ymm23

// CHECK: vcvtps2uqq %xmm19, %ymm23 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x7d,0x2a,0x79,0xfb]
          vcvtps2uqq %xmm19, %ymm23 {%k2}

// CHECK: vcvtps2uqq %xmm19, %ymm23 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x7d,0xaa,0x79,0xfb]
          vcvtps2uqq %xmm19, %ymm23 {%k2} {z}

// CHECK: vcvtps2uqq (%rcx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0x79,0x39]
          vcvtps2uqq (%rcx), %ymm23

// CHECK: vcvtps2uqq 291(%rax,%r14,8), %ymm23
// CHECK:  encoding: [0x62,0xa1,0x7d,0x28,0x79,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2uqq 291(%rax,%r14,8), %ymm23

// CHECK: vcvtps2uqq (%rcx){1to4}, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x38,0x79,0x39]
          vcvtps2uqq (%rcx){1to4}, %ymm23

// CHECK: vcvtps2uqq 2032(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0x79,0x7a,0x7f]
          vcvtps2uqq 2032(%rdx), %ymm23

// CHECK: vcvtps2uqq 2048(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0x79,0xba,0x00,0x08,0x00,0x00]
          vcvtps2uqq 2048(%rdx), %ymm23

// CHECK: vcvtps2uqq -2048(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0x79,0x7a,0x80]
          vcvtps2uqq -2048(%rdx), %ymm23

// CHECK: vcvtps2uqq -2064(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0x79,0xba,0xf0,0xf7,0xff,0xff]
          vcvtps2uqq -2064(%rdx), %ymm23

// CHECK: vcvtps2uqq 508(%rdx){1to4}, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x38,0x79,0x7a,0x7f]
          vcvtps2uqq 508(%rdx){1to4}, %ymm23

// CHECK: vcvtps2uqq 512(%rdx){1to4}, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x38,0x79,0xba,0x00,0x02,0x00,0x00]
          vcvtps2uqq 512(%rdx){1to4}, %ymm23

// CHECK: vcvtps2uqq -512(%rdx){1to4}, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x38,0x79,0x7a,0x80]
          vcvtps2uqq -512(%rdx){1to4}, %ymm23

// CHECK: vcvtps2uqq -516(%rdx){1to4}, %ymm23
// CHECK:  encoding: [0x62,0xe1,0x7d,0x38,0x79,0xba,0xfc,0xfd,0xff,0xff]
          vcvtps2uqq -516(%rdx){1to4}, %ymm23

// CHECK: vcvtqq2pd %xmm29, %xmm22
// CHECK:  encoding: [0x62,0x81,0xfe,0x08,0xe6,0xf5]
          vcvtqq2pd %xmm29, %xmm22

// CHECK: vcvtqq2pd %xmm29, %xmm22 {%k7}
// CHECK:  encoding: [0x62,0x81,0xfe,0x0f,0xe6,0xf5]
          vcvtqq2pd %xmm29, %xmm22 {%k7}

// CHECK: vcvtqq2pd %xmm29, %xmm22 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0xfe,0x8f,0xe6,0xf5]
          vcvtqq2pd %xmm29, %xmm22 {%k7} {z}

// CHECK: vcvtqq2pd (%rcx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0xe6,0x31]
          vcvtqq2pd (%rcx), %xmm22

// CHECK: vcvtqq2pd 291(%rax,%r14,8), %xmm22
// CHECK:  encoding: [0x62,0xa1,0xfe,0x08,0xe6,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcvtqq2pd 291(%rax,%r14,8), %xmm22

// CHECK: vcvtqq2pd (%rcx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0xe6,0x31]
          vcvtqq2pd (%rcx){1to2}, %xmm22

// CHECK: vcvtqq2pd 2032(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0xe6,0x72,0x7f]
          vcvtqq2pd 2032(%rdx), %xmm22

// CHECK: vcvtqq2pd 2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0xe6,0xb2,0x00,0x08,0x00,0x00]
          vcvtqq2pd 2048(%rdx), %xmm22

// CHECK: vcvtqq2pd -2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0xe6,0x72,0x80]
          vcvtqq2pd -2048(%rdx), %xmm22

// CHECK: vcvtqq2pd -2064(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0xe6,0xb2,0xf0,0xf7,0xff,0xff]
          vcvtqq2pd -2064(%rdx), %xmm22

// CHECK: vcvtqq2pd 1016(%rdx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0xe6,0x72,0x7f]
          vcvtqq2pd 1016(%rdx){1to2}, %xmm22

// CHECK: vcvtqq2pd 1024(%rdx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0xe6,0xb2,0x00,0x04,0x00,0x00]
          vcvtqq2pd 1024(%rdx){1to2}, %xmm22

// CHECK: vcvtqq2pd -1024(%rdx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0xe6,0x72,0x80]
          vcvtqq2pd -1024(%rdx){1to2}, %xmm22

// CHECK: vcvtqq2pd -1032(%rdx){1to2}, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0xe6,0xb2,0xf8,0xfb,0xff,0xff]
          vcvtqq2pd -1032(%rdx){1to2}, %xmm22

// CHECK: vcvtqq2pd %ymm20, %ymm21
// CHECK:  encoding: [0x62,0xa1,0xfe,0x28,0xe6,0xec]
          vcvtqq2pd %ymm20, %ymm21

// CHECK: vcvtqq2pd %ymm20, %ymm21 {%k5}
// CHECK:  encoding: [0x62,0xa1,0xfe,0x2d,0xe6,0xec]
          vcvtqq2pd %ymm20, %ymm21 {%k5}

// CHECK: vcvtqq2pd %ymm20, %ymm21 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0xfe,0xad,0xe6,0xec]
          vcvtqq2pd %ymm20, %ymm21 {%k5} {z}

// CHECK: vcvtqq2pd (%rcx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0xe6,0x29]
          vcvtqq2pd (%rcx), %ymm21

// CHECK: vcvtqq2pd 291(%rax,%r14,8), %ymm21
// CHECK:  encoding: [0x62,0xa1,0xfe,0x28,0xe6,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtqq2pd 291(%rax,%r14,8), %ymm21

// CHECK: vcvtqq2pd (%rcx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x38,0xe6,0x29]
          vcvtqq2pd (%rcx){1to4}, %ymm21

// CHECK: vcvtqq2pd 4064(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0xe6,0x6a,0x7f]
          vcvtqq2pd 4064(%rdx), %ymm21

// CHECK: vcvtqq2pd 4096(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0xe6,0xaa,0x00,0x10,0x00,0x00]
          vcvtqq2pd 4096(%rdx), %ymm21

// CHECK: vcvtqq2pd -4096(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0xe6,0x6a,0x80]
          vcvtqq2pd -4096(%rdx), %ymm21

// CHECK: vcvtqq2pd -4128(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0xe6,0xaa,0xe0,0xef,0xff,0xff]
          vcvtqq2pd -4128(%rdx), %ymm21

// CHECK: vcvtqq2pd 1016(%rdx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x38,0xe6,0x6a,0x7f]
          vcvtqq2pd 1016(%rdx){1to4}, %ymm21

// CHECK: vcvtqq2pd 1024(%rdx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x38,0xe6,0xaa,0x00,0x04,0x00,0x00]
          vcvtqq2pd 1024(%rdx){1to4}, %ymm21

// CHECK: vcvtqq2pd -1024(%rdx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x38,0xe6,0x6a,0x80]
          vcvtqq2pd -1024(%rdx){1to4}, %ymm21

// CHECK: vcvtqq2pd -1032(%rdx){1to4}, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x38,0xe6,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtqq2pd -1032(%rdx){1to4}, %ymm21

// CHECK: vcvtqq2ps %xmm28, %xmm25
// CHECK:  encoding: [0x62,0x01,0xfc,0x08,0x5b,0xcc]
          vcvtqq2ps %xmm28, %xmm25

// CHECK: vcvtqq2ps %xmm28, %xmm25 {%k6}
// CHECK:  encoding: [0x62,0x01,0xfc,0x0e,0x5b,0xcc]
          vcvtqq2ps %xmm28, %xmm25 {%k6}

// CHECK: vcvtqq2ps %xmm28, %xmm25 {%k6} {z}
// CHECK:  encoding: [0x62,0x01,0xfc,0x8e,0x5b,0xcc]
          vcvtqq2ps %xmm28, %xmm25 {%k6} {z}

// CHECK: vcvtqq2psx (%rcx), %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0x09]
          vcvtqq2psx (%rcx), %xmm25

// CHECK: vcvtqq2psx 291(%rax,%r14,8), %xmm25
// CHECK:  encoding: [0x62,0x21,0xfc,0x08,0x5b,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vcvtqq2psx 291(%rax,%r14,8), %xmm25

// CHECK: vcvtqq2ps (%rcx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0x09]
          vcvtqq2ps (%rcx){1to2}, %xmm25

// CHECK: vcvtqq2psx 2032(%rdx), %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0x4a,0x7f]
          vcvtqq2psx 2032(%rdx), %xmm25

// CHECK: vcvtqq2psx 2048(%rdx), %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0x8a,0x00,0x08,0x00,0x00]
          vcvtqq2psx 2048(%rdx), %xmm25

// CHECK: vcvtqq2psx -2048(%rdx), %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0x4a,0x80]
          vcvtqq2psx -2048(%rdx), %xmm25

// CHECK: vcvtqq2psx -2064(%rdx), %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0x8a,0xf0,0xf7,0xff,0xff]
          vcvtqq2psx -2064(%rdx), %xmm25

// CHECK: vcvtqq2ps 1016(%rdx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0x4a,0x7f]
          vcvtqq2ps 1016(%rdx){1to2}, %xmm25

// CHECK: vcvtqq2ps 1024(%rdx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0x8a,0x00,0x04,0x00,0x00]
          vcvtqq2ps 1024(%rdx){1to2}, %xmm25

// CHECK: vcvtqq2ps -1024(%rdx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0x4a,0x80]
          vcvtqq2ps -1024(%rdx){1to2}, %xmm25

// CHECK: vcvtqq2ps -1032(%rdx){1to2}, %xmm25
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0x8a,0xf8,0xfb,0xff,0xff]
          vcvtqq2ps -1032(%rdx){1to2}, %xmm25

// CHECK: vcvtqq2ps %ymm22, %xmm27
// CHECK:  encoding: [0x62,0x21,0xfc,0x28,0x5b,0xde]
          vcvtqq2ps %ymm22, %xmm27

// CHECK: vcvtqq2ps %ymm22, %xmm27 {%k3}
// CHECK:  encoding: [0x62,0x21,0xfc,0x2b,0x5b,0xde]
          vcvtqq2ps %ymm22, %xmm27 {%k3}

// CHECK: vcvtqq2ps %ymm22, %xmm27 {%k3} {z}
// CHECK:  encoding: [0x62,0x21,0xfc,0xab,0x5b,0xde]
          vcvtqq2ps %ymm22, %xmm27 {%k3} {z}

// CHECK: vcvtqq2psy (%rcx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x28,0x5b,0x19]
          vcvtqq2psy (%rcx), %xmm27

// CHECK: vcvtqq2psy 291(%rax,%r14,8), %xmm27
// CHECK:  encoding: [0x62,0x21,0xfc,0x28,0x5b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vcvtqq2psy 291(%rax,%r14,8), %xmm27

// CHECK: vcvtqq2ps (%rcx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x38,0x5b,0x19]
          vcvtqq2ps (%rcx){1to4}, %xmm27

// CHECK: vcvtqq2psy 4064(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x28,0x5b,0x5a,0x7f]
          vcvtqq2psy 4064(%rdx), %xmm27

// CHECK: vcvtqq2psy 4096(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x28,0x5b,0x9a,0x00,0x10,0x00,0x00]
          vcvtqq2psy 4096(%rdx), %xmm27

// CHECK: vcvtqq2psy -4096(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x28,0x5b,0x5a,0x80]
          vcvtqq2psy -4096(%rdx), %xmm27

// CHECK: vcvtqq2psy -4128(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x28,0x5b,0x9a,0xe0,0xef,0xff,0xff]
          vcvtqq2psy -4128(%rdx), %xmm27

// CHECK: vcvtqq2ps 1016(%rdx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x38,0x5b,0x5a,0x7f]
          vcvtqq2ps 1016(%rdx){1to4}, %xmm27

// CHECK: vcvtqq2ps 1024(%rdx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x38,0x5b,0x9a,0x00,0x04,0x00,0x00]
          vcvtqq2ps 1024(%rdx){1to4}, %xmm27

// CHECK: vcvtqq2ps -1024(%rdx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x38,0x5b,0x5a,0x80]
          vcvtqq2ps -1024(%rdx){1to4}, %xmm27

// CHECK: vcvtqq2ps -1032(%rdx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x61,0xfc,0x38,0x5b,0x9a,0xf8,0xfb,0xff,0xff]
          vcvtqq2ps -1032(%rdx){1to4}, %xmm27

// CHECK: vcvtqq2ps %xmm26, %xmm30
// CHECK:  encoding: [0x62,0x01,0xfc,0x08,0x5b,0xf2]
          vcvtqq2ps %xmm26, %xmm30

// CHECK: vcvtqq2ps %xmm26, %xmm30 {%k4}
// CHECK:  encoding: [0x62,0x01,0xfc,0x0c,0x5b,0xf2]
          vcvtqq2ps %xmm26, %xmm30 {%k4}

// CHECK: vcvtqq2ps %xmm26, %xmm30 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0xfc,0x8c,0x5b,0xf2]
          vcvtqq2ps %xmm26, %xmm30 {%k4} {z}

// CHECK: vcvtqq2psx (%rcx), %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0x31]
          vcvtqq2psx (%rcx), %xmm30

// CHECK: vcvtqq2psx 4660(%rax,%r14,8), %xmm30
// CHECK:  encoding: [0x62,0x21,0xfc,0x08,0x5b,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vcvtqq2psx 4660(%rax,%r14,8), %xmm30

// CHECK: vcvtqq2ps (%rcx){1to2}, %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0x31]
          vcvtqq2ps (%rcx){1to2}, %xmm30

// CHECK: vcvtqq2psx 2032(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0x72,0x7f]
          vcvtqq2psx 2032(%rdx), %xmm30

// CHECK: vcvtqq2psx 2048(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0xb2,0x00,0x08,0x00,0x00]
          vcvtqq2psx 2048(%rdx), %xmm30

// CHECK: vcvtqq2psx -2048(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0x72,0x80]
          vcvtqq2psx -2048(%rdx), %xmm30

// CHECK: vcvtqq2psx -2064(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x08,0x5b,0xb2,0xf0,0xf7,0xff,0xff]
          vcvtqq2psx -2064(%rdx), %xmm30

// CHECK: vcvtqq2ps 1016(%rdx){1to2}, %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0x72,0x7f]
          vcvtqq2ps 1016(%rdx){1to2}, %xmm30

// CHECK: vcvtqq2ps 1024(%rdx){1to2}, %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0xb2,0x00,0x04,0x00,0x00]
          vcvtqq2ps 1024(%rdx){1to2}, %xmm30

// CHECK: vcvtqq2ps -1024(%rdx){1to2}, %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0x72,0x80]
          vcvtqq2ps -1024(%rdx){1to2}, %xmm30

// CHECK: vcvtqq2ps -1032(%rdx){1to2}, %xmm30
// CHECK:  encoding: [0x62,0x61,0xfc,0x18,0x5b,0xb2,0xf8,0xfb,0xff,0xff]
          vcvtqq2ps -1032(%rdx){1to2}, %xmm30

// CHECK: vcvtqq2ps %ymm28, %xmm20
// CHECK:  encoding: [0x62,0x81,0xfc,0x28,0x5b,0xe4]
          vcvtqq2ps %ymm28, %xmm20

// CHECK: vcvtqq2ps %ymm28, %xmm20 {%k3}
// CHECK:  encoding: [0x62,0x81,0xfc,0x2b,0x5b,0xe4]
          vcvtqq2ps %ymm28, %xmm20 {%k3}

// CHECK: vcvtqq2ps %ymm28, %xmm20 {%k3} {z}
// CHECK:  encoding: [0x62,0x81,0xfc,0xab,0x5b,0xe4]
          vcvtqq2ps %ymm28, %xmm20 {%k3} {z}

// CHECK: vcvtqq2psy (%rcx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x28,0x5b,0x21]
          vcvtqq2psy (%rcx), %xmm20

// CHECK: vcvtqq2psy 4660(%rax,%r14,8), %xmm20
// CHECK:  encoding: [0x62,0xa1,0xfc,0x28,0x5b,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vcvtqq2psy 4660(%rax,%r14,8), %xmm20

// CHECK: vcvtqq2ps (%rcx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x38,0x5b,0x21]
          vcvtqq2ps (%rcx){1to4}, %xmm20

// CHECK: vcvtqq2psy 4064(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x28,0x5b,0x62,0x7f]
          vcvtqq2psy 4064(%rdx), %xmm20

// CHECK: vcvtqq2psy 4096(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x28,0x5b,0xa2,0x00,0x10,0x00,0x00]
          vcvtqq2psy 4096(%rdx), %xmm20

// CHECK: vcvtqq2psy -4096(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x28,0x5b,0x62,0x80]
          vcvtqq2psy -4096(%rdx), %xmm20

// CHECK: vcvtqq2psy -4128(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x28,0x5b,0xa2,0xe0,0xef,0xff,0xff]
          vcvtqq2psy -4128(%rdx), %xmm20

// CHECK: vcvtqq2ps 1016(%rdx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x38,0x5b,0x62,0x7f]
          vcvtqq2ps 1016(%rdx){1to4}, %xmm20

// CHECK: vcvtqq2ps 1024(%rdx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x38,0x5b,0xa2,0x00,0x04,0x00,0x00]
          vcvtqq2ps 1024(%rdx){1to4}, %xmm20

// CHECK: vcvtqq2ps -1024(%rdx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x38,0x5b,0x62,0x80]
          vcvtqq2ps -1024(%rdx){1to4}, %xmm20

// CHECK: vcvtqq2ps -1032(%rdx){1to4}, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x38,0x5b,0xa2,0xf8,0xfb,0xff,0xff]
          vcvtqq2ps -1032(%rdx){1to4}, %xmm20

// CHECK: vcvtuqq2pd %xmm20, %xmm19
// CHECK:  encoding: [0x62,0xa1,0xfe,0x08,0x7a,0xdc]
          vcvtuqq2pd %xmm20, %xmm19

// CHECK: vcvtuqq2pd %xmm20, %xmm19 {%k3}
// CHECK:  encoding: [0x62,0xa1,0xfe,0x0b,0x7a,0xdc]
          vcvtuqq2pd %xmm20, %xmm19 {%k3}

// CHECK: vcvtuqq2pd %xmm20, %xmm19 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0xfe,0x8b,0x7a,0xdc]
          vcvtuqq2pd %xmm20, %xmm19 {%k3} {z}

// CHECK: vcvtuqq2pd (%rcx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7a,0x19]
          vcvtuqq2pd (%rcx), %xmm19

// CHECK: vcvtuqq2pd 291(%rax,%r14,8), %xmm19
// CHECK:  encoding: [0x62,0xa1,0xfe,0x08,0x7a,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vcvtuqq2pd 291(%rax,%r14,8), %xmm19

// CHECK: vcvtuqq2pd (%rcx){1to2}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0x7a,0x19]
          vcvtuqq2pd (%rcx){1to2}, %xmm19

// CHECK: vcvtuqq2pd 2032(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7a,0x5a,0x7f]
          vcvtuqq2pd 2032(%rdx), %xmm19

// CHECK: vcvtuqq2pd 2048(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7a,0x9a,0x00,0x08,0x00,0x00]
          vcvtuqq2pd 2048(%rdx), %xmm19

// CHECK: vcvtuqq2pd -2048(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7a,0x5a,0x80]
          vcvtuqq2pd -2048(%rdx), %xmm19

// CHECK: vcvtuqq2pd -2064(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7a,0x9a,0xf0,0xf7,0xff,0xff]
          vcvtuqq2pd -2064(%rdx), %xmm19

// CHECK: vcvtuqq2pd 1016(%rdx){1to2}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0x7a,0x5a,0x7f]
          vcvtuqq2pd 1016(%rdx){1to2}, %xmm19

// CHECK: vcvtuqq2pd 1024(%rdx){1to2}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0x7a,0x9a,0x00,0x04,0x00,0x00]
          vcvtuqq2pd 1024(%rdx){1to2}, %xmm19

// CHECK: vcvtuqq2pd -1024(%rdx){1to2}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0x7a,0x5a,0x80]
          vcvtuqq2pd -1024(%rdx){1to2}, %xmm19

// CHECK: vcvtuqq2pd -1032(%rdx){1to2}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xfe,0x18,0x7a,0x9a,0xf8,0xfb,0xff,0xff]
          vcvtuqq2pd -1032(%rdx){1to2}, %xmm19

// CHECK: vcvtuqq2pd %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x01,0xfe,0x28,0x7a,0xe2]
          vcvtuqq2pd %ymm26, %ymm28

// CHECK: vcvtuqq2pd %ymm26, %ymm28 {%k4}
// CHECK:  encoding: [0x62,0x01,0xfe,0x2c,0x7a,0xe2]
          vcvtuqq2pd %ymm26, %ymm28 {%k4}

// CHECK: vcvtuqq2pd %ymm26, %ymm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0xfe,0xac,0x7a,0xe2]
          vcvtuqq2pd %ymm26, %ymm28 {%k4} {z}

// CHECK: vcvtuqq2pd (%rcx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x7a,0x21]
          vcvtuqq2pd (%rcx), %ymm28

// CHECK: vcvtuqq2pd 291(%rax,%r14,8), %ymm28
// CHECK:  encoding: [0x62,0x21,0xfe,0x28,0x7a,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vcvtuqq2pd 291(%rax,%r14,8), %ymm28

// CHECK: vcvtuqq2pd (%rcx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x38,0x7a,0x21]
          vcvtuqq2pd (%rcx){1to4}, %ymm28

// CHECK: vcvtuqq2pd 4064(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x7a,0x62,0x7f]
          vcvtuqq2pd 4064(%rdx), %ymm28

// CHECK: vcvtuqq2pd 4096(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x7a,0xa2,0x00,0x10,0x00,0x00]
          vcvtuqq2pd 4096(%rdx), %ymm28

// CHECK: vcvtuqq2pd -4096(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x7a,0x62,0x80]
          vcvtuqq2pd -4096(%rdx), %ymm28

// CHECK: vcvtuqq2pd -4128(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x7a,0xa2,0xe0,0xef,0xff,0xff]
          vcvtuqq2pd -4128(%rdx), %ymm28

// CHECK: vcvtuqq2pd 1016(%rdx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x38,0x7a,0x62,0x7f]
          vcvtuqq2pd 1016(%rdx){1to4}, %ymm28

// CHECK: vcvtuqq2pd 1024(%rdx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x38,0x7a,0xa2,0x00,0x04,0x00,0x00]
          vcvtuqq2pd 1024(%rdx){1to4}, %ymm28

// CHECK: vcvtuqq2pd -1024(%rdx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x38,0x7a,0x62,0x80]
          vcvtuqq2pd -1024(%rdx){1to4}, %ymm28

// CHECK: vcvtuqq2pd -1032(%rdx){1to4}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfe,0x38,0x7a,0xa2,0xf8,0xfb,0xff,0xff]
          vcvtuqq2pd -1032(%rdx){1to4}, %ymm28

// CHECK: vcvtuqq2ps %xmm27, %xmm21
// CHECK:  encoding: [0x62,0x81,0xff,0x08,0x7a,0xeb]
          vcvtuqq2ps %xmm27, %xmm21

// CHECK: vcvtuqq2ps %xmm27, %xmm21 {%k7}
// CHECK:  encoding: [0x62,0x81,0xff,0x0f,0x7a,0xeb]
          vcvtuqq2ps %xmm27, %xmm21 {%k7}

// CHECK: vcvtuqq2ps %xmm27, %xmm21 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0xff,0x8f,0x7a,0xeb]
          vcvtuqq2ps %xmm27, %xmm21 {%k7} {z}

// CHECK: vcvtuqq2psx (%rcx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0x29]
          vcvtuqq2psx (%rcx), %xmm21

// CHECK: vcvtuqq2psx 291(%rax,%r14,8), %xmm21
// CHECK:  encoding: [0x62,0xa1,0xff,0x08,0x7a,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtuqq2psx 291(%rax,%r14,8), %xmm21

// CHECK: vcvtuqq2ps (%rcx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0x29]
          vcvtuqq2ps (%rcx){1to2}, %xmm21

// CHECK: vcvtuqq2psx 2032(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0x6a,0x7f]
          vcvtuqq2psx 2032(%rdx), %xmm21

// CHECK: vcvtuqq2psx 2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0xaa,0x00,0x08,0x00,0x00]
          vcvtuqq2psx 2048(%rdx), %xmm21

// CHECK: vcvtuqq2psx -2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0x6a,0x80]
          vcvtuqq2psx -2048(%rdx), %xmm21

// CHECK: vcvtuqq2psx -2064(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0xaa,0xf0,0xf7,0xff,0xff]
          vcvtuqq2psx -2064(%rdx), %xmm21

// CHECK: vcvtuqq2ps 1016(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0x6a,0x7f]
          vcvtuqq2ps 1016(%rdx){1to2}, %xmm21

// CHECK: vcvtuqq2ps 1024(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0xaa,0x00,0x04,0x00,0x00]
          vcvtuqq2ps 1024(%rdx){1to2}, %xmm21

// CHECK: vcvtuqq2ps -1024(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0x6a,0x80]
          vcvtuqq2ps -1024(%rdx){1to2}, %xmm21

// CHECK: vcvtuqq2ps -1032(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtuqq2ps -1032(%rdx){1to2}, %xmm21

// CHECK: vcvtuqq2ps %ymm24, %xmm28
// CHECK:  encoding: [0x62,0x01,0xff,0x28,0x7a,0xe0]
          vcvtuqq2ps %ymm24, %xmm28

// CHECK: vcvtuqq2ps %ymm24, %xmm28 {%k3}
// CHECK:  encoding: [0x62,0x01,0xff,0x2b,0x7a,0xe0]
          vcvtuqq2ps %ymm24, %xmm28 {%k3}

// CHECK: vcvtuqq2ps %ymm24, %xmm28 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0xff,0xab,0x7a,0xe0]
          vcvtuqq2ps %ymm24, %xmm28 {%k3} {z}

// CHECK: vcvtuqq2psy (%rcx), %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0x21]
          vcvtuqq2psy (%rcx), %xmm28

// CHECK: vcvtuqq2psy 291(%rax,%r14,8), %xmm28
// CHECK:  encoding: [0x62,0x21,0xff,0x28,0x7a,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vcvtuqq2psy 291(%rax,%r14,8), %xmm28

// CHECK: vcvtuqq2ps (%rcx){1to4}, %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0x21]
          vcvtuqq2ps (%rcx){1to4}, %xmm28

// CHECK: vcvtuqq2psy 4064(%rdx), %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0x62,0x7f]
          vcvtuqq2psy 4064(%rdx), %xmm28

// CHECK: vcvtuqq2psy 4096(%rdx), %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0xa2,0x00,0x10,0x00,0x00]
          vcvtuqq2psy 4096(%rdx), %xmm28

// CHECK: vcvtuqq2psy -4096(%rdx), %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0x62,0x80]
          vcvtuqq2psy -4096(%rdx), %xmm28

// CHECK: vcvtuqq2psy -4128(%rdx), %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0xa2,0xe0,0xef,0xff,0xff]
          vcvtuqq2psy -4128(%rdx), %xmm28

// CHECK: vcvtuqq2ps 1016(%rdx){1to4}, %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0x62,0x7f]
          vcvtuqq2ps 1016(%rdx){1to4}, %xmm28

// CHECK: vcvtuqq2ps 1024(%rdx){1to4}, %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0xa2,0x00,0x04,0x00,0x00]
          vcvtuqq2ps 1024(%rdx){1to4}, %xmm28

// CHECK: vcvtuqq2ps -1024(%rdx){1to4}, %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0x62,0x80]
          vcvtuqq2ps -1024(%rdx){1to4}, %xmm28

// CHECK: vcvtuqq2ps -1032(%rdx){1to4}, %xmm28
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0xa2,0xf8,0xfb,0xff,0xff]
          vcvtuqq2ps -1032(%rdx){1to4}, %xmm28

// CHECK: vcvtuqq2ps %xmm22, %xmm21
// CHECK:  encoding: [0x62,0xa1,0xff,0x08,0x7a,0xee]
          vcvtuqq2ps %xmm22, %xmm21

// CHECK: vcvtuqq2ps %xmm22, %xmm21 {%k6}
// CHECK:  encoding: [0x62,0xa1,0xff,0x0e,0x7a,0xee]
          vcvtuqq2ps %xmm22, %xmm21 {%k6}

// CHECK: vcvtuqq2ps %xmm22, %xmm21 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0xff,0x8e,0x7a,0xee]
          vcvtuqq2ps %xmm22, %xmm21 {%k6} {z}

// CHECK: vcvtuqq2psx (%rcx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0x29]
          vcvtuqq2psx (%rcx), %xmm21

// CHECK: vcvtuqq2psx 4660(%rax,%r14,8), %xmm21
// CHECK:  encoding: [0x62,0xa1,0xff,0x08,0x7a,0xac,0xf0,0x34,0x12,0x00,0x00]
          vcvtuqq2psx 4660(%rax,%r14,8), %xmm21

// CHECK: vcvtuqq2ps (%rcx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0x29]
          vcvtuqq2ps (%rcx){1to2}, %xmm21

// CHECK: vcvtuqq2psx 2032(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0x6a,0x7f]
          vcvtuqq2psx 2032(%rdx), %xmm21

// CHECK: vcvtuqq2psx 2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0xaa,0x00,0x08,0x00,0x00]
          vcvtuqq2psx 2048(%rdx), %xmm21

// CHECK: vcvtuqq2psx -2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0x6a,0x80]
          vcvtuqq2psx -2048(%rdx), %xmm21

// CHECK: vcvtuqq2psx -2064(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x08,0x7a,0xaa,0xf0,0xf7,0xff,0xff]
          vcvtuqq2psx -2064(%rdx), %xmm21

// CHECK: vcvtuqq2ps 1016(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0x6a,0x7f]
          vcvtuqq2ps 1016(%rdx){1to2}, %xmm21

// CHECK: vcvtuqq2ps 1024(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0xaa,0x00,0x04,0x00,0x00]
          vcvtuqq2ps 1024(%rdx){1to2}, %xmm21

// CHECK: vcvtuqq2ps -1024(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0x6a,0x80]
          vcvtuqq2ps -1024(%rdx){1to2}, %xmm21

// CHECK: vcvtuqq2ps -1032(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe1,0xff,0x18,0x7a,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtuqq2ps -1032(%rdx){1to2}, %xmm21

// CHECK: vcvtuqq2ps %ymm17, %xmm26
// CHECK:  encoding: [0x62,0x21,0xff,0x28,0x7a,0xd1]
          vcvtuqq2ps %ymm17, %xmm26

// CHECK: vcvtuqq2ps %ymm17, %xmm26 {%k4}
// CHECK:  encoding: [0x62,0x21,0xff,0x2c,0x7a,0xd1]
          vcvtuqq2ps %ymm17, %xmm26 {%k4}

// CHECK: vcvtuqq2ps %ymm17, %xmm26 {%k4} {z}
// CHECK:  encoding: [0x62,0x21,0xff,0xac,0x7a,0xd1]
          vcvtuqq2ps %ymm17, %xmm26 {%k4} {z}

// CHECK: vcvtuqq2psy (%rcx), %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0x11]
          vcvtuqq2psy (%rcx), %xmm26

// CHECK: vcvtuqq2psy 4660(%rax,%r14,8), %xmm26
// CHECK:  encoding: [0x62,0x21,0xff,0x28,0x7a,0x94,0xf0,0x34,0x12,0x00,0x00]
          vcvtuqq2psy 4660(%rax,%r14,8), %xmm26

// CHECK: vcvtuqq2ps (%rcx){1to4}, %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0x11]
          vcvtuqq2ps (%rcx){1to4}, %xmm26

// CHECK: vcvtuqq2psy 4064(%rdx), %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0x52,0x7f]
          vcvtuqq2psy 4064(%rdx), %xmm26

// CHECK: vcvtuqq2psy 4096(%rdx), %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0x92,0x00,0x10,0x00,0x00]
          vcvtuqq2psy 4096(%rdx), %xmm26

// CHECK: vcvtuqq2psy -4096(%rdx), %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0x52,0x80]
          vcvtuqq2psy -4096(%rdx), %xmm26

// CHECK: vcvtuqq2psy -4128(%rdx), %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x28,0x7a,0x92,0xe0,0xef,0xff,0xff]
          vcvtuqq2psy -4128(%rdx), %xmm26

// CHECK: vcvtuqq2ps 1016(%rdx){1to4}, %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0x52,0x7f]
          vcvtuqq2ps 1016(%rdx){1to4}, %xmm26

// CHECK: vcvtuqq2ps 1024(%rdx){1to4}, %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0x92,0x00,0x04,0x00,0x00]
          vcvtuqq2ps 1024(%rdx){1to4}, %xmm26

// CHECK: vcvtuqq2ps -1024(%rdx){1to4}, %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0x52,0x80]
          vcvtuqq2ps -1024(%rdx){1to4}, %xmm26

// CHECK: vcvtuqq2ps -1032(%rdx){1to4}, %xmm26
// CHECK:  encoding: [0x62,0x61,0xff,0x38,0x7a,0x92,0xf8,0xfb,0xff,0xff]
          vcvtuqq2ps -1032(%rdx){1to4}, %xmm26

// CHECK: vinsertf64x2 $171, %xmm23, %ymm27, %ymm21
// CHECK:  encoding: [0x62,0xa3,0xa5,0x20,0x18,0xef,0xab]
          vinsertf64x2 $0xab, %xmm23, %ymm27, %ymm21

// CHECK: vinsertf64x2 $171, %xmm23, %ymm27, %ymm21 {%k7}
// CHECK:  encoding: [0x62,0xa3,0xa5,0x27,0x18,0xef,0xab]
          vinsertf64x2 $0xab, %xmm23, %ymm27, %ymm21 {%k7}

// CHECK: vinsertf64x2 $171, %xmm23, %ymm27, %ymm21 {%k7} {z}
// CHECK:  encoding: [0x62,0xa3,0xa5,0xa7,0x18,0xef,0xab]
          vinsertf64x2 $0xab, %xmm23, %ymm27, %ymm21 {%k7} {z}

// CHECK: vinsertf64x2 $123, %xmm23, %ymm27, %ymm21
// CHECK:  encoding: [0x62,0xa3,0xa5,0x20,0x18,0xef,0x7b]
          vinsertf64x2 $0x7b, %xmm23, %ymm27, %ymm21

// CHECK: vinsertf64x2 $123, (%rcx), %ymm27, %ymm21
// CHECK:  encoding: [0x62,0xe3,0xa5,0x20,0x18,0x29,0x7b]
          vinsertf64x2 $0x7b,(%rcx), %ymm27, %ymm21

// CHECK: vinsertf64x2 $123, 291(%rax,%r14,8), %ymm27, %ymm21
// CHECK:  encoding: [0x62,0xa3,0xa5,0x20,0x18,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinsertf64x2 $0x7b,291(%rax,%r14,8), %ymm27, %ymm21

// CHECK: vinsertf64x2 $123, 2032(%rdx), %ymm27, %ymm21
// CHECK:  encoding: [0x62,0xe3,0xa5,0x20,0x18,0x6a,0x7f,0x7b]
          vinsertf64x2 $0x7b,2032(%rdx), %ymm27, %ymm21

// CHECK: vinsertf64x2 $123, 2048(%rdx), %ymm27, %ymm21
// CHECK:  encoding: [0x62,0xe3,0xa5,0x20,0x18,0xaa,0x00,0x08,0x00,0x00,0x7b]
          vinsertf64x2 $0x7b,2048(%rdx), %ymm27, %ymm21

// CHECK: vinsertf64x2 $123, -2048(%rdx), %ymm27, %ymm21
// CHECK:  encoding: [0x62,0xe3,0xa5,0x20,0x18,0x6a,0x80,0x7b]
          vinsertf64x2 $0x7b,-2048(%rdx), %ymm27, %ymm21

// CHECK: vinsertf64x2 $123, -2064(%rdx), %ymm27, %ymm21
// CHECK:  encoding: [0x62,0xe3,0xa5,0x20,0x18,0xaa,0xf0,0xf7,0xff,0xff,0x7b]
          vinsertf64x2 $0x7b,-2064(%rdx), %ymm27, %ymm21

// CHECK: vinsertf64x2 $171, %xmm27, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x03,0xc5,0x20,0x18,0xc3,0xab]
          vinsertf64x2 $0xab, %xmm27, %ymm23, %ymm24

// CHECK: vinsertf64x2 $171, %xmm27, %ymm23, %ymm24 {%k5}
// CHECK:  encoding: [0x62,0x03,0xc5,0x25,0x18,0xc3,0xab]
          vinsertf64x2 $0xab, %xmm27, %ymm23, %ymm24 {%k5}

// CHECK: vinsertf64x2 $171, %xmm27, %ymm23, %ymm24 {%k5} {z}
// CHECK:  encoding: [0x62,0x03,0xc5,0xa5,0x18,0xc3,0xab]
          vinsertf64x2 $0xab, %xmm27, %ymm23, %ymm24 {%k5} {z}

// CHECK: vinsertf64x2 $123, %xmm27, %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x03,0xc5,0x20,0x18,0xc3,0x7b]
          vinsertf64x2 $0x7b, %xmm27, %ymm23, %ymm24

// CHECK: vinsertf64x2 $123, (%rcx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0xc5,0x20,0x18,0x01,0x7b]
          vinsertf64x2 $0x7b,(%rcx), %ymm23, %ymm24

// CHECK: vinsertf64x2 $123, 4660(%rax,%r14,8), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x23,0xc5,0x20,0x18,0x84,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vinsertf64x2 $0x7b,4660(%rax,%r14,8), %ymm23, %ymm24

// CHECK: vinsertf64x2 $123, 2032(%rdx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0xc5,0x20,0x18,0x42,0x7f,0x7b]
          vinsertf64x2 $0x7b,2032(%rdx), %ymm23, %ymm24

// CHECK: vinsertf64x2 $123, 2048(%rdx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0xc5,0x20,0x18,0x82,0x00,0x08,0x00,0x00,0x7b]
          vinsertf64x2 $0x7b,2048(%rdx), %ymm23, %ymm24

// CHECK: vinsertf64x2 $123, -2048(%rdx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0xc5,0x20,0x18,0x42,0x80,0x7b]
          vinsertf64x2 $0x7b,-2048(%rdx), %ymm23, %ymm24

// CHECK: vinsertf64x2 $123, -2064(%rdx), %ymm23, %ymm24
// CHECK:  encoding: [0x62,0x63,0xc5,0x20,0x18,0x82,0xf0,0xf7,0xff,0xff,0x7b]
          vinsertf64x2 $0x7b,-2064(%rdx), %ymm23, %ymm24

// CHECK: vinserti64x2 $171, %xmm21, %ymm25, %ymm19
// CHECK:  encoding: [0x62,0xa3,0xb5,0x20,0x38,0xdd,0xab]
          vinserti64x2 $0xab, %xmm21, %ymm25, %ymm19

// CHECK: vinserti64x2 $171, %xmm21, %ymm25, %ymm19 {%k6}
// CHECK:  encoding: [0x62,0xa3,0xb5,0x26,0x38,0xdd,0xab]
          vinserti64x2 $0xab, %xmm21, %ymm25, %ymm19 {%k6}

// CHECK: vinserti64x2 $171, %xmm21, %ymm25, %ymm19 {%k6} {z}
// CHECK:  encoding: [0x62,0xa3,0xb5,0xa6,0x38,0xdd,0xab]
          vinserti64x2 $0xab, %xmm21, %ymm25, %ymm19 {%k6} {z}

// CHECK: vinserti64x2 $123, %xmm21, %ymm25, %ymm19
// CHECK:  encoding: [0x62,0xa3,0xb5,0x20,0x38,0xdd,0x7b]
          vinserti64x2 $0x7b, %xmm21, %ymm25, %ymm19

// CHECK: vinserti64x2 $123, (%rcx), %ymm25, %ymm19
// CHECK:  encoding: [0x62,0xe3,0xb5,0x20,0x38,0x19,0x7b]
          vinserti64x2 $0x7b,(%rcx), %ymm25, %ymm19

// CHECK: vinserti64x2 $123, 291(%rax,%r14,8), %ymm25, %ymm19
// CHECK:  encoding: [0x62,0xa3,0xb5,0x20,0x38,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinserti64x2 $0x7b,291(%rax,%r14,8), %ymm25, %ymm19

// CHECK: vinserti64x2 $123, 2032(%rdx), %ymm25, %ymm19
// CHECK:  encoding: [0x62,0xe3,0xb5,0x20,0x38,0x5a,0x7f,0x7b]
          vinserti64x2 $0x7b,2032(%rdx), %ymm25, %ymm19

// CHECK: vinserti64x2 $123, 2048(%rdx), %ymm25, %ymm19
// CHECK:  encoding: [0x62,0xe3,0xb5,0x20,0x38,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vinserti64x2 $0x7b,2048(%rdx), %ymm25, %ymm19

// CHECK: vinserti64x2 $123, -2048(%rdx), %ymm25, %ymm19
// CHECK:  encoding: [0x62,0xe3,0xb5,0x20,0x38,0x5a,0x80,0x7b]
          vinserti64x2 $0x7b,-2048(%rdx), %ymm25, %ymm19

// CHECK: vinserti64x2 $123, -2064(%rdx), %ymm25, %ymm19
// CHECK:  encoding: [0x62,0xe3,0xb5,0x20,0x38,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vinserti64x2 $0x7b,-2064(%rdx), %ymm25, %ymm19

// CHECK: vinserti64x2 $171, %xmm25, %ymm24, %ymm29
// CHECK:  encoding: [0x62,0x03,0xbd,0x20,0x38,0xe9,0xab]
          vinserti64x2 $0xab, %xmm25, %ymm24, %ymm29

// CHECK: vinserti64x2 $171, %xmm25, %ymm24, %ymm29 {%k2}
// CHECK:  encoding: [0x62,0x03,0xbd,0x22,0x38,0xe9,0xab]
          vinserti64x2 $0xab, %xmm25, %ymm24, %ymm29 {%k2}

// CHECK: vinserti64x2 $171, %xmm25, %ymm24, %ymm29 {%k2} {z}
// CHECK:  encoding: [0x62,0x03,0xbd,0xa2,0x38,0xe9,0xab]
          vinserti64x2 $0xab, %xmm25, %ymm24, %ymm29 {%k2} {z}

// CHECK: vinserti64x2 $123, %xmm25, %ymm24, %ymm29
// CHECK:  encoding: [0x62,0x03,0xbd,0x20,0x38,0xe9,0x7b]
          vinserti64x2 $0x7b, %xmm25, %ymm24, %ymm29

// CHECK: vinserti64x2 $123, (%rcx), %ymm24, %ymm29
// CHECK:  encoding: [0x62,0x63,0xbd,0x20,0x38,0x29,0x7b]
          vinserti64x2 $0x7b,(%rcx), %ymm24, %ymm29

// CHECK: vinserti64x2 $123, 4660(%rax,%r14,8), %ymm24, %ymm29
// CHECK:  encoding: [0x62,0x23,0xbd,0x20,0x38,0xac,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vinserti64x2 $0x7b,4660(%rax,%r14,8), %ymm24, %ymm29

// CHECK: vinserti64x2 $123, 2032(%rdx), %ymm24, %ymm29
// CHECK:  encoding: [0x62,0x63,0xbd,0x20,0x38,0x6a,0x7f,0x7b]
          vinserti64x2 $0x7b,2032(%rdx), %ymm24, %ymm29

// CHECK: vinserti64x2 $123, 2048(%rdx), %ymm24, %ymm29
// CHECK:  encoding: [0x62,0x63,0xbd,0x20,0x38,0xaa,0x00,0x08,0x00,0x00,0x7b]
          vinserti64x2 $0x7b,2048(%rdx), %ymm24, %ymm29

// CHECK: vinserti64x2 $123, -2048(%rdx), %ymm24, %ymm29
// CHECK:  encoding: [0x62,0x63,0xbd,0x20,0x38,0x6a,0x80,0x7b]
          vinserti64x2 $0x7b,-2048(%rdx), %ymm24, %ymm29

// CHECK: vinserti64x2 $123, -2064(%rdx), %ymm24, %ymm29
// CHECK:  encoding: [0x62,0x63,0xbd,0x20,0x38,0xaa,0xf0,0xf7,0xff,0xff,0x7b]
          vinserti64x2 $0x7b,-2064(%rdx), %ymm24, %ymm29

// CHECK: vextractf64x2 $171, %ymm21, %xmm27
// CHECK:  encoding: [0x62,0x83,0xfd,0x28,0x19,0xeb,0xab]
          vextractf64x2 $0xab, %ymm21, %xmm27

// CHECK: vextractf64x2 $171, %ymm21, %xmm27 {%k7}
// CHECK:  encoding: [0x62,0x83,0xfd,0x2f,0x19,0xeb,0xab]
          vextractf64x2 $0xab, %ymm21, %xmm27 {%k7}

// CHECK: vextractf64x2 $171, %ymm21, %xmm27 {%k7} {z}
// CHECK:  encoding: [0x62,0x83,0xfd,0xaf,0x19,0xeb,0xab]
          vextractf64x2 $0xab, %ymm21, %xmm27 {%k7} {z}

// CHECK: vextractf64x2 $123, %ymm21, %xmm27
// CHECK:  encoding: [0x62,0x83,0xfd,0x28,0x19,0xeb,0x7b]
          vextractf64x2 $0x7b, %ymm21, %xmm27

// CHECK: vextractf64x2 $171, %ymm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x21,0xab]
          vextractf64x2 $0xab, %ymm20,(%rcx)

// CHECK: vextractf64x2 $171, %ymm20, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0xe3,0xfd,0x29,0x19,0x21,0xab]
          vextractf64x2 $0xab, %ymm20,(%rcx) {%k1}

// CHECK: vextractf64x2 $123, %ymm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x21,0x7b]
          vextractf64x2 $0x7b, %ymm20,(%rcx)

// CHECK: vextractf64x2 $123, %ymm20, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0xfd,0x28,0x19,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextractf64x2 $0x7b, %ymm20,291(%rax,%r14,8)

// CHECK: vextractf64x2 $123, %ymm20, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x62,0x7f,0x7b]
          vextractf64x2 $0x7b, %ymm20,2032(%rdx)

// CHECK: vextractf64x2 $123, %ymm20, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vextractf64x2 $0x7b, %ymm20,2048(%rdx)

// CHECK: vextractf64x2 $123, %ymm20, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x62,0x80,0x7b]
          vextractf64x2 $0x7b, %ymm20,-2048(%rdx)

// CHECK: vextractf64x2 $123, %ymm20, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vextractf64x2 $0x7b, %ymm20,-2064(%rdx)

// CHECK: vextractf64x2 $171, %ymm26, %xmm28
// CHECK:  encoding: [0x62,0x03,0xfd,0x28,0x19,0xd4,0xab]
          vextractf64x2 $0xab, %ymm26, %xmm28

// CHECK: vextractf64x2 $171, %ymm26, %xmm28 {%k4}
// CHECK:  encoding: [0x62,0x03,0xfd,0x2c,0x19,0xd4,0xab]
          vextractf64x2 $0xab, %ymm26, %xmm28 {%k4}

// CHECK: vextractf64x2 $171, %ymm26, %xmm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x03,0xfd,0xac,0x19,0xd4,0xab]
          vextractf64x2 $0xab, %ymm26, %xmm28 {%k4} {z}

// CHECK: vextractf64x2 $123, %ymm26, %xmm28
// CHECK:  encoding: [0x62,0x03,0xfd,0x28,0x19,0xd4,0x7b]
          vextractf64x2 $0x7b, %ymm26, %xmm28

// CHECK: vextractf64x2 $171, %ymm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x09,0xab]
          vextractf64x2 $0xab, %ymm17,(%rcx)

// CHECK: vextractf64x2 $171, %ymm17, (%rcx) {%k2}
// CHECK:  encoding: [0x62,0xe3,0xfd,0x2a,0x19,0x09,0xab]
          vextractf64x2 $0xab, %ymm17,(%rcx) {%k2}

// CHECK: vextractf64x2 $123, %ymm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x09,0x7b]
          vextractf64x2 $0x7b, %ymm17,(%rcx)

// CHECK: vextractf64x2 $123, %ymm17, 4660(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0xfd,0x28,0x19,0x8c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vextractf64x2 $0x7b, %ymm17,4660(%rax,%r14,8)

// CHECK: vextractf64x2 $123, %ymm17, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x4a,0x7f,0x7b]
          vextractf64x2 $0x7b, %ymm17,2032(%rdx)

// CHECK: vextractf64x2 $123, %ymm17, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x8a,0x00,0x08,0x00,0x00,0x7b]
          vextractf64x2 $0x7b, %ymm17,2048(%rdx)

// CHECK: vextractf64x2 $123, %ymm17, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x4a,0x80,0x7b]
          vextractf64x2 $0x7b, %ymm17,-2048(%rdx)

// CHECK: vextractf64x2 $123, %ymm17, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x19,0x8a,0xf0,0xf7,0xff,0xff,0x7b]
          vextractf64x2 $0x7b, %ymm17,-2064(%rdx)

// CHECK: vextracti64x2 $171, %ymm24, %xmm29
// CHECK:  encoding: [0x62,0x03,0xfd,0x28,0x39,0xc5,0xab]
          vextracti64x2 $0xab, %ymm24, %xmm29

// CHECK: vextracti64x2 $171, %ymm24, %xmm29 {%k7}
// CHECK:  encoding: [0x62,0x03,0xfd,0x2f,0x39,0xc5,0xab]
          vextracti64x2 $0xab, %ymm24, %xmm29 {%k7}

// CHECK: vextracti64x2 $171, %ymm24, %xmm29 {%k7} {z}
// CHECK:  encoding: [0x62,0x03,0xfd,0xaf,0x39,0xc5,0xab]
          vextracti64x2 $0xab, %ymm24, %xmm29 {%k7} {z}

// CHECK: vextracti64x2 $123, %ymm24, %xmm29
// CHECK:  encoding: [0x62,0x03,0xfd,0x28,0x39,0xc5,0x7b]
          vextracti64x2 $0x7b, %ymm24, %xmm29

// CHECK: vextracti64x2 $171, %ymm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x09,0xab]
          vextracti64x2 $0xab, %ymm17,(%rcx)

// CHECK: vextracti64x2 $171, %ymm17, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0xe3,0xfd,0x29,0x39,0x09,0xab]
          vextracti64x2 $0xab, %ymm17,(%rcx) {%k1}

// CHECK: vextracti64x2 $123, %ymm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x09,0x7b]
          vextracti64x2 $0x7b, %ymm17,(%rcx)

// CHECK: vextracti64x2 $123, %ymm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0xfd,0x28,0x39,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextracti64x2 $0x7b, %ymm17,291(%rax,%r14,8)

// CHECK: vextracti64x2 $123, %ymm17, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x4a,0x7f,0x7b]
          vextracti64x2 $0x7b, %ymm17,2032(%rdx)

// CHECK: vextracti64x2 $123, %ymm17, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x8a,0x00,0x08,0x00,0x00,0x7b]
          vextracti64x2 $0x7b, %ymm17,2048(%rdx)

// CHECK: vextracti64x2 $123, %ymm17, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x4a,0x80,0x7b]
          vextracti64x2 $0x7b, %ymm17,-2048(%rdx)

// CHECK: vextracti64x2 $123, %ymm17, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x8a,0xf0,0xf7,0xff,0xff,0x7b]
          vextracti64x2 $0x7b, %ymm17,-2064(%rdx)

// CHECK: vextracti64x2 $171, %ymm17, %xmm29
// CHECK:  encoding: [0x62,0x83,0xfd,0x28,0x39,0xcd,0xab]
          vextracti64x2 $0xab, %ymm17, %xmm29

// CHECK: vextracti64x2 $171, %ymm17, %xmm29 {%k5}
// CHECK:  encoding: [0x62,0x83,0xfd,0x2d,0x39,0xcd,0xab]
          vextracti64x2 $0xab, %ymm17, %xmm29 {%k5}

// CHECK: vextracti64x2 $171, %ymm17, %xmm29 {%k5} {z}
// CHECK:  encoding: [0x62,0x83,0xfd,0xad,0x39,0xcd,0xab]
          vextracti64x2 $0xab, %ymm17, %xmm29 {%k5} {z}

// CHECK: vextracti64x2 $123, %ymm17, %xmm29
// CHECK:  encoding: [0x62,0x83,0xfd,0x28,0x39,0xcd,0x7b]
          vextracti64x2 $0x7b, %ymm17, %xmm29

// CHECK: vextracti64x2 $171, %ymm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x21,0xab]
          vextracti64x2 $0xab, %ymm20,(%rcx)

// CHECK: vextracti64x2 $171, %ymm20, (%rcx) {%k2}
// CHECK:  encoding: [0x62,0xe3,0xfd,0x2a,0x39,0x21,0xab]
          vextracti64x2 $0xab, %ymm20,(%rcx) {%k2}

// CHECK: vextracti64x2 $123, %ymm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x21,0x7b]
          vextracti64x2 $0x7b, %ymm20,(%rcx)

// CHECK: vextracti64x2 $123, %ymm20, 4660(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0xfd,0x28,0x39,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vextracti64x2 $0x7b, %ymm20,4660(%rax,%r14,8)

// CHECK: vextracti64x2 $123, %ymm20, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x62,0x7f,0x7b]
          vextracti64x2 $0x7b, %ymm20,2032(%rdx)

// CHECK: vextracti64x2 $123, %ymm20, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vextracti64x2 $0x7b, %ymm20,2048(%rdx)

// CHECK: vextracti64x2 $123, %ymm20, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0x62,0x80,0x7b]
          vextracti64x2 $0x7b, %ymm20,-2048(%rdx)

// CHECK: vextracti64x2 $123, %ymm20, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x28,0x39,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vextracti64x2 $0x7b, %ymm20,-2064(%rdx)

// CHECK: vfpclasspd $171, %xmm18, %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x08,0x66,0xd2,0xab]
          vfpclasspd $0xab, %xmm18, %k2

// CHECK: vfpclasspd $171, %xmm18, %k2 {%k7}
// CHECK:  encoding: [0x62,0xb3,0xfd,0x0f,0x66,0xd2,0xab]
          vfpclasspd $0xab, %xmm18, %k2 {%k7}

// CHECK: vfpclasspd $123,  %xmm18, %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x08,0x66,0xd2,0x7b]
          vfpclasspd $0x7b, %xmm18, %k2

// CHECK: vfpclasspdx $123, (%rcx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x11,0x7b]
          vfpclasspdx $0x7b,(%rcx), %k2

// CHECK: vfpclasspdx $123, 291(%rax,%r14,8), %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x08,0x66,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfpclasspdx $0x7b,291(%rax,%r14,8), %k2

// CHECK: vfpclasspdq $123, (%rcx){1to2}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x11,0x7b]
          vfpclasspdq $0x7b,(%rcx){1to2}, %k2

// CHECK: vfpclasspdx $123, 2032(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x52,0x7f,0x7b]
          vfpclasspdx $0x7b,2032(%rdx), %k2

// CHECK: vfpclasspdx $123, 2048(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x92,0x00,0x08,0x00,0x00,0x7b]
          vfpclasspdx $0x7b,2048(%rdx), %k2

// CHECK: vfpclasspdx $123, -2048(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x52,0x80,0x7b]
          vfpclasspdx $0x7b,-2048(%rdx), %k2

// CHECK: vfpclasspdx $123, -2064(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x92,0xf0,0xf7,0xff,0xff,0x7b]
          vfpclasspdx $0x7b,-2064(%rdx), %k2

// CHECK: vfpclasspdq $123, 1016(%rdx){1to2}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x52,0x7f,0x7b]
          vfpclasspdq $0x7b,1016(%rdx){1to2}, %k2

// CHECK: vfpclasspdq $123, 1024(%rdx){1to2}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x92,0x00,0x04,0x00,0x00,0x7b]
          vfpclasspdq $0x7b,1024(%rdx){1to2}, %k2

// CHECK: vfpclasspdq $123, -1024(%rdx){1to2}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x52,0x80,0x7b]
          vfpclasspdq $0x7b,-1024(%rdx){1to2}, %k2

// CHECK: vfpclasspdq $123, -1032(%rdx){1to2}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vfpclasspdq $0x7b,-1032(%rdx){1to2}, %k2

// CHECK: vfpclasspd $171, %ymm25, %k4
// CHECK:  encoding: [0x62,0x93,0xfd,0x28,0x66,0xe1,0xab]
          vfpclasspd $0xab, %ymm25, %k4

// CHECK: vfpclasspd $171, %ymm25, %k4 {%k6}
// CHECK:  encoding: [0x62,0x93,0xfd,0x2e,0x66,0xe1,0xab]
          vfpclasspd $0xab, %ymm25, %k4 {%k6}

// CHECK: vfpclasspd $123,  %ymm25, %k4
// CHECK:  encoding: [0x62,0x93,0xfd,0x28,0x66,0xe1,0x7b]
          vfpclasspd $0x7b, %ymm25, %k4

// CHECK: vfpclasspdy $123, (%rcx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0x21,0x7b]
          vfpclasspdy $0x7b,(%rcx), %k4

// CHECK: vfpclasspdy $123, 291(%rax,%r14,8), %k4
// CHECK:  encoding: [0x62,0xb3,0xfd,0x28,0x66,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfpclasspdy $0x7b,291(%rax,%r14,8), %k4

// CHECK: vfpclasspdq $123, (%rcx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0x21,0x7b]
          vfpclasspdq $0x7b,(%rcx){1to4}, %k4

// CHECK: vfpclasspdy $123, 4064(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0x62,0x7f,0x7b]
          vfpclasspdy $0x7b,4064(%rdx), %k4

// CHECK: vfpclasspdy $123, 4096(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vfpclasspdy $0x7b,4096(%rdx), %k4

// CHECK: vfpclasspdy $123, -4096(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0x62,0x80,0x7b]
          vfpclasspdy $0x7b,-4096(%rdx), %k4

// CHECK: vfpclasspdy $123, -4128(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vfpclasspdy $0x7b,-4128(%rdx), %k4

// CHECK: vfpclasspdq $123, 1016(%rdx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0x62,0x7f,0x7b]
          vfpclasspdq $0x7b,1016(%rdx){1to4}, %k4

// CHECK: vfpclasspdq $123, 1024(%rdx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0xa2,0x00,0x04,0x00,0x00,0x7b]
          vfpclasspdq $0x7b,1024(%rdx){1to4}, %k4

// CHECK: vfpclasspdq $123, -1024(%rdx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0x62,0x80,0x7b]
          vfpclasspdq $0x7b,-1024(%rdx){1to4}, %k4

// CHECK: vfpclasspdq $123, -1032(%rdx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          vfpclasspdq $0x7b,-1032(%rdx){1to4}, %k4

// CHECK: vfpclassps $171, %xmm20, %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x08,0x66,0xe4,0xab]
          vfpclassps $0xab, %xmm20, %k4

// CHECK: vfpclassps $171, %xmm20, %k4 {%k5}
// CHECK:  encoding: [0x62,0xb3,0x7d,0x0d,0x66,0xe4,0xab]
          vfpclassps $0xab, %xmm20, %k4 {%k5}

// CHECK: vfpclassps $123,  %xmm20, %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x08,0x66,0xe4,0x7b]
          vfpclassps $0x7b, %xmm20, %k4

// CHECK: vfpclasspsx $123, (%rcx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0x21,0x7b]
          vfpclasspsx $0x7b,(%rcx), %k4

// CHECK: vfpclasspsx $123, 291(%rax,%r14,8), %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x08,0x66,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfpclasspsx $0x7b,291(%rax,%r14,8), %k4

// CHECK: vfpclasspsl $123, (%rcx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0x21,0x7b]
          vfpclasspsl $0x7b,(%rcx){1to4}, %k4

// CHECK: vfpclasspsx $123, 2032(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0x62,0x7f,0x7b]
          vfpclasspsx $0x7b,2032(%rdx), %k4

// CHECK: vfpclasspsx $123, 2048(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vfpclasspsx $0x7b,2048(%rdx), %k4

// CHECK: vfpclasspsx $123, -2048(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0x62,0x80,0x7b]
          vfpclasspsx $0x7b,-2048(%rdx), %k4

// CHECK: vfpclasspsx $123, -2064(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vfpclasspsx $0x7b,-2064(%rdx), %k4

// CHECK: vfpclasspsl $123, 508(%rdx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0x62,0x7f,0x7b]
          vfpclasspsl $0x7b,508(%rdx){1to4}, %k4

// CHECK: vfpclasspsl $123, 512(%rdx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vfpclasspsl $0x7b,512(%rdx){1to4}, %k4

// CHECK: vfpclasspsl $123, -512(%rdx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0x62,0x80,0x7b]
          vfpclasspsl $0x7b,-512(%rdx){1to4}, %k4

// CHECK: vfpclasspsl $123, -516(%rdx){1to4}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vfpclasspsl $0x7b,-516(%rdx){1to4}, %k4

// CHECK: vfpclassps $171, %ymm17, %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x28,0x66,0xe1,0xab]
          vfpclassps $0xab, %ymm17, %k4

// CHECK: vfpclassps $171, %ymm17, %k4 {%k5}
// CHECK:  encoding: [0x62,0xb3,0x7d,0x2d,0x66,0xe1,0xab]
          vfpclassps $0xab, %ymm17, %k4 {%k5}

// CHECK: vfpclassps $123,  %ymm17, %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x28,0x66,0xe1,0x7b]
          vfpclassps $0x7b, %ymm17, %k4

// CHECK: vfpclasspsy $123, (%rcx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0x21,0x7b]
          vfpclasspsy $0x7b,(%rcx), %k4

// CHECK: vfpclasspsy $123, 291(%rax,%r14,8), %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x28,0x66,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfpclasspsy $0x7b,291(%rax,%r14,8), %k4

// CHECK: vfpclasspsl $123, (%rcx){1to8}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0x21,0x7b]
          vfpclasspsl $0x7b,(%rcx){1to8}, %k4

// CHECK: vfpclasspsy $123, 4064(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0x62,0x7f,0x7b]
          vfpclasspsy $0x7b,4064(%rdx), %k4

// CHECK: vfpclasspsy $123, 4096(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vfpclasspsy $0x7b,4096(%rdx), %k4

// CHECK: vfpclasspsy $123, -4096(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0x62,0x80,0x7b]
          vfpclasspsy $0x7b,-4096(%rdx), %k4

// CHECK: vfpclasspsy $123, -4128(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vfpclasspsy $0x7b,-4128(%rdx), %k4

// CHECK: vfpclasspsl $123, 508(%rdx){1to8}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0x62,0x7f,0x7b]
          vfpclasspsl $0x7b,508(%rdx){1to8}, %k4

// CHECK: vfpclasspsl $123, 512(%rdx){1to8}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vfpclasspsl $0x7b,512(%rdx){1to8}, %k4

// CHECK: vfpclasspsl $123, -512(%rdx){1to8}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0x62,0x80,0x7b]
          vfpclasspsl $0x7b,-512(%rdx){1to8}, %k4

// CHECK: vfpclasspsl $123, -516(%rdx){1to8}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vfpclasspsl $0x7b,-516(%rdx){1to8}, %k4

// CHECK: vfpclasspd $171, %xmm26, %k3
// CHECK:  encoding: [0x62,0x93,0xfd,0x08,0x66,0xda,0xab]
          vfpclasspd $0xab, %xmm26, %k3

// CHECK: vfpclasspd $171, %xmm26, %k3 {%k5}
// CHECK:  encoding: [0x62,0x93,0xfd,0x0d,0x66,0xda,0xab]
          vfpclasspd $0xab, %xmm26, %k3 {%k5}

// CHECK: vfpclasspd $123,  %xmm26, %k3
// CHECK:  encoding: [0x62,0x93,0xfd,0x08,0x66,0xda,0x7b]
          vfpclasspd $0x7b, %xmm26, %k3

// CHECK: vfpclasspdx $123, (%rcx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x19,0x7b]
          vfpclasspdx $0x7b,(%rcx), %k3

// CHECK: vfpclasspdx $123, 4660(%rax,%r14,8), %k3
// CHECK:  encoding: [0x62,0xb3,0xfd,0x08,0x66,0x9c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vfpclasspdx $0x7b,4660(%rax,%r14,8), %k3

// CHECK: vfpclasspdq $123, (%rcx){1to2}, %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x19,0x7b]
          vfpclasspdq $0x7b,(%rcx){1to2}, %k3

// CHECK: vfpclasspdx $123, 2032(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x5a,0x7f,0x7b]
          vfpclasspdx $0x7b,2032(%rdx), %k3

// CHECK: vfpclasspdx $123, 2048(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vfpclasspdx $0x7b,2048(%rdx), %k3

// CHECK: vfpclasspdx $123, -2048(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x5a,0x80,0x7b]
          vfpclasspdx $0x7b,-2048(%rdx), %k3

// CHECK: vfpclasspdx $123, -2064(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x66,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vfpclasspdx $0x7b,-2064(%rdx), %k3

// CHECK: vfpclasspdq $123, 1016(%rdx){1to2}, %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x5a,0x7f,0x7b]
          vfpclasspdq $0x7b,1016(%rdx){1to2}, %k3

// CHECK: vfpclasspdq $123, 1024(%rdx){1to2}, %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vfpclasspdq $0x7b,1024(%rdx){1to2}, %k3

// CHECK: vfpclasspdq $123, -1024(%rdx){1to2}, %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x5a,0x80,0x7b]
          vfpclasspdq $0x7b,-1024(%rdx){1to2}, %k3

// CHECK: vfpclasspdq $123, -1032(%rdx){1to2}, %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x18,0x66,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vfpclasspdq $0x7b,-1032(%rdx){1to2}, %k3

// CHECK: vfpclasspd $171, %ymm26, %k2
// CHECK:  encoding: [0x62,0x93,0xfd,0x28,0x66,0xd2,0xab]
          vfpclasspd $0xab, %ymm26, %k2

// CHECK: vfpclasspd $171, %ymm26, %k2 {%k6}
// CHECK:  encoding: [0x62,0x93,0xfd,0x2e,0x66,0xd2,0xab]
          vfpclasspd $0xab, %ymm26, %k2 {%k6}

// CHECK: vfpclasspd $123,  %ymm26, %k2
// CHECK:  encoding: [0x62,0x93,0xfd,0x28,0x66,0xd2,0x7b]
          vfpclasspd $0x7b, %ymm26, %k2

// CHECK: vfpclasspdy $123, (%rcx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0x11,0x7b]
          vfpclasspdy $0x7b,(%rcx), %k2

// CHECK: vfpclasspdy $123, 4660(%rax,%r14,8), %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x28,0x66,0x94,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vfpclasspdy $0x7b,4660(%rax,%r14,8), %k2

// CHECK: vfpclasspdq $123, (%rcx){1to4}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0x11,0x7b]
          vfpclasspdq $0x7b,(%rcx){1to4}, %k2

// CHECK: vfpclasspdy $123, 4064(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0x52,0x7f,0x7b]
          vfpclasspdy $0x7b,4064(%rdx), %k2

// CHECK: vfpclasspdy $123, 4096(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0x92,0x00,0x10,0x00,0x00,0x7b]
          vfpclasspdy $0x7b,4096(%rdx), %k2

// CHECK: vfpclasspdy $123, -4096(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0x52,0x80,0x7b]
          vfpclasspdy $0x7b,-4096(%rdx), %k2

// CHECK: vfpclasspdy $123, -4128(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x28,0x66,0x92,0xe0,0xef,0xff,0xff,0x7b]
          vfpclasspdy $0x7b,-4128(%rdx), %k2

// CHECK: vfpclasspdq $123, 1016(%rdx){1to4}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0x52,0x7f,0x7b]
          vfpclasspdq $0x7b,1016(%rdx){1to4}, %k2

// CHECK: vfpclasspdq $123, 1024(%rdx){1to4}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0x92,0x00,0x04,0x00,0x00,0x7b]
          vfpclasspdq $0x7b,1024(%rdx){1to4}, %k2

// CHECK: vfpclasspdq $123, -1024(%rdx){1to4}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0x52,0x80,0x7b]
          vfpclasspdq $0x7b,-1024(%rdx){1to4}, %k2

// CHECK: vfpclasspdq $123, -1032(%rdx){1to4}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x38,0x66,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vfpclasspdq $0x7b,-1032(%rdx){1to4}, %k2

// CHECK: vfpclassps $171, %xmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x7d,0x08,0x66,0xdd,0xab]
          vfpclassps $0xab, %xmm29, %k3

// CHECK: vfpclassps $171, %xmm29, %k3 {%k6}
// CHECK:  encoding: [0x62,0x93,0x7d,0x0e,0x66,0xdd,0xab]
          vfpclassps $0xab, %xmm29, %k3 {%k6}

// CHECK: vfpclassps $123,  %xmm29, %k3
// CHECK:  encoding: [0x62,0x93,0x7d,0x08,0x66,0xdd,0x7b]
          vfpclassps $0x7b, %xmm29, %k3

// CHECK: vfpclasspsx $123, (%rcx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0x19,0x7b]
          vfpclasspsx $0x7b,(%rcx), %k3

// CHECK: vfpclasspsx $123, 4660(%rax,%r14,8), %k3
// CHECK:  encoding: [0x62,0xb3,0x7d,0x08,0x66,0x9c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vfpclasspsx $0x7b,4660(%rax,%r14,8), %k3

// CHECK: vfpclasspsl $123, (%rcx){1to4}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0x19,0x7b]
          vfpclasspsl $0x7b,(%rcx){1to4}, %k3

// CHECK: vfpclasspsx $123, 2032(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0x5a,0x7f,0x7b]
          vfpclasspsx $0x7b,2032(%rdx), %k3

// CHECK: vfpclasspsx $123, 2048(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vfpclasspsx $0x7b,2048(%rdx), %k3

// CHECK: vfpclasspsx $123, -2048(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0x5a,0x80,0x7b]
          vfpclasspsx $0x7b,-2048(%rdx), %k3

// CHECK: vfpclasspsx $123, -2064(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x66,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vfpclasspsx $0x7b,-2064(%rdx), %k3

// CHECK: vfpclasspsl $123, 508(%rdx){1to4}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0x5a,0x7f,0x7b]
          vfpclasspsl $0x7b,508(%rdx){1to4}, %k3

// CHECK: vfpclasspsl $123, 512(%rdx){1to4}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vfpclasspsl $0x7b,512(%rdx){1to4}, %k3

// CHECK: vfpclasspsl $123, -512(%rdx){1to4}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0x5a,0x80,0x7b]
          vfpclasspsl $0x7b,-512(%rdx){1to4}, %k3

// CHECK: vfpclasspsl $123, -516(%rdx){1to4}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x18,0x66,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vfpclasspsl $0x7b,-516(%rdx){1to4}, %k3

// CHECK: vfpclassps $171, %ymm19, %k3
// CHECK:  encoding: [0x62,0xb3,0x7d,0x28,0x66,0xdb,0xab]
          vfpclassps $0xab, %ymm19, %k3

// CHECK: vfpclassps $171, %ymm19, %k3 {%k3}
// CHECK:  encoding: [0x62,0xb3,0x7d,0x2b,0x66,0xdb,0xab]
          vfpclassps $0xab, %ymm19, %k3 {%k3}

// CHECK: vfpclassps $123,  %ymm19, %k3
// CHECK:  encoding: [0x62,0xb3,0x7d,0x28,0x66,0xdb,0x7b]
          vfpclassps $0x7b, %ymm19, %k3

// CHECK: vfpclasspsy $123, (%rcx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0x19,0x7b]
          vfpclasspsy $0x7b,(%rcx), %k3

// CHECK: vfpclasspsy $123, 4660(%rax,%r14,8), %k3
// CHECK:  encoding: [0x62,0xb3,0x7d,0x28,0x66,0x9c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vfpclasspsy $0x7b,4660(%rax,%r14,8), %k3

// CHECK: vfpclasspsl $123, (%rcx){1to8}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0x19,0x7b]
          vfpclasspsl $0x7b,(%rcx){1to8}, %k3

// CHECK: vfpclasspsy $123, 4064(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0x5a,0x7f,0x7b]
          vfpclasspsy $0x7b,4064(%rdx), %k3

// CHECK: vfpclasspsy $123, 4096(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0x9a,0x00,0x10,0x00,0x00,0x7b]
          vfpclasspsy $0x7b,4096(%rdx), %k3

// CHECK: vfpclasspsy $123, -4096(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0x5a,0x80,0x7b]
          vfpclasspsy $0x7b,-4096(%rdx), %k3

// CHECK: vfpclasspsy $123, -4128(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x28,0x66,0x9a,0xe0,0xef,0xff,0xff,0x7b]
          vfpclasspsy $0x7b,-4128(%rdx), %k3

// CHECK: vfpclasspsl $123, 508(%rdx){1to8}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0x5a,0x7f,0x7b]
          vfpclasspsl $0x7b,508(%rdx){1to8}, %k3

// CHECK: vfpclasspsl $123, 512(%rdx){1to8}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vfpclasspsl $0x7b,512(%rdx){1to8}, %k3

// CHECK: vfpclasspsl $123, -512(%rdx){1to8}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0x5a,0x80,0x7b]
          vfpclasspsl $0x7b,-512(%rdx){1to8}, %k3

// CHECK: vfpclasspsl $123, -516(%rdx){1to8}, %k3
// CHECK:  encoding: [0x62,0xf3,0x7d,0x38,0x66,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vfpclasspsl $0x7b,-516(%rdx){1to8}, %k3

// CHECK: vbroadcasti32x2 %xmm30, %xmm30
// CHECK:  encoding: [0x62,0x02,0x7d,0x08,0x59,0xf6]
          vbroadcasti32x2 %xmm30, %xmm30

// CHECK: vbroadcasti32x2 %xmm30, %xmm30 {%k2}
// CHECK:  encoding: [0x62,0x02,0x7d,0x0a,0x59,0xf6]
          vbroadcasti32x2 %xmm30, %xmm30 {%k2}

// CHECK: vbroadcasti32x2 %xmm30, %xmm30 {%k2} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0x8a,0x59,0xf6]
          vbroadcasti32x2 %xmm30, %xmm30 {%k2} {z}

// CHECK: vbroadcasti32x2 (%rcx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0x31]
          vbroadcasti32x2 (%rcx), %xmm30

// CHECK: vbroadcasti32x2 291(%rax,%r14,8), %xmm30
// CHECK:  encoding: [0x62,0x22,0x7d,0x08,0x59,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcasti32x2 291(%rax,%r14,8), %xmm30

// CHECK: vbroadcasti32x2 1016(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0x72,0x7f]
          vbroadcasti32x2 1016(%rdx), %xmm30

// CHECK: vbroadcasti32x2 1024(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0xb2,0x00,0x04,0x00,0x00]
          vbroadcasti32x2 1024(%rdx), %xmm30

// CHECK: vbroadcasti32x2 -1024(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0x72,0x80]
          vbroadcasti32x2 -1024(%rdx), %xmm30

// CHECK: vbroadcasti32x2 -1032(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0xb2,0xf8,0xfb,0xff,0xff]
          vbroadcasti32x2 -1032(%rdx), %xmm30

// CHECK: vbroadcasti32x2 %xmm28, %ymm26
// CHECK:  encoding: [0x62,0x02,0x7d,0x28,0x59,0xd4]
          vbroadcasti32x2 %xmm28, %ymm26

// CHECK: vbroadcasti32x2 %xmm28, %ymm26 {%k7}
// CHECK:  encoding: [0x62,0x02,0x7d,0x2f,0x59,0xd4]
          vbroadcasti32x2 %xmm28, %ymm26 {%k7}

// CHECK: vbroadcasti32x2 %xmm28, %ymm26 {%k7} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0xaf,0x59,0xd4]
          vbroadcasti32x2 %xmm28, %ymm26 {%k7} {z}

// CHECK: vbroadcasti32x2 (%rcx), %ymm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x59,0x11]
          vbroadcasti32x2 (%rcx), %ymm26

// CHECK: vbroadcasti32x2 291(%rax,%r14,8), %ymm26
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x59,0x94,0xf0,0x23,0x01,0x00,0x00]
          vbroadcasti32x2 291(%rax,%r14,8), %ymm26

// CHECK: vbroadcasti32x2 1016(%rdx), %ymm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x59,0x52,0x7f]
          vbroadcasti32x2 1016(%rdx), %ymm26

// CHECK: vbroadcasti32x2 1024(%rdx), %ymm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x59,0x92,0x00,0x04,0x00,0x00]
          vbroadcasti32x2 1024(%rdx), %ymm26

// CHECK: vbroadcasti32x2 -1024(%rdx), %ymm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x59,0x52,0x80]
          vbroadcasti32x2 -1024(%rdx), %ymm26

// CHECK: vbroadcasti32x2 -1032(%rdx), %ymm26
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x59,0x92,0xf8,0xfb,0xff,0xff]
          vbroadcasti32x2 -1032(%rdx), %ymm26

// CHECK: vbroadcasti32x2 %xmm28, %xmm30
// CHECK:  encoding: [0x62,0x02,0x7d,0x08,0x59,0xf4]
          vbroadcasti32x2 %xmm28, %xmm30

// CHECK: vbroadcasti32x2 %xmm28, %xmm30 {%k6}
// CHECK:  encoding: [0x62,0x02,0x7d,0x0e,0x59,0xf4]
          vbroadcasti32x2 %xmm28, %xmm30 {%k6}

// CHECK: vbroadcasti32x2 %xmm28, %xmm30 {%k6} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0x8e,0x59,0xf4]
          vbroadcasti32x2 %xmm28, %xmm30 {%k6} {z}

// CHECK: vbroadcasti32x2 (%rcx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0x31]
          vbroadcasti32x2 (%rcx), %xmm30

// CHECK: vbroadcasti32x2 4660(%rax,%r14,8), %xmm30
// CHECK:  encoding: [0x62,0x22,0x7d,0x08,0x59,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vbroadcasti32x2 4660(%rax,%r14,8), %xmm30

// CHECK: vbroadcasti32x2 1016(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0x72,0x7f]
          vbroadcasti32x2 1016(%rdx), %xmm30

// CHECK: vbroadcasti32x2 1024(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0xb2,0x00,0x04,0x00,0x00]
          vbroadcasti32x2 1024(%rdx), %xmm30

// CHECK: vbroadcasti32x2 -1024(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0x72,0x80]
          vbroadcasti32x2 -1024(%rdx), %xmm30

// CHECK: vbroadcasti32x2 -1032(%rdx), %xmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x59,0xb2,0xf8,0xfb,0xff,0xff]
          vbroadcasti32x2 -1032(%rdx), %xmm30

// CHECK: vbroadcasti32x2 %xmm28, %ymm23
// CHECK:  encoding: [0x62,0x82,0x7d,0x28,0x59,0xfc]
          vbroadcasti32x2 %xmm28, %ymm23

// CHECK: vbroadcasti32x2 %xmm28, %ymm23 {%k1}
// CHECK:  encoding: [0x62,0x82,0x7d,0x29,0x59,0xfc]
          vbroadcasti32x2 %xmm28, %ymm23 {%k1}

// CHECK: vbroadcasti32x2 %xmm28, %ymm23 {%k1} {z}
// CHECK:  encoding: [0x62,0x82,0x7d,0xa9,0x59,0xfc]
          vbroadcasti32x2 %xmm28, %ymm23 {%k1} {z}

// CHECK: vbroadcasti32x2 (%rcx), %ymm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x59,0x39]
          vbroadcasti32x2 (%rcx), %ymm23

// CHECK: vbroadcasti32x2 4660(%rax,%r14,8), %ymm23
// CHECK:  encoding: [0x62,0xa2,0x7d,0x28,0x59,0xbc,0xf0,0x34,0x12,0x00,0x00]
          vbroadcasti32x2 4660(%rax,%r14,8), %ymm23

// CHECK: vbroadcasti32x2 1016(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x59,0x7a,0x7f]
          vbroadcasti32x2 1016(%rdx), %ymm23

// CHECK: vbroadcasti32x2 1024(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x59,0xba,0x00,0x04,0x00,0x00]
          vbroadcasti32x2 1024(%rdx), %ymm23

// CHECK: vbroadcasti32x2 -1024(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x59,0x7a,0x80]
          vbroadcasti32x2 -1024(%rdx), %ymm23

// CHECK: vbroadcasti32x2 -1032(%rdx), %ymm23
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x59,0xba,0xf8,0xfb,0xff,0xff]
          vbroadcasti32x2 -1032(%rdx), %ymm23

// CHECK: vbroadcastf32x2 %xmm18, %ymm28
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x19,0xe2]
          vbroadcastf32x2 %xmm18, %ymm28

// CHECK: vbroadcastf32x2 %xmm18, %ymm28 {%k7}
// CHECK:  encoding: [0x62,0x22,0x7d,0x2f,0x19,0xe2]
          vbroadcastf32x2 %xmm18, %ymm28 {%k7}

// CHECK: vbroadcastf32x2 %xmm18, %ymm28 {%k7} {z}
// CHECK:  encoding: [0x62,0x22,0x7d,0xaf,0x19,0xe2]
          vbroadcastf32x2 %xmm18, %ymm28 {%k7} {z}

// CHECK: vbroadcastf32x2 (%rcx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x19,0x21]
          vbroadcastf32x2 (%rcx), %ymm28

// CHECK: vbroadcastf32x2 291(%rax,%r14,8), %ymm28
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x19,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastf32x2 291(%rax,%r14,8), %ymm28

// CHECK: vbroadcastf32x2 1016(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x19,0x62,0x7f]
          vbroadcastf32x2 1016(%rdx), %ymm28

// CHECK: vbroadcastf32x2 1024(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x19,0xa2,0x00,0x04,0x00,0x00]
          vbroadcastf32x2 1024(%rdx), %ymm28

// CHECK: vbroadcastf32x2 -1024(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x19,0x62,0x80]
          vbroadcastf32x2 -1024(%rdx), %ymm28

// CHECK: vbroadcastf32x2 -1032(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x19,0xa2,0xf8,0xfb,0xff,0xff]
          vbroadcastf32x2 -1032(%rdx), %ymm28

// CHECK: vbroadcastf32x2 %xmm26, %ymm19
// CHECK:  encoding: [0x62,0x82,0x7d,0x28,0x19,0xda]
          vbroadcastf32x2 %xmm26, %ymm19

// CHECK: vbroadcastf32x2 %xmm26, %ymm19 {%k7}
// CHECK:  encoding: [0x62,0x82,0x7d,0x2f,0x19,0xda]
          vbroadcastf32x2 %xmm26, %ymm19 {%k7}

// CHECK: vbroadcastf32x2 %xmm26, %ymm19 {%k7} {z}
// CHECK:  encoding: [0x62,0x82,0x7d,0xaf,0x19,0xda]
          vbroadcastf32x2 %xmm26, %ymm19 {%k7} {z}

// CHECK: vbroadcastf32x2 (%rcx), %ymm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x19,0x19]
          vbroadcastf32x2 (%rcx), %ymm19

// CHECK: vbroadcastf32x2 4660(%rax,%r14,8), %ymm19
// CHECK:  encoding: [0x62,0xa2,0x7d,0x28,0x19,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vbroadcastf32x2 4660(%rax,%r14,8), %ymm19

// CHECK: vbroadcastf32x2 1016(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x19,0x5a,0x7f]
          vbroadcastf32x2 1016(%rdx), %ymm19

// CHECK: vbroadcastf32x2 1024(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x19,0x9a,0x00,0x04,0x00,0x00]
          vbroadcastf32x2 1024(%rdx), %ymm19

// CHECK: vbroadcastf32x2 -1024(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x19,0x5a,0x80]
          vbroadcastf32x2 -1024(%rdx), %ymm19

// CHECK: vbroadcastf32x2 -1032(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x28,0x19,0x9a,0xf8,0xfb,0xff,0xff]
          vbroadcastf32x2 -1032(%rdx), %ymm19

