.\"
.\"
.\" Copyright © 2013 Keith Packard
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that copyright
.\" notice and this permission notice appear in supporting documentation, and
.\" that the name of the copyright holders not be used in advertising or
.\" publicity pertaining to distribution of the software without specific,
.\" written prior permission.  The copyright holders make no representations
.\" about the suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
.\" OF THIS SOFTWARE.
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH XPresentSelectInput __libmansuffix__ 2022-08-27 __xorgversion__
.SH NAME
XPresentSelectInput \- select X Present Extension events to receive
.SH SYNTAX
\&#include <X11/extensions/Xpresent.h>
.nf
.sp
XID XPresentSelectInput \^(\^Display *\fIdisplay\fP,
	Window \fIwindow\fP,
	unsigned int \fIevent_mask\fP\^)\^;
.sp
void XPresentFreeInput \^(\^Display *\fIdisplay\fP,
        Window \fIwindow\fP,
        XID \fIevent_id\fP\^)\^;
.fi
.SH DESCRIPTION
.B XPresentSelectInput
selects a set of Present events to be delivered for the
specified \fIwindow\fP on the X server specified by \fIdisplay\fP.
.PP
.B XPresentSelectInput
returns an XID which may be passed to
.B XPresentFreeInput
to stop receiving the requested events.
.SH SEE ALSO
.BR Xpresent (__libmansuffix__),
.BR XPresentNotifyMSC (__libmansuffix__),
.BR XPresentPixmap (__libmansuffix__),
.BR XPresentQueryCapabilities (__libmansuffix__)
.SH AUTHORS
Keith Packard, Intel
