/***************************************************************************
 *   Copyright (C) 2002 by Jakob Simon-Gaarde                              *
 *   jsgaarde@tdcspace.dk                                                  *
 *   Copyright (C) 2002-2003 by Alexander Dymo                             *
 *   cloudtemple@mksat.net                                                 *
 *   Copyright (C) 2003 by Thomas Hasart                                   *
 *   thasart@gmx.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "projectconfigurationdlg.h"
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <kfiledialog.h>
#include <knotifyclient.h>
#include <klineedit.h>
#include <klineeditdlg.h>
#include <kurlrequester.h>
#include <kdebug.h>

#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qlistview.h>
#include <iostream>
#include <qregexp.h>
#include <qvalidator.h>
#include <qtabwidget.h>

ProjectConfigurationDlg::ProjectConfigurationDlg(SubprojectItem *_item,QListView *_prjList,QWidget* parent, const char* name, bool modal, WFlags fl)
: ProjectConfigurationDlgBase(parent,name,modal,fl)
//=================================================
{
  myProjectItem=_item;
  prjList=_prjList;
//  m_projectConfiguration = conf;
  m_targetLibraryVersion->setValidator(new QRegExpValidator(
    QRegExp("\\d+(\\.\\d+)?(\\.\\d+)"), this));
  UpdateControls();
}


ProjectConfigurationDlg::~ProjectConfigurationDlg()
//==============================================
{
}

//void ProjectConfigurationDlg::radioLibrarytoggled(bool on)
////=============================================
//{
//	if(!on) checkStatic->setChecked(false);
//	checkStatic->setEnabled(on);
//	m_targetLibraryVersion->setEnabled(on);
//}

/*
void ProjectConfigurationDlg::radioLibrarytoggled(bool on)
//=============================================
{
	groupLibrary->setEnabled(on);
	//radioShared->setChecked(true);
	m_targetLibraryVersion->setEnabled(on);
}
*/
void ProjectConfigurationDlg::browseTargetPath()
//==============================================
{
  m_targetPath->setText(KFileDialog::getExistingDirectory());

}


void ProjectConfigurationDlg::updateProjectConfiguration()
//=======================================================
{
  // Template
  myProjectItem->configuration.m_requirements = 0;

  if (radioApplication->isChecked())
    myProjectItem->configuration.m_template = QTMP_APPLICATION;
  else if (radioLibrary->isChecked())
  {
    myProjectItem->configuration.m_template = QTMP_LIBRARY;
    if (staticRadio->isOn())
      myProjectItem->configuration.m_requirements += QD_STATIC;
    if (sharedRadio->isOn()){
      myProjectItem->configuration.m_requirements += QD_SHARED;
      myProjectItem->configuration.m_libraryversion = m_targetLibraryVersion->text();
    }
    if (pluginRadio->isOn())
      myProjectItem->configuration.m_requirements += QD_PLUGIN;
  }
  else if (radioSubdirs->isChecked())
    myProjectItem->configuration.m_template = QTMP_SUBDIRS;

  // Buildmode
  if (radioDebugMode->isChecked())
    myProjectItem->configuration.m_buildMode = QBM_DEBUG;
  if (radioReleaseMode->isChecked())
    myProjectItem->configuration.m_buildMode = QBM_RELEASE;

  // requirements
  if (exceptionCheck->isChecked())
    myProjectItem->configuration.m_requirements += QD_EXCEPTIONS;
  if (stlCheck->isChecked())
    myProjectItem->configuration.m_requirements += QD_STL;
  if (rttiCheck->isChecked())
    myProjectItem->configuration.m_requirements += QD_RTTI;
  if (checkQt->isChecked())
    myProjectItem->configuration.m_requirements += QD_QT;
  if (checkOpenGL->isChecked())
    myProjectItem->configuration.m_requirements += QD_OPENGL;
  if (checkThread->isChecked())
    myProjectItem->configuration.m_requirements += QD_THREAD;
  if (checkX11->isChecked())
    myProjectItem->configuration.m_requirements += QD_X11;

  // Warnings
  myProjectItem->configuration.m_warnings = QWARN_OFF;
  if (checkWarning->isChecked())
    myProjectItem->configuration.m_warnings = QWARN_ON;

  myProjectItem->configuration.m_target = "";
/*  if ((m_targetPath->text().simplifyWhiteSpace()!="" ||
      m_targetOutputFile->text().simplifyWhiteSpace()!="") &&
      !radioSubdirs->isChecked())
  {
    QString outputFile = m_targetOutputFile->text();
    if (outputFile.simplifyWhiteSpace() == "")
      outputFile = myProjectItem->configuration.m_subdirName;
    myProjectItem->configuration.m_target = m_targetPath->text() + "/" + outputFile;
  }*/
  myProjectItem->configuration.m_target = m_targetOutputFile->text();
  myProjectItem->configuration.m_destdir = m_targetPath->text();
//  myProjectItem->configuration.m_includepath = m_includePath->text();
  myProjectItem->configuration.m_defines = QStringList::split(" ",m_defines->text());
  myProjectItem->configuration.m_cxxflags_debug = QStringList::split(" ",m_debugFlags->text());
  myProjectItem->configuration.m_cxxflags_release = QStringList::split(" ",m_releaseFlags->text());
//  myProjectItem->configuration.m_lflags_debug = QStringList::split(" ",m_debugFlagsLink->text());
// myProjectItem->configuration.m_lflags_release = QStringList::split(" ",m_releaseFlagsLink->text());
//  myProjectItem->configuration.m_librarypath = QStringList::split(" ",m_libraryPath->text());
  if (checkDontInheritConfig->isChecked())
    myProjectItem->configuration.m_inheritconfig = false;
  else
    myProjectItem->configuration.m_inheritconfig = true;

  //add selected includes
  myProjectItem->configuration.m_incadd.clear();

  InsideCheckListItem *insideItem=(InsideCheckListItem *)insideinc_listview->firstChild();
  while(insideItem)
  {
    if(insideItem->isOn()){
      QString tmpInc=insideItem->prjItem->getIncAddPath(myProjectItem->getDownDirs());
      tmpInc=QDir::cleanDirPath(tmpInc);
      myProjectItem->configuration.m_incadd.append(tmpInc);

    }
    insideItem=(InsideCheckListItem*)insideItem->itemBelow();
  }

  QCheckListItem *outsideItem=(QCheckListItem *)outsideinc_listview->firstChild();
  while(outsideItem)
  {
    myProjectItem->configuration.m_incadd.append(outsideItem->text(0));
    outsideItem=(QCheckListItem*)outsideItem->itemBelow();
  }

  //target.install
  if (checkInstallTarget->isChecked() == true)
  {
    myProjectItem->configuration.m_target_install = true;
    myProjectItem->configuration.m_target_install_path = m_InstallTargetPath->text();
  }
  else
  {
    myProjectItem->configuration.m_target_install = false;
  }

  //makefile
  myProjectItem->configuration.m_makefile = makefile_url->url();

  //add libs to link
  myProjectItem->configuration.m_libadd.clear();
  myProjectItem->configuration.m_librarypath.clear();

  //outside libs to link
  outsideItem=(QCheckListItem *)outsidelib_listview->firstChild();
  while(outsideItem)
  {
    myProjectItem->configuration.m_libadd.append(outsideItem->text(0));
    outsideItem=(QCheckListItem*)outsideItem->itemBelow();
  }

  //inside libs to link    
  myProjectItem->configuration.m_prjdeps.clear();
  insideItem=(InsideCheckListItem *)insidelib_listview->firstChild();
  while(insideItem)
  {
    if(insideItem->isOn()){

      QString tmpLib=insideItem->prjItem->getLibAddObject(myProjectItem->getDownDirs());
      if(insideItem->prjItem->configuration.m_requirements & QD_SHARED)
      {
        tmpLib=/*"-l"+*/tmpLib;

        //add path if shared lib is linked
        QString tmpPath=insideItem->prjItem->getLibAddPath(myProjectItem->getDownDirs());
        if(tmpPath!=""){
          myProjectItem->configuration.m_librarypath.append(/*"-L"+*/tmpPath);
        }
      }else if(insideItem->prjItem->configuration.m_requirements & QD_STATIC)
      {
        //deps if static libs are linked
        myProjectItem->configuration.m_prjdeps.append(tmpLib);
      }
      myProjectItem->configuration.m_libadd.append(tmpLib);
           
    }
    insideItem=(InsideCheckListItem*)insideItem->itemBelow();
  }

  //extra lib paths
  QListViewItem *lvItem=outsidelibdir_listview->firstChild();
  while(lvItem)
  {
    myProjectItem->configuration.m_librarypath.append(lvItem->text(0));
    lvItem=lvItem->itemBelow();
  }

  //change build order
  lvItem=buildorder_listview->firstChild();
  myProjectItem->subdirs.clear();
  while(lvItem)
  {
    myProjectItem->subdirs.append(lvItem->text(0));
    lvItem=lvItem->itemBelow();
  }

  // intermediate locations
  myProjectItem->configuration.m_objectpath = objdir_url->url();
  myProjectItem->configuration.m_uipath = uidir_url->url();
  myProjectItem->configuration.m_mocpath = mocdir_url->url();

  //CORBA
  myProjectItem->configuration.idl_compiler=idlCmdEdit->text();
  myProjectItem->configuration.idl_options=idlCmdOptionsEdit->text();

  QDialog::accept();
  
}


void ProjectConfigurationDlg::UpdateControls()
//============================================
{
  QRadioButton *activateRadiobutton=NULL;
  // Project template
  libGroup->setEnabled(false);
  switch (myProjectItem->configuration.m_template)
  {
    case QTMP_APPLICATION:
      activateRadiobutton = radioApplication;
      break;
    case QTMP_LIBRARY:
      libGroup->setEnabled(true);

      activateRadiobutton = radioLibrary;
      staticRadio->setChecked(true); //default
      if (myProjectItem->configuration.m_requirements & QD_STATIC){
        staticRadio->setChecked(true);
        libAddTab->setEnabled(false);
        libPathTab->setEnabled(false);
      }else{
        libAddTab->setEnabled(true);
        libPathTab->setEnabled(true);
      }        
      if (myProjectItem->configuration.m_requirements & QD_SHARED){
        sharedRadio->setChecked(true);
        m_targetLibraryVersion->setText(myProjectItem->configuration.m_libraryversion);
      }

      if (myProjectItem->configuration.m_requirements & QD_PLUGIN)
        pluginRadio->setChecked(true);
      break;
    case QTMP_SUBDIRS:
      activateRadiobutton = radioSubdirs;
      break;
  }
  // Buildmode
  if (activateRadiobutton)
    activateRadiobutton->setChecked(true);
  switch (myProjectItem->configuration.m_buildMode)
  {
    case QBM_DEBUG:
      activateRadiobutton = radioDebugMode;
      break;
    case QBM_RELEASE:
      activateRadiobutton = radioReleaseMode;
      break;
  }
  if (activateRadiobutton)
    activateRadiobutton->setChecked(true);

  // Requirements
  if (myProjectItem->configuration.m_requirements & QD_QT)
    checkQt->setChecked(true);
  if (myProjectItem->configuration.m_requirements & QD_OPENGL)
    checkOpenGL->setChecked(true);
  if (myProjectItem->configuration.m_requirements & QD_THREAD)
    checkThread->setChecked(true);
  if (myProjectItem->configuration.m_requirements & QD_X11)
    checkX11->setChecked(true);
  if (myProjectItem->configuration.m_requirements & QD_EXCEPTIONS)
    exceptionCheck->setChecked(true);
  if (myProjectItem->configuration.m_requirements & QD_STL)
    stlCheck->setChecked(true);
  if (myProjectItem->configuration.m_requirements & QD_RTTI)
    rttiCheck->setChecked(true);

  // Warnings
  if (myProjectItem->configuration.m_warnings == QWARN_ON)
  {
    checkWarning->setChecked(true);
  }

  //makefile
  makefile_url->setURL(myProjectItem->configuration.m_makefile);

  // Target
/*  QString targetString = myProjectItem->configuration.m_target;
  int slashPos = targetString.findRev('/');

  if (slashPos>=0)
  {
    m_targetPath->setText(targetString.left(slashPos));
    m_targetOutputFile->setText(targetString.right(targetString.length()-slashPos-1));
  }
  else
    m_targetOutputFile->setText(targetString);
*/
  //target.path = path
  //INSTALLS += target
  if (myProjectItem->configuration.m_target_install == true) 
  {
    checkInstallTarget->setChecked(true);
    m_InstallTargetPath->setEnabled(true);
  } 
  else
  {
    checkInstallTarget->setChecked(false);
    m_InstallTargetPath->setEnabled(false);
  }
  m_InstallTargetPath->setText(myProjectItem->configuration.m_target_install_path);
  
  
  
  m_targetOutputFile->setText(myProjectItem->configuration.m_target);
  m_targetPath->setText(myProjectItem->configuration.m_destdir);
  clickSubdirsTemplate();

  m_defines->setText(myProjectItem->configuration.m_defines.join(" "));
  m_debugFlags->setText(myProjectItem->configuration.m_cxxflags_debug.join(" "));
  m_releaseFlags->setText(myProjectItem->configuration.m_cxxflags_release.join(" "));

  if (myProjectItem->configuration.m_inheritconfig == false)
    checkDontInheritConfig->setChecked(true);
  else
    checkDontInheritConfig->setChecked(false);    
     
  updateIncludeControl();
  updateLibaddControl();
  updateLibDirAddControl();
  updateBuildOrderControl();  

  objdir_url->setURL(myProjectItem->configuration.m_objectpath);
  uidir_url->setURL(myProjectItem->configuration.m_uipath);
  mocdir_url->setURL(myProjectItem->configuration.m_mocpath);
}

QPtrList <ProjectItem> ProjectConfigurationDlg::getAllProjects()
{
  QPtrList <ProjectItem> tmpPrjList;
  ProjectItem *item=(ProjectItem *)prjList->firstChild();
  while(item)
  {
    tmpPrjList.append(item);
    getAllSubProjects(item,&tmpPrjList);
    item=(ProjectItem *)item->nextSibling();
  }
  return(tmpPrjList);
}

void ProjectConfigurationDlg::getAllSubProjects(ProjectItem *item,QPtrList <ProjectItem> *itemList)
{

  ProjectItem *subItem=(ProjectItem *)item->firstChild();
  while(subItem)
  {
    itemList->append(subItem);
    getAllSubProjects(subItem,itemList);
    subItem=(ProjectItem *)subItem->nextSibling();
  }
}



void ProjectConfigurationDlg::updateIncludeControl()
{
  insideinc_listview->setSorting(-1,false);
  outsideinc_listview->setSorting(-1,false);


  QStringList incList=myProjectItem->configuration.m_incadd;
  QPtrList <ProjectItem> itemList=getAllProjects();
  ProjectItem *item=itemList.first();

  
  while(item){
    if(item->type()==ProjectItem::Subproject)
    {

      //includes
      //temp strlist
      if( ((SubprojectItem*)item)->configuration.m_template==QTMP_LIBRARY ||
          ((SubprojectItem*)item)->configuration.m_template==QTMP_APPLICATION){
          SubprojectItem *sItem=(SubprojectItem*)item;
         //if(sItem!=myProjectItem) //needed own path for other libs
         {
              QString tmpInc=sItem->getIncAddPath(myProjectItem->getDownDirs());
              tmpInc=QDir::cleanDirPath(tmpInc);
              InsideCheckListItem *newItem=new InsideCheckListItem(insideinc_listview,insideinc_listview->lastItem(),sItem);
              QStringList::Iterator it=incList.begin();
              
          for(;it!=incList.end();++it)
          {
            if((*it).find(tmpInc)>=0){
              incList.remove(it);
              newItem->setOn(true);
              it=incList.begin();
            }
          }
        }
      }
    }
//    item=(ProjectItem*)item->itemBelow();
    item=itemList.next();
  }

  //all other in incList are outside incs
  QStringList::Iterator it1=incList.begin();
  for(;it1!=incList.end();++it1)
  {
      new QListViewItem(outsideinc_listview,outsideinc_listview->lastItem(),(*it1));
  }
  
}
void ProjectConfigurationDlg::updateLibaddControl()
{

  QPtrList <ProjectItem> itemList=getAllProjects();

  insidelib_listview->setSorting(-1,false);
  outsidelib_listview->setSorting(-1,false);

  //update librarys
  //temp strlist
  QStringList libList=myProjectItem->configuration.m_libadd;


  QStringList::Iterator it=libList.begin();
  for(;it!=libList.end();++it){
        ProjectItem *item=itemList.first();
        while(item){
          if(item->type()==ProjectItem::Subproject)
          {

            //librarys
            if( ((SubprojectItem*)item)->configuration.m_template==QTMP_LIBRARY ){
              SubprojectItem *sItem=(SubprojectItem*)item;
              

              if(sItem!=myProjectItem)
              {
                // create lib string
                  QString tmpLib=sItem->getLibAddObject(myProjectItem->getDownDirs());
                  if(sItem->configuration.m_requirements & QD_SHARED) tmpLib=/*"-l"+*/tmpLib;
                  if(tmpLib==(*it)){
                    InsideCheckListItem *newItem=new InsideCheckListItem(insidelib_listview,insidelib_listview->lastItem(),sItem);
                    libList.remove(it);
                    it=libList.begin();
                    newItem->setOn(true);
                    itemList.remove(item);
                    item=itemList.first();
                  }

              }
            }
          }
          item=itemList.next();
        }
    }

  kdDebug()<< "itemlist count =" << itemList.count()<<endl;
    
  //add all other prj in itemList unchecked
  ProjectItem *item=itemList.first();
  while(item)
  {
    if(item->type()==ProjectItem::Subproject)
    {
      //librarys
      if( ((SubprojectItem*)item)->configuration.m_template==QTMP_LIBRARY ){
        SubprojectItem *sItem=(SubprojectItem*)item;
        if(sItem!=myProjectItem)
        {
          // create lib string
          QString tmpLib=sItem->getLibAddObject(myProjectItem->getDownDirs());
          if(sItem->configuration.m_requirements & QD_SHARED) tmpLib=/*"-l"+*/tmpLib;
          InsideCheckListItem *newItem=new InsideCheckListItem(insidelib_listview,insidelib_listview->lastItem(),sItem);
          newItem->setOn(false);
        }
      }
    }
    item=itemList.next();
  }
  







                  
  
  //all other in libList are outside libs
  QStringList::Iterator it1=libList.begin();
  for(;it1!=libList.end();++it1)
  {
      new QListViewItem(outsidelib_listview,outsidelib_listview->lastItem(),(*it1));
  }
}
void ProjectConfigurationDlg::updateBuildOrderControl()
{
  //sort build order only if subdirs
  if(myProjectItem->configuration.m_template==QTMP_SUBDIRS)
  {

      QPtrList <ProjectItem> itemList;

      ProjectItem *item=(ProjectItem *)myProjectItem->firstChild();
      while(item){
        itemList.append(item);
        item=(ProjectItem*)item->nextSibling();
      }



    incaddTab->setEnabled(false);
    buildorder_listview->setSorting(-1,false);
    QStringList buildList=myProjectItem->subdirs;
    QStringList::Iterator it1=buildList.begin();
    for(;it1!=buildList.end();++it1){
      item=itemList.first();
      while(item){
        if(item->type()==ProjectItem::Subproject)
        {
          if(item->text(0)==(*it1)){
            new QListViewItem(buildorder_listview,buildorder_listview->lastItem(),item->text(0));
            itemList.take();
            item=itemList.first();
          }
        }
        item=itemList.next();;
      }
    }
    //add the rest
      item=itemList.first();
      while(item){
        if(item->type()==ProjectItem::Subproject)
        {
            new QListViewItem(buildorder_listview,buildorder_listview->lastItem(),item->text(0));
        }
        item=itemList.next();;
      }

  }else buildOrderTab->setEnabled(false);

}

void ProjectConfigurationDlg::updateLibDirAddControl()
{
  //update librarys
  //temp strlist
  QStringList libDirList=myProjectItem->configuration.m_librarypath;

  QPtrList <ProjectItem> itemList=getAllProjects();
  ProjectItem *item=itemList.first();
  
  while(item){
    if(item->type()==ProjectItem::Subproject)
    {

      //librarys
      if( ((SubprojectItem*)item)->configuration.m_template==QTMP_LIBRARY ){
        SubprojectItem *sItem=(SubprojectItem*)item;

        if(sItem!=myProjectItem)
        {
          // create lib string
          QString tmpLibDir=sItem->getLibAddPath(myProjectItem->getDownDirs());
          
          QStringList::Iterator it=libDirList.begin();
          for(;it!=libDirList.end();++it)
          {

            if((*it).find(tmpLibDir)>=0 && tmpLibDir!="" && !tmpLibDir.isEmpty()){
              kdDebug()<<"remove from LIBDIR   "<<(*it).ascii()<<"   tmpLib="<<tmpLibDir.ascii()<<""<<endl;
              libDirList.remove(it);
              it=libDirList.begin();
            }
          }
        }
      }
    }
    item=itemList.next();
  }

  //all other in libList are outside libs
  QStringList::Iterator it1=libDirList.begin();
  for(;it1!=libDirList.end();++it1)
  {
      kdDebug()<<"create LIBDIR item  "<<(*it1).ascii()<<endl;
      new QListViewItem(outsidelibdir_listview,outsidelibdir_listview->lastItem(),(*it1));
  }
  
}


void ProjectConfigurationDlg::slotStaticLibClicked(int)
{
  if (staticRadio->isChecked())
  {
    libAddTab->setEnabled(false);
    libPathTab->setEnabled(false);
  } else {
    libAddTab->setEnabled(true);
    libPathTab->setEnabled(true);
  }
}


void ProjectConfigurationDlg::templateLibraryClicked(int)
{
  if (radioLibrary->isChecked())
  {
    libGroup->setEnabled(true);  
  } else {
    libGroup->setEnabled(false);
  }
}
void ProjectConfigurationDlg::clickSubdirsTemplate()
{
  if (radioSubdirs->isChecked())
  {
    m_targetPath->setEnabled(false);
    m_targetOutputFile->setEnabled(false);
    Browse->setEnabled(false);
    libGroup->setEnabled(false);
    buildOrderTab->setEnabled(true);
    corbaTab->setEnabled(false);
  }
  else   
  {
    m_targetPath->setEnabled(true);
    m_targetOutputFile->setEnabled(true);
    Browse->setEnabled(true);
    buildOrderTab->setEnabled(false);
    if (radioLibrary->isChecked()) libGroup->setEnabled(true);
    else libGroup->setEnabled(false);
    corbaTab->setEnabled(true);
  }
}



//build order buttons
void ProjectConfigurationDlg::buildorderMoveUpClicked()
{
    if (buildorder_listview->currentItem() == buildorder_listview->firstChild()) {
        KNotifyClient::beep();
        return;
    }

    QListViewItem *item = buildorder_listview->firstChild();
    while (item->nextSibling() != buildorder_listview->currentItem())
        item = item->nextSibling();
    item->moveItem(buildorder_listview->currentItem());
}


void ProjectConfigurationDlg::buildorderMoveDownClicked()
{
   if (buildorder_listview->currentItem() == 0 || buildorder_listview->currentItem()->nextSibling() == 0) {
        KNotifyClient::beep();
        return;
   }

   buildorder_listview->currentItem()->moveItem(buildorder_listview->currentItem()->nextSibling());
}







//Include dir buttons
void ProjectConfigurationDlg::insideIncMoveUpClicked()
{
    if (insideinc_listview->currentItem() == insideinc_listview->firstChild()) {
        KNotifyClient::beep();
        return;
    }

    QListViewItem *item = insideinc_listview->firstChild();
    while (item->nextSibling() != insideinc_listview->currentItem())
        item = item->nextSibling();
    item->moveItem(insideinc_listview->currentItem());
}


void ProjectConfigurationDlg::insideIncMoveDownClicked()
{
   if (insideinc_listview->currentItem() == 0 || insideinc_listview->currentItem()->nextSibling() == 0) {
        KNotifyClient::beep();
        return;
   }

   insideinc_listview->currentItem()->moveItem(insideinc_listview->currentItem()->nextSibling());
}


void ProjectConfigurationDlg::outsideIncMoveUpClicked()
{
    if (outsideinc_listview->currentItem() == outsideinc_listview->firstChild()) {
        KNotifyClient::beep();
        return;
    }

    QListViewItem *item = outsideinc_listview->firstChild();
    while (item->nextSibling() != outsideinc_listview->currentItem())
        item = item->nextSibling();
    item->moveItem(outsideinc_listview->currentItem());
}


void ProjectConfigurationDlg::outsideIncMoveDownClicked()
{
   if (outsideinc_listview->currentItem() == 0 || outsideinc_listview->currentItem()->nextSibling() == 0) {
        KNotifyClient::beep();
        return;
   }

   outsideinc_listview->currentItem()->moveItem(outsideinc_listview->currentItem()->nextSibling());
}


void ProjectConfigurationDlg::outsideIncAddClicked()
{
    bool ok;
    QString dir = KLineEditDlg::getText(i18n("Add include directory:"), "", &ok, 0);
    if (ok && !dir.isEmpty() && dir != "-I")
        new QListViewItem(outsideinc_listview, dir);
}


void ProjectConfigurationDlg::outsideIncRemoveClicked()
{
    delete outsideinc_listview->currentItem();
}










//libadd buttons
void ProjectConfigurationDlg::insideLibMoveUpClicked()
{
    if (insidelib_listview->currentItem() == insidelib_listview->firstChild()) {
        KNotifyClient::beep();
        return;
    }

    QListViewItem *item = insidelib_listview->firstChild();
    while (item->nextSibling() != insidelib_listview->currentItem())
        item = item->nextSibling();
    item->moveItem(insidelib_listview->currentItem());
}


void ProjectConfigurationDlg::insideLibMoveDownClicked()
{
   if (insidelib_listview->currentItem() == 0 || insidelib_listview->currentItem()->nextSibling() == 0) {
        KNotifyClient::beep();
        return;
   }

   insidelib_listview->currentItem()->moveItem(insidelib_listview->currentItem()->nextSibling());
}


void ProjectConfigurationDlg::outsideLibMoveUpClicked()
{
    if (outsidelib_listview->currentItem() == outsidelib_listview->firstChild()) {
        KNotifyClient::beep();
        return;
    }

    QListViewItem *item = outsidelib_listview->firstChild();
    while (item->nextSibling() != outsidelib_listview->currentItem())
        item = item->nextSibling();
    item->moveItem(outsidelib_listview->currentItem());
}


void ProjectConfigurationDlg::outsideLibMoveDownClicked()
{
   if (outsidelib_listview->currentItem() == 0 || outsidelib_listview->currentItem()->nextSibling() == 0) {
        KNotifyClient::beep();
        return;
   }

   outsidelib_listview->currentItem()->moveItem(outsidelib_listview->currentItem()->nextSibling());
}


void ProjectConfigurationDlg::outsideLibAddClicked()
{
    bool ok;
    QString dir = KLineEditDlg::getText(i18n("Add library to link:"), "-l", &ok, 0);
    if (ok && !dir.isEmpty() && dir != "-I")
        new QListViewItem(outsidelib_listview, dir);
}


void ProjectConfigurationDlg::outsideLibRemoveClicked()
{
    delete outsidelib_listview->currentItem();
}



//lib paths buttons


void ProjectConfigurationDlg::outsideLibDirMoveUpClicked()
{
    if (outsidelibdir_listview->currentItem() == outsidelibdir_listview->firstChild()) {
        KNotifyClient::beep();
        return;
    }

    QListViewItem *item = outsidelibdir_listview->firstChild();
    while (item->nextSibling() != outsidelibdir_listview->currentItem())
        item = item->nextSibling();
    item->moveItem(outsidelibdir_listview->currentItem());
}


void ProjectConfigurationDlg::outsideLibDirMoveDownClicked()
{
   if (outsidelibdir_listview->currentItem() == 0 || outsidelibdir_listview->currentItem()->nextSibling() == 0) {
        KNotifyClient::beep();
        return;
   }

   outsidelibdir_listview->currentItem()->moveItem(outsidelibdir_listview->currentItem()->nextSibling());
}


void ProjectConfigurationDlg::outsideLibDirAddClicked()
{
    bool ok;
    QString dir = KLineEditDlg::getText(i18n("Add library directory:"), "", &ok, 0);
    if (ok && !dir.isEmpty() && dir != "-I")
        new QListViewItem(outsidelibdir_listview, dir);
}


void ProjectConfigurationDlg::outsideLibDirRemoveClicked()
{
    delete outsidelibdir_listview->currentItem();
}

void ProjectConfigurationDlg::outsideIncEditClicked()
{
    bool ok;
    QListViewItem *item=outsideinc_listview->currentItem();
    if(item==NULL)return;
    QString text=item->text(0);
    QString dir = KLineEditDlg::getText(i18n("Change include directory:"), text, &ok, 0);
    if (ok && !dir.isEmpty() && dir != "-I")
        item->setText(0,dir);
  
}

void ProjectConfigurationDlg::outsideLibEditClicked()
{
    bool ok;
    QListViewItem *item=outsidelib_listview->currentItem();
    if(item==NULL)return;
    QString text=item->text(0);
    QString dir = KLineEditDlg::getText(i18n("Change library to link:"), text, &ok, 0);
    if (ok && !dir.isEmpty() && dir != "-l")
        item->setText(0,dir);
  
}

void ProjectConfigurationDlg::outsideLibDirEditClicked()
{
    bool ok;
    QListViewItem *item=outsidelibdir_listview->currentItem();
    if(item==NULL)return;
    QString text=item->text(0);
    QString dir = KLineEditDlg::getText(i18n("Change library directory:"), text, &ok, 0);
    if (ok && !dir.isEmpty() && dir != "-l")
        item->setText(0,dir);
  
}

void ProjectConfigurationDlg::slotInstallTargetClicked()
{
  if (checkInstallTarget->isChecked() == true)
    m_InstallTargetPath->setEnabled(true);
  else
    m_InstallTargetPath->setEnabled(false);
}
