/*
 * main.cpp
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <klocale.h>
#include <kprocess.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qlayout.h>
#include <qlayout.h>

#include "main.h"
#include "warning.h"
#include "power.h"
#include "battery.h"
#include "pcmcia.h"
#include "portable.h"


extern "C"
{

  KCModule *create_pcmcia(QWidget *parent, const char *)
  {
    return new PcmciaConfig(parent, "kcmlaptop");
  }

  KCModule *create_bwarning(QWidget *parent, const char *)
  {
    return new WarningConfig(0, parent, "kcmlaptop");
  }
  KCModule *create_cwarning(QWidget *parent, const char *)
  {
    return new WarningConfig(1, parent, "kcmlaptop");
  }
  KCModule *create_battery(QWidget *parent, const char *)
  {
    return new BatteryConfig(parent, "kcmlaptop");
  }
  KCModule *create_power(QWidget *parent, const char *)
  {
    return new PowerConfig(parent, "kcmlaptop");
  }

  void init_battery()
  {
    KConfig config("kcmlaptoprc", true /*readonly*/, false /*no globals*/);
    config.setGroup("BatteryDefault");
    bool enable = false;
    if (!config.hasKey("Enable")) {  // if they have APM or PCMCIA, Enable=true
	struct power_result pr = laptop_portable::poll_battery_state();
	if ((laptop_portable::has_power_management() &&
             !(pr.powered &&
              (pr.percentage < 0 || pr.percentage == 0xff)))||
	    0 == access("/var/run/stab", R_OK|F_OK) ||
	    0 == access("/var/lib/pcmcia/stab", R_OK|F_OK))
		enable = true;
    } else {
	    enable = config.readBoolEntry("Enable", false);
    }
    if (!enable)
      return;
    kapp->startServiceByDesktopName("klaptopdaemon");
  }

  KCModule *create_laptop(QWidget *parent, const char *)
  {
	return new LaptopModule(parent, "kcmlaptop");
  }

  void init_laptop()
  {
	init_battery();
  }
}



LaptopModule::LaptopModule(QWidget *parent, const char *)
  : KCModule(parent, "kcmlaptop")
{
  QVBoxLayout *layout = new QVBoxLayout(this);
  tab = new QTabWidget(this);
  layout->addWidget(tab);

  battery = new BatteryConfig(parent, "kcmlaptop");
  tab->addTab(battery, i18n("&Battery"));
  connect(battery, SIGNAL(changed(bool)), this, SLOT(moduleChanged(bool)));

  power = new PowerConfig(parent, "kcmlaptop");
  tab->addTab(power, i18n("&Power Control"));
  connect(power, SIGNAL(changed(bool)), this, SLOT(moduleChanged(bool)));

  warning = new WarningConfig(0, parent, "kcmlaptop");
  tab->addTab(warning, i18n("Low Battery &Warning"));
  connect(warning, SIGNAL(changed(bool)), this, SLOT(moduleChanged(bool)));

  critical = new WarningConfig(1, parent, "kcmlaptop");
  tab->addTab(critical, i18n("Low Battery &Critical"));
  connect(critical, SIGNAL(changed(bool)), this, SLOT(moduleChanged(bool)));

}

void LaptopModule::load()
{
  battery->load();
  warning->load();
  critical->load();
  power->load();
}

void LaptopModule::save()
{
  battery->save();
  warning->save();
  critical->save();
  power->save();
}


void LaptopModule::defaults()
{
    battery->defaults();
  warning->defaults();
  critical->defaults();
  power->defaults();
}

QString LaptopModule::quickHelp() const
{
  return i18n("<h1>Battery Monitor</h1>This module allows you to monitor "
        "your batteries. To make use of this module, you must have APM "
        "or ACPI installed. (And, of course, you should have batteries in your "
        "machine.)");
}


void LaptopModule::moduleChanged(bool state)
{
  emit changed(state);
}


#include "main.moc"
