#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>

SEQ_DEFINEBUF (1024);
int             seqfd;

void
seqbuf_dump ()
{
  if (_seqbufptr)
    if (write (seqfd, _seqbuf, _seqbufptr) == -1)
      {
	perror ("write /dev/sequencer2");
	exit (-1);
      }
  _seqbufptr = 0;
}

int
main (int argc, char *argv[])
{
  int             mode = 0;
  int             i;

  if (argc > 1)
    {
      for (i = 1; i < argc; i++)
	{
	  if (!strcmp (argv[i], "internal"))
	    mode |= TMR_INTERNAL;
	  else if (!strcmp (argv[i], "external"))
	    mode |= TMR_EXTERNAL;
	  else if (!strcmp (argv[i], "midi"))
	    mode |= TMR_MODE_MIDI;
	  else if (!strcmp (argv[i], "fsk"))
	    mode |= TMR_MODE_FSK;
	  else if (!strcmp (argv[i], "cls"))
	    mode |= TMR_MODE_CLS;
	  else if (!strcmp (argv[i], "smpte"))
	    mode |= TMR_MODE_SMPTE;
	  else
	    {
	      fprintf (stderr, "Invalid mode %s\n", argv[i]);
	      exit (-1);
	    }
	}

      if (!(mode & (TMR_INTERNAL | TMR_EXTERNAL)))
	mode |= TMR_INTERNAL;
    }

  if ((seqfd = open ("/dev/sequencer2", O_RDWR, 0)) == -1)
    {
      perror ("/dev/sequencer2");
      exit (-1);
    }

  if (ioctl (seqfd, SNDCTL_TMR_SOURCE, &mode) == -1)
    perror ("Set timer source");

  printf ("Timer source = %08x: ", mode);

  if (mode & TMR_INTERNAL) printf("internal ");
  if (mode & TMR_EXTERNAL) printf("external ");

  if (mode & TMR_MODE_MIDI) printf("midi ");
  if (mode & TMR_MODE_FSK) printf("fsk ");
  if (mode & TMR_MODE_CLS) printf("cls ");
  if (mode & TMR_MODE_SMPTE) printf("smpte ");
  printf("\n");

  exit (0);
}
