#!/bin/bash
# turn shadow passwords on or off on a Debian system

set -e

function permfix {
    [ -f $1 ] || return 0
    chown root.shadow $1
    chmod 2755 $1
}
export -f permfix

function shadowon {
bash<<- EOF
    set -e

    if killall -0 xdm 2>/dev/null ; then
	echo You must quit xdm before turning on shadow passwords.
	exit 1
    fi

    permfix /usr/X11R6/bin/xlock
    permfix /usr/X11R6/bin/xtrlock
    permfix /bin/vlock

    # xdm-shadow works fine with non-shadowed systems also, so it's
    # not necessary to reverse this in shadowoff
    # do it only if /etc/init.d/xdm exists (Bug#9189)

    # no longer necessary with XFree86-3.3.  --marekm

#   if [ -f /etc/init.d/xdm ] ; then
#	cd /etc/init.d/
#	if ! grep -q 'xdm-shadow' xdm ; then
#	    sed -e 's:/usr/bin/X11/xdm:/usr/bin/X11/xdm-shadow:' xdm > shadowxdm$$
#	    mv shadowxdm$$ xdm
#	    chmod 755 xdm
#	fi
#   fi

    pwck -e
    grpck
    pwconv
    grpconv
    cd /etc
    chown root.root passwd group
    chmod 644 passwd group
    chown root.shadow shadow gshadow
    chmod 640 shadow gshadow
EOF
}


function shadowoff {
bash<<- EOF
    set -e
    pwck -e
    grpck
    pwunconv
    grpunconv
EOF
}


case "$1" in
    "on")
	if shadowon ; then
	    echo Shadow passwords are now on.
	else
	    echo Please correct the error and rerun \`$0 on\'
	    exit 1
	fi
	;;
    "off")
	if shadowoff ; then
	    echo Shadow passwords are now off.
	else
	    echo Please correct the error and rerun \`$0 off\'
	    exit 1
	fi
	;;
     *)
	echo Usage: $0 on \| off
	;;
esac
