; RUN: llc -march=amdgcn -mcpu=SI < %s | FileCheck %s
; RUN: llc -march=amdgcn -mcpu=tonga < %s | FileCheck %s

; These tests check that the compiler won't crash when it needs to spill
; SGPRs.

; CHECK-LABEL: {{^}}main:
; CHECK: s_wqm

; Make sure not emitting unused scratch resource descriptor setup
; CHECK-NOT: s_mov_b32
; CHECK-NOT: s_mov_b32
; CHECK-NOT: s_mov_b32
; CHECK-NOT: s_mov_b32

; CHECK: s_mov_b32 m0


; Writing to M0 from an SMRD instruction will hang the GPU.
; CHECK-NOT: s_buffer_load_dword m0
; CHECK: s_endpgm
@ddxy_lds = external addrspace(3) global [64 x i32]

define void @main([17 x <16 x i8>] addrspace(2)* byval, [32 x <16 x i8>] addrspace(2)* byval, [16 x <32 x i8>] addrspace(2)* byval, float inreg, i32 inreg, <2 x i32>, <2 x i32>, <2 x i32>, <3 x i32>, <2 x i32>, <2 x i32>, <2 x i32>, float, float, float, float, float, float, float, float, float) #0 {
main_body:
  %21 = getelementptr [17 x <16 x i8>], [17 x <16 x i8>] addrspace(2)* %0, i64 0, i32 0
  %22 = load <16 x i8>, <16 x i8> addrspace(2)* %21, !tbaa !0
  %23 = call float @llvm.SI.load.const(<16 x i8> %22, i32 96)
  %24 = call float @llvm.SI.load.const(<16 x i8> %22, i32 100)
  %25 = call float @llvm.SI.load.const(<16 x i8> %22, i32 104)
  %26 = call float @llvm.SI.load.const(<16 x i8> %22, i32 112)
  %27 = call float @llvm.SI.load.const(<16 x i8> %22, i32 116)
  %28 = call float @llvm.SI.load.const(<16 x i8> %22, i32 120)
  %29 = call float @llvm.SI.load.const(<16 x i8> %22, i32 128)
  %30 = call float @llvm.SI.load.const(<16 x i8> %22, i32 132)
  %31 = call float @llvm.SI.load.const(<16 x i8> %22, i32 140)
  %32 = call float @llvm.SI.load.const(<16 x i8> %22, i32 144)
  %33 = call float @llvm.SI.load.const(<16 x i8> %22, i32 160)
  %34 = call float @llvm.SI.load.const(<16 x i8> %22, i32 176)
  %35 = call float @llvm.SI.load.const(<16 x i8> %22, i32 180)
  %36 = call float @llvm.SI.load.const(<16 x i8> %22, i32 184)
  %37 = call float @llvm.SI.load.const(<16 x i8> %22, i32 192)
  %38 = call float @llvm.SI.load.const(<16 x i8> %22, i32 196)
  %39 = call float @llvm.SI.load.const(<16 x i8> %22, i32 200)
  %40 = call float @llvm.SI.load.const(<16 x i8> %22, i32 208)
  %41 = call float @llvm.SI.load.const(<16 x i8> %22, i32 212)
  %42 = call float @llvm.SI.load.const(<16 x i8> %22, i32 216)
  %43 = call float @llvm.SI.load.const(<16 x i8> %22, i32 224)
  %44 = call float @llvm.SI.load.const(<16 x i8> %22, i32 240)
  %45 = call float @llvm.SI.load.const(<16 x i8> %22, i32 244)
  %46 = call float @llvm.SI.load.const(<16 x i8> %22, i32 248)
  %47 = call float @llvm.SI.load.const(<16 x i8> %22, i32 256)
  %48 = call float @llvm.SI.load.const(<16 x i8> %22, i32 272)
  %49 = call float @llvm.SI.load.const(<16 x i8> %22, i32 276)
  %50 = call float @llvm.SI.load.const(<16 x i8> %22, i32 280)
  %51 = call float @llvm.SI.load.const(<16 x i8> %22, i32 288)
  %52 = call float @llvm.SI.load.const(<16 x i8> %22, i32 292)
  %53 = call float @llvm.SI.load.const(<16 x i8> %22, i32 296)
  %54 = call float @llvm.SI.load.const(<16 x i8> %22, i32 304)
  %55 = call float @llvm.SI.load.const(<16 x i8> %22, i32 308)
  %56 = call float @llvm.SI.load.const(<16 x i8> %22, i32 312)
  %57 = call float @llvm.SI.load.const(<16 x i8> %22, i32 368)
  %58 = call float @llvm.SI.load.const(<16 x i8> %22, i32 372)
  %59 = call float @llvm.SI.load.const(<16 x i8> %22, i32 376)
  %60 = call float @llvm.SI.load.const(<16 x i8> %22, i32 384)
  %61 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 0
  %62 = load <32 x i8>, <32 x i8> addrspace(2)* %61, !tbaa !0
  %63 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 0
  %64 = load <16 x i8>, <16 x i8> addrspace(2)* %63, !tbaa !0
  %65 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 1
  %66 = load <32 x i8>, <32 x i8> addrspace(2)* %65, !tbaa !0
  %67 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 1
  %68 = load <16 x i8>, <16 x i8> addrspace(2)* %67, !tbaa !0
  %69 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 2
  %70 = load <32 x i8>, <32 x i8> addrspace(2)* %69, !tbaa !0
  %71 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 2
  %72 = load <16 x i8>, <16 x i8> addrspace(2)* %71, !tbaa !0
  %73 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 3
  %74 = load <32 x i8>, <32 x i8> addrspace(2)* %73, !tbaa !0
  %75 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 3
  %76 = load <16 x i8>, <16 x i8> addrspace(2)* %75, !tbaa !0
  %77 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 4
  %78 = load <32 x i8>, <32 x i8> addrspace(2)* %77, !tbaa !0
  %79 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 4
  %80 = load <16 x i8>, <16 x i8> addrspace(2)* %79, !tbaa !0
  %81 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 5
  %82 = load <32 x i8>, <32 x i8> addrspace(2)* %81, !tbaa !0
  %83 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 5
  %84 = load <16 x i8>, <16 x i8> addrspace(2)* %83, !tbaa !0
  %85 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 6
  %86 = load <32 x i8>, <32 x i8> addrspace(2)* %85, !tbaa !0
  %87 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 6
  %88 = load <16 x i8>, <16 x i8> addrspace(2)* %87, !tbaa !0
  %89 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 7
  %90 = load <32 x i8>, <32 x i8> addrspace(2)* %89, !tbaa !0
  %91 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 7
  %92 = load <16 x i8>, <16 x i8> addrspace(2)* %91, !tbaa !0
  %93 = call float @llvm.SI.fs.interp(i32 0, i32 0, i32 %4, <2 x i32> %6)
  %94 = call float @llvm.SI.fs.interp(i32 1, i32 0, i32 %4, <2 x i32> %6)
  %95 = call float @llvm.SI.fs.interp(i32 0, i32 1, i32 %4, <2 x i32> %6)
  %96 = call float @llvm.SI.fs.interp(i32 1, i32 1, i32 %4, <2 x i32> %6)
  %97 = call float @llvm.SI.fs.interp(i32 2, i32 1, i32 %4, <2 x i32> %6)
  %98 = call float @llvm.SI.fs.interp(i32 0, i32 2, i32 %4, <2 x i32> %6)
  %99 = call float @llvm.SI.fs.interp(i32 1, i32 2, i32 %4, <2 x i32> %6)
  %100 = call float @llvm.SI.fs.interp(i32 2, i32 2, i32 %4, <2 x i32> %6)
  %101 = call float @llvm.SI.fs.interp(i32 0, i32 3, i32 %4, <2 x i32> %6)
  %102 = call float @llvm.SI.fs.interp(i32 1, i32 3, i32 %4, <2 x i32> %6)
  %103 = call float @llvm.SI.fs.interp(i32 2, i32 3, i32 %4, <2 x i32> %6)
  %104 = call float @llvm.SI.fs.interp(i32 0, i32 4, i32 %4, <2 x i32> %6)
  %105 = call float @llvm.SI.fs.interp(i32 1, i32 4, i32 %4, <2 x i32> %6)
  %106 = call float @llvm.SI.fs.interp(i32 2, i32 4, i32 %4, <2 x i32> %6)
  %107 = call float @llvm.SI.fs.interp(i32 0, i32 5, i32 %4, <2 x i32> %6)
  %108 = call float @llvm.SI.fs.interp(i32 1, i32 5, i32 %4, <2 x i32> %6)
  %109 = call float @llvm.SI.fs.interp(i32 2, i32 5, i32 %4, <2 x i32> %6)
  %110 = call i32 @llvm.SI.tid()
  %111 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %110
  %112 = bitcast float %93 to i32
  store i32 %112, i32 addrspace(3)* %111
  %113 = bitcast float %94 to i32
  store i32 %113, i32 addrspace(3)* %111
  %114 = call i32 @llvm.SI.tid()
  %115 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %114
  %116 = and i32 %114, -4
  %117 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %116
  %118 = add i32 %116, 1
  %119 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %118
  %120 = bitcast float %93 to i32
  store i32 %120, i32 addrspace(3)* %115
  %121 = load i32, i32 addrspace(3)* %117
  %122 = bitcast i32 %121 to float
  %123 = load i32, i32 addrspace(3)* %119
  %124 = bitcast i32 %123 to float
  %125 = fsub float %124, %122
  %126 = bitcast float %94 to i32
  store i32 %126, i32 addrspace(3)* %115
  %127 = load i32, i32 addrspace(3)* %117
  %128 = bitcast i32 %127 to float
  %129 = load i32, i32 addrspace(3)* %119
  %130 = bitcast i32 %129 to float
  %131 = fsub float %130, %128
  %132 = insertelement <4 x float> undef, float %125, i32 0
  %133 = insertelement <4 x float> %132, float %131, i32 1
  %134 = insertelement <4 x float> %133, float %131, i32 2
  %135 = insertelement <4 x float> %134, float %131, i32 3
  %136 = extractelement <4 x float> %135, i32 0
  %137 = extractelement <4 x float> %135, i32 1
  %138 = fmul float %60, %93
  %139 = fmul float %60, %94
  %140 = fmul float %60, %94
  %141 = fmul float %60, %94
  %142 = call i32 @llvm.SI.tid()
  %143 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %142
  %144 = bitcast float %138 to i32
  store i32 %144, i32 addrspace(3)* %143
  %145 = bitcast float %139 to i32
  store i32 %145, i32 addrspace(3)* %143
  %146 = bitcast float %140 to i32
  store i32 %146, i32 addrspace(3)* %143
  %147 = bitcast float %141 to i32
  store i32 %147, i32 addrspace(3)* %143
  %148 = call i32 @llvm.SI.tid()
  %149 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %148
  %150 = and i32 %148, -4
  %151 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %150
  %152 = add i32 %150, 2
  %153 = getelementptr [64 x i32], [64 x i32] addrspace(3)* @ddxy_lds, i32 0, i32 %152
  %154 = bitcast float %138 to i32
  store i32 %154, i32 addrspace(3)* %149
  %155 = load i32, i32 addrspace(3)* %151
  %156 = bitcast i32 %155 to float
  %157 = load i32, i32 addrspace(3)* %153
  %158 = bitcast i32 %157 to float
  %159 = fsub float %158, %156
  %160 = bitcast float %139 to i32
  store i32 %160, i32 addrspace(3)* %149
  %161 = load i32, i32 addrspace(3)* %151
  %162 = bitcast i32 %161 to float
  %163 = load i32, i32 addrspace(3)* %153
  %164 = bitcast i32 %163 to float
  %165 = fsub float %164, %162
  %166 = bitcast float %140 to i32
  store i32 %166, i32 addrspace(3)* %149
  %167 = load i32, i32 addrspace(3)* %151
  %168 = bitcast i32 %167 to float
  %169 = load i32, i32 addrspace(3)* %153
  %170 = bitcast i32 %169 to float
  %171 = fsub float %170, %168
  %172 = bitcast float %141 to i32
  store i32 %172, i32 addrspace(3)* %149
  %173 = load i32, i32 addrspace(3)* %151
  %174 = bitcast i32 %173 to float
  %175 = load i32, i32 addrspace(3)* %153
  %176 = bitcast i32 %175 to float
  %177 = fsub float %176, %174
  %178 = insertelement <4 x float> undef, float %159, i32 0
  %179 = insertelement <4 x float> %178, float %165, i32 1
  %180 = insertelement <4 x float> %179, float %171, i32 2
  %181 = insertelement <4 x float> %180, float %177, i32 3
  %182 = extractelement <4 x float> %181, i32 0
  %183 = extractelement <4 x float> %181, i32 1
  %184 = fdiv float 1.000000e+00, %97
  %185 = fmul float %33, %184
  %186 = fcmp uge float 1.000000e+00, %185
  %187 = select i1 %186, float %185, float 1.000000e+00
  %188 = fmul float %187, %30
  %189 = call float @ceil(float %188)
  %190 = fcmp uge float 3.000000e+00, %189
  %191 = select i1 %190, float 3.000000e+00, float %189
  %192 = fdiv float 1.000000e+00, %191
  %193 = fdiv float 1.000000e+00, %30
  %194 = fmul float %191, %193
  %195 = fmul float %31, %194
  %196 = fmul float %95, %95
  %197 = fmul float %96, %96
  %198 = fadd float %197, %196
  %199 = fmul float %97, %97
  %200 = fadd float %198, %199
  %201 = call float @llvm.AMDGPU.rsq.f32(float %200)
  %202 = fmul float %95, %201
  %203 = fmul float %96, %201
  %204 = fmul float %202, %29
  %205 = fmul float %203, %29
  %206 = fmul float %204, -1.000000e+00
  %207 = fmul float %205, 1.000000e+00
  %208 = fmul float %206, %32
  %209 = fmul float %207, %32
  %210 = fsub float -0.000000e+00, %208
  %211 = fadd float %93, %210
  %212 = fsub float -0.000000e+00, %209
  %213 = fadd float %94, %212
  %214 = fmul float %206, %192
  %215 = fmul float %207, %192
  %216 = fmul float -1.000000e+00, %192
  %217 = bitcast float %136 to i32
  %218 = bitcast float %182 to i32
  %219 = bitcast float %137 to i32
  %220 = bitcast float %183 to i32
  %221 = insertelement <8 x i32> undef, i32 %217, i32 0
  %222 = insertelement <8 x i32> %221, i32 %218, i32 1
  %223 = insertelement <8 x i32> %222, i32 %219, i32 2
  %224 = insertelement <8 x i32> %223, i32 %220, i32 3
  br label %LOOP

LOOP:                                             ; preds = %ENDIF, %main_body
  %temp24.0 = phi float [ 1.000000e+00, %main_body ], [ %258, %ENDIF ]
  %temp28.0 = phi float [ %211, %main_body ], [ %253, %ENDIF ]
  %temp29.0 = phi float [ %213, %main_body ], [ %255, %ENDIF ]
  %temp30.0 = phi float [ 1.000000e+00, %main_body ], [ %257, %ENDIF ]
  %225 = fcmp oge float %temp24.0, %191
  %226 = sext i1 %225 to i32
  %227 = bitcast i32 %226 to float
  %228 = bitcast float %227 to i32
  %229 = icmp ne i32 %228, 0
  br i1 %229, label %IF, label %ENDIF

IF:                                               ; preds = %LOOP
  %230 = bitcast float %136 to i32
  %231 = bitcast float %182 to i32
  %232 = bitcast float %137 to i32
  %233 = bitcast float %183 to i32
  %234 = insertelement <8 x i32> undef, i32 %230, i32 0
  %235 = insertelement <8 x i32> %234, i32 %231, i32 1
  %236 = insertelement <8 x i32> %235, i32 %232, i32 2
  %237 = insertelement <8 x i32> %236, i32 %233, i32 3
  br label %LOOP65

ENDIF:                                            ; preds = %LOOP
  %238 = bitcast float %temp28.0 to i32
  %239 = bitcast float %temp29.0 to i32
  %240 = insertelement <8 x i32> %224, i32 %238, i32 4
  %241 = insertelement <8 x i32> %240, i32 %239, i32 5
  %242 = insertelement <8 x i32> %241, i32 undef, i32 6
  %243 = insertelement <8 x i32> %242, i32 undef, i32 7
  %244 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %243, <32 x i8> %62, <16 x i8> %64, i32 2)
  %245 = extractelement <4 x float> %244, i32 3
  %246 = fcmp oge float %temp30.0, %245
  %247 = sext i1 %246 to i32
  %248 = bitcast i32 %247 to float
  %249 = bitcast float %248 to i32
  %250 = and i32 %249, 1065353216
  %251 = bitcast i32 %250 to float
  %252 = fmul float %214, %251
  %253 = fadd float %252, %temp28.0
  %254 = fmul float %215, %251
  %255 = fadd float %254, %temp29.0
  %256 = fmul float %216, %251
  %257 = fadd float %256, %temp30.0
  %258 = fadd float %temp24.0, 1.000000e+00
  br label %LOOP

LOOP65:                                           ; preds = %ENDIF66, %IF
  %temp24.1 = phi float [ 0.000000e+00, %IF ], [ %610, %ENDIF66 ]
  %temp28.1 = phi float [ %temp28.0, %IF ], [ %605, %ENDIF66 ]
  %temp29.1 = phi float [ %temp29.0, %IF ], [ %607, %ENDIF66 ]
  %temp30.1 = phi float [ %temp30.0, %IF ], [ %609, %ENDIF66 ]
  %temp32.0 = phi float [ 1.000000e+00, %IF ], [ %611, %ENDIF66 ]
  %259 = fcmp oge float %temp24.1, %195
  %260 = sext i1 %259 to i32
  %261 = bitcast i32 %260 to float
  %262 = bitcast float %261 to i32
  %263 = icmp ne i32 %262, 0
  br i1 %263, label %IF67, label %ENDIF66

IF67:                                             ; preds = %LOOP65
  %264 = bitcast float %136 to i32
  %265 = bitcast float %182 to i32
  %266 = bitcast float %137 to i32
  %267 = bitcast float %183 to i32
  %268 = bitcast float %temp28.1 to i32
  %269 = bitcast float %temp29.1 to i32
  %270 = insertelement <8 x i32> undef, i32 %264, i32 0
  %271 = insertelement <8 x i32> %270, i32 %265, i32 1
  %272 = insertelement <8 x i32> %271, i32 %266, i32 2
  %273 = insertelement <8 x i32> %272, i32 %267, i32 3
  %274 = insertelement <8 x i32> %273, i32 %268, i32 4
  %275 = insertelement <8 x i32> %274, i32 %269, i32 5
  %276 = insertelement <8 x i32> %275, i32 undef, i32 6
  %277 = insertelement <8 x i32> %276, i32 undef, i32 7
  %278 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %277, <32 x i8> %66, <16 x i8> %68, i32 2)
  %279 = extractelement <4 x float> %278, i32 0
  %280 = extractelement <4 x float> %278, i32 1
  %281 = extractelement <4 x float> %278, i32 2
  %282 = extractelement <4 x float> %278, i32 3
  %283 = fmul float %282, %47
  %284 = bitcast float %136 to i32
  %285 = bitcast float %182 to i32
  %286 = bitcast float %137 to i32
  %287 = bitcast float %183 to i32
  %288 = bitcast float %temp28.1 to i32
  %289 = bitcast float %temp29.1 to i32
  %290 = insertelement <8 x i32> undef, i32 %284, i32 0
  %291 = insertelement <8 x i32> %290, i32 %285, i32 1
  %292 = insertelement <8 x i32> %291, i32 %286, i32 2
  %293 = insertelement <8 x i32> %292, i32 %287, i32 3
  %294 = insertelement <8 x i32> %293, i32 %288, i32 4
  %295 = insertelement <8 x i32> %294, i32 %289, i32 5
  %296 = insertelement <8 x i32> %295, i32 undef, i32 6
  %297 = insertelement <8 x i32> %296, i32 undef, i32 7
  %298 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %297, <32 x i8> %82, <16 x i8> %84, i32 2)
  %299 = extractelement <4 x float> %298, i32 0
  %300 = extractelement <4 x float> %298, i32 1
  %301 = extractelement <4 x float> %298, i32 2
  %302 = bitcast float %136 to i32
  %303 = bitcast float %182 to i32
  %304 = bitcast float %137 to i32
  %305 = bitcast float %183 to i32
  %306 = bitcast float %temp28.1 to i32
  %307 = bitcast float %temp29.1 to i32
  %308 = insertelement <8 x i32> undef, i32 %302, i32 0
  %309 = insertelement <8 x i32> %308, i32 %303, i32 1
  %310 = insertelement <8 x i32> %309, i32 %304, i32 2
  %311 = insertelement <8 x i32> %310, i32 %305, i32 3
  %312 = insertelement <8 x i32> %311, i32 %306, i32 4
  %313 = insertelement <8 x i32> %312, i32 %307, i32 5
  %314 = insertelement <8 x i32> %313, i32 undef, i32 6
  %315 = insertelement <8 x i32> %314, i32 undef, i32 7
  %316 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %315, <32 x i8> %78, <16 x i8> %80, i32 2)
  %317 = extractelement <4 x float> %316, i32 0
  %318 = extractelement <4 x float> %316, i32 1
  %319 = extractelement <4 x float> %316, i32 2
  %320 = fmul float %317, %23
  %321 = fmul float %318, %24
  %322 = fmul float %319, %25
  %323 = fmul float %299, %26
  %324 = fadd float %323, %320
  %325 = fmul float %300, %27
  %326 = fadd float %325, %321
  %327 = fmul float %301, %28
  %328 = fadd float %327, %322
  %329 = fadd float %279, %324
  %330 = fadd float %280, %326
  %331 = fadd float %281, %328
  %332 = bitcast float %136 to i32
  %333 = bitcast float %182 to i32
  %334 = bitcast float %137 to i32
  %335 = bitcast float %183 to i32
  %336 = bitcast float %temp28.1 to i32
  %337 = bitcast float %temp29.1 to i32
  %338 = insertelement <8 x i32> undef, i32 %332, i32 0
  %339 = insertelement <8 x i32> %338, i32 %333, i32 1
  %340 = insertelement <8 x i32> %339, i32 %334, i32 2
  %341 = insertelement <8 x i32> %340, i32 %335, i32 3
  %342 = insertelement <8 x i32> %341, i32 %336, i32 4
  %343 = insertelement <8 x i32> %342, i32 %337, i32 5
  %344 = insertelement <8 x i32> %343, i32 undef, i32 6
  %345 = insertelement <8 x i32> %344, i32 undef, i32 7
  %346 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %345, <32 x i8> %62, <16 x i8> %64, i32 2)
  %347 = extractelement <4 x float> %346, i32 0
  %348 = extractelement <4 x float> %346, i32 1
  %349 = extractelement <4 x float> %346, i32 2
  %350 = fadd float %347, -5.000000e-01
  %351 = fadd float %348, -5.000000e-01
  %352 = fadd float %349, -5.000000e-01
  %353 = fmul float %350, %350
  %354 = fmul float %351, %351
  %355 = fadd float %354, %353
  %356 = fmul float %352, %352
  %357 = fadd float %355, %356
  %358 = call float @llvm.AMDGPU.rsq.f32(float %357)
  %359 = fmul float %350, %358
  %360 = fmul float %351, %358
  %361 = fmul float %352, %358
  %362 = bitcast float %136 to i32
  %363 = bitcast float %182 to i32
  %364 = bitcast float %137 to i32
  %365 = bitcast float %183 to i32
  %366 = bitcast float %temp28.1 to i32
  %367 = bitcast float %temp29.1 to i32
  %368 = insertelement <8 x i32> undef, i32 %362, i32 0
  %369 = insertelement <8 x i32> %368, i32 %363, i32 1
  %370 = insertelement <8 x i32> %369, i32 %364, i32 2
  %371 = insertelement <8 x i32> %370, i32 %365, i32 3
  %372 = insertelement <8 x i32> %371, i32 %366, i32 4
  %373 = insertelement <8 x i32> %372, i32 %367, i32 5
  %374 = insertelement <8 x i32> %373, i32 undef, i32 6
  %375 = insertelement <8 x i32> %374, i32 undef, i32 7
  %376 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %375, <32 x i8> %70, <16 x i8> %72, i32 2)
  %377 = extractelement <4 x float> %376, i32 0
  %378 = extractelement <4 x float> %376, i32 1
  %379 = extractelement <4 x float> %376, i32 2
  %380 = extractelement <4 x float> %376, i32 3
  %381 = fsub float -0.000000e+00, %95
  %382 = fsub float -0.000000e+00, %96
  %383 = fsub float -0.000000e+00, %97
  %384 = fmul float %359, %381
  %385 = fmul float %360, %382
  %386 = fadd float %385, %384
  %387 = fmul float %361, %383
  %388 = fadd float %386, %387
  %389 = fmul float %388, %359
  %390 = fmul float %388, %360
  %391 = fmul float %388, %361
  %392 = fmul float 2.000000e+00, %389
  %393 = fmul float 2.000000e+00, %390
  %394 = fmul float 2.000000e+00, %391
  %395 = fsub float -0.000000e+00, %392
  %396 = fadd float %381, %395
  %397 = fsub float -0.000000e+00, %393
  %398 = fadd float %382, %397
  %399 = fsub float -0.000000e+00, %394
  %400 = fadd float %383, %399
  %401 = fmul float %396, %98
  %402 = fmul float %396, %99
  %403 = fmul float %396, %100
  %404 = fmul float %398, %101
  %405 = fadd float %404, %401
  %406 = fmul float %398, %102
  %407 = fadd float %406, %402
  %408 = fmul float %398, %103
  %409 = fadd float %408, %403
  %410 = fmul float %400, %104
  %411 = fadd float %410, %405
  %412 = fmul float %400, %105
  %413 = fadd float %412, %407
  %414 = fmul float %400, %106
  %415 = fadd float %414, %409
  %416 = bitcast float %136 to i32
  %417 = bitcast float %182 to i32
  %418 = bitcast float %137 to i32
  %419 = bitcast float %183 to i32
  %420 = bitcast float %temp28.1 to i32
  %421 = bitcast float %temp29.1 to i32
  %422 = insertelement <8 x i32> undef, i32 %416, i32 0
  %423 = insertelement <8 x i32> %422, i32 %417, i32 1
  %424 = insertelement <8 x i32> %423, i32 %418, i32 2
  %425 = insertelement <8 x i32> %424, i32 %419, i32 3
  %426 = insertelement <8 x i32> %425, i32 %420, i32 4
  %427 = insertelement <8 x i32> %426, i32 %421, i32 5
  %428 = insertelement <8 x i32> %427, i32 undef, i32 6
  %429 = insertelement <8 x i32> %428, i32 undef, i32 7
  %430 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %429, <32 x i8> %86, <16 x i8> %88, i32 2)
  %431 = extractelement <4 x float> %430, i32 0
  %432 = extractelement <4 x float> %430, i32 1
  %433 = extractelement <4 x float> %430, i32 2
  %434 = fmul float %48, %411
  %435 = fmul float %49, %411
  %436 = fmul float %50, %411
  %437 = fmul float %51, %413
  %438 = fadd float %437, %434
  %439 = fmul float %52, %413
  %440 = fadd float %439, %435
  %441 = fmul float %53, %413
  %442 = fadd float %441, %436
  %443 = fmul float %54, %415
  %444 = fadd float %443, %438
  %445 = fmul float %55, %415
  %446 = fadd float %445, %440
  %447 = fmul float %56, %415
  %448 = fadd float %447, %442
  %449 = insertelement <4 x float> undef, float %444, i32 0
  %450 = insertelement <4 x float> %449, float %446, i32 1
  %451 = insertelement <4 x float> %450, float %448, i32 2
  %452 = insertelement <4 x float> %451, float %195, i32 3
  %453 = call <4 x float> @llvm.AMDGPU.cube(<4 x float> %452)
  %454 = extractelement <4 x float> %453, i32 0
  %455 = extractelement <4 x float> %453, i32 1
  %456 = extractelement <4 x float> %453, i32 2
  %457 = extractelement <4 x float> %453, i32 3
  %458 = call float @fabs(float %456)
  %459 = fdiv float 1.000000e+00, %458
  %460 = fmul float %454, %459
  %461 = fadd float %460, 1.500000e+00
  %462 = fmul float %455, %459
  %463 = fadd float %462, 1.500000e+00
  %464 = bitcast float %463 to i32
  %465 = bitcast float %461 to i32
  %466 = bitcast float %457 to i32
  %467 = insertelement <4 x i32> undef, i32 %464, i32 0
  %468 = insertelement <4 x i32> %467, i32 %465, i32 1
  %469 = insertelement <4 x i32> %468, i32 %466, i32 2
  %470 = insertelement <4 x i32> %469, i32 undef, i32 3
  %471 = call <4 x float> @llvm.SI.sample.v4i32(<4 x i32> %470, <32 x i8> %90, <16 x i8> %92, i32 4)
  %472 = extractelement <4 x float> %471, i32 0
  %473 = extractelement <4 x float> %471, i32 1
  %474 = extractelement <4 x float> %471, i32 2
  %475 = fmul float %431, %472
  %476 = fadd float %475, %329
  %477 = fmul float %432, %473
  %478 = fadd float %477, %330
  %479 = fmul float %433, %474
  %480 = fadd float %479, %331
  %481 = fmul float %107, %107
  %482 = fmul float %108, %108
  %483 = fadd float %482, %481
  %484 = fmul float %109, %109
  %485 = fadd float %483, %484
  %486 = call float @llvm.AMDGPU.rsq.f32(float %485)
  %487 = fmul float %107, %486
  %488 = fmul float %108, %486
  %489 = fmul float %109, %486
  %490 = fmul float %377, %40
  %491 = fmul float %378, %41
  %492 = fmul float %379, %42
  %493 = fmul float %359, %487
  %494 = fmul float %360, %488
  %495 = fadd float %494, %493
  %496 = fmul float %361, %489
  %497 = fadd float %495, %496
  %498 = fmul float %497, %359
  %499 = fmul float %497, %360
  %500 = fmul float %497, %361
  %501 = fmul float 2.000000e+00, %498
  %502 = fmul float 2.000000e+00, %499
  %503 = fmul float 2.000000e+00, %500
  %504 = fsub float -0.000000e+00, %501
  %505 = fadd float %487, %504
  %506 = fsub float -0.000000e+00, %502
  %507 = fadd float %488, %506
  %508 = fsub float -0.000000e+00, %503
  %509 = fadd float %489, %508
  %510 = fmul float %95, %95
  %511 = fmul float %96, %96
  %512 = fadd float %511, %510
  %513 = fmul float %97, %97
  %514 = fadd float %512, %513
  %515 = call float @llvm.AMDGPU.rsq.f32(float %514)
  %516 = fmul float %95, %515
  %517 = fmul float %96, %515
  %518 = fmul float %97, %515
  %519 = fmul float %505, %516
  %520 = fmul float %507, %517
  %521 = fadd float %520, %519
  %522 = fmul float %509, %518
  %523 = fadd float %521, %522
  %524 = fsub float -0.000000e+00, %523
  %525 = fcmp uge float %524, 0.000000e+00
  %526 = select i1 %525, float %524, float 0.000000e+00
  %527 = fmul float %43, %380
  %528 = fadd float %527, 1.000000e+00
  %529 = call float @llvm.pow.f32(float %526, float %528)
  %530 = fmul float %476, %37
  %531 = fmul float %478, %38
  %532 = fmul float %480, %39
  %533 = fmul float %359, %487
  %534 = fmul float %360, %488
  %535 = fadd float %534, %533
  %536 = fmul float %361, %489
  %537 = fadd float %535, %536
  %538 = fcmp uge float %537, 0.000000e+00
  %539 = select i1 %538, float %537, float 0.000000e+00
  %540 = fmul float %530, %539
  %541 = fmul float %531, %539
  %542 = fmul float %532, %539
  %543 = fmul float %490, %529
  %544 = fadd float %543, %540
  %545 = fmul float %491, %529
  %546 = fadd float %545, %541
  %547 = fmul float %492, %529
  %548 = fadd float %547, %542
  %549 = fmul float %476, %34
  %550 = fmul float %478, %35
  %551 = fmul float %480, %36
  %552 = fmul float %544, %57
  %553 = fadd float %552, %549
  %554 = fmul float %546, %58
  %555 = fadd float %554, %550
  %556 = fmul float %548, %59
  %557 = fadd float %556, %551
  %558 = bitcast float %136 to i32
  %559 = bitcast float %182 to i32
  %560 = bitcast float %137 to i32
  %561 = bitcast float %183 to i32
  %562 = bitcast float %temp28.1 to i32
  %563 = bitcast float %temp29.1 to i32
  %564 = insertelement <8 x i32> undef, i32 %558, i32 0
  %565 = insertelement <8 x i32> %564, i32 %559, i32 1
  %566 = insertelement <8 x i32> %565, i32 %560, i32 2
  %567 = insertelement <8 x i32> %566, i32 %561, i32 3
  %568 = insertelement <8 x i32> %567, i32 %562, i32 4
  %569 = insertelement <8 x i32> %568, i32 %563, i32 5
  %570 = insertelement <8 x i32> %569, i32 undef, i32 6
  %571 = insertelement <8 x i32> %570, i32 undef, i32 7
  %572 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %571, <32 x i8> %74, <16 x i8> %76, i32 2)
  %573 = extractelement <4 x float> %572, i32 0
  %574 = extractelement <4 x float> %572, i32 1
  %575 = extractelement <4 x float> %572, i32 2
  %576 = fmul float %573, %44
  %577 = fadd float %576, %553
  %578 = fmul float %574, %45
  %579 = fadd float %578, %555
  %580 = fmul float %575, %46
  %581 = fadd float %580, %557
  %582 = call i32 @llvm.SI.packf16(float %577, float %579)
  %583 = bitcast i32 %582 to float
  %584 = call i32 @llvm.SI.packf16(float %581, float %283)
  %585 = bitcast i32 %584 to float
  call void @llvm.SI.export(i32 15, i32 1, i32 1, i32 0, i32 1, float %583, float %585, float %583, float %585)
  ret void

ENDIF66:                                          ; preds = %LOOP65
  %586 = bitcast float %temp28.1 to i32
  %587 = bitcast float %temp29.1 to i32
  %588 = insertelement <8 x i32> %237, i32 %586, i32 4
  %589 = insertelement <8 x i32> %588, i32 %587, i32 5
  %590 = insertelement <8 x i32> %589, i32 undef, i32 6
  %591 = insertelement <8 x i32> %590, i32 undef, i32 7
  %592 = call <4 x float> @llvm.SI.sampled.v8i32(<8 x i32> %591, <32 x i8> %62, <16 x i8> %64, i32 2)
  %593 = extractelement <4 x float> %592, i32 3
  %594 = fcmp oge float %temp30.1, %593
  %595 = sext i1 %594 to i32
  %596 = bitcast i32 %595 to float
  %597 = bitcast float %596 to i32
  %598 = and i32 %597, 1065353216
  %599 = bitcast i32 %598 to float
  %600 = fmul float 5.000000e-01, %temp32.0
  %601 = fsub float -0.000000e+00, %600
  %602 = fmul float %599, %temp32.0
  %603 = fadd float %602, %601
  %604 = fmul float %214, %603
  %605 = fadd float %604, %temp28.1
  %606 = fmul float %215, %603
  %607 = fadd float %606, %temp29.1
  %608 = fmul float %216, %603
  %609 = fadd float %608, %temp30.1
  %610 = fadd float %temp24.1, 1.000000e+00
  %611 = fmul float %temp32.0, 5.000000e-01
  br label %LOOP65
}

; Function Attrs: nounwind readnone
declare float @llvm.SI.load.const(<16 x i8>, i32) #1

; Function Attrs: nounwind readnone
declare float @llvm.SI.fs.interp(i32, i32, i32, <2 x i32>) #1

; Function Attrs: readnone
declare i32 @llvm.SI.tid() #2

; Function Attrs: readonly
declare float @ceil(float) #3

; Function Attrs: readnone
declare float @llvm.AMDGPU.rsq.f32(float) #2

; Function Attrs: nounwind readnone
declare <4 x float> @llvm.SI.sampled.v8i32(<8 x i32>, <32 x i8>, <16 x i8>, i32) #1

; Function Attrs: readnone
declare <4 x float> @llvm.AMDGPU.cube(<4 x float>) #2

; Function Attrs: readnone
declare float @fabs(float) #2

; Function Attrs: nounwind readnone
declare <4 x float> @llvm.SI.sample.v4i32(<4 x i32>, <32 x i8>, <16 x i8>, i32) #1

; Function Attrs: nounwind readonly
declare float @llvm.pow.f32(float, float) #4

; Function Attrs: nounwind readnone
declare i32 @llvm.SI.packf16(float, float) #1

declare void @llvm.SI.export(i32, i32, i32, i32, i32, float, float, float, float)

attributes #0 = { "ShaderType"="0" }
attributes #1 = { nounwind readnone }
attributes #2 = { readnone }
attributes #3 = { readonly }
attributes #4 = { nounwind readonly }

!0 = !{!"const", null, i32 1}

; CHECK-LABEL: {{^}}main1:
; CHECK: s_endpgm
define void @main1([17 x <16 x i8>] addrspace(2)* byval, [32 x <16 x i8>] addrspace(2)* byval, [16 x <32 x i8>] addrspace(2)* byval, float inreg, i32 inreg, <2 x i32>, <2 x i32>, <2 x i32>, <3 x i32>, <2 x i32>, <2 x i32>, <2 x i32>, float, float, float, float, float, float, float, float, float) #0 {
main_body:
  %21 = getelementptr [17 x <16 x i8>], [17 x <16 x i8>] addrspace(2)* %0, i64 0, i32 0
  %22 = load <16 x i8>, <16 x i8> addrspace(2)* %21, !tbaa !0
  %23 = call float @llvm.SI.load.const(<16 x i8> %22, i32 0)
  %24 = call float @llvm.SI.load.const(<16 x i8> %22, i32 4)
  %25 = call float @llvm.SI.load.const(<16 x i8> %22, i32 8)
  %26 = call float @llvm.SI.load.const(<16 x i8> %22, i32 12)
  %27 = call float @llvm.SI.load.const(<16 x i8> %22, i32 28)
  %28 = call float @llvm.SI.load.const(<16 x i8> %22, i32 48)
  %29 = call float @llvm.SI.load.const(<16 x i8> %22, i32 52)
  %30 = call float @llvm.SI.load.const(<16 x i8> %22, i32 56)
  %31 = call float @llvm.SI.load.const(<16 x i8> %22, i32 64)
  %32 = call float @llvm.SI.load.const(<16 x i8> %22, i32 68)
  %33 = call float @llvm.SI.load.const(<16 x i8> %22, i32 72)
  %34 = call float @llvm.SI.load.const(<16 x i8> %22, i32 76)
  %35 = call float @llvm.SI.load.const(<16 x i8> %22, i32 128)
  %36 = call float @llvm.SI.load.const(<16 x i8> %22, i32 132)
  %37 = call float @llvm.SI.load.const(<16 x i8> %22, i32 144)
  %38 = call float @llvm.SI.load.const(<16 x i8> %22, i32 148)
  %39 = call float @llvm.SI.load.const(<16 x i8> %22, i32 152)
  %40 = call float @llvm.SI.load.const(<16 x i8> %22, i32 160)
  %41 = call float @llvm.SI.load.const(<16 x i8> %22, i32 164)
  %42 = call float @llvm.SI.load.const(<16 x i8> %22, i32 168)
  %43 = call float @llvm.SI.load.const(<16 x i8> %22, i32 172)
  %44 = call float @llvm.SI.load.const(<16 x i8> %22, i32 176)
  %45 = call float @llvm.SI.load.const(<16 x i8> %22, i32 180)
  %46 = call float @llvm.SI.load.const(<16 x i8> %22, i32 184)
  %47 = call float @llvm.SI.load.const(<16 x i8> %22, i32 192)
  %48 = call float @llvm.SI.load.const(<16 x i8> %22, i32 196)
  %49 = call float @llvm.SI.load.const(<16 x i8> %22, i32 200)
  %50 = call float @llvm.SI.load.const(<16 x i8> %22, i32 208)
  %51 = call float @llvm.SI.load.const(<16 x i8> %22, i32 212)
  %52 = call float @llvm.SI.load.const(<16 x i8> %22, i32 216)
  %53 = call float @llvm.SI.load.const(<16 x i8> %22, i32 220)
  %54 = call float @llvm.SI.load.const(<16 x i8> %22, i32 236)
  %55 = call float @llvm.SI.load.const(<16 x i8> %22, i32 240)
  %56 = call float @llvm.SI.load.const(<16 x i8> %22, i32 244)
  %57 = call float @llvm.SI.load.const(<16 x i8> %22, i32 248)
  %58 = call float @llvm.SI.load.const(<16 x i8> %22, i32 252)
  %59 = call float @llvm.SI.load.const(<16 x i8> %22, i32 256)
  %60 = call float @llvm.SI.load.const(<16 x i8> %22, i32 260)
  %61 = call float @llvm.SI.load.const(<16 x i8> %22, i32 264)
  %62 = call float @llvm.SI.load.const(<16 x i8> %22, i32 268)
  %63 = call float @llvm.SI.load.const(<16 x i8> %22, i32 272)
  %64 = call float @llvm.SI.load.const(<16 x i8> %22, i32 276)
  %65 = call float @llvm.SI.load.const(<16 x i8> %22, i32 280)
  %66 = call float @llvm.SI.load.const(<16 x i8> %22, i32 284)
  %67 = call float @llvm.SI.load.const(<16 x i8> %22, i32 288)
  %68 = call float @llvm.SI.load.const(<16 x i8> %22, i32 292)
  %69 = call float @llvm.SI.load.const(<16 x i8> %22, i32 464)
  %70 = call float @llvm.SI.load.const(<16 x i8> %22, i32 468)
  %71 = call float @llvm.SI.load.const(<16 x i8> %22, i32 472)
  %72 = call float @llvm.SI.load.const(<16 x i8> %22, i32 496)
  %73 = call float @llvm.SI.load.const(<16 x i8> %22, i32 500)
  %74 = call float @llvm.SI.load.const(<16 x i8> %22, i32 504)
  %75 = call float @llvm.SI.load.const(<16 x i8> %22, i32 512)
  %76 = call float @llvm.SI.load.const(<16 x i8> %22, i32 516)
  %77 = call float @llvm.SI.load.const(<16 x i8> %22, i32 524)
  %78 = call float @llvm.SI.load.const(<16 x i8> %22, i32 532)
  %79 = call float @llvm.SI.load.const(<16 x i8> %22, i32 536)
  %80 = call float @llvm.SI.load.const(<16 x i8> %22, i32 540)
  %81 = call float @llvm.SI.load.const(<16 x i8> %22, i32 544)
  %82 = call float @llvm.SI.load.const(<16 x i8> %22, i32 548)
  %83 = call float @llvm.SI.load.const(<16 x i8> %22, i32 552)
  %84 = call float @llvm.SI.load.const(<16 x i8> %22, i32 556)
  %85 = call float @llvm.SI.load.const(<16 x i8> %22, i32 560)
  %86 = call float @llvm.SI.load.const(<16 x i8> %22, i32 564)
  %87 = call float @llvm.SI.load.const(<16 x i8> %22, i32 568)
  %88 = call float @llvm.SI.load.const(<16 x i8> %22, i32 572)
  %89 = call float @llvm.SI.load.const(<16 x i8> %22, i32 576)
  %90 = call float @llvm.SI.load.const(<16 x i8> %22, i32 580)
  %91 = call float @llvm.SI.load.const(<16 x i8> %22, i32 584)
  %92 = call float @llvm.SI.load.const(<16 x i8> %22, i32 588)
  %93 = call float @llvm.SI.load.const(<16 x i8> %22, i32 592)
  %94 = call float @llvm.SI.load.const(<16 x i8> %22, i32 596)
  %95 = call float @llvm.SI.load.const(<16 x i8> %22, i32 600)
  %96 = call float @llvm.SI.load.const(<16 x i8> %22, i32 604)
  %97 = call float @llvm.SI.load.const(<16 x i8> %22, i32 608)
  %98 = call float @llvm.SI.load.const(<16 x i8> %22, i32 612)
  %99 = call float @llvm.SI.load.const(<16 x i8> %22, i32 616)
  %100 = call float @llvm.SI.load.const(<16 x i8> %22, i32 624)
  %101 = call float @llvm.SI.load.const(<16 x i8> %22, i32 628)
  %102 = call float @llvm.SI.load.const(<16 x i8> %22, i32 632)
  %103 = call float @llvm.SI.load.const(<16 x i8> %22, i32 636)
  %104 = call float @llvm.SI.load.const(<16 x i8> %22, i32 640)
  %105 = call float @llvm.SI.load.const(<16 x i8> %22, i32 644)
  %106 = call float @llvm.SI.load.const(<16 x i8> %22, i32 648)
  %107 = call float @llvm.SI.load.const(<16 x i8> %22, i32 652)
  %108 = call float @llvm.SI.load.const(<16 x i8> %22, i32 656)
  %109 = call float @llvm.SI.load.const(<16 x i8> %22, i32 660)
  %110 = call float @llvm.SI.load.const(<16 x i8> %22, i32 664)
  %111 = call float @llvm.SI.load.const(<16 x i8> %22, i32 668)
  %112 = call float @llvm.SI.load.const(<16 x i8> %22, i32 672)
  %113 = call float @llvm.SI.load.const(<16 x i8> %22, i32 676)
  %114 = call float @llvm.SI.load.const(<16 x i8> %22, i32 680)
  %115 = call float @llvm.SI.load.const(<16 x i8> %22, i32 684)
  %116 = call float @llvm.SI.load.const(<16 x i8> %22, i32 688)
  %117 = call float @llvm.SI.load.const(<16 x i8> %22, i32 692)
  %118 = call float @llvm.SI.load.const(<16 x i8> %22, i32 696)
  %119 = call float @llvm.SI.load.const(<16 x i8> %22, i32 700)
  %120 = call float @llvm.SI.load.const(<16 x i8> %22, i32 704)
  %121 = call float @llvm.SI.load.const(<16 x i8> %22, i32 708)
  %122 = call float @llvm.SI.load.const(<16 x i8> %22, i32 712)
  %123 = call float @llvm.SI.load.const(<16 x i8> %22, i32 716)
  %124 = call float @llvm.SI.load.const(<16 x i8> %22, i32 864)
  %125 = call float @llvm.SI.load.const(<16 x i8> %22, i32 868)
  %126 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 0
  %127 = load <32 x i8>, <32 x i8> addrspace(2)* %126, !tbaa !0
  %128 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 0
  %129 = load <16 x i8>, <16 x i8> addrspace(2)* %128, !tbaa !0
  %130 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 1
  %131 = load <32 x i8>, <32 x i8> addrspace(2)* %130, !tbaa !0
  %132 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 1
  %133 = load <16 x i8>, <16 x i8> addrspace(2)* %132, !tbaa !0
  %134 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 2
  %135 = load <32 x i8>, <32 x i8> addrspace(2)* %134, !tbaa !0
  %136 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 2
  %137 = load <16 x i8>, <16 x i8> addrspace(2)* %136, !tbaa !0
  %138 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 3
  %139 = load <32 x i8>, <32 x i8> addrspace(2)* %138, !tbaa !0
  %140 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 3
  %141 = load <16 x i8>, <16 x i8> addrspace(2)* %140, !tbaa !0
  %142 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 4
  %143 = load <32 x i8>, <32 x i8> addrspace(2)* %142, !tbaa !0
  %144 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 4
  %145 = load <16 x i8>, <16 x i8> addrspace(2)* %144, !tbaa !0
  %146 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 5
  %147 = load <32 x i8>, <32 x i8> addrspace(2)* %146, !tbaa !0
  %148 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 5
  %149 = load <16 x i8>, <16 x i8> addrspace(2)* %148, !tbaa !0
  %150 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 6
  %151 = load <32 x i8>, <32 x i8> addrspace(2)* %150, !tbaa !0
  %152 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 6
  %153 = load <16 x i8>, <16 x i8> addrspace(2)* %152, !tbaa !0
  %154 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 7
  %155 = load <32 x i8>, <32 x i8> addrspace(2)* %154, !tbaa !0
  %156 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 7
  %157 = load <16 x i8>, <16 x i8> addrspace(2)* %156, !tbaa !0
  %158 = getelementptr [16 x <32 x i8>], [16 x <32 x i8>] addrspace(2)* %2, i64 0, i32 8
  %159 = load <32 x i8>, <32 x i8> addrspace(2)* %158, !tbaa !0
  %160 = getelementptr [32 x <16 x i8>], [32 x <16 x i8>] addrspace(2)* %1, i64 0, i32 8
  %161 = load <16 x i8>, <16 x i8> addrspace(2)* %160, !tbaa !0
  %162 = fcmp ugt float %17, 0.000000e+00
  %163 = select i1 %162, float 1.000000e+00, float 0.000000e+00
  %164 = call float @llvm.SI.fs.interp(i32 0, i32 0, i32 %4, <2 x i32> %6)
  %165 = call float @llvm.SI.fs.interp(i32 1, i32 0, i32 %4, <2 x i32> %6)
  %166 = call float @llvm.SI.fs.interp(i32 2, i32 0, i32 %4, <2 x i32> %6)
  %167 = call float @llvm.SI.fs.interp(i32 3, i32 0, i32 %4, <2 x i32> %6)
  %168 = call float @llvm.SI.fs.interp(i32 0, i32 1, i32 %4, <2 x i32> %6)
  %169 = call float @llvm.SI.fs.interp(i32 1, i32 1, i32 %4, <2 x i32> %6)
  %170 = call float @llvm.SI.fs.interp(i32 2, i32 1, i32 %4, <2 x i32> %6)
  %171 = call float @llvm.SI.fs.interp(i32 3, i32 1, i32 %4, <2 x i32> %6)
  %172 = call float @llvm.SI.fs.interp(i32 0, i32 2, i32 %4, <2 x i32> %6)
  %173 = call float @llvm.SI.fs.interp(i32 1, i32 2, i32 %4, <2 x i32> %6)
  %174 = call float @llvm.SI.fs.interp(i32 2, i32 2, i32 %4, <2 x i32> %6)
  %175 = call float @llvm.SI.fs.interp(i32 3, i32 2, i32 %4, <2 x i32> %6)
  %176 = call float @llvm.SI.fs.interp(i32 0, i32 3, i32 %4, <2 x i32> %6)
  %177 = call float @llvm.SI.fs.interp(i32 1, i32 3, i32 %4, <2 x i32> %6)
  %178 = call float @llvm.SI.fs.interp(i32 2, i32 3, i32 %4, <2 x i32> %6)
  %179 = call float @llvm.SI.fs.interp(i32 3, i32 3, i32 %4, <2 x i32> %6)
  %180 = call float @llvm.SI.fs.interp(i32 0, i32 4, i32 %4, <2 x i32> %6)
  %181 = call float @llvm.SI.fs.interp(i32 1, i32 4, i32 %4, <2 x i32> %6)
  %182 = call float @llvm.SI.fs.interp(i32 2, i32 4, i32 %4, <2 x i32> %6)
  %183 = call float @llvm.SI.fs.interp(i32 3, i32 4, i32 %4, <2 x i32> %6)
  %184 = call float @llvm.SI.fs.interp(i32 0, i32 5, i32 %4, <2 x i32> %6)
  %185 = call float @llvm.SI.fs.interp(i32 1, i32 5, i32 %4, <2 x i32> %6)
  %186 = call float @llvm.SI.fs.interp(i32 2, i32 5, i32 %4, <2 x i32> %6)
  %187 = call float @llvm.SI.fs.interp(i32 3, i32 5, i32 %4, <2 x i32> %6)
  %188 = call float @llvm.SI.fs.interp(i32 0, i32 6, i32 %4, <2 x i32> %6)
  %189 = call float @llvm.SI.fs.interp(i32 1, i32 6, i32 %4, <2 x i32> %6)
  %190 = call float @llvm.SI.fs.interp(i32 2, i32 6, i32 %4, <2 x i32> %6)
  %191 = call float @llvm.SI.fs.interp(i32 3, i32 6, i32 %4, <2 x i32> %6)
  %192 = call float @llvm.SI.fs.interp(i32 0, i32 7, i32 %4, <2 x i32> %6)
  %193 = call float @llvm.SI.fs.interp(i32 1, i32 7, i32 %4, <2 x i32> %6)
  %194 = call float @llvm.SI.fs.interp(i32 2, i32 7, i32 %4, <2 x i32> %6)
  %195 = call float @llvm.SI.fs.interp(i32 3, i32 7, i32 %4, <2 x i32> %6)
  %196 = fmul float %14, %124
  %197 = fadd float %196, %125
  %198 = call float @llvm.AMDIL.clamp.(float %163, float 0.000000e+00, float 1.000000e+00)
  %199 = call float @llvm.AMDIL.clamp.(float 0.000000e+00, float 0.000000e+00, float 1.000000e+00)
  %200 = call float @llvm.AMDIL.clamp.(float 0.000000e+00, float 0.000000e+00, float 1.000000e+00)
  %201 = call float @llvm.AMDIL.clamp.(float 1.000000e+00, float 0.000000e+00, float 1.000000e+00)
  %202 = bitcast float %198 to i32
  %203 = icmp ne i32 %202, 0
  %. = select i1 %203, float -1.000000e+00, float 1.000000e+00
  %204 = fsub float -0.000000e+00, %164
  %205 = fadd float %44, %204
  %206 = fsub float -0.000000e+00, %165
  %207 = fadd float %45, %206
  %208 = fsub float -0.000000e+00, %166
  %209 = fadd float %46, %208
  %210 = fmul float %205, %205
  %211 = fmul float %207, %207
  %212 = fadd float %211, %210
  %213 = fmul float %209, %209
  %214 = fadd float %212, %213
  %215 = call float @llvm.AMDGPU.rsq.f32(float %214)
  %216 = fmul float %205, %215
  %217 = fmul float %207, %215
  %218 = fmul float %209, %215
  %219 = fmul float %., %54
  %220 = fmul float %13, %47
  %221 = fmul float %197, %48
  %222 = bitcast float %174 to i32
  %223 = bitcast float %175 to i32
  %224 = insertelement <2 x i32> undef, i32 %222, i32 0
  %225 = insertelement <2 x i32> %224, i32 %223, i32 1
  %226 = call <4 x float> @llvm.SI.sample.v2i32(<2 x i32> %225, <32 x i8> %131, <16 x i8> %133, i32 2)
  %227 = extractelement <4 x float> %226, i32 0
  %228 = extractelement <4 x float> %226, i32 1
  %229 = extractelement <4 x float> %226, i32 2
  %230 = extractelement <4 x float> %226, i32 3
  %231 = fmul float %227, 0x4012611180000000
  %232 = fmul float %228, 0x4012611180000000
  %233 = fmul float %229, 0x4012611180000000
  %234 = call float @llvm.AMDGPU.lrp(float %27, float %231, float 1.000000e+00)
  %235 = call float @llvm.AMDGPU.lrp(float %27, float %232, float 1.000000e+00)
  %236 = call float @llvm.AMDGPU.lrp(float %27, float %233, float 1.000000e+00)
  %237 = fmul float %216, %184
  %238 = fmul float %217, %185
  %239 = fadd float %238, %237
  %240 = fmul float %218, %186
  %241 = fadd float %239, %240
  %242 = fmul float %216, %187
  %243 = fmul float %217, %188
  %244 = fadd float %243, %242
  %245 = fmul float %218, %189
  %246 = fadd float %244, %245
  %247 = fmul float %216, %190
  %248 = fmul float %217, %191
  %249 = fadd float %248, %247
  %250 = fmul float %218, %192
  %251 = fadd float %249, %250
  %252 = call float @llvm.AMDIL.clamp.(float %251, float 0.000000e+00, float 1.000000e+00)
  %253 = fmul float %214, 0x3F5A36E2E0000000
  %254 = call float @llvm.AMDIL.clamp.(float %253, float 0.000000e+00, float 1.000000e+00)
  %255 = fsub float -0.000000e+00, %254
  %256 = fadd float 1.000000e+00, %255
  %257 = call float @llvm.pow.f32(float %252, float 2.500000e-01)
  %258 = fmul float %39, %257
  %259 = fmul float %241, %258
  %260 = fmul float %246, %258
  %261 = fmul float %259, %230
  %262 = fmul float %260, %230
  %263 = fadd float %252, 0x3EE4F8B580000000
  %264 = fsub float -0.000000e+00, %252
  %265 = fadd float 1.000000e+00, %264
  %266 = fmul float 1.200000e+01, %265
  %267 = fadd float %266, 4.000000e+00
  %268 = fsub float -0.000000e+00, %267
  %269 = fmul float %268, %263
  %270 = fsub float -0.000000e+00, %267
  %271 = fmul float %270, %263
  %272 = fsub float -0.000000e+00, %267
  %273 = fmul float %272, %263
  %274 = fdiv float 1.000000e+00, %269
  %275 = fdiv float 1.000000e+00, %271
  %276 = fdiv float 1.000000e+00, %273
  %277 = fmul float %261, %274
  %278 = fmul float %262, %275
  %279 = fmul float %263, %276
  br label %LOOP

LOOP:                                             ; preds = %LOOP, %main_body
  %temp144.0 = phi float [ 1.000000e+00, %main_body ], [ %292, %LOOP ]
  %temp168.0 = phi float [ %176, %main_body ], [ %288, %LOOP ]
  %temp169.0 = phi float [ %177, %main_body ], [ %289, %LOOP ]
  %temp170.0 = phi float [ %256, %main_body ], [ %290, %LOOP ]
  %280 = bitcast float %temp168.0 to i32
  %281 = bitcast float %temp169.0 to i32
  %282 = insertelement <4 x i32> undef, i32 %280, i32 0
  %283 = insertelement <4 x i32> %282, i32 %281, i32 1
  %284 = insertelement <4 x i32> %283, i32 0, i32 2
  %285 = insertelement <4 x i32> %284, i32 undef, i32 3
  %286 = call <4 x float> @llvm.SI.samplel.v4i32(<4 x i32> %285, <32 x i8> %147, <16 x i8> %149, i32 2)
  %287 = extractelement <4 x float> %286, i32 3
  %288 = fadd float %temp168.0, %277
  %289 = fadd float %temp169.0, %278
  %290 = fadd float %temp170.0, %279
  %291 = fsub float -0.000000e+00, %287
  %292 = fadd float %290, %291
  %293 = fcmp oge float 0.000000e+00, %292
  %294 = sext i1 %293 to i32
  %295 = bitcast i32 %294 to float
  %296 = bitcast float %295 to i32
  %297 = icmp ne i32 %296, 0
  br i1 %297, label %IF189, label %LOOP

IF189:                                            ; preds = %LOOP
  %298 = extractelement <4 x float> %286, i32 0
  %299 = extractelement <4 x float> %286, i32 1
  %300 = extractelement <4 x float> %286, i32 2
  %301 = fsub float -0.000000e+00, %292
  %302 = fadd float %temp144.0, %301
  %303 = fdiv float 1.000000e+00, %302
  %304 = fmul float %292, %303
  %305 = fadd float %304, -1.000000e+00
  %306 = fmul float %305, %277
  %307 = fadd float %306, %288
  %308 = fmul float %305, %278
  %309 = fadd float %308, %289
  %310 = fsub float -0.000000e+00, %176
  %311 = fadd float %307, %310
  %312 = fsub float -0.000000e+00, %177
  %313 = fadd float %309, %312
  %314 = fadd float %176, %311
  %315 = fadd float %177, %313
  %316 = fmul float %311, %67
  %317 = fmul float %313, %68
  %318 = fmul float %316, %55
  %319 = fmul float %316, %56
  %320 = fmul float %317, %57
  %321 = fadd float %320, %318
  %322 = fmul float %317, %58
  %323 = fadd float %322, %319
  %324 = fadd float %178, %321
  %325 = fadd float %179, %323
  %326 = fmul float %316, %59
  %327 = fmul float %316, %60
  %328 = fmul float %316, %61
  %329 = fmul float %316, %62
  %330 = fmul float %317, %63
  %331 = fadd float %330, %326
  %332 = fmul float %317, %64
  %333 = fadd float %332, %327
  %334 = fmul float %317, %65
  %335 = fadd float %334, %328
  %336 = fmul float %317, %66
  %337 = fadd float %336, %329
  %338 = fadd float %168, %331
  %339 = fadd float %169, %333
  %340 = fadd float %170, %335
  %341 = fadd float %171, %337
  %342 = bitcast float %338 to i32
  %343 = bitcast float %339 to i32
  %344 = insertelement <2 x i32> undef, i32 %342, i32 0
  %345 = insertelement <2 x i32> %344, i32 %343, i32 1
  %346 = call <4 x float> @llvm.SI.sample.v2i32(<2 x i32> %345, <32 x i8> %135, <16 x i8> %137, i32 2)
  %347 = extractelement <4 x float> %346, i32 0
  %348 = extractelement <4 x float> %346, i32 1
  %349 = extractelement <4 x float> %346, i32 2
  %350 = extractelement <4 x float> %346, i32 3
  %351 = fmul float %347, %23
  %352 = fmul float %348, %24
  %353 = fmul float %349, %25
  %354 = fmul float %350, %26
  %355 = fmul float %351, %180
  %356 = fmul float %352, %181
  %357 = fmul float %353, %182
  %358 = fmul float %354, %183
  %359 = fsub float -0.000000e+00, %350
  %360 = fadd float 1.000000e+00, %359
  %361 = fmul float %360, %49
  %362 = call float @llvm.AMDGPU.lrp(float %361, float %347, float %355)
  %363 = call float @llvm.AMDGPU.lrp(float %361, float %348, float %356)
  %364 = call float @llvm.AMDGPU.lrp(float %361, float %349, float %357)
  %365 = bitcast float %340 to i32
  %366 = bitcast float %341 to i32
  %367 = insertelement <2 x i32> undef, i32 %365, i32 0
  %368 = insertelement <2 x i32> %367, i32 %366, i32 1
  %369 = call <4 x float> @llvm.SI.sample.v2i32(<2 x i32> %368, <32 x i8> %151, <16 x i8> %153, i32 2)
  %370 = extractelement <4 x float> %369, i32 2
  %371 = fmul float %362, %234
  %372 = fmul float %363, %235
  %373 = fmul float %364, %236
  %374 = fmul float %358, %230
  %375 = bitcast float %314 to i32
  %376 = bitcast float %315 to i32
  %377 = insertelement <2 x i32> undef, i32 %375, i32 0
  %378 = insertelement <2 x i32> %377, i32 %376, i32 1
  %379 = call <4 x float> @llvm.SI.sample.v2i32(<2 x i32> %378, <32 x i8> %139, <16 x i8> %141, i32 2)
  %380 = extractelement <4 x float> %379, i32 0
  %381 = extractelement <4 x float> %379, i32 1
  %382 = extractelement <4 x float> %379, i32 2
  %383 = extractelement <4 x float> %379, i32 3
  %384 = fcmp olt float 0.000000e+00, %382
  %385 = sext i1 %384 to i32
  %386 = bitcast i32 %385 to float
  %387 = bitcast float %386 to i32
  %388 = icmp ne i32 %387, 0
  %.224 = select i1 %388, float %381, float %380
  %.225 = select i1 %388, float %383, float %381
  %389 = bitcast float %324 to i32
  %390 = bitcast float %325 to i32
  %391 = insertelement <2 x i32> undef, i32 %389, i32 0
  %392 = insertelement <2 x i32> %391, i32 %390, i32 1
  %393 = call <4 x float> @llvm.SI.sample.v2i32(<2 x i32> %392, <32 x i8> %143, <16 x i8> %145, i32 2)
  %394 = extractelement <4 x float> %393, i32 0
  %395 = extractelement <4 x float> %393, i32 1
  %396 = extractelement <4 x float> %393, i32 2
  %397 = extractelement <4 x float> %393, i32 3
  %398 = fcmp olt float 0.000000e+00, %396
  %399 = sext i1 %398 to i32
  %400 = bitcast i32 %399 to float
  %401 = bitcast float %400 to i32
  %402 = icmp ne i32 %401, 0
  %temp112.1 = select i1 %402, float %395, float %394
  %temp113.1 = select i1 %402, float %397, float %395
  %403 = fmul float %.224, 2.000000e+00
  %404 = fadd float %403, -1.000000e+00
  %405 = fmul float %.225, 2.000000e+00
  %406 = fadd float %405, -1.000000e+00
  %407 = fmul float %temp112.1, 2.000000e+00
  %408 = fadd float %407, -1.000000e+00
  %409 = fmul float %temp113.1, 2.000000e+00
  %410 = fadd float %409, -1.000000e+00
  %411 = fsub float -0.000000e+00, %404
  %412 = fmul float %411, %35
  %413 = fsub float -0.000000e+00, %406
  %414 = fmul float %413, %35
  %415 = fsub float -0.000000e+00, %408
  %416 = fmul float %415, %36
  %417 = fsub float -0.000000e+00, %410
  %418 = fmul float %417, %36
  %419 = fmul float %416, %370
  %420 = fmul float %418, %370
  %421 = call float @fabs(float %412)
  %422 = call float @fabs(float %414)
  %423 = fsub float -0.000000e+00, %421
  %424 = fadd float 1.000000e+00, %423
  %425 = fsub float -0.000000e+00, %422
  %426 = fadd float 1.000000e+00, %425
  %427 = fmul float %424, %419
  %428 = fadd float %427, %412
  %429 = fmul float %426, %420
  %430 = fadd float %429, %414
  %431 = fmul float %428, %428
  %432 = fmul float %430, %430
  %433 = fadd float %431, %432
  %434 = fsub float -0.000000e+00, %433
  %435 = fadd float 0x3FF00068E0000000, %434
  %436 = call float @llvm.AMDIL.clamp.(float %435, float 0.000000e+00, float 1.000000e+00)
  %437 = call float @llvm.AMDGPU.rsq.f32(float %436)
  %438 = fmul float %437, %436
  %439 = fsub float -0.000000e+00, %436
  %440 = call float @llvm.AMDGPU.cndlt(float %439, float %438, float 0.000000e+00)
  %441 = fmul float %184, %428
  %442 = fmul float %185, %428
  %443 = fmul float %186, %428
  %444 = fmul float %187, %430
  %445 = fadd float %444, %441
  %446 = fmul float %188, %430
  %447 = fadd float %446, %442
  %448 = fmul float %189, %430
  %449 = fadd float %448, %443
  %450 = fmul float %190, %440
  %451 = fadd float %450, %445
  %452 = fmul float %191, %440
  %453 = fadd float %452, %447
  %454 = fmul float %192, %440
  %455 = fadd float %454, %449
  %456 = fmul float %451, %451
  %457 = fmul float %453, %453
  %458 = fadd float %457, %456
  %459 = fmul float %455, %455
  %460 = fadd float %458, %459
  %461 = call float @llvm.AMDGPU.rsq.f32(float %460)
  %462 = fmul float %451, %461
  %463 = fmul float %453, %461
  %464 = fmul float %455, %461
  %465 = fcmp olt float 0.000000e+00, %219
  %466 = sext i1 %465 to i32
  %467 = bitcast i32 %466 to float
  %468 = bitcast float %467 to i32
  %469 = icmp ne i32 %468, 0
  br i1 %469, label %IF198, label %ENDIF197

IF198:                                            ; preds = %IF189
  %470 = fsub float -0.000000e+00, %462
  %471 = fsub float -0.000000e+00, %463
  %472 = fsub float -0.000000e+00, %464
  br label %ENDIF197

ENDIF197:                                         ; preds = %IF189, %IF198
  %temp14.0 = phi float [ %472, %IF198 ], [ %464, %IF189 ]
  %temp13.0 = phi float [ %471, %IF198 ], [ %463, %IF189 ]
  %temp12.0 = phi float [ %470, %IF198 ], [ %462, %IF189 ]
  %473 = bitcast float %220 to i32
  %474 = bitcast float %221 to i32
  %475 = insertelement <2 x i32> undef, i32 %473, i32 0
  %476 = insertelement <2 x i32> %475, i32 %474, i32 1
  %477 = call <4 x float> @llvm.SI.sample.v2i32(<2 x i32> %476, <32 x i8> %159, <16 x i8> %161, i32 2)
  %478 = extractelement <4 x float> %477, i32 0
  %479 = extractelement <4 x float> %477, i32 1
  %480 = extractelement <4 x float> %477, i32 2
  %481 = extractelement <4 x float> %477, i32 3
  %482 = fmul float %478, %40
  %483 = fadd float %482, %41
  %484 = fmul float %479, %40
  %485 = fadd float %484, %41
  %486 = fmul float %480, %40
  %487 = fadd float %486, %41
  %488 = fmul float %481, %42
  %489 = fadd float %488, %43
  %490 = bitcast float %172 to i32
  %491 = bitcast float %173 to i32
  %492 = insertelement <2 x i32> undef, i32 %490, i32 0
  %493 = insertelement <2 x i32> %492, i32 %491, i32 1
  %494 = call <4 x float> @llvm.SI.sample.v2i32(<2 x i32> %493, <32 x i8> %155, <16 x i8> %157, i32 2)
  %495 = extractelement <4 x float> %494, i32 0
  %496 = extractelement <4 x float> %494, i32 1
  %497 = extractelement <4 x float> %494, i32 2
  %498 = extractelement <4 x float> %494, i32 3
  %499 = fmul float %498, 3.200000e+01
  %500 = fadd float %499, -1.600000e+01
  %501 = call float @llvm.AMDIL.exp.(float %500)
  %502 = fmul float %495, %501
  %503 = fmul float %496, %501
  %504 = fmul float %497, %501
  %505 = fmul float %28, %502
  %506 = fadd float %505, %193
  %507 = fmul float %29, %503
  %508 = fadd float %507, %194
  %509 = fmul float %30, %504
  %510 = fadd float %509, %195
  %511 = fmul float %506, %489
  %512 = fmul float %508, %489
  %513 = fmul float %510, %489
  %514 = fmul float %489, 5.000000e-01
  %515 = fadd float %514, 5.000000e-01
  %516 = fmul float %483, %515
  %517 = fadd float %516, %511
  %518 = fmul float %485, %515
  %519 = fadd float %518, %512
  %520 = fmul float %487, %515
  %521 = fadd float %520, %513
  %522 = fmul float %517, %371
  %523 = fmul float %519, %372
  %524 = fmul float %521, %373
  %525 = fmul float %428, 0x3FDB272440000000
  %526 = fmul float %430, 0xBFDB272440000000
  %527 = fadd float %526, %525
  %528 = fmul float %440, 0x3FE99999A0000000
  %529 = fadd float %527, %528
  %530 = fmul float %529, 5.000000e-01
  %531 = fadd float %530, 0x3FE3333340000000
  %532 = fmul float %531, %531
  %533 = fmul float %522, %532
  %534 = fmul float %523, %532
  %535 = fmul float %524, %532
  %536 = fsub float -0.000000e+00, %72
  %537 = fsub float -0.000000e+00, %73
  %538 = fsub float -0.000000e+00, %74
  %539 = fmul float %temp12.0, %536
  %540 = fmul float %temp13.0, %537
  %541 = fadd float %540, %539
  %542 = fmul float %temp14.0, %538
  %543 = fadd float %541, %542
  %544 = call float @llvm.AMDIL.clamp.(float %543, float 0.000000e+00, float 1.000000e+00)
  %545 = fmul float %371, %544
  %546 = fmul float %372, %544
  %547 = fmul float %373, %544
  %548 = fmul float %545, %69
  %549 = fmul float %546, %70
  %550 = fmul float %547, %71
  %551 = fsub float -0.000000e+00, %164
  %552 = fadd float %97, %551
  %553 = fsub float -0.000000e+00, %165
  %554 = fadd float %98, %553
  %555 = fsub float -0.000000e+00, %166
  %556 = fadd float %99, %555
  %557 = fmul float %552, %552
  %558 = fmul float %554, %554
  %559 = fadd float %558, %557
  %560 = fmul float %556, %556
  %561 = fadd float %559, %560
  %562 = call float @llvm.AMDGPU.rsq.f32(float %561)
  %563 = fmul float %562, %561
  %564 = fsub float -0.000000e+00, %561
  %565 = call float @llvm.AMDGPU.cndlt(float %564, float %563, float 0.000000e+00)
  %566 = fsub float -0.000000e+00, %84
  %567 = fadd float %565, %566
  %568 = fsub float -0.000000e+00, %83
  %569 = fadd float %565, %568
  %570 = fsub float -0.000000e+00, %82
  %571 = fadd float %565, %570
  %572 = fsub float -0.000000e+00, %84
  %573 = fadd float %83, %572
  %574 = fsub float -0.000000e+00, %83
  %575 = fadd float %82, %574
  %576 = fsub float -0.000000e+00, %82
  %577 = fadd float %81, %576
  %578 = fdiv float 1.000000e+00, %573
  %579 = fdiv float 1.000000e+00, %575
  %580 = fdiv float 1.000000e+00, %577
  %581 = fmul float %567, %578
  %582 = fmul float %569, %579
  %583 = fmul float %571, %580
  %584 = fcmp olt float %565, %83
  %585 = sext i1 %584 to i32
  %586 = bitcast i32 %585 to float
  %587 = bitcast float %586 to i32
  %588 = icmp ne i32 %587, 0
  br i1 %588, label %ENDIF200, label %ELSE202

ELSE202:                                          ; preds = %ENDIF197
  %589 = fcmp olt float %565, %82
  %590 = sext i1 %589 to i32
  %591 = bitcast i32 %590 to float
  %592 = bitcast float %591 to i32
  %593 = icmp ne i32 %592, 0
  br i1 %593, label %ENDIF200, label %ELSE205

ENDIF200:                                         ; preds = %ELSE205, %ELSE202, %ENDIF197
  %temp80.0 = phi float [ %581, %ENDIF197 ], [ %.226, %ELSE205 ], [ %582, %ELSE202 ]
  %temp88.0 = phi float [ %122, %ENDIF197 ], [ %.227, %ELSE205 ], [ %120, %ELSE202 ]
  %temp89.0 = phi float [ %123, %ENDIF197 ], [ %.228, %ELSE205 ], [ %121, %ELSE202 ]
  %temp90.0 = phi float [ %120, %ENDIF197 ], [ %116, %ELSE205 ], [ %118, %ELSE202 ]
  %temp91.0 = phi float [ %121, %ENDIF197 ], [ %117, %ELSE205 ], [ %119, %ELSE202 ]
  %594 = fcmp olt float %565, %83
  %595 = sext i1 %594 to i32
  %596 = bitcast i32 %595 to float
  %597 = bitcast float %596 to i32
  %598 = icmp ne i32 %597, 0
  br i1 %598, label %ENDIF209, label %ELSE211

ELSE205:                                          ; preds = %ELSE202
  %599 = fcmp olt float %565, %81
  %600 = sext i1 %599 to i32
  %601 = bitcast i32 %600 to float
  %602 = bitcast float %601 to i32
  %603 = icmp ne i32 %602, 0
  %.226 = select i1 %603, float %583, float 1.000000e+00
  %.227 = select i1 %603, float %118, float %116
  %.228 = select i1 %603, float %119, float %117
  br label %ENDIF200

ELSE211:                                          ; preds = %ENDIF200
  %604 = fcmp olt float %565, %82
  %605 = sext i1 %604 to i32
  %606 = bitcast i32 %605 to float
  %607 = bitcast float %606 to i32
  %608 = icmp ne i32 %607, 0
  br i1 %608, label %ENDIF209, label %ELSE214

ENDIF209:                                         ; preds = %ELSE214, %ELSE211, %ENDIF200
  %temp52.0 = phi float [ %108, %ENDIF200 ], [ %100, %ELSE214 ], [ %104, %ELSE211 ]
  %temp53.0 = phi float [ %109, %ENDIF200 ], [ %101, %ELSE214 ], [ %105, %ELSE211 ]
  %temp54.0 = phi float [ %110, %ENDIF200 ], [ %102, %ELSE214 ], [ %106, %ELSE211 ]
  %temp55.0 = phi float [ %111, %ENDIF200 ], [ %103, %ELSE214 ], [ %107, %ELSE211 ]
  %temp68.0 = phi float [ %112, %ENDIF200 ], [ %.230, %ELSE214 ], [ %108, %ELSE211 ]
  %temp69.0 = phi float [ %113, %ENDIF200 ], [ %.231, %ELSE214 ], [ %109, %ELSE211 ]
  %temp70.0 = phi float [ %114, %ENDIF200 ], [ %.232, %ELSE214 ], [ %110, %ELSE211 ]
  %temp71.0 = phi float [ %115, %ENDIF200 ], [ %.233, %ELSE214 ], [ %111, %ELSE211 ]
  %609 = fmul float %164, %85
  %610 = fmul float %165, %86
  %611 = fadd float %609, %610
  %612 = fmul float %166, %87
  %613 = fadd float %611, %612
  %614 = fmul float %167, %88
  %615 = fadd float %613, %614
  %616 = fmul float %164, %89
  %617 = fmul float %165, %90
  %618 = fadd float %616, %617
  %619 = fmul float %166, %91
  %620 = fadd float %618, %619
  %621 = fmul float %167, %92
  %622 = fadd float %620, %621
  %623 = fmul float %164, %93
  %624 = fmul float %165, %94
  %625 = fadd float %623, %624
  %626 = fmul float %166, %95
  %627 = fadd float %625, %626
  %628 = fmul float %167, %96
  %629 = fadd float %627, %628
  %630 = fsub float -0.000000e+00, %78
  %631 = fadd float 1.000000e+00, %630
  %632 = call float @fabs(float %615)
  %633 = call float @fabs(float %622)
  %634 = fcmp oge float %631, %632
  %635 = sext i1 %634 to i32
  %636 = bitcast i32 %635 to float
  %637 = bitcast float %636 to i32
  %638 = and i32 %637, 1065353216
  %639 = bitcast i32 %638 to float
  %640 = fcmp oge float %631, %633
  %641 = sext i1 %640 to i32
  %642 = bitcast i32 %641 to float
  %643 = bitcast float %642 to i32
  %644 = and i32 %643, 1065353216
  %645 = bitcast i32 %644 to float
  %646 = fmul float %639, %645
  %647 = fmul float %629, %646
  %648 = fmul float %615, %temp68.0
  %649 = fadd float %648, %temp70.0
  %650 = fmul float %622, %temp69.0
  %651 = fadd float %650, %temp71.0
  %652 = fmul float %615, %temp52.0
  %653 = fadd float %652, %temp54.0
  %654 = fmul float %622, %temp53.0
  %655 = fadd float %654, %temp55.0
  %656 = fadd float %temp80.0, -1.000000e+00
  %657 = fmul float %656, %77
  %658 = fadd float %657, 1.000000e+00
  %659 = call float @llvm.AMDIL.clamp.(float %658, float 0.000000e+00, float 1.000000e+00)
  %660 = bitcast float %649 to i32
  %661 = bitcast float %651 to i32
  %662 = bitcast float 0.000000e+00 to i32
  %663 = insertelement <4 x i32> undef, i32 %660, i32 0
  %664 = insertelement <4 x i32> %663, i32 %661, i32 1
  %665 = insertelement <4 x i32> %664, i32 %662, i32 2
  %666 = insertelement <4 x i32> %665, i32 undef, i32 3
  %667 = call <4 x float> @llvm.SI.samplel.v4i32(<4 x i32> %666, <32 x i8> %127, <16 x i8> %129, i32 2)
  %668 = extractelement <4 x float> %667, i32 0
  %669 = extractelement <4 x float> %667, i32 1
  %670 = bitcast float %653 to i32
  %671 = bitcast float %655 to i32
  %672 = bitcast float 0.000000e+00 to i32
  %673 = insertelement <4 x i32> undef, i32 %670, i32 0
  %674 = insertelement <4 x i32> %673, i32 %671, i32 1
  %675 = insertelement <4 x i32> %674, i32 %672, i32 2
  %676 = insertelement <4 x i32> %675, i32 undef, i32 3
  %677 = call <4 x float> @llvm.SI.samplel.v4i32(<4 x i32> %676, <32 x i8> %127, <16 x i8> %129, i32 2)
  %678 = extractelement <4 x float> %677, i32 0
  %679 = extractelement <4 x float> %677, i32 1
  %680 = fsub float -0.000000e+00, %669
  %681 = fadd float 1.000000e+00, %680
  %682 = fsub float -0.000000e+00, %679
  %683 = fadd float 1.000000e+00, %682
  %684 = fmul float %681, 2.500000e-01
  %685 = fmul float %683, 2.500000e-01
  %686 = fsub float -0.000000e+00, %684
  %687 = fadd float %668, %686
  %688 = fsub float -0.000000e+00, %685
  %689 = fadd float %678, %688
  %690 = fmul float %647, %temp88.0
  %691 = fadd float %690, %temp89.0
  %692 = fmul float %647, %temp90.0
  %693 = fadd float %692, %temp91.0
  %694 = call float @llvm.AMDIL.clamp.(float %691, float 0.000000e+00, float 1.000000e+00)
  %695 = call float @llvm.AMDIL.clamp.(float %693, float 0.000000e+00, float 1.000000e+00)
  %696 = fsub float -0.000000e+00, %694
  %697 = fadd float %668, %696
  %698 = fsub float -0.000000e+00, %695
  %699 = fadd float %678, %698
  %700 = fmul float %668, %668
  %701 = fmul float %678, %678
  %702 = fsub float -0.000000e+00, %700
  %703 = fadd float %687, %702
  %704 = fsub float -0.000000e+00, %701
  %705 = fadd float %689, %704
  %706 = fcmp uge float %703, %75
  %707 = select i1 %706, float %703, float %75
  %708 = fcmp uge float %705, %75
  %709 = select i1 %708, float %705, float %75
  %710 = fmul float %697, %697
  %711 = fadd float %710, %707
  %712 = fmul float %699, %699
  %713 = fadd float %712, %709
  %714 = fdiv float 1.000000e+00, %711
  %715 = fdiv float 1.000000e+00, %713
  %716 = fmul float %707, %714
  %717 = fmul float %709, %715
  %718 = fcmp oge float %697, 0.000000e+00
  %719 = sext i1 %718 to i32
  %720 = bitcast i32 %719 to float
  %721 = bitcast float %720 to i32
  %722 = icmp ne i32 %721, 0
  %.229 = select i1 %722, float 1.000000e+00, float %716
  %723 = fcmp oge float %699, 0.000000e+00
  %724 = sext i1 %723 to i32
  %725 = bitcast i32 %724 to float
  %726 = bitcast float %725 to i32
  %727 = icmp ne i32 %726, 0
  %temp28.0 = select i1 %727, float 1.000000e+00, float %717
  %728 = call float @llvm.AMDGPU.lrp(float %659, float %temp28.0, float %.229)
  %729 = call float @llvm.pow.f32(float %728, float %76)
  %730 = fmul float %729, %79
  %731 = fadd float %730, %80
  %732 = call float @llvm.AMDIL.clamp.(float %731, float 0.000000e+00, float 1.000000e+00)
  %733 = fmul float %732, %732
  %734 = fmul float 2.000000e+00, %732
  %735 = fsub float -0.000000e+00, %734
  %736 = fadd float 3.000000e+00, %735
  %737 = fmul float %733, %736
  %738 = fmul float %548, %737
  %739 = fmul float %549, %737
  %740 = fmul float %550, %737
  %741 = fmul float %738, %515
  %742 = fadd float %741, %533
  %743 = fmul float %739, %515
  %744 = fadd float %743, %534
  %745 = fmul float %740, %515
  %746 = fadd float %745, %535
  %747 = call float @llvm.AMDGPU.lrp(float %230, float %287, float 1.000000e+00)
  %748 = call float @llvm.AMDGPU.lrp(float %37, float %298, float 1.000000e+00)
  %749 = call float @llvm.AMDGPU.lrp(float %37, float %299, float 1.000000e+00)
  %750 = call float @llvm.AMDGPU.lrp(float %37, float %300, float 1.000000e+00)
  %751 = call float @llvm.AMDGPU.lrp(float %38, float %747, float 1.000000e+00)
  %752 = fmul float %748, %751
  %753 = fmul float %749, %751
  %754 = fmul float %750, %751
  %755 = fmul float %742, %752
  %756 = fmul float %744, %753
  %757 = fmul float %746, %754
  %758 = fmul float %temp12.0, %216
  %759 = fmul float %temp13.0, %217
  %760 = fadd float %759, %758
  %761 = fmul float %temp14.0, %218
  %762 = fadd float %760, %761
  %763 = call float @fabs(float %762)
  %764 = fmul float %763, %763
  %765 = fmul float %764, %50
  %766 = fadd float %765, %51
  %767 = call float @llvm.AMDIL.clamp.(float %766, float 0.000000e+00, float 1.000000e+00)
  %768 = fsub float -0.000000e+00, %767
  %769 = fadd float 1.000000e+00, %768
  %770 = fmul float %33, %769
  %771 = fmul float %33, %769
  %772 = fmul float %33, %769
  %773 = fmul float %34, %769
  %774 = call float @llvm.AMDGPU.lrp(float %770, float %31, float %755)
  %775 = call float @llvm.AMDGPU.lrp(float %771, float %31, float %756)
  %776 = call float @llvm.AMDGPU.lrp(float %772, float %31, float %757)
  %777 = call float @llvm.AMDGPU.lrp(float %773, float %32, float %374)
  %778 = fcmp uge float %774, 0x3E6FFFFE60000000
  %779 = select i1 %778, float %774, float 0x3E6FFFFE60000000
  %780 = fcmp uge float %775, 0x3E6FFFFE60000000
  %781 = select i1 %780, float %775, float 0x3E6FFFFE60000000
  %782 = fcmp uge float %776, 0x3E6FFFFE60000000
  %783 = select i1 %782, float %776, float 0x3E6FFFFE60000000
  %784 = fcmp uge float %779, 6.550400e+04
  %785 = select i1 %784, float 6.550400e+04, float %779
  %786 = fcmp uge float %781, 6.550400e+04
  %787 = select i1 %786, float 6.550400e+04, float %781
  %788 = fcmp uge float %783, 6.550400e+04
  %789 = select i1 %788, float 6.550400e+04, float %783
  %790 = fmul float %777, %52
  %791 = fadd float %790, %53
  %792 = call float @llvm.AMDIL.clamp.(float %791, float 0.000000e+00, float 1.000000e+00)
  %793 = call i32 @llvm.SI.packf16(float %785, float %787)
  %794 = bitcast i32 %793 to float
  %795 = call i32 @llvm.SI.packf16(float %789, float %792)
  %796 = bitcast i32 %795 to float
  call void @llvm.SI.export(i32 15, i32 1, i32 1, i32 0, i32 1, float %794, float %796, float %794, float %796)
  ret void

ELSE214:                                          ; preds = %ELSE211
  %797 = fcmp olt float %565, %81
  %798 = sext i1 %797 to i32
  %799 = bitcast i32 %798 to float
  %800 = bitcast float %799 to i32
  %801 = icmp ne i32 %800, 0
  %.230 = select i1 %801, float %104, float %100
  %.231 = select i1 %801, float %105, float %101
  %.232 = select i1 %801, float %106, float %102
  %.233 = select i1 %801, float %107, float %103
  br label %ENDIF209
}

; Function Attrs: readnone
declare float @llvm.AMDIL.clamp.(float, float, float) #2

; Function Attrs: nounwind readnone
declare <4 x float> @llvm.SI.sample.v2i32(<2 x i32>, <32 x i8>, <16 x i8>, i32) #1

; Function Attrs: readnone
declare float @llvm.AMDGPU.lrp(float, float, float) #2

; Function Attrs: nounwind readnone
declare <4 x float> @llvm.SI.samplel.v4i32(<4 x i32>, <32 x i8>, <16 x i8>, i32) #1

; Function Attrs: readnone
declare float @llvm.AMDGPU.cndlt(float, float, float) #2

; Function Attrs: readnone
declare float @llvm.AMDIL.exp.(float) #2

attributes #0 = { "ShaderType"="0" }
attributes #1 = { nounwind readnone }
attributes #2 = { readnone }
attributes #3 = { nounwind readonly }
attributes #4 = { readonly }
