// RUN: llvm-mc -triple x86_64-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: vpmullq %zmm18, %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xa2,0xbd,0x40,0x40,0xd2]
          vpmullq %zmm18, %zmm24, %zmm18

// CHECK: vpmullq %zmm18, %zmm24, %zmm18 {%k2}
// CHECK:  encoding: [0x62,0xa2,0xbd,0x42,0x40,0xd2]
          vpmullq %zmm18, %zmm24, %zmm18 {%k2}

// CHECK: vpmullq %zmm18, %zmm24, %zmm18 {%k2} {z}
// CHECK:  encoding: [0x62,0xa2,0xbd,0xc2,0x40,0xd2]
          vpmullq %zmm18, %zmm24, %zmm18 {%k2} {z}

// CHECK: vpmullq (%rcx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x40,0x11]
          vpmullq (%rcx), %zmm24, %zmm18

// CHECK: vpmullq 291(%rax,%r14,8), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xa2,0xbd,0x40,0x40,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmullq 291(%rax,%r14,8), %zmm24, %zmm18

// CHECK: vpmullq (%rcx){1to8}, %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x50,0x40,0x11]
          vpmullq (%rcx){1to8}, %zmm24, %zmm18

// CHECK: vpmullq 8128(%rdx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x40,0x52,0x7f]
          vpmullq 8128(%rdx), %zmm24, %zmm18

// CHECK: vpmullq 8192(%rdx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x40,0x92,0x00,0x20,0x00,0x00]
          vpmullq 8192(%rdx), %zmm24, %zmm18

// CHECK: vpmullq -8192(%rdx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x40,0x52,0x80]
          vpmullq -8192(%rdx), %zmm24, %zmm18

// CHECK: vpmullq -8256(%rdx), %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x40,0x40,0x92,0xc0,0xdf,0xff,0xff]
          vpmullq -8256(%rdx), %zmm24, %zmm18

// CHECK: vpmullq 1016(%rdx){1to8}, %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x50,0x40,0x52,0x7f]
          vpmullq 1016(%rdx){1to8}, %zmm24, %zmm18

// CHECK: vpmullq 1024(%rdx){1to8}, %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x50,0x40,0x92,0x00,0x04,0x00,0x00]
          vpmullq 1024(%rdx){1to8}, %zmm24, %zmm18

// CHECK: vpmullq -1024(%rdx){1to8}, %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x50,0x40,0x52,0x80]
          vpmullq -1024(%rdx){1to8}, %zmm24, %zmm18

// CHECK: vpmullq -1032(%rdx){1to8}, %zmm24, %zmm18
// CHECK:  encoding: [0x62,0xe2,0xbd,0x50,0x40,0x92,0xf8,0xfb,0xff,0xff]
          vpmullq -1032(%rdx){1to8}, %zmm24, %zmm18

// CHECK: kandb  %k6, %k5, %k2
// CHECK:  encoding: [0xc5,0xd5,0x41,0xd6]
          kandb  %k6, %k5, %k2

// CHECK: kandnb %k4, %k6, %k5
// CHECK:  encoding: [0xc5,0xcd,0x42,0xec]
          kandnb %k4, %k6, %k5

// CHECK: korb   %k5, %k4, %k4
// CHECK:  encoding: [0xc5,0xdd,0x45,0xe5]
          korb   %k5, %k4, %k4

// CHECK: kxnorb %k7, %k6, %k4
// CHECK:  encoding: [0xc5,0xcd,0x46,0xe7]
          kxnorb %k7, %k6, %k4

// CHECK: kxorb  %k5, %k6, %k4
// CHECK:  encoding: [0xc5,0xcd,0x47,0xe5]
          kxorb  %k5, %k6, %k4

// CHECK: knotb  %k4, %k5
// CHECK:  encoding: [0xc5,0xf9,0x44,0xec]
          knotb  %k4, %k5

// CHECK: knotb  %k3, %k3
// CHECK:  encoding: [0xc5,0xf9,0x44,0xdb]
          knotb  %k3, %k3

// CHECK: kmovb  %k3, %k5
// CHECK:  encoding: [0xc5,0xf9,0x90,0xeb]
          kmovb  %k3, %k5

// CHECK: kmovb  (%rcx), %k5
// CHECK:  encoding: [0xc5,0xf9,0x90,0x29]
          kmovb  (%rcx), %k5

// CHECK: kmovb  4660(%rax,%r14,8), %k5
// CHECK:  encoding: [0xc4,0xa1,0x79,0x90,0xac,0xf0,0x34,0x12,0x00,0x00]
          kmovb  4660(%rax,%r14,8), %k5

// CHECK: kmovb  %k2, (%rcx)
// CHECK:  encoding: [0xc5,0xf9,0x91,0x11]
          kmovb  %k2, (%rcx)

// CHECK: kmovb  %k2, 4660(%rax,%r14,8)
// CHECK:  encoding: [0xc4,0xa1,0x79,0x91,0x94,0xf0,0x34,0x12,0x00,0x00]
          kmovb  %k2, 4660(%rax,%r14,8)

// CHECK: kmovb  %eax, %k2
// CHECK:  encoding: [0xc5,0xf9,0x92,0xd0]
          kmovb  %eax, %k2

// CHECK: kmovb  %ebp, %k2
// CHECK:  encoding: [0xc5,0xf9,0x92,0xd5]
          kmovb  %ebp, %k2

// CHECK: kmovb  %r13d, %k2
// CHECK:  encoding: [0xc4,0xc1,0x79,0x92,0xd5]
          kmovb  %r13d, %k2

// CHECK: kmovb  %k3, %eax
// CHECK:  encoding: [0xc5,0xf9,0x93,0xc3]
          kmovb  %k3, %eax

// CHECK: kmovb  %k3, %ebp
// CHECK:  encoding: [0xc5,0xf9,0x93,0xeb]
          kmovb  %k3, %ebp

// CHECK: kmovb  %k3, %r13d
// CHECK:  encoding: [0xc5,0x79,0x93,0xeb]
          kmovb  %k3, %r13d

// CHECK: vandpd %zmm27, %zmm28, %zmm19
// CHECK:  encoding: [0x62,0x81,0x9d,0x40,0x54,0xdb]
          vandpd %zmm27, %zmm28, %zmm19

// CHECK: vandpd %zmm27, %zmm28, %zmm19 {%k5}
// CHECK:  encoding: [0x62,0x81,0x9d,0x45,0x54,0xdb]
          vandpd %zmm27, %zmm28, %zmm19 {%k5}

// CHECK: vandpd %zmm27, %zmm28, %zmm19 {%k5} {z}
// CHECK:  encoding: [0x62,0x81,0x9d,0xc5,0x54,0xdb]
          vandpd %zmm27, %zmm28, %zmm19 {%k5} {z}

// CHECK: vandpd (%rcx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x54,0x19]
          vandpd (%rcx), %zmm28, %zmm19

// CHECK: vandpd 291(%rax,%r14,8), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xa1,0x9d,0x40,0x54,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vandpd 291(%rax,%r14,8), %zmm28, %zmm19

// CHECK: vandpd (%rcx){1to8}, %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x54,0x19]
          vandpd (%rcx){1to8}, %zmm28, %zmm19

// CHECK: vandpd 8128(%rdx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x54,0x5a,0x7f]
          vandpd 8128(%rdx), %zmm28, %zmm19

// CHECK: vandpd 8192(%rdx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x54,0x9a,0x00,0x20,0x00,0x00]
          vandpd 8192(%rdx), %zmm28, %zmm19

// CHECK: vandpd -8192(%rdx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x54,0x5a,0x80]
          vandpd -8192(%rdx), %zmm28, %zmm19

// CHECK: vandpd -8256(%rdx), %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x54,0x9a,0xc0,0xdf,0xff,0xff]
          vandpd -8256(%rdx), %zmm28, %zmm19

// CHECK: vandpd 1016(%rdx){1to8}, %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x54,0x5a,0x7f]
          vandpd 1016(%rdx){1to8}, %zmm28, %zmm19

// CHECK: vandpd 1024(%rdx){1to8}, %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x54,0x9a,0x00,0x04,0x00,0x00]
          vandpd 1024(%rdx){1to8}, %zmm28, %zmm19

// CHECK: vandpd -1024(%rdx){1to8}, %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x54,0x5a,0x80]
          vandpd -1024(%rdx){1to8}, %zmm28, %zmm19

// CHECK: vandpd -1032(%rdx){1to8}, %zmm28, %zmm19
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x54,0x9a,0xf8,0xfb,0xff,0xff]
          vandpd -1032(%rdx){1to8}, %zmm28, %zmm19

// CHECK: vandps %zmm25, %zmm22, %zmm17
// CHECK:  encoding: [0x62,0x81,0x4c,0x40,0x54,0xc9]
          vandps %zmm25, %zmm22, %zmm17

// CHECK: vandps %zmm25, %zmm22, %zmm17 {%k4}
// CHECK:  encoding: [0x62,0x81,0x4c,0x44,0x54,0xc9]
          vandps %zmm25, %zmm22, %zmm17 {%k4}

// CHECK: vandps %zmm25, %zmm22, %zmm17 {%k4} {z}
// CHECK:  encoding: [0x62,0x81,0x4c,0xc4,0x54,0xc9]
          vandps %zmm25, %zmm22, %zmm17 {%k4} {z}

// CHECK: vandps (%rcx), %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x40,0x54,0x09]
          vandps (%rcx), %zmm22, %zmm17

// CHECK: vandps 291(%rax,%r14,8), %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x4c,0x40,0x54,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vandps 291(%rax,%r14,8), %zmm22, %zmm17

// CHECK: vandps (%rcx){1to16}, %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x50,0x54,0x09]
          vandps (%rcx){1to16}, %zmm22, %zmm17

// CHECK: vandps 8128(%rdx), %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x40,0x54,0x4a,0x7f]
          vandps 8128(%rdx), %zmm22, %zmm17

// CHECK: vandps 8192(%rdx), %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x40,0x54,0x8a,0x00,0x20,0x00,0x00]
          vandps 8192(%rdx), %zmm22, %zmm17

// CHECK: vandps -8192(%rdx), %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x40,0x54,0x4a,0x80]
          vandps -8192(%rdx), %zmm22, %zmm17

// CHECK: vandps -8256(%rdx), %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x40,0x54,0x8a,0xc0,0xdf,0xff,0xff]
          vandps -8256(%rdx), %zmm22, %zmm17

// CHECK: vandps 508(%rdx){1to16}, %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x50,0x54,0x4a,0x7f]
          vandps 508(%rdx){1to16}, %zmm22, %zmm17

// CHECK: vandps 512(%rdx){1to16}, %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x50,0x54,0x8a,0x00,0x02,0x00,0x00]
          vandps 512(%rdx){1to16}, %zmm22, %zmm17

// CHECK: vandps -512(%rdx){1to16}, %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x50,0x54,0x4a,0x80]
          vandps -512(%rdx){1to16}, %zmm22, %zmm17

// CHECK: vandps -516(%rdx){1to16}, %zmm22, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x4c,0x50,0x54,0x8a,0xfc,0xfd,0xff,0xff]
          vandps -516(%rdx){1to16}, %zmm22, %zmm17

// CHECK: vandnpd %zmm22, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xa1,0xf5,0x40,0x55,0xe6]
          vandnpd %zmm22, %zmm17, %zmm20

// CHECK: vandnpd %zmm22, %zmm17, %zmm20 {%k1}
// CHECK:  encoding: [0x62,0xa1,0xf5,0x41,0x55,0xe6]
          vandnpd %zmm22, %zmm17, %zmm20 {%k1}

// CHECK: vandnpd %zmm22, %zmm17, %zmm20 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0xf5,0xc1,0x55,0xe6]
          vandnpd %zmm22, %zmm17, %zmm20 {%k1} {z}

// CHECK: vandnpd (%rcx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0x55,0x21]
          vandnpd (%rcx), %zmm17, %zmm20

// CHECK: vandnpd 291(%rax,%r14,8), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xa1,0xf5,0x40,0x55,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vandnpd 291(%rax,%r14,8), %zmm17, %zmm20

// CHECK: vandnpd (%rcx){1to8}, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x50,0x55,0x21]
          vandnpd (%rcx){1to8}, %zmm17, %zmm20

// CHECK: vandnpd 8128(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0x55,0x62,0x7f]
          vandnpd 8128(%rdx), %zmm17, %zmm20

// CHECK: vandnpd 8192(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0x55,0xa2,0x00,0x20,0x00,0x00]
          vandnpd 8192(%rdx), %zmm17, %zmm20

// CHECK: vandnpd -8192(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0x55,0x62,0x80]
          vandnpd -8192(%rdx), %zmm17, %zmm20

// CHECK: vandnpd -8256(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x40,0x55,0xa2,0xc0,0xdf,0xff,0xff]
          vandnpd -8256(%rdx), %zmm17, %zmm20

// CHECK: vandnpd 1016(%rdx){1to8}, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x50,0x55,0x62,0x7f]
          vandnpd 1016(%rdx){1to8}, %zmm17, %zmm20

// CHECK: vandnpd 1024(%rdx){1to8}, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x50,0x55,0xa2,0x00,0x04,0x00,0x00]
          vandnpd 1024(%rdx){1to8}, %zmm17, %zmm20

// CHECK: vandnpd -1024(%rdx){1to8}, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x50,0x55,0x62,0x80]
          vandnpd -1024(%rdx){1to8}, %zmm17, %zmm20

// CHECK: vandnpd -1032(%rdx){1to8}, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe1,0xf5,0x50,0x55,0xa2,0xf8,0xfb,0xff,0xff]
          vandnpd -1032(%rdx){1to8}, %zmm17, %zmm20

// CHECK: vandnps %zmm19, %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xa1,0x74,0x40,0x55,0xf3]
          vandnps %zmm19, %zmm17, %zmm22

// CHECK: vandnps %zmm19, %zmm17, %zmm22 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x74,0x42,0x55,0xf3]
          vandnps %zmm19, %zmm17, %zmm22 {%k2}

// CHECK: vandnps %zmm19, %zmm17, %zmm22 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x74,0xc2,0x55,0xf3]
          vandnps %zmm19, %zmm17, %zmm22 {%k2} {z}

// CHECK: vandnps (%rcx), %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x40,0x55,0x31]
          vandnps (%rcx), %zmm17, %zmm22

// CHECK: vandnps 291(%rax,%r14,8), %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xa1,0x74,0x40,0x55,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vandnps 291(%rax,%r14,8), %zmm17, %zmm22

// CHECK: vandnps (%rcx){1to16}, %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x50,0x55,0x31]
          vandnps (%rcx){1to16}, %zmm17, %zmm22

// CHECK: vandnps 8128(%rdx), %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x40,0x55,0x72,0x7f]
          vandnps 8128(%rdx), %zmm17, %zmm22

// CHECK: vandnps 8192(%rdx), %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x40,0x55,0xb2,0x00,0x20,0x00,0x00]
          vandnps 8192(%rdx), %zmm17, %zmm22

// CHECK: vandnps -8192(%rdx), %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x40,0x55,0x72,0x80]
          vandnps -8192(%rdx), %zmm17, %zmm22

// CHECK: vandnps -8256(%rdx), %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x40,0x55,0xb2,0xc0,0xdf,0xff,0xff]
          vandnps -8256(%rdx), %zmm17, %zmm22

// CHECK: vandnps 508(%rdx){1to16}, %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x50,0x55,0x72,0x7f]
          vandnps 508(%rdx){1to16}, %zmm17, %zmm22

// CHECK: vandnps 512(%rdx){1to16}, %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x50,0x55,0xb2,0x00,0x02,0x00,0x00]
          vandnps 512(%rdx){1to16}, %zmm17, %zmm22

// CHECK: vandnps -512(%rdx){1to16}, %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x50,0x55,0x72,0x80]
          vandnps -512(%rdx){1to16}, %zmm17, %zmm22

// CHECK: vandnps -516(%rdx){1to16}, %zmm17, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x74,0x50,0x55,0xb2,0xfc,0xfd,0xff,0xff]
          vandnps -516(%rdx){1to16}, %zmm17, %zmm22

// CHECK: vorpd  %zmm21, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x21,0xcd,0x40,0x56,0xf5]
          vorpd  %zmm21, %zmm22, %zmm30

// CHECK: vorpd  %zmm21, %zmm22, %zmm30 {%k6}
// CHECK:  encoding: [0x62,0x21,0xcd,0x46,0x56,0xf5]
          vorpd  %zmm21, %zmm22, %zmm30 {%k6}

// CHECK: vorpd  %zmm21, %zmm22, %zmm30 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0xcd,0xc6,0x56,0xf5]
          vorpd  %zmm21, %zmm22, %zmm30 {%k6} {z}

// CHECK: vorpd  (%rcx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x56,0x31]
          vorpd  (%rcx), %zmm22, %zmm30

// CHECK: vorpd  291(%rax,%r14,8), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x21,0xcd,0x40,0x56,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vorpd  291(%rax,%r14,8), %zmm22, %zmm30

// CHECK: vorpd  (%rcx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x56,0x31]
          vorpd  (%rcx){1to8}, %zmm22, %zmm30

// CHECK: vorpd  8128(%rdx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x56,0x72,0x7f]
          vorpd  8128(%rdx), %zmm22, %zmm30

// CHECK: vorpd  8192(%rdx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x56,0xb2,0x00,0x20,0x00,0x00]
          vorpd  8192(%rdx), %zmm22, %zmm30

// CHECK: vorpd  -8192(%rdx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x56,0x72,0x80]
          vorpd  -8192(%rdx), %zmm22, %zmm30

// CHECK: vorpd  -8256(%rdx), %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x56,0xb2,0xc0,0xdf,0xff,0xff]
          vorpd  -8256(%rdx), %zmm22, %zmm30

// CHECK: vorpd  1016(%rdx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x56,0x72,0x7f]
          vorpd  1016(%rdx){1to8}, %zmm22, %zmm30

// CHECK: vorpd  1024(%rdx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x56,0xb2,0x00,0x04,0x00,0x00]
          vorpd  1024(%rdx){1to8}, %zmm22, %zmm30

// CHECK: vorpd  -1024(%rdx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x56,0x72,0x80]
          vorpd  -1024(%rdx){1to8}, %zmm22, %zmm30

// CHECK: vorpd  -1032(%rdx){1to8}, %zmm22, %zmm30
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x56,0xb2,0xf8,0xfb,0xff,0xff]
          vorpd  -1032(%rdx){1to8}, %zmm22, %zmm30

// CHECK: vorps  %zmm26, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0x81,0x54,0x40,0x56,0xf2]
          vorps  %zmm26, %zmm21, %zmm22

// CHECK: vorps  %zmm26, %zmm21, %zmm22 {%k7}
// CHECK:  encoding: [0x62,0x81,0x54,0x47,0x56,0xf2]
          vorps  %zmm26, %zmm21, %zmm22 {%k7}

// CHECK: vorps  %zmm26, %zmm21, %zmm22 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0x54,0xc7,0x56,0xf2]
          vorps  %zmm26, %zmm21, %zmm22 {%k7} {z}

// CHECK: vorps  (%rcx), %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x56,0x31]
          vorps  (%rcx), %zmm21, %zmm22

// CHECK: vorps  291(%rax,%r14,8), %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xa1,0x54,0x40,0x56,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vorps  291(%rax,%r14,8), %zmm21, %zmm22

// CHECK: vorps  (%rcx){1to16}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x56,0x31]
          vorps  (%rcx){1to16}, %zmm21, %zmm22

// CHECK: vorps  8128(%rdx), %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x56,0x72,0x7f]
          vorps  8128(%rdx), %zmm21, %zmm22

// CHECK: vorps  8192(%rdx), %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x56,0xb2,0x00,0x20,0x00,0x00]
          vorps  8192(%rdx), %zmm21, %zmm22

// CHECK: vorps  -8192(%rdx), %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x56,0x72,0x80]
          vorps  -8192(%rdx), %zmm21, %zmm22

// CHECK: vorps  -8256(%rdx), %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x56,0xb2,0xc0,0xdf,0xff,0xff]
          vorps  -8256(%rdx), %zmm21, %zmm22

// CHECK: vorps  508(%rdx){1to16}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x56,0x72,0x7f]
          vorps  508(%rdx){1to16}, %zmm21, %zmm22

// CHECK: vorps  512(%rdx){1to16}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x56,0xb2,0x00,0x02,0x00,0x00]
          vorps  512(%rdx){1to16}, %zmm21, %zmm22

// CHECK: vorps  -512(%rdx){1to16}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x56,0x72,0x80]
          vorps  -512(%rdx){1to16}, %zmm21, %zmm22

// CHECK: vorps  -516(%rdx){1to16}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x56,0xb2,0xfc,0xfd,0xff,0xff]
          vorps  -516(%rdx){1to16}, %zmm21, %zmm22

// CHECK: vxorpd %zmm24, %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x01,0xbd,0x40,0x57,0xd8]
          vxorpd %zmm24, %zmm24, %zmm27

// CHECK: vxorpd %zmm24, %zmm24, %zmm27 {%k5}
// CHECK:  encoding: [0x62,0x01,0xbd,0x45,0x57,0xd8]
          vxorpd %zmm24, %zmm24, %zmm27 {%k5}

// CHECK: vxorpd %zmm24, %zmm24, %zmm27 {%k5} {z}
// CHECK:  encoding: [0x62,0x01,0xbd,0xc5,0x57,0xd8]
          vxorpd %zmm24, %zmm24, %zmm27 {%k5} {z}

// CHECK: vxorpd (%rcx), %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x40,0x57,0x19]
          vxorpd (%rcx), %zmm24, %zmm27

// CHECK: vxorpd 291(%rax,%r14,8), %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x21,0xbd,0x40,0x57,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vxorpd 291(%rax,%r14,8), %zmm24, %zmm27

// CHECK: vxorpd (%rcx){1to8}, %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x50,0x57,0x19]
          vxorpd (%rcx){1to8}, %zmm24, %zmm27

// CHECK: vxorpd 8128(%rdx), %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x40,0x57,0x5a,0x7f]
          vxorpd 8128(%rdx), %zmm24, %zmm27

// CHECK: vxorpd 8192(%rdx), %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x40,0x57,0x9a,0x00,0x20,0x00,0x00]
          vxorpd 8192(%rdx), %zmm24, %zmm27

// CHECK: vxorpd -8192(%rdx), %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x40,0x57,0x5a,0x80]
          vxorpd -8192(%rdx), %zmm24, %zmm27

// CHECK: vxorpd -8256(%rdx), %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x40,0x57,0x9a,0xc0,0xdf,0xff,0xff]
          vxorpd -8256(%rdx), %zmm24, %zmm27

// CHECK: vxorpd 1016(%rdx){1to8}, %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x50,0x57,0x5a,0x7f]
          vxorpd 1016(%rdx){1to8}, %zmm24, %zmm27

// CHECK: vxorpd 1024(%rdx){1to8}, %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x50,0x57,0x9a,0x00,0x04,0x00,0x00]
          vxorpd 1024(%rdx){1to8}, %zmm24, %zmm27

// CHECK: vxorpd -1024(%rdx){1to8}, %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x50,0x57,0x5a,0x80]
          vxorpd -1024(%rdx){1to8}, %zmm24, %zmm27

// CHECK: vxorpd -1032(%rdx){1to8}, %zmm24, %zmm27
// CHECK:  encoding: [0x62,0x61,0xbd,0x50,0x57,0x9a,0xf8,0xfb,0xff,0xff]
          vxorpd -1032(%rdx){1to8}, %zmm24, %zmm27

// CHECK: vxorps %zmm19, %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x6c,0x40,0x57,0xd3]
          vxorps %zmm19, %zmm18, %zmm18

// CHECK: vxorps %zmm19, %zmm18, %zmm18 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x6c,0x42,0x57,0xd3]
          vxorps %zmm19, %zmm18, %zmm18 {%k2}

// CHECK: vxorps %zmm19, %zmm18, %zmm18 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x6c,0xc2,0x57,0xd3]
          vxorps %zmm19, %zmm18, %zmm18 {%k2} {z}

// CHECK: vxorps (%rcx), %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x40,0x57,0x11]
          vxorps (%rcx), %zmm18, %zmm18

// CHECK: vxorps 291(%rax,%r14,8), %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x6c,0x40,0x57,0x94,0xf0,0x23,0x01,0x00,0x00]
          vxorps 291(%rax,%r14,8), %zmm18, %zmm18

// CHECK: vxorps (%rcx){1to16}, %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x50,0x57,0x11]
          vxorps (%rcx){1to16}, %zmm18, %zmm18

// CHECK: vxorps 8128(%rdx), %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x40,0x57,0x52,0x7f]
          vxorps 8128(%rdx), %zmm18, %zmm18

// CHECK: vxorps 8192(%rdx), %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x40,0x57,0x92,0x00,0x20,0x00,0x00]
          vxorps 8192(%rdx), %zmm18, %zmm18

// CHECK: vxorps -8192(%rdx), %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x40,0x57,0x52,0x80]
          vxorps -8192(%rdx), %zmm18, %zmm18

// CHECK: vxorps -8256(%rdx), %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x40,0x57,0x92,0xc0,0xdf,0xff,0xff]
          vxorps -8256(%rdx), %zmm18, %zmm18

// CHECK: vxorps 508(%rdx){1to16}, %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x50,0x57,0x52,0x7f]
          vxorps 508(%rdx){1to16}, %zmm18, %zmm18

// CHECK: vxorps 512(%rdx){1to16}, %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x50,0x57,0x92,0x00,0x02,0x00,0x00]
          vxorps 512(%rdx){1to16}, %zmm18, %zmm18

// CHECK: vxorps -512(%rdx){1to16}, %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x50,0x57,0x52,0x80]
          vxorps -512(%rdx){1to16}, %zmm18, %zmm18

// CHECK: vxorps -516(%rdx){1to16}, %zmm18, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x6c,0x50,0x57,0x92,0xfc,0xfd,0xff,0xff]
          vxorps -516(%rdx){1to16}, %zmm18, %zmm18
// CHECK: vandpd %zmm22, %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x21,0xcd,0x40,0x54,0xc6]
          vandpd %zmm22, %zmm22, %zmm24

// CHECK: vandpd %zmm22, %zmm22, %zmm24 {%k4}
// CHECK:  encoding: [0x62,0x21,0xcd,0x44,0x54,0xc6]
          vandpd %zmm22, %zmm22, %zmm24 {%k4}

// CHECK: vandpd %zmm22, %zmm22, %zmm24 {%k4} {z}
// CHECK:  encoding: [0x62,0x21,0xcd,0xc4,0x54,0xc6]
          vandpd %zmm22, %zmm22, %zmm24 {%k4} {z}

// CHECK: vandpd (%rcx), %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x54,0x01]
          vandpd (%rcx), %zmm22, %zmm24

// CHECK: vandpd 4660(%rax,%r14,8), %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x21,0xcd,0x40,0x54,0x84,0xf0,0x34,0x12,0x00,0x00]
          vandpd 4660(%rax,%r14,8), %zmm22, %zmm24

// CHECK: vandpd (%rcx){1to8}, %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x54,0x01]
          vandpd (%rcx){1to8}, %zmm22, %zmm24

// CHECK: vandpd 8128(%rdx), %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x54,0x42,0x7f]
          vandpd 8128(%rdx), %zmm22, %zmm24

// CHECK: vandpd 8192(%rdx), %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x54,0x82,0x00,0x20,0x00,0x00]
          vandpd 8192(%rdx), %zmm22, %zmm24

// CHECK: vandpd -8192(%rdx), %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x54,0x42,0x80]
          vandpd -8192(%rdx), %zmm22, %zmm24

// CHECK: vandpd -8256(%rdx), %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x40,0x54,0x82,0xc0,0xdf,0xff,0xff]
          vandpd -8256(%rdx), %zmm22, %zmm24

// CHECK: vandpd 1016(%rdx){1to8}, %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x54,0x42,0x7f]
          vandpd 1016(%rdx){1to8}, %zmm22, %zmm24

// CHECK: vandpd 1024(%rdx){1to8}, %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x54,0x82,0x00,0x04,0x00,0x00]
          vandpd 1024(%rdx){1to8}, %zmm22, %zmm24

// CHECK: vandpd -1024(%rdx){1to8}, %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x54,0x42,0x80]
          vandpd -1024(%rdx){1to8}, %zmm22, %zmm24

// CHECK: vandpd -1032(%rdx){1to8}, %zmm22, %zmm24
// CHECK:  encoding: [0x62,0x61,0xcd,0x50,0x54,0x82,0xf8,0xfb,0xff,0xff]
          vandpd -1032(%rdx){1to8}, %zmm22, %zmm24

// CHECK: vandps %zmm23, %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x21,0x44,0x40,0x54,0xf7]
          vandps %zmm23, %zmm23, %zmm30

// CHECK: vandps %zmm23, %zmm23, %zmm30 {%k5}
// CHECK:  encoding: [0x62,0x21,0x44,0x45,0x54,0xf7]
          vandps %zmm23, %zmm23, %zmm30 {%k5}

// CHECK: vandps %zmm23, %zmm23, %zmm30 {%k5} {z}
// CHECK:  encoding: [0x62,0x21,0x44,0xc5,0x54,0xf7]
          vandps %zmm23, %zmm23, %zmm30 {%k5} {z}

// CHECK: vandps (%rcx), %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x40,0x54,0x31]
          vandps (%rcx), %zmm23, %zmm30

// CHECK: vandps 4660(%rax,%r14,8), %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x21,0x44,0x40,0x54,0xb4,0xf0,0x34,0x12,0x00,0x00]
          vandps 4660(%rax,%r14,8), %zmm23, %zmm30

// CHECK: vandps (%rcx){1to16}, %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x50,0x54,0x31]
          vandps (%rcx){1to16}, %zmm23, %zmm30

// CHECK: vandps 8128(%rdx), %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x40,0x54,0x72,0x7f]
          vandps 8128(%rdx), %zmm23, %zmm30

// CHECK: vandps 8192(%rdx), %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x40,0x54,0xb2,0x00,0x20,0x00,0x00]
          vandps 8192(%rdx), %zmm23, %zmm30

// CHECK: vandps -8192(%rdx), %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x40,0x54,0x72,0x80]
          vandps -8192(%rdx), %zmm23, %zmm30

// CHECK: vandps -8256(%rdx), %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x40,0x54,0xb2,0xc0,0xdf,0xff,0xff]
          vandps -8256(%rdx), %zmm23, %zmm30

// CHECK: vandps 508(%rdx){1to16}, %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x50,0x54,0x72,0x7f]
          vandps 508(%rdx){1to16}, %zmm23, %zmm30

// CHECK: vandps 512(%rdx){1to16}, %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x50,0x54,0xb2,0x00,0x02,0x00,0x00]
          vandps 512(%rdx){1to16}, %zmm23, %zmm30

// CHECK: vandps -512(%rdx){1to16}, %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x50,0x54,0x72,0x80]
          vandps -512(%rdx){1to16}, %zmm23, %zmm30

// CHECK: vandps -516(%rdx){1to16}, %zmm23, %zmm30
// CHECK:  encoding: [0x62,0x61,0x44,0x50,0x54,0xb2,0xfc,0xfd,0xff,0xff]
          vandps -516(%rdx){1to16}, %zmm23, %zmm30

// CHECK: vandnpd %zmm21, %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x21,0xd5,0x40,0x55,0xcd]
          vandnpd %zmm21, %zmm21, %zmm25

// CHECK: vandnpd %zmm21, %zmm21, %zmm25 {%k2}
// CHECK:  encoding: [0x62,0x21,0xd5,0x42,0x55,0xcd]
          vandnpd %zmm21, %zmm21, %zmm25 {%k2}

// CHECK: vandnpd %zmm21, %zmm21, %zmm25 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0xd5,0xc2,0x55,0xcd]
          vandnpd %zmm21, %zmm21, %zmm25 {%k2} {z}

// CHECK: vandnpd (%rcx), %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x40,0x55,0x09]
          vandnpd (%rcx), %zmm21, %zmm25

// CHECK: vandnpd 4660(%rax,%r14,8), %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x21,0xd5,0x40,0x55,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vandnpd 4660(%rax,%r14,8), %zmm21, %zmm25

// CHECK: vandnpd (%rcx){1to8}, %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x50,0x55,0x09]
          vandnpd (%rcx){1to8}, %zmm21, %zmm25

// CHECK: vandnpd 8128(%rdx), %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x40,0x55,0x4a,0x7f]
          vandnpd 8128(%rdx), %zmm21, %zmm25

// CHECK: vandnpd 8192(%rdx), %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x40,0x55,0x8a,0x00,0x20,0x00,0x00]
          vandnpd 8192(%rdx), %zmm21, %zmm25

// CHECK: vandnpd -8192(%rdx), %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x40,0x55,0x4a,0x80]
          vandnpd -8192(%rdx), %zmm21, %zmm25

// CHECK: vandnpd -8256(%rdx), %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x40,0x55,0x8a,0xc0,0xdf,0xff,0xff]
          vandnpd -8256(%rdx), %zmm21, %zmm25

// CHECK: vandnpd 1016(%rdx){1to8}, %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x50,0x55,0x4a,0x7f]
          vandnpd 1016(%rdx){1to8}, %zmm21, %zmm25

// CHECK: vandnpd 1024(%rdx){1to8}, %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x50,0x55,0x8a,0x00,0x04,0x00,0x00]
          vandnpd 1024(%rdx){1to8}, %zmm21, %zmm25

// CHECK: vandnpd -1024(%rdx){1to8}, %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x50,0x55,0x4a,0x80]
          vandnpd -1024(%rdx){1to8}, %zmm21, %zmm25

// CHECK: vandnpd -1032(%rdx){1to8}, %zmm21, %zmm25
// CHECK:  encoding: [0x62,0x61,0xd5,0x50,0x55,0x8a,0xf8,0xfb,0xff,0xff]
          vandnpd -1032(%rdx){1to8}, %zmm21, %zmm25

// CHECK: vandnps %zmm18, %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x54,0x40,0x55,0xca]
          vandnps %zmm18, %zmm21, %zmm17

// CHECK: vandnps %zmm18, %zmm21, %zmm17 {%k1}
// CHECK:  encoding: [0x62,0xa1,0x54,0x41,0x55,0xca]
          vandnps %zmm18, %zmm21, %zmm17 {%k1}

// CHECK: vandnps %zmm18, %zmm21, %zmm17 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0x54,0xc1,0x55,0xca]
          vandnps %zmm18, %zmm21, %zmm17 {%k1} {z}

// CHECK: vandnps (%rcx), %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x55,0x09]
          vandnps (%rcx), %zmm21, %zmm17

// CHECK: vandnps 4660(%rax,%r14,8), %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xa1,0x54,0x40,0x55,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vandnps 4660(%rax,%r14,8), %zmm21, %zmm17

// CHECK: vandnps (%rcx){1to16}, %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x55,0x09]
          vandnps (%rcx){1to16}, %zmm21, %zmm17

// CHECK: vandnps 8128(%rdx), %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x55,0x4a,0x7f]
          vandnps 8128(%rdx), %zmm21, %zmm17

// CHECK: vandnps 8192(%rdx), %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x55,0x8a,0x00,0x20,0x00,0x00]
          vandnps 8192(%rdx), %zmm21, %zmm17

// CHECK: vandnps -8192(%rdx), %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x55,0x4a,0x80]
          vandnps -8192(%rdx), %zmm21, %zmm17

// CHECK: vandnps -8256(%rdx), %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x40,0x55,0x8a,0xc0,0xdf,0xff,0xff]
          vandnps -8256(%rdx), %zmm21, %zmm17

// CHECK: vandnps 508(%rdx){1to16}, %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x55,0x4a,0x7f]
          vandnps 508(%rdx){1to16}, %zmm21, %zmm17

// CHECK: vandnps 512(%rdx){1to16}, %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x55,0x8a,0x00,0x02,0x00,0x00]
          vandnps 512(%rdx){1to16}, %zmm21, %zmm17

// CHECK: vandnps -512(%rdx){1to16}, %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x55,0x4a,0x80]
          vandnps -512(%rdx){1to16}, %zmm21, %zmm17

// CHECK: vandnps -516(%rdx){1to16}, %zmm21, %zmm17
// CHECK:  encoding: [0x62,0xe1,0x54,0x50,0x55,0x8a,0xfc,0xfd,0xff,0xff]
          vandnps -516(%rdx){1to16}, %zmm21, %zmm17

// CHECK: vorpd  %zmm24, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0x81,0x9d,0x40,0x56,0xd0]
          vorpd  %zmm24, %zmm28, %zmm18

// CHECK: vorpd  %zmm24, %zmm28, %zmm18 {%k1}
// CHECK:  encoding: [0x62,0x81,0x9d,0x41,0x56,0xd0]
          vorpd  %zmm24, %zmm28, %zmm18 {%k1}

// CHECK: vorpd  %zmm24, %zmm28, %zmm18 {%k1} {z}
// CHECK:  encoding: [0x62,0x81,0x9d,0xc1,0x56,0xd0]
          vorpd  %zmm24, %zmm28, %zmm18 {%k1} {z}

// CHECK: vorpd  (%rcx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x56,0x11]
          vorpd  (%rcx), %zmm28, %zmm18

// CHECK: vorpd  4660(%rax,%r14,8), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xa1,0x9d,0x40,0x56,0x94,0xf0,0x34,0x12,0x00,0x00]
          vorpd  4660(%rax,%r14,8), %zmm28, %zmm18

// CHECK: vorpd  (%rcx){1to8}, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x56,0x11]
          vorpd  (%rcx){1to8}, %zmm28, %zmm18

// CHECK: vorpd  8128(%rdx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x56,0x52,0x7f]
          vorpd  8128(%rdx), %zmm28, %zmm18

// CHECK: vorpd  8192(%rdx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x56,0x92,0x00,0x20,0x00,0x00]
          vorpd  8192(%rdx), %zmm28, %zmm18

// CHECK: vorpd  -8192(%rdx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x56,0x52,0x80]
          vorpd  -8192(%rdx), %zmm28, %zmm18

// CHECK: vorpd  -8256(%rdx), %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x40,0x56,0x92,0xc0,0xdf,0xff,0xff]
          vorpd  -8256(%rdx), %zmm28, %zmm18

// CHECK: vorpd  1016(%rdx){1to8}, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x56,0x52,0x7f]
          vorpd  1016(%rdx){1to8}, %zmm28, %zmm18

// CHECK: vorpd  1024(%rdx){1to8}, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x56,0x92,0x00,0x04,0x00,0x00]
          vorpd  1024(%rdx){1to8}, %zmm28, %zmm18

// CHECK: vorpd  -1024(%rdx){1to8}, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x56,0x52,0x80]
          vorpd  -1024(%rdx){1to8}, %zmm28, %zmm18

// CHECK: vorpd  -1032(%rdx){1to8}, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0xe1,0x9d,0x50,0x56,0x92,0xf8,0xfb,0xff,0xff]
          vorpd  -1032(%rdx){1to8}, %zmm28, %zmm18

// CHECK: vorps  %zmm23, %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x21,0x74,0x40,0x56,0xe7]
          vorps  %zmm23, %zmm17, %zmm28

// CHECK: vorps  %zmm23, %zmm17, %zmm28 {%k7}
// CHECK:  encoding: [0x62,0x21,0x74,0x47,0x56,0xe7]
          vorps  %zmm23, %zmm17, %zmm28 {%k7}

// CHECK: vorps  %zmm23, %zmm17, %zmm28 {%k7} {z}
// CHECK:  encoding: [0x62,0x21,0x74,0xc7,0x56,0xe7]
          vorps  %zmm23, %zmm17, %zmm28 {%k7} {z}

// CHECK: vorps  (%rcx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x40,0x56,0x21]
          vorps  (%rcx), %zmm17, %zmm28

// CHECK: vorps  4660(%rax,%r14,8), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x21,0x74,0x40,0x56,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vorps  4660(%rax,%r14,8), %zmm17, %zmm28

// CHECK: vorps  (%rcx){1to16}, %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x50,0x56,0x21]
          vorps  (%rcx){1to16}, %zmm17, %zmm28

// CHECK: vorps  8128(%rdx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x40,0x56,0x62,0x7f]
          vorps  8128(%rdx), %zmm17, %zmm28

// CHECK: vorps  8192(%rdx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x40,0x56,0xa2,0x00,0x20,0x00,0x00]
          vorps  8192(%rdx), %zmm17, %zmm28

// CHECK: vorps  -8192(%rdx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x40,0x56,0x62,0x80]
          vorps  -8192(%rdx), %zmm17, %zmm28

// CHECK: vorps  -8256(%rdx), %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x40,0x56,0xa2,0xc0,0xdf,0xff,0xff]
          vorps  -8256(%rdx), %zmm17, %zmm28

// CHECK: vorps  508(%rdx){1to16}, %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x50,0x56,0x62,0x7f]
          vorps  508(%rdx){1to16}, %zmm17, %zmm28

// CHECK: vorps  512(%rdx){1to16}, %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x50,0x56,0xa2,0x00,0x02,0x00,0x00]
          vorps  512(%rdx){1to16}, %zmm17, %zmm28

// CHECK: vorps  -512(%rdx){1to16}, %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x50,0x56,0x62,0x80]
          vorps  -512(%rdx){1to16}, %zmm17, %zmm28

// CHECK: vorps  -516(%rdx){1to16}, %zmm17, %zmm28
// CHECK:  encoding: [0x62,0x61,0x74,0x50,0x56,0xa2,0xfc,0xfd,0xff,0xff]
          vorps  -516(%rdx){1to16}, %zmm17, %zmm28

// CHECK: vxorpd %zmm27, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x01,0xed,0x40,0x57,0xe3]
          vxorpd %zmm27, %zmm18, %zmm28

// CHECK: vxorpd %zmm27, %zmm18, %zmm28 {%k4}
// CHECK:  encoding: [0x62,0x01,0xed,0x44,0x57,0xe3]
          vxorpd %zmm27, %zmm18, %zmm28 {%k4}

// CHECK: vxorpd %zmm27, %zmm18, %zmm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0xed,0xc4,0x57,0xe3]
          vxorpd %zmm27, %zmm18, %zmm28 {%k4} {z}

// CHECK: vxorpd (%rcx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x40,0x57,0x21]
          vxorpd (%rcx), %zmm18, %zmm28

// CHECK: vxorpd 4660(%rax,%r14,8), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x21,0xed,0x40,0x57,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vxorpd 4660(%rax,%r14,8), %zmm18, %zmm28

// CHECK: vxorpd (%rcx){1to8}, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x50,0x57,0x21]
          vxorpd (%rcx){1to8}, %zmm18, %zmm28

// CHECK: vxorpd 8128(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x40,0x57,0x62,0x7f]
          vxorpd 8128(%rdx), %zmm18, %zmm28

// CHECK: vxorpd 8192(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x40,0x57,0xa2,0x00,0x20,0x00,0x00]
          vxorpd 8192(%rdx), %zmm18, %zmm28

// CHECK: vxorpd -8192(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x40,0x57,0x62,0x80]
          vxorpd -8192(%rdx), %zmm18, %zmm28

// CHECK: vxorpd -8256(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x40,0x57,0xa2,0xc0,0xdf,0xff,0xff]
          vxorpd -8256(%rdx), %zmm18, %zmm28

// CHECK: vxorpd 1016(%rdx){1to8}, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x50,0x57,0x62,0x7f]
          vxorpd 1016(%rdx){1to8}, %zmm18, %zmm28

// CHECK: vxorpd 1024(%rdx){1to8}, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x50,0x57,0xa2,0x00,0x04,0x00,0x00]
          vxorpd 1024(%rdx){1to8}, %zmm18, %zmm28

// CHECK: vxorpd -1024(%rdx){1to8}, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x50,0x57,0x62,0x80]
          vxorpd -1024(%rdx){1to8}, %zmm18, %zmm28

// CHECK: vxorpd -1032(%rdx){1to8}, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x61,0xed,0x50,0x57,0xa2,0xf8,0xfb,0xff,0xff]
          vxorpd -1032(%rdx){1to8}, %zmm18, %zmm28

// CHECK: vxorps %zmm18, %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x21,0x1c,0x40,0x57,0xc2]
          vxorps %zmm18, %zmm28, %zmm24

// CHECK: vxorps %zmm18, %zmm28, %zmm24 {%k4}
// CHECK:  encoding: [0x62,0x21,0x1c,0x44,0x57,0xc2]
          vxorps %zmm18, %zmm28, %zmm24 {%k4}

// CHECK: vxorps %zmm18, %zmm28, %zmm24 {%k4} {z}
// CHECK:  encoding: [0x62,0x21,0x1c,0xc4,0x57,0xc2]
          vxorps %zmm18, %zmm28, %zmm24 {%k4} {z}

// CHECK: vxorps (%rcx), %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x40,0x57,0x01]
          vxorps (%rcx), %zmm28, %zmm24

// CHECK: vxorps 4660(%rax,%r14,8), %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x21,0x1c,0x40,0x57,0x84,0xf0,0x34,0x12,0x00,0x00]
          vxorps 4660(%rax,%r14,8), %zmm28, %zmm24

// CHECK: vxorps (%rcx){1to16}, %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x50,0x57,0x01]
          vxorps (%rcx){1to16}, %zmm28, %zmm24

// CHECK: vxorps 8128(%rdx), %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x40,0x57,0x42,0x7f]
          vxorps 8128(%rdx), %zmm28, %zmm24

// CHECK: vxorps 8192(%rdx), %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x40,0x57,0x82,0x00,0x20,0x00,0x00]
          vxorps 8192(%rdx), %zmm28, %zmm24

// CHECK: vxorps -8192(%rdx), %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x40,0x57,0x42,0x80]
          vxorps -8192(%rdx), %zmm28, %zmm24

// CHECK: vxorps -8256(%rdx), %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x40,0x57,0x82,0xc0,0xdf,0xff,0xff]
          vxorps -8256(%rdx), %zmm28, %zmm24

// CHECK: vxorps 508(%rdx){1to16}, %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x50,0x57,0x42,0x7f]
          vxorps 508(%rdx){1to16}, %zmm28, %zmm24

// CHECK: vxorps 512(%rdx){1to16}, %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x50,0x57,0x82,0x00,0x02,0x00,0x00]
          vxorps 512(%rdx){1to16}, %zmm28, %zmm24

// CHECK: vxorps -512(%rdx){1to16}, %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x50,0x57,0x42,0x80]
          vxorps -512(%rdx){1to16}, %zmm28, %zmm24

// CHECK: vxorps -516(%rdx){1to16}, %zmm28, %zmm24
// CHECK:  encoding: [0x62,0x61,0x1c,0x50,0x57,0x82,0xfc,0xfd,0xff,0xff]
          vxorps -516(%rdx){1to16}, %zmm28, %zmm24

// CHECK: vinserti32x8
// CHECK: encoding: [0x62,0xd3,0x4d,0x40,0x3a,0xdb,0x01]
          vinserti32x8  $1, %ymm11, %zmm22, %zmm3

// CHECK: vinsertf64x2
// CHECK: encoding: [0x62,0xf3,0xed,0x48,0x18,0x4f,0x10,0x01]
          vinsertf64x2  $1, 256(%rdi), %zmm2, %zmm1

// CHECK: vbroadcastf32x8 (%rcx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1b,0x31]
          vbroadcastf32x8 (%rcx), %zmm30

// CHECK: vbroadcastf32x8 (%rcx), %zmm30 {%k3}
// CHECK:  encoding: [0x62,0x62,0x7d,0x4b,0x1b,0x31]
          vbroadcastf32x8 (%rcx), %zmm30 {%k3}

// CHECK: vbroadcastf32x8 (%rcx), %zmm30 {%k3} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xcb,0x1b,0x31]
          vbroadcastf32x8 (%rcx), %zmm30 {%k3} {z}

// CHECK: vbroadcastf32x8 291(%rax,%r14,8), %zmm30
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x1b,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastf32x8 291(%rax,%r14,8), %zmm30

// CHECK: vbroadcastf32x8 4064(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1b,0x72,0x7f]
          vbroadcastf32x8 4064(%rdx), %zmm30

// CHECK: vbroadcastf32x8 4096(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1b,0xb2,0x00,0x10,0x00,0x00]
          vbroadcastf32x8 4096(%rdx), %zmm30

// CHECK: vbroadcastf32x8 -4096(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1b,0x72,0x80]
          vbroadcastf32x8 -4096(%rdx), %zmm30

// CHECK: vbroadcastf32x8 -4128(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x1b,0xb2,0xe0,0xef,0xff,0xff]
          vbroadcastf32x8 -4128(%rdx), %zmm30

// CHECK: vbroadcastf64x2 (%rcx), %zmm28
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1a,0x21]
          vbroadcastf64x2 (%rcx), %zmm28

// CHECK: vbroadcastf64x2 (%rcx), %zmm28 {%k4}
// CHECK:  encoding: [0x62,0x62,0xfd,0x4c,0x1a,0x21]
          vbroadcastf64x2 (%rcx), %zmm28 {%k4}

// CHECK: vbroadcastf64x2 (%rcx), %zmm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x62,0xfd,0xcc,0x1a,0x21]
          vbroadcastf64x2 (%rcx), %zmm28 {%k4} {z}

// CHECK: vbroadcastf64x2 291(%rax,%r14,8), %zmm28
// CHECK:  encoding: [0x62,0x22,0xfd,0x48,0x1a,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastf64x2 291(%rax,%r14,8), %zmm28

// CHECK: vbroadcastf64x2 2032(%rdx), %zmm28
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1a,0x62,0x7f]
          vbroadcastf64x2 2032(%rdx), %zmm28

// CHECK: vbroadcastf64x2 2048(%rdx), %zmm28
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1a,0xa2,0x00,0x08,0x00,0x00]
          vbroadcastf64x2 2048(%rdx), %zmm28

// CHECK: vbroadcastf64x2 -2048(%rdx), %zmm28
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1a,0x62,0x80]
          vbroadcastf64x2 -2048(%rdx), %zmm28

// CHECK: vbroadcastf64x2 -2064(%rdx), %zmm28
// CHECK:  encoding: [0x62,0x62,0xfd,0x48,0x1a,0xa2,0xf0,0xf7,0xff,0xff]
          vbroadcastf64x2 -2064(%rdx), %zmm28

// CHECK: vbroadcasti32x8 (%rcx), %zmm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5b,0x29]
          vbroadcasti32x8 (%rcx), %zmm29

// CHECK: vbroadcasti32x8 (%rcx), %zmm29 {%k5}
// CHECK:  encoding: [0x62,0x62,0x7d,0x4d,0x5b,0x29]
          vbroadcasti32x8 (%rcx), %zmm29 {%k5}

// CHECK: vbroadcasti32x8 (%rcx), %zmm29 {%k5} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xcd,0x5b,0x29]
          vbroadcasti32x8 (%rcx), %zmm29 {%k5} {z}

// CHECK: vbroadcasti32x8 291(%rax,%r14,8), %zmm29
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x5b,0xac,0xf0,0x23,0x01,0x00,0x00]
          vbroadcasti32x8 291(%rax,%r14,8), %zmm29

// CHECK: vbroadcasti32x8 4064(%rdx), %zmm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5b,0x6a,0x7f]
          vbroadcasti32x8 4064(%rdx), %zmm29

// CHECK: vbroadcasti32x8 4096(%rdx), %zmm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5b,0xaa,0x00,0x10,0x00,0x00]
          vbroadcasti32x8 4096(%rdx), %zmm29

// CHECK: vbroadcasti32x8 -4096(%rdx), %zmm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5b,0x6a,0x80]
          vbroadcasti32x8 -4096(%rdx), %zmm29

// CHECK: vbroadcasti32x8 -4128(%rdx), %zmm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x5b,0xaa,0xe0,0xef,0xff,0xff]
          vbroadcasti32x8 -4128(%rdx), %zmm29

// CHECK: vbroadcasti64x2 (%rcx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5a,0x21]
          vbroadcasti64x2 (%rcx), %zmm20

// CHECK: vbroadcasti64x2 (%rcx), %zmm20 {%k3}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x4b,0x5a,0x21]
          vbroadcasti64x2 (%rcx), %zmm20 {%k3}

// CHECK: vbroadcasti64x2 (%rcx), %zmm20 {%k3} {z}
// CHECK:  encoding: [0x62,0xe2,0xfd,0xcb,0x5a,0x21]
          vbroadcasti64x2 (%rcx), %zmm20 {%k3} {z}

// CHECK: vbroadcasti64x2 291(%rax,%r14,8), %zmm20
// CHECK:  encoding: [0x62,0xa2,0xfd,0x48,0x5a,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcasti64x2 291(%rax,%r14,8), %zmm20

// CHECK: vbroadcasti64x2 2032(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5a,0x62,0x7f]
          vbroadcasti64x2 2032(%rdx), %zmm20

// CHECK: vbroadcasti64x2 2048(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5a,0xa2,0x00,0x08,0x00,0x00]
          vbroadcasti64x2 2048(%rdx), %zmm20

// CHECK: vbroadcasti64x2 -2048(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5a,0x62,0x80]
          vbroadcasti64x2 -2048(%rdx), %zmm20

// CHECK: vbroadcasti64x2 -2064(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0xfd,0x48,0x5a,0xa2,0xf0,0xf7,0xff,0xff]
          vbroadcasti64x2 -2064(%rdx), %zmm20

// CHECK: vrangepd $171, %zmm17, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xa3,0xe5,0x40,0x50,0xc9,0xab]
          vrangepd $0xab, %zmm17, %zmm19, %zmm17

// CHECK: vrangepd $171, %zmm17, %zmm19, %zmm17 {%k6}
// CHECK:  encoding: [0x62,0xa3,0xe5,0x46,0x50,0xc9,0xab]
          vrangepd $0xab, %zmm17, %zmm19, %zmm17 {%k6}

// CHECK: vrangepd $171, %zmm17, %zmm19, %zmm17 {%k6} {z}
// CHECK:  encoding: [0x62,0xa3,0xe5,0xc6,0x50,0xc9,0xab]
          vrangepd $0xab, %zmm17, %zmm19, %zmm17 {%k6} {z}

// CHECK: vrangepd $171, {sae}, %zmm17, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xa3,0xe5,0x10,0x50,0xc9,0xab]
          vrangepd $0xab,{sae}, %zmm17, %zmm19, %zmm17

// CHECK: vrangepd $123, %zmm17, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xa3,0xe5,0x40,0x50,0xc9,0x7b]
          vrangepd $0x7b, %zmm17, %zmm19, %zmm17

// CHECK: vrangepd $123, {sae}, %zmm17, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xa3,0xe5,0x10,0x50,0xc9,0x7b]
          vrangepd $0x7b,{sae}, %zmm17, %zmm19, %zmm17

// CHECK: vrangepd $123, (%rcx), %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x40,0x50,0x09,0x7b]
          vrangepd $0x7b,(%rcx), %zmm19, %zmm17

// CHECK: vrangepd $123, 291(%rax,%r14,8), %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xa3,0xe5,0x40,0x50,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrangepd $0x7b,291(%rax,%r14,8), %zmm19, %zmm17

// CHECK: vrangepd $123, (%rcx){1to8}, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x50,0x50,0x09,0x7b]
          vrangepd $0x7b,(%rcx){1to8}, %zmm19, %zmm17

// CHECK: vrangepd $123, 8128(%rdx), %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x40,0x50,0x4a,0x7f,0x7b]
          vrangepd $0x7b,8128(%rdx), %zmm19, %zmm17

// CHECK: vrangepd $123, 8192(%rdx), %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x40,0x50,0x8a,0x00,0x20,0x00,0x00,0x7b]
          vrangepd $0x7b,8192(%rdx), %zmm19, %zmm17

// CHECK: vrangepd $123, -8192(%rdx), %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x40,0x50,0x4a,0x80,0x7b]
          vrangepd $0x7b,-8192(%rdx), %zmm19, %zmm17

// CHECK: vrangepd $123, -8256(%rdx), %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x40,0x50,0x8a,0xc0,0xdf,0xff,0xff,0x7b]
          vrangepd $0x7b,-8256(%rdx), %zmm19, %zmm17

// CHECK: vrangepd $123, 1016(%rdx){1to8}, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x50,0x50,0x4a,0x7f,0x7b]
          vrangepd $0x7b,1016(%rdx){1to8}, %zmm19, %zmm17

// CHECK: vrangepd $123, 1024(%rdx){1to8}, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x50,0x50,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vrangepd $0x7b,1024(%rdx){1to8}, %zmm19, %zmm17

// CHECK: vrangepd $123, -1024(%rdx){1to8}, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x50,0x50,0x4a,0x80,0x7b]
          vrangepd $0x7b,-1024(%rdx){1to8}, %zmm19, %zmm17

// CHECK: vrangepd $123, -1032(%rdx){1to8}, %zmm19, %zmm17
// CHECK:  encoding: [0x62,0xe3,0xe5,0x50,0x50,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vrangepd $0x7b,-1032(%rdx){1to8}, %zmm19, %zmm17

// CHECK: vrangeps $171, %zmm17, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x23,0x55,0x40,0x50,0xc1,0xab]
          vrangeps $0xab, %zmm17, %zmm21, %zmm24

// CHECK: vrangeps $171, %zmm17, %zmm21, %zmm24 {%k6}
// CHECK:  encoding: [0x62,0x23,0x55,0x46,0x50,0xc1,0xab]
          vrangeps $0xab, %zmm17, %zmm21, %zmm24 {%k6}

// CHECK: vrangeps $171, %zmm17, %zmm21, %zmm24 {%k6} {z}
// CHECK:  encoding: [0x62,0x23,0x55,0xc6,0x50,0xc1,0xab]
          vrangeps $0xab, %zmm17, %zmm21, %zmm24 {%k6} {z}

// CHECK: vrangeps $171, {sae}, %zmm17, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x23,0x55,0x10,0x50,0xc1,0xab]
          vrangeps $0xab,{sae}, %zmm17, %zmm21, %zmm24

// CHECK: vrangeps $123, %zmm17, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x23,0x55,0x40,0x50,0xc1,0x7b]
          vrangeps $0x7b, %zmm17, %zmm21, %zmm24

// CHECK: vrangeps $123, {sae}, %zmm17, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x23,0x55,0x10,0x50,0xc1,0x7b]
          vrangeps $0x7b,{sae}, %zmm17, %zmm21, %zmm24

// CHECK: vrangeps $123, (%rcx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x40,0x50,0x01,0x7b]
          vrangeps $0x7b,(%rcx), %zmm21, %zmm24

// CHECK: vrangeps $123, 291(%rax,%r14,8), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x23,0x55,0x40,0x50,0x84,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrangeps $0x7b,291(%rax,%r14,8), %zmm21, %zmm24

// CHECK: vrangeps $123, (%rcx){1to16}, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x50,0x50,0x01,0x7b]
          vrangeps $0x7b,(%rcx){1to16}, %zmm21, %zmm24

// CHECK: vrangeps $123, 8128(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x40,0x50,0x42,0x7f,0x7b]
          vrangeps $0x7b,8128(%rdx), %zmm21, %zmm24

// CHECK: vrangeps $123, 8192(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x40,0x50,0x82,0x00,0x20,0x00,0x00,0x7b]
          vrangeps $0x7b,8192(%rdx), %zmm21, %zmm24

// CHECK: vrangeps $123, -8192(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x40,0x50,0x42,0x80,0x7b]
          vrangeps $0x7b,-8192(%rdx), %zmm21, %zmm24

// CHECK: vrangeps $123, -8256(%rdx), %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x40,0x50,0x82,0xc0,0xdf,0xff,0xff,0x7b]
          vrangeps $0x7b,-8256(%rdx), %zmm21, %zmm24

// CHECK: vrangeps $123, 508(%rdx){1to16}, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x50,0x50,0x42,0x7f,0x7b]
          vrangeps $0x7b,508(%rdx){1to16}, %zmm21, %zmm24

// CHECK: vrangeps $123, 512(%rdx){1to16}, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x50,0x50,0x82,0x00,0x02,0x00,0x00,0x7b]
          vrangeps $0x7b,512(%rdx){1to16}, %zmm21, %zmm24

// CHECK: vrangeps $123, -512(%rdx){1to16}, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x50,0x50,0x42,0x80,0x7b]
          vrangeps $0x7b,-512(%rdx){1to16}, %zmm21, %zmm24

// CHECK: vrangeps $123, -516(%rdx){1to16}, %zmm21, %zmm24
// CHECK:  encoding: [0x62,0x63,0x55,0x50,0x50,0x82,0xfc,0xfd,0xff,0xff,0x7b]
          vrangeps $0x7b,-516(%rdx){1to16}, %zmm21, %zmm24

// CHECK: vrangesd $171, %xmm21, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa3,0xf5,0x00,0x51,0xcd,0xab]
          vrangesd $0xab, %xmm21, %xmm17, %xmm17

// CHECK: vrangesd $171, %xmm21, %xmm17, %xmm17 {%k5}
// CHECK:  encoding: [0x62,0xa3,0xf5,0x05,0x51,0xcd,0xab]
          vrangesd $0xab, %xmm21, %xmm17, %xmm17 {%k5}

// CHECK: vrangesd $171, %xmm21, %xmm17, %xmm17 {%k5} {z}
// CHECK:  encoding: [0x62,0xa3,0xf5,0x85,0x51,0xcd,0xab]
          vrangesd $0xab, %xmm21, %xmm17, %xmm17 {%k5} {z}

// CHECK: vrangesd $171, {sae}, %xmm21, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa3,0xf5,0x10,0x51,0xcd,0xab]
          vrangesd $0xab,{sae}, %xmm21, %xmm17, %xmm17

// CHECK: vrangesd $123, %xmm21, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa3,0xf5,0x00,0x51,0xcd,0x7b]
          vrangesd $0x7b, %xmm21, %xmm17, %xmm17

// CHECK: vrangesd $123, {sae}, %xmm21, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa3,0xf5,0x10,0x51,0xcd,0x7b]
          vrangesd $0x7b,{sae}, %xmm21, %xmm17, %xmm17

// CHECK: vrangesd $123, (%rcx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x51,0x09,0x7b]
          vrangesd $0x7b,(%rcx), %xmm17, %xmm17

// CHECK: vrangesd $123, 291(%rax,%r14,8), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa3,0xf5,0x00,0x51,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrangesd $0x7b,291(%rax,%r14,8), %xmm17, %xmm17

// CHECK: vrangesd $123, 1016(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x51,0x4a,0x7f,0x7b]
          vrangesd $0x7b,1016(%rdx), %xmm17, %xmm17

// CHECK: vrangesd $123, 1024(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x51,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vrangesd $0x7b,1024(%rdx), %xmm17, %xmm17

// CHECK: vrangesd $123, -1024(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x51,0x4a,0x80,0x7b]
          vrangesd $0x7b,-1024(%rdx), %xmm17, %xmm17

// CHECK: vrangesd $123, -1032(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x51,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vrangesd $0x7b,-1032(%rdx), %xmm17, %xmm17

// CHECK: vrangess $171, %xmm20, %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x23,0x3d,0x00,0x51,0xcc,0xab]
          vrangess $0xab, %xmm20, %xmm24, %xmm25

// CHECK: vrangess $171, %xmm20, %xmm24, %xmm25 {%k5}
// CHECK:  encoding: [0x62,0x23,0x3d,0x05,0x51,0xcc,0xab]
          vrangess $0xab, %xmm20, %xmm24, %xmm25 {%k5}

// CHECK: vrangess $171, %xmm20, %xmm24, %xmm25 {%k5} {z}
// CHECK:  encoding: [0x62,0x23,0x3d,0x85,0x51,0xcc,0xab]
          vrangess $0xab, %xmm20, %xmm24, %xmm25 {%k5} {z}

// CHECK: vrangess $171, {sae}, %xmm20, %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x23,0x3d,0x10,0x51,0xcc,0xab]
          vrangess $0xab,{sae}, %xmm20, %xmm24, %xmm25

// CHECK: vrangess $123, %xmm20, %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x23,0x3d,0x00,0x51,0xcc,0x7b]
          vrangess $0x7b, %xmm20, %xmm24, %xmm25

// CHECK: vrangess $123, {sae}, %xmm20, %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x23,0x3d,0x10,0x51,0xcc,0x7b]
          vrangess $0x7b,{sae}, %xmm20, %xmm24, %xmm25

// CHECK: vrangess $123, (%rcx), %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x51,0x09,0x7b]
          vrangess $0x7b,(%rcx), %xmm24, %xmm25

// CHECK: vrangess $123, 291(%rax,%r14,8), %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x23,0x3d,0x00,0x51,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vrangess $0x7b,291(%rax,%r14,8), %xmm24, %xmm25

// CHECK: vrangess $123, 508(%rdx), %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x51,0x4a,0x7f,0x7b]
          vrangess $0x7b,508(%rdx), %xmm24, %xmm25

// CHECK: vrangess $123, 512(%rdx), %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x51,0x8a,0x00,0x02,0x00,0x00,0x7b]
          vrangess $0x7b,512(%rdx), %xmm24, %xmm25

// CHECK: vrangess $123, -512(%rdx), %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x51,0x4a,0x80,0x7b]
          vrangess $0x7b,-512(%rdx), %xmm24, %xmm25

// CHECK: vrangess $123, -516(%rdx), %xmm24, %xmm25
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x51,0x8a,0xfc,0xfd,0xff,0xff,0x7b]
          vrangess $0x7b,-516(%rdx), %xmm24, %xmm25

// CHECK: vreducepd $171, %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x56,0xdb,0xab]
          vreducepd $0xab, %zmm19, %zmm19

// CHECK: vreducepd $171, %zmm19, %zmm19 {%k6}
// CHECK:  encoding: [0x62,0xa3,0xfd,0x4e,0x56,0xdb,0xab]
          vreducepd $0xab, %zmm19, %zmm19 {%k6}

// CHECK: vreducepd $171, %zmm19, %zmm19 {%k6} {z}
// CHECK:  encoding: [0x62,0xa3,0xfd,0xce,0x56,0xdb,0xab]
          vreducepd $0xab, %zmm19, %zmm19 {%k6} {z}

// CHECK: vreducepd $171, {sae}, %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xa3,0xfd,0x18,0x56,0xdb,0xab]
          vreducepd $0xab,{sae}, %zmm19, %zmm19

// CHECK: vreducepd $123, %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x56,0xdb,0x7b]
          vreducepd $0x7b, %zmm19, %zmm19

// CHECK: vreducepd $123, {sae}, %zmm19, %zmm19
// CHECK:  encoding: [0x62,0xa3,0xfd,0x18,0x56,0xdb,0x7b]
          vreducepd $0x7b,{sae}, %zmm19, %zmm19

// CHECK: vreducepd $123, (%rcx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x19,0x7b]
          vreducepd $0x7b,(%rcx), %zmm19

// CHECK: vreducepd $123, 291(%rax,%r14,8), %zmm19
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x56,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vreducepd $0x7b,291(%rax,%r14,8), %zmm19

// CHECK: vreducepd $123, (%rcx){1to8}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x19,0x7b]
          vreducepd $0x7b,(%rcx){1to8}, %zmm19

// CHECK: vreducepd $123, 8128(%rdx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x5a,0x7f,0x7b]
          vreducepd $0x7b,8128(%rdx), %zmm19

// CHECK: vreducepd $123, 8192(%rdx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vreducepd $0x7b,8192(%rdx), %zmm19

// CHECK: vreducepd $123, -8192(%rdx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x5a,0x80,0x7b]
          vreducepd $0x7b,-8192(%rdx), %zmm19

// CHECK: vreducepd $123, -8256(%rdx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vreducepd $0x7b,-8256(%rdx), %zmm19

// CHECK: vreducepd $123, 1016(%rdx){1to8}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x5a,0x7f,0x7b]
          vreducepd $0x7b,1016(%rdx){1to8}, %zmm19

// CHECK: vreducepd $123, 1024(%rdx){1to8}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vreducepd $0x7b,1024(%rdx){1to8}, %zmm19

// CHECK: vreducepd $123, -1024(%rdx){1to8}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x5a,0x80,0x7b]
          vreducepd $0x7b,-1024(%rdx){1to8}, %zmm19

// CHECK: vreducepd $123, -1032(%rdx){1to8}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vreducepd $0x7b,-1032(%rdx){1to8}, %zmm19

// CHECK: vreduceps $171, %zmm29, %zmm19
// CHECK:  encoding: [0x62,0x83,0x7d,0x48,0x56,0xdd,0xab]
          vreduceps $0xab, %zmm29, %zmm19

// CHECK: vreduceps $171, %zmm29, %zmm19 {%k3}
// CHECK:  encoding: [0x62,0x83,0x7d,0x4b,0x56,0xdd,0xab]
          vreduceps $0xab, %zmm29, %zmm19 {%k3}

// CHECK: vreduceps $171, %zmm29, %zmm19 {%k3} {z}
// CHECK:  encoding: [0x62,0x83,0x7d,0xcb,0x56,0xdd,0xab]
          vreduceps $0xab, %zmm29, %zmm19 {%k3} {z}

// CHECK: vreduceps $171, {sae}, %zmm29, %zmm19
// CHECK:  encoding: [0x62,0x83,0x7d,0x18,0x56,0xdd,0xab]
          vreduceps $0xab,{sae}, %zmm29, %zmm19

// CHECK: vreduceps $123, %zmm29, %zmm19
// CHECK:  encoding: [0x62,0x83,0x7d,0x48,0x56,0xdd,0x7b]
          vreduceps $0x7b, %zmm29, %zmm19

// CHECK: vreduceps $123, {sae}, %zmm29, %zmm19
// CHECK:  encoding: [0x62,0x83,0x7d,0x18,0x56,0xdd,0x7b]
          vreduceps $0x7b,{sae}, %zmm29, %zmm19

// CHECK: vreduceps $123, (%rcx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x56,0x19,0x7b]
          vreduceps $0x7b,(%rcx), %zmm19

// CHECK: vreduceps $123, 291(%rax,%r14,8), %zmm19
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x56,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vreduceps $0x7b,291(%rax,%r14,8), %zmm19

// CHECK: vreduceps $123, (%rcx){1to16}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x56,0x19,0x7b]
          vreduceps $0x7b,(%rcx){1to16}, %zmm19

// CHECK: vreduceps $123, 8128(%rdx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x56,0x5a,0x7f,0x7b]
          vreduceps $0x7b,8128(%rdx), %zmm19

// CHECK: vreduceps $123, 8192(%rdx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x56,0x9a,0x00,0x20,0x00,0x00,0x7b]
          vreduceps $0x7b,8192(%rdx), %zmm19

// CHECK: vreduceps $123, -8192(%rdx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x56,0x5a,0x80,0x7b]
          vreduceps $0x7b,-8192(%rdx), %zmm19

// CHECK: vreduceps $123, -8256(%rdx), %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x56,0x9a,0xc0,0xdf,0xff,0xff,0x7b]
          vreduceps $0x7b,-8256(%rdx), %zmm19

// CHECK: vreduceps $123, 508(%rdx){1to16}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x56,0x5a,0x7f,0x7b]
          vreduceps $0x7b,508(%rdx){1to16}, %zmm19

// CHECK: vreduceps $123, 512(%rdx){1to16}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x56,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vreduceps $0x7b,512(%rdx){1to16}, %zmm19

// CHECK: vreduceps $123, -512(%rdx){1to16}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x56,0x5a,0x80,0x7b]
          vreduceps $0x7b,-512(%rdx){1to16}, %zmm19

// CHECK: vreduceps $123, -516(%rdx){1to16}, %zmm19
// CHECK:  encoding: [0x62,0xe3,0x7d,0x58,0x56,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vreduceps $0x7b,-516(%rdx){1to16}, %zmm19

// CHECK: vreducesd $171, %xmm25, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0x83,0xf5,0x00,0x57,0xc9,0xab]
          vreducesd $0xab, %xmm25, %xmm17, %xmm17

// CHECK: vreducesd $171, %xmm25, %xmm17, %xmm17 {%k6}
// CHECK:  encoding: [0x62,0x83,0xf5,0x06,0x57,0xc9,0xab]
          vreducesd $0xab, %xmm25, %xmm17, %xmm17 {%k6}

// CHECK: vreducesd $171, %xmm25, %xmm17, %xmm17 {%k6} {z}
// CHECK:  encoding: [0x62,0x83,0xf5,0x86,0x57,0xc9,0xab]
          vreducesd $0xab, %xmm25, %xmm17, %xmm17 {%k6} {z}

// CHECK: vreducesd $171, {sae}, %xmm25, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0x83,0xf5,0x10,0x57,0xc9,0xab]
          vreducesd $0xab,{sae}, %xmm25, %xmm17, %xmm17

// CHECK: vreducesd $123, %xmm25, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0x83,0xf5,0x00,0x57,0xc9,0x7b]
          vreducesd $0x7b, %xmm25, %xmm17, %xmm17

// CHECK: vreducesd $123, {sae}, %xmm25, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0x83,0xf5,0x10,0x57,0xc9,0x7b]
          vreducesd $0x7b,{sae}, %xmm25, %xmm17, %xmm17

// CHECK: vreducesd $123, (%rcx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x57,0x09,0x7b]
          vreducesd $0x7b,(%rcx), %xmm17, %xmm17

// CHECK: vreducesd $123, 291(%rax,%r14,8), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa3,0xf5,0x00,0x57,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vreducesd $0x7b,291(%rax,%r14,8), %xmm17, %xmm17

// CHECK: vreducesd $123, 1016(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x57,0x4a,0x7f,0x7b]
          vreducesd $0x7b,1016(%rdx), %xmm17, %xmm17

// CHECK: vreducesd $123, 1024(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x57,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vreducesd $0x7b,1024(%rdx), %xmm17, %xmm17

// CHECK: vreducesd $123, -1024(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x57,0x4a,0x80,0x7b]
          vreducesd $0x7b,-1024(%rdx), %xmm17, %xmm17

// CHECK: vreducesd $123, -1032(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe3,0xf5,0x00,0x57,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vreducesd $0x7b,-1032(%rdx), %xmm17, %xmm17

// CHECK: vreducess $171, %xmm21, %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x23,0x15,0x00,0x57,0xf5,0xab]
          vreducess $0xab, %xmm21, %xmm29, %xmm30

// CHECK: vreducess $171, %xmm21, %xmm29, %xmm30 {%k1}
// CHECK:  encoding: [0x62,0x23,0x15,0x01,0x57,0xf5,0xab]
          vreducess $0xab, %xmm21, %xmm29, %xmm30 {%k1}

// CHECK: vreducess $171, %xmm21, %xmm29, %xmm30 {%k1} {z}
// CHECK:  encoding: [0x62,0x23,0x15,0x81,0x57,0xf5,0xab]
          vreducess $0xab, %xmm21, %xmm29, %xmm30 {%k1} {z}

// CHECK: vreducess $171, {sae}, %xmm21, %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x23,0x15,0x10,0x57,0xf5,0xab]
          vreducess $0xab,{sae}, %xmm21, %xmm29, %xmm30

// CHECK: vreducess $123, %xmm21, %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x23,0x15,0x00,0x57,0xf5,0x7b]
          vreducess $0x7b, %xmm21, %xmm29, %xmm30

// CHECK: vreducess $123, {sae}, %xmm21, %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x23,0x15,0x10,0x57,0xf5,0x7b]
          vreducess $0x7b,{sae}, %xmm21, %xmm29, %xmm30

// CHECK: vreducess $123, (%rcx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x63,0x15,0x00,0x57,0x31,0x7b]
          vreducess $0x7b,(%rcx), %xmm29, %xmm30

// CHECK: vreducess $123, 291(%rax,%r14,8), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x23,0x15,0x00,0x57,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vreducess $0x7b,291(%rax,%r14,8), %xmm29, %xmm30

// CHECK: vreducess $123, 508(%rdx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x63,0x15,0x00,0x57,0x72,0x7f,0x7b]
          vreducess $0x7b,508(%rdx), %xmm29, %xmm30

// CHECK: vreducess $123, 512(%rdx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x63,0x15,0x00,0x57,0xb2,0x00,0x02,0x00,0x00,0x7b]
          vreducess $0x7b,512(%rdx), %xmm29, %xmm30

// CHECK: vreducess $123, -512(%rdx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x63,0x15,0x00,0x57,0x72,0x80,0x7b]
          vreducess $0x7b,-512(%rdx), %xmm29, %xmm30

// CHECK: vreducess $123, -516(%rdx), %xmm29, %xmm30
// CHECK:  encoding: [0x62,0x63,0x15,0x00,0x57,0xb2,0xfc,0xfd,0xff,0xff,0x7b]
          vreducess $0x7b,-516(%rdx), %xmm29, %xmm30

// CHECK: vreducepd $171, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0x83,0xfd,0x48,0x56,0xd4,0xab]
          vreducepd $0xab, %zmm28, %zmm18

// CHECK: vreducepd $171, %zmm28, %zmm18 {%k5}
// CHECK:  encoding: [0x62,0x83,0xfd,0x4d,0x56,0xd4,0xab]
          vreducepd $0xab, %zmm28, %zmm18 {%k5}

// CHECK: vreducepd $171, %zmm28, %zmm18 {%k5} {z}
// CHECK:  encoding: [0x62,0x83,0xfd,0xcd,0x56,0xd4,0xab]
          vreducepd $0xab, %zmm28, %zmm18 {%k5} {z}

// CHECK: vreducepd $171, {sae}, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0x83,0xfd,0x18,0x56,0xd4,0xab]
          vreducepd $0xab,{sae}, %zmm28, %zmm18

// CHECK: vreducepd $123, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0x83,0xfd,0x48,0x56,0xd4,0x7b]
          vreducepd $0x7b, %zmm28, %zmm18

// CHECK: vreducepd $123, {sae}, %zmm28, %zmm18
// CHECK:  encoding: [0x62,0x83,0xfd,0x18,0x56,0xd4,0x7b]
          vreducepd $0x7b,{sae}, %zmm28, %zmm18

// CHECK: vreducepd $123, (%rcx), %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x11,0x7b]
          vreducepd $0x7b,(%rcx), %zmm18

// CHECK: vreducepd $123, 4660(%rax,%r14,8), %zmm18
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x56,0x94,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vreducepd $0x7b,4660(%rax,%r14,8), %zmm18

// CHECK: vreducepd $123, (%rcx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x11,0x7b]
          vreducepd $0x7b,(%rcx){1to8}, %zmm18

// CHECK: vreducepd $123, 8128(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x52,0x7f,0x7b]
          vreducepd $0x7b,8128(%rdx), %zmm18

// CHECK: vreducepd $123, 8192(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x92,0x00,0x20,0x00,0x00,0x7b]
          vreducepd $0x7b,8192(%rdx), %zmm18

// CHECK: vreducepd $123, -8192(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x52,0x80,0x7b]
          vreducepd $0x7b,-8192(%rdx), %zmm18

// CHECK: vreducepd $123, -8256(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x56,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vreducepd $0x7b,-8256(%rdx), %zmm18

// CHECK: vreducepd $123, 1016(%rdx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x52,0x7f,0x7b]
          vreducepd $0x7b,1016(%rdx){1to8}, %zmm18

// CHECK: vreducepd $123, 1024(%rdx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x92,0x00,0x04,0x00,0x00,0x7b]
          vreducepd $0x7b,1024(%rdx){1to8}, %zmm18

// CHECK: vreducepd $123, -1024(%rdx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x52,0x80,0x7b]
          vreducepd $0x7b,-1024(%rdx){1to8}, %zmm18

// CHECK: vreducepd $123, -1032(%rdx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe3,0xfd,0x58,0x56,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vreducepd $0x7b,-1032(%rdx){1to8}, %zmm18

// CHECK: vreduceps $171, %zmm25, %zmm26
// CHECK:  encoding: [0x62,0x03,0x7d,0x48,0x56,0xd1,0xab]
          vreduceps $0xab, %zmm25, %zmm26

// CHECK: vreduceps $171, %zmm25, %zmm26 {%k3}
// CHECK:  encoding: [0x62,0x03,0x7d,0x4b,0x56,0xd1,0xab]
          vreduceps $0xab, %zmm25, %zmm26 {%k3}

// CHECK: vreduceps $171, %zmm25, %zmm26 {%k3} {z}
// CHECK:  encoding: [0x62,0x03,0x7d,0xcb,0x56,0xd1,0xab]
          vreduceps $0xab, %zmm25, %zmm26 {%k3} {z}

// CHECK: vreduceps $171, {sae}, %zmm25, %zmm26
// CHECK:  encoding: [0x62,0x03,0x7d,0x18,0x56,0xd1,0xab]
          vreduceps $0xab,{sae}, %zmm25, %zmm26

// CHECK: vreduceps $123, %zmm25, %zmm26
// CHECK:  encoding: [0x62,0x03,0x7d,0x48,0x56,0xd1,0x7b]
          vreduceps $0x7b, %zmm25, %zmm26

// CHECK: vreduceps $123, {sae}, %zmm25, %zmm26
// CHECK:  encoding: [0x62,0x03,0x7d,0x18,0x56,0xd1,0x7b]
          vreduceps $0x7b,{sae}, %zmm25, %zmm26

// CHECK: vreduceps $123, (%rcx), %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x56,0x11,0x7b]
          vreduceps $0x7b,(%rcx), %zmm26

// CHECK: vreduceps $123, 4660(%rax,%r14,8), %zmm26
// CHECK:  encoding: [0x62,0x23,0x7d,0x48,0x56,0x94,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vreduceps $0x7b,4660(%rax,%r14,8), %zmm26

// CHECK: vreduceps $123, (%rcx){1to16}, %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x58,0x56,0x11,0x7b]
          vreduceps $0x7b,(%rcx){1to16}, %zmm26

// CHECK: vreduceps $123, 8128(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x56,0x52,0x7f,0x7b]
          vreduceps $0x7b,8128(%rdx), %zmm26

// CHECK: vreduceps $123, 8192(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x56,0x92,0x00,0x20,0x00,0x00,0x7b]
          vreduceps $0x7b,8192(%rdx), %zmm26

// CHECK: vreduceps $123, -8192(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x56,0x52,0x80,0x7b]
          vreduceps $0x7b,-8192(%rdx), %zmm26

// CHECK: vreduceps $123, -8256(%rdx), %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x56,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vreduceps $0x7b,-8256(%rdx), %zmm26

// CHECK: vreduceps $123, 508(%rdx){1to16}, %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x58,0x56,0x52,0x7f,0x7b]
          vreduceps $0x7b,508(%rdx){1to16}, %zmm26

// CHECK: vreduceps $123, 512(%rdx){1to16}, %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x58,0x56,0x92,0x00,0x02,0x00,0x00,0x7b]
          vreduceps $0x7b,512(%rdx){1to16}, %zmm26

// CHECK: vreduceps $123, -512(%rdx){1to16}, %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x58,0x56,0x52,0x80,0x7b]
          vreduceps $0x7b,-512(%rdx){1to16}, %zmm26

// CHECK: vreduceps $123, -516(%rdx){1to16}, %zmm26
// CHECK:  encoding: [0x62,0x63,0x7d,0x58,0x56,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vreduceps $0x7b,-516(%rdx){1to16}, %zmm26

// CHECK: vreducesd $171, %xmm24, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x03,0xe5,0x00,0x57,0xc8,0xab]
          vreducesd $0xab, %xmm24, %xmm19, %xmm25

// CHECK: vreducesd $171, %xmm24, %xmm19, %xmm25 {%k3}
// CHECK:  encoding: [0x62,0x03,0xe5,0x03,0x57,0xc8,0xab]
          vreducesd $0xab, %xmm24, %xmm19, %xmm25 {%k3}

// CHECK: vreducesd $171, %xmm24, %xmm19, %xmm25 {%k3} {z}
// CHECK:  encoding: [0x62,0x03,0xe5,0x83,0x57,0xc8,0xab]
          vreducesd $0xab, %xmm24, %xmm19, %xmm25 {%k3} {z}

// CHECK: vreducesd $171, {sae}, %xmm24, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x03,0xe5,0x10,0x57,0xc8,0xab]
          vreducesd $0xab,{sae}, %xmm24, %xmm19, %xmm25

// CHECK: vreducesd $123, %xmm24, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x03,0xe5,0x00,0x57,0xc8,0x7b]
          vreducesd $0x7b, %xmm24, %xmm19, %xmm25

// CHECK: vreducesd $123, {sae}, %xmm24, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x03,0xe5,0x10,0x57,0xc8,0x7b]
          vreducesd $0x7b,{sae}, %xmm24, %xmm19, %xmm25

// CHECK: vreducesd $123, (%rcx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x57,0x09,0x7b]
          vreducesd $0x7b,(%rcx), %xmm19, %xmm25

// CHECK: vreducesd $123, 4660(%rax,%r14,8), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x23,0xe5,0x00,0x57,0x8c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vreducesd $0x7b,4660(%rax,%r14,8), %xmm19, %xmm25

// CHECK: vreducesd $123, 1016(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x57,0x4a,0x7f,0x7b]
          vreducesd $0x7b,1016(%rdx), %xmm19, %xmm25

// CHECK: vreducesd $123, 1024(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x57,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vreducesd $0x7b,1024(%rdx), %xmm19, %xmm25

// CHECK: vreducesd $123, -1024(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x57,0x4a,0x80,0x7b]
          vreducesd $0x7b,-1024(%rdx), %xmm19, %xmm25

// CHECK: vreducesd $123, -1032(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x57,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vreducesd $0x7b,-1032(%rdx), %xmm19, %xmm25

// CHECK: vreducess $171, %xmm21, %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x23,0x3d,0x00,0x57,0xf5,0xab]
          vreducess $0xab, %xmm21, %xmm24, %xmm30

// CHECK: vreducess $171, %xmm21, %xmm24, %xmm30 {%k2}
// CHECK:  encoding: [0x62,0x23,0x3d,0x02,0x57,0xf5,0xab]
          vreducess $0xab, %xmm21, %xmm24, %xmm30 {%k2}

// CHECK: vreducess $171, %xmm21, %xmm24, %xmm30 {%k2} {z}
// CHECK:  encoding: [0x62,0x23,0x3d,0x82,0x57,0xf5,0xab]
          vreducess $0xab, %xmm21, %xmm24, %xmm30 {%k2} {z}

// CHECK: vreducess $171, {sae}, %xmm21, %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x23,0x3d,0x10,0x57,0xf5,0xab]
          vreducess $0xab,{sae}, %xmm21, %xmm24, %xmm30

// CHECK: vreducess $123, %xmm21, %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x23,0x3d,0x00,0x57,0xf5,0x7b]
          vreducess $0x7b, %xmm21, %xmm24, %xmm30

// CHECK: vreducess $123, {sae}, %xmm21, %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x23,0x3d,0x10,0x57,0xf5,0x7b]
          vreducess $0x7b,{sae}, %xmm21, %xmm24, %xmm30

// CHECK: vreducess $123, (%rcx), %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x57,0x31,0x7b]
          vreducess $0x7b,(%rcx), %xmm24, %xmm30

// CHECK: vreducess $123, 4660(%rax,%r14,8), %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x23,0x3d,0x00,0x57,0xb4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vreducess $0x7b,4660(%rax,%r14,8), %xmm24, %xmm30

// CHECK: vreducess $123, 508(%rdx), %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x57,0x72,0x7f,0x7b]
          vreducess $0x7b,508(%rdx), %xmm24, %xmm30

// CHECK: vreducess $123, 512(%rdx), %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x57,0xb2,0x00,0x02,0x00,0x00,0x7b]
          vreducess $0x7b,512(%rdx), %xmm24, %xmm30

// CHECK: vreducess $123, -512(%rdx), %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x57,0x72,0x80,0x7b]
          vreducess $0x7b,-512(%rdx), %xmm24, %xmm30

// CHECK: vreducess $123, -516(%rdx), %xmm24, %xmm30
// CHECK:  encoding: [0x62,0x63,0x3d,0x00,0x57,0xb2,0xfc,0xfd,0xff,0xff,0x7b]
          vreducess $0x7b,-516(%rdx), %xmm24, %xmm30

// CHECK: vcvtpd2qq %zmm29, %zmm18
// CHECK:  encoding: [0x62,0x81,0xfd,0x48,0x7b,0xd5]
          vcvtpd2qq %zmm29, %zmm18

// CHECK: vcvtpd2qq %zmm29, %zmm18 {%k6}
// CHECK:  encoding: [0x62,0x81,0xfd,0x4e,0x7b,0xd5]
          vcvtpd2qq %zmm29, %zmm18 {%k6}

// CHECK: vcvtpd2qq %zmm29, %zmm18 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0xfd,0xce,0x7b,0xd5]
          vcvtpd2qq %zmm29, %zmm18 {%k6} {z}

// CHECK: vcvtpd2qq {rn-sae}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0x81,0xfd,0x18,0x7b,0xd5]
          vcvtpd2qq {rn-sae}, %zmm29, %zmm18

// CHECK: vcvtpd2qq {ru-sae}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0x81,0xfd,0x58,0x7b,0xd5]
          vcvtpd2qq {ru-sae}, %zmm29, %zmm18

// CHECK: vcvtpd2qq {rd-sae}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0x81,0xfd,0x38,0x7b,0xd5]
          vcvtpd2qq {rd-sae}, %zmm29, %zmm18

// CHECK: vcvtpd2qq {rz-sae}, %zmm29, %zmm18
// CHECK:  encoding: [0x62,0x81,0xfd,0x78,0x7b,0xd5]
          vcvtpd2qq {rz-sae}, %zmm29, %zmm18

// CHECK: vcvtpd2qq (%rcx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7b,0x11]
          vcvtpd2qq (%rcx), %zmm18

// CHECK: vcvtpd2qq 291(%rax,%r14,8), %zmm18
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x7b,0x94,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2qq 291(%rax,%r14,8), %zmm18

// CHECK: vcvtpd2qq (%rcx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x7b,0x11]
          vcvtpd2qq (%rcx){1to8}, %zmm18

// CHECK: vcvtpd2qq 8128(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7b,0x52,0x7f]
          vcvtpd2qq 8128(%rdx), %zmm18

// CHECK: vcvtpd2qq 8192(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7b,0x92,0x00,0x20,0x00,0x00]
          vcvtpd2qq 8192(%rdx), %zmm18

// CHECK: vcvtpd2qq -8192(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7b,0x52,0x80]
          vcvtpd2qq -8192(%rdx), %zmm18

// CHECK: vcvtpd2qq -8256(%rdx), %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x7b,0x92,0xc0,0xdf,0xff,0xff]
          vcvtpd2qq -8256(%rdx), %zmm18

// CHECK: vcvtpd2qq 1016(%rdx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x7b,0x52,0x7f]
          vcvtpd2qq 1016(%rdx){1to8}, %zmm18

// CHECK: vcvtpd2qq 1024(%rdx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x7b,0x92,0x00,0x04,0x00,0x00]
          vcvtpd2qq 1024(%rdx){1to8}, %zmm18

// CHECK: vcvtpd2qq -1024(%rdx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x7b,0x52,0x80]
          vcvtpd2qq -1024(%rdx){1to8}, %zmm18

// CHECK: vcvtpd2qq -1032(%rdx){1to8}, %zmm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x7b,0x92,0xf8,0xfb,0xff,0xff]
          vcvtpd2qq -1032(%rdx){1to8}, %zmm18

// CHECK: vcvtpd2uqq %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x79,0xf5]
          vcvtpd2uqq %zmm21, %zmm22

// CHECK: vcvtpd2uqq %zmm21, %zmm22 {%k5}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x4d,0x79,0xf5]
          vcvtpd2uqq %zmm21, %zmm22 {%k5}

// CHECK: vcvtpd2uqq %zmm21, %zmm22 {%k5} {z}
// CHECK:  encoding: [0x62,0xa1,0xfd,0xcd,0x79,0xf5]
          vcvtpd2uqq %zmm21, %zmm22 {%k5} {z}

// CHECK: vcvtpd2uqq {rn-sae}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x18,0x79,0xf5]
          vcvtpd2uqq {rn-sae}, %zmm21, %zmm22

// CHECK: vcvtpd2uqq {ru-sae}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x58,0x79,0xf5]
          vcvtpd2uqq {ru-sae}, %zmm21, %zmm22

// CHECK: vcvtpd2uqq {rd-sae}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x38,0x79,0xf5]
          vcvtpd2uqq {rd-sae}, %zmm21, %zmm22

// CHECK: vcvtpd2uqq {rz-sae}, %zmm21, %zmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x78,0x79,0xf5]
          vcvtpd2uqq {rz-sae}, %zmm21, %zmm22

// CHECK: vcvtpd2uqq (%rcx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x79,0x31]
          vcvtpd2uqq (%rcx), %zmm22

// CHECK: vcvtpd2uqq 291(%rax,%r14,8), %zmm22
// CHECK:  encoding: [0x62,0xa1,0xfd,0x48,0x79,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vcvtpd2uqq 291(%rax,%r14,8), %zmm22

// CHECK: vcvtpd2uqq (%rcx){1to8}, %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x79,0x31]
          vcvtpd2uqq (%rcx){1to8}, %zmm22

// CHECK: vcvtpd2uqq 8128(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x79,0x72,0x7f]
          vcvtpd2uqq 8128(%rdx), %zmm22

// CHECK: vcvtpd2uqq 8192(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x79,0xb2,0x00,0x20,0x00,0x00]
          vcvtpd2uqq 8192(%rdx), %zmm22

// CHECK: vcvtpd2uqq -8192(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x79,0x72,0x80]
          vcvtpd2uqq -8192(%rdx), %zmm22

// CHECK: vcvtpd2uqq -8256(%rdx), %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x48,0x79,0xb2,0xc0,0xdf,0xff,0xff]
          vcvtpd2uqq -8256(%rdx), %zmm22

// CHECK: vcvtpd2uqq 1016(%rdx){1to8}, %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x79,0x72,0x7f]
          vcvtpd2uqq 1016(%rdx){1to8}, %zmm22

// CHECK: vcvtpd2uqq 1024(%rdx){1to8}, %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x79,0xb2,0x00,0x04,0x00,0x00]
          vcvtpd2uqq 1024(%rdx){1to8}, %zmm22

// CHECK: vcvtpd2uqq -1024(%rdx){1to8}, %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x79,0x72,0x80]
          vcvtpd2uqq -1024(%rdx){1to8}, %zmm22

// CHECK: vcvtpd2uqq -1032(%rdx){1to8}, %zmm22
// CHECK:  encoding: [0x62,0xe1,0xfd,0x58,0x79,0xb2,0xf8,0xfb,0xff,0xff]
          vcvtpd2uqq -1032(%rdx){1to8}, %zmm22

// CHECK: vcvtps2qq %ymm18, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x7b,0xe2]
          vcvtps2qq %ymm18, %zmm20

// CHECK: vcvtps2qq %ymm18, %zmm20 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x7d,0x4a,0x7b,0xe2]
          vcvtps2qq %ymm18, %zmm20 {%k2}

// CHECK: vcvtps2qq %ymm18, %zmm20 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x7d,0xca,0x7b,0xe2]
          vcvtps2qq %ymm18, %zmm20 {%k2} {z}

// CHECK: vcvtps2qq {rn-sae}, %ymm18, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x7d,0x18,0x7b,0xe2]
          vcvtps2qq {rn-sae}, %ymm18, %zmm20

// CHECK: vcvtps2qq {ru-sae}, %ymm18, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x7d,0x58,0x7b,0xe2]
          vcvtps2qq {ru-sae}, %ymm18, %zmm20

// CHECK: vcvtps2qq {rd-sae}, %ymm18, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x7d,0x38,0x7b,0xe2]
          vcvtps2qq {rd-sae}, %ymm18, %zmm20

// CHECK: vcvtps2qq {rz-sae}, %ymm18, %zmm20
// CHECK:  encoding: [0x62,0xa1,0x7d,0x78,0x7b,0xe2]
          vcvtps2qq {rz-sae}, %ymm18, %zmm20

// CHECK: vcvtps2qq (%rcx), %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7b,0x21]
          vcvtps2qq (%rcx), %zmm20

// CHECK: vcvtps2qq 291(%rax,%r14,8), %zmm20
// CHECK:  encoding: [0x62,0xa1,0x7d,0x48,0x7b,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2qq 291(%rax,%r14,8), %zmm20

// CHECK: vcvtps2qq (%rcx){1to8}, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x7b,0x21]
          vcvtps2qq (%rcx){1to8}, %zmm20

// CHECK: vcvtps2qq 4064(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7b,0x62,0x7f]
          vcvtps2qq 4064(%rdx), %zmm20

// CHECK: vcvtps2qq 4096(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7b,0xa2,0x00,0x10,0x00,0x00]
          vcvtps2qq 4096(%rdx), %zmm20

// CHECK: vcvtps2qq -4096(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7b,0x62,0x80]
          vcvtps2qq -4096(%rdx), %zmm20

// CHECK: vcvtps2qq -4128(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x48,0x7b,0xa2,0xe0,0xef,0xff,0xff]
          vcvtps2qq -4128(%rdx), %zmm20

// CHECK: vcvtps2qq 508(%rdx){1to8}, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x7b,0x62,0x7f]
          vcvtps2qq 508(%rdx){1to8}, %zmm20

// CHECK: vcvtps2qq 512(%rdx){1to8}, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x7b,0xa2,0x00,0x02,0x00,0x00]
          vcvtps2qq 512(%rdx){1to8}, %zmm20

// CHECK: vcvtps2qq -512(%rdx){1to8}, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x7b,0x62,0x80]
          vcvtps2qq -512(%rdx){1to8}, %zmm20

// CHECK: vcvtps2qq -516(%rdx){1to8}, %zmm20
// CHECK:  encoding: [0x62,0xe1,0x7d,0x58,0x7b,0xa2,0xfc,0xfd,0xff,0xff]
          vcvtps2qq -516(%rdx){1to8}, %zmm20

// CHECK: vcvtps2uqq %ymm27, %zmm25
// CHECK:  encoding: [0x62,0x01,0x7d,0x48,0x79,0xcb]
          vcvtps2uqq %ymm27, %zmm25

// CHECK: vcvtps2uqq %ymm27, %zmm25 {%k5}
// CHECK:  encoding: [0x62,0x01,0x7d,0x4d,0x79,0xcb]
          vcvtps2uqq %ymm27, %zmm25 {%k5}

// CHECK: vcvtps2uqq %ymm27, %zmm25 {%k5} {z}
// CHECK:  encoding: [0x62,0x01,0x7d,0xcd,0x79,0xcb]
          vcvtps2uqq %ymm27, %zmm25 {%k5} {z}

// CHECK: vcvtps2uqq {rn-sae}, %ymm27, %zmm25
// CHECK:  encoding: [0x62,0x01,0x7d,0x18,0x79,0xcb]
          vcvtps2uqq {rn-sae}, %ymm27, %zmm25

// CHECK: vcvtps2uqq {ru-sae}, %ymm27, %zmm25
// CHECK:  encoding: [0x62,0x01,0x7d,0x58,0x79,0xcb]
          vcvtps2uqq {ru-sae}, %ymm27, %zmm25

// CHECK: vcvtps2uqq {rd-sae}, %ymm27, %zmm25
// CHECK:  encoding: [0x62,0x01,0x7d,0x38,0x79,0xcb]
          vcvtps2uqq {rd-sae}, %ymm27, %zmm25

// CHECK: vcvtps2uqq {rz-sae}, %ymm27, %zmm25
// CHECK:  encoding: [0x62,0x01,0x7d,0x78,0x79,0xcb]
          vcvtps2uqq {rz-sae}, %ymm27, %zmm25

// CHECK: vcvtps2uqq (%rcx), %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0x79,0x09]
          vcvtps2uqq (%rcx), %zmm25

// CHECK: vcvtps2uqq 291(%rax,%r14,8), %zmm25
// CHECK:  encoding: [0x62,0x21,0x7d,0x48,0x79,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vcvtps2uqq 291(%rax,%r14,8), %zmm25

// CHECK: vcvtps2uqq (%rcx){1to8}, %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x58,0x79,0x09]
          vcvtps2uqq (%rcx){1to8}, %zmm25

// CHECK: vcvtps2uqq 4064(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0x79,0x4a,0x7f]
          vcvtps2uqq 4064(%rdx), %zmm25

// CHECK: vcvtps2uqq 4096(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0x79,0x8a,0x00,0x10,0x00,0x00]
          vcvtps2uqq 4096(%rdx), %zmm25

// CHECK: vcvtps2uqq -4096(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0x79,0x4a,0x80]
          vcvtps2uqq -4096(%rdx), %zmm25

// CHECK: vcvtps2uqq -4128(%rdx), %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x48,0x79,0x8a,0xe0,0xef,0xff,0xff]
          vcvtps2uqq -4128(%rdx), %zmm25

// CHECK: vcvtps2uqq 508(%rdx){1to8}, %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x58,0x79,0x4a,0x7f]
          vcvtps2uqq 508(%rdx){1to8}, %zmm25

// CHECK: vcvtps2uqq 512(%rdx){1to8}, %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x58,0x79,0x8a,0x00,0x02,0x00,0x00]
          vcvtps2uqq 512(%rdx){1to8}, %zmm25

// CHECK: vcvtps2uqq -512(%rdx){1to8}, %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x58,0x79,0x4a,0x80]
          vcvtps2uqq -512(%rdx){1to8}, %zmm25

// CHECK: vcvtps2uqq -516(%rdx){1to8}, %zmm25
// CHECK:  encoding: [0x62,0x61,0x7d,0x58,0x79,0x8a,0xfc,0xfd,0xff,0xff]
          vcvtps2uqq -516(%rdx){1to8}, %zmm25

// CHECK: vcvtqq2pd %zmm25, %zmm17
// CHECK:  encoding: [0x62,0x81,0xfe,0x48,0xe6,0xc9]
          vcvtqq2pd %zmm25, %zmm17

// CHECK: vcvtqq2pd %zmm25, %zmm17 {%k4}
// CHECK:  encoding: [0x62,0x81,0xfe,0x4c,0xe6,0xc9]
          vcvtqq2pd %zmm25, %zmm17 {%k4}

// CHECK: vcvtqq2pd %zmm25, %zmm17 {%k4} {z}
// CHECK:  encoding: [0x62,0x81,0xfe,0xcc,0xe6,0xc9]
          vcvtqq2pd %zmm25, %zmm17 {%k4} {z}

// CHECK: vcvtqq2pd {rn-sae}, %zmm25, %zmm17
// CHECK:  encoding: [0x62,0x81,0xfe,0x18,0xe6,0xc9]
          vcvtqq2pd {rn-sae}, %zmm25, %zmm17

// CHECK: vcvtqq2pd {ru-sae}, %zmm25, %zmm17
// CHECK:  encoding: [0x62,0x81,0xfe,0x58,0xe6,0xc9]
          vcvtqq2pd {ru-sae}, %zmm25, %zmm17

// CHECK: vcvtqq2pd {rd-sae}, %zmm25, %zmm17
// CHECK:  encoding: [0x62,0x81,0xfe,0x38,0xe6,0xc9]
          vcvtqq2pd {rd-sae}, %zmm25, %zmm17

// CHECK: vcvtqq2pd {rz-sae}, %zmm25, %zmm17
// CHECK:  encoding: [0x62,0x81,0xfe,0x78,0xe6,0xc9]
          vcvtqq2pd {rz-sae}, %zmm25, %zmm17

// CHECK: vcvtqq2pd (%rcx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0xe6,0x09]
          vcvtqq2pd (%rcx), %zmm17

// CHECK: vcvtqq2pd 291(%rax,%r14,8), %zmm17
// CHECK:  encoding: [0x62,0xa1,0xfe,0x48,0xe6,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vcvtqq2pd 291(%rax,%r14,8), %zmm17

// CHECK: vcvtqq2pd (%rcx){1to8}, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0xe6,0x09]
          vcvtqq2pd (%rcx){1to8}, %zmm17

// CHECK: vcvtqq2pd 8128(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0xe6,0x4a,0x7f]
          vcvtqq2pd 8128(%rdx), %zmm17

// CHECK: vcvtqq2pd 8192(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0xe6,0x8a,0x00,0x20,0x00,0x00]
          vcvtqq2pd 8192(%rdx), %zmm17

// CHECK: vcvtqq2pd -8192(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0xe6,0x4a,0x80]
          vcvtqq2pd -8192(%rdx), %zmm17

// CHECK: vcvtqq2pd -8256(%rdx), %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0xe6,0x8a,0xc0,0xdf,0xff,0xff]
          vcvtqq2pd -8256(%rdx), %zmm17

// CHECK: vcvtqq2pd 1016(%rdx){1to8}, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0xe6,0x4a,0x7f]
          vcvtqq2pd 1016(%rdx){1to8}, %zmm17

// CHECK: vcvtqq2pd 1024(%rdx){1to8}, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0xe6,0x8a,0x00,0x04,0x00,0x00]
          vcvtqq2pd 1024(%rdx){1to8}, %zmm17

// CHECK: vcvtqq2pd -1024(%rdx){1to8}, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0xe6,0x4a,0x80]
          vcvtqq2pd -1024(%rdx){1to8}, %zmm17

// CHECK: vcvtqq2pd -1032(%rdx){1to8}, %zmm17
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0xe6,0x8a,0xf8,0xfb,0xff,0xff]
          vcvtqq2pd -1032(%rdx){1to8}, %zmm17

// CHECK: vcvtqq2ps %zmm27, %ymm20
// CHECK:  encoding: [0x62,0x81,0xfc,0x48,0x5b,0xe3]
          vcvtqq2ps %zmm27, %ymm20

// CHECK: vcvtqq2ps %zmm27, %ymm20 {%k5}
// CHECK:  encoding: [0x62,0x81,0xfc,0x4d,0x5b,0xe3]
          vcvtqq2ps %zmm27, %ymm20 {%k5}

// CHECK: vcvtqq2ps %zmm27, %ymm20 {%k5} {z}
// CHECK:  encoding: [0x62,0x81,0xfc,0xcd,0x5b,0xe3]
          vcvtqq2ps %zmm27, %ymm20 {%k5} {z}

// CHECK: vcvtqq2ps {rn-sae}, %zmm27, %ymm20
// CHECK:  encoding: [0x62,0x81,0xfc,0x18,0x5b,0xe3]
          vcvtqq2ps {rn-sae}, %zmm27, %ymm20

// CHECK: vcvtqq2ps {ru-sae}, %zmm27, %ymm20
// CHECK:  encoding: [0x62,0x81,0xfc,0x58,0x5b,0xe3]
          vcvtqq2ps {ru-sae}, %zmm27, %ymm20

// CHECK: vcvtqq2ps {rd-sae}, %zmm27, %ymm20
// CHECK:  encoding: [0x62,0x81,0xfc,0x38,0x5b,0xe3]
          vcvtqq2ps {rd-sae}, %zmm27, %ymm20

// CHECK: vcvtqq2ps {rz-sae}, %zmm27, %ymm20
// CHECK:  encoding: [0x62,0x81,0xfc,0x78,0x5b,0xe3]
          vcvtqq2ps {rz-sae}, %zmm27, %ymm20

// CHECK: vcvtqq2ps (%rcx), %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x5b,0x21]
          vcvtqq2ps (%rcx), %ymm20

// CHECK: vcvtqq2ps 291(%rax,%r14,8), %ymm20
// CHECK:  encoding: [0x62,0xa1,0xfc,0x48,0x5b,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vcvtqq2ps 291(%rax,%r14,8), %ymm20

// CHECK: vcvtqq2ps (%rcx){1to8}, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x5b,0x21]
          vcvtqq2ps (%rcx){1to8}, %ymm20

// CHECK: vcvtqq2ps 8128(%rdx), %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x5b,0x62,0x7f]
          vcvtqq2ps 8128(%rdx), %ymm20

// CHECK: vcvtqq2ps 8192(%rdx), %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x5b,0xa2,0x00,0x20,0x00,0x00]
          vcvtqq2ps 8192(%rdx), %ymm20

// CHECK: vcvtqq2ps -8192(%rdx), %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x5b,0x62,0x80]
          vcvtqq2ps -8192(%rdx), %ymm20

// CHECK: vcvtqq2ps -8256(%rdx), %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x48,0x5b,0xa2,0xc0,0xdf,0xff,0xff]
          vcvtqq2ps -8256(%rdx), %ymm20

// CHECK: vcvtqq2ps 1016(%rdx){1to8}, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x5b,0x62,0x7f]
          vcvtqq2ps 1016(%rdx){1to8}, %ymm20

// CHECK: vcvtqq2ps 1024(%rdx){1to8}, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x5b,0xa2,0x00,0x04,0x00,0x00]
          vcvtqq2ps 1024(%rdx){1to8}, %ymm20

// CHECK: vcvtqq2ps -1024(%rdx){1to8}, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x5b,0x62,0x80]
          vcvtqq2ps -1024(%rdx){1to8}, %ymm20

// CHECK: vcvtqq2ps -1032(%rdx){1to8}, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xfc,0x58,0x5b,0xa2,0xf8,0xfb,0xff,0xff]
          vcvtqq2ps -1032(%rdx){1to8}, %ymm20

// CHECK: vcvtqq2ps %zmm19, %ymm28
// CHECK:  encoding: [0x62,0x21,0xfc,0x48,0x5b,0xe3]
          vcvtqq2ps %zmm19, %ymm28

// CHECK: vcvtqq2ps %zmm19, %ymm28 {%k3}
// CHECK:  encoding: [0x62,0x21,0xfc,0x4b,0x5b,0xe3]
          vcvtqq2ps %zmm19, %ymm28 {%k3}

// CHECK: vcvtqq2ps %zmm19, %ymm28 {%k3} {z}
// CHECK:  encoding: [0x62,0x21,0xfc,0xcb,0x5b,0xe3]
          vcvtqq2ps %zmm19, %ymm28 {%k3} {z}

// CHECK: vcvtqq2ps {rn-sae}, %zmm19, %ymm28
// CHECK:  encoding: [0x62,0x21,0xfc,0x18,0x5b,0xe3]
          vcvtqq2ps {rn-sae}, %zmm19, %ymm28

// CHECK: vcvtqq2ps {ru-sae}, %zmm19, %ymm28
// CHECK:  encoding: [0x62,0x21,0xfc,0x58,0x5b,0xe3]
          vcvtqq2ps {ru-sae}, %zmm19, %ymm28

// CHECK: vcvtqq2ps {rd-sae}, %zmm19, %ymm28
// CHECK:  encoding: [0x62,0x21,0xfc,0x38,0x5b,0xe3]
          vcvtqq2ps {rd-sae}, %zmm19, %ymm28

// CHECK: vcvtqq2ps {rz-sae}, %zmm19, %ymm28
// CHECK:  encoding: [0x62,0x21,0xfc,0x78,0x5b,0xe3]
          vcvtqq2ps {rz-sae}, %zmm19, %ymm28

// CHECK: vcvtqq2ps (%rcx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x5b,0x21]
          vcvtqq2ps (%rcx), %ymm28

// CHECK: vcvtqq2ps 4660(%rax,%r14,8), %ymm28
// CHECK:  encoding: [0x62,0x21,0xfc,0x48,0x5b,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vcvtqq2ps 4660(%rax,%r14,8), %ymm28

// CHECK: vcvtqq2ps (%rcx){1to8}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x5b,0x21]
          vcvtqq2ps (%rcx){1to8}, %ymm28

// CHECK: vcvtqq2ps 8128(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x5b,0x62,0x7f]
          vcvtqq2ps 8128(%rdx), %ymm28

// CHECK: vcvtqq2ps 8192(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x5b,0xa2,0x00,0x20,0x00,0x00]
          vcvtqq2ps 8192(%rdx), %ymm28

// CHECK: vcvtqq2ps -8192(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x5b,0x62,0x80]
          vcvtqq2ps -8192(%rdx), %ymm28

// CHECK: vcvtqq2ps -8256(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x48,0x5b,0xa2,0xc0,0xdf,0xff,0xff]
          vcvtqq2ps -8256(%rdx), %ymm28

// CHECK: vcvtqq2ps 1016(%rdx){1to8}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x5b,0x62,0x7f]
          vcvtqq2ps 1016(%rdx){1to8}, %ymm28

// CHECK: vcvtqq2ps 1024(%rdx){1to8}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x5b,0xa2,0x00,0x04,0x00,0x00]
          vcvtqq2ps 1024(%rdx){1to8}, %ymm28

// CHECK: vcvtqq2ps -1024(%rdx){1to8}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x5b,0x62,0x80]
          vcvtqq2ps -1024(%rdx){1to8}, %ymm28

// CHECK: vcvtqq2ps -1032(%rdx){1to8}, %ymm28
// CHECK:  encoding: [0x62,0x61,0xfc,0x58,0x5b,0xa2,0xf8,0xfb,0xff,0xff]
          vcvtqq2ps -1032(%rdx){1to8}, %ymm28

// CHECK: vcvtuqq2pd %zmm29, %zmm21
// CHECK:  encoding: [0x62,0x81,0xfe,0x48,0x7a,0xed]
          vcvtuqq2pd %zmm29, %zmm21

// CHECK: vcvtuqq2pd %zmm29, %zmm21 {%k6}
// CHECK:  encoding: [0x62,0x81,0xfe,0x4e,0x7a,0xed]
          vcvtuqq2pd %zmm29, %zmm21 {%k6}

// CHECK: vcvtuqq2pd %zmm29, %zmm21 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0xfe,0xce,0x7a,0xed]
          vcvtuqq2pd %zmm29, %zmm21 {%k6} {z}

// CHECK: vcvtuqq2pd {rn-sae}, %zmm29, %zmm21
// CHECK:  encoding: [0x62,0x81,0xfe,0x18,0x7a,0xed]
          vcvtuqq2pd {rn-sae}, %zmm29, %zmm21

// CHECK: vcvtuqq2pd {ru-sae}, %zmm29, %zmm21
// CHECK:  encoding: [0x62,0x81,0xfe,0x58,0x7a,0xed]
          vcvtuqq2pd {ru-sae}, %zmm29, %zmm21

// CHECK: vcvtuqq2pd {rd-sae}, %zmm29, %zmm21
// CHECK:  encoding: [0x62,0x81,0xfe,0x38,0x7a,0xed]
          vcvtuqq2pd {rd-sae}, %zmm29, %zmm21

// CHECK: vcvtuqq2pd {rz-sae}, %zmm29, %zmm21
// CHECK:  encoding: [0x62,0x81,0xfe,0x78,0x7a,0xed]
          vcvtuqq2pd {rz-sae}, %zmm29, %zmm21

// CHECK: vcvtuqq2pd (%rcx), %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0x7a,0x29]
          vcvtuqq2pd (%rcx), %zmm21

// CHECK: vcvtuqq2pd 291(%rax,%r14,8), %zmm21
// CHECK:  encoding: [0x62,0xa1,0xfe,0x48,0x7a,0xac,0xf0,0x23,0x01,0x00,0x00]
          vcvtuqq2pd 291(%rax,%r14,8), %zmm21

// CHECK: vcvtuqq2pd (%rcx){1to8}, %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0x7a,0x29]
          vcvtuqq2pd (%rcx){1to8}, %zmm21

// CHECK: vcvtuqq2pd 8128(%rdx), %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0x7a,0x6a,0x7f]
          vcvtuqq2pd 8128(%rdx), %zmm21

// CHECK: vcvtuqq2pd 8192(%rdx), %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0x7a,0xaa,0x00,0x20,0x00,0x00]
          vcvtuqq2pd 8192(%rdx), %zmm21

// CHECK: vcvtuqq2pd -8192(%rdx), %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0x7a,0x6a,0x80]
          vcvtuqq2pd -8192(%rdx), %zmm21

// CHECK: vcvtuqq2pd -8256(%rdx), %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x48,0x7a,0xaa,0xc0,0xdf,0xff,0xff]
          vcvtuqq2pd -8256(%rdx), %zmm21

// CHECK: vcvtuqq2pd 1016(%rdx){1to8}, %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0x7a,0x6a,0x7f]
          vcvtuqq2pd 1016(%rdx){1to8}, %zmm21

// CHECK: vcvtuqq2pd 1024(%rdx){1to8}, %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0x7a,0xaa,0x00,0x04,0x00,0x00]
          vcvtuqq2pd 1024(%rdx){1to8}, %zmm21

// CHECK: vcvtuqq2pd -1024(%rdx){1to8}, %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0x7a,0x6a,0x80]
          vcvtuqq2pd -1024(%rdx){1to8}, %zmm21

// CHECK: vcvtuqq2pd -1032(%rdx){1to8}, %zmm21
// CHECK:  encoding: [0x62,0xe1,0xfe,0x58,0x7a,0xaa,0xf8,0xfb,0xff,0xff]
          vcvtuqq2pd -1032(%rdx){1to8}, %zmm21

// CHECK: vcvtuqq2ps %zmm21, %ymm18
// CHECK:  encoding: [0x62,0xa1,0xff,0x48,0x7a,0xd5]
          vcvtuqq2ps %zmm21, %ymm18

// CHECK: vcvtuqq2ps %zmm21, %ymm18 {%k2}
// CHECK:  encoding: [0x62,0xa1,0xff,0x4a,0x7a,0xd5]
          vcvtuqq2ps %zmm21, %ymm18 {%k2}

// CHECK: vcvtuqq2ps %zmm21, %ymm18 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0xff,0xca,0x7a,0xd5]
          vcvtuqq2ps %zmm21, %ymm18 {%k2} {z}

// CHECK: vpextrd $171, %xmm28, %eax
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x16,0xe0,0xab]
          vpextrd $0xab, %xmm28, %eax

// CHECK: vpextrd $123, %xmm28, %eax
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x16,0xe0,0x7b]
          vpextrd $0x7b, %xmm28, %eax

// CHECK: vpextrd $123, %xmm28, %ebp
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x16,0xe5,0x7b]
          vpextrd $0x7b, %xmm28, %ebp

// CHECK: vpextrd $123, %xmm28, %r13d
// CHECK:  encoding: [0x62,0x43,0x7d,0x08,0x16,0xe5,0x7b]
          vpextrd $0x7b, %xmm28, %r13d

// CHECK: vpextrd $123, %xmm28, (%rcx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x16,0x21,0x7b]
          vpextrd $0x7b, %xmm28, (%rcx)

// CHECK: vpextrd $123, %xmm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x23,0x7d,0x08,0x16,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpextrd $0x7b, %xmm28, 291(%rax,%r14,8)

// CHECK: vpextrd $123, %xmm28, 508(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x16,0x62,0x7f,0x7b]
          vpextrd $0x7b, %xmm28, 508(%rdx)

// CHECK: vpextrd $123, %xmm28, 512(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x16,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vpextrd $0x7b, %xmm28, 512(%rdx)

// CHECK: vpextrd $123, %xmm28, -512(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x16,0x62,0x80,0x7b]
          vpextrd $0x7b, %xmm28, -512(%rdx)

// CHECK: vpextrd $123, %xmm28, -516(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x08,0x16,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vpextrd $0x7b, %xmm28, -516(%rdx)

// CHECK: vpextrd $171, %xmm20, %eax
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x16,0xe0,0xab]
          vpextrd $0xab, %xmm20, %eax

// CHECK: vpextrd $123, %xmm20, %eax
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x16,0xe0,0x7b]
          vpextrd $0x7b, %xmm20, %eax

// CHECK: vpextrd $123, %xmm20, %ebp
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x16,0xe5,0x7b]
          vpextrd $0x7b, %xmm20, %ebp

// CHECK: vpextrd $123, %xmm20, %r13d
// CHECK:  encoding: [0x62,0xc3,0x7d,0x08,0x16,0xe5,0x7b]
          vpextrd $0x7b, %xmm20, %r13d

// CHECK: vpextrd $123, %xmm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x16,0x21,0x7b]
          vpextrd $0x7b, %xmm20, (%rcx)

// CHECK: vpextrd $123, %xmm20, 4660(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0x7d,0x08,0x16,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vpextrd $0x7b, %xmm20, 4660(%rax,%r14,8)

// CHECK: vpextrd $123, %xmm20, 508(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x16,0x62,0x7f,0x7b]
          vpextrd $0x7b, %xmm20, 508(%rdx)

// CHECK: vpextrd $123, %xmm20, 512(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x16,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vpextrd $0x7b, %xmm20, 512(%rdx)

// CHECK: vpextrd $123, %xmm20, -512(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x16,0x62,0x80,0x7b]
          vpextrd $0x7b, %xmm20, -512(%rdx)

// CHECK: vpextrd $123, %xmm20, -516(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x08,0x16,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vpextrd $0x7b, %xmm20, -516(%rdx)

// CHECK: vpextrq $171, %xmm24, %rax
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x16,0xc0,0xab]
          vpextrq $0xab, %xmm24, %rax

// CHECK: vpextrq $123, %xmm24, %rax
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x16,0xc0,0x7b]
          vpextrq $0x7b, %xmm24, %rax

// CHECK: vpextrq $123, %xmm24, %r8
// CHECK:  encoding: [0x62,0x43,0xfd,0x08,0x16,0xc0,0x7b]
          vpextrq $0x7b, %xmm24, %r8

// CHECK: vpextrq $123, %xmm24, (%rcx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x16,0x01,0x7b]
          vpextrq $0x7b, %xmm24, (%rcx)

// CHECK: vpextrq $123, %xmm24, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x23,0xfd,0x08,0x16,0x84,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpextrq $0x7b, %xmm24, 291(%rax,%r14,8)

// CHECK: vpextrq $123, %xmm24, 1016(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x16,0x42,0x7f,0x7b]
          vpextrq $0x7b, %xmm24, 1016(%rdx)

// CHECK: vpextrq $123, %xmm24, 1024(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x16,0x82,0x00,0x04,0x00,0x00,0x7b]
          vpextrq $0x7b, %xmm24, 1024(%rdx)

// CHECK: vpextrq $123, %xmm24, -1024(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x16,0x42,0x80,0x7b]
          vpextrq $0x7b, %xmm24, -1024(%rdx)

// CHECK: vpextrq $123, %xmm24, -1032(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x08,0x16,0x82,0xf8,0xfb,0xff,0xff,0x7b]
          vpextrq $0x7b, %xmm24, -1032(%rdx)

// CHECK: vpextrq $171, %xmm20, %rax
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x16,0xe0,0xab]
          vpextrq $0xab, %xmm20, %rax

// CHECK: vpextrq $123, %xmm20, %rax
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x16,0xe0,0x7b]
          vpextrq $0x7b, %xmm20, %rax

// CHECK: vpextrq $123, %xmm20, %r8
// CHECK:  encoding: [0x62,0xc3,0xfd,0x08,0x16,0xe0,0x7b]
          vpextrq $0x7b, %xmm20, %r8

// CHECK: vpextrq $123, %xmm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x16,0x21,0x7b]
          vpextrq $0x7b, %xmm20, (%rcx)

// CHECK: vpextrq $123, %xmm20, 4660(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0xfd,0x08,0x16,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vpextrq $0x7b, %xmm20, 4660(%rax,%r14,8)

// CHECK: vpextrq $123, %xmm20, 1016(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x16,0x62,0x7f,0x7b]
          vpextrq $0x7b, %xmm20, 1016(%rdx)

// CHECK: vpextrq $123, %xmm20, 1024(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x16,0xa2,0x00,0x04,0x00,0x00,0x7b]
          vpextrq $0x7b, %xmm20, 1024(%rdx)

// CHECK: vpextrq $123, %xmm20, -1024(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x16,0x62,0x80,0x7b]
          vpextrq $0x7b, %xmm20, -1024(%rdx)

// CHECK: vpextrq $123, %xmm20, -1032(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x08,0x16,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          vpextrq $0x7b, %xmm20, -1032(%rdx)

// CHECK: vpinsrd $171, %eax, %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xe3,0x35,0x00,0x22,0xf8,0xab]
          vpinsrd $0xab,%eax, %xmm25, %xmm23

// CHECK: vpinsrd $123, %eax, %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xe3,0x35,0x00,0x22,0xf8,0x7b]
          vpinsrd $0x7b,%eax, %xmm25, %xmm23

// CHECK: vpinsrd $123, %ebp, %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xe3,0x35,0x00,0x22,0xfd,0x7b]
          vpinsrd $0x7b,%ebp, %xmm25, %xmm23

// CHECK: vpinsrd $123, %r13d, %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xc3,0x35,0x00,0x22,0xfd,0x7b]
          vpinsrd $0x7b,%r13d, %xmm25, %xmm23

// CHECK: vpinsrd $123, (%rcx), %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xe3,0x35,0x00,0x22,0x39,0x7b]
          vpinsrd $0x7b,(%rcx), %xmm25, %xmm23

// CHECK: vpinsrd $123, 291(%rax,%r14,8), %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xa3,0x35,0x00,0x22,0xbc,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpinsrd $0x7b,291(%rax,%r14,8), %xmm25, %xmm23

// CHECK: vpinsrd $123, 508(%rdx), %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xe3,0x35,0x00,0x22,0x7a,0x7f,0x7b]
          vpinsrd $0x7b,508(%rdx), %xmm25, %xmm23

// CHECK: vpinsrd $123, 512(%rdx), %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xe3,0x35,0x00,0x22,0xba,0x00,0x02,0x00,0x00,0x7b]
          vpinsrd $0x7b,512(%rdx), %xmm25, %xmm23

// CHECK: vpinsrd $123, -512(%rdx), %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xe3,0x35,0x00,0x22,0x7a,0x80,0x7b]
          vpinsrd $0x7b,-512(%rdx), %xmm25, %xmm23

// CHECK: vpinsrd $123, -516(%rdx), %xmm25, %xmm23
// CHECK:  encoding: [0x62,0xe3,0x35,0x00,0x22,0xba,0xfc,0xfd,0xff,0xff,0x7b]
          vpinsrd $0x7b,-516(%rdx), %xmm25, %xmm23

// CHECK: vpinsrd $171, %eax, %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xe3,0x15,0x00,0x22,0xf0,0xab]
          vpinsrd $0xab,%eax, %xmm29, %xmm22

// CHECK: vpinsrd $123, %eax, %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xe3,0x15,0x00,0x22,0xf0,0x7b]
          vpinsrd $0x7b,%eax, %xmm29, %xmm22

// CHECK: vpinsrd $123, %ebp, %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xe3,0x15,0x00,0x22,0xf5,0x7b]
          vpinsrd $0x7b,%ebp, %xmm29, %xmm22

// CHECK: vpinsrd $123, %r13d, %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xc3,0x15,0x00,0x22,0xf5,0x7b]
          vpinsrd $0x7b,%r13d, %xmm29, %xmm22

// CHECK: vpinsrd $123, (%rcx), %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xe3,0x15,0x00,0x22,0x31,0x7b]
          vpinsrd $0x7b,(%rcx), %xmm29, %xmm22

// CHECK: vpinsrd $123, 4660(%rax,%r14,8), %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xa3,0x15,0x00,0x22,0xb4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vpinsrd $0x7b,4660(%rax,%r14,8), %xmm29, %xmm22

// CHECK: vpinsrd $123, 508(%rdx), %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xe3,0x15,0x00,0x22,0x72,0x7f,0x7b]
          vpinsrd $0x7b,508(%rdx), %xmm29, %xmm22

// CHECK: vpinsrd $123, 512(%rdx), %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xe3,0x15,0x00,0x22,0xb2,0x00,0x02,0x00,0x00,0x7b]
          vpinsrd $0x7b,512(%rdx), %xmm29, %xmm22

// CHECK: vpinsrd $123, -512(%rdx), %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xe3,0x15,0x00,0x22,0x72,0x80,0x7b]
          vpinsrd $0x7b,-512(%rdx), %xmm29, %xmm22

// CHECK: vpinsrd $123, -516(%rdx), %xmm29, %xmm22
// CHECK:  encoding: [0x62,0xe3,0x15,0x00,0x22,0xb2,0xfc,0xfd,0xff,0xff,0x7b]
          vpinsrd $0x7b,-516(%rdx), %xmm29, %xmm22

// CHECK: vpinsrq $171, %rax, %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xe3,0xdd,0x00,0x22,0xf0,0xab]
          vpinsrq $0xab,%rax, %xmm20, %xmm22

// CHECK: vpinsrq $123, %rax, %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xe3,0xdd,0x00,0x22,0xf0,0x7b]
          vpinsrq $0x7b,%rax, %xmm20, %xmm22

// CHECK: vpinsrq $123, %r8, %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xc3,0xdd,0x00,0x22,0xf0,0x7b]
          vpinsrq $0x7b,%r8, %xmm20, %xmm22

// CHECK: vpinsrq $123, (%rcx), %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xe3,0xdd,0x00,0x22,0x31,0x7b]
          vpinsrq $0x7b,(%rcx), %xmm20, %xmm22

// CHECK: vpinsrq $123, 291(%rax,%r14,8), %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xa3,0xdd,0x00,0x22,0xb4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpinsrq $0x7b,291(%rax,%r14,8), %xmm20, %xmm22

// CHECK: vpinsrq $123, 1016(%rdx), %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xe3,0xdd,0x00,0x22,0x72,0x7f,0x7b]
          vpinsrq $0x7b,1016(%rdx), %xmm20, %xmm22

// CHECK: vpinsrq $123, 1024(%rdx), %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xe3,0xdd,0x00,0x22,0xb2,0x00,0x04,0x00,0x00,0x7b]
          vpinsrq $0x7b,1024(%rdx), %xmm20, %xmm22

// CHECK: vpinsrq $123, -1024(%rdx), %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xe3,0xdd,0x00,0x22,0x72,0x80,0x7b]
          vpinsrq $0x7b,-1024(%rdx), %xmm20, %xmm22

// CHECK: vpinsrq $123, -1032(%rdx), %xmm20, %xmm22
// CHECK:  encoding: [0x62,0xe3,0xdd,0x00,0x22,0xb2,0xf8,0xfb,0xff,0xff,0x7b]
          vpinsrq $0x7b,-1032(%rdx), %xmm20, %xmm22

// CHECK: vpinsrq $171, %rax, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x22,0xc8,0xab]
          vpinsrq $0xab,%rax, %xmm19, %xmm25

// CHECK: vpinsrq $123, %rax, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x22,0xc8,0x7b]
          vpinsrq $0x7b,%rax, %xmm19, %xmm25

// CHECK: vpinsrq $123, %r8, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x43,0xe5,0x00,0x22,0xc8,0x7b]
          vpinsrq $0x7b,%r8, %xmm19, %xmm25

// CHECK: vpinsrq $123, (%rcx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x22,0x09,0x7b]
          vpinsrq $0x7b,(%rcx), %xmm19, %xmm25

// CHECK: vpinsrq $123, 4660(%rax,%r14,8), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x23,0xe5,0x00,0x22,0x8c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vpinsrq $0x7b,4660(%rax,%r14,8), %xmm19, %xmm25

// CHECK: vpinsrq $123, 1016(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x22,0x4a,0x7f,0x7b]
          vpinsrq $0x7b,1016(%rdx), %xmm19, %xmm25

// CHECK: vpinsrq $123, 1024(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x22,0x8a,0x00,0x04,0x00,0x00,0x7b]
          vpinsrq $0x7b,1024(%rdx), %xmm19, %xmm25

// CHECK: vpinsrq $123, -1024(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x22,0x4a,0x80,0x7b]
          vpinsrq $0x7b,-1024(%rdx), %xmm19, %xmm25

// CHECK: vpinsrq $123, -1032(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x63,0xe5,0x00,0x22,0x8a,0xf8,0xfb,0xff,0xff,0x7b]
          vpinsrq $0x7b,-1032(%rdx), %xmm19, %xmm25

// CHECK: vinsertf32x8 $171, %ymm24, %zmm17, %zmm29
// CHECK:  encoding: [0x62,0x03,0x75,0x40,0x1a,0xe8,0xab]
          vinsertf32x8 $0xab, %ymm24, %zmm17, %zmm29

// CHECK: vinsertf32x8 $171, %ymm24, %zmm17, %zmm29 {%k3}
// CHECK:  encoding: [0x62,0x03,0x75,0x43,0x1a,0xe8,0xab]
          vinsertf32x8 $0xab, %ymm24, %zmm17, %zmm29 {%k3}

// CHECK: vinsertf32x8 $171, %ymm24, %zmm17, %zmm29 {%k3} {z}
// CHECK:  encoding: [0x62,0x03,0x75,0xc3,0x1a,0xe8,0xab]
          vinsertf32x8 $0xab, %ymm24, %zmm17, %zmm29 {%k3} {z}

// CHECK: vinsertf32x8 $123, %ymm24, %zmm17, %zmm29
// CHECK:  encoding: [0x62,0x03,0x75,0x40,0x1a,0xe8,0x7b]
          vinsertf32x8 $0x7b, %ymm24, %zmm17, %zmm29

// CHECK: vinsertf32x8 $123, (%rcx), %zmm17, %zmm29
// CHECK:  encoding: [0x62,0x63,0x75,0x40,0x1a,0x29,0x7b]
          vinsertf32x8 $0x7b,(%rcx), %zmm17, %zmm29

// CHECK: vinsertf32x8 $123, 291(%rax,%r14,8), %zmm17, %zmm29
// CHECK:  encoding: [0x62,0x23,0x75,0x40,0x1a,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinsertf32x8 $0x7b,291(%rax,%r14,8), %zmm17, %zmm29

// CHECK: vinsertf32x8 $123, 4064(%rdx), %zmm17, %zmm29
// CHECK:  encoding: [0x62,0x63,0x75,0x40,0x1a,0x6a,0x7f,0x7b]
          vinsertf32x8 $0x7b,4064(%rdx), %zmm17, %zmm29

// CHECK: vinsertf32x8 $123, 4096(%rdx), %zmm17, %zmm29
// CHECK:  encoding: [0x62,0x63,0x75,0x40,0x1a,0xaa,0x00,0x10,0x00,0x00,0x7b]
          vinsertf32x8 $0x7b,4096(%rdx), %zmm17, %zmm29

// CHECK: vinsertf32x8 $123, -4096(%rdx), %zmm17, %zmm29
// CHECK:  encoding: [0x62,0x63,0x75,0x40,0x1a,0x6a,0x80,0x7b]
          vinsertf32x8 $0x7b,-4096(%rdx), %zmm17, %zmm29

// CHECK: vinsertf32x8 $123, -4128(%rdx), %zmm17, %zmm29
// CHECK:  encoding: [0x62,0x63,0x75,0x40,0x1a,0xaa,0xe0,0xef,0xff,0xff,0x7b]
          vinsertf32x8 $0x7b,-4128(%rdx), %zmm17, %zmm29

// CHECK: vinsertf32x8 $171, %ymm22, %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x23,0x1d,0x40,0x1a,0xee,0xab]
          vinsertf32x8 $0xab, %ymm22, %zmm28, %zmm29

// CHECK: vinsertf32x8 $171, %ymm22, %zmm28, %zmm29 {%k5}
// CHECK:  encoding: [0x62,0x23,0x1d,0x45,0x1a,0xee,0xab]
          vinsertf32x8 $0xab, %ymm22, %zmm28, %zmm29 {%k5}

// CHECK: vinsertf32x8 $171, %ymm22, %zmm28, %zmm29 {%k5} {z}
// CHECK:  encoding: [0x62,0x23,0x1d,0xc5,0x1a,0xee,0xab]
          vinsertf32x8 $0xab, %ymm22, %zmm28, %zmm29 {%k5} {z}

// CHECK: vinsertf32x8 $123, %ymm22, %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x23,0x1d,0x40,0x1a,0xee,0x7b]
          vinsertf32x8 $0x7b, %ymm22, %zmm28, %zmm29

// CHECK: vinsertf32x8 $123, (%rcx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x63,0x1d,0x40,0x1a,0x29,0x7b]
          vinsertf32x8 $0x7b,(%rcx), %zmm28, %zmm29

// CHECK: vinsertf32x8 $123, 4660(%rax,%r14,8), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x23,0x1d,0x40,0x1a,0xac,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vinsertf32x8 $0x7b,4660(%rax,%r14,8), %zmm28, %zmm29

// CHECK: vinsertf32x8 $123, 4064(%rdx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x63,0x1d,0x40,0x1a,0x6a,0x7f,0x7b]
          vinsertf32x8 $0x7b,4064(%rdx), %zmm28, %zmm29

// CHECK: vinsertf32x8 $123, 4096(%rdx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x63,0x1d,0x40,0x1a,0xaa,0x00,0x10,0x00,0x00,0x7b]
          vinsertf32x8 $0x7b,4096(%rdx), %zmm28, %zmm29

// CHECK: vinsertf32x8 $123, -4096(%rdx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x63,0x1d,0x40,0x1a,0x6a,0x80,0x7b]
          vinsertf32x8 $0x7b,-4096(%rdx), %zmm28, %zmm29

// CHECK: vinsertf32x8 $123, -4128(%rdx), %zmm28, %zmm29
// CHECK:  encoding: [0x62,0x63,0x1d,0x40,0x1a,0xaa,0xe0,0xef,0xff,0xff,0x7b]
          vinsertf32x8 $0x7b,-4128(%rdx), %zmm28, %zmm29

// CHECK: vinsertf64x2 $171, %xmm25, %zmm28, %zmm17
// CHECK:  encoding: [0x62,0x83,0x9d,0x40,0x18,0xc9,0xab]
          vinsertf64x2 $0xab, %xmm25, %zmm28, %zmm17

// CHECK: vinsertf64x2 $171, %xmm25, %zmm28, %zmm17 {%k2}
// CHECK:  encoding: [0x62,0x83,0x9d,0x42,0x18,0xc9,0xab]
          vinsertf64x2 $0xab, %xmm25, %zmm28, %zmm17 {%k2}

// CHECK: vinsertf64x2 $171, %xmm25, %zmm28, %zmm17 {%k2} {z}
// CHECK:  encoding: [0x62,0x83,0x9d,0xc2,0x18,0xc9,0xab]
          vinsertf64x2 $0xab, %xmm25, %zmm28, %zmm17 {%k2} {z}

// CHECK: vinsertf64x2 $123, %xmm25, %zmm28, %zmm17
// CHECK:  encoding: [0x62,0x83,0x9d,0x40,0x18,0xc9,0x7b]
          vinsertf64x2 $0x7b, %xmm25, %zmm28, %zmm17

// CHECK: vinsertf64x2 $123, (%rcx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe3,0x9d,0x40,0x18,0x09,0x7b]
          vinsertf64x2 $0x7b,(%rcx), %zmm28, %zmm17

// CHECK: vinsertf64x2 $123, 291(%rax,%r14,8), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xa3,0x9d,0x40,0x18,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinsertf64x2 $0x7b,291(%rax,%r14,8), %zmm28, %zmm17

// CHECK: vinsertf64x2 $123, 2032(%rdx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe3,0x9d,0x40,0x18,0x4a,0x7f,0x7b]
          vinsertf64x2 $0x7b,2032(%rdx), %zmm28, %zmm17

// CHECK: vinsertf64x2 $123, 2048(%rdx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe3,0x9d,0x40,0x18,0x8a,0x00,0x08,0x00,0x00,0x7b]
          vinsertf64x2 $0x7b,2048(%rdx), %zmm28, %zmm17

// CHECK: vinsertf64x2 $123, -2048(%rdx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe3,0x9d,0x40,0x18,0x4a,0x80,0x7b]
          vinsertf64x2 $0x7b,-2048(%rdx), %zmm28, %zmm17

// CHECK: vinsertf64x2 $123, -2064(%rdx), %zmm28, %zmm17
// CHECK:  encoding: [0x62,0xe3,0x9d,0x40,0x18,0x8a,0xf0,0xf7,0xff,0xff,0x7b]
          vinsertf64x2 $0x7b,-2064(%rdx), %zmm28, %zmm17

// CHECK: vinsertf64x2 $171, %xmm28, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0x83,0xf5,0x40,0x18,0xe4,0xab]
          vinsertf64x2 $0xab, %xmm28, %zmm17, %zmm20

// CHECK: vinsertf64x2 $171, %xmm28, %zmm17, %zmm20 {%k7}
// CHECK:  encoding: [0x62,0x83,0xf5,0x47,0x18,0xe4,0xab]
          vinsertf64x2 $0xab, %xmm28, %zmm17, %zmm20 {%k7}

// CHECK: vinsertf64x2 $171, %xmm28, %zmm17, %zmm20 {%k7} {z}
// CHECK:  encoding: [0x62,0x83,0xf5,0xc7,0x18,0xe4,0xab]
          vinsertf64x2 $0xab, %xmm28, %zmm17, %zmm20 {%k7} {z}

// CHECK: vinsertf64x2 $123, %xmm28, %zmm17, %zmm20
// CHECK:  encoding: [0x62,0x83,0xf5,0x40,0x18,0xe4,0x7b]
          vinsertf64x2 $0x7b, %xmm28, %zmm17, %zmm20

// CHECK: vinsertf64x2 $123, (%rcx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe3,0xf5,0x40,0x18,0x21,0x7b]
          vinsertf64x2 $0x7b,(%rcx), %zmm17, %zmm20

// CHECK: vinsertf64x2 $123, 4660(%rax,%r14,8), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xa3,0xf5,0x40,0x18,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vinsertf64x2 $0x7b,4660(%rax,%r14,8), %zmm17, %zmm20

// CHECK: vinsertf64x2 $123, 2032(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe3,0xf5,0x40,0x18,0x62,0x7f,0x7b]
          vinsertf64x2 $0x7b,2032(%rdx), %zmm17, %zmm20

// CHECK: vinsertf64x2 $123, 2048(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe3,0xf5,0x40,0x18,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vinsertf64x2 $0x7b,2048(%rdx), %zmm17, %zmm20

// CHECK: vinsertf64x2 $123, -2048(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe3,0xf5,0x40,0x18,0x62,0x80,0x7b]
          vinsertf64x2 $0x7b,-2048(%rdx), %zmm17, %zmm20

// CHECK: vinsertf64x2 $123, -2064(%rdx), %zmm17, %zmm20
// CHECK:  encoding: [0x62,0xe3,0xf5,0x40,0x18,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vinsertf64x2 $0x7b,-2064(%rdx), %zmm17, %zmm20

// CHECK: vinserti32x8 $171, %ymm22, %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x23,0x3d,0x40,0x3a,0xe6,0xab]
          vinserti32x8 $0xab, %ymm22, %zmm24, %zmm28

// CHECK: vinserti32x8 $171, %ymm22, %zmm24, %zmm28 {%k2}
// CHECK:  encoding: [0x62,0x23,0x3d,0x42,0x3a,0xe6,0xab]
          vinserti32x8 $0xab, %ymm22, %zmm24, %zmm28 {%k2}

// CHECK: vinserti32x8 $171, %ymm22, %zmm24, %zmm28 {%k2} {z}
// CHECK:  encoding: [0x62,0x23,0x3d,0xc2,0x3a,0xe6,0xab]
          vinserti32x8 $0xab, %ymm22, %zmm24, %zmm28 {%k2} {z}

// CHECK: vinserti32x8 $123, %ymm22, %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x23,0x3d,0x40,0x3a,0xe6,0x7b]
          vinserti32x8 $0x7b, %ymm22, %zmm24, %zmm28

// CHECK: vinserti32x8 $123, (%rcx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x63,0x3d,0x40,0x3a,0x21,0x7b]
          vinserti32x8 $0x7b,(%rcx), %zmm24, %zmm28

// CHECK: vinserti32x8 $123, 291(%rax,%r14,8), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x23,0x3d,0x40,0x3a,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinserti32x8 $0x7b,291(%rax,%r14,8), %zmm24, %zmm28

// CHECK: vinserti32x8 $123, 4064(%rdx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x63,0x3d,0x40,0x3a,0x62,0x7f,0x7b]
          vinserti32x8 $0x7b,4064(%rdx), %zmm24, %zmm28

// CHECK: vinserti32x8 $123, 4096(%rdx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x63,0x3d,0x40,0x3a,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vinserti32x8 $0x7b,4096(%rdx), %zmm24, %zmm28

// CHECK: vinserti32x8 $123, -4096(%rdx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x63,0x3d,0x40,0x3a,0x62,0x80,0x7b]
          vinserti32x8 $0x7b,-4096(%rdx), %zmm24, %zmm28

// CHECK: vinserti32x8 $123, -4128(%rdx), %zmm24, %zmm28
// CHECK:  encoding: [0x62,0x63,0x3d,0x40,0x3a,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vinserti32x8 $0x7b,-4128(%rdx), %zmm24, %zmm28

// CHECK: vinserti32x8 $171, %ymm24, %zmm20, %zmm28
// CHECK:  encoding: [0x62,0x03,0x5d,0x40,0x3a,0xe0,0xab]
          vinserti32x8 $0xab, %ymm24, %zmm20, %zmm28

// CHECK: vinserti32x8 $171, %ymm24, %zmm20, %zmm28 {%k7}
// CHECK:  encoding: [0x62,0x03,0x5d,0x47,0x3a,0xe0,0xab]
          vinserti32x8 $0xab, %ymm24, %zmm20, %zmm28 {%k7}

// CHECK: vinserti32x8 $171, %ymm24, %zmm20, %zmm28 {%k7} {z}
// CHECK:  encoding: [0x62,0x03,0x5d,0xc7,0x3a,0xe0,0xab]
          vinserti32x8 $0xab, %ymm24, %zmm20, %zmm28 {%k7} {z}

// CHECK: vinserti32x8 $123, %ymm24, %zmm20, %zmm28
// CHECK:  encoding: [0x62,0x03,0x5d,0x40,0x3a,0xe0,0x7b]
          vinserti32x8 $0x7b, %ymm24, %zmm20, %zmm28

// CHECK: vinserti32x8 $123, (%rcx), %zmm20, %zmm28
// CHECK:  encoding: [0x62,0x63,0x5d,0x40,0x3a,0x21,0x7b]
          vinserti32x8 $0x7b,(%rcx), %zmm20, %zmm28

// CHECK: vinserti32x8 $123, 4660(%rax,%r14,8), %zmm20, %zmm28
// CHECK:  encoding: [0x62,0x23,0x5d,0x40,0x3a,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vinserti32x8 $0x7b,4660(%rax,%r14,8), %zmm20, %zmm28

// CHECK: vinserti32x8 $123, 4064(%rdx), %zmm20, %zmm28
// CHECK:  encoding: [0x62,0x63,0x5d,0x40,0x3a,0x62,0x7f,0x7b]
          vinserti32x8 $0x7b,4064(%rdx), %zmm20, %zmm28

// CHECK: vinserti32x8 $123, 4096(%rdx), %zmm20, %zmm28
// CHECK:  encoding: [0x62,0x63,0x5d,0x40,0x3a,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vinserti32x8 $0x7b,4096(%rdx), %zmm20, %zmm28

// CHECK: vinserti32x8 $123, -4096(%rdx), %zmm20, %zmm28
// CHECK:  encoding: [0x62,0x63,0x5d,0x40,0x3a,0x62,0x80,0x7b]
          vinserti32x8 $0x7b,-4096(%rdx), %zmm20, %zmm28

// CHECK: vinserti32x8 $123, -4128(%rdx), %zmm20, %zmm28
// CHECK:  encoding: [0x62,0x63,0x5d,0x40,0x3a,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vinserti32x8 $0x7b,-4128(%rdx), %zmm20, %zmm28

// CHECK: vinserti64x2 $171, %xmm26, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x03,0xed,0x40,0x38,0xe2,0xab]
          vinserti64x2 $0xab, %xmm26, %zmm18, %zmm28

// CHECK: vinserti64x2 $171, %xmm26, %zmm18, %zmm28 {%k7}
// CHECK:  encoding: [0x62,0x03,0xed,0x47,0x38,0xe2,0xab]
          vinserti64x2 $0xab, %xmm26, %zmm18, %zmm28 {%k7}

// CHECK: vinserti64x2 $171, %xmm26, %zmm18, %zmm28 {%k7} {z}
// CHECK:  encoding: [0x62,0x03,0xed,0xc7,0x38,0xe2,0xab]
          vinserti64x2 $0xab, %xmm26, %zmm18, %zmm28 {%k7} {z}

// CHECK: vinserti64x2 $123, %xmm26, %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x03,0xed,0x40,0x38,0xe2,0x7b]
          vinserti64x2 $0x7b, %xmm26, %zmm18, %zmm28

// CHECK: vinserti64x2 $123, (%rcx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0x21,0x7b]
          vinserti64x2 $0x7b,(%rcx), %zmm18, %zmm28

// CHECK: vinserti64x2 $123, 291(%rax,%r14,8), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x23,0xed,0x40,0x38,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vinserti64x2 $0x7b,291(%rax,%r14,8), %zmm18, %zmm28

// CHECK: vinserti64x2 $123, 2032(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0x62,0x7f,0x7b]
          vinserti64x2 $0x7b,2032(%rdx), %zmm18, %zmm28

// CHECK: vinserti64x2 $123, 2048(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vinserti64x2 $0x7b,2048(%rdx), %zmm18, %zmm28

// CHECK: vinserti64x2 $123, -2048(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0x62,0x80,0x7b]
          vinserti64x2 $0x7b,-2048(%rdx), %zmm18, %zmm28

// CHECK: vinserti64x2 $123, -2064(%rdx), %zmm18, %zmm28
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vinserti64x2 $0x7b,-2064(%rdx), %zmm18, %zmm28

// CHECK: vinserti64x2 $171, %xmm21, %zmm18, %zmm27
// CHECK:  encoding: [0x62,0x23,0xed,0x40,0x38,0xdd,0xab]
          vinserti64x2 $0xab, %xmm21, %zmm18, %zmm27

// CHECK: vinserti64x2 $171, %xmm21, %zmm18, %zmm27 {%k2}
// CHECK:  encoding: [0x62,0x23,0xed,0x42,0x38,0xdd,0xab]
          vinserti64x2 $0xab, %xmm21, %zmm18, %zmm27 {%k2}

// CHECK: vinserti64x2 $171, %xmm21, %zmm18, %zmm27 {%k2} {z}
// CHECK:  encoding: [0x62,0x23,0xed,0xc2,0x38,0xdd,0xab]
          vinserti64x2 $0xab, %xmm21, %zmm18, %zmm27 {%k2} {z}

// CHECK: vinserti64x2 $123, %xmm21, %zmm18, %zmm27
// CHECK:  encoding: [0x62,0x23,0xed,0x40,0x38,0xdd,0x7b]
          vinserti64x2 $0x7b, %xmm21, %zmm18, %zmm27

// CHECK: vinserti64x2 $123, (%rcx), %zmm18, %zmm27
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0x19,0x7b]
          vinserti64x2 $0x7b,(%rcx), %zmm18, %zmm27

// CHECK: vinserti64x2 $123, 4660(%rax,%r14,8), %zmm18, %zmm27
// CHECK:  encoding: [0x62,0x23,0xed,0x40,0x38,0x9c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vinserti64x2 $0x7b,4660(%rax,%r14,8), %zmm18, %zmm27

// CHECK: vinserti64x2 $123, 2032(%rdx), %zmm18, %zmm27
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0x5a,0x7f,0x7b]
          vinserti64x2 $0x7b,2032(%rdx), %zmm18, %zmm27

// CHECK: vinserti64x2 $123, 2048(%rdx), %zmm18, %zmm27
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vinserti64x2 $0x7b,2048(%rdx), %zmm18, %zmm27

// CHECK: vinserti64x2 $123, -2048(%rdx), %zmm18, %zmm27
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0x5a,0x80,0x7b]
          vinserti64x2 $0x7b,-2048(%rdx), %zmm18, %zmm27

// CHECK: vinserti64x2 $123, -2064(%rdx), %zmm18, %zmm27
// CHECK:  encoding: [0x62,0x63,0xed,0x40,0x38,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vinserti64x2 $0x7b,-2064(%rdx), %zmm18, %zmm27

// CHECK: vextractf32x8 $171, %zmm18, %ymm21
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x1b,0xd5,0xab]
          vextractf32x8 $0xab, %zmm18, %ymm21

// CHECK: vextractf32x8 $171, %zmm18, %ymm21 {%k1}
// CHECK:  encoding: [0x62,0xa3,0x7d,0x49,0x1b,0xd5,0xab]
          vextractf32x8 $0xab, %zmm18, %ymm21 {%k1}

// CHECK: vextractf32x8 $171, %zmm18, %ymm21 {%k1} {z}
// CHECK:  encoding: [0x62,0xa3,0x7d,0xc9,0x1b,0xd5,0xab]
          vextractf32x8 $0xab, %zmm18, %ymm21 {%k1} {z}

// CHECK: vextractf32x8 $123, %zmm18, %ymm21
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x1b,0xd5,0x7b]
          vextractf32x8 $0x7b, %zmm18, %ymm21

// CHECK: vextractf32x8 $171, %zmm21, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0x29,0xab]
          vextractf32x8 $0xab, %zmm21,(%rcx)

// CHECK: vextractf32x8 $171, %zmm21, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0xe3,0x7d,0x4b,0x1b,0x29,0xab]
          vextractf32x8 $0xab, %zmm21,(%rcx) {%k3}

// CHECK: vextractf32x8 $123, %zmm21, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0x29,0x7b]
          vextractf32x8 $0x7b, %zmm21,(%rcx)

// CHECK: vextractf32x8 $123, %zmm21, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x1b,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextractf32x8 $0x7b, %zmm21,291(%rax,%r14,8)

// CHECK: vextractf32x8 $123, %zmm21, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0x6a,0x7f,0x7b]
          vextractf32x8 $0x7b, %zmm21,4064(%rdx)

// CHECK: vextractf32x8 $123, %zmm21, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0xaa,0x00,0x10,0x00,0x00,0x7b]
          vextractf32x8 $0x7b, %zmm21,4096(%rdx)

// CHECK: vextractf32x8 $123, %zmm21, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0x6a,0x80,0x7b]
          vextractf32x8 $0x7b, %zmm21,-4096(%rdx)

// CHECK: vextractf32x8 $123, %zmm21, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0xaa,0xe0,0xef,0xff,0xff,0x7b]
          vextractf32x8 $0x7b, %zmm21,-4128(%rdx)

// CHECK: vextractf32x8 $171, %zmm26, %ymm30
// CHECK:  encoding: [0x62,0x03,0x7d,0x48,0x1b,0xd6,0xab]
          vextractf32x8 $0xab, %zmm26, %ymm30

// CHECK: vextractf32x8 $171, %zmm26, %ymm30 {%k3}
// CHECK:  encoding: [0x62,0x03,0x7d,0x4b,0x1b,0xd6,0xab]
          vextractf32x8 $0xab, %zmm26, %ymm30 {%k3}

// CHECK: vextractf32x8 $171, %zmm26, %ymm30 {%k3} {z}
// CHECK:  encoding: [0x62,0x03,0x7d,0xcb,0x1b,0xd6,0xab]
          vextractf32x8 $0xab, %zmm26, %ymm30 {%k3} {z}

// CHECK: vextractf32x8 $123, %zmm26, %ymm30
// CHECK:  encoding: [0x62,0x03,0x7d,0x48,0x1b,0xd6,0x7b]
          vextractf32x8 $0x7b, %zmm26, %ymm30

// CHECK: vextractf32x8 $171, %zmm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0x21,0xab]
          vextractf32x8 $0xab, %zmm20,(%rcx)

// CHECK: vextractf32x8 $171, %zmm20, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0xe3,0x7d,0x4b,0x1b,0x21,0xab]
          vextractf32x8 $0xab, %zmm20,(%rcx) {%k3}

// CHECK: vextractf32x8 $123, %zmm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0x21,0x7b]
          vextractf32x8 $0x7b, %zmm20,(%rcx)

// CHECK: vextractf32x8 $123, %zmm20, 4660(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x1b,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vextractf32x8 $0x7b, %zmm20,4660(%rax,%r14,8)

// CHECK: vextractf32x8 $123, %zmm20, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0x62,0x7f,0x7b]
          vextractf32x8 $0x7b, %zmm20,4064(%rdx)

// CHECK: vextractf32x8 $123, %zmm20, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vextractf32x8 $0x7b, %zmm20,4096(%rdx)

// CHECK: vextractf32x8 $123, %zmm20, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0x62,0x80,0x7b]
          vextractf32x8 $0x7b, %zmm20,-4096(%rdx)

// CHECK: vextractf32x8 $123, %zmm20, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x1b,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vextractf32x8 $0x7b, %zmm20,-4128(%rdx)

// CHECK: vextractf64x2 $171, %zmm26, %xmm28
// CHECK:  encoding: [0x62,0x03,0xfd,0x48,0x19,0xd4,0xab]
          vextractf64x2 $0xab, %zmm26, %xmm28

// CHECK: vextractf64x2 $171, %zmm26, %xmm28 {%k5}
// CHECK:  encoding: [0x62,0x03,0xfd,0x4d,0x19,0xd4,0xab]
          vextractf64x2 $0xab, %zmm26, %xmm28 {%k5}

// CHECK: vextractf64x2 $171, %zmm26, %xmm28 {%k5} {z}
// CHECK:  encoding: [0x62,0x03,0xfd,0xcd,0x19,0xd4,0xab]
          vextractf64x2 $0xab, %zmm26, %xmm28 {%k5} {z}

// CHECK: vextractf64x2 $123, %zmm26, %xmm28
// CHECK:  encoding: [0x62,0x03,0xfd,0x48,0x19,0xd4,0x7b]
          vextractf64x2 $0x7b, %zmm26, %xmm28

// CHECK: vextractf64x2 $171, %zmm28, (%rcx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x19,0x21,0xab]
          vextractf64x2 $0xab, %zmm28,(%rcx)

// CHECK: vextractf64x2 $171, %zmm28, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0x63,0xfd,0x4b,0x19,0x21,0xab]
          vextractf64x2 $0xab, %zmm28,(%rcx) {%k3}

// CHECK: vextractf64x2 $123, %zmm28, (%rcx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x19,0x21,0x7b]
          vextractf64x2 $0x7b, %zmm28,(%rcx)

// CHECK: vextractf64x2 $123, %zmm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x23,0xfd,0x48,0x19,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextractf64x2 $0x7b, %zmm28,291(%rax,%r14,8)

// CHECK: vextractf64x2 $123, %zmm28, 2032(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x19,0x62,0x7f,0x7b]
          vextractf64x2 $0x7b, %zmm28,2032(%rdx)

// CHECK: vextractf64x2 $123, %zmm28, 2048(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x19,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vextractf64x2 $0x7b, %zmm28,2048(%rdx)

// CHECK: vextractf64x2 $123, %zmm28, -2048(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x19,0x62,0x80,0x7b]
          vextractf64x2 $0x7b, %zmm28,-2048(%rdx)

// CHECK: vextractf64x2 $123, %zmm28, -2064(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x19,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vextractf64x2 $0x7b, %zmm28,-2064(%rdx)

// CHECK: vextractf64x2 $171, %zmm26, %xmm19
// CHECK:  encoding: [0x62,0x23,0xfd,0x48,0x19,0xd3,0xab]
          vextractf64x2 $0xab, %zmm26, %xmm19

// CHECK: vextractf64x2 $171, %zmm26, %xmm19 {%k3}
// CHECK:  encoding: [0x62,0x23,0xfd,0x4b,0x19,0xd3,0xab]
          vextractf64x2 $0xab, %zmm26, %xmm19 {%k3}

// CHECK: vextractf64x2 $171, %zmm26, %xmm19 {%k3} {z}
// CHECK:  encoding: [0x62,0x23,0xfd,0xcb,0x19,0xd3,0xab]
          vextractf64x2 $0xab, %zmm26, %xmm19 {%k3} {z}

// CHECK: vextractf64x2 $123, %zmm26, %xmm19
// CHECK:  encoding: [0x62,0x23,0xfd,0x48,0x19,0xd3,0x7b]
          vextractf64x2 $0x7b, %zmm26, %xmm19

// CHECK: vextractf64x2 $171, %zmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x19,0x09,0xab]
          vextractf64x2 $0xab, %zmm17,(%rcx)

// CHECK: vextractf64x2 $171, %zmm17, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0xe3,0xfd,0x49,0x19,0x09,0xab]
          vextractf64x2 $0xab, %zmm17,(%rcx) {%k1}

// CHECK: vextractf64x2 $123, %zmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x19,0x09,0x7b]
          vextractf64x2 $0x7b, %zmm17,(%rcx)

// CHECK: vextractf64x2 $123, %zmm17, 4660(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x19,0x8c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vextractf64x2 $0x7b, %zmm17,4660(%rax,%r14,8)

// CHECK: vextractf64x2 $123, %zmm17, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x19,0x4a,0x7f,0x7b]
          vextractf64x2 $0x7b, %zmm17,2032(%rdx)

// CHECK: vextractf64x2 $123, %zmm17, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x19,0x8a,0x00,0x08,0x00,0x00,0x7b]
          vextractf64x2 $0x7b, %zmm17,2048(%rdx)

// CHECK: vextractf64x2 $123, %zmm17, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x19,0x4a,0x80,0x7b]
          vextractf64x2 $0x7b, %zmm17,-2048(%rdx)

// CHECK: vextractf64x2 $123, %zmm17, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x19,0x8a,0xf0,0xf7,0xff,0xff,0x7b]
          vextractf64x2 $0x7b, %zmm17,-2064(%rdx)

// CHECK: vextracti32x8 $171, %zmm24, %ymm20
// CHECK:  encoding: [0x62,0x23,0x7d,0x48,0x3b,0xc4,0xab]
          vextracti32x8 $0xab, %zmm24, %ymm20

// CHECK: vextracti32x8 $171, %zmm24, %ymm20 {%k1}
// CHECK:  encoding: [0x62,0x23,0x7d,0x49,0x3b,0xc4,0xab]
          vextracti32x8 $0xab, %zmm24, %ymm20 {%k1}

// CHECK: vextracti32x8 $171, %zmm24, %ymm20 {%k1} {z}
// CHECK:  encoding: [0x62,0x23,0x7d,0xc9,0x3b,0xc4,0xab]
          vextracti32x8 $0xab, %zmm24, %ymm20 {%k1} {z}

// CHECK: vextracti32x8 $123, %zmm24, %ymm20
// CHECK:  encoding: [0x62,0x23,0x7d,0x48,0x3b,0xc4,0x7b]
          vextracti32x8 $0x7b, %zmm24, %ymm20

// CHECK: vextracti32x8 $171, %zmm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x3b,0x21,0xab]
          vextracti32x8 $0xab, %zmm20,(%rcx)

// CHECK: vextracti32x8 $171, %zmm20, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0xe3,0x7d,0x4b,0x3b,0x21,0xab]
          vextracti32x8 $0xab, %zmm20,(%rcx) {%k3}

// CHECK: vextracti32x8 $123, %zmm20, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x3b,0x21,0x7b]
          vextracti32x8 $0x7b, %zmm20,(%rcx)

// CHECK: vextracti32x8 $123, %zmm20, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0x7d,0x48,0x3b,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextracti32x8 $0x7b, %zmm20,291(%rax,%r14,8)

// CHECK: vextracti32x8 $123, %zmm20, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x3b,0x62,0x7f,0x7b]
          vextracti32x8 $0x7b, %zmm20,4064(%rdx)

// CHECK: vextracti32x8 $123, %zmm20, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x3b,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vextracti32x8 $0x7b, %zmm20,4096(%rdx)

// CHECK: vextracti32x8 $123, %zmm20, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x3b,0x62,0x80,0x7b]
          vextracti32x8 $0x7b, %zmm20,-4096(%rdx)

// CHECK: vextracti32x8 $123, %zmm20, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe3,0x7d,0x48,0x3b,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vextracti32x8 $0x7b, %zmm20,-4128(%rdx)

// CHECK: vextracti32x8 $171, %zmm29, %ymm27
// CHECK:  encoding: [0x62,0x03,0x7d,0x48,0x3b,0xeb,0xab]
          vextracti32x8 $0xab, %zmm29, %ymm27

// CHECK: vextracti32x8 $171, %zmm29, %ymm27 {%k2}
// CHECK:  encoding: [0x62,0x03,0x7d,0x4a,0x3b,0xeb,0xab]
          vextracti32x8 $0xab, %zmm29, %ymm27 {%k2}

// CHECK: vextracti32x8 $171, %zmm29, %ymm27 {%k2} {z}
// CHECK:  encoding: [0x62,0x03,0x7d,0xca,0x3b,0xeb,0xab]
          vextracti32x8 $0xab, %zmm29, %ymm27 {%k2} {z}

// CHECK: vextracti32x8 $123, %zmm29, %ymm27
// CHECK:  encoding: [0x62,0x03,0x7d,0x48,0x3b,0xeb,0x7b]
          vextracti32x8 $0x7b, %zmm29, %ymm27

// CHECK: vextracti32x8 $171, %zmm26, (%rcx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x3b,0x11,0xab]
          vextracti32x8 $0xab, %zmm26,(%rcx)

// CHECK: vextracti32x8 $171, %zmm26, (%rcx) {%k2}
// CHECK:  encoding: [0x62,0x63,0x7d,0x4a,0x3b,0x11,0xab]
          vextracti32x8 $0xab, %zmm26,(%rcx) {%k2}

// CHECK: vextracti32x8 $123, %zmm26, (%rcx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x3b,0x11,0x7b]
          vextracti32x8 $0x7b, %zmm26,(%rcx)

// CHECK: vextracti32x8 $123, %zmm26, 4660(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x23,0x7d,0x48,0x3b,0x94,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vextracti32x8 $0x7b, %zmm26,4660(%rax,%r14,8)

// CHECK: vextracti32x8 $123, %zmm26, 4064(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x3b,0x52,0x7f,0x7b]
          vextracti32x8 $0x7b, %zmm26,4064(%rdx)

// CHECK: vextracti32x8 $123, %zmm26, 4096(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x3b,0x92,0x00,0x10,0x00,0x00,0x7b]
          vextracti32x8 $0x7b, %zmm26,4096(%rdx)

// CHECK: vextracti32x8 $123, %zmm26, -4096(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x3b,0x52,0x80,0x7b]
          vextracti32x8 $0x7b, %zmm26,-4096(%rdx)

// CHECK: vextracti32x8 $123, %zmm26, -4128(%rdx)
// CHECK:  encoding: [0x62,0x63,0x7d,0x48,0x3b,0x92,0xe0,0xef,0xff,0xff,0x7b]
          vextracti32x8 $0x7b, %zmm26,-4128(%rdx)

// CHECK: vextracti64x2 $171, %zmm20, %xmm17
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x39,0xe1,0xab]
          vextracti64x2 $0xab, %zmm20, %xmm17

// CHECK: vextracti64x2 $171, %zmm20, %xmm17 {%k2}
// CHECK:  encoding: [0x62,0xa3,0xfd,0x4a,0x39,0xe1,0xab]
          vextracti64x2 $0xab, %zmm20, %xmm17 {%k2}

// CHECK: vextracti64x2 $171, %zmm20, %xmm17 {%k2} {z}
// CHECK:  encoding: [0x62,0xa3,0xfd,0xca,0x39,0xe1,0xab]
          vextracti64x2 $0xab, %zmm20, %xmm17 {%k2} {z}

// CHECK: vextracti64x2 $123, %zmm20, %xmm17
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x39,0xe1,0x7b]
          vextracti64x2 $0x7b, %zmm20, %xmm17

// CHECK: vextracti64x2 $171, %zmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x39,0x09,0xab]
          vextracti64x2 $0xab, %zmm17,(%rcx)

// CHECK: vextracti64x2 $171, %zmm17, (%rcx) {%k5}
// CHECK:  encoding: [0x62,0xe3,0xfd,0x4d,0x39,0x09,0xab]
          vextracti64x2 $0xab, %zmm17,(%rcx) {%k5}

// CHECK: vextracti64x2 $123, %zmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x39,0x09,0x7b]
          vextracti64x2 $0x7b, %zmm17,(%rcx)

// CHECK: vextracti64x2 $123, %zmm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa3,0xfd,0x48,0x39,0x8c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vextracti64x2 $0x7b, %zmm17,291(%rax,%r14,8)

// CHECK: vextracti64x2 $123, %zmm17, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x39,0x4a,0x7f,0x7b]
          vextracti64x2 $0x7b, %zmm17,2032(%rdx)

// CHECK: vextracti64x2 $123, %zmm17, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x39,0x8a,0x00,0x08,0x00,0x00,0x7b]
          vextracti64x2 $0x7b, %zmm17,2048(%rdx)

// CHECK: vextracti64x2 $123, %zmm17, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x39,0x4a,0x80,0x7b]
          vextracti64x2 $0x7b, %zmm17,-2048(%rdx)

// CHECK: vextracti64x2 $123, %zmm17, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe3,0xfd,0x48,0x39,0x8a,0xf0,0xf7,0xff,0xff,0x7b]
          vextracti64x2 $0x7b, %zmm17,-2064(%rdx)

// CHECK: vextracti64x2 $171, %zmm23, %xmm27
// CHECK:  encoding: [0x62,0x83,0xfd,0x48,0x39,0xfb,0xab]
          vextracti64x2 $0xab, %zmm23, %xmm27

// CHECK: vextracti64x2 $171, %zmm23, %xmm27 {%k5}
// CHECK:  encoding: [0x62,0x83,0xfd,0x4d,0x39,0xfb,0xab]
          vextracti64x2 $0xab, %zmm23, %xmm27 {%k5}

// CHECK: vextracti64x2 $171, %zmm23, %xmm27 {%k5} {z}
// CHECK:  encoding: [0x62,0x83,0xfd,0xcd,0x39,0xfb,0xab]
          vextracti64x2 $0xab, %zmm23, %xmm27 {%k5} {z}

// CHECK: vextracti64x2 $123, %zmm23, %xmm27
// CHECK:  encoding: [0x62,0x83,0xfd,0x48,0x39,0xfb,0x7b]
          vextracti64x2 $0x7b, %zmm23, %xmm27

// CHECK: vextracti64x2 $171, %zmm24, (%rcx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x39,0x01,0xab]
          vextracti64x2 $0xab, %zmm24,(%rcx)

// CHECK: vextracti64x2 $171, %zmm24, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0x63,0xfd,0x4b,0x39,0x01,0xab]
          vextracti64x2 $0xab, %zmm24,(%rcx) {%k3}

// CHECK: vextracti64x2 $123, %zmm24, (%rcx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x39,0x01,0x7b]
          vextracti64x2 $0x7b, %zmm24,(%rcx)

// CHECK: vextracti64x2 $123, %zmm24, 4660(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x23,0xfd,0x48,0x39,0x84,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vextracti64x2 $0x7b, %zmm24,4660(%rax,%r14,8)

// CHECK: vextracti64x2 $123, %zmm24, 2032(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x39,0x42,0x7f,0x7b]
          vextracti64x2 $0x7b, %zmm24,2032(%rdx)

// CHECK: vextracti64x2 $123, %zmm24, 2048(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x39,0x82,0x00,0x08,0x00,0x00,0x7b]
          vextracti64x2 $0x7b, %zmm24,2048(%rdx)

// CHECK: vextracti64x2 $123, %zmm24, -2048(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x39,0x42,0x80,0x7b]
          vextracti64x2 $0x7b, %zmm24,-2048(%rdx)

// CHECK: vextracti64x2 $123, %zmm24, -2064(%rdx)
// CHECK:  encoding: [0x62,0x63,0xfd,0x48,0x39,0x82,0xf0,0xf7,0xff,0xff,0x7b]
          vextracti64x2 $0x7b, %zmm24,-2064(%rdx)

// CHECK: ktestb %k6, %k4
// CHECK:  encoding: [0xc5,0xf9,0x99,0xe6]
          ktestb %k6, %k4

// CHECK: ktestb %k4, %k5
// CHECK:  encoding: [0xc5,0xf9,0x99,0xec]
          ktestb %k4, %k5

// CHECK: ktestw %k4, %k5
// CHECK:  encoding: [0xc5,0xf8,0x99,0xec]
          ktestw %k4, %k5

// CHECK: ktestw %k6, %k2
// CHECK:  encoding: [0xc5,0xf8,0x99,0xd6]
          ktestw %k6, %k2

// CHECK: kortestb %k3, %k2
// CHECK:  encoding: [0xc5,0xf9,0x98,0xd3]
          kortestb %k3, %k2

// CHECK: kortestb %k6, %k2
// CHECK:  encoding: [0xc5,0xf9,0x98,0xd6]
          kortestb %k6, %k2

// CHECK: kaddb  %k7, %k4, %k5
// CHECK:  encoding: [0xc5,0xdd,0x4a,0xef]
          kaddb  %k7, %k4, %k5

// CHECK: kaddb  %k4, %k6, %k5
// CHECK:  encoding: [0xc5,0xcd,0x4a,0xec]
          kaddb  %k4, %k6, %k5

// CHECK: kaddw  %k4, %k3, %k2
// CHECK:  encoding: [0xc5,0xe4,0x4a,0xd4]
          kaddw  %k4, %k3, %k2

// CHECK: kaddw  %k6, %k6, %k2
// CHECK:  encoding: [0xc5,0xcc,0x4a,0xd6]
          kaddw  %k6, %k6, %k2

// CHECK: vfpclasspd $171, %zmm17, %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x66,0xd1,0xab]
          vfpclasspd $0xab, %zmm17, %k2

// CHECK: vfpclasspd $171, %zmm17, %k2 {%k1}
// CHECK:  encoding: [0x62,0xb3,0xfd,0x49,0x66,0xd1,0xab]
          vfpclasspd $0xab, %zmm17, %k2 {%k1}

// CHECK: vfpclasspd $123,  %zmm17, %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x66,0xd1,0x7b]
          vfpclasspd $0x7b, %zmm17, %k2

// CHECK: vfpclasspdz $123, (%rcx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x11,0x7b]
          vfpclasspdz $0x7b,(%rcx), %k2

// CHECK: vfpclasspdz $123, 291(%rax,%r14,8), %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x66,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfpclasspdz $0x7b,291(%rax,%r14,8), %k2

// CHECK: vfpclasspdq $123, (%rcx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x11,0x7b]
          vfpclasspdq $0x7b,(%rcx){1to8}, %k2

// CHECK: vfpclasspdz $123, 8128(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x52,0x7f,0x7b]
          vfpclasspdz $0x7b,8128(%rdx), %k2

// CHECK: vfpclasspdz $123, 8192(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x92,0x00,0x20,0x00,0x00,0x7b]
          vfpclasspdz $0x7b,8192(%rdx), %k2

// CHECK: vfpclasspdz $123, -8192(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x52,0x80,0x7b]
          vfpclasspdz $0x7b,-8192(%rdx), %k2

// CHECK: vfpclasspdz $123, -8256(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vfpclasspdz $0x7b,-8256(%rdx), %k2

// CHECK: vfpclasspdq $123, 1016(%rdx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x52,0x7f,0x7b]
          vfpclasspdq $0x7b,1016(%rdx){1to8}, %k2

// CHECK: vfpclasspdq $123, 1024(%rdx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x92,0x00,0x04,0x00,0x00,0x7b]
          vfpclasspdq $0x7b,1024(%rdx){1to8}, %k2

// CHECK: vfpclasspdq $123, -1024(%rdx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x52,0x80,0x7b]
          vfpclasspdq $0x7b,-1024(%rdx){1to8}, %k2

// CHECK: vfpclasspdq $123, -1032(%rdx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vfpclasspdq $0x7b,-1032(%rdx){1to8}, %k2

// CHECK: vfpclassps $171, %zmm21, %k2
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x66,0xd5,0xab]
          vfpclassps $0xab, %zmm21, %k2

// CHECK: vfpclassps $171, %zmm21, %k2 {%k2}
// CHECK:  encoding: [0x62,0xb3,0x7d,0x4a,0x66,0xd5,0xab]
          vfpclassps $0xab, %zmm21, %k2 {%k2}

// CHECK: vfpclassps $123,  %zmm21, %k2
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x66,0xd5,0x7b]
          vfpclassps $0x7b, %zmm21, %k2

// CHECK: vfpclasspsz $123, (%rcx), %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0x11,0x7b]
          vfpclasspsz $0x7b,(%rcx), %k2

// CHECK: vfpclasspsz $123, 291(%rax,%r14,8), %k2
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x66,0x94,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfpclasspsz $0x7b,291(%rax,%r14,8), %k2

// CHECK: vfpclasspsl $123, (%rcx){1to16}, %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0x11,0x7b]
          vfpclasspsl $0x7b,(%rcx){1to16}, %k2

// CHECK: vfpclasspsz $123, 8128(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0x52,0x7f,0x7b]
          vfpclasspsz $0x7b,8128(%rdx), %k2

// CHECK: vfpclasspsz $123, 8192(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0x92,0x00,0x20,0x00,0x00,0x7b]
          vfpclasspsz $0x7b,8192(%rdx), %k2

// CHECK: vfpclasspsz $123, -8192(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0x52,0x80,0x7b]
          vfpclasspsz $0x7b,-8192(%rdx), %k2

// CHECK: vfpclasspsz $123, -8256(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vfpclasspsz $0x7b,-8256(%rdx), %k2

// CHECK: vfpclasspsl $123, 508(%rdx){1to16}, %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0x52,0x7f,0x7b]
          vfpclasspsl $0x7b,508(%rdx){1to16}, %k2

// CHECK: vfpclasspsl $123, 512(%rdx){1to16}, %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0x92,0x00,0x02,0x00,0x00,0x7b]
          vfpclasspsl $0x7b,512(%rdx){1to16}, %k2

// CHECK: vfpclasspsl $123, -512(%rdx){1to16}, %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0x52,0x80,0x7b]
          vfpclasspsl $0x7b,-512(%rdx){1to16}, %k2

// CHECK: vfpclasspsl $123, -516(%rdx){1to16}, %k2
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0x92,0xfc,0xfd,0xff,0xff,0x7b]
          vfpclasspsl $0x7b,-516(%rdx){1to16}, %k2

// CHECK: vfpclasspd $171, %zmm19, %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x66,0xd3,0xab]
          vfpclasspd $0xab, %zmm19, %k2

// CHECK: vfpclasspd $171, %zmm19, %k2 {%k6}
// CHECK:  encoding: [0x62,0xb3,0xfd,0x4e,0x66,0xd3,0xab]
          vfpclasspd $0xab, %zmm19, %k2 {%k6}

// CHECK: vfpclasspd $123,  %zmm19, %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x66,0xd3,0x7b]
          vfpclasspd $0x7b, %zmm19, %k2

// CHECK: vfpclasspdz $123, (%rcx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x11,0x7b]
          vfpclasspdz $0x7b,(%rcx), %k2

// CHECK: vfpclasspdz $123, 4660(%rax,%r14,8), %k2
// CHECK:  encoding: [0x62,0xb3,0xfd,0x48,0x66,0x94,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vfpclasspdz $0x7b,4660(%rax,%r14,8), %k2

// CHECK: vfpclasspdq $123, (%rcx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x11,0x7b]
          vfpclasspdq $0x7b,(%rcx){1to8}, %k2

// CHECK: vfpclasspdz $123, 8128(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x52,0x7f,0x7b]
          vfpclasspdz $0x7b,8128(%rdx), %k2

// CHECK: vfpclasspdz $123, 8192(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x92,0x00,0x20,0x00,0x00,0x7b]
          vfpclasspdz $0x7b,8192(%rdx), %k2

// CHECK: vfpclasspdz $123, -8192(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x52,0x80,0x7b]
          vfpclasspdz $0x7b,-8192(%rdx), %k2

// CHECK: vfpclasspdz $123, -8256(%rdx), %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x48,0x66,0x92,0xc0,0xdf,0xff,0xff,0x7b]
          vfpclasspdz $0x7b,-8256(%rdx), %k2

// CHECK: vfpclasspdq $123, 1016(%rdx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x52,0x7f,0x7b]
          vfpclasspdq $0x7b,1016(%rdx){1to8}, %k2

// CHECK: vfpclasspdq $123, 1024(%rdx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x92,0x00,0x04,0x00,0x00,0x7b]
          vfpclasspdq $0x7b,1024(%rdx){1to8}, %k2

// CHECK: vfpclasspdq $123, -1024(%rdx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x52,0x80,0x7b]
          vfpclasspdq $0x7b,-1024(%rdx){1to8}, %k2

// CHECK: vfpclasspdq $123, -1032(%rdx){1to8}, %k2
// CHECK:  encoding: [0x62,0xf3,0xfd,0x58,0x66,0x92,0xf8,0xfb,0xff,0xff,0x7b]
          vfpclasspdq $0x7b,-1032(%rdx){1to8}, %k2

// CHECK: vfpclassps $171, %zmm17, %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x66,0xe1,0xab]
          vfpclassps $0xab, %zmm17, %k4

// CHECK: vfpclassps $171, %zmm17, %k4 {%k2}
// CHECK:  encoding: [0x62,0xb3,0x7d,0x4a,0x66,0xe1,0xab]
          vfpclassps $0xab, %zmm17, %k4 {%k2}

// CHECK: vfpclassps $123,  %zmm17, %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x66,0xe1,0x7b]
          vfpclassps $0x7b, %zmm17, %k4

// CHECK: vfpclasspsz $123, (%rcx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0x21,0x7b]
          vfpclasspsz $0x7b,(%rcx), %k4

// CHECK: vfpclasspsz $123, 4660(%rax,%r14,8), %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x48,0x66,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vfpclasspsz $0x7b,4660(%rax,%r14,8), %k4

// CHECK: vfpclasspsl $123, (%rcx){1to16}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0x21,0x7b]
          vfpclasspsl $0x7b,(%rcx){1to16}, %k4

// CHECK: vfpclasspsz $123, 8128(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0x62,0x7f,0x7b]
          vfpclasspsz $0x7b,8128(%rdx), %k4

// CHECK: vfpclasspsz $123, 8192(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0xa2,0x00,0x20,0x00,0x00,0x7b]
          vfpclasspsz $0x7b,8192(%rdx), %k4

// CHECK: vfpclasspsz $123, -8192(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0x62,0x80,0x7b]
          vfpclasspsz $0x7b,-8192(%rdx), %k4

// CHECK: vfpclasspsz $123, -8256(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x48,0x66,0xa2,0xc0,0xdf,0xff,0xff,0x7b]
          vfpclasspsz $0x7b,-8256(%rdx), %k4

// CHECK: vfpclasspsl $123, 508(%rdx){1to16}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0x62,0x7f,0x7b]
          vfpclasspsl $0x7b,508(%rdx){1to16}, %k4

// CHECK: vfpclasspsl $123, 512(%rdx){1to16}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vfpclasspsl $0x7b,512(%rdx){1to16}, %k4

// CHECK: vfpclasspsl $123, -512(%rdx){1to16}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0x62,0x80,0x7b]
          vfpclasspsl $0x7b,-512(%rdx){1to16}, %k4

// CHECK: vfpclasspsl $123, -516(%rdx){1to16}, %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x58,0x66,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vfpclasspsl $0x7b,-516(%rdx){1to16}, %k4


// CHECK: vcvtuqq2ps {rn-sae}, %zmm21, %ymm18
// CHECK:  encoding: [0x62,0xa1,0xff,0x18,0x7a,0xd5]
          vcvtuqq2ps {rn-sae}, %zmm21, %ymm18

// CHECK: vcvtuqq2ps {ru-sae}, %zmm21, %ymm18
// CHECK:  encoding: [0x62,0xa1,0xff,0x58,0x7a,0xd5]
          vcvtuqq2ps {ru-sae}, %zmm21, %ymm18

// CHECK: vcvtuqq2ps {rd-sae}, %zmm21, %ymm18
// CHECK:  encoding: [0x62,0xa1,0xff,0x38,0x7a,0xd5]
          vcvtuqq2ps {rd-sae}, %zmm21, %ymm18

// CHECK: vcvtuqq2ps {rz-sae}, %zmm21, %ymm18
// CHECK:  encoding: [0x62,0xa1,0xff,0x78,0x7a,0xd5]
          vcvtuqq2ps {rz-sae}, %zmm21, %ymm18

// CHECK: vcvtuqq2ps (%rcx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x7a,0x11]
          vcvtuqq2ps (%rcx), %ymm18

// CHECK: vcvtuqq2ps 291(%rax,%r14,8), %ymm18
// CHECK:  encoding: [0x62,0xa1,0xff,0x48,0x7a,0x94,0xf0,0x23,0x01,0x00,0x00]
          vcvtuqq2ps 291(%rax,%r14,8), %ymm18

// CHECK: vcvtuqq2ps (%rcx){1to8}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x58,0x7a,0x11]
          vcvtuqq2ps (%rcx){1to8}, %ymm18

// CHECK: vcvtuqq2ps 8128(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x7a,0x52,0x7f]
          vcvtuqq2ps 8128(%rdx), %ymm18

// CHECK: vcvtuqq2ps 8192(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x7a,0x92,0x00,0x20,0x00,0x00]
          vcvtuqq2ps 8192(%rdx), %ymm18

// CHECK: vcvtuqq2ps -8192(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x7a,0x52,0x80]
          vcvtuqq2ps -8192(%rdx), %ymm18

// CHECK: vcvtuqq2ps -8256(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x48,0x7a,0x92,0xc0,0xdf,0xff,0xff]
          vcvtuqq2ps -8256(%rdx), %ymm18

// CHECK: vcvtuqq2ps 1016(%rdx){1to8}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x58,0x7a,0x52,0x7f]
          vcvtuqq2ps 1016(%rdx){1to8}, %ymm18

// CHECK: vcvtuqq2ps 1024(%rdx){1to8}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x58,0x7a,0x92,0x00,0x04,0x00,0x00]
          vcvtuqq2ps 1024(%rdx){1to8}, %ymm18

// CHECK: vcvtuqq2ps -1024(%rdx){1to8}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x58,0x7a,0x52,0x80]
          vcvtuqq2ps -1024(%rdx){1to8}, %ymm18

// CHECK: vcvtuqq2ps -1032(%rdx){1to8}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xff,0x58,0x7a,0x92,0xf8,0xfb,0xff,0xff]
          vcvtuqq2ps -1032(%rdx){1to8}, %ymm18

// CHECK: vcvtuqq2ps %zmm26, %ymm25
// CHECK:  encoding: [0x62,0x01,0xff,0x48,0x7a,0xca]
          vcvtuqq2ps %zmm26, %ymm25

// CHECK: vcvtuqq2ps %zmm26, %ymm25 {%k2}
// CHECK:  encoding: [0x62,0x01,0xff,0x4a,0x7a,0xca]
          vcvtuqq2ps %zmm26, %ymm25 {%k2}

// CHECK: vcvtuqq2ps %zmm26, %ymm25 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0xff,0xca,0x7a,0xca]
          vcvtuqq2ps %zmm26, %ymm25 {%k2} {z}

// CHECK: vcvtuqq2ps {rn-sae}, %zmm26, %ymm25
// CHECK:  encoding: [0x62,0x01,0xff,0x18,0x7a,0xca]
          vcvtuqq2ps {rn-sae}, %zmm26, %ymm25

// CHECK: vcvtuqq2ps {ru-sae}, %zmm26, %ymm25
// CHECK:  encoding: [0x62,0x01,0xff,0x58,0x7a,0xca]
          vcvtuqq2ps {ru-sae}, %zmm26, %ymm25

// CHECK: vcvtuqq2ps {rd-sae}, %zmm26, %ymm25
// CHECK:  encoding: [0x62,0x01,0xff,0x38,0x7a,0xca]
          vcvtuqq2ps {rd-sae}, %zmm26, %ymm25

// CHECK: vcvtuqq2ps {rz-sae}, %zmm26, %ymm25
// CHECK:  encoding: [0x62,0x01,0xff,0x78,0x7a,0xca]
          vcvtuqq2ps {rz-sae}, %zmm26, %ymm25

// CHECK: vcvtuqq2ps (%rcx), %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7a,0x09]
          vcvtuqq2ps (%rcx), %ymm25

// CHECK: vcvtuqq2ps 4660(%rax,%r14,8), %ymm25
// CHECK:  encoding: [0x62,0x21,0xff,0x48,0x7a,0x8c,0xf0,0x34,0x12,0x00,0x00]
          vcvtuqq2ps 4660(%rax,%r14,8), %ymm25

// CHECK: vcvtuqq2ps (%rcx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0x7a,0x09]
          vcvtuqq2ps (%rcx){1to8}, %ymm25

// CHECK: vcvtuqq2ps 8128(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7a,0x4a,0x7f]
          vcvtuqq2ps 8128(%rdx), %ymm25

// CHECK: vcvtuqq2ps 8192(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7a,0x8a,0x00,0x20,0x00,0x00]
          vcvtuqq2ps 8192(%rdx), %ymm25

// CHECK: vcvtuqq2ps -8192(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7a,0x4a,0x80]
          vcvtuqq2ps -8192(%rdx), %ymm25

// CHECK: vcvtuqq2ps -8256(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x48,0x7a,0x8a,0xc0,0xdf,0xff,0xff]
          vcvtuqq2ps -8256(%rdx), %ymm25

// CHECK: vcvtuqq2ps 1016(%rdx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0x7a,0x4a,0x7f]
          vcvtuqq2ps 1016(%rdx){1to8}, %ymm25

// CHECK: vcvtuqq2ps 1024(%rdx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0x7a,0x8a,0x00,0x04,0x00,0x00]
          vcvtuqq2ps 1024(%rdx){1to8}, %ymm25

// CHECK: vcvtuqq2ps -1024(%rdx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0x7a,0x4a,0x80]
          vcvtuqq2ps -1024(%rdx){1to8}, %ymm25

// CHECK: vcvtuqq2ps -1032(%rdx){1to8}, %ymm25
// CHECK:  encoding: [0x62,0x61,0xff,0x58,0x7a,0x8a,0xf8,0xfb,0xff,0xff]
          vcvtuqq2ps -1032(%rdx){1to8}, %ymm25

// CHECK: vfpclasssd $171, %xmm28, %k4
// CHECK:  encoding: [0x62,0x93,0xfd,0x08,0x67,0xe4,0xab]
          vfpclasssd $0xab, %xmm28, %k4

// CHECK: vfpclasssd $171, %xmm28, %k4 {%k3}
// CHECK:  encoding: [0x62,0x93,0xfd,0x0b,0x67,0xe4,0xab]
          vfpclasssd $0xab, %xmm28, %k4 {%k3}

// CHECK: vfpclasssd $123,  %xmm28, %k4
// CHECK:  encoding: [0x62,0x93,0xfd,0x08,0x67,0xe4,0x7b]
          vfpclasssd $0x7b, %xmm28, %k4

// CHECK: vfpclasssd $123, (%rcx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0x21,0x7b]
          vfpclasssd $0x7b,(%rcx), %k4

// CHECK: vfpclasssd $123, 291(%rax,%r14,8), %k4
// CHECK:  encoding: [0x62,0xb3,0xfd,0x08,0x67,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfpclasssd $0x7b,291(%rax,%r14,8), %k4

// CHECK: vfpclasssd $123, 1016(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0x62,0x7f,0x7b]
          vfpclasssd $0x7b,1016(%rdx), %k4

// CHECK: vfpclasssd $123, 1024(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0xa2,0x00,0x04,0x00,0x00,0x7b]
          vfpclasssd $0x7b,1024(%rdx), %k4

// CHECK: vfpclasssd $123, -1024(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0x62,0x80,0x7b]
          vfpclasssd $0x7b,-1024(%rdx), %k4

// CHECK: vfpclasssd $123, -1032(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          vfpclasssd $0x7b,-1032(%rdx), %k4

// CHECK: vfpclassss $171, %xmm26, %k5
// CHECK:  encoding: [0x62,0x93,0x7d,0x08,0x67,0xea,0xab]
          vfpclassss $0xab, %xmm26, %k5

// CHECK: vfpclassss $171, %xmm26, %k5 {%k4}
// CHECK:  encoding: [0x62,0x93,0x7d,0x0c,0x67,0xea,0xab]
          vfpclassss $0xab, %xmm26, %k5 {%k4}

// CHECK: vfpclassss $123,  %xmm26, %k5
// CHECK:  encoding: [0x62,0x93,0x7d,0x08,0x67,0xea,0x7b]
          vfpclassss $0x7b, %xmm26, %k5

// CHECK: vfpclassss $123, (%rcx), %k5
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0x29,0x7b]
          vfpclassss $0x7b,(%rcx), %k5

// CHECK: vfpclassss $123, 291(%rax,%r14,8), %k5
// CHECK:  encoding: [0x62,0xb3,0x7d,0x08,0x67,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vfpclassss $0x7b,291(%rax,%r14,8), %k5

// CHECK: vfpclassss $123, 508(%rdx), %k5
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0x6a,0x7f,0x7b]
          vfpclassss $0x7b,508(%rdx), %k5

// CHECK: vfpclassss $123, 512(%rdx), %k5
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0xaa,0x00,0x02,0x00,0x00,0x7b]
          vfpclassss $0x7b,512(%rdx), %k5

// CHECK: vfpclassss $123, -512(%rdx), %k5
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0x6a,0x80,0x7b]
          vfpclassss $0x7b,-512(%rdx), %k5

// CHECK: vfpclassss $123, -516(%rdx), %k5
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0xaa,0xfc,0xfd,0xff,0xff,0x7b]
          vfpclassss $0x7b,-516(%rdx), %k5

// CHECK: vfpclasssd $171, %xmm20, %k3
// CHECK:  encoding: [0x62,0xb3,0xfd,0x08,0x67,0xdc,0xab]
          vfpclasssd $0xab, %xmm20, %k3

// CHECK: vfpclasssd $171, %xmm20, %k3 {%k6}
// CHECK:  encoding: [0x62,0xb3,0xfd,0x0e,0x67,0xdc,0xab]
          vfpclasssd $0xab, %xmm20, %k3 {%k6}

// CHECK: vfpclasssd $123, %xmm20, %k3
// CHECK:  encoding: [0x62,0xb3,0xfd,0x08,0x67,0xdc,0x7b]
          vfpclasssd $0x7b, %xmm20, %k3

// CHECK: vfpclasssd $123, (%rcx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0x19,0x7b]
          vfpclasssd $0x7b,(%rcx), %k3

// CHECK: vfpclasssd $123, 4660(%rax,%r14,8), %k3
// CHECK:  encoding: [0x62,0xb3,0xfd,0x08,0x67,0x9c,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vfpclasssd $0x7b,4660(%rax,%r14,8), %k3

// CHECK: vfpclasssd $123, 1016(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0x5a,0x7f,0x7b]
          vfpclasssd $0x7b,1016(%rdx), %k3

// CHECK: vfpclasssd $123, 1024(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vfpclasssd $0x7b,1024(%rdx), %k3

// CHECK: vfpclasssd $123, -1024(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0x5a,0x80,0x7b]
          vfpclasssd $0x7b,-1024(%rdx), %k3

// CHECK: vfpclasssd $123, -1032(%rdx), %k3
// CHECK:  encoding: [0x62,0xf3,0xfd,0x08,0x67,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vfpclasssd $0x7b,-1032(%rdx), %k3

// CHECK: vfpclassss $171, %xmm28, %k4
// CHECK:  encoding: [0x62,0x93,0x7d,0x08,0x67,0xe4,0xab]
          vfpclassss $0xab, %xmm28, %k4

// CHECK: vfpclassss $171, %xmm28, %k4 {%k6}
// CHECK:  encoding: [0x62,0x93,0x7d,0x0e,0x67,0xe4,0xab]
          vfpclassss $0xab, %xmm28, %k4 {%k6}

// CHECK: vfpclassss $123,  %xmm28, %k4
// CHECK:  encoding: [0x62,0x93,0x7d,0x08,0x67,0xe4,0x7b]
          vfpclassss $0x7b, %xmm28, %k4

// CHECK: vfpclassss $123, (%rcx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0x21,0x7b]
          vfpclassss $0x7b,(%rcx), %k4

// CHECK: vfpclassss $123, 4660(%rax,%r14,8), %k4
// CHECK:  encoding: [0x62,0xb3,0x7d,0x08,0x67,0xa4,0xf0,0x34,0x12,0x00,0x00,0x7b]
          vfpclassss $0x7b,4660(%rax,%r14,8), %k4

// CHECK: vfpclassss $123, 508(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0x62,0x7f,0x7b]
          vfpclassss $0x7b,508(%rdx), %k4

// CHECK: vfpclassss $123, 512(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vfpclassss $0x7b,512(%rdx), %k4

// CHECK: vfpclassss $123, -512(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0x62,0x80,0x7b]
          vfpclassss $0x7b,-512(%rdx), %k4

// CHECK: vfpclassss $123, -516(%rdx), %k4
// CHECK:  encoding: [0x62,0xf3,0x7d,0x08,0x67,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vfpclassss $0x7b,-516(%rdx), %k4

// CHECK: vbroadcasti32x2 %xmm31, %zmm30
// CHECK:  encoding: [0x62,0x02,0x7d,0x48,0x59,0xf7]
          vbroadcasti32x2 %xmm31, %zmm30

// CHECK: vbroadcasti32x2 %xmm31, %zmm30 {%k5}
// CHECK:  encoding: [0x62,0x02,0x7d,0x4d,0x59,0xf7]
          vbroadcasti32x2 %xmm31, %zmm30 {%k5}

// CHECK: vbroadcasti32x2 %xmm31, %zmm30 {%k5} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0xcd,0x59,0xf7]
          vbroadcasti32x2 %xmm31, %zmm30 {%k5} {z}

// CHECK: vbroadcasti32x2 (%rcx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x59,0x31]
          vbroadcasti32x2 (%rcx), %zmm30

// CHECK: vbroadcasti32x2 291(%rax,%r14,8), %zmm30
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x59,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcasti32x2 291(%rax,%r14,8), %zmm30

// CHECK: vbroadcasti32x2 1016(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x59,0x72,0x7f]
          vbroadcasti32x2 1016(%rdx), %zmm30

// CHECK: vbroadcasti32x2 1024(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x59,0xb2,0x00,0x04,0x00,0x00]
          vbroadcasti32x2 1024(%rdx), %zmm30

// CHECK: vbroadcasti32x2 -1024(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x59,0x72,0x80]
          vbroadcasti32x2 -1024(%rdx), %zmm30

// CHECK: vbroadcasti32x2 -1032(%rdx), %zmm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x59,0xb2,0xf8,0xfb,0xff,0xff]
          vbroadcasti32x2 -1032(%rdx), %zmm30

// CHECK: vbroadcasti32x2 %xmm17, %zmm20
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x59,0xe1]
          vbroadcasti32x2 %xmm17, %zmm20

// CHECK: vbroadcasti32x2 %xmm17, %zmm20 {%k1}
// CHECK:  encoding: [0x62,0xa2,0x7d,0x49,0x59,0xe1]
          vbroadcasti32x2 %xmm17, %zmm20 {%k1}

// CHECK: vbroadcasti32x2 %xmm17, %zmm20 {%k1} {z}
// CHECK:  encoding: [0x62,0xa2,0x7d,0xc9,0x59,0xe1]
          vbroadcasti32x2 %xmm17, %zmm20 {%k1} {z}

// CHECK: vbroadcasti32x2 (%rcx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x59,0x21]
          vbroadcasti32x2 (%rcx), %zmm20

// CHECK: vbroadcasti32x2 4660(%rax,%r14,8), %zmm20
// CHECK:  encoding: [0x62,0xa2,0x7d,0x48,0x59,0xa4,0xf0,0x34,0x12,0x00,0x00]
          vbroadcasti32x2 4660(%rax,%r14,8), %zmm20

// CHECK: vbroadcasti32x2 1016(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x59,0x62,0x7f]
          vbroadcasti32x2 1016(%rdx), %zmm20

// CHECK: vbroadcasti32x2 1024(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x59,0xa2,0x00,0x04,0x00,0x00]
          vbroadcasti32x2 1024(%rdx), %zmm20

// CHECK: vbroadcasti32x2 -1024(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x59,0x62,0x80]
          vbroadcasti32x2 -1024(%rdx), %zmm20

// CHECK: vbroadcasti32x2 -1032(%rdx), %zmm20
// CHECK:  encoding: [0x62,0xe2,0x7d,0x48,0x59,0xa2,0xf8,0xfb,0xff,0xff]
          vbroadcasti32x2 -1032(%rdx), %zmm20

// CHECK: vbroadcastf32x2 %xmm23, %zmm27
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x19,0xdf]
          vbroadcastf32x2 %xmm23, %zmm27

// CHECK: vbroadcastf32x2 %xmm23, %zmm27 {%k6}
// CHECK:  encoding: [0x62,0x22,0x7d,0x4e,0x19,0xdf]
          vbroadcastf32x2 %xmm23, %zmm27 {%k6}

// CHECK: vbroadcastf32x2 %xmm23, %zmm27 {%k6} {z}
// CHECK:  encoding: [0x62,0x22,0x7d,0xce,0x19,0xdf]
          vbroadcastf32x2 %xmm23, %zmm27 {%k6} {z}

// CHECK: vbroadcastf32x2 (%rcx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x19]
          vbroadcastf32x2 (%rcx), %zmm27

// CHECK: vbroadcastf32x2 291(%rax,%r14,8), %zmm27
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x19,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastf32x2 291(%rax,%r14,8), %zmm27

// CHECK: vbroadcastf32x2 1016(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x5a,0x7f]
          vbroadcastf32x2 1016(%rdx), %zmm27

// CHECK: vbroadcastf32x2 1024(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x9a,0x00,0x04,0x00,0x00]
          vbroadcastf32x2 1024(%rdx), %zmm27

// CHECK: vbroadcastf32x2 -1024(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x5a,0x80]
          vbroadcastf32x2 -1024(%rdx), %zmm27

// CHECK: vbroadcastf32x2 -1032(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x9a,0xf8,0xfb,0xff,0xff]
          vbroadcastf32x2 -1032(%rdx), %zmm27

// CHECK: vbroadcastf32x2 %xmm21, %zmm27
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x19,0xdd]
          vbroadcastf32x2 %xmm21, %zmm27

// CHECK: vbroadcastf32x2 %xmm21, %zmm27 {%k5}
// CHECK:  encoding: [0x62,0x22,0x7d,0x4d,0x19,0xdd]
          vbroadcastf32x2 %xmm21, %zmm27 {%k5}

// CHECK: vbroadcastf32x2 %xmm21, %zmm27 {%k5} {z}
// CHECK:  encoding: [0x62,0x22,0x7d,0xcd,0x19,0xdd]
          vbroadcastf32x2 %xmm21, %zmm27 {%k5} {z}

// CHECK: vbroadcastf32x2 (%rcx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x19]
          vbroadcastf32x2 (%rcx), %zmm27

// CHECK: vbroadcastf32x2 4660(%rax,%r14,8), %zmm27
// CHECK:  encoding: [0x62,0x22,0x7d,0x48,0x19,0x9c,0xf0,0x34,0x12,0x00,0x00]
          vbroadcastf32x2 4660(%rax,%r14,8), %zmm27

// CHECK: vbroadcastf32x2 1016(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x5a,0x7f]
          vbroadcastf32x2 1016(%rdx), %zmm27

// CHECK: vbroadcastf32x2 1024(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x9a,0x00,0x04,0x00,0x00]
          vbroadcastf32x2 1024(%rdx), %zmm27

// CHECK: vbroadcastf32x2 -1024(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x5a,0x80]
          vbroadcastf32x2 -1024(%rdx), %zmm27

// CHECK: vbroadcastf32x2 -1032(%rdx), %zmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x48,0x19,0x9a,0xf8,0xfb,0xff,0xff]
          vbroadcastf32x2 -1032(%rdx), %zmm27

