/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;

public final class SSLServerSocketImpl
extends SSLServerSocket {
    public SSLContextImpl a;
    public boolean b = false;
    public boolean c = true;
    public boolean d = true;
    public String[] e = null;
    public boolean f = false;

    public SSLServerSocketImpl(int n2, int n3, SSLContextImpl sSLContextImpl) throws IOException, SSLException {
        super(n2, n3);
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.a = sSLContextImpl;
        this.e = SSLSocketImpl.getDefaultSuites();
    }

    public SSLServerSocketImpl(int n2, int n3, InetAddress inetAddress, SSLContextImpl sSLContextImpl) throws IOException {
        super(n2, n3, inetAddress);
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.a = sSLContextImpl;
        this.e = SSLSocketImpl.getDefaultSuites();
    }

    public Socket accept() throws IOException {
        this.a();
        SSLSocketImpl sSLSocketImpl = this.c ? new SSLSocketImpl(this.a, this.b) : new SSLSocketImpl(this.a);
        sSLSocketImpl.setEnableSessionCreation(this.d);
        sSLSocketImpl.setEnabledCipherSuites(this.e);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.b();
        return sSLSocketImpl;
    }

    private final void a() throws IOException {
        if (this.f) {
            return;
        }
        SSLServerSocketImpl sSLServerSocketImpl = this;
        synchronized (sSLServerSocketImpl) {
            if (!this.f) {
                SSLSocketImpl sSLSocketImpl = this.c ? new SSLSocketImpl(this.a, this.b) : new SSLSocketImpl(this.a);
                sSLSocketImpl.setEnableSessionCreation(this.d);
                sSLSocketImpl.setEnabledCipherSuites(this.e);
                String[] stringArray = this.e;
                Handshaker handshaker = sSLSocketImpl.d();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (handshaker.canUseCipherSuite(stringArray[n2])) {
                        this.f = true;
                        break;
                    }
                    ++n2;
                }
                if (!this.f) {
                    throw new SSLException("No available certificate corresponds to the SSL cipher suites which are enabled.");
                }
            }
        }
    }

    public boolean getEnableSessionCreation() {
        return this.d;
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.e.clone();
    }

    public boolean getNeedClientAuth() {
        return this.b;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSpec.getSupportedCipherSuites();
    }

    public boolean getUseClientMode() {
        return this.c ^ true;
    }

    public void setEnableSessionCreation(boolean bl2) {
        this.d = bl2;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.e = SSLSocketImpl.a(stringArray);
    }

    public void setNeedClientAuth(boolean bl2) {
        this.b = bl2;
    }

    public void setUseClientMode(boolean bl2) {
        this.c = bl2 ^ true;
    }

    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

