/*
 *  ----------------------------------------------------------------------------
 *  This file was automatically generated by SWIG (http://www.swig.org).
 *  Version: 1.3.19
 *
 *  Do not make changes to this file unless you know what you are doing--modify
 *  the SWIG interface file instead.
 *  -----------------------------------------------------------------------------
 */
package com.sleepycat.db;

/**
 *  The Dbc object is the handle for a cursor into a Berkeley DB
 *  database. The handle is not free-threaded. Cursor handles may be
 *  used by multiple threads, but only serially, that is, the
 *  application must serialize access to the Dbc handle.</p> <p>
 *
 *  If the cursor is to be used to perform operations on behalf of a
 *  transaction, the cursor must be opened and closed within the
 *  context of that single transaction. Once {@link
 *  com.sleepycat.db.Dbc#close Dbc.close} has been called, the handle
 *  may not be accessed again, regardless of the method's return.</p>
 */
public class Dbc {
    private long swigCPtr;
    protected boolean swigCMemOwn;


    protected Dbc(long cPtr, boolean cMemoryOwn) {
        swigCMemOwn = cMemoryOwn;
        swigCPtr = cPtr;
    }


    protected Dbc() {
        this(0, false);
    }


    protected void delete() {
        if (swigCPtr != 0 && swigCMemOwn) {
            swigCMemOwn = false;
        }
        swigCPtr = 0;
    }


    protected static long getCPtr(Dbc obj) {
        return (obj == null) ? 0 : obj.swigCPtr;
    }


    /**
     *  The Dbc.close method discards the cursor.</p> <p>
     *
     *  It is possible for the Dbc.close method to return <a
     *  href="{@docRoot}/../ref/program/errorret.html#DB_LOCK_DEADLOCK">
     *  Db.DB_LOCK_DEADLOCK</a> , signaling that any enclosing
     *  transaction should be aborted. If the application is already
     *  intending to abort the transaction, this error should be
     *  ignored, and the application should proceed.</p> <p>
     *
     *  After Dbc.close has been called, regardless of its return, the
     *  cursor handle may not be used again.</p>
     *
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Dbc.close method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Dbc.close method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Dbc.close method will
     *      fail and throw a IllegalArgumentException exception if the
     *      cursor is already closed; or if an invalid flag value or
     *      parameter was specified.
     */
    public synchronized void close() throws DbException {
        try {
            close0();
        } finally {
            swigCPtr = 0;
        }
    }


    /**
     * @deprecated    Replaced in Berkeley DB 4.2 by {@link
     *      #get(Dbt,Dbt,Dbt,int)}
     */
    public int pget(Dbt key, Dbt pkey, Dbt data, int flags) throws DbException {

        return get(key, pkey, data, flags);
    }


    void close0() {
        db_javaJNI.Dbc_close0(swigCPtr);
    }


    /**
     *  The Dbc.count method returns a count of the number of data
     *  items for the key to which the cursor refers.</p>
     *
     * @param  flags                      currently unused, and must
     *      be set to 0.
     * @throws  DbException               The Dbc.count method may
     *      fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  IllegalArgumentException  The Dbc.count method will
     *      fail and throw a IllegalArgumentException exception if the
     *      cursor has not been initialized; or if an invalid flag
     *      value or parameter was specified.
     * @return                            The Dbc.count method throws
     *      an exception that encapsulates a non-zero error value on
     *      failure. </p>
     */
    public int count(int flags) throws DbException {
        return db_javaJNI.Dbc_count(swigCPtr, flags);
    }


    /**
     * @deprecated    As of Berkeley DB 4.2, replaced by {@link
     *      #delete(int)}
     */
    public int del(int flags) throws DbException {
        return delete(flags);
    }


    /**
     *  The Dbc.delete method deletes the key/data pair to which the
     *  cursor refers.</p> <p>
     *
     *  When called on a cursor opened on a database that has been
     *  made into a secondary index using the {@link
     *  com.sleepycat.db.Db#associate Db.associate} method, the {@link
     *  com.sleepycat.db.Db#delete Db.delete} method deletes the
     *  key/data pair from the primary database and all secondary
     *  indices.</p> <p>
     *
     *  The cursor position is unchanged after a delete, and
     *  subsequent calls to cursor functions expecting the cursor to
     *  refer to an existing key will fail.</p>
     *
     * @param  flags                       currently unused, and must
     *      be set to 0.
     * @throws  DbException                The Dbc.delete method may
     *      fail and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors: An attempt was made to modify a read-only
     *      database.
     *      <li> Write attempted on read-only cursor when the {@link
     *      com.sleepycat.db.Db#DB_INIT_CDB Db.DB_INIT_CDB} flag was
     *      specified to {@link com.sleepycat.db.DbEnv#open
     *      DbEnv.open}.
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Dbc.delete method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Dbc.delete method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Dbc.delete method will
     *      fail and throw a IllegalArgumentException exception if the
     *      cursor has not been initialized; or if an invalid flag
     *      value or parameter was specified.
     * @return
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEMPTY DB_KEYEMPTY}
     *        <p>
     *
     *        The Dbc.delete method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> if the element has
     *        already been deleted. </li>
     *      </ul>
     *      Unless otherwise specified, the Dbc.delete method throws
     *      an exception that encapsulates a non-zero error value on
     *      failure. </p>
     */
    public int delete(int flags) throws DbException {
        return db_javaJNI.Dbc_del(swigCPtr, flags);
    }


    /**
     *  The Dbc.dup method creates a new cursor that uses the same
     *  transaction and locker ID as the original cursor. This is
     *  useful when an application is using locking and requires two
     *  or more cursors in the same thread of control.</p>
     *
     * @param  flags                      must be set to 0 or by
     *      bitwise inclusively <b>OR</b> 'ing together one or more of
     *      the following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_POSITION
     *        Db.DB_POSITION}<p>
     *
     *        The newly created cursor is initialized to refer to the
     *        same position in the database as the original cursor and
     *        hold the same locks. If the <code>Db.DB_POSITION</code>
     *        flag is not specified, then the created cursor is
     *        uninitialized and will behave like a cursor newly
     *        created using {@link com.sleepycat.db.Db#cursor
     *        Db.cursor}. </li>
     *      </ul>
     *
     * @throws  DbException               The Dbc.dup method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  IllegalArgumentException  The Dbc.dup method will fail
     *      and throw a IllegalArgumentException exception if the
     *      cursor has not been initialized; or if an invalid flag
     *      value or parameter was specified.
     * @return                            The Dbc.dup method throws an
     *      exception that encapsulates a non-zero error value on
     *      failure. </p>
     */
    public Dbc dup(int flags) throws DbException {
        long cPtr = db_javaJNI.Dbc_dup(swigCPtr, flags);
        return (cPtr == 0) ? null : new Dbc(cPtr, true);
    }


    /**
     *  The Dbc.get method retrieves key/data pairs from the database.
     *  The byte array and length of the key are returned in the
     *  object to which <b>key</b> refers (except for the case of the
     *  Db.DB_SET flag, in which the <b>key</b> object is unchanged),
     *  and the byte array and length of the data are returned in the
     *  object to which <b>data</b> refers.</p> <p>
     *
     *  When called on a cursor opened on a database that has been
     *  made into a secondary index using the {@link
     *  com.sleepycat.db.Db#associate Db.associate} method, the
     *  Dbc.get and Dbc.get methods return the key from the secondary
     *  index and the data item from the primary database. In
     *  addition, the second method signature returns the key from the
     *  primary database. In databases that are not secondary indices,
     *  the second method signature will always fail.</p> <p>
     *
     *  Modifications to the database during a sequential scan will be
     *  reflected in the scan; that is, records inserted behind a
     *  cursor will not be returned while records inserted in front of
     *  a cursor will be returned.</p> <p>
     *
     *  In Queue and Recno databases, missing entries (that is,
     *  entries that were never explicitly created or that were
     *  created and then deleted) will be skipped during a sequential
     *  scan.</p> If Dbc.get fails for any reason, the state of the
     *  cursor will be unchanged.</p>
     *
     * @param  data                        The data {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  flags                       must be set to one of the
     *      following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CURRENT
     *        Db.DB_CURRENT}<p>
     *
     *        Return the key/data pair to which the cursor refers.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_FIRST Db.DB_FIRST}<p>
     *
     *        The cursor is set to refer to the first key/data pair of
     *        the database, and that pair is returned. If the first
     *        key has duplicate values, the first data item in the set
     *        of duplicates is returned. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_FIRST</code> flag will ignore any
     *        keys that exist but were never explicitly created by the
     *        application, or were created and later deleted.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_GET_BOTH
     *        Db.DB_GET_BOTH}<p>
     *
     *        The <code>Db.DB_GET_BOTH</code> flag is identical to the
     *        <code>Db.DB_SET</code> flag, except that both the key
     *        and the data parameters must be matched by the key and
     *        data item in the database. <p>
     *
     *        When used with the second method signature version of
     *        this method on a secondary index handle, both the
     *        secondary and primary keys must be matched by the
     *        secondary and primary key item in the database. It is an
     *        error to use the <code>Db.DB_GET_BOTH</code> flag with
     *        the first method signature version of this method and a
     *        cursor that has been opened on a secondary index handle.
     *        </p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_GET_BOTH_RANGE
     *        Db.DB_GET_BOTH_RANGE}<p>
     *
     *        The <code>Db.DB_GET_BOTH_RANGE</code> flag is identical
     *        to the <code>Db.DB_GET_BOTH</code> flag, except that, in
     *        the case of any database supporting sorted duplicate
     *        sets, the returned key/data pair is the smallest data
     *        item greater than or equal to the specified data item
     *        (as determined by the comparison function), permitting
     *        partial matches and range searches in duplicate data
     *        sets. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_GET_RECNO
     *        Db.DB_GET_RECNO}<p>
     *
     *        Return the record number associated with the cursor. The
     *        record number will be returned in <b>data</b> , as
     *        described in {@link com.sleepycat.db.Dbt Dbt}. ignored.
     *        <p>
     *
     *        For <code>Db.DB_GET_RECNO</code> to be specified, the
     *        underlying database must be of type Btree, and it must
     *        have been created with the {@link
     *        com.sleepycat.db.Db#DB_RECNUM <code>Db.DB_RECNUM</code>}
     *        flag.</p> <p>
     *
     *        When called on a cursor opened on a database that has
     *        been made into a secondary index, the Dbc.get method
     *        returns the record number of the primary database in <b>
     *        data</b> . In addition, the second method signature
     *        returns the record number of the secondary index in <b>
     *        pkey</b> . If either underlying database is not of type
     *        Btree or is not created with the {@link
     *        com.sleepycat.db.Db#DB_RECNUM <code>Db.DB_RECNUM</code>}
     *        flag, the out-of-band record number of 0 is returned.
     *        </p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_JOIN_ITEM
     *        Db.DB_JOIN_ITEM}<p>
     *
     *        Do not use the data value found in all of the cursors as
     *        a lookup key for the primary database, but simply return
     *        it in the key parameter instead. The data parameter is
     *        left unchanged. <p>
     *
     *        For <code>Db.DB_JOIN_ITEM</code> to be specified, the
     *        underlying cursor must have been returned from the
     *        {@link com.sleepycat.db.Db#join Db.join} method.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LAST Db.DB_LAST}<p>
     *
     *        The cursor is set to refer to the last key/data pair of
     *        the database, and that pair is returned. If the last key
     *        has duplicate values, the last data item in the set of
     *        duplicates is returned. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_LAST</code> flag will ignore any
     *        keys that exist but were never explicitly created by the
     *        application, or were created and later deleted.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NEXT Db.DB_NEXT}<p>
     *
     *        If the cursor is not yet initialized, <code>Db.DB_NEXT</code>
     *        is identical to <code>Db.DB_FIRST</code>. Otherwise, the
     *        cursor is moved to the next key/data pair of the
     *        database, and that pair is returned. In the presence of
     *        duplicate key values, the value of the key may not
     *        change. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_NEXT</code> flag will skip any
     *        keys that exist but were never explicitly created by the
     *        application, or those that were created and later
     *        deleted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NEXT_DUP
     *        Db.DB_NEXT_DUP}<p>
     *
     *        If the next key/data pair of the database is a duplicate
     *        data record for the current key/data pair, the cursor is
     *        moved to the next key/data pair of the database, and
     *        that pair is returned. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NEXT_NODUP
     *        Db.DB_NEXT_NODUP}<p>
     *
     *        If the cursor is not yet initialized, <code>Db.DB_NEXT_NODUP</code>
     *        is identical to <code>Db.DB_FIRST</code>. Otherwise, the
     *        cursor is moved to the next non-duplicate key of the
     *        database, and that key/data pair is returned. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_NEXT_NODUP</code> flag will ignore
     *        any keys that exist but were never explicitly created by
     *        the application, or those that were created and later
     *        deleted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_PREV Db.DB_PREV}<p>
     *
     *        If the cursor is not yet initialized, <code>Db.DB_PREV</code>
     *        is identical to <code>Db.DB_LAST</code>. Otherwise, the
     *        cursor is moved to the previous key/data pair of the
     *        database, and that pair is returned. In the presence of
     *        duplicate key values, the value of the key may not
     *        change. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_PREV</code> flag will skip any
     *        keys that exist but were never explicitly created by the
     *        application, or those that were created and later
     *        deleted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_PREV_NODUP
     *        Db.DB_PREV_NODUP}<p>
     *
     *        If the cursor is not yet initialized, <code>Db.DB_PREV_NODUP</code>
     *        is identical to <code>Db.DB_LAST</code>. Otherwise, the
     *        cursor is moved to the previous non-duplicate key of the
     *        database, and that key/data pair is returned. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_PREV_NODUP</code> flag will ignore
     *        any keys that exist but were never explicitly created by
     *        the application, or those that were created and later
     *        deleted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET Db.DB_SET}<p>
     *
     *        Move the cursor to the specified key/data pair of the
     *        database, and return the datum associated with the given
     *        key. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_RANGE
     *        Db.DB_SET_RANGE}<p>
     *
     *        The <code>Db.DB_SET_RANGE</code> flag is identical to
     *        the <code>Db.DB_SET</code> flag, except that in the case
     *        of the Btree access method, the key is returned as well
     *        as the data item and the returned key/data pair is the
     *        smallest key greater than or equal to the specified key
     *        (as determined by the Btree comparison function),
     *        permitting partial key matches and range searches. </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_RECNO
     *        Db.DB_SET_RECNO}<p>
     *
     *        Move the cursor to the specific numbered record of the
     *        database, and return the associated key/data pair. The
     *        <b>data</b> field of the specified <b>key</b> must be a
     *        byte array containing a record number, as described in
     *        {@link com.sleepycat.db.Dbt Dbt}. This determines the
     *        record to be retrieved. <p>
     *
     *        For <code>Db.DB_SET_RECNO</code> to be specified, the
     *        underlying database must be of type Btree, and it must
     *        have been created with the {@link
     *        com.sleepycat.db.Db#DB_RECNUM <code>Db.DB_RECNUM</code>}
     *        flag.</p> </li>
     *      </ul>
     *      In addition, the following flags may be set by bitwise
     *      inclusively <b>OR</b> 'ing them into the <b>flags</b>
     *      parameter:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        Db.DB_DIRTY_READ}<p>
     *
     *        Read modified but not yet committed data. Silently
     *        ignored if the {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        <code>Db.DB_DIRTY_READ</code>} flag was not specified
     *        when the underlying database was opened. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_MULTIPLE
     *        Db.DB_MULTIPLE}<p>
     *
     *        Return multiple data items in the <b>data</b> parameter.
     *        <p>
     *
     *        In the case of Btree or Hash databases, duplicate data
     *        items for the current key, starting at the current
     *        cursor position, are entered into the buffer. Subsequent
     *        calls with both the <code>Db.DB_NEXT_DUP</code> and
     *        <code>Db.DB_MULTIPLE</code> flags specified will return
     *        additional duplicate data items associated with the
     *        current key or <a href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if there are no
     *        additional duplicate data items to return. Subsequent
     *        calls with both the <code>Db.DB_NEXT</code> and <code>Db.DB_MULTIPLE</code>
     *        flags specified will return additional duplicate data
     *        items associated with the current key or if there are no
     *        additional duplicate data items will return the next key
     *        and its data items or <a href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if there are no
     *        additional keys in the database.</p> <p>
     *
     *        In the case of Queue or Recno databases, data items
     *        starting at the current cursor position are entered into
     *        the buffer. The record number of the first record will
     *        be returned in the <b>key</b> parameter. The record
     *        number of each subsequent returned record must be
     *        calculated from this value. Subsequent calls with the
     *        <code>Db.DB_MULTIPLE</code> flag specified will return
     *        additional data items or <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if there are no
     *        additional data items to return.</p> <p>
     *
     *        The buffer to which the <b>data</b> parameter refers
     *        must be provided from user memory (see {@link
     *        com.sleepycat.db.Db#DB_DBT_USERMEM <code>Db.DB_DBT_USERMEM</code>
     *        }). The buffer must be at least as large as the page
     *        size of the underlying database, aligned for unsigned
     *        integer access, and be a multiple of 1024 bytes in size.
     *        If the buffer size is insufficient, then upon return
     *        from the call the size field of the <b>data</b>
     *        parameter will have been set to an estimated buffer
     *        size, and a {@link com.sleepycat.db.DbMemoryException
     *        DbMemoryException} is thrown. (The size is an estimate
     *        as the exact size needed may not be known until all
     *        entries are read. It is best to initially provide a
     *        relatively large buffer, but applications should be
     *        prepared to resize the buffer as necessary and
     *        repeatedly call the method.)</p> <p>
     *
     *        The multiple data items can be iterated over using the
     *        {@link com.sleepycat.db.DbMultipleDataIterator
     *        DbMultipleDataIterator} class.</p> <p>
     *
     *        The <code>Db.DB_MULTIPLE</code> flag may only be used
     *        with the <code>Db.DB_CURRENT</code>, <code>Db.DB_FIRST</code>
     *        , <code>Db.DB_GET_BOTH</code>, <code>Db.DB_GET_BOTH_RANGE</code>
     *        , <code>Db.DB_NEXT</code>, <code>Db.DB_NEXT_DUP</code>,
     *        <code>Db.DB_NEXT_NODUP</code>, <code>Db.DB_SET</code>,
     *        <code>Db.DB_SET_RANGE</code>, and <code>Db.DB_SET_RECNO</code>
     *        options. The <code>Db.DB_MULTIPLE</code> flag may not be
     *        used when accessing databases made into secondary
     *        indices using the {@link com.sleepycat.db.Db#associate
     *        Db.associate} method.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_MULTIPLE_KEY
     *        Db.DB_MULTIPLE_KEY}<p>
     *
     *        Return multiple key and data pairs in the <b>data</b>
     *        parameter. <p>
     *
     *        Key and data pairs, starting at the current cursor
     *        position, are entered into the buffer. Subsequent calls
     *        with both the <code>Db.DB_NEXT</code> and <code>Db.DB_MULTIPLE</code>
     *        flags specified will return additional key and data
     *        pairs or <a href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if there are no
     *        additional key and data items to return.</p> <p>
     *
     *        In the case of Btree or Hash databases, the multiple key
     *        and data pairs can be iterated over using the {@link
     *        com.sleepycat.db.DbMultipleKeyDataIterator
     *        DbMultipleKeyDataIterator} class.</p> <p>
     *
     *        In the case of Queue or Recno databases, the multiple
     *        record number and data pairs can be iterated over using
     *        the {@link com.sleepycat.db.DbMultipleRecnoDataIterator
     *        DbMultipleRecnoDataIterator} class.</p> <p>
     *
     *        The buffer to which the <b>data</b> parameter refers
     *        must be provided from user memory (see {@link
     *        com.sleepycat.db.Db#DB_DBT_USERMEM <code>Db.DB_DBT_USERMEM</code>
     *        }). The buffer must be at least as large as the page
     *        size of the underlying database, aligned for unsigned
     *        integer access, and be a multiple of 1024 bytes in size.
     *        If the buffer size is insufficient, then upon return
     *        from the call the size field of the <b>data</b>
     *        parameter will have been set to an estimated buffer
     *        size, and a {@link com.sleepycat.db.DbMemoryException
     *        DbMemoryException} is thrown. (The size is an estimate
     *        as the exact size needed may not be known until all
     *        entries are read. It is best to initially provide a
     *        relatively large buffer, but applications should be
     *        prepared to resize the buffer as necessary and
     *        repeatedly call the method.)</p> <p>
     *
     *        The <code>Db.DB_MULTIPLE_KEY</code> flag may only be
     *        used with the <code>Db.DB_CURRENT</code>, <code>Db.DB_FIRST</code>
     *        , <code>Db.DB_GET_BOTH</code>, <code>Db.DB_GET_BOTH_RANGE</code>
     *        , <code>Db.DB_NEXT</code>, <code>Db.DB_NEXT_DUP</code>,
     *        <code>Db.DB_NEXT_NODUP</code>, <code>Db.DB_SET</code>,
     *        <code>Db.DB_SET_RANGE</code>, and <code>Db.DB_SET_RECNO</code>
     *        options. The <code>Db.DB_MULTIPLE_KEY</code> flag may
     *        not be used when accessing databases made into secondary
     *        indices using the {@link com.sleepycat.db.Db#associate
     *        Db.associate} method.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RMW Db.DB_RMW}<p>
     *
     *        Acquire write locks instead of read locks when doing the
     *        retrieval. Setting this flag can eliminate deadlock
     *        during a read-modify-write cycle by acquiring the write
     *        lock during the read part of the cycle so that another
     *        thread of control acquiring a read lock for the same
     *        item, in its own read-modify-write cycle, will not
     *        result in deadlock. </li>
     *      </ul>
     *
     * @param  key                         The key {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @throws  DbException                The Dbc.get method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Dbc.get method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Dbc.get method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Dbc.get method will
     *      fail and throw a IllegalArgumentException exception if the
     *      Db.DB_CURRENT or Db.DB_NEXT_DUP flags were specified and
     *      the cursor has not been initialized; the second method
     *      signature was called with a cursor that does not refer to
     *      a secondary index; or if an invalid flag value or
     *      parameter was specified.
     * @throws  DbMemoryException          If the requested item could
     *      not be returned due to insufficient memory, the Dbc.get
     *      method will fail and throw a {@link
     *      com.sleepycat.db.DbMemoryException DbMemoryException}
     *      exception.
     * @return                             Unless otherwise specified,
     *      the Dbc.get method throws an exception that encapsulates a
     *      non-zero error value on failure. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEMPTY DB_KEYEMPTY}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> if <code>Db.DB_CURRENT</code>
     *        is set and the cursor key/data pair was deleted. </li>
     *
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_FIRST</code>
     *        is set and the database is empty. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_LAST</code>
     *        is set and the database is empty. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_NEXT</code>
     *        is set and the cursor is already on the last record in
     *        the database. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_NEXT_DUP</code>
     *        is set and the next key/data pair of the database is not
     *        a duplicate data record for the current key/data pair.
     *        </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_NEXT_NODUP</code>
     *        is set and no non-duplicate key/data pairs occur after
     *        the cursor position in the database. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_PREV</code>
     *        is set and the cursor is already on the first record in
     *        the database. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_PREV_NODUP</code>
     *        is set and no non-duplicate key/data pairs occur before
     *        the cursor position in the database. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_SET</code>
     *        is set and no matching keys are found. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEMPTY DB_KEYEMPTY}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> if <code>Db.DB_SET</code>
     *        is set and the database is a Queue or Recno database,
     *        and the specified key exists, but was never explicitly
     *        created by the application or was later deleted. </li>
     *
     *      </ul>
     *      In the presence of duplicate key values, Dbc.get will
     *      return the first data item for the given key. </p>
     */
    public int get(Dbt key, Dbt data, int flags) throws DbException {
        return db_javaJNI.Dbc_get__SWIG_0(swigCPtr, key, data, flags);
    }


    /**
     *  The Dbc.get method retrieves key/data pairs from the database.
     *  The byte array and length of the key are returned in the
     *  object to which <b>key</b> refers (except for the case of the
     *  Db.DB_SET flag, in which the <b>key</b> object is unchanged),
     *  and the byte array and length of the data are returned in the
     *  object to which <b>data</b> refers.</p> <p>
     *
     *  When called on a cursor opened on a database that has been
     *  made into a secondary index using the {@link
     *  com.sleepycat.db.Db#associate Db.associate} method, the
     *  Dbc.get and Dbc.get methods return the key from the secondary
     *  index and the data item from the primary database. In
     *  addition, the second method signature returns the key from the
     *  primary database. In databases that are not secondary indices,
     *  the second method signature will always fail.</p> <p>
     *
     *  Modifications to the database during a sequential scan will be
     *  reflected in the scan; that is, records inserted behind a
     *  cursor will not be returned while records inserted in front of
     *  a cursor will be returned.</p> <p>
     *
     *  In Queue and Recno databases, missing entries (that is,
     *  entries that were never explicitly created or that were
     *  created and then deleted) will be skipped during a sequential
     *  scan.</p> If Dbc.get fails for any reason, the state of the
     *  cursor will be unchanged.</p>
     *
     * @param  data                        The data {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  flags                       must be set to one of the
     *      following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CURRENT
     *        Db.DB_CURRENT}<p>
     *
     *        Return the key/data pair to which the cursor refers.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_FIRST Db.DB_FIRST}<p>
     *
     *        The cursor is set to refer to the first key/data pair of
     *        the database, and that pair is returned. If the first
     *        key has duplicate values, the first data item in the set
     *        of duplicates is returned. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_FIRST</code> flag will ignore any
     *        keys that exist but were never explicitly created by the
     *        application, or were created and later deleted.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_GET_BOTH
     *        Db.DB_GET_BOTH}<p>
     *
     *        The <code>Db.DB_GET_BOTH</code> flag is identical to the
     *        <code>Db.DB_SET</code> flag, except that both the key
     *        and the data parameters must be matched by the key and
     *        data item in the database. <p>
     *
     *        When used with the second method signature version of
     *        this method on a secondary index handle, both the
     *        secondary and primary keys must be matched by the
     *        secondary and primary key item in the database. It is an
     *        error to use the <code>Db.DB_GET_BOTH</code> flag with
     *        the first method signature version of this method and a
     *        cursor that has been opened on a secondary index handle.
     *        </p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_GET_BOTH_RANGE
     *        Db.DB_GET_BOTH_RANGE}<p>
     *
     *        The <code>Db.DB_GET_BOTH_RANGE</code> flag is identical
     *        to the <code>Db.DB_GET_BOTH</code> flag, except that, in
     *        the case of any database supporting sorted duplicate
     *        sets, the returned key/data pair is the smallest data
     *        item greater than or equal to the specified data item
     *        (as determined by the comparison function), permitting
     *        partial matches and range searches in duplicate data
     *        sets. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_GET_RECNO
     *        Db.DB_GET_RECNO}<p>
     *
     *        Return the record number associated with the cursor. The
     *        record number will be returned in <b>data</b> , as
     *        described in {@link com.sleepycat.db.Dbt Dbt}. ignored.
     *        <p>
     *
     *        For <code>Db.DB_GET_RECNO</code> to be specified, the
     *        underlying database must be of type Btree, and it must
     *        have been created with the {@link
     *        com.sleepycat.db.Db#DB_RECNUM <code>Db.DB_RECNUM</code>}
     *        flag.</p> <p>
     *
     *        When called on a cursor opened on a database that has
     *        been made into a secondary index, the Dbc.get method
     *        returns the record number of the primary database in <b>
     *        data</b> . In addition, the second method signature
     *        returns the record number of the secondary index in <b>
     *        pkey</b> . If either underlying database is not of type
     *        Btree or is not created with the {@link
     *        com.sleepycat.db.Db#DB_RECNUM <code>Db.DB_RECNUM</code>}
     *        flag, the out-of-band record number of 0 is returned.
     *        </p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_JOIN_ITEM
     *        Db.DB_JOIN_ITEM}<p>
     *
     *        Do not use the data value found in all of the cursors as
     *        a lookup key for the primary database, but simply return
     *        it in the key parameter instead. The data parameter is
     *        left unchanged. <p>
     *
     *        For <code>Db.DB_JOIN_ITEM</code> to be specified, the
     *        underlying cursor must have been returned from the
     *        {@link com.sleepycat.db.Db#join Db.join} method.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_LAST Db.DB_LAST}<p>
     *
     *        The cursor is set to refer to the last key/data pair of
     *        the database, and that pair is returned. If the last key
     *        has duplicate values, the last data item in the set of
     *        duplicates is returned. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_LAST</code> flag will ignore any
     *        keys that exist but were never explicitly created by the
     *        application, or were created and later deleted.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NEXT Db.DB_NEXT}<p>
     *
     *        If the cursor is not yet initialized, <code>Db.DB_NEXT</code>
     *        is identical to <code>Db.DB_FIRST</code>. Otherwise, the
     *        cursor is moved to the next key/data pair of the
     *        database, and that pair is returned. In the presence of
     *        duplicate key values, the value of the key may not
     *        change. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_NEXT</code> flag will skip any
     *        keys that exist but were never explicitly created by the
     *        application, or those that were created and later
     *        deleted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NEXT_DUP
     *        Db.DB_NEXT_DUP}<p>
     *
     *        If the next key/data pair of the database is a duplicate
     *        data record for the current key/data pair, the cursor is
     *        moved to the next key/data pair of the database, and
     *        that pair is returned. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NEXT_NODUP
     *        Db.DB_NEXT_NODUP}<p>
     *
     *        If the cursor is not yet initialized, <code>Db.DB_NEXT_NODUP</code>
     *        is identical to <code>Db.DB_FIRST</code>. Otherwise, the
     *        cursor is moved to the next non-duplicate key of the
     *        database, and that key/data pair is returned. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_NEXT_NODUP</code> flag will ignore
     *        any keys that exist but were never explicitly created by
     *        the application, or those that were created and later
     *        deleted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_PREV Db.DB_PREV}<p>
     *
     *        If the cursor is not yet initialized, <code>Db.DB_PREV</code>
     *        is identical to <code>Db.DB_LAST</code>. Otherwise, the
     *        cursor is moved to the previous key/data pair of the
     *        database, and that pair is returned. In the presence of
     *        duplicate key values, the value of the key may not
     *        change. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_PREV</code> flag will skip any
     *        keys that exist but were never explicitly created by the
     *        application, or those that were created and later
     *        deleted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_PREV_NODUP
     *        Db.DB_PREV_NODUP}<p>
     *
     *        If the cursor is not yet initialized, <code>Db.DB_PREV_NODUP</code>
     *        is identical to <code>Db.DB_LAST</code>. Otherwise, the
     *        cursor is moved to the previous non-duplicate key of the
     *        database, and that key/data pair is returned. <p>
     *
     *        If the database is a Queue or Recno database, Dbc.get
     *        using the <code>Db.DB_PREV_NODUP</code> flag will ignore
     *        any keys that exist but were never explicitly created by
     *        the application, or those that were created and later
     *        deleted.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET Db.DB_SET}<p>
     *
     *        Move the cursor to the specified key/data pair of the
     *        database, and return the datum associated with the given
     *        key. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_RANGE
     *        Db.DB_SET_RANGE}<p>
     *
     *        The <code>Db.DB_SET_RANGE</code> flag is identical to
     *        the <code>Db.DB_SET</code> flag, except that in the case
     *        of the Btree access method, the key is returned as well
     *        as the data item and the returned key/data pair is the
     *        smallest key greater than or equal to the specified key
     *        (as determined by the Btree comparison function),
     *        permitting partial key matches and range searches. </li>
     *
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_SET_RECNO
     *        Db.DB_SET_RECNO}<p>
     *
     *        Move the cursor to the specific numbered record of the
     *        database, and return the associated key/data pair. The
     *        <b>data</b> field of the specified <b>key</b> must be a
     *        byte array containing a record number, as described in
     *        {@link com.sleepycat.db.Dbt Dbt}. This determines the
     *        record to be retrieved. <p>
     *
     *        For <code>Db.DB_SET_RECNO</code> to be specified, the
     *        underlying database must be of type Btree, and it must
     *        have been created with the {@link
     *        com.sleepycat.db.Db#DB_RECNUM <code>Db.DB_RECNUM</code>}
     *        flag.</p> </li>
     *      </ul>
     *      In addition, the following flags may be set by bitwise
     *      inclusively <b>OR</b> 'ing them into the <b>flags</b>
     *      parameter:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        Db.DB_DIRTY_READ}<p>
     *
     *        Read modified but not yet committed data. Silently
     *        ignored if the {@link com.sleepycat.db.Db#DB_DIRTY_READ
     *        <code>Db.DB_DIRTY_READ</code>} flag was not specified
     *        when the underlying database was opened. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_MULTIPLE
     *        Db.DB_MULTIPLE}<p>
     *
     *        Return multiple data items in the <b>data</b> parameter.
     *        <p>
     *
     *        In the case of Btree or Hash databases, duplicate data
     *        items for the current key, starting at the current
     *        cursor position, are entered into the buffer. Subsequent
     *        calls with both the <code>Db.DB_NEXT_DUP</code> and
     *        <code>Db.DB_MULTIPLE</code> flags specified will return
     *        additional duplicate data items associated with the
     *        current key or <a href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if there are no
     *        additional duplicate data items to return. Subsequent
     *        calls with both the <code>Db.DB_NEXT</code> and <code>Db.DB_MULTIPLE</code>
     *        flags specified will return additional duplicate data
     *        items associated with the current key or if there are no
     *        additional duplicate data items will return the next key
     *        and its data items or <a href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if there are no
     *        additional keys in the database.</p> <p>
     *
     *        In the case of Queue or Recno databases, data items
     *        starting at the current cursor position are entered into
     *        the buffer. The record number of the first record will
     *        be returned in the <b>key</b> parameter. The record
     *        number of each subsequent returned record must be
     *        calculated from this value. Subsequent calls with the
     *        <code>Db.DB_MULTIPLE</code> flag specified will return
     *        additional data items or <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if there are no
     *        additional data items to return.</p> <p>
     *
     *        The buffer to which the <b>data</b> parameter refers
     *        must be provided from user memory (see {@link
     *        com.sleepycat.db.Db#DB_DBT_USERMEM <code>Db.DB_DBT_USERMEM</code>
     *        }). The buffer must be at least as large as the page
     *        size of the underlying database, aligned for unsigned
     *        integer access, and be a multiple of 1024 bytes in size.
     *        If the buffer size is insufficient, then upon return
     *        from the call the size field of the <b>data</b>
     *        parameter will have been set to an estimated buffer
     *        size, and a {@link com.sleepycat.db.DbMemoryException
     *        DbMemoryException} is thrown. (The size is an estimate
     *        as the exact size needed may not be known until all
     *        entries are read. It is best to initially provide a
     *        relatively large buffer, but applications should be
     *        prepared to resize the buffer as necessary and
     *        repeatedly call the method.)</p> <p>
     *
     *        The multiple data items can be iterated over using the
     *        {@link com.sleepycat.db.DbMultipleDataIterator
     *        DbMultipleDataIterator} class.</p> <p>
     *
     *        The <code>Db.DB_MULTIPLE</code> flag may only be used
     *        with the <code>Db.DB_CURRENT</code>, <code>Db.DB_FIRST</code>
     *        , <code>Db.DB_GET_BOTH</code>, <code>Db.DB_GET_BOTH_RANGE</code>
     *        , <code>Db.DB_NEXT</code>, <code>Db.DB_NEXT_DUP</code>,
     *        <code>Db.DB_NEXT_NODUP</code>, <code>Db.DB_SET</code>,
     *        <code>Db.DB_SET_RANGE</code>, and <code>Db.DB_SET_RECNO</code>
     *        options. The <code>Db.DB_MULTIPLE</code> flag may not be
     *        used when accessing databases made into secondary
     *        indices using the {@link com.sleepycat.db.Db#associate
     *        Db.associate} method.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_MULTIPLE_KEY
     *        Db.DB_MULTIPLE_KEY}<p>
     *
     *        Return multiple key and data pairs in the <b>data</b>
     *        parameter. <p>
     *
     *        Key and data pairs, starting at the current cursor
     *        position, are entered into the buffer. Subsequent calls
     *        with both the <code>Db.DB_NEXT</code> and <code>Db.DB_MULTIPLE</code>
     *        flags specified will return additional key and data
     *        pairs or <a href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if there are no
     *        additional key and data items to return.</p> <p>
     *
     *        In the case of Btree or Hash databases, the multiple key
     *        and data pairs can be iterated over using the {@link
     *        com.sleepycat.db.DbMultipleKeyDataIterator
     *        DbMultipleKeyDataIterator} class.</p> <p>
     *
     *        In the case of Queue or Recno databases, the multiple
     *        record number and data pairs can be iterated over using
     *        the {@link com.sleepycat.db.DbMultipleRecnoDataIterator
     *        DbMultipleRecnoDataIterator} class.</p> <p>
     *
     *        The buffer to which the <b>data</b> parameter refers
     *        must be provided from user memory (see {@link
     *        com.sleepycat.db.Db#DB_DBT_USERMEM <code>Db.DB_DBT_USERMEM</code>
     *        }). The buffer must be at least as large as the page
     *        size of the underlying database, aligned for unsigned
     *        integer access, and be a multiple of 1024 bytes in size.
     *        If the buffer size is insufficient, then upon return
     *        from the call the size field of the <b>data</b>
     *        parameter will have been set to an estimated buffer
     *        size, and a {@link com.sleepycat.db.DbMemoryException
     *        DbMemoryException} is thrown. (The size is an estimate
     *        as the exact size needed may not be known until all
     *        entries are read. It is best to initially provide a
     *        relatively large buffer, but applications should be
     *        prepared to resize the buffer as necessary and
     *        repeatedly call the method.)</p> <p>
     *
     *        The <code>Db.DB_MULTIPLE_KEY</code> flag may only be
     *        used with the <code>Db.DB_CURRENT</code>, <code>Db.DB_FIRST</code>
     *        , <code>Db.DB_GET_BOTH</code>, <code>Db.DB_GET_BOTH_RANGE</code>
     *        , <code>Db.DB_NEXT</code>, <code>Db.DB_NEXT_DUP</code>,
     *        <code>Db.DB_NEXT_NODUP</code>, <code>Db.DB_SET</code>,
     *        <code>Db.DB_SET_RANGE</code>, and <code>Db.DB_SET_RECNO</code>
     *        options. The <code>Db.DB_MULTIPLE_KEY</code> flag may
     *        not be used when accessing databases made into secondary
     *        indices using the {@link com.sleepycat.db.Db#associate
     *        Db.associate} method.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_RMW Db.DB_RMW}<p>
     *
     *        Acquire write locks instead of read locks when doing the
     *        retrieval. Setting this flag can eliminate deadlock
     *        during a read-modify-write cycle by acquiring the write
     *        lock during the read part of the cycle so that another
     *        thread of control acquiring a read lock for the same
     *        item, in its own read-modify-write cycle, will not
     *        result in deadlock. </li>
     *      </ul>
     *
     * @param  key                         The key {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  pkey                        The secondary index key
     *      {@link com.sleepycat.db.Dbt Dbt} operated on.
     * @throws  DbException                The Dbc.get method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Dbc.get method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Dbc.get method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Dbc.get method will
     *      fail and throw a IllegalArgumentException exception if the
     *      Db.DB_CURRENT or Db.DB_NEXT_DUP flags were specified and
     *      the cursor has not been initialized; the second method
     *      signature was called with a cursor that does not refer to
     *      a secondary index; or if an invalid flag value or
     *      parameter was specified.
     * @throws  DbMemoryException          If the requested item could
     *      not be returned due to insufficient memory, the Dbc.get
     *      method will fail and throw a {@link
     *      com.sleepycat.db.DbMemoryException DbMemoryException}
     *      exception.
     * @return                             Unless otherwise specified,
     *      the Dbc.get method throws an exception that encapsulates a
     *      non-zero error value on failure. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEMPTY DB_KEYEMPTY}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> if <code>Db.DB_CURRENT</code>
     *        is set and the cursor key/data pair was deleted. </li>
     *
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_FIRST</code>
     *        is set and the database is empty. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_LAST</code>
     *        is set and the database is empty. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_NEXT</code>
     *        is set and the cursor is already on the last record in
     *        the database. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_NEXT_DUP</code>
     *        is set and the next key/data pair of the database is not
     *        a duplicate data record for the current key/data pair.
     *        </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_NEXT_NODUP</code>
     *        is set and no non-duplicate key/data pairs occur after
     *        the cursor position in the database. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_PREV</code>
     *        is set and the cursor is already on the first record in
     *        the database. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_PREV_NODUP</code>
     *        is set and no non-duplicate key/data pairs occur before
     *        the cursor position in the database. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if <code>Db.DB_SET</code>
     *        is set and no matching keys are found. </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYEMPTY DB_KEYEMPTY}
     *        <p>
     *
     *        The Dbc.get method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_KEYEMPTY">
     *        <code>Db.DB_KEYEMPTY</code></a> if <code>Db.DB_SET</code>
     *        is set and the database is a Queue or Recno database,
     *        and the specified key exists, but was never explicitly
     *        created by the application or was later deleted. </li>
     *
     *      </ul>
     *      In the presence of duplicate key values, Dbc.get will
     *      return the first data item for the given key. </p>
     */
    public int get(Dbt key, Dbt pkey, Dbt data, int flags) throws DbException {
        return db_javaJNI.Dbc_get__SWIG_1(swigCPtr, key, pkey, data, flags);
    }


    /**
     *  The Dbc.put method stores key/data pairs into the database.
     *  </p> If Dbc.put fails for any reason, the state of the cursor
     *  will be unchanged. If Dbc.put succeeds and an item is inserted
     *  into the database, the cursor is always positioned to refer to
     *  the newly inserted item.</p>
     *
     * @param  data                        The data {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @param  flags                       must be set to one of the
     *      following values:
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_AFTER Db.DB_AFTER}<p>
     *
     *        In the case of the Btree and Hash access methods, insert
     *        the data element as a duplicate element of the key to
     *        which the cursor refers. The new element appears
     *        immediately after the current cursor position. It is an
     *        error to specify <code>Db.DB_AFTER</code> if the
     *        underlying Btree or Hash database does not support
     *        duplicate data items. ignored. <p>
     *
     *        In the case of the Recno access method, it is an error
     *        to specify <code>Db.DB_AFTER</code> if the underlying
     *        Recno database was not created with the {@link
     *        com.sleepycat.db.Db#DB_RENUMBER <code>Db.DB_RENUMBER</code>
     *        } flag. If the {@link com.sleepycat.db.Db#DB_RENUMBER
     *        <code>Db.DB_RENUMBER</code>} flag was specified, a new
     *        key is created, all records after the inserted item are
     *        automatically renumbered, and the key of the new record
     *        is returned in the structure to which the <b>key</b>
     *        parameter refers. The initial value of the <b>key</b>
     *        parameter is ignored. See {@link
     *        com.sleepycat.db.Db#open Db.open} for more information.
     *        </p> <p>
     *
     *        The <code>Db.DB_AFTER</code> flag may not be specified
     *        to the Queue access method.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_BEFORE Db.DB_BEFORE}
     *        <p>
     *
     *        In the case of the Btree and Hash access methods, insert
     *        the data element as a duplicate element of the key to
     *        which the cursor refers. The new element appears
     *        immediately before the current cursor position. It is an
     *        error to specify <code>Db.DB_BEFORE</code> if the
     *        underlying Btree or Hash database does not support
     *        duplicate data items. ignored. <p>
     *
     *        In the case of the Recno access method, it is an error
     *        to specify <code>Db.DB_BEFORE</code> if the underlying
     *        Recno database was not created with the {@link
     *        com.sleepycat.db.Db#DB_RENUMBER <code>Db.DB_RENUMBER</code>
     *        } flag. If the {@link com.sleepycat.db.Db#DB_RENUMBER
     *        <code>Db.DB_RENUMBER</code>} flag was specified, a new
     *        key is created, the current record and all records after
     *        it are automatically renumbered, and the key of the new
     *        record is returned in the structure to which the <b>key
     *        </b> parameter refers. The initial value of the <b>key
     *        </b> parameter is ignored. See {@link
     *        com.sleepycat.db.Db#open Db.open} for more information.
     *        </p> <p>
     *
     *        The <code>Db.DB_BEFORE</code> flag may not be specified
     *        to the Queue access method.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_CURRENT
     *        Db.DB_CURRENT}<p>
     *
     *        Overwrite the data of the key/data pair to which the
     *        cursor refers with the specified data item. ignored.
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYFIRST
     *        Db.DB_KEYFIRST}<p>
     *
     *        In the case of the Btree and Hash access methods, insert
     *        the specified key/data pair into the database. <p>
     *
     *        If the underlying database supports duplicate data
     *        items, and if the key already exists in the database and
     *        a duplicate sort function has been specified, the
     *        inserted data item is added in its sorted location. If
     *        the key already exists in the database and no duplicate
     *        sort function has been specified, the inserted data item
     *        is added as the first of the data items for that key.
     *        </p> <p>
     *
     *        The <code>Db.DB_KEYFIRST</code> flag may not be
     *        specified to the Queue or Recno access methods.</p>
     *        </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_KEYLAST
     *        Db.DB_KEYLAST}<p>
     *
     *        In the case of the Btree and Hash access methods, insert
     *        the specified key/data pair into the database. <p>
     *
     *        If the underlying database supports duplicate data
     *        items, and if the key already exists in the database and
     *        a duplicate sort function has been specified, the
     *        inserted data item is added in its sorted location. If
     *        the key already exists in the database, and no duplicate
     *        sort function has been specified, the inserted data item
     *        is added as the last of the data items for that key.</p>
     *        <p>
     *
     *        The <code>Db.DB_KEYLAST</code> flag may not be specified
     *        to the Queue or Recno access methods.</p> </li>
     *      </ul>
     *
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NODUPDATA
     *        Db.DB_NODUPDATA}<p>
     *
     *        In the case of the Btree and Hash access methods, insert
     *        the specified key/data pair into the database, unless a
     *        key/data pair comparing equally to it already exists in
     *        the database. If a matching key/data pair already exists
     *        in the database, {@link com.sleepycat.db.Db#DB_KEYEXIST
     *        <code>Db.DB_KEYEXIST</code>} is returned. The <code>Db.DB_NODUPDATA</code>
     *        flag may only be specified if the underlying database
     *        has been configured to support sorted duplicate data
     *        items. <p>
     *
     *        The <code>Db.DB_NODUPDATA</code> flag may not be
     *        specified to the Queue or Recno access methods.</p>
     *        </li>
     *      </ul>
     *
     * @param  key                         The key {@link
     *      com.sleepycat.db.Dbt Dbt} operated on.
     * @throws  DbException                The Dbc.put method may fail
     *      and throw {@link com.sleepycat.db.DbException
     *      DbException}, encapsulating one of the following non-zero
     *      errors:
     *      <li> An attempt was made to modify a read-only database.
     *      Write attempted on read-only cursor when the {@link
     *      com.sleepycat.db.Db#DB_INIT_CDB Db.DB_INIT_CDB} flag was
     *      specified to {@link com.sleepycat.db.DbEnv#open
     *      DbEnv.open}.
     * @throws  DbDeadlockException        If a transactional database
     *      environment operation was selected to resolve a deadlock,
     *      the Dbc.put method will fail and throw a {@link
     *      com.sleepycat.db.DbDeadlockException DbDeadlockException}
     *      exception.
     * @throws  DbLockNotGrantedException  If a Berkeley DB Concurrent
     *      Data Store database environment configured for lock
     *      timeouts was unable to grant a lock in the allowed time,
     *      the Dbc.put method will fail and throw a {@link
     *      com.sleepycat.db.DbLockNotGrantedException
     *      DbLockNotGrantedException} exception.
     * @throws  IllegalArgumentException   The Dbc.put method will
     *      fail and throw a IllegalArgumentException exception if the
     *      Db.DB_AFTER, Db.DB_BEFORE or Db.DB_CURRENT flags were
     *      specified and the cursor has not been initialized; the
     *      Db.DB_AFTER or Db.DB_BEFORE flags were specified and a
     *      duplicate sort function has been specified; the
     *      Db.DB_CURRENT flag was specified, a duplicate sort
     *      function has been specified, and the data item of the
     *      referenced key/data pair does not compare equally to the
     *      <b>data</b> parameter; the Db.DB_AFTER or Db.DB_BEFORE
     *      flags were specified, and the underlying access method is
     *      Queue; an attempt was made to add a record to a
     *      fixed-length database that was too large to fit; an
     *      attempt was made to add a record to a secondary index; or
     *      if an invalid flag value or parameter was specified.
     * @return                             Unless otherwise specified,
     *      the Dbc.put method throws an exception that encapsulates a
     *      non-zero error value on failure. </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.put method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if the current cursor
     *        record has already been deleted and the underlying
     *        access method is Hash. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.put method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if the current cursor
     *        record has already been deleted and the underlying
     *        access method is Hash. </li>
     *      </ul>
     *      </p>
     *      <ul>
     *        <li> {@link com.sleepycat.db.Db#DB_NOTFOUND DB_NOTFOUND}
     *        <p>
     *
     *        The Dbc.put method will return <a
     *        href="{@docRoot}/../ref/program/errorret.html#DB_NOTFOUND">
     *        <code>Db.DB_NOTFOUND</code></a> if the current cursor
     *        record has already been deleted and the underlying
     *        access method is Hash. </li>
     *      </ul>
     *      </p>
     */
    public int put(Dbt key, Dbt data, int flags) throws DbException {
        return db_javaJNI.Dbc_put(swigCPtr, key, data, flags);
    }

}
