/*
 * Decompiled with CFR 0.152.
 */
package netscape.oji;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import netscape.oji.JNIUtils;

public class CSecureEnv {
    static /* synthetic */ Class class$java$lang$reflect$Method;

    private static boolean getBooleanResult(Object result) {
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    private static byte getByteResult(Object result) {
        if (result instanceof Number) {
            return ((Number)result).byteValue();
        }
        return 0;
    }

    private static char getCharacterResult(Object result) {
        if (result instanceof Character) {
            return ((Character)result).charValue();
        }
        Character empty = new Character('\u0000');
        return empty.charValue();
    }

    private static short getShortResult(Object result) {
        if (result instanceof Number) {
            return ((Number)result).shortValue();
        }
        return 0;
    }

    private static int getIntegerResult(Object result) {
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return 0;
    }

    private static long getLongResult(Object result) {
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        return 0L;
    }

    private static float getFloatResult(Object result) {
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        return 0.0f;
    }

    private static double getDoubleResult(Object result) {
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return 0.0;
    }

    private static void checkPackageAccess(Class clazz) {
        String pkg = clazz.getName();
        int i = pkg.lastIndexOf(46);
        if (i != -1) {
            pkg = pkg.substring(0, i);
            System.getSecurityManager().checkPackageAccess(pkg);
        }
    }

    public static class SetField
    implements Runnable {
        private boolean didRun = false;
        private Field field = null;
        private Object object = null;
        private Object value = null;

        private static SetField createNew(Field field, Object object, Object value) {
            return new SetField(field, object, value);
        }

        private SetField(Field field, Object object, Object value) {
            this.field = field;
            this.object = object;
            this.value = value;
        }

        public void run() {
            try {
                if (this.object instanceof Class) {
                    CSecureEnv.checkPackageAccess((Class)this.object);
                }
                CSecureEnv.checkPackageAccess(this.field.getDeclaringClass());
                this.field.set(this.object, this.value);
                this.didRun = true;
            }
            catch (Exception e) {
                System.err.println("Exception in LiveConnect setting field \"" + this.field + "\"");
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }

        private boolean didRun() {
            return this.didRun;
        }
    }

    public static class GetField
    implements Runnable {
        private boolean didRun = false;
        private Field field = null;
        private Object object = null;
        private Object result = null;

        private static GetField createNew(Field field, Object object) {
            return new GetField(field, object);
        }

        private GetField(Field field, Object object) {
            this.field = field;
            this.object = object;
        }

        public void run() {
            try {
                if (this.object instanceof Class) {
                    CSecureEnv.checkPackageAccess((Class)this.object);
                }
                CSecureEnv.checkPackageAccess(this.field.getDeclaringClass());
                this.result = this.field.get(this.object);
                this.didRun = true;
            }
            catch (Exception e) {
                System.err.println("Exception in LiveConnect getting field \"" + this.field + "\"");
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }

        private boolean didRun() {
            return this.didRun;
        }

        private Object getObjectResult() {
            return this.result;
        }

        private boolean getBooleanResult() {
            return CSecureEnv.getBooleanResult(this.result);
        }

        private byte getByteResult() {
            return CSecureEnv.getByteResult(this.result);
        }

        private char getCharacterResult() {
            return CSecureEnv.getCharacterResult(this.result);
        }

        private short getShortResult() {
            return CSecureEnv.getShortResult(this.result);
        }

        private int getIntegerResult() {
            return CSecureEnv.getIntegerResult(this.result);
        }

        private long getLongResult() {
            return CSecureEnv.getLongResult(this.result);
        }

        private float getFloatResult() {
            return CSecureEnv.getFloatResult(this.result);
        }

        private double getDoubleResult() {
            return CSecureEnv.getDoubleResult(this.result);
        }
    }

    public static class Invoke
    implements Runnable {
        private boolean didRun = false;
        private AccessibleObject method = null;
        private Object object = null;
        private Object[] args = null;
        private Object result = null;
        private int pluginInstance = 0;

        private static Invoke createNew(AccessibleObject method, Object object, Object[] args, int pluginInstance) {
            return new Invoke(method, object, args, pluginInstance);
        }

        private Invoke(AccessibleObject method, Object object, Object[] args, int pluginInstance) {
            this.method = method;
            this.object = object;
            this.args = args;
            this.pluginInstance = pluginInstance;
            if (method instanceof Method) {
                Method m = (Method)method;
                Object[] a = args;
                while (m.getDeclaringClass().equals(class$java$lang$reflect$Method == null ? CSecureEnv.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method) && m.getName().equals("invoke") && a.length > 1 && a[0] instanceof Method && a[1] instanceof Object[]) {
                    m = (Method)a[0];
                    a = (Object[])a[1];
                }
                method = m;
                args = a;
            }
        }

        public void run() {
            try {
                if (this.pluginInstance != 0) {
                    JNIUtils.PushLCInfo(this.pluginInstance);
                }
                if (this.method instanceof Method) {
                    if (this.object instanceof Class) {
                        CSecureEnv.checkPackageAccess((Class)this.object);
                    }
                    CSecureEnv.checkPackageAccess(((Method)this.method).getDeclaringClass());
                    this.result = ((Method)this.method).invoke(this.object, this.args);
                } else if (this.method instanceof Constructor) {
                    CSecureEnv.checkPackageAccess(((Constructor)this.method).getDeclaringClass());
                    this.result = ((Constructor)this.method).newInstance(this.args);
                }
                if (this.pluginInstance != 0) {
                    JNIUtils.PopLCInfo();
                }
                this.didRun = true;
            }
            catch (Exception e) {
                if (this.pluginInstance != 0) {
                    JNIUtils.PopLCInfo();
                }
                System.err.println("Exception in LiveConnect invoking method \"" + this.method + "\"");
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }

        private boolean didRun() {
            return this.didRun;
        }

        private Object getObjectResult() {
            return this.result;
        }

        private boolean getBooleanResult() {
            return CSecureEnv.getBooleanResult(this.result);
        }

        private byte getByteResult() {
            return CSecureEnv.getByteResult(this.result);
        }

        private char getCharacterResult() {
            return CSecureEnv.getCharacterResult(this.result);
        }

        private short getShortResult() {
            return CSecureEnv.getShortResult(this.result);
        }

        private int getIntegerResult() {
            return CSecureEnv.getIntegerResult(this.result);
        }

        private long getLongResult() {
            return CSecureEnv.getLongResult(this.result);
        }

        private float getFloatResult() {
            return CSecureEnv.getFloatResult(this.result);
        }

        private double getDoubleResult() {
            return CSecureEnv.getDoubleResult(this.result);
        }
    }
}

