namespace QtSamples {

	using Qt;
	using System;

	public class Display : QMainWindow {

		private TextArea textarea;
		private QScrollView scrollview;
		private QMenuBar menubar;
		private QPopupMenu filemenu, aboutmenu;

		private class TextArea : QTextEdit {

			public TextArea (QWidget parent) : base (parent)
			{
				QFile file = new QFile ("display.cs");
				if ( file.Open(1) ) {
					QTextStream ts = new QTextStream (file);
					this.SetText (ts.Read ());
					this.SetTabStopWidth (30);
				}
			}
		}

		public Display ()
		{
			filemenu = new QPopupMenu (null, "filemenu");
			filemenu.InsertItem	("&Quit", qApp, SLOT ("quit()"));

			aboutmenu = new QPopupMenu(null, "aboutmenu");
			aboutmenu.InsertItem("&About Qt-Sharp", this, SLOT("slotAbout()"));

			menubar = new QMenuBar(this, "");
			menubar.InsertItem("&File", filemenu);
			menubar.InsertItem("&About", aboutmenu);

			textarea = new TextArea (this);
			textarea.SetGeometry(0, menubar.Height(), Width(), Height() - menubar.Height());
			this.SetCentralWidget (textarea);
		}

		public void slotAbout ()
		{
			QMessageBox.Information (
				this, "About Qt-Sharp-0.7",
					  "A Qt (http://www.trolltech.com) to C# language binding.\n" +
					  "Qt-Sharp is compatible with Mono (http://go-mono.org) and\n" +
					  "Portable.NET (http://www.southern-storm.com.au/portable_net.html)\n" +
					  "(c) 2002 Adam Treat. Licensed under the terms of the GNU GPL.\n"
				);
		}

		public static void Main (String[] args)
		{
			QApplication app = new QApplication (args);
			Display demo = new Display ();
			demo.SetCaption ("Qt-Sharp-0.7!");
			app.SetMainWidget (demo);
			demo.Show ();
			app.Exec ();
			return;
		}
	}
}
