/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class RealSnow
extends Applet
implements Runnable {
    private Thread animThread;
    private Graphics buffG;
    private Image buff;
    private Image bgimage;
    private Dimension dim;
    private boolean running;
    private int delay = 40;
    private Wind[] winds;
    private Snow[] flakes;
    private int numberOfFlakes = 500;
    private int numberOfWinds = 0;
    private int nsbug;

    public void destroy() {
        System.out.println("Destroy called, bye bye");
        this.running = false;
        this.animThread = null;
    }

    private void dodgeFlakes() {
        int n = 0;
        while (n < this.getNumberOfWinds()) {
            Wind wind = this.winds[n];
            int n2 = 0;
            while (n2 < this.getNumberOfFlakes()) {
                if (this.flakes[n2].getDepth() == wind.getDepth() && this.flakes[n2].isAlive() && wind.isAlive() && wind.getXco() < this.flakes[n2].getXco() && wind.getXco() + wind.getWidth() > this.flakes[n2].getXco() && wind.getYco() < this.flakes[n2].getYco() && wind.getYco() + wind.getHeight() > this.flakes[n2].getYco()) {
                    this.flakes[n2].dodge(wind.getSign() * wind.getStrength());
                }
                ++n2;
            }
            ++n;
        }
    }

    private int getNumberOfFlakes() {
        return this.numberOfFlakes;
    }

    private int getNumberOfWinds() {
        return this.numberOfWinds;
    }

    public void init() {
        this.setBackground(Color.black);
        this.dim = this.getSize();
        this.buff = this.createImage(this.dim.width, this.dim.height);
        this.buffG = this.buff.getGraphics();
        String string = this.getParameter("Background");
        this.numberOfFlakes = Integer.parseInt(this.getParameter("NumberOfFlakes"));
        this.numberOfWinds = Integer.parseInt(this.getParameter("Turbulence"));
        this.bgimage = this.getImage(this.getDocumentBase(), string);
        this.initWind();
        this.initSnow();
        System.out.println("Starting life and struggling to survive");
    }

    private void initSnow() {
        this.flakes = new Snow[this.getNumberOfFlakes()];
        int n = 0;
        while (n < this.getNumberOfFlakes()) {
            this.flakes[n] = new Snow(this.dim.width, this.dim.height);
            ++n;
        }
    }

    private void initWind() {
        this.winds = new Wind[this.getNumberOfWinds()];
        int n = 0;
        while (n < this.getNumberOfWinds()) {
            this.winds[n] = new Wind(this.dim.width, this.dim.height);
            ++n;
        }
    }

    private void makeFlakes() {
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < this.getNumberOfFlakes()) {
                if (!this.flakes[n2].isAlive()) {
                    this.flakes[n2].newFlake();
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void makeWind() {
        int n = 0;
        while (n < this.getNumberOfWinds()) {
            if (!this.winds[n].isAlive()) {
                this.winds[n].newWind();
            } else {
                this.winds[n].move();
            }
            ++n;
        }
    }

    private void moveSnowFlakes() {
        int n = 0;
        while (n < this.getNumberOfFlakes()) {
            this.flakes[n].move();
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        this.buffG.setColor(Color.black);
        this.buffG.fillRect(0, 0, this.dim.width, this.dim.height);
        this.buffG.drawImage(this.bgimage, 0, 0, this);
        this.buffG.setColor(Color.white);
        int n = 0;
        while (n < this.getNumberOfFlakes()) {
            if (this.flakes[n].isAlive()) {
                this.buffG.drawRect(this.flakes[n].getXco(), this.flakes[n].getYco(), this.flakes[n].getSize(), this.flakes[n].getSize());
            }
            ++n;
        }
        graphics.drawImage(this.buff, 0, 0, this);
    }

    public void run() {
        while (this.running) {
            try {
                ++this.nsbug;
                this.makeFlakes();
                this.makeWind();
                this.dodgeFlakes();
                this.moveSnowFlakes();
                this.repaint();
                Thread.sleep(this.delay);
            }
            catch (Exception exception) {
                System.out.println("Thread Mesg: " + exception);
            }
        }
    }

    public void start() {
        System.out.println("Started");
        this.nsbug = 0;
        if (this.animThread == null) {
            this.running = true;
            this.animThread = new Thread(this);
            this.animThread.start();
        }
    }

    public void stop() {
        if (this.nsbug < 30) {
            System.out.println("Early kill by NS, ignoring (" + this.nsbug + ")");
        } else {
            System.out.println("Stop called, ending (" + this.nsbug + ")");
            this.running = false;
            this.animThread = null;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

