/*-
 * customsPError.c --
 *	Print error message based on last call
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsPError.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <string.h>
#include    <sys/time.h>
#include    <stdio.h>
#include    <fcntl.h>
#include    <netdb.h>
#include    <sys/types.h>
#include    <sys/stat.h>
#include    <errno.h>

extern int  errno;

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_PError --
 *	Print error message based on last call.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *  	A message is printed.
 *
 *-----------------------------------------------------------------------
 */
void
Customs_PError(msg)
    char    	  *msg;
{
    fprintf(stderr, "%s: %s\n", msg, Rpc_ErrorMessage(customs_Status));
}

