// simplePageSize.cpp
//
// Part of KVIEWSHELL - A framework for multipage text/gfx viewers
//
// (C) 2002-2004 Stefan Kebekus
// Distributed under the GPL

// Add header files alphabetically

#include <kdebug.h>
#include <qpaintdevice.h>
//#include <kglobal.h>
//#include <klocale.h>
//#include <math.h>
//#include <qstringlist.h>

#include "simplePageSize.h"


double simplePageSize::zoomForHeight(Q_UINT32 height) const
{
  if (!isValid()) {
    kdError(4300) << "simplePageSize::zoomForHeight() called when paper height was invalid" << endl;
    return 0.1;
  }
  return (double)(height)/(QPaintDevice::x11AppDpiX()*(pageHeight/25.4));
}


double simplePageSize::zoomForWidth(Q_UINT32 width) const
{
  if (!isValid()) {
    kdError(4300) << "simplePageSize::zoomForWidth() called when paper width was invalid" << endl;
    return 0.1;
  }
  return (double)(width)/(QPaintDevice::x11AppDpiX()*(pageWidth/25.4));
}
