/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Filter;
import com.amazon.aes.webservices.client.ImageDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeImages
extends BaseCmd {
    private static final String[] EXECUTABLE_BY_DESC = new String[]{"Only AMIs with launch permissions as specified are described. USER may either", "be a user's account id for AMIs owned by you for which the user has explicit", "launch permissions, 'self' for AMIs you have explicit launch permissions for,", "or 'all' for AMIs with public launch permissions."};
    private static final String[] OWNER_DESC = new String[]{"Only AMIs owned by the users specified are described. OWNER may either be a", "user's account id for images owned by that user, 'self' for images owned by", "you, 'amazon' for images owned by Amazon and 'aws-marketplace' for images", "from the AWS Marketplace"};
    private static final String[] ALL_DESC = new String[]{"Describe all AMIs, public, private or owned, that the user has access to."};

    public DescribeImages(String[] args) {
        super("ec2dim", "ec2-describe-images");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"all");
        OptionBuilder.withDescription((String)DescribeImages.joinDescription(ALL_DESC));
        result.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"owner");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeImages.joinDescription(OWNER_DESC));
        OptionBuilder.withArgName((String)"OWNER");
        result.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"executable-by");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeImages.joinDescription(EXECUTABLE_BY_DESC));
        OptionBuilder.withArgName((String)"USER");
        result.addOption(OptionBuilder.create((String)"x"));
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        result.addOption(OptionBuilder.create((String)"F"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "[AMI [...]] [-a] [-o OWNER [...]] [-x USER [...]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe registered AMIs and AMIs you have launch permissions for.");
        System.out.println("     The AMI parameters, if specified, are the AMIs to describe.");
        System.out.println("     The result set of AMIs described are the intersection of the AMIs specified,");
        System.out.println("     AMIs owned by the owners specified and AMIs with launch permissions as specified");
        System.out.println("     by the executable by options.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("all");
        this.printOption("owner");
        this.printOption("executable-by");
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        if (this.isOptionSet("owner") && this.isOptionSet("all")) {
            throw new InvalidArgumentCombination("Owners may not be specified with the --all (-a) flag.");
        }
        if (this.isOptionSet("executable-by") && this.isOptionSet("all")) {
            throw new InvalidArgumentCombination("Executable by options may not be specified with the --all (-a) flag.");
        }
        ArrayList<String> imageIds = new ArrayList<String>(Arrays.asList(this.getNonOptions()));
        ArrayList<String> owners = new ArrayList<String>(Arrays.asList(this.getOptionValues("owner")));
        ArrayList<String> executableBy = new ArrayList<String>(Arrays.asList(this.getOptionValues("executable-by")));
        if (imageIds.size() > 0 && this.isOptionSet("all")) {
            throw new InvalidArgumentCombination("AMIs may not be specified with the --all (-a) flag.");
        }
        List<Filter> filters = this.getFilters(true);
        TreeSet<ImageDescription> imagesSet = new TreeSet<ImageDescription>(new AmiComparator());
        if (!(imageIds.size() != 0 || this.isOptionSet("owner") || this.isOptionSet("executable-by") || this.isOptionSet("all"))) {
            owners.add("self");
            executableBy.add("self");
            rsp = jec2.describeImages(new ArrayList(), owners, new ArrayList(), filters);
            imagesSet.addAll((Collection)rsp.getResponse());
            rsp = jec2.describeImages(new ArrayList(), new ArrayList(), executableBy, filters);
            imagesSet.addAll((Collection)rsp.getResponse());
        } else if (this.isOptionSet("all")) {
            rsp = jec2.describeImages(new ArrayList(), new ArrayList(), new ArrayList(), filters);
            imagesSet.addAll((Collection)rsp.getResponse());
        } else {
            rsp = jec2.describeImages(imageIds, owners, executableBy, filters);
            imagesSet.addAll((Collection)rsp.getResponse());
        }
        for (ImageDescription i : imagesSet) {
            out.output(System.out, i);
        }
        return true;
    }

    public static void main(String[] args) {
        new DescribeImages(args).invoke();
    }

    private class AmiComparator
    implements Comparator<ImageDescription> {
        private AmiComparator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ImageDescription ami1, ImageDescription ami2) {
            int i;
            if (ami1.imageLocation != null) {
                if (ami2.imageLocation == null) return 1;
                i = ami1.imageLocation.compareToIgnoreCase(ami2.imageLocation);
            } else {
                if (ami2.imageLocation != null) {
                    return -1;
                }
                if (ami1.name == null) {
                    if (ami2.name != null) return -1;
                    i = 0;
                } else {
                    if (ami2.name == null) {
                        return 1;
                    }
                    i = ami1.name.compareToIgnoreCase(ami2.name);
                }
            }
            if (i != 0) {
                return i;
            }
            i = ami1.imageOwnerId.compareTo(ami2.imageOwnerId);
            if (i == 0) return ami1.imageId.compareTo(ami2.imageId);
            return i;
        }
    }
}

