/*
 * Decompiled with CFR 0.152.
 */
package ari.ucidy;

import ari.ucidy.DeprecatedUCDWordList;
import ari.ucidy.UCD;
import ari.ucidy.UCDSyntax;
import ari.ucidy.UCDWord;
import ari.ucidy.UCDWordList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Iterator;
import java.util.logging.Logger;

public class UCDParser {
    public static final String UCIDY_VERSION = "1.2";
    protected static final Logger LOGGER = Logger.getLogger(UCDParser.class.getName());
    public static final String FILE_UCD_WORDS = "/ari/ucidy/ucd1p-words.txt";
    public static final String FILE_UCD_DEPRECATED = "/ari/ucidy/ucd1p-deprecated.txt";
    public static final String VERSION_UCD_WORDS = "EN-UCD1+-1.4";
    public static final UCDParser defaultParser = new UCDParser("EN-UCD1+-1.4");
    public final UCDWordList knownWords;
    public final DeprecatedUCDWordList deprecatedWords;
    protected static final int NB_MAX_ERRORS = 10;

    public static void main(String[] args) throws Throwable {
        Iterator<String> advice;
        byte[] buffer = new byte[128];
        System.out.println("---");
        System.out.println(defaultParser.getFullVersion());
        System.out.println("---");
        System.out.print("UCD to parse? ");
        int nbRead = System.in.read(buffer);
        String read = new String(buffer, 0, nbRead);
        UCD ucd = UCDParser.parseUCD(read.trim());
        System.out.println("----------------------------------------------");
        System.out.println("All words valid?        " + ucd.isAllValid());
        System.out.println("All words recognised?   " + ucd.isAllRecognised());
        System.out.println("All words recommended?  " + ucd.isAllRecommended());
        System.out.println("\nUCD fully valid?        " + ucd.isFullyValid());
        if (!ucd.isFullyValid()) {
            System.out.println("\nREASON:");
            Iterator<String> errors = ucd.getErrors();
            while (errors.hasNext()) {
                System.out.println("    - " + errors.next());
            }
            System.out.println("\nCORRECTION SUGGESTION: " + (ucd.getSuggestion() == null ? "none" : ucd.getSuggestion()));
        }
        if ((advice = ucd.getAdvice()).hasNext()) {
            System.out.println("\nADVICE for improvement of your UCD:");
            do {
                System.out.println("    - " + advice.next());
            } while (advice.hasNext());
        }
        System.out.println("----------------------------------------------\n");
    }

    public UCDParser() {
        this.knownWords = new UCDWordList();
        this.deprecatedWords = new DeprecatedUCDWordList(this.knownWords);
    }

    public UCDParser(String wordsListVersion) {
        this.knownWords = new UCDWordList(wordsListVersion);
        this.deprecatedWords = new DeprecatedUCDWordList(this.knownWords);
    }

    public UCDParser(UCDWordList words) {
        this(words, null);
    }

    public UCDParser(UCDWordList words, DeprecatedUCDWordList deprecatedWords) {
        this.knownWords = words == null ? new UCDWordList() : words;
        this.deprecatedWords = deprecatedWords == null ? new DeprecatedUCDWordList(this.knownWords) : deprecatedWords;
    }

    public static final String getVersion() {
        return UCIDY_VERSION;
    }

    public final String getFullVersion() {
        StringBuilder buf = new StringBuilder();
        buf.append("Ucidy version ").append(UCDParser.getVersion());
        buf.append(System.lineSeparator()).append("UCD words version ");
        buf.append(this.knownWords.getVersion() != null ? this.knownWords.getVersion() : "?");
        buf.append(System.lineSeparator()).append("UCD deprecated words version ");
        buf.append(this.deprecatedWords.getVersion() != null ? this.deprecatedWords.getVersion() : "?");
        return buf.toString();
    }

    public UCD parse(String ucdStr) {
        if (ucdStr == null || ucdStr.trim().length() == 0) {
            return null;
        }
        String[] wordsStr = ucdStr.split(";");
        UCDWord[] words = new UCDWord[wordsStr.length];
        for (int i = 0; i < wordsStr.length; ++i) {
            if (wordsStr[i] == null || wordsStr[i].length() == 0) {
                words[i] = null;
                continue;
            }
            words[i] = this.knownWords.get(wordsStr[i].trim(), true);
            if (words[i] == null) {
                words[i] = this.deprecatedWords.get(wordsStr[i].trim(), true);
            }
            if (words[i] == null) {
                words[i] = new UCDWord(wordsStr[i], this.knownWords.getClosest(wordsStr[i]));
                continue;
            }
            if (wordsStr[i].equals(words[i].rawWord)) continue;
            words[i] = new UCDWord(words[i].syntaxCode, wordsStr[i], words[i].description, words[i].recommended);
        }
        return new UCD(words);
    }

    public static UCD parseUCD(String ucdStr) {
        return defaultParser.parse(ucdStr);
    }

    public static UCDWordList parseWordList(Reader reader, boolean recommended) throws NullPointerException, IOException {
        UCDWordList words = new UCDWordList();
        UCDParser.parseWordList(reader, recommended, words);
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int parseWordList(Reader reader, boolean recommended, UCDWordList words) throws NullPointerException, IOException {
        if (reader == null) {
            throw new NullPointerException("Missing reader to parse!");
        }
        int nbAdded = 0;
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(reader);
            int numLine = 1;
            int nbConsecutiveErrors = 0;
            while ((line = input.readLine()) != null) {
                try {
                    if (words.add(UCDParser.parsePSVLine(line, recommended))) {
                        ++nbAdded;
                    } else {
                        LOGGER.warning("[l." + numLine + "] Duplicated, not recognised or not syntactically correct UCD ignored.");
                    }
                    nbConsecutiveErrors = 0;
                }
                catch (ParseException pe) {
                    LOGGER.severe("[l." + numLine + "] Skipped UCD definition! Cause: " + pe.getMessage());
                    nbConsecutiveErrors = (short)(nbConsecutiveErrors + 1);
                    if (nbConsecutiveErrors > 10) {
                        throw new IOException("Parsing stopped before the end! Cause: More than 10 consecutive incorrect UCD definitions detected.");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++numLine;
            }
            int n = nbAdded;
            return n;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static DeprecatedUCDWordList parseDeprecatedWordList(Reader reader, UCDWordList lstWords) throws NullPointerException, IOException {
        DeprecatedUCDWordList lstDeprecatedWords = new DeprecatedUCDWordList(lstWords);
        UCDParser.parseDeprecatedWordList(reader, lstWords, lstDeprecatedWords);
        return lstDeprecatedWords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int parseDeprecatedWordList(Reader reader, UCDWordList lstWords, DeprecatedUCDWordList lstDeprecatedWords) throws NullPointerException, IOException {
        if (reader == null) {
            throw new NullPointerException("Missing reader to parse!");
        }
        int nbAdded = 0;
        BufferedReader input = null;
        UCDParser ucdParser = new UCDParser(lstWords);
        try {
            String line;
            input = new BufferedReader(reader);
            int numLine = 1;
            int nbConsecutiveErrors = 0;
            while ((line = input.readLine()) != null) {
                try {
                    String[] deprecatedEntry = UCDParser.parseDeprecatedFileLine(line);
                    UCDWord duplicatedWord = lstWords.get(deprecatedEntry[0]);
                    if (duplicatedWord != null) {
                        throw new ParseException("The UCD word \"" + deprecatedEntry[0] + "\" can not be declared as deprecated! It is already listed among the recognised UCD words.", 0);
                    }
                    duplicatedWord = lstDeprecatedWords.get(deprecatedEntry[0]);
                    if (duplicatedWord != null && duplicatedWord.isDeprecated()) {
                        if (duplicatedWord.suggestedReplacement.toString().equalsIgnoreCase(deprecatedEntry[1])) {
                            LOGGER.warning("[l." + numLine + "] Duplicated declaration of the deprecated UCD word \"" + deprecatedEntry[0] + "\"! (note: duplicated declarations are ignored)");
                            continue;
                        }
                        throw new ParseException("The UCD word \"" + deprecatedEntry[0] + "\" is already declared as deprecated, but with a different suggestion of UCD replacement: \"" + deprecatedEntry[1] + "\" (new suggestion) instead of \"" + duplicatedWord.suggestedReplacement + "\" (know suggestion).", 0);
                    }
                    UCD suggestedUCD = ucdParser.parse(deprecatedEntry[1]);
                    if (suggestedUCD == null) {
                        throw new ParseException("Can not parse the suggested UCD replacement as a UCD: \"" + deprecatedEntry[1] + "\"!", 0);
                    }
                    if (!suggestedUCD.isAllRecognised()) {
                        throw new ParseException("Incorrect suggested UCD extract: \"" + deprecatedEntry[1] + "\"! One of its words is not recognised.", 0);
                    }
                    UCDWord deprecatedWord = new UCDWord(deprecatedEntry[0], suggestedUCD, null, null);
                    if (!deprecatedWord.valid) {
                        throw new ParseException("Incorrect syntax for the deprecated UCD word: \"" + deprecatedEntry[0] + "\"!", 0);
                    }
                    if (lstDeprecatedWords.add(deprecatedWord)) {
                        ++nbAdded;
                    } else {
                        LOGGER.warning("[l." + numLine + "] Duplicated, not recognised or not syntactically correct UCD ignored.");
                    }
                    nbConsecutiveErrors = 0;
                }
                catch (ParseException pe) {
                    LOGGER.severe("[l." + numLine + "] Skipped deprecated UCD declaration! Cause: " + pe.getMessage());
                    nbConsecutiveErrors = (short)(nbConsecutiveErrors + 1);
                    if (nbConsecutiveErrors > 10) {
                        throw new IOException("Parsing stopped before the end! Cause: More than 10 consecutive incorrect deprecated UCD declarations detected.");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++numLine;
            }
            int n = nbAdded;
            return n;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static UCDWord parsePSVLine(String psvLine, boolean recommended) throws NullPointerException, ParseException {
        if (psvLine == null || psvLine.trim().length() == 0) {
            throw new NullPointerException("No PSV file line to parse!");
        }
        UCDSyntax syntax = null;
        String word = null;
        String description = null;
        int start = 0;
        int indPipe = psvLine.indexOf(124);
        if (indPipe < 0) {
            throw new ParseException("No valid separator found between the syntax code and the UCD word!", start);
        }
        String tmp = psvLine.substring(0, indPipe).trim();
        if (indPipe == 0 || tmp.length() > 1) {
            throw new ParseException("Unknown syntax code: \"" + tmp + "\"! It should be EXACTLY one character among: " + UCDSyntax.allowedSyntaxCodes + ".", 0);
        }
        syntax = UCDSyntax.get(tmp.charAt(0));
        if (syntax == null) {
            throw new ParseException("Unknown syntax code: \"" + tmp.charAt(0) + "\"! It should be a character among: " + UCDSyntax.allowedSyntaxCodes + ".", 0);
        }
        start = indPipe + 1;
        if ((indPipe = psvLine.indexOf(124, start)) < 0) {
            throw new ParseException("No valid separator found between the UCD word and its description!", start);
        }
        word = psvLine.substring(start, indPipe).trim();
        description = psvLine.substring(indPipe + 1).trim();
        if (description.length() == 0) {
            description = null;
        }
        return new UCDWord(syntax, word, description, recommended);
    }

    public static String[] parseDeprecatedFileLine(String line) throws NullPointerException, ParseException {
        if (line == null || line.trim().length() == 0) {
            throw new NullPointerException("No line to parse!");
        }
        if ((line = line.trim().replaceAll("[ \t]+", " ")).charAt(0) == '#') {
            throw new NullPointerException("No UCD word or UCD can be fetched from a comment line!");
        }
        String[] parseResult = line.split(" ");
        if (parseResult.length < 2) {
            throw new ParseException("Incorrect syntax for a deprecated entry line! It must be 2 values separated by a space, but no space character has been found.", 0);
        }
        if (parseResult.length > 2) {
            throw new ParseException("Incorrect syntax for a deprecated entry line! It must be 2 values separated by a space, but more space separated values have been found.", 0);
        }
        return parseResult;
    }

    static {
        try {
            UCDParser.defaultParser.knownWords.addAll(UCDWordList.class.getResourceAsStream(FILE_UCD_WORDS), true);
        }
        catch (NullPointerException npe) {
            LOGGER.severe("Impossible to import the official IVOA UCDs inside the default UCD parser! Cause: the UCD words list can not be found.");
        }
        catch (IOException ioe) {
            LOGGER.severe("Impossible to import the official IVOA UCDs inside the default UCD parser! Cause: " + ioe.getMessage());
        }
        try {
            UCDParser.defaultParser.deprecatedWords.addAll(UCDWordList.class.getResourceAsStream(FILE_UCD_DEPRECATED), true);
        }
        catch (NullPointerException npe) {
            LOGGER.severe("Impossible to import the deprecated UCDs inside the default UCD parser! Cause: the UCD words list can not be found.");
        }
        catch (IOException ioe) {
            LOGGER.severe("Impossible to import the deprecated UCDs inside the default UCD parser! Cause: " + ioe.getMessage());
        }
    }
}

