# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.avs import AVSClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-avs
# USAGE
    python private_clouds_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AVSClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.private_clouds.begin_create_or_update(
        resource_group_name="group1",
        private_cloud_name="cloud1",
        private_cloud={
            "identity": {"type": "SystemAssigned"},
            "location": "eastus2",
            "properties": {
                "managementCluster": {"clusterSize": 4},
                "networkBlock": "192.168.48.0/22",
                "vcfLicense": {
                    "broadcomContractNumber": "123456",
                    "broadcomSiteId": "123456",
                    "cores": 16,
                    "endDate": "2025-12-31T23:59:59Z",
                    "kind": "vcf5",
                    "licenseKey": "12345-12345-12345-12345-12345",
                },
            },
            "sku": {"name": "AV36"},
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-09-01/PrivateClouds_CreateOrUpdate.json
if __name__ == "__main__":
    main()
